
//-------------------------------------------------------------------------------------------------
// Structure of this file:
//-------------------------------------------------------------------------------------------------
//		Configuration
//    Up-/Download List
//		BLOCK
//    VARIABLE (Standard Parameter)
//    VARIABLE (DO Parameter)
//    COMMAND (Standard Parameter)
//    COMMAND (DO Parameter)
//		COLLECTION
//		MENU
//    MENU (Alarm)
//    MENU (Diagnosis)
//    MENU (Simulation)
//    MENU (Parameter Table)

//-------------------------------------------------------------------------------------------------
//    Configuration
//-------------------------------------------------------------------------------------------------

#ifndef FUNC4_DO_TITLE
    #define FUNC4_DO_TITLE [func4_DO]
#endif


//-------------------------------------------------------------------------------------------------
//    Up-/Download List
//-------------------------------------------------------------------------------------------------

#define FUNC4_DO_LOAD_TO_DEVICE										\
                func4_DO_tag_desc,	  								\
                func4_DO_batch_id,									\
                func4_DO_batch_unit,								\
                func4_DO_batch_operation,							\
                func4_DO_batch_phase,								\
                func4_DO_invert,									\
                func4_DO_fsafe_time,								\
                func4_DO_FSafeType,									\
                func4_DO_FSafeValue

#define FUNC4_DO_LOAD_TO_PC											\
                FUNC4_DO_LOAD_TO_DEVICE								\
                func4_DO_st_rev


//-------------------------------------------------------------------------------------------------
//    BLOCK
//-------------------------------------------------------------------------------------------------

BLOCK func4_DO_block
{
    TYPE		FUNCTION;
    NUMBER	FUNC4_DO_BLOCKNUMBER;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 00 : BLOCK_OBJECT ------------------------------------------------------------------------

func4_DO_blk_reserve  				LIKE VARIABLE	phys_blk_reserve
{
}


func4_DO_blk_object	  				LIKE VARIABLE	phys_blk_object
{
    REDEFINE	TYPE	ENUMERATED(1)
    {
        DEFAULT_VALUE    2;
        {	2,	[blk_block_object_FUNCTION]	}
    }
}


func4_DO_blk_parent_class	  		LIKE VARIABLE	phys_blk_parent_class
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {	2,	[func_blk_parent_class_OUTPUT]	}
    }
}


func4_DO_blk_class	  				LIKE VARIABLE	phys_blk_class
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {	2,	[func_blk_class_DO]	}
    }
}


func4_DO_blk_dd_reference	  		LIKE VARIABLE	phys_blk_dd_reference
{
}


func4_DO_blk_dd_rev			  		LIKE VARIABLE	phys_blk_dd_rev
{
}


func4_DO_blk_profile  				LIKE VARIABLE	phys_blk_profile
{
}


func4_DO_blk_profile_rev	  		LIKE VARIABLE	phys_blk_profile_rev
{
}


func4_DO_blk_execution_time	  	LIKE VARIABLE	phys_blk_execution_time
{
}


func4_DO_blk_num_parameters	  	LIKE VARIABLE	phys_blk_num_parameters
{
}


func4_DO_blk_index_view	  			LIKE VARIABLE	phys_blk_index_view_1
{
}


func4_DO_blk_num_view_lists	  	LIKE VARIABLE	phys_blk_num_view_lists
{
}


//--- DO 01 : ST_REV ------------------------------------------------------------------------------

func4_DO_st_rev		  				LIKE VARIABLE	phys_st_rev
{
}


//--- DO 02 : TAG_DESC ----------------------------------------------------------------------------

func4_DO_tag_desc	  					LIKE VARIABLE	phys_tag_desc
{
}


//--- DO 03 : STRATEGY ----------------------------------------------------------------------------

func4_DO_strategy	  					LIKE VARIABLE	phys_strategy
{
}


//--- DO 04 : ALERT_KEY ---------------------------------------------------------------------------

func4_DO_alert_key	  				LIKE VARIABLE	phys_alert_key
{
}


//--- DO 05 : TARGET_MODE -------------------------------------------------------------------------

func4_DO_target_mode  				LIKE VARIABLE	phys_target_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
}


//--- DO 06 : MODE_BLK ----------------------------------------------------------------------------

func4_DO_actual_mode  				LIKE VARIABLE	phys_actual_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	BLOCK_MODE_AUTO,			 	[mode_AUTO]					},
        {	BLOCK_MODE_MAN,				[mode_MAN]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,	[mode_OUT_OF_SERVICE]	}
    }
    REDEFINE POST_READ_ACTIONS
    {
        method_func4_DO_set_global_simulation
    }
}


func4_DO_permitted_mode  			LIKE VARIABLE	phys_permitted_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	0xB8;
        {	BLOCK_MODE_AUTO,			 	[mode_AUTO]					},
        {	BLOCK_MODE_MAN,				[mode_MAN]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,	[mode_OUT_OF_SERVICE]	}
    }
}


func4_DO_normal_mode  				LIKE VARIABLE	phys_normal_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	BLOCK_MODE_AUTO,			 	[mode_AUTO]					}
    }
}


//--- DO 07 : ALARM_SUM ---------------------------------------------------------------------------

func4_DO_current_state_alarm_sum  				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


func4_DO_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


func4_DO_unreported_state_alarm_sum  			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


func4_DO_disabled_state_alarm_sum  				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


//--- DO 08 : BATCH -------------------------------------------------------------------------------

VARIABLE func4_DO_batch_id
{
    LABEL		[func_batch_id];
    HELP		[func_batch_id_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func4_DO_batch_unit
{
    LABEL		[func_batch_unit];
    HELP		[func_batch_unit_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func4_DO_batch_operation
{
    LABEL		[func_batch_operation];
    HELP		[func_batch_operation_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func4_DO_batch_phase
{
    LABEL		[func_batch_phase];
    HELP		[func_batch_phase_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 09 : SP_D --------------------------------------------------------------------------------

// VARIABLE func4_DO_sp_d_value : extern

VARIABLE func4_DO_sp_d_status_quality
{
    LABEL		[status_quality];
    HELP		[value_status_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        STATUS_QUALITY_CODES
    }
    HANDLING	READ & WRITE;
}


func4_DO_sp_d_status_limit					LIKE VARIABLE	func4_DO_sp_d_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_LIMITS_DISCRETE
    }
}


//--- DO 10 : OUT_D -------------------------------------------------------------------------------

// VARIABLE func4_DO_out_d_value : extern

func4_DO_out_d_status_quality	  			LIKE VARIABLE	func4_DO_sp_d_status_quality
{
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        FUNC_DO_OUT_D_STATUS_QUALITY_CODES
    }
    REDEFINE HANDLING
        IF (func4_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


func4_DO_out_d_status_limit  				LIKE VARIABLE	func4_DO_out_d_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_LIMITS_DISCRETE
    }
    REDEFINE HANDLING
        IF (func4_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

// VARIABLE func4_DO_readback_d_value : extern

func4_DO_readback_d_status_quality  	LIKE VARIABLE	func4_DO_out_d_status_quality
{
    REDEFINE HANDLING READ;
}


func4_DO_readback_d_status_limit  		LIKE VARIABLE	func4_DO_readback_d_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_LIMITS_DISCRETE
    }
}


//--- DO 17 : CHANNEL -----------------------------------------------------------------------------

VARIABLE func4_DO_channel
{
    LABEL		[func_channel];
    HELP		[func_channel_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (2)
    {
        DEFAULT_VALUE			0x0000;
        { 0x0000,	"not used"	}
    }
    HANDLING	READ & WRITE;
}


//--- DO 18 : INVERT ------------------------------------------------------------------------------

VARIABLE func4_DO_invert
{
    LABEL		[func_do_invert];
    HELP		[func_do_invert_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[off]			},
        {	1,	[on]			}
    }
    HANDLING	READ & WRITE;
}


//--- DO 19 : FSAFE_TIME --------------------------------------------------------------------------

VARIABLE func4_DO_fsafe_time
{
    LABEL		[func_ao_fsafe_time];
    HELP		[func_ao_fsafe_time_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
        MAX_VALUE		6000.0;
    }
    CONSTANT_UNIT	[sec];
    HANDLING	READ & WRITE;
}


//--- DO 20 : FSAFE_TYPE --------------------------------------------------------------------------

VARIABLE func4_DO_FSafeType
{
    LABEL		[func_ao_fsafe_type];
    HELP		[func_ao_fsafe_type_help_PROFILE_3];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    FUNC_AI_STORING_LAST_SETPOINT;
        { FUNC_AI_FAIL_SAFE_VALUE,			[func_ai_fsafe_type_FAIL_SAFE_VALUE]			},
        { FUNC_AI_STORING_LAST_SETPOINT,	[func_ai_fsafe_type_STORING_LAST_SETPOINT]	}
    }
    HANDLING	READ & WRITE;
}


//--- DO 21 : FSAFE_VAL_D -------------------------------------------------------------------------

// VARIABLE func4_DO_FSafeValue : extern


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

// VARIABLE func4_DO_simulate_value : extern


VARIABLE func4_DO_simulate_status_quality
{
    LABEL		[status_quality];
    HELP		[func_simulate_status_help];
    CLASS		CONTAINED & SERVICE;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x20;
        STATUS_INPUT_NO_RCAS
    }
    HANDLING	READ & WRITE;
}


func4_DO_simulate_status_limit				LIKE VARIABLE	func4_DO_simulate_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x00;
        STATUS_INPUT_LIMIT(func4_DO_simulate_status_quality)
    }
}


VARIABLE func4_DO_simulation_enabled
{
    LABEL		[func_simulation_enabled];
    HELP		[func_simulation_enabled_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[disabled]		},
        {	1,	[enabled]		}
    }
    HANDLING READ & WRITE;
    POST_READ_ACTIONS
    {
        method_func4_DO_set_global_simulation
    }
}


#define CB_FAIL_SAFE			0x00010000		/* Bit  0 */
#define CB_REQ_LOC_OP		0x00020000		/* Bit  1 */
#define CB_LOCAL_OP			0x00040000		/* Bit  2 */
#define CB_OVERRIDE			0x00080000		/* Bit  3 */
#define CB_DISC_DIR			0x00100000		/* Bit  4 */
#define CB_TORQUE_D_OP		0x00200000		/* Bit  5 */
#define CB_TORQUE_D_CL		0x00400000		/* Bit  6 */
#define CB_TRAV_TIME			0x00800000		/* Bit  7 */
#define CB_ACT_OPEN			0x00000100		/* Bit  8 */
#define CB_ACT_CLOSE			0x00000200		/* Bit  9 */
#define CB_UPDATE_EVT		0x00000400		/* Bit 10 */
#define CB_SIMULATE			0x00000800		/* Bit 11 */
#define CB_DISTURBANCE		0x00001000		/* Bit 12 */
#define CB_CONTR_ERR			0x00002000		/* Bit 13 */
#define CB_CONTR_INACT		0x00004000		/* Bit 14 */
#define CB_SELFTEST			0x00008000		/* Bit 15 */
#define CB_TOT_VALVE_TRAV	0x00000001		/* Bit 16 */


//--- DO 33 : CHECK_BACK --------------------------------------------------------------------------

VARIABLE func4_DO_check_back
{
    LABEL		[func_check_back];
    HELP		[func_check_back_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		BIT_ENUMERATED (3)
    {
        {	0,							[dia_OK],				[dia_OK_help]					},
        {	CB_FAIL_SAFE,			[cb_FAIL_SAFE],		[cb_FAIL_SAFE_help]			},
        {	CB_REQ_LOC_OP,			[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]			},
        {	CB_LOCAL_OP,			[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
        {	CB_OVERRIDE,			[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
        {	CB_DISC_DIR,			[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
        {	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
        {	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
        {	CB_TRAV_TIME,			[cb_TRAV_TIME],		[cb_TRAV_TIME_help]			},
        {	CB_ACT_OPEN,			[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
        {	CB_ACT_CLOSE,			[cb_ACT_CLOSE],		[cb_ACT_CLOSE_help]			},
        {	CB_UPDATE_EVT,			[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]			},
        {	CB_SIMULATE,			[cb_SIMULATE],			[cb_SIMULATE_help]			},
        {	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
        {	CB_CONTR_ERR,			[cb_CONTR_ERR],		[cb_CONTR_ERR_help]			},
        {	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
        {	CB_SELFTEST,			[cb_SELFTEST],			[cb_SELFTEST_help]			},
        {	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
    }
    HANDLING	READ;
}


//--- DO 34 : CHECK_BACK_MASK ---------------------------------------------------------------------

VARIABLE func4_DO_check_back_mask
{
    LABEL		[func_check_back_mask];
    HELP		[func_check_back_mask_help];
    CLASS		CONTAINED;
    TYPE		BIT_ENUMERATED (3)
    {
        {	CB_FAIL_SAFE,			[cb_FAIL_SAFE],		[cb_FAIL_SAFE_help]			},
        {	CB_REQ_LOC_OP,			[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]			},
        {	CB_LOCAL_OP,			[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
        {	CB_OVERRIDE,			[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
        {	CB_DISC_DIR,			[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
        {	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
        {	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
        {	CB_TRAV_TIME,			[cb_TRAV_TIME],		[cb_TRAV_TIME_help]			},
        {	CB_ACT_OPEN,			[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
        {	CB_ACT_CLOSE,			[cb_ACT_CLOSE],		[cb_ACT_CLOSE_help]			},
        {	CB_UPDATE_EVT,			[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]			},
        {	CB_SIMULATE,			[cb_SIMULATE],			[cb_SIMULATE_help]			},
        {	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
        {	CB_CONTR_ERR,			[cb_CONTR_ERR],		[cb_CONTR_ERR_help]			},
        {	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
        {	CB_SELFTEST,			[cb_SELFTEST],			[cb_SELFTEST_help]			},
        {	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
    }
    HANDLING	READ;
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 00 : BLOCK_OBJECT ------------------------------------------------------------------------

COMMAND read_func4_DO_blk
{
    BLOCK func4_DO_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_blk_reserve,
            func4_DO_blk_object,
            func4_DO_blk_parent_class,
            func4_DO_blk_class,
            func4_DO_blk_dd_reference,
            func4_DO_blk_dd_rev,
            func4_DO_blk_profile,
            func4_DO_blk_profile_rev,
            func4_DO_blk_execution_time,
            func4_DO_blk_num_parameters,
            func4_DO_blk_index_view,
            func4_DO_blk_num_view_lists
        }
    }
}


//--- DO 01 : ST_REV ------------------------------------------------------------------------------

COMMAND read_func4_DO_st_rev
{
    BLOCK func4_DO_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_st_rev
        }
    }
}


//--- DO 02 : TAG_DESC ----------------------------------------------------------------------------

COMMAND read_func4_DO_tag_desc
{
    BLOCK func4_DO_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_tag_desc
        }
    }
}


COMMAND write_func4_DO_tag_desc
{
    BLOCK func4_DO_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_tag_desc
        }
        REPLY
        {
        }
    }
}


//--- DO 03 : STRATEGY ----------------------------------------------------------------------------

COMMAND read_func4_DO_strategy
{
    BLOCK func4_DO_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_strategy
        }
    }
}


COMMAND write_func4_DO_strategy
{
    BLOCK func4_DO_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_strategy
        }
        REPLY
        {
        }
    }
}


//--- DO 04 : ALERT_KEY ---------------------------------------------------------------------------

COMMAND read_func4_DO_alert_key
{
    BLOCK func4_DO_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_alert_key
        }
    }
}


COMMAND write_func4_DO_alert_key
{
    BLOCK func4_DO_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_alert_key
        }
        REPLY
        {
        }
    }
}


//--- DO 05 : TARGET_MODE -------------------------------------------------------------------------

COMMAND read_func4_DO_target_mode
{
    BLOCK func4_DO_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_target_mode
        }
    }
}


COMMAND write_func4_DO_target_mode
{
    BLOCK func4_DO_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_target_mode
        }
        REPLY
        {
        }
    }
}


//--- DO 06 : MODE_BLK ----------------------------------------------------------------------------

COMMAND read_func4_DO_mode
{
    BLOCK func4_DO_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func4_DO_actual_mode,
             func4_DO_permitted_mode,
             func4_DO_normal_mode
        }
    }
}


//--- DO 07 : ALARM_SUM ---------------------------------------------------------------------------

COMMAND read_func4_DO_alarm
{
    BLOCK func4_DO_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_current_state_alarm_sum,
            func4_DO_unacknowledged_state_alarm_sum,
            func4_DO_unreported_state_alarm_sum,
            func4_DO_disabled_state_alarm_sum
        }
    }
}


//--- DO 08 : BATCH -------------------------------------------------------------------------------

COMMAND read_func4_DO_batch_information
{
    BLOCK func4_DO_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_batch_id,
            func4_DO_batch_unit,
            func4_DO_batch_operation,
            func4_DO_batch_phase
        }
    }
}


COMMAND write_func4_DO_batch_information
{
    BLOCK func4_DO_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_batch_id,
            func4_DO_batch_unit,
            func4_DO_batch_operation,
            func4_DO_batch_phase
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 09 : SP_D --------------------------------------------------------------------------------

COMMAND read_func4_DO_sp_d
{
    BLOCK func4_DO_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_sp_d_value,
            func4_DO_sp_d_status_quality	<0xFC>,
            func4_DO_sp_d_status_limit		<0x03>
        }
    }
}


COMMAND write_func4_DO_sp_d
{
    BLOCK func4_DO_block;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_sp_d_value,
            func4_DO_sp_d_status_quality	<0xFC>,
            func4_DO_sp_d_status_limit		<0x03>
        }
        REPLY
        {
        }
    }
}


//--- DO 10 : OUT_D -------------------------------------------------------------------------------
// extern

//--- DO 12 : READBACK_D --------------------------------------------------------------------------
// extern

//--- DO 17 : CHANNEL -----------------------------------------------------------------------------

COMMAND read_func4_DO_channel
{
    BLOCK func4_DO_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_channel
        }
    }
}


COMMAND write_func4_DO_channel
{
    BLOCK func4_DO_block;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_channel
        }
        REPLY
        {
        }
    }
}


//--- DO 18 : INVERT ------------------------------------------------------------------------------

COMMAND read_func4_DO_invert
{
    BLOCK func4_DO_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_invert
        }
    }
}


COMMAND write_func4_DO_invert
{
    BLOCK func4_DO_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_invert
        }
        REPLY
        {
        }
    }
}


//--- DO 19 : FSAFE_TIME --------------------------------------------------------------------------

COMMAND read_func4_DO_fsafe_time
{
    BLOCK func4_DO_block;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_fsafe_time
        }
    }
}


COMMAND write_func4_DO_fsafe_time
{
    BLOCK func4_DO_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_fsafe_time
        }
        REPLY
        {
        }
    }
}


//--- DO 20 : FSAFE_TYPE --------------------------------------------------------------------------

COMMAND read_func4_DO_FSafeType
{
    BLOCK func4_DO_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_FSafeType
        }
    }
}


COMMAND write_func4_DO_FSafeType
{
    BLOCK func4_DO_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_FSafeType
        }
        REPLY
        {
        }
    }
}


//--- DO 21 : FSAFE_VAL_D -------------------------------------------------------------------------

COMMAND read_func4_DO_FSafeValue
{
    BLOCK func4_DO_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_FSafeValue
        }
    }
}


COMMAND write_func4_DO_FSafeValue
{
    BLOCK func4_DO_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_FSafeValue
        }
        REPLY
        {
        }
    }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------
// extern


//--- DO 33 : CHECK_BACK --------------------------------------------------------------------------

COMMAND read_func4_DO_check_back
{
    BLOCK func4_DO_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_check_back
        }
    }
}


//--- DO 34 : CHECK_BACK_MASK ---------------------------------------------------------------------

COMMAND read_func4_DO_check_back_mask
{
    BLOCK func4_DO_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_check_back_mask
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    METHOD
//-------------------------------------------------------------------------------------------------

METHOD method_func4_DO_set_global_simulation
{
    LABEL "";
    CLASS		DYNAMIC;
    DEFINITION
    {
        int  simu_ena, man_ena;

        simu_ena	= ivar_value( func4_DO_simulation_enabled );
        man_ena	= ivar_value( func4_DO_actual_mode 			);

        if ( (simu_ena == 1) || (man_ena == 0x10) )
        {
            lokal_global_simulation |= FUNC4_DO_GLOBAL_SIMULATION_MASK;
        }
        else
        {
            lokal_global_simulation &= ~FUNC4_DO_GLOBAL_SIMULATION_MASK;
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    COLLECTION
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

MENU Group_display_func4_DO_simulation
{
    LABEL		[menu_OnlineWindow_func_display_simulation];
    ITEMS
    {
        func4_DO_simulation_enabled 		(READ_ONLY),
        SEPARATOR,
        func4_DO_actual_mode 				(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Alarm)
//-------------------------------------------------------------------------------------------------

MENU OnlineWindow_S_alarm_func4_DO
{
    LABEL		FUNC4_DO_TITLE;
    ITEMS
    {
        Page_alarm_sum_func4_DO,
    }
}


MENU OnlineWindow_M_alarm_func4_DO
{
    LABEL		FUNC4_DO_TITLE;
    ITEMS
    {
        Page_alarm_sum_func4_DO,
    }
}


MENU Page_alarm_sum_func4_DO
{
    LABEL		[menu_dialog_alarm_sum];
    ITEMS
    {
        func4_DO_current_state_alarm_sum,
        func4_DO_unacknowledged_state_alarm_sum,
        SEPARATOR,
        func4_DO_unreported_state_alarm_sum,
        func4_DO_disabled_state_alarm_sum
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Diagnosis)
//-------------------------------------------------------------------------------------------------

MENU Page_diagnosis_func4_DO
{
    LABEL		FUNC4_DO_TITLE+THEME_DO;
    ITEMS
    {
        func4_DO_blk_object,
        func4_DO_blk_parent_class,
        func4_DO_blk_class,
        func4_DO_blk_dd_reference,
        func4_DO_blk_dd_rev,
        func4_DO_blk_profile,
        func4_DO_blk_profile_rev,
        func4_DO_st_rev,
        func4_DO_actual_mode
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU OnlineDialog_simulation_func4_DO
{
    LABEL		FUNC4_DO_TITLE;
    ITEMS
    {
        Page_simulation_output_func4_DO,
        Page_simulation_input_func4_DO
    }
}


MENU Page_simulation_input_func4_DO
{
    LABEL		[menu_dialog_DO_simulation_input];
    ITEMS
    {
        func4_DO_simulation_enabled,
        Group_simulate_input_func4_DO,
        method_set
    }
}


MENU Page_simulation_output_func4_DO
{
    LABEL		[menu_dialog_DO_simulation_output];
    ITEMS
    {
        func4_DO_target_mode,
        func4_DO_actual_mode,
        Group_simulate_output_func4_DO,
        method_set
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Parameter table)
//-------------------------------------------------------------------------------------------------

MENU Tab_s_func4_DO
{
    LABEL		FUNC4_DO_TITLE;
    ITEMS
    {
        func4_DO_st_rev,
        func4_DO_tag_desc,
        Tab_s_func4_DO_batch,
        Tab_s_func4_DO_FSafe
    }
}


MENU Tab_m_func4_DO
{
    LABEL		FUNC4_DO_TITLE;
    ITEMS
    {
        func4_DO_st_rev,
        func4_DO_tag_desc 			(READ_ONLY),
        Tab_s_func4_DO_batch,
        Tab_m_func4_DO_FSafe
    }
}


MENU Tab_s_func4_DO_batch
{
    LABEL		[menu_ident_batch_info];
    ITEMS
    {
            func4_DO_batch_id,
            func4_DO_batch_unit,
            func4_DO_batch_operation,
            func4_DO_batch_phase
    }
}


MENU Tab_s_func4_DO_FSafe
{
    LABEL [menu_fail_safe] ;
    ITEMS
    {
        func4_DO_fsafe_time,
        func4_DO_FSafeType,
        func4_DO_FSafeValue
    }
}


MENU Tab_m_func4_DO_FSafe
{
    LABEL [menu_fail_safe] ;
    ITEMS
    {
        func4_DO_fsafe_time			(READ_ONLY),
        func4_DO_FSafeType			(READ_ONLY),
        func4_DO_FSafeValue			(READ_ONLY)
    }
}

