
//-------------------------------------------------------------------------------------------------
// Structure of this file:
//-------------------------------------------------------------------------------------------------
//		Configuration
//    Up-/Download List
//		BLOCK
//    VARIABLE (Standard Parameter)
//    VARIABLE (DI Parameter)
//    COMMAND (Standard Parameter)
//    COMMAND (DI Parameter)
//		METHOD
//		COLLECTION
//		MENU
//    MENU (Alarm)
//    MENU (Diagnosis)
//    MENU (Simulation)
//    MENU (Parameter Table)


//-------------------------------------------------------------------------------------------------
//    Configuration
//-------------------------------------------------------------------------------------------------

#ifndef FUNC1_DI_TITLE
    #define FUNC1_DI_TITLE [func1_DI]
#endif


//-------------------------------------------------------------------------------------------------
//    Up-/Download List
//-------------------------------------------------------------------------------------------------

#define FUNC1_DI_LOAD_TO_DEVICE										\
                func1_DI_tag_desc,									\
                func1_DI_batch_id,									\
                func1_DI_batch_unit,								\
                func1_DI_batch_operation,							\
                func1_DI_batch_phase,								\
                func1_DI_invert,									\
                func1_DI_fsafe_type,								\
                func1_DI_fsafe_value

#define FUNC1_DI_LOAD_TO_PC											\
                FUNC1_DI_LOAD_TO_DEVICE								\
                func1_DI_st_rev


//-------------------------------------------------------------------------------------------------
//    BLOCK
//-------------------------------------------------------------------------------------------------

BLOCK func1_DI_block
{
    TYPE		FUNCTION;
    NUMBER	FUNC1_DI_BLOCKNUMBER;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 00 : BLOCK_OBJECT ------------------------------------------------------------------------

func1_DI_blk_reserve					LIKE VARIABLE	phys_blk_reserve
{
}


func1_DI_blk_object	  				LIKE VARIABLE	phys_blk_object
{
    REDEFINE	TYPE	ENUMERATED(1)
    {
        DEFAULT_VALUE    2;
        {	2,	[blk_block_object_FUNCTION]	}
    }
}


func1_DI_blk_parent_class	  		LIKE VARIABLE	phys_blk_parent_class
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        {	1,	[func_blk_parent_class_INPUT]	}
    }
}


func1_DI_blk_class	  				LIKE VARIABLE	phys_blk_class
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {	2,	[func_blk_class_DI]	}
    }
}


func1_DI_blk_dd_reference			LIKE VARIABLE	phys_blk_dd_reference
{
}


func1_DI_blk_dd_rev					LIKE VARIABLE	phys_blk_dd_rev
{
}


func1_DI_blk_profile					LIKE VARIABLE	phys_blk_profile
{
}


func1_DI_blk_profile_rev			LIKE VARIABLE	phys_blk_profile_rev
{
}


func1_DI_blk_execution_time		LIKE VARIABLE	phys_blk_execution_time
{
}


func1_DI_blk_num_parameters		LIKE VARIABLE	phys_blk_num_parameters
{
}


func1_DI_blk_index_view_1			LIKE VARIABLE	phys_blk_index_view_1
{
}


func1_DI_blk_num_view_lists		LIKE VARIABLE	phys_blk_num_view_lists
{
}


//--- DI 01 : ST_REV ------------------------------------------------------------------------------

func1_DI_st_rev						LIKE VARIABLE	phys_st_rev
{
}


//--- DI 02 : TAG_DESC ----------------------------------------------------------------------------

func1_DI_tag_desc						LIKE VARIABLE	phys_tag_desc
{
}


//--- DI 03 : STRATEGY ----------------------------------------------------------------------------

func1_DI_strategy						LIKE VARIABLE	phys_strategy
{
}


//--- DI 04 : ALERT_KEY ---------------------------------------------------------------------------

func1_DI_alert_key					LIKE VARIABLE	phys_alert_key
{
}


//--- DI 05 : TARGET_MODE -------------------------------------------------------------------------

func1_DI_target_mode  				LIKE VARIABLE	phys_target_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	BLOCK_MODE_AUTO,				[mode_AUTO]					},
        {	BLOCK_MODE_MAN,				[mode_MAN]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,	[mode_OUT_OF_SERVICE]	}
    }
}


//--- DI 06 : MODE_BLK ----------------------------------------------------------------------------

func1_DI_actual_mode  				LIKE VARIABLE	phys_actual_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
    REDEFINE POST_READ_ACTIONS
    {
        method_func1_DI_set_global_simulation
    }
}


func1_DI_permitted_mode  			LIKE VARIABLE	phys_permitted_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
}


func1_DI_normal_mode  				LIKE VARIABLE	phys_normal_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
}


//--- DI 07 : ALARM_SUM ---------------------------------------------------------------------------

func1_DI_current_state_alarm_sum  				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


func1_DI_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


func1_DI_unreported_state_alarm_sum  			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


func1_DI_disabled_state_alarm_sum  				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]			},
        {	0x0100,	[limit_state_DISCRETE_ALARM]	}
//		{	0x8000,	[limit_state_ST_REV]				}
    }
    REDEFINE STYLE "MULTILINE 12 2" ;
}


//--- DI 08 : BATCH -------------------------------------------------------------------------------

VARIABLE func1_DI_batch_id
{
    LABEL		[func_batch_id];
    HELP		[func_batch_id_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_DI_batch_unit
{
    LABEL		[func_batch_unit];
    HELP		[func_batch_unit_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_DI_batch_operation
{
    LABEL		[func_batch_operation];
    HELP		[func_batch_operation_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_DI_batch_phase
{
    LABEL		[func_batch_phase];
    HELP		[func_batch_phase_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (DI Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

// VARIABLE func1_DI_out_value : extern

VARIABLE func1_DI_out_status_quality
{
    LABEL		[status_quality];
    HELP		[func_out_status_help];
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        IF (func1_DI_target_mode == BLOCK_MODE_MAN)
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE
        {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF (func1_DI_target_mode == BLOCK_MODE_MAN)
        {
            method_set_status_limit_func1_DI
        }
    }
    HANDLING
        IF (func1_DI_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


func1_DI_out_status_limit					LIKE VARIABLE	func1_DI_out_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT(func1_DI_out_status_quality)
    }
}


//--- DI 14 : CHANNEL -----------------------------------------------------------------------------

VARIABLE func1_DI_channel
{
    LABEL		[func_channel];
    HELP		[func_channel_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (2)
    {
#ifdef FUNC1_DI_CHANNEL_LIST
        FUNC1_DI_CHANNEL_LIST
#endif
    }
    HANDLING	READ & WRITE;
}


//--- DI 15 : INVERT ------------------------------------------------------------------------------

VARIABLE func1_DI_invert
{
    LABEL		[func_invert];
    HELP		[func_invert_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[func_invert_NOT_INVERT]	},
        {	1,	[func_invert_INVERT]			}
    }
    HANDLING	READ & WRITE;
}


//--- DI 20 : FSAFE_TYPE --------------------------------------------------------------------------

VARIABLE func1_DI_fsafe_type
{
    LABEL		[func_ao_fsafe_type];
    HELP		[func_ao_fsafe_type_help_PROFILE_3];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    FUNC_AI_STORING_LAST_SETPOINT;
        { FUNC_AI_FAIL_SAFE_VALUE,			[func_ai_fsafe_type_FAIL_SAFE_VALUE]			},
        { FUNC_AI_STORING_LAST_SETPOINT,	[func_ai_fsafe_type_STORING_LAST_SETPOINT]	},
        { FUNC_AI_FAIL_SAFE_POSITION,		[func_ai_fsafe_type_FAIL_SAFE_POSITION]		}
    }
   HANDLING	READ & WRITE;
}


//--- DI 21 : FSAFE_VAL_D -------------------------------------------------------------------------

// VARIABLE func1_DI_fsafe_value : extern


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

// VARIABLE func1_DI_simulate_value	: extern

VARIABLE func1_DI_simulate_status_quality
{
    LABEL		[status_quality];
    HELP		[func_simulate_status_help];
    CLASS		CONTAINED & SERVICE;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_func1_DI
    }
    HANDLING	READ & WRITE;
}


func1_DI_simulate_status_limit				LIKE VARIABLE	func1_DI_simulate_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT(func1_DI_simulate_status_quality)
    }
}


VARIABLE func1_DI_simulation_enabled
{
    LABEL		[func_simulation_enabled];
    HELP		[func_simulation_enabled_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[disabled]		},
        {	1,	[enabled]		}
    }
    HANDLING READ & WRITE;
    POST_READ_ACTIONS
    {
        method_func1_DI_set_global_simulation
    }
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 00 : BLOCK_OBJECT ------------------------------------------------------------------------

COMMAND read_func1_DI_blk
{
    BLOCK func1_DI_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_blk_reserve,
            func1_DI_blk_object,
            func1_DI_blk_parent_class,
            func1_DI_blk_class,
            func1_DI_blk_dd_reference,
            func1_DI_blk_dd_rev,
            func1_DI_blk_profile,
            func1_DI_blk_profile_rev,
            func1_DI_blk_execution_time,
            func1_DI_blk_num_parameters,
            func1_DI_blk_index_view_1,
            func1_DI_blk_num_view_lists
        }
    }
}


//--- DI 01 : ST_REV ------------------------------------------------------------------------------

COMMAND read_func1_DI_st_rev
{
    BLOCK func1_DI_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_st_rev
        }
    }
}


//--- DI 02 : TAG_DESC ----------------------------------------------------------------------------

COMMAND read_func1_DI_tag_desc
{
    BLOCK func1_DI_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_tag_desc
        }
    }
}


COMMAND write_func1_DI_tag_desc
{
    BLOCK func1_DI_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_tag_desc
        }
        REPLY
        {
        }
    }
}


//--- DI 03 : STRATEGY ----------------------------------------------------------------------------

COMMAND read_func1_DI_strategy
{
    BLOCK func1_DI_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_strategy
        }
    }
}


COMMAND write_func1_DI_strategy
{
    BLOCK func1_DI_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_strategy
        }
        REPLY
        {
        }
    }
}


//--- DI 04 : ALERT_KEY ---------------------------------------------------------------------------

COMMAND read_func1_DI_alert_key
{
    BLOCK func1_DI_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_alert_key
        }
    }
}


COMMAND write_func1_DI_alert_key
{
    BLOCK func1_DI_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_alert_key
        }
        REPLY
        {
        }
    }
}


//--- DI 05 : TARGET_MODE -------------------------------------------------------------------------

COMMAND read_func1_DI_target_mode
{
    BLOCK func1_DI_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_target_mode
        }
    }
}


COMMAND write_func1_DI_target_mode
{
    BLOCK func1_DI_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_target_mode
        }
        REPLY
        {
        }
    }
}


//--- DI 06 : MODE_BLK ----------------------------------------------------------------------------

COMMAND read_func1_DI_mode
{
    BLOCK func1_DI_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func1_DI_actual_mode,
             func1_DI_permitted_mode,
             func1_DI_normal_mode
        }
    }
}


//--- DI 07 : ALARM_SUM ---------------------------------------------------------------------------

COMMAND read_func1_DI_alarm
{
    BLOCK func1_DI_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_current_state_alarm_sum,
            func1_DI_unacknowledged_state_alarm_sum,
            func1_DI_unreported_state_alarm_sum,
            func1_DI_disabled_state_alarm_sum
        }
    }
}


//--- DI 08 : BATCH -------------------------------------------------------------------------------

COMMAND read_func1_DI_batch_information
{
    BLOCK func1_DI_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_batch_id,
            func1_DI_batch_unit,
            func1_DI_batch_operation,
            func1_DI_batch_phase
        }
    }
}


COMMAND write_func1_DI_batch_information
{
    BLOCK func1_DI_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_batch_id,
            func1_DI_batch_unit,
            func1_DI_batch_operation,
            func1_DI_batch_phase
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DI Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 10 : OUT_D -------------------------------------------------------------------------------
// extern

//--- DI 14 : CHANNEL -----------------------------------------------------------------------------

COMMAND read_func1_DI_channel
{
    BLOCK func1_DI_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_channel
        }
    }
}


COMMAND write_func1_DI_channel
{
    BLOCK func1_DI_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_channel
        }
        REPLY
        {
        }
    }
}


//--- DI 15 : INVERT ------------------------------------------------------------------------------

COMMAND read_func1_DI_invert
{
    BLOCK func1_DI_block;
    INDEX 15;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_invert
        }
    }
}


COMMAND write_func1_DI_invert
{
    BLOCK func1_DI_block;
    INDEX 15;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_invert
        }
        REPLY
        {
        }
    }
}


//--- DI 20 : FSAFE_TYPE --------------------------------------------------------------------------

COMMAND read_func1_DI_fsafe_type
{
    BLOCK func1_DI_block;
    INDEX 20;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_fsafe_type
        }
    }
}


COMMAND write_func1_DI_fsafe_type
{
    BLOCK func1_DI_block;
    INDEX 20;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_fsafe_type
        }
        REPLY
        {
        }
    }
}


//--- DI 21 : FSAFE_VAL_D -------------------------------------------------------------------------

COMMAND read_func1_DI_fsafe_value
{
    BLOCK func1_DI_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DI_fsafe_value
        }
    }
}


COMMAND write_func1_DI_fsafe_value
{
    BLOCK func1_DI_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DI_fsafe_value
        }
        REPLY
        {
        }
    }
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------
// extern


//-------------------------------------------------------------------------------------------------
//    METHOD
//-------------------------------------------------------------------------------------------------

METHOD method_set_status_limit_func1_DI
{
    LABEL "";
    CLASS		INPUT;
    DEFINITION
    {
        int	quality;
        int block_mode;			/* !!! temp.: bis Methoden mit Aufrufparametern funktionieren !!! */

        quality = ivar_value(func1_DI_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func1_DI_simulate_status_limit, 0);

        block_mode	= ivar_value(func1_DI_target_mode);
        quality		= ivar_value(func1_DI_out_status_quality);
        if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func1_DI_out_status_limit, 0);
    }
}


METHOD method_func1_DI_set_global_simulation
{
    LABEL "";
    CLASS		DYNAMIC;
    DEFINITION
    {
        int  simu_ena, man_ena;

        simu_ena	= ivar_value( func1_DI_simulation_enabled );
        man_ena	= ivar_value( func1_DI_actual_mode 			);

        if ( (simu_ena == 1) || (man_ena == 0x10) )
        {
            lokal_global_simulation |= FUNC1_DI_GLOBAL_SIMULATION_MASK;
        }
        else
        {
            lokal_global_simulation &= ~FUNC1_DI_GLOBAL_SIMULATION_MASK;
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    COLLECTION
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

MENU Group_display_func1_DI_out
{
    LABEL		[menu_dialog_display_output];
    ITEMS
    {
        func1_DI_out_status_quality		(READ_ONLY),
        func1_DI_out_status_limit			(READ_ONLY),
       SEPARATOR,
        func1_DI_current_state_alarm_sum
    }
}


MENU Group_display_func1_DI_in
{
    LABEL		[menu_dialog_display_input];
    ITEMS
    {
        func1_DI_invert 						(READ_ONLY)
    }
}


MENU Group_display_func1_DI_simulation
{
    LABEL		[menu_OnlineWindow_func_display_simulation];
    ITEMS
    {
        func1_DI_simulation_enabled 		(READ_ONLY),
        SEPARATOR,
        func1_DI_actual_mode 				(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Alarm)
//-------------------------------------------------------------------------------------------------

MENU OnlineWindow_S_alarm_func1_DI
{
    LABEL		FUNC1_DI_TITLE;
    ITEMS
    {
        Page_alarm_sum_func1_DI,
    }
}


MENU OnlineWindow_M_alarm_func1_DI
{
    LABEL		FUNC1_DI_TITLE;
    ITEMS
    {
        Page_alarm_sum_func1_DI,
    }
}


MENU Page_alarm_sum_func1_DI
{
    LABEL		[menu_dialog_alarm_sum];
    ITEMS
    {
        func1_DI_current_state_alarm_sum,
        func1_DI_unacknowledged_state_alarm_sum,
        SEPARATOR,
        func1_DI_unreported_state_alarm_sum,
        func1_DI_disabled_state_alarm_sum
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Diagnosis)
//-------------------------------------------------------------------------------------------------

MENU Page_diagnosis_func1_DI
{
    LABEL		FUNC1_DI_TITLE+THEME_DI;
    ITEMS
    {
        func1_DI_blk_object,
        func1_DI_blk_parent_class,
        func1_DI_blk_class,
        func1_DI_blk_dd_reference,
        func1_DI_blk_dd_rev,
        func1_DI_blk_profile,
        func1_DI_blk_profile_rev,
        func1_DI_st_rev,
        func1_DI_actual_mode
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU OnlineDialog_simulation_func1_DI
{
    LABEL		FUNC1_DI_TITLE;
    ITEMS
    {
        Page_simulation_input_func1_DI,
        Page_simulation_output_func1_DI
    }
}


MENU Page_simulation_input_func1_DI
{
    LABEL		[menu_dialog_simulation_input];
    ITEMS
    {
        func1_DI_simulation_enabled,
        Group_simulate_input_func1_DI,
        method_set
    }
}


MENU Page_simulation_output_func1_DI
{
    LABEL		[menu_dialog_simulation_output];
    ITEMS
    {
        func1_DI_target_mode,
        func1_DI_actual_mode,
        Group_simulate_output_func1_DI,
        method_set
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Parameter table)
//-------------------------------------------------------------------------------------------------

MENU Tab_s_func1_DI
{
    LABEL		FUNC1_DI_TITLE;
    ITEMS
    {
        func1_DI_st_rev,

        func1_DI_invert,
        Tab_s_func1_DI_batch,
        Tab_s_func1_DI_fsafe
    }
}


MENU Tab_m_func1_DI
{
    LABEL		FUNC1_DI_TITLE;
    ITEMS
    {
        func1_DI_st_rev,

        Tab_s_func1_DI_batch,
        Tab_m_func1_DI_fsafe
    }
}


MENU Tab_s_func1_DI_batch
{
    LABEL		[menu_ident_batch_info];
    ITEMS
    {
        func1_DI_batch_id,
        func1_DI_batch_unit,
        func1_DI_batch_operation,
        func1_DI_batch_phase
    }
}


MENU Tab_s_func1_DI_fsafe
{
    LABEL [menu_fail_safe];
    ITEMS
    {
        func1_DI_fsafe_type,
        func1_DI_fsafe_value
    }
}


MENU Tab_m_func1_DI_fsafe
{
    LABEL [menu_fail_safe];
    ITEMS
    {
        func1_DI_fsafe_type		(READ_ONLY),
        func1_DI_fsafe_value		(READ_ONLY)
    }
}


//--- DI 00 : BLOCK_OBJECT ------------------------------------------------------------------------
//--- DI 01 : ST_REV ------------------------------------------------------------------------------
//--- DI 02 : TAG_DESC ----------------------------------------------------------------------------
//--- DI 03 : STRATEGY ----------------------------------------------------------------------------
//--- DI 04 : ALERT_KEY ---------------------------------------------------------------------------
//--- DI 05 : TARGET_MODE -------------------------------------------------------------------------
//--- DI 06 : MODE_BLK ----------------------------------------------------------------------------
//--- DI 07 : ALARM_SUM ---------------------------------------------------------------------------
//--- DI 08 : BATCH -------------------------------------------------------------------------------
//--- DI 10 : OUT_D -------------------------------------------------------------------------------
//--- DI 14 : CHANNEL -----------------------------------------------------------------------------
//--- DI 15 : INVERT ------------------------------------------------------------------------------
//--- DI 20 : FSAFE_TYPE --------------------------------------------------------------------------
//--- DI 21 : FSAFE_VAL_D -------------------------------------------------------------------------
//--- DI 24 : SIMULATE ----------------------------------------------------------------------------


//		func1_DI_blk_reserve
//		func1_DI_blk_object
//		func1_DI_blk_parent_class
//		func1_DI_blk_class
//		func1_DI_blk_dd_reference
//		func1_DI_blk_dd_rev
//		func1_DI_blk_profile
//		func1_DI_blk_profile_rev
//		func1_DI_blk_execution_time
//		func1_DI_blk_num_parameters
//		func1_DI_blk_index_view_1
//		func1_DI_blk_num_view_lists
//		func1_DI_st_rev
//		func1_DI_tag_desc
//		func1_DI_strategy
//		func1_DI_alert_key
//		func1_DI_target_mode
//		func1_DI_actual_mode
//		func1_DI_permitted_mode
//		func1_DI_normal_mode
//		func1_DI_current_state_alarm_sum
//		func1_DI_unacknowledged_state_alarm_sum
//		func1_DI_unreported_state_alarm_sum
//		func1_DI_disabled_state_alarm_sum
//		func1_DI_batch_id
//		func1_DI_batch_unit
//		func1_DI_batch_operation
//		func1_DI_batch_phase
//		func1_DI_out_value
//		func1_DI_out_status_quality
//		func1_DI_out_status_limit
//		func1_DI_channel
//		func1_DI_invert
//		func1_DI_fsafe_type
//		func1_DI_fsafe_value
//		func1_DI_simulate_value
//		func1_DI_simulate_status_quality
//		func1_DI_simulate_status_limit
//		func1_DI_simulation_enabled
