/*
//----------------------------------------------------------------------------
// Erzeuger:        msh
// Datum:           2013-10-21_10:07:42
//                  Transducerblock Standard-Parameter

 Variablen:
 -----------------------------------------------
 * - tb1_Ana_BLOCK_OBJECT_Reserved
 * - tb1_Ana_BLOCK_OBJECT_Block_Object
 * - tb1_Ana_BLOCK_OBJECT_Parent_Class
 * - tb1_Ana_BLOCK_OBJECT_Class
 * - tb1_Ana_BLOCK_OBJECT_DD_Reference
 * - tb1_Ana_BLOCK_OBJECT_DD_Revision
 * - tb1_Ana_BLOCK_OBJECT_Profile
 * - tb1_Ana_BLOCK_OBJECT_Profile_Revision
 * - tb1_Ana_BLOCK_OBJECT_Execution_Time
 * - tb1_Ana_BLOCK_OBJECT_Number_of_Parameters
 * - tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Slot
 * - tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Index
 * - tb1_Ana_BLOCK_OBJECT_Number_of_Views
 * - tb1_Ana_ST_REV
 * - tb1_Ana_TAG_DESC
 * - tb1_Ana_STRATEGY
 * - tb1_Ana_ALERT_KEY
 * - tb1_Ana_TARGET_MODE
 * - tb1_Ana_MODE_BLK_Actual
 * - tb1_Ana_MODE_BLK_Permitted
 * - tb1_Ana_MODE_BLK_Normal
 * - tb1_Ana_ALARM_SUM_Current
 * - tb1_Ana_ALARM_SUM_Unacknowledged
 * - tb1_Ana_ALARM_SUM_Unreported
 * - tb1_Ana_ALARM_SUM_Disabled

 Commands:
 -----------------------------------------------
 * - tb1_Ana_BLOCK_OBJECT_read
 * - tb1_Ana_ST_REV_read
 * - tb1_Ana_TAG_DESC_read
 * - tb1_Ana_TAG_DESC_write
 * - tb1_Ana_STRATEGY_read
 * - tb1_Ana_STRATEGY_write
 * - tb1_Ana_ALERT_KEY_read
 * - tb1_Ana_ALERT_KEY_write
 * - tb1_Ana_TARGET_MODE_read
 * - tb1_Ana_TARGET_MODE_write
 * - tb1_Ana_MODE_BLK_read
 * - tb1_Ana_ALARM_SUM_read

  Menue:
 -----------------------------------------------
 * - tb1_Ana_BLOCK_OBJECT_page
 * - tb1_Ana_ST_REV_page
 * - tb1_Ana_TAG_DESC_page
 * - tb1_Ana_STRATEGY_page
 * - tb1_Ana_ALERT_KEY_page
 * - tb1_Ana_TARGET_MODE_page
 * - tb1_Ana_MODE_BLK_page
 * - tb1_Ana_ALARM_SUM_page
//----------------------------------------------------------------------------
*/
MANUFACTURER 97, DEVICE_TYPE 1, DEVICE_REVISION 1, DD_REVISION 1

BLOCK tb1_Ana_block
{
    NUMBER 1;
    TYPE TRANSDUCER;
}

COLLECTION tb1_Ana_BLOCK_OBJECT
{
    LABEL [PI_BLOCK_OBJECT_label];
    HELP [PI_BLOCK_OBJECT_help];
    MEMBERS
    {
        Reserved, tb1_Ana_BLOCK_OBJECT_Reserved;
        Block_Object, tb1_Ana_BLOCK_OBJECT_Block_Object;
        Parent_Class, tb1_Ana_BLOCK_OBJECT_Parent_Class;
        Class, tb1_Ana_BLOCK_OBJECT_Class;
        Dev_Rev, tb1_Ana_BLOCK_OBJECT_Dev_Rev;
        Dev_Rev_Comp, tb1_Ana_BLOCK_OBJECT_Dev_Rev_Comp;
        DD_Revision, tb1_Ana_BLOCK_OBJECT_DD_Revision;
        Profile, tb1_Ana_BLOCK_OBJECT_Profile;
        Profile_Revision, tb1_Ana_BLOCK_OBJECT_Profile_Revision;
        Execution_Time, tb1_Ana_BLOCK_OBJECT_Execution_Time;
        Number_of_Parameters, tb1_Ana_BLOCK_OBJECT_Number_of_Parameters;
        Address_of_VIEW_1_Slot, tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Slot;
        Address_of_VIEW_1_Index, tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Index;
        Number_of_Views, tb1_Ana_BLOCK_OBJECT_Number_of_Views;
    }
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Reserved
{
    LABEL [PI_BLOCK_OBJECT_Reserved_label];
    HELP [PI_BLOCK_OBJECT_Reserved_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(1);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Block_Object
{
    LABEL [PI_BLOCK_OBJECT_Block_Object_label];
    HELP [PI_BLOCK_OBJECT_Block_Object_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE ENUMERATED(1)
    {
        DEFAULT_VALUE 2;
        { 1, [PI_BLOCK_OBJECT_Block_Object_enum_1] },
        { 2, [PI_BLOCK_OBJECT_Block_Object_enum_2] },
        { 3, [PI_BLOCK_OBJECT_Block_Object_enum_3] }
    }
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Parent_Class
{
    LABEL [PI_BLOCK_OBJECT_Parent_Class_label];
    HELP [PI_BLOCK_OBJECT_Parent_Class_help_1];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE ENUMERATED(1)
    {
        DEFAULT_VALUE 1;
        { 1, [PI_BLOCK_OBJECT_Parent_Class_enum_1_1] },
        { 2, [PI_BLOCK_OBJECT_Parent_Class_enum_2_1] },
        { 3, [PI_BLOCK_OBJECT_Parent_Class_enum_3_1] },
        { 4, [PI_BLOCK_OBJECT_Parent_Class_enum_4_1] },
        { 5, [PI_BLOCK_OBJECT_Parent_Class_enum_5_1] },
        { 6, [PI_BLOCK_OBJECT_Parent_Class_enum_8] },
        { 7, [PI_BLOCK_OBJECT_Parent_Class_enum_7_1] }
    }
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Class
{
    LABEL [PI_BLOCK_OBJECT_Class_label];
    HELP [PI_BLOCK_OBJECT_Class_help_1];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE ENUMERATED(1)
    {
        DEFAULT_VALUE 1;
        { 1, [PI_func_AI_BLOCK_OBJECT_Class_enum_1] }
    }
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Dev_Rev
{
    LABEL [PI_BLOCK_OBJECT_Dev_Rev_label];
    HELP [PI_BLOCK_OBJECT_Dev_Rev_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(2);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Dev_Rev_Comp
{
    LABEL [PI_BLOCK_OBJECT_Dev_Rev_Comp_label];
    HELP [PI_BLOCK_OBJECT_Dev_Rev_Comp_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(2);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_DD_Revision
{
    LABEL [PI_BLOCK_OBJECT_DD_Revision_label];
    HELP [PI_BLOCK_OBJECT_DD_Revision_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(2);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Profile
{
    LABEL [PI_BLOCK_OBJECT_Profile_label];
    HELP [PI_BLOCK_OBJECT_Profile_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE ENUMERATED(2)
    {
        { 0x4001, [PI_BLOCK_OBJECT_Profile_enum_0x4001] },
        { 0x4002, [PI_BLOCK_OBJECT_Profile_enum_0x4002] },
        { 0x4081, [PI_BLOCK_OBJECT_Profile_enum_0x4081] },
        { 0x4082, [PI_BLOCK_OBJECT_Profile_enum_0x4082] }
    }
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Profile_Revision
{
    LABEL [PI_BLOCK_OBJECT_Profile_Revision_label];
    HELP [PI_BLOCK_OBJECT_Profile_Revision_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE ENUMERATED(2)
    {
        DEFAULT_VALUE 0x302;
        { 0x0200, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0200] },
        { 0x0300, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0300] },
        { 0x0301, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0301] },
        { 0x0302, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0302] }
    }
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Execution_Time
{
    LABEL [PI_BLOCK_OBJECT_Execution_Time_label];
    HELP [PI_BLOCK_OBJECT_Execution_Time_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(1);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Number_of_Parameters
{
    LABEL [PI_BLOCK_OBJECT_Number_of_Parameters_label];
    HELP [PI_BLOCK_OBJECT_Number_of_Parameters_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(2);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Slot
{
    LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_label];
    HELP [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(1);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Index
{
    LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Index_label];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(1);
}

VARIABLE tb1_Ana_BLOCK_OBJECT_Number_of_Views
{
    LABEL [PI_BLOCK_OBJECT_Number_of_Views_label];
    HELP [PI_BLOCK_OBJECT_Number_of_Views_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(1);
}


VARIABLE tb1_Ana_ST_REV
{
    LABEL [PI_ST_REV_label];
    HELP [PI_ST_REV_help];
    CLASS CONTAINED;
    HANDLING READ;
    TYPE UNSIGNED_INTEGER(2)
    {
        DEFAULT_VALUE 0;
    }
}

VARIABLE tb1_Ana_TAG_DESC
{
    LABEL [PI_TAG_DESC_label];
    HELP [PI_TAG_DESC_help];
    CLASS CONTAINED;
    TYPE VISIBLE(32)
    {
        DEFAULT_VALUE " ";
    }
}

VARIABLE tb1_Ana_STRATEGY
{
    LABEL [PI_STRATEGY_label];
    HELP [PI_STRATEGY_help];
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        DEFAULT_VALUE 0;
    }
}

VARIABLE tb1_Ana_ALERT_KEY
{
    LABEL [PI_ALERT_KEY_label];
    HELP [PI_ALERT_KEY_help];
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1)
    {
        DEFAULT_VALUE 0;
    }
}

VARIABLE tb1_Ana_TARGET_MODE
{
    LABEL [PI_TARGET_MODE_label];
    HELP [PI_TARGET_MODE_help];
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        { 0x01, [PI_mode_ROUT] },
        { 0x02, [PI_mode_RCAS] },
        { 0x04, [PI_mode_CAS] },
        { 0x08, [PI_mode_AUTO] },
        { 0x10, [PI_mode_MAN] },
        { 0x20, [PI_mode_LO] },
        { 0x40, [PI_mode_IMAN] },
        { 0x80, [PI_mode_OUT_OF_SERVICE] }
    }
}

COLLECTION tb1_Ana_MODE_BLK
{
    MEMBERS
    {
        Actual, tb1_Ana_MODE_BLK_Actual;
        Permitted, tb1_Ana_MODE_BLK_Permitted;
        Normal, tb1_Ana_MODE_BLK_Normal;
    }
}

VARIABLE tb1_Ana_MODE_BLK_Actual
{
    LABEL [PI_MODE_BLK_Actual_label];
    HELP [PI_MODE_BLK_Actual_help];
    CLASS CONTAINED & DYNAMIC;
    HANDLING READ;
    TYPE ENUMERATED(1)
    {
        DEFAULT_VALUE 0x8;
        { 0x01, [PI_mode_ROUT] },
        { 0x02, [PI_mode_RCAS] },
        { 0x04, [PI_mode_CAS] },
        { 0x08, [PI_mode_AUTO] },
        { 0x10, [PI_mode_MAN] },
        { 0x20, [PI_mode_LO] },
        { 0x40, [PI_mode_IMAN] },
        { 0x80, [PI_mode_OUT_OF_SERVICE] }
    }
}

VARIABLE tb1_Ana_MODE_BLK_Permitted
{
    LABEL [PI_MODE_BLK_Permitted_label];
    HELP [PI_MODE_BLK_Permitted_help];
    CLASS CONTAINED & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED(1)
    {
        DEFAULT_VALUE 0xb8;
        { 0x01, [PI_mode_ROUT] },
        { 0x02, [PI_mode_RCAS] },
        { 0x04, [PI_mode_CAS] },
        { 0x08, [PI_mode_AUTO] },
        { 0x10, [PI_mode_MAN] },
        { 0x20, [PI_mode_LO] },
        { 0x40, [PI_mode_IMAN] },
        { 0x80, [PI_mode_OUT_OF_SERVICE] }
    }
}

VARIABLE tb1_Ana_MODE_BLK_Normal
{
    LABEL [PI_MODE_BLK_Normal_label];
    HELP [PI_MODE_BLK_Normal_help];
    CLASS CONTAINED & DYNAMIC;
    HANDLING READ;
    TYPE ENUMERATED(1)
    {
        DEFAULT_VALUE 0x8;
        { 0x01, [PI_mode_ROUT] },
        { 0x02, [PI_mode_RCAS] },
        { 0x04, [PI_mode_CAS] },
        { 0x08, [PI_mode_AUTO] },
        { 0x10, [PI_mode_MAN] },
        { 0x20, [PI_mode_LO] },
        { 0x40, [PI_mode_IMAN] },
        { 0x80, [PI_mode_OUT_OF_SERVICE] }
    }
}

COLLECTION tb1_Ana_ALARM_SUM
{
    MEMBERS
    {
        Current, tb1_Ana_ALARM_SUM_Current;
        Unacknowledged, tb1_Ana_ALARM_SUM_Unacknowledged;
        Unreported, tb1_Ana_ALARM_SUM_Unreported;
        Disabled, tb1_Ana_ALARM_SUM_Disabled;
    }
}

VARIABLE tb1_Ana_ALARM_SUM_Current
{
    LABEL [PI_ALARM_SUM_Current_label];
    HELP [PI_ALARM_SUM_Current_help];
    CLASS CONTAINED & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED(2)
    {
        DEFAULT_VALUE 0;
        { 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
        { 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
    }
}

VARIABLE tb1_Ana_ALARM_SUM_Unacknowledged
{
    LABEL [PI_ALARM_SUM_Unacknowledged_label];
    HELP [PI_ALARM_SUM_Unacknowledged_help];
    CLASS CONTAINED & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED(2)
    {
        DEFAULT_VALUE 0;
        { 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
        { 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
    }
}

VARIABLE tb1_Ana_ALARM_SUM_Unreported
{
    LABEL [PI_ALARM_SUM_Unreported_label];
    HELP [PI_ALARM_SUM_Unreported_help];
    CLASS CONTAINED & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED(2)
    {
        DEFAULT_VALUE 0;
        { 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
        { 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
    }
}

VARIABLE tb1_Ana_ALARM_SUM_Disabled
{
    LABEL [PI_ALARM_SUM_Disabled_label];
    HELP [PI_ALARM_SUM_Disabled_help];
    CLASS CONTAINED & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED(2)
    {
        DEFAULT_VALUE 0;
        { 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
        { 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
    }
}


/*VARIABLE tb1_primary_value
{
    LABEL        "Value";
    HELP        "Value";
    CLASS        CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
    }
    HANDLING    READ;
}


VARIABLE tb1_primary_value_status_quality
{
    LABEL        "Status";
    HELP        "Status";
    CLASS        CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}


tb1_primary_value_status_limit LIKE VARIABLE tb1_primary_value_status_quality
{
    REDEFINE LABEL        "Status Limit";        
}*/

/*RECORD    value_ds101
{
    LABEL          "Value and Status" ;
    HELP           "Value and Status" ;
    MEMBERS
    {
        STATUS,     tb1_primary_value_status_quality ;
        VALUE,      tb1_primary_value ;
    }
}*/

/*
//----------------------------------------------------------------------------
// MENs
//----------------------------------------------------------------------------
*/
MENU tb1_Ana_BLOCK_OBJECT_page
{
    LABEL [PI_BLOCK_OBJECT_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_BLOCK_OBJECT
    }
}

MENU tb1_Ana_ST_REV_page
{
    LABEL [PI_ST_REV_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_ST_REV
    }
}

MENU tb1_Ana_TAG_DESC_page
{
    LABEL [PI_TAG_DESC_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_TAG_DESC
    }
}

MENU tb1_Ana_STRATEGY_page
{
    LABEL [PI_STRATEGY_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_STRATEGY
    }
}

MENU tb1_Ana_ALERT_KEY_page
{
    LABEL [PI_ALERT_KEY_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_ALERT_KEY
    }
}

MENU tb1_Ana_TARGET_MODE_page
{
    LABEL [PI_TARGET_MODE_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_TARGET_MODE
    }
}

MENU tb1_Ana_MODE_BLK_page
{
    LABEL [PI_MODE_BLK_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_MODE_BLK
    }
}

MENU tb1_Ana_ALARM_SUM_page
{
    LABEL [PI_ALARM_SUM_page_label];
    STYLE PAGE;
    ITEMS
    {
        tb1_Ana_ALARM_SUM
    }
}

/*
//----------------------------------------------------------------------------
// Commands
//----------------------------------------------------------------------------
*/
COMMAND tb1_Ana_BLOCK_OBJECT_read
{
    BLOCK tb1_Ana_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
      tb1_Ana_BLOCK_OBJECT_Reserved,
            tb1_Ana_BLOCK_OBJECT_Block_Object,
            tb1_Ana_BLOCK_OBJECT_Parent_Class,
            tb1_Ana_BLOCK_OBJECT_Class,
            tb1_Ana_BLOCK_OBJECT_Dev_Rev,
            tb1_Ana_BLOCK_OBJECT_Dev_Rev_Comp,
            tb1_Ana_BLOCK_OBJECT_DD_Revision,
            tb1_Ana_BLOCK_OBJECT_Profile,
            tb1_Ana_BLOCK_OBJECT_Profile_Revision,
            tb1_Ana_BLOCK_OBJECT_Execution_Time,
            tb1_Ana_BLOCK_OBJECT_Number_of_Parameters,
            tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Slot,
            tb1_Ana_BLOCK_OBJECT_Address_of_VIEW_1_Index,
            tb1_Ana_BLOCK_OBJECT_Number_of_Views
        }
    }
}

COMMAND tb1_Ana_ST_REV_read
{
    BLOCK tb1_Ana_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tb1_Ana_ST_REV
        }
    }
}

COMMAND tb1_Ana_TAG_DESC_read
{
    BLOCK tb1_Ana_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tb1_Ana_TAG_DESC
        }
    }
}

COMMAND tb1_Ana_TAG_DESC_write
{
    BLOCK tb1_Ana_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            tb1_Ana_TAG_DESC
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_Ana_STRATEGY_read
{
    BLOCK tb1_Ana_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tb1_Ana_STRATEGY
        }
    }
}

COMMAND tb1_Ana_STRATEGY_write
{
    BLOCK tb1_Ana_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            tb1_Ana_STRATEGY
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_Ana_ALERT_KEY_read
{
    BLOCK tb1_Ana_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tb1_Ana_ALERT_KEY
        }
    }
}

COMMAND tb1_Ana_ALERT_KEY_write
{
    BLOCK tb1_Ana_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            tb1_Ana_ALERT_KEY
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_Ana_TARGET_MODE_read
{
    BLOCK tb1_Ana_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tb1_Ana_TARGET_MODE
        }
    }
}

COMMAND tb1_Ana_TARGET_MODE_write
{
    BLOCK tb1_Ana_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            tb1_Ana_TARGET_MODE
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_Ana_MODE_BLK_read
{
    BLOCK tb1_Ana_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tb1_Ana_MODE_BLK_Actual,
            tb1_Ana_MODE_BLK_Permitted,
            tb1_Ana_MODE_BLK_Normal
        }
    }
}

COMMAND tb1_Ana_ALARM_SUM_read
{
    BLOCK tb1_Ana_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tb1_Ana_ALARM_SUM_Current,
            tb1_Ana_ALARM_SUM_Unacknowledged,
            tb1_Ana_ALARM_SUM_Unreported,
            tb1_Ana_ALARM_SUM_Disabled
        }
    }
}

/*
  ENDE
*/
