
//-------------------------------------------------------------------------------------------------
// Structure of this file:
//-------------------------------------------------------------------------------------------------
//    Macros
//		Configuration
//    Up-/Download List
//		BLOCK
//    VARIABLE (Standard Parameter)
//    VARIABLE (AI Parameter)
//    COMMAND (Standard Parameter)
//    COMMAND (AI Parameter)
//    UNIT
//		COLLECTION
//		METHOD
//		MENU (Output)
//    MENU (Simulation)
//    MENU (Alarm)
//    MENU (Diagnosis)
//    MENU (Parameter Table)


//-------------------------------------------------------------------------------------------------
//    Macros
//-------------------------------------------------------------------------------------------------

#ifndef FLOAT_MIN
    #define	FLOAT_MIN	-3.4E+38
    #define	FLOAT_MAX	 3.4E+38
#endif


#define DEF_DISPLAY_FORMAT_FUNC5_AI(value)					\
        IF( (value > 999999999) || (value < -999999999) )	\
        {																	\
            SELECT(func5_AI_out_decimal_point)					\
            {																\
                CASE 0:		".1g";									\
                CASE 1:		".2g";									\
                CASE 2:		".3g";									\
                CASE 3:		".4g";									\
                CASE 4:		".5g";									\
                CASE 5:		".6g";									\
                CASE 6:		".7g";									\
                CASE 7:		".8g";									\
                DEFAULT:	  "8.4g"; 									\
            }																\
        }																	\
        ELSE																\
        {																	\
            SELECT(func5_AI_out_decimal_point)					\
            {																\
                CASE 0:		".0f";									\
                CASE 1:		".1f";									\
                CASE 2:		".2f";									\
                CASE 3:		".3f";									\
                CASE 4:		".4f";									\
                CASE 5:		".5f";									\
                CASE 6:		".6f";									\
                CASE 7:		".7f";									\
                DEFAULT:	  "7.4f";									\
            }																\
        }


//-------------------------------------------------------------------------------------------------
//    Configuration
//-------------------------------------------------------------------------------------------------

#ifndef FUNC5_AI_TITLE
    #define FUNC5_AI_TITLE 										[func5_AI]
#endif


#ifndef FUNC5_AI_BLOCKNUMBER
    #define FUNC5_AI_BLOCKNUMBER								1
#endif


#ifdef FUNC5_AI_DEFAULT_UNIT
    #define DEFAULT_VALUE_func5_AI_out_unit    			FUNC5_AI_DEFAULT_UNIT
#endif


#ifndef DEFAULT_VALUE_func5_AI_out_unit
    #define DEFAULT_VALUE_func5_AI_out_unit				1342
#endif


#ifndef DEFAULT_VALUE_func5_AI_upper_range_value
    #define DEFAULT_VALUE_func5_AI_upper_range_value	1.0
#endif


#ifndef DEFAULT_VALUE_func5_AI_lower_range_value
    #define DEFAULT_VALUE_func5_AI_lower_range_value	0.0
#endif


#ifndef DEFAULT_VALUE_func5_AI_hi_hi_lim
    #define DEFAULT_VALUE_func5_AI_hi_hi_lim 				DEFAULT_VALUE_func5_AI_upper_range_value
#endif


#ifndef DEFAULT_VALUE_func5_AI_hi_lim
    #define DEFAULT_VALUE_func5_AI_hi_lim 					DEFAULT_VALUE_func5_AI_upper_range_value
#endif


#ifndef DEFAULT_VALUE_func5_AI_lo_lim
    #define DEFAULT_VALUE_func5_AI_lo_lim 					DEFAULT_VALUE_func5_AI_lower_range_value
#endif


#ifndef DEFAULT_VALUE_func5_AI_lo_lo_lim
    #define DEFAULT_VALUE_func5_AI_lo_lo_lim 				DEFAULT_VALUE_func5_AI_lower_range_value
#endif


#ifndef NO_func5_AI_out_unit_text
    #ifndef	FUNC5_AI_UNIT_LIST
        #define FUNC5_AI_UNIT_LIST	UNIT_LIST				, { 1995,	func5_AI_out_unit_text }
    #endif
#else
    #ifndef	FUNC5_AI_UNIT_LIST
        #define FUNC5_AI_UNIT_LIST	UNIT_LIST
    #endif
#endif


#ifndef	FUNC5_AI_UNIT_LIST
    #define FUNC5_AI_UNIT_LIST	UNIT_LIST					, { 1995,	func5_AI_out_unit_text }
#endif


#ifndef MAX_VALUE_func5_AI_pv_ftime
    #define MAX_VALUE_func5_AI_pv_ftime						300
#endif


#ifndef DEFAULT_VALUE_func5_AI_pv_ftime
    #define DEFAULT_VALUE_func5_AI_pv_ftime				1
#endif


//-------------------------------------------------------------------------------------------------
//    Up-/Download List
//-------------------------------------------------------------------------------------------------

#define FUNC5_VARIABLES										\
                func5_AI_tag_desc,							\
                func5_AI_batch_id,							\
                func5_AI_batch_unit,						\
                func5_AI_batch_operation,					\
                func5_AI_batch_phase,						\
                func5_AI_pv_upper_range_value,				\
                func5_AI_pv_lower_range_value,				\
                func5_AI_out_upper_range_value,				\
                func5_AI_out_lower_range_value,				\
                func5_AI_out_unit,							\
                func5_AI_pv_ftime,							\
                func5_AI_FSafeType,							\
                func5_AI_FSafeValue,						\
                func5_AI_alarm_hys,							\
                func5_AI_hi_hi_lim,							\
                func5_AI_hi_lim, 							\
                func5_AI_lo_lim,							\
                func5_AI_lo_lo_lim

#ifdef NO_func5_AI_out_unit_text
#define FUNC5_AI_LOAD_TO_DEVICE		FUNC5_VARIABLES
#else
#define FUNC5_AI_LOAD_TO_DEVICE		FUNC5_VARIABLES, func5_AI_out_unit_text
#endif


#define FUNC5_AI_LOAD_TO_PC									\
                func5_AI_st_rev,							\
                FUNC5_AI_LOAD_TO_DEVICE


//-------------------------------------------------------------------------------------------------
//		BLOCK
//-------------------------------------------------------------------------------------------------

BLOCK func5_AI_block
{
    TYPE		FUNCTION;
    NUMBER	FUNC5_AI_BLOCKNUMBER;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- AI 00 : BLOCK_OBJECT ------------------------------------------------------------------------

func5_AI_blk_reserve					LIKE VARIABLE	phys_blk_reserve
{
}


VARIABLE func5_AI_blk_object
{
    LABEL		[blk_block_object];
    HELP		[blk_block_object_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED(1)
    {
        {	2,	[blk_block_object_FUNCTION]	}
    }
    HANDLING	READ;
}


VARIABLE func5_AI_blk_parent_class
{
    LABEL		[blk_parent_class];
    HELP		[func_blk_parent_class_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED(1)
    {
        {	1,	[func_blk_parent_class_INPUT]	}
    }
    HANDLING	READ;
}


VARIABLE func5_AI_blk_class
{
    LABEL		[blk_class];
    HELP		[func_blk_class_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED(1)
    {
        {	1,	[func_blk_class_AI]				}
    }
    HANDLING	READ;
}


func5_AI_blk_dd_reference			LIKE VARIABLE	phys_blk_dd_reference
{
}


func5_AI_blk_dd_rev					LIKE VARIABLE	phys_blk_dd_rev
{
}


func5_AI_blk_profile					LIKE VARIABLE	phys_blk_profile
{
}


func5_AI_blk_profile_rev			LIKE VARIABLE	phys_blk_profile_rev
{
}


func5_AI_blk_execution_time		LIKE VARIABLE	phys_blk_execution_time
{
}


func5_AI_blk_num_parameters		LIKE VARIABLE	phys_blk_num_parameters
{
}


func5_AI_blk_index_view_1			LIKE VARIABLE	phys_blk_index_view_1
{
}


func5_AI_blk_num_view_lists		LIKE VARIABLE	phys_blk_num_view_lists
{
}


//--- AI 01 : ST_REV ------------------------------------------------------------------------------

func5_AI_st_rev						LIKE VARIABLE	phys_st_rev
{
}


//--- AI 02 : TAG_DESC ----------------------------------------------------------------------------

func5_AI_tag_desc						LIKE VARIABLE	phys_tag_desc
{
}


//--- AI 03 : STRATEGY ----------------------------------------------------------------------------

func5_AI_strategy						LIKE VARIABLE	phys_strategy
{
}


//--- AI 04 : ALERT_KEY ---------------------------------------------------------------------------

func5_AI_alert_key					LIKE VARIABLE	phys_alert_key
{
}


//--- AI 05 : TARGET_MODE -------------------------------------------------------------------------

VARIABLE func5_AI_target_mode
{
    LABEL		[target_mode];
    HELP		[target_mode_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
    HANDLING	READ & WRITE;
}


//--- AI 06 : MODE_BLK ----------------------------------------------------------------------------

VARIABLE func5_AI_actual_mode
{
    LABEL		[actual_mode];
    HELP		[actual_mode_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
    HANDLING	READ;
    POST_READ_ACTIONS
    {
        method_func5_AI_set_global_simulation
    }
}


VARIABLE func5_AI_permitted_mode
{
    LABEL		[permitted_mode];
    HELP		[permitted_mode_help];
    CLASS		CONTAINED;
    TYPE		BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
    HANDLING	READ;
}


VARIABLE func5_AI_normal_mode
{
    LABEL		[normal_mode];
    HELP		[normal_mode_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x08;
        {	0x08,	[mode_AUTO]					},
        {	0x10,	[mode_MAN]					},
        {	0x80,	[mode_OUT_OF_SERVICE]	}
    }
    HANDLING	READ;
}


//--- AI 07 : ALARM_SUM ---------------------------------------------------------------------------

func5_AI_current_state_alarm_sum				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


func5_AI_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


func5_AI_unreported_state_alarm_sum			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


func5_AI_disabled_state_alarm_sum				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


//--- AI 08 : BATCH -------------------------------------------------------------------------------

VARIABLE func5_AI_batch_id
{
    LABEL		[func_batch_id];
    HELP		[func_batch_id_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_batch_unit
{
    LABEL		[func_batch_unit];
    HELP		[func_batch_unit_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_batch_operation
{
    LABEL		[func_batch_operation];
    HELP		[func_batch_operation_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_batch_phase
{
    LABEL		[func_batch_phase];
    HELP		[func_batch_phase_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (AI Parameter)
//-------------------------------------------------------------------------------------------------

//--- AI 10 : OUT ---------------------------------------------------------------------------------

VARIABLE func5_AI_out_value
{
    LABEL		[func_out_value];
    HELP		[func_ai_out_value_help];
    CLASS		OUTPUT & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_out_value)
    }
    HANDLING
        IF (func5_AI_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}


VARIABLE func5_AI_out_status_quality
{
    LABEL		[status_quality];
    HELP		[func_out_status_help];
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        IF (func5_AI_target_mode == BLOCK_MODE_MAN)
        {
            STATUS_INPUT_NO_RCAS
        }
        ELSE {
            STATUS_OUTPUT_NO_RCAS
        }
    }
    POST_EDIT_ACTIONS
    {
        IF (func5_AI_target_mode == BLOCK_MODE_MAN)
        {
            method_set_status_limit_1
        }
    }
    HANDLING
        IF (func5_AI_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE {
            READ;
        }
}


func5_AI_out_status_limit						LIKE VARIABLE	func5_AI_out_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT(func5_AI_out_status_quality)
    }
}


//--- AI 11 : PV_SCALE ----------------------------------------------------------------------------

VARIABLE func5_AI_pv_upper_range_value
{
    LABEL		[func_pv_scale_upper_value];
    HELP		[func_pv_scale_upper_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_upper_range_value;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_pv_upper_range_value)
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_pv_lower_range_value
{
    LABEL		[func_pv_scale_lower_value];
    HELP		[func_pv_scale_lower_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_lower_range_value;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_pv_lower_range_value)
    }
    HANDLING	READ & WRITE;
}


//--- AI 12 : OUT_SCALE ---------------------------------------------------------------------------

VARIABLE func5_AI_out_upper_range_value
{
    LABEL		[func_upper_value];
    HELP		[func_out_scale_upper_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_upper_range_value ;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_out_upper_range_value)
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_out_lower_range_value
{
    LABEL		[func_lower_value];
    HELP		[func_out_scale_lower_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_lower_range_value ;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_out_lower_range_value)
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_out_unit
{
    LABEL		[digital_units];
    HELP		[digital_units_help];
    CLASS		CONTAINED & SERVICE;
    TYPE		ENUMERATED (2)
    {
// #ifdef DEFAULT_VALUE_func5_AI_out_unit
//		DEFAULT_VALUE DEFAULT_VALUE_func5_AI_out_unit ;
// #endif
        FUNC5_AI_UNIT_LIST
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_out_decimal_point
{
    LABEL		[decimal_point];
    HELP		[decimal_point_help];
    CLASS		CONTAINED;
    TYPE		INTEGER (1)
    {
        DEFAULT_VALUE	2;
        {	0,   "0"		},
        {	1,   "1"		},
        {	2,   "2"		},
        {	3,   "3"		}
    }
    HANDLING	READ & WRITE;
}


//--- AI 13 : LIN_TYPE ----------------------------------------------------------------------------

VARIABLE func5_AI_lin_type
{
    LABEL		[trans_lin_type];
    HELP		[trans_lin_type_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0,	[linear]	}
    }
    HANDLING	READ & WRITE;
}


//--- AI 14 : CHANNEL -----------------------------------------------------------------------------

VARIABLE func5_AI_channel
{
    LABEL		[func_channel];
    HELP		[func_channel_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (2)
    {
#ifdef FUNC5_AI_CHANNEL_LIST
        FUNC5_AI_CHANNEL_LIST
#else
        { 0x111,	"pv"		}
#endif
    }
    HANDLING	READ & WRITE;
}


//--- AI 16 : PV_FTIME ----------------------------------------------------------------------------

VARIABLE func5_AI_pv_ftime
{
    LABEL		[func_pv_ftime];
    HELP		[func_pv_ftime_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	DEFAULT_VALUE_func5_AI_pv_ftime ;
        MIN_VALUE		0.0;
        MAX_VALUE		MAX_VALUE_func5_AI_pv_ftime ;
    }
    CONSTANT_UNIT	[sec];
    HANDLING	READ & WRITE;
}


//--- AI 17 : FSAFE_TYPE --------------------------------------------------------------------------

VARIABLE func5_AI_FSafeType
{
    LABEL		[func_ao_fsafe_type];
    HELP		[func_ao_fsafe_type_help_PROFILE_3];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    FUNC_AI_STORING_LAST_SETPOINT;
        { 0,	[func_ai_fsafe_type_FAIL_SAFE_VALUE]			},
        { 1,	[func_ai_fsafe_type_STORING_LAST_SETPOINT]	},
        { 2,	[func_ai_fsafe_type_FAIL_SAFE_POSITION]		}
    }
   HANDLING		READ & WRITE;
}


//--- AI 18 : FSAFE_VALUE -------------------------------------------------------------------------

VARIABLE func5_AI_FSafeValue
{
   LABEL		[func_ai_fsafe_value] ;
   HELP		[func_ai_fsafe_value_help];
   CLASS		CONTAINED;
   TYPE		FLOAT
   {
      DEFAULT_VALUE    0.0;
   }
   HANDLING		READ & WRITE;
   VALIDITY	IF (func5_AI_FSafeType == FUNC_AI_FAIL_SAFE_VALUE)
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}


//--- AI 19 : ALARM_HYS ---------------------------------------------------------------------------

VARIABLE func5_AI_alarm_hys
{
    LABEL		[limit_hysteresis];
    HELP		[limit_hysteresis_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        // MIN_VALUE 0 ; problems with temperature units
        DEFAULT_VALUE (DEFAULT_VALUE_func5_AI_upper_range_value - DEFAULT_VALUE_func5_AI_lower_range_value) * 0.05;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_alarm_hys)
    }
    HANDLING	READ & WRITE;

    POST_EDIT_ACTIONS
    {
        method_check_func5_AI_alarm_hys
    }
}


//--- AI 21 : HI_HI_LIM ---------------------------------------------------------------------------

VARIABLE func5_AI_hi_hi_lim
{
    LABEL		[limit_hi_hi];
    HELP		[limit_hi_hi_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_hi_hi_lim ;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_hi_hi_lim)

#ifdef MAX_VALUE_func5_AI_hi_hi_lim
    MAX_VALUE MAX_VALUE_func5_AI_hi_hi_lim ;
#endif

#ifdef MIN_VALUE_func5_AI_hi_hi_lim
    MIN_VALUE MIN_VALUE_func5_AI_hi_hi_lim ;
#endif
    }
    HANDLING	READ & WRITE;

    POST_EDIT_ACTIONS
    {
        method_check_func5_AI_alarm_hys
    }
}


//--- AI 23 : HI_LIM ------------------------------------------------------------------------------

VARIABLE func5_AI_hi_lim
{
    LABEL		[limit_hi];
    HELP		[limit_hi_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_hi_lim ;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_hi_lim)

#ifdef MAX_VALUE_func5_AI_hi_lim
    MAX_VALUE MAX_VALUE_func5_AI_hi_lim ;
#endif

#ifdef MIN_VALUE_func5_AI_hi_lim
    MIN_VALUE MIN_VALUE_func5_AI_hi_lim ;
#endif
    }
    HANDLING	READ & WRITE;

    POST_EDIT_ACTIONS
    {
        method_check_func5_AI_alarm_hys
    }
}


//--- AI 25 : LO_LIM ------------------------------------------------------------------------------

VARIABLE func5_AI_lo_lim
{
    LABEL		[limit_lo];
    HELP		[limit_lo_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_lo_lim ;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_lo_lim)

#ifdef MAX_VALUE_func5_AI_lo_lim
    MAX_VALUE MAX_VALUE_func5_AI_lo_lim ;
#endif

#ifdef MIN_VALUE_func5_AI_lo_lim
    MIN_VALUE MIN_VALUE_func5_AI_lo_lim ;
#endif
    }
    HANDLING	READ & WRITE;

    POST_EDIT_ACTIONS
    {
        method_check_func5_AI_alarm_hys
    }
}


//--- AI 27 : LO_LO_LIM ---------------------------------------------------------------------------

VARIABLE func5_AI_lo_lo_lim
{
    LABEL		[limit_lo_lo];
    HELP		[limit_lo_lo_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func5_AI_lo_lo_lim ;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC5_AI(func5_AI_lo_lo_lim)

#ifdef MAX_VALUE_func5_AI_lo_lo_lim
    MAX_VALUE MAX_VALUE_func5_AI_lo_lo_lim ;
#endif

#ifdef MIN_VALUE_func5_AI_lo_lo_lim
    MIN_VALUE MIN_VALUE_func5_AI_lo_lo_lim ;
#endif

    }
    HANDLING	READ & WRITE;

    POST_EDIT_ACTIONS
    {
        method_check_func5_AI_alarm_hys
    }
}


//--- AI 30 : HI_HI_ALM ---------------------------------------------------------------------------

VARIABLE func5_AI_hi_hi_alm_unacknowledged
{
    LABEL		[limit_alarm_unacknowledged];
    HELP		[limit_alarm_unacknowledged_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1);
    HANDLING	READ;
}


VARIABLE func5_AI_hi_hi_alm_state
{
    LABEL		[limit_state];
    HELP		[limit_hi_hi_state_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[limit_state_NO_ALARM]	},
        {	1,	[limit_state_HI_HI]		}
    }
    HANDLING	READ;
}


VARIABLE func5_AI_hi_hi_alm_time_stamp
{
    LABEL		[limit_time_stamp];
    HELP		[limit_time_stamp_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		TIME;
    HANDLING	READ;
}


VARIABLE func5_AI_hi_hi_alm_subcode
{
    LABEL		[limit_subcode];
    HELP		[limit_hi_hi_subcode_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (2);
    HANDLING	READ;
}


VARIABLE func5_AI_hi_hi_alm_value
{
    LABEL		[limit_alarm_value];
    HELP		[limit_hi_hi_alarm_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT;
    HANDLING	READ;
}


//--- AI 31 : HI_ALM ------------------------------------------------------------------------------

VARIABLE func5_AI_hi_alm_unacknowledged
{
    LABEL		[limit_warn_unacknowledged];
    HELP		[limit_warn_unacknowledged_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1);
    HANDLING	READ;
}


VARIABLE func5_AI_hi_alm_state
{
    LABEL		[limit_state];
    HELP		[limit_hi_state_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[limit_state_NO_WARNING]	},
        {	1,	[limit_state_HI]				}
    }
    HANDLING	READ;
}


VARIABLE func5_AI_hi_alm_time_stamp
{
    LABEL		[limit_time_stamp];
    HELP		[limit_time_stamp_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		TIME;
    HANDLING	READ;
}


VARIABLE func5_AI_hi_alm_subcode
{
    LABEL		[limit_subcode];
    HELP		[limit_hi_subcode_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (2);
    HANDLING	READ;
}


VARIABLE func5_AI_hi_alm_value
{
    LABEL		[limit_warn_value];
    HELP		[limit_hi_warn_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT;
    HANDLING	READ;
}


//--- AI 32 : LO_ALM ------------------------------------------------------------------------------

VARIABLE func5_AI_lo_alm_unacknowledged
{
    LABEL		[limit_warn_unacknowledged];
    HELP		[limit_warn_unacknowledged_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1);
    HANDLING	READ;
}


VARIABLE func5_AI_lo_alm_state
{
    LABEL		[limit_state];
    HELP		[limit_lo_state_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[limit_state_NO_WARNING]	},
        {	1,	[limit_state_LO]			}
    }
    HANDLING	READ;
}


VARIABLE func5_AI_lo_alm_time_stamp
{
    LABEL		[limit_time_stamp];
    HELP		[limit_time_stamp_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		TIME;
    HANDLING	READ;
}


VARIABLE func5_AI_lo_alm_subcode
{
    LABEL		[limit_subcode];
    HELP		[limit_lo_subcode_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (2);
    HANDLING	READ;
}


VARIABLE func5_AI_lo_alm_value
{
    LABEL		[limit_warn_value];
    HELP		[limit_lo_warn_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT;
    HANDLING	READ;
}


//--- AI 33 : LO_LO_ALM ---------------------------------------------------------------------------

VARIABLE func5_AI_lo_lo_alm_unacknowledged
{
    LABEL		[limit_alarm_unacknowledged];
    HELP		[limit_alarm_unacknowledged_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1);
    HANDLING	READ;
}


VARIABLE func5_AI_lo_lo_alm_state
{
    LABEL		[limit_state];
    HELP		[limit_lo_lo_state_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[limit_state_NO_ALARM]		},
        {	1,	[limit_state_LO_LO]			}
    }
    HANDLING	READ;
}


VARIABLE func5_AI_lo_lo_alm_time_stamp
{
    LABEL		[limit_time_stamp];
    HELP		[limit_time_stamp_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		TIME;
    HANDLING	READ;
}


VARIABLE func5_AI_lo_lo_alm_subcode
{
    LABEL		[limit_subcode];
    HELP		[limit_lo_lo_subcode_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (2);
    HANDLING	READ;
}


VARIABLE func5_AI_lo_lo_alm_value
{
    LABEL		[limit_alarm_value];
    HELP		[limit_lo_lo_alarm_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT;
    HANDLING	READ;
}

//--- AI 34 : SIMULATE ----------------------------------------------------------------------------

VARIABLE func5_AI_simulate_value
{
    LABEL		[func_simulate_value];
    HELP		[func_ai_simulate_value_help];
    CLASS		CONTAINED & SERVICE;
    TYPE        FLOAT
    {
        DEFAULT_VALUE	0.0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_simulate_status_quality
{
    LABEL		[status_quality];
    HELP		[func_simulate_status_help];
    CLASS		CONTAINED & SERVICE;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        STATUS_INPUT_NO_RCAS
    }
    POST_EDIT_ACTIONS
    {
        method_set_status_limit_1
    }
    HANDLING	READ & WRITE;
}


func5_AI_simulate_status_limit					LIKE VARIABLE	func5_AI_simulate_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT(func5_AI_simulate_status_quality)
    }
}


VARIABLE func5_AI_simulation_enabled
{
    LABEL		[func_simulation_enabled];
    HELP		[func_simulation_enabled_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[disabled]		},
        {	1,	[enabled]		}
    }
    HANDLING	READ & WRITE;
    POST_READ_ACTIONS
    {
        method_func5_AI_set_global_simulation
    }
}


//--- AI 35 : OUT_UNIT_TEXT -----------------------------------------------------------------------

VARIABLE func5_AI_out_unit_text
{
   LABEL         "";
   HELP          [func_out_unit_text_help];
   CLASS         CONTAINED;
   TYPE          ASCII(16);
   HANDLING      READ & WRITE;
//   VALIDITY		IF( func5_AI_out_unit == 1995 )
//				{
//					TRUE ;
//				}
//				ELSE
//				{
//					FALSE ;
//				}
//
}


//--- AI 45 : SENSOR_ID ---------------------------------------------------------------------------

VARIABLE func5_AI_sensor_id_name
{
   LABEL         [sensor_id_name];
   HELP          [sensor_id_name];
   CLASS         CONTAINED & DYNAMIC;
   TYPE          ASCII(10);
   HANDLING      READ;
}


VARIABLE func5_AI_sensor_id_ser_num
{
   LABEL         [sensor_id_ser_num];
   HELP          [sensor_id_ser_num];
   CLASS         CONTAINED & DYNAMIC;
   TYPE          ASCII(10);
   HANDLING      READ;
}


#ifdef CALIBRATION_PRODUCT

//--- AI 46 : CALPRD_MODE ------------------------------------------------------------------------

VARIABLE func5_AI_calprd_mode
{
    LABEL		"|en|Cal Mode|de|Kalibriermodus";
    HELP		"";
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE 0;
        MODULE_BASED_CALPRD_MODE_LIST(func5_AI_local_module_id)
    }
   HANDLING	IF ( func5_AI_calprd_step < 2 )
                {
                    READ & WRITE;
                }
                ELSE
                {
                    READ;
                }
    VALIDITY MODULE_BASED_CALPRD_MODE_VALIDITY(func5_AI_local_module_id)
}


//--- AI 47 : CALPRD_SAMPLE ----------------------------------------------------------------------

VARIABLE func5_AI_calprd_sample
{
    LABEL		"Prd Cal Sample";
    HELP		"Prd Cal Sample";
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE 0;
    }
    HANDLING	READ & WRITE;
}


//--- AI 48 : CALPRD_STORED_VAL ------------------------------------------------------------------

VARIABLE func5_AI_calprd_stored_val
{
    LABEL		"Sampled value|de|Probenwert";
    HELP		"Product Calibration: Sampled Value";
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
         DISPLAY_FORMAT	DISPLAY_FORMAT_CALPRD_TRUE_VAL(func5_AI_local_calprd_unit)
    }
    HANDLING	READ;
   VALIDITY	IF ( func5_AI_calprd_step == 3 )
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}


//--- AI 49 : CALPRD_TRUE_VAL --------------------------------------------------------------------

VARIABLE func5_AI_calprd_true_val
{
    LABEL		"Lab value|de|Laborwert";
    HELP		"Product Calibration: True Value";
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE 0.0;
         DISPLAY_FORMAT	DISPLAY_FORMAT_CALPRD_TRUE_VAL(func5_AI_local_calprd_unit)
    }
   HANDLING	READ & WRITE;
   VALIDITY	IF ( func5_AI_calprd_step == 3 )
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}


func5_AI_local_calprd_true_val	LIKE VARIABLE func5_AI_calprd_true_val
{
    REDEFINE	CLASS		LOCAL;
}


//--- AI 50 : CALPRD_STEP ------------------------------------------------------------------------

VARIABLE func5_AI_calprd_step
{
    LABEL		"Prd Cal Step";
    HELP		"Prd Cal Step";
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE 0;
    }
    HANDLING	READ;
}


//--- AI 51 : CALPRD_RESULT ----------------------------------------------------------------------

VARIABLE func5_AI_calprd_result
{
    LABEL		"Prd Cal Result";
    HELP		"Prd Cal Result";
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE 0;
    }
    HANDLING	READ;
}

#endif // CALIBRATION_PRODUCT


#ifdef CALIBRATION_PROTOCOL

//--- AI 53 : CALPROT_STATUS ----------------------------------------------------------------------

VARIABLE func5_AI_calprot_status
{
//	LABEL		"CALPROT_STATUS";
    LABEL		"";
    HELP		"CALPROT_STATUS";
    CLASS		CONTAINED & DYNAMIC;
    TYPE		INTEGER (1)
    {
        DEFAULT_VALUE	0;
        {	0,   "kein Protokoll vorhanden"				},
        {	1,   "kein weiteres Protokoll vorhanden"	},
        {	2,   "1 weiteres Protokoll vorhanden"		},
        {	3,   "2 weitere Protokolle vorhanden"		}
    }
    HANDLING	READ;
}

//--- AI 54 : CALPROT_DATA -----------------------------------------------------------------------

VARIABLE func5_AI_calprot_data_item
{
    LABEL		"Calprot Array Item";
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE 0xFF;
    }
    HANDLING	READ;
}

ARRAY func5_AI_calprot_data
{
    LABEL						"Calibration Protocol Array";
    TYPE						func5_AI_calprot_data_item;
    NUMBER_OF_ELEMENTS	PROTO_LENGTH;
}


//--- AI 55 : CALPROT_CONFIRM -----------------------------------------------------------------------

VARIABLE func5_AI_calprot_confirm
{
    LABEL		"CALPROT_CONFIRM";
    HELP		"CALPROT_CONFIRM";
    CLASS		CONTAINED;
    TYPE		INTEGER (1)
    {
        DEFAULT_VALUE	0;
        {	0,   "NOP"				},
        {	1,   "Confirm"			},
        {	2,   "Rewind"			}
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_local_calprot_text
{
// 	LABEL		"Protokoll";
     LABEL		"";
     HELP		"Protokoll";
     CLASS		LOCAL;
    STYLE		"MULTILINE 40 18";
     TYPE		ASCII (2048)
     {
         DEFAULT_VALUE	"|en|No protocol|de|Kein Protokoll";
     }
     HANDLING	READ;
}

GRID func5_AI_local_calprot_grid
{

    LABEL		"";	
    VECTORS	
	{
		{[TXT_DESCRIPTION], func5_CalProtocol_Attributes},
		{[TXT_VALUE], func5_CalProtocol_Values}
	}	 
}

ARRAY func5_CalProtocol_Attributes
{
  LABEL               "Entry";
  NUMBER_OF_ELEMENTS  PROTO_GRID_ROWS;
  TYPE                CalProtocol_Attribute;
}
ARRAY func5_CalProtocol_Values
{
  LABEL               "Entry";
  NUMBER_OF_ELEMENTS  PROTO_GRID_ROWS;
  TYPE                CalProtocol_Attribute;
}
#endif // CALIBRATION_PROTOCOL

VARIABLE func5_AI_local_module_adr
{
    LABEL		"|en|Module|de|Modul";
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        CONFIGURATION_BASED_MODULE_LIST
    }
    HANDLING	READ;
}


VARIABLE func5_AI_local_module_id
{
    LABEL		FUNC5_AI_CHANNEL_LABEL+" Module Type";
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        MODULE_LIST
    }
    HANDLING	READ;
}


#ifdef CALIBRATION_PRODUCT
VARIABLE func5_AI_local_calprd_info_txt
{
    LABEL		"Info";
    STYLE		"MULTILINE 30 4";
    CLASS		LOCAL;
    TYPE		ASCII (100)
    {
        DEFAULT_VALUE	"";
    }
    HANDLING	READ & WRITE;
}


VARIABLE func5_AI_local_calprd_unit
{
    LABEL		[digital_units];
    HELP		[digital_units_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (2)
    {
        UNIT_LIST_COMPA
    }
    HANDLING	READ & WRITE;
}
#endif // CALIBRATION_PRODUCT

//-------------------------------------------------------------------------------------------------
//    COMMAND (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- AI 00 : BLOCK_OBJECT ------------------------------------------------------------------------

COMMAND read_func5_AI_blk
{
    BLOCK func5_AI_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_blk_reserve,
            func5_AI_blk_object,
            func5_AI_blk_parent_class,
            func5_AI_blk_class,
            func5_AI_blk_dd_reference,
            func5_AI_blk_dd_rev,
            func5_AI_blk_profile,
            func5_AI_blk_profile_rev,
            func5_AI_blk_execution_time,
            func5_AI_blk_num_parameters,
            func5_AI_blk_index_view_1,
            func5_AI_blk_num_view_lists
        }
    }
}


//--- AI 01 : ST_REV ------------------------------------------------------------------------------

COMMAND read_func5_AI_st_rev
{
    BLOCK func5_AI_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_st_rev
        }
    }
}


//--- AI 02 : TAG_DESC ----------------------------------------------------------------------------

COMMAND read_func5_AI_tag_desc
{
    BLOCK func5_AI_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_tag_desc
        }
    }
}


COMMAND write_func5_AI_tag_desc
{
    BLOCK func5_AI_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_tag_desc
        }
        REPLY
        {
        }
    }
}


//--- AI 03 : STRATEGY ----------------------------------------------------------------------------

COMMAND read_func5_AI_strategy
{
    BLOCK func5_AI_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_strategy
        }
    }
}


COMMAND write_func5_AI_strategy
{
    BLOCK func5_AI_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_strategy
        }
        REPLY
        {
        }
    }
}


//--- AI 04 : ALERT_KEY ---------------------------------------------------------------------------

COMMAND read_func5_AI_alert_key
{
    BLOCK func5_AI_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_alert_key
        }
    }
}


COMMAND write_func5_AI_alert_key
{
    BLOCK func5_AI_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_alert_key
        }
        REPLY
        {
        }
    }
}


//--- AI 05 : TARGET_MODE -------------------------------------------------------------------------

COMMAND read_func5_AI_target_mode
{
    BLOCK func5_AI_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_target_mode
        }
    }
}


COMMAND write_func5_AI_target_mode
{
    BLOCK func5_AI_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_target_mode
        }
        REPLY
        {
        }
    }
}


//--- AI 06 : MODE_BLK ----------------------------------------------------------------------------

COMMAND read_func5_AI_mode
{
    BLOCK func5_AI_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func5_AI_actual_mode,
             func5_AI_permitted_mode,
             func5_AI_normal_mode
        }
    }
}


//--- AI 07 : ALARM_SUM ---------------------------------------------------------------------------

COMMAND read_func5_AI_alarm
{
    BLOCK func5_AI_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_current_state_alarm_sum,
            func5_AI_unacknowledged_state_alarm_sum,
            func5_AI_unreported_state_alarm_sum,
            func5_AI_disabled_state_alarm_sum
        }
    }
}


//--- AI 08 : BATCH -------------------------------------------------------------------------------

COMMAND read_func5_AI_batch_information
{
    BLOCK func5_AI_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_batch_id,
            func5_AI_batch_unit,
            func5_AI_batch_operation,
            func5_AI_batch_phase
        }
    }
}

COMMAND write_func5_AI_batch_information
{
    BLOCK func5_AI_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_batch_id,
            func5_AI_batch_unit,
            func5_AI_batch_operation,
            func5_AI_batch_phase
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (AI Parameter)
//-------------------------------------------------------------------------------------------------

//--- AI 10 : OUT ---------------------------------------------------------------------------------

COMMAND read_func5_AI_out
{
    BLOCK func5_AI_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_out_value,
            func5_AI_out_status_quality	<0xFC>,
            func5_AI_out_status_limit		<0x03>,
        }
    }
}


COMMAND write_func5_AI_out
{
    BLOCK func5_AI_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_out_value,
            func5_AI_out_status_quality	<0xFC>,
            func5_AI_out_status_limit		<0x03>,
        }
        REPLY
        {
        }
    }
}


//--- AI 11 : PV_SCALE ----------------------------------------------------------------------------

COMMAND read_func5_AI_pv
{
    BLOCK func5_AI_block;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_pv_upper_range_value,
            func5_AI_pv_lower_range_value
        }
    }
}


COMMAND write_func5_AI_pv
{
    BLOCK func5_AI_block;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_pv_upper_range_value,
            func5_AI_pv_lower_range_value
        }
        REPLY
        {
        }
    }
}


//--- AI 12 : OUT_SCALE ---------------------------------------------------------------------------

COMMAND read_func5_AI_out_scale
{
    BLOCK func5_AI_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_out_upper_range_value,
            func5_AI_out_lower_range_value,
            func5_AI_out_unit,
            func5_AI_out_decimal_point
        }
    }
}


COMMAND write_func5_AI_out_scale
{
    BLOCK func5_AI_block;
    INDEX 12;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_out_upper_range_value,
            func5_AI_out_lower_range_value,
            func5_AI_out_unit,
            func5_AI_out_decimal_point
        }
        REPLY
        {
        }
    }
}


//--- AI 13 : LIN_TYPE ----------------------------------------------------------------------------

COMMAND read_func5_AI_lin_type
{
    BLOCK func5_AI_block;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_lin_type
        }
    }
}


COMMAND write_func5_AI_lin_type
{
    BLOCK func5_AI_block;
    INDEX 13;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_lin_type
        }
        REPLY
        {
        }
    }
}


//--- AI 14 : CHANNEL -----------------------------------------------------------------------------

COMMAND read_func5_AI_channel
{
    BLOCK func5_AI_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_channel
        }
    }
}


COMMAND write_func5_AI_channel
{
    BLOCK func5_AI_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_channel
        }
        REPLY
        {
        }
    }
}


//--- AI 16 : PV_FTIME ----------------------------------------------------------------------------

COMMAND read_func5_AI_pv_ftime
{
    BLOCK func5_AI_block;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_pv_ftime
        }
    }
}


COMMAND write_func5_AI_pv_ftime
{
    BLOCK func5_AI_block;
    INDEX 16;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_pv_ftime
        }
        REPLY
        {
        }
    }
}


//--- AI 17 : FSAFE_TYPE --------------------------------------------------------------------------

COMMAND read_func5_AI_FSafeType
{
    BLOCK func5_AI_block;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_FSafeType
        }
    }
}


COMMAND write_func5_AI_FSafeType
{
    BLOCK func5_AI_block;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_FSafeType
        }
        REPLY
        {
        }
    }
}


//--- AI 18 : FSAFE_VALUE -------------------------------------------------------------------------

COMMAND read_func5_AI_FSafeValue
{
    BLOCK func5_AI_block;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_FSafeValue
        }
    }
}


COMMAND write_func5_AI_FSafeValue
{
    BLOCK func5_AI_block;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_FSafeValue
        }
        REPLY
        {
        }
    }
}


//--- AI 19 : ALARM_HYS ---------------------------------------------------------------------------

COMMAND read_func5_AI_alarm_hys
{
    BLOCK func5_AI_block;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_alarm_hys
        }
    }
}


COMMAND write_func5_AI_alarm_hys
{
    BLOCK func5_AI_block;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_alarm_hys
        }
        REPLY
        {
        }
    }
}


//--- AI 21 : HI_HI_LIM ---------------------------------------------------------------------------

COMMAND read_func5_AI_hi_hi_lim
{
    BLOCK func5_AI_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_hi_hi_lim
        }
    }
}


COMMAND write_func5_AI_hi_hi_lim
{
    BLOCK func5_AI_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_hi_hi_lim
        }
        REPLY
        {
        }
    }
}


//--- AI 23 : HI_LIM ------------------------------------------------------------------------------

COMMAND read_func5_AI_hi_lim
{
    BLOCK func5_AI_block;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_hi_lim
        }
    }
}


COMMAND write_func5_AI_hi_lim
{
    BLOCK func5_AI_block;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_hi_lim
        }
        REPLY
        {
        }
    }
}


//--- AI 25 : LO_LIM ------------------------------------------------------------------------------

COMMAND read_func5_AI_lo_lim
{
    BLOCK func5_AI_block;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_lo_lim
        }
    }
}


COMMAND write_func5_AI_lo_lim
{
    BLOCK func5_AI_block;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_lo_lim
        }
        REPLY
        {
        }
    }
}


//--- AI 27 : LO_LO_LIM ---------------------------------------------------------------------------

COMMAND read_func5_AI_lo_lo_lim
{
    BLOCK func5_AI_block;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_lo_lo_lim
        }
    }
}

COMMAND write_func5_AI_lo_lo_lim
{
    BLOCK func5_AI_block;
    INDEX 27;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_lo_lo_lim
        }
        REPLY
        {
        }
    }
}


//--- AI 30 : HI_HI_ALM ---------------------------------------------------------------------------

COMMAND read_func5_AI_hi_hi_alm
{
    BLOCK func5_AI_block;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_hi_hi_alm_unacknowledged,
            func5_AI_hi_hi_alm_state,
            func5_AI_hi_hi_alm_time_stamp,
            func5_AI_hi_hi_alm_subcode,
            func5_AI_hi_hi_alm_value
        }
    }
}


//--- AI 31 : HI_ALM ------------------------------------------------------------------------------

COMMAND read_func5_AI_hi_alm
{
    BLOCK func5_AI_block;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_hi_alm_unacknowledged,
            func5_AI_hi_alm_state,
            func5_AI_hi_alm_time_stamp,
            func5_AI_hi_alm_subcode,
            func5_AI_hi_alm_value
        }
    }
}


//--- AI 32 : LO_ALM ------------------------------------------------------------------------------

COMMAND read_func5_AI_lo_alm
{
    BLOCK func5_AI_block;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_lo_alm_unacknowledged,
            func5_AI_lo_alm_state,
            func5_AI_lo_alm_time_stamp,
            func5_AI_lo_alm_subcode,
            func5_AI_lo_alm_value
        }
    }
}


//--- AI 33 : LO_LO_ALM ---------------------------------------------------------------------------

COMMAND read_func5_AI_lo_lo_alm
{
    BLOCK func5_AI_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_lo_lo_alm_unacknowledged,
            func5_AI_lo_lo_alm_state,
            func5_AI_lo_lo_alm_time_stamp,
            func5_AI_lo_lo_alm_subcode,
            func5_AI_lo_lo_alm_value
        }
    }
}


//--- AI 34 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func5_AI_simulate
{
    BLOCK func5_AI_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_simulate_status_quality		<0xFC>,
            func5_AI_simulate_status_limit		<0x03>,
            func5_AI_simulate_value,
            func5_AI_simulation_enabled
        }
    }
}


COMMAND write_func5_AI_simulate
{
    BLOCK func5_AI_block;
    INDEX 34;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_simulate_status_quality		<0xFC>,
            func5_AI_simulate_status_limit		<0x03>,
            func5_AI_simulate_value,
            func5_AI_simulation_enabled
        }
        REPLY
        {
        }
    }
}


//--- AI 35 : OUT_UNIT_TEXT -----------------------------------------------------------------------

COMMAND  read_func5_AI_out_unit_text
{
     BLOCK func5_AI_block;
     INDEX 35;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
               func5_AI_out_unit_text
          }
     }
}


COMMAND  write_func5_AI_out_unit_text
{
     BLOCK func5_AI_block;
     INDEX 35;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
               func5_AI_out_unit_text
          }
          REPLY
          {
          }
     }
}


//--- AI 45 : SENSOR_ID ---------------------------------------------------------------------------

COMMAND read_func5_AI_sensor_id
{
    BLOCK func5_AI_block;
    INDEX 45;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_sensor_id_name,
            func5_AI_sensor_id_ser_num
        }
    }
}


#ifdef CALIBRATION_PRODUCT

//--- AI 46 : CALPRD_MODE ------------------------------------------------------------------------

COMMAND  read_func5_AI_calprd_mode
{
     BLOCK func5_AI_block;
     INDEX 46;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
               func5_AI_calprd_mode
          }
     }
}


COMMAND  write_func5_AI_calprd_mode
{
     BLOCK func5_AI_block;
     INDEX 46;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
               func5_AI_calprd_mode
          }
          REPLY
          {
          }
     }
}


//--- AI 47 : CALPRD_SAMPLE ----------------------------------------------------------------------

COMMAND  read_func5_AI_calprd_sample
{
     BLOCK func5_AI_block;
     INDEX 47;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
               func5_AI_calprd_sample
          }
     }
}


COMMAND  write_func5_AI_calprd_sample
{
     BLOCK func5_AI_block;
     INDEX 47;
     OPERATION WRITE;
      RESPONSE_CODES
      {
              0x00A9, MISC_ERROR, "alles scheisse", "help me please!" ;
      }
     TRANSACTION
     {
          REQUEST
          {
               func5_AI_calprd_sample
          }
          REPLY
          {
          }
     }
}


//--- AI 48 : CALPRD_STORED_VAL ------------------------------------------------------------------

COMMAND  read_func5_AI_calprd_stored_val
{
     BLOCK func5_AI_block;
     INDEX 48;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
               func5_AI_calprd_stored_val
          }
     }
}


//--- AI 49 : CALPRD_TRUE_VAL --------------------------------------------------------------------

COMMAND  read_func5_AI_calprd_true_val
{
     BLOCK func5_AI_block;
     INDEX 49;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
               func5_AI_calprd_true_val
          }
     }
}


COMMAND  write_func5_AI_calprd_true_val
{
     BLOCK func5_AI_block;
     INDEX 49;
     OPERATION WRITE;
     TRANSACTION
     {
          REQUEST
          {
               func5_AI_calprd_true_val
          }
          REPLY
          {
          }
     }
}


//--- AI 50 : CALPRD_STEP ------------------------------------------------------------------------

COMMAND  read_func5_AI_calprd_step
{
     BLOCK func5_AI_block;
     INDEX 50;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
               func5_AI_calprd_step
          }
     }
}


//--- AI 51 : CALPRD_RESULT ----------------------------------------------------------------------

COMMAND  read_func5_AI_calprd_result
{
     BLOCK func5_AI_block;
     INDEX 51;
     OPERATION READ;
     TRANSACTION
     {
          REQUEST
          {
          }
          REPLY
          {
               func5_AI_calprd_result
          }
     }
}

#endif // CALIBRATION_PRODUCT


#ifdef CALIBRATION_PROTOCOL
//--- AI 53 : CALPROT_STATUS -----------------------------------------------------------------------

COMMAND read_func5_AI_calprot_status
{
    BLOCK func5_AI_block;
    INDEX 53;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_calprot_status
        }
    }
}

//--- AI 56 : CALPROT_DATA -----------------------------------------------------------------------
// bis COMPA 2.3 war das AI 54
COMMAND read_func5_AI_calprot_data
{
    BLOCK func5_AI_block;
    INDEX 56;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_calprot_data
        }
    }
}

//--- AI 55 : CALPROT_CONFIRM -----------------------------------------------------------------------

COMMAND read_func5_AI_calprot_confirm
{
    BLOCK func5_AI_block;
    INDEX 55;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func5_AI_calprot_confirm
        }
    }
}


COMMAND write_func5_AI_calprot_confirm
{
    BLOCK func5_AI_block;
    INDEX 55;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func5_AI_calprot_confirm
        }
        REPLY
        {
        }
    }
}

#endif // CALIBRATION_PROTOCOL

//-------------------------------------------------------------------------------------------------
//    UNIT
//-------------------------------------------------------------------------------------------------

UNIT FUNC5_AI_OUT_SCALE_UNIT
{
    func5_AI_out_unit:

    func5_AI_out_value,
    func5_AI_out_upper_range_value,
    func5_AI_out_lower_range_value,
    func5_AI_alarm_hys,
    func5_AI_hi_hi_lim,
    func5_AI_hi_lim,
    func5_AI_lo_lim,
    func5_AI_lo_lo_lim,
    func5_AI_hi_hi_alm_value,
    func5_AI_hi_alm_value,
    func5_AI_lo_alm_value,
    func5_AI_lo_lo_alm_value,
    func5_AI_FSafeValue
}


UNIT FUNC5_AI_PV_SCALE_UNIT
{
    FUNC5_AI_PV_SCALE_UNIT_REFERENCE:

    func5_AI_pv_upper_range_value,
    func5_AI_pv_lower_range_value,
    func5_AI_simulate_value
}


#ifdef CALIBRATION_PRODUCT

UNIT UNIT_FUNC5_AI_CALPRD
{
    func5_AI_local_calprd_unit:

    func5_AI_calprd_stored_val,
    func5_AI_local_calprd_true_val
}

#endif // CALIBRATION_PRODUCT


//-------------------------------------------------------------------------------------------------
//    COLLECTION
//-------------------------------------------------------------------------------------------------

COLLECTION OF VARIABLE func5_AI_blank
{
    MEMBERS
    {
        actual_mode,			func5_AI_actual_mode,			" " ;
        simulation_enabled,	func5_AI_simulation_enabled,	" " ;
        out,						func5_AI_out_value,				" " ;
        lo_lo_alm_state,		func5_AI_lo_lo_alm_state,		" " ;
        lo_alm_state,			func5_AI_lo_alm_state,			" " ;
        hi_alm_state,			func5_AI_hi_alm_state,			" " ;
        hi_hi_alm_state,		func5_AI_hi_hi_alm_state,		" " ;
        lo_lo_alm_value,		func5_AI_lo_lo_alm_value,		" " ;
        lo_alm_value,			func5_AI_lo_alm_value,			" " ;
        hi_alm_value,			func5_AI_hi_alm_value,			" " ;
        hi_hi_alm_value,		func5_AI_hi_hi_alm_value,		" " ;
    }
}


//-------------------------------------------------------------------------------------------------
//		METHOD
//-------------------------------------------------------------------------------------------------

METHOD method_set_status_limit_1
{
    LABEL "";
    CLASS		INPUT;
    DEFINITION
    {
        int	quality;
        int block_mode;			/* !!! temp.: bis Methoden mit Aufrufparametern funktionieren !!! */

        quality = ivar_value(func5_AI_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func5_AI_simulate_status_limit, 0);

        block_mode	= ivar_value(func5_AI_target_mode);
        quality		= ivar_value(func5_AI_out_status_quality);
        if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func5_AI_out_status_limit, 0);
    }
}


METHOD method_check_func5_AI_alarm_hys
{
    LABEL "";
    CLASS		INPUT;
    DEFINITION
    {
        float	hi_hi_lim, lo_lo_lim, hyst, hyst_new, fDiff ;
        long	var_id[2];

        hi_hi_lim = fvar_value(func5_AI_hi_hi_lim);
        lo_lo_lim = fvar_value(func5_AI_lo_lo_lim);
        fDiff = hi_hi_lim-lo_lo_lim;
        hyst = fvar_value(func5_AI_alarm_hys);

        if( fDiff < 0 )
            fDiff = - fDiff;

        if ((hyst < 0) || (hyst >= fDiff) )
        {
            hyst_new = fDiff * 0.05;
            fassign (func5_AI_alarm_hys, hyst_new);
            var_id[0] = VARID (func5_AI_alarm_hys);
            var_id[1] = VARID (func5_AI_out_unit);
            acknowledge ([alert_alarm_hys],var_id);
        }
    }
}


METHOD method_func5_AI_set_global_simulation
{
    LABEL "";
    CLASS		DYNAMIC;
    DEFINITION
    {
        int  simu_ena, man_ena;

        simu_ena	= ivar_value( func5_AI_simulation_enabled );
        man_ena	= ivar_value( func5_AI_actual_mode 			);

        if ( (simu_ena == 1) || (man_ena == 0x10) )
        {
            lokal_global_simulation |= FUNC5_AI_GLOBAL_SIMULATION_MASK;
        }
        else
        {
            lokal_global_simulation &= ~FUNC5_AI_GLOBAL_SIMULATION_MASK;
        }
    }
}


#ifdef CALIBRATION_PRODUCT
METHOD method_func5_AI_set_calprd_info_txt( unsigned char calprd_step )
{
    LABEL "";
    CLASS		INPUT;
    DEFINITION
    {
        switch( calprd_step )
        {
            case 0 :
            case 1 :		func5_AI_local_calprd_info_txt = "Please take a sample."
                                                                        "|de|Bitte speichern Sie eine Probe.";
                                                                        break;
            case 3 :		func5_AI_local_calprd_info_txt = "A sample has already been taken. Please enter the true value (lab value) now."
                                                                        "|de|Es wurde bereits eine Probe gespeichert. Bitte geben Sie nun den richtigen Wert (Laborwert) ein.";
                                                                        break;
            case 255 :	func5_AI_local_calprd_info_txt = "This module does not support product calibration."
                    "|de|Dieses Modul untersttzt keine Produktkalibrierung.";
                                                                        break;
        }
    }
}


METHOD method_func5_AI_init_menu_calprd
{
    LABEL "";
    CLASS		INPUT;
    DEFINITION
    {
        method_get_channel_mapping( FUNC5_AI_CHANNEL_NBR );
        method_get_prdcal_unit( FUNC5_AI_CHANNEL_NBR );
        method_func5_AI_set_calprd_info_txt( func5_AI_calprd_step );
        func5_AI_local_calprd_true_val = 0.0;
    }
}


METHOD method_func5_AI_take_sample
{
    LABEL		"Take a sample|de|Probe nehmen";
    CLASS		INPUT;
    DEFINITION
    {
        int i, j;

        WriteCommand( write_func5_AI_calprd_mode );

        func5_AI_calprd_sample = 1;
        WriteCommand( write_func5_AI_calprd_sample );

        i = 0;
        j = 0;
        while ( ( i < 50 ) && ( j < 3 ) )
        {
            ReadCommand( read_func5_AI_calprd_step );
            j = func5_AI_calprd_step;
            i++;
        }

        ReadCommand( read_func5_AI_calprd_stored_val );

        method_func5_AI_set_calprd_info_txt( func5_AI_calprd_step );
        method_get_prdcal_unit( FUNC5_AI_CHANNEL_NBR );
        func5_AI_local_calprd_true_val = 0.0;
    }
   VALIDITY	IF ( func5_AI_calprd_step <= 1 )
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}


METHOD method_func5_AI_set_true_val
{
    LABEL		"Set lab value|de|Laborwert setzen";
    CLASS		INPUT;
    DEFINITION
    {
        int i, j;

        func5_AI_calprd_true_val = func5_AI_local_calprd_true_val;
        WriteCommand( write_func5_AI_calprd_true_val );

        i = 0;
        j = 3;
        while ( ( i < 10 ) && ( j > 1 ) )
        {
            ReadCommand( read_func5_AI_calprd_step );
            j = func5_AI_calprd_step;
            i++;
        }

        DELAY_TIME(2);
        ReadCommand( read_func5_AI_calprd_result );

        if( func5_AI_calprd_result == 0 )
        {
            func5_AI_local_calprd_info_txt = "Calibration successful!|de|Kalibrierung erfolgreich!";
        }
        else
        {
            func5_AI_local_calprd_info_txt = "Calibration not successful!|de|Kalibrierung fehlgeschlagen!";
        }
    }
   VALIDITY	IF ( func5_AI_calprd_step == 3 )
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}


METHOD method_func5_AI_prdcal_cancel
{
    LABEL		"Cancel product calibration|de|Kalibrierung abbrechen";
    CLASS		INPUT;
    DEFINITION
    {
        func5_AI_calprd_true_val = -1e32;
        WriteCommand( write_func5_AI_calprd_true_val );
        method_func5_AI_set_calprd_info_txt( 1 );
    }
   VALIDITY	IF ( func5_AI_calprd_step == 3 )
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}
#endif // CALIBRATION_PRODUCT

#ifdef CALIBRATION_PROTOCOL

METHOD func5_method_calprot_read_all() 
{
    LABEL    [TXT_REFRESH];
    CLASS INPUT;
    DEFINITION
    {		
		method_calprot_read_all(FUNC5_AI_CHANNEL_NBR);
	}
}
#endif // CALIBRATION_PROTOCOL

//-------------------------------------------------------------------------------------------------
//		MENU (Output)
//-------------------------------------------------------------------------------------------------

MENU Page_display_func5_AI
{
    LABEL		FUNC5_AI_TITLE;
    ITEMS
    {
#ifdef FUNCX_AI_TAG_IN_PAGE_DISPLAY
        func5_AI_tag_desc						(READ_ONLY),
#endif
        Group_display_sensor_id_func5_AI,
//		func5_AI_sensor_id_name,
//		func5_AI_sensor_id_ser_num,
        HoriBarChart_func5_AI_out,
        Group_display_func5_AI_out,
        Group_display_func5_AI_simulation
    }
}


MENU Group_display_sensor_id_func5_AI
{
    LABEL		"Sensor";
    ITEMS
    {
        func5_AI_sensor_id_name,
        SEPARATOR,
        func5_AI_sensor_id_ser_num
    }
    VALIDITY IF ( (func5_AI_sensor_id_name == "") && (func5_AI_sensor_id_ser_num == "") )
                {
                    FALSE;
                }
                ELSE
                {
                    TRUE;
                }
}


CHART HoriBarChart_func5_AI_out
{
    LABEL [func_out_value];
    TYPE HORIZONTAL_BAR;
    WIDTH MEDIUM;
    HEIGHT MEDIUM;
    CYCLE_TIME 3000;
    MEMBERS
    {
        SOURCE1, Value_func5_AI_out;
    }
}
SOURCE Value_func5_AI_out
{
    LABEL [func_out_value];
    Y_AXIS Axis_func5_AI_out;
    MEMBERS
    {
        MONITOR1, func5_AI_out_value;
    }
}
AXIS Axis_func5_AI_out
{
    LABEL [func_out_value];
    MIN_VALUE func5_AI_out_lower_range_value;
    MAX_VALUE func5_AI_out_upper_range_value;
}

MENU Group_display_func5_AI_out
{
    LABEL		[menu_dialog_display_output];
    ITEMS
    {
        func5_AI_out_status_quality		(READ_ONLY),
        func5_AI_out_status_limit			(READ_ONLY),
        SEPARATOR,
        func5_AI_current_state_alarm_sum
    }
}


MENU Group_display_func5_AI_simulation
{
    LABEL		[menu_OnlineWindow_func_display_simulation] ;
    ITEMS
    {
        func5_AI_simulation_enabled 		(READ_ONLY),
        SEPARATOR,
        func5_AI_actual_mode 				(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU OnlineDialog_simulation_func5_AI
{
    LABEL		FUNC5_AI_TITLE ;
    ITEMS
    {
        Page_simulation_input_func5_AI,
        Page_simulation_output_func5_AI
    }
}


MENU Page_simulation_input_func5_AI
{
    LABEL		[menu_dialog_simulation_input];
    ITEMS
    {
        func5_AI_simulation_enabled,
        Group_simulate_input_func5_AI,
        method_set
    }
}


MENU Group_simulate_input_func5_AI
{
    LABEL		[func_simulate_value];
    ITEMS
    {
        func5_AI_simulate_value,
        SEPARATOR,
        func5_AI_simulate_status_quality,
        func5_AI_simulate_status_limit
    }
}


MENU Page_simulation_output_func5_AI
{
    LABEL		[menu_dialog_simulation_output];
    ITEMS
    {
        func5_AI_target_mode,
        func5_AI_actual_mode,
        Group_simulate_output_func5_AI,
        method_set
    }
}


MENU Group_simulate_output_func5_AI
{
    LABEL		[func_out_value];
    ITEMS
    {
        func5_AI_out_value,
        SEPARATOR,
        func5_AI_out_status_quality,
        func5_AI_out_status_limit
    }
}


#ifdef CALIBRATION_PRODUCT
//-------------------------------------------------------------------------------------------------
//    MENU (Calibration)
//-------------------------------------------------------------------------------------------------


MENU func5_Group_cal_not_supported
{
    LABEL FUNC5_AI_CHANNEL_LABEL;
	//STYLE GROUP;
    ITEMS
    { 				
		[str_cal_unsupported_sensor]
    }    
	VALIDITY IF ( func5_AI_local_module_id == 40) {TRUE;} ELSE {FALSE;} 
}


MENU Page_calprd_func5_AI
{
    LABEL		FUNC5_AI_CHANNEL_LABEL;
    ITEMS
    {
        func5_AI_local_module_adr,
        func5_AI_local_calprd_info_txt,
        Group_calprd_take_sample_func5_AI
    }
    PRE_EDIT_ACTIONS
    {
        method_func5_AI_init_menu_calprd
    }
}


MENU Group_calprd_take_sample_func5_AI
{
    LABEL		"";
    ITEMS
    {
        func5_AI_calprd_mode,
        method_func5_AI_take_sample,
        func5_AI_calprd_stored_val,
        func5_AI_local_calprd_true_val,
        method_func5_AI_set_true_val,
        method_func5_AI_prdcal_cancel,
        func5_AI_calprd_step	(HIDDEN)
    }
}


MENU Page_calprd_func5_AI_Test
{
    LABEL		FUNC5_AI_CHANNEL_LABEL+" Test";
    ITEMS
    {
        func5_AI_calprd_mode,
        func5_AI_calprd_sample,
        func5_AI_calprd_step,
        func5_AI_calprd_result
    }
}

#endif // CALIBRATION_PRODUCT


#ifdef CALIBRATION_PROTOCOL

MENU Page_calprot_func5_AI
{
    LABEL		FUNC5_AI_CHANNEL_LABEL;
    ITEMS
    {
		phys_software_rev_str(HIDDEN),
		phys_software_rev_numeric(HIDDEN),
		
		IF (phys_software_rev_numeric >= 204000) {
			
			func5_AI_local_module_adr,
			func5_AI_calprot_status,        
			func5_AI_local_calprot_grid,
			func5_method_calprot_read_all
		}
		ELSE {
			
			Group_calprot_not_supported
		}
    }
    POST_READ_ACTIONS
    {
        method_get_channel_mapping( FUNC5_AI_CHANNEL_NBR )
		IF (phys_software_rev_numeric >= 204000) {
			func5_method_calprot_read_all
		}
    }
}


#endif // CALIBRATION_PROTOCOL


//-------------------------------------------------------------------------------------------------
//    MENU (Alarm)
//-------------------------------------------------------------------------------------------------
MENU OnlineWindow_S_alarm_func5_AI
{
    LABEL		FUNC5_AI_TITLE ;
    ITEMS
    {
        Page_alarm_overview_func5_AI,
        Page_alarm_sum_func5_AI,
        Page_alarm_hi_hi_alm_func5_AI,
        Page_alarm_hi_alm_func5_AI,
        Page_alarm_lo_alm_func5_AI,
        Page_alarm_lo_lo_alm_func5_AI
    }
}



MENU OnlineWindow_M_alarm_func5_AI
{
    LABEL		FUNC5_AI_TITLE ;
    ITEMS
    {
        Page_alarm_overview_func5_AI,
        Page_alarm_sum_func5_AI,
        Page_alarm_hi_hi_alm_func5_AI,
        Page_alarm_hi_alm_func5_AI,
        Page_alarm_lo_alm_func5_AI,
        Page_alarm_lo_lo_alm_func5_AI
    }
}


MENU Page_alarm_overview_func5_AI
{
    LABEL [menu_dialog_overview] ;
    HELP  [dialog_alarm_overview_help] ;
    ITEMS
    {
        func5_AI_hi_hi_lim 	(READ_ONLY),
        func5_AI_hi_lim 		(READ_ONLY),
        func5_AI_lo_lim 		(READ_ONLY),
        func5_AI_lo_lo_lim 	(READ_ONLY),
        SEPARATOR,
        func5_AI_blank.hi_hi_alm_state,
        func5_AI_blank.hi_alm_state,
        func5_AI_blank.lo_alm_state,
        func5_AI_blank.lo_lo_alm_state
        SEPARATOR,
        func5_AI_blank.hi_hi_alm_value,
        func5_AI_blank.hi_alm_value,
        func5_AI_blank.lo_alm_value,
        func5_AI_blank.lo_lo_alm_value
    }
}


MENU Page_alarm_sum_func5_AI
{
    LABEL		[menu_dialog_alarm_sum];
    ITEMS
    {
        func5_AI_current_state_alarm_sum,
//		func5_AI_unacknowledged_state_alarm_sum,
//		SEPARATOR,
//		func5_AI_unreported_state_alarm_sum,
//		func5_AI_disabled_state_alarm_sum
    }
}


MENU Page_alarm_hi_hi_alm_func5_AI
{
    LABEL		[limit_hi_hi];
    ITEMS
    {
        func5_AI_hi_hi_alm_unacknowledged,
        func5_AI_hi_hi_alm_state,
        /* func5_AI_hi_hi_alm_time_stamp,		*/
        func5_AI_hi_hi_alm_subcode,
        func5_AI_hi_hi_lim				(READ_ONLY),
        func5_AI_hi_hi_alm_value
    }
}

MENU Page_alarm_hi_alm_func5_AI
{
    LABEL		[limit_hi];
    ITEMS
    {
        func5_AI_hi_alm_unacknowledged,
        func5_AI_hi_alm_state,
        /* func5_AI_hi_alm_time_stamp,		*/
        func5_AI_hi_alm_subcode,
        func5_AI_hi_lim				(READ_ONLY),
        func5_AI_hi_alm_value
    }
}

MENU Page_alarm_lo_alm_func5_AI
{
    LABEL		[limit_lo];
    ITEMS
    {
        func5_AI_lo_alm_unacknowledged,
        func5_AI_lo_alm_state,
        /* func5_AI_lo_alm_time_stamp,		*/
        func5_AI_lo_alm_subcode,
        func5_AI_lo_lim				(READ_ONLY),
        func5_AI_lo_alm_value
    }
}

MENU Page_alarm_lo_lo_alm_func5_AI
{
    LABEL		[limit_lo_lo];
    ITEMS
    {
        func5_AI_lo_lo_alm_unacknowledged,
        func5_AI_lo_lo_alm_state,
        /* func5_AI_lo_lo_alm_time_stamp,		*/
        func5_AI_lo_lo_alm_subcode,
        func5_AI_lo_lo_lim				(READ_ONLY),
        func5_AI_lo_lo_alm_value
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Diagnosis)
//-------------------------------------------------------------------------------------------------

MENU Page_diagnosis_func5_AI
{
    LABEL		FUNC5_AI_TITLE ;
    ITEMS
    {
        func5_AI_blk_object,
        func5_AI_blk_parent_class,
        func5_AI_blk_class,
        func5_AI_blk_dd_reference,
        func5_AI_blk_dd_rev,
        func5_AI_blk_profile,
        func5_AI_blk_profile_rev,
        func5_AI_st_rev,
        func5_AI_actual_mode,
        func5_AI_simulation_enabled (READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Parameter Table)
//-------------------------------------------------------------------------------------------------

MENU Tab_s_func5_AI_Output
{
    LABEL		"Output" "|de|Ausgang";
    ITEMS
    {
        func5_AI_st_rev,
        func5_AI_tag_desc,

        func5_AI_out_unit					(READ_ONLY),
#ifndef NO_func5_AI_out_unit_text
        func5_AI_out_unit_text,
#endif
        func5_AI_pv_ftime,
        Tab_s_func5_AI_batch,
        Tab_s_func5_AI_pv_range,
        Tab_s_func5_AI_outscale,
        Tab_s_func5_AI_limits,
        Tab_s_func5_AI_FSafe,
        Tab_s_func5_AI_interface
    }
}


MENU Tab_m_func5_AI_Output
{
    LABEL		"Output" "|de|Ausgang";
    ITEMS
    {
        func5_AI_st_rev,
        func5_AI_tag_desc 				(READ_ONLY),

        func5_AI_out_unit					(READ_ONLY),
#ifndef NO_func5_AI_out_unit_text
        func5_AI_out_unit_text,			(READ_ONLY),
#endif
        func5_AI_pv_ftime					(READ_ONLY),
        Tab_s_func5_AI_batch,
        Tab_s_func5_AI_pv_range			(READ_ONLY),
        Tab_s_func5_AI_outscale			(READ_ONLY),
        Tab_s_func5_AI_limits			(READ_ONLY),
        Tab_s_func5_AI_FSafe				(READ_ONLY),
        Tab_s_func5_AI_interface
    }
}


MENU Tab_s_func5_AI_batch
{
    LABEL		[menu_ident_batch_info];
    ITEMS
    {
            func5_AI_batch_id,
            func5_AI_batch_unit,
            func5_AI_batch_operation,
            func5_AI_batch_phase
    }
}

MENU Tab_s_func5_AI_pv_range
{
    LABEL		[menu_input_measwindow];
    ITEMS
    {
        func5_AI_pv_lower_range_value,
        func5_AI_pv_upper_range_value
    }
}

MENU Tab_s_func5_AI_outscale
{
    LABEL		[menu_output_scalewindow];
    ITEMS
    {
        func5_AI_out_lower_range_value,
        func5_AI_out_upper_range_value,
    }
}

MENU Tab_s_func5_AI_FSafe
{
    LABEL [menu_fail_safe] ;
    ITEMS
    {
        func5_AI_FSafeType,
        func5_AI_FSafeValue
    }
}


MENU Tab_m_func5_AI_pv_range
{
    LABEL		[menu_input_measwindow];
    ITEMS
    {
        func5_AI_pv_lower_range_value	(READ_ONLY),
        func5_AI_pv_upper_range_value	(READ_ONLY)
    }
}

MENU Tab_m_func5_AI_outscale
{
    LABEL		[menu_output_scalewindow];
    ITEMS
    {
        func5_AI_out_lower_range_value	(READ_ONLY),
        func5_AI_out_upper_range_value	(READ_ONLY)
    }
}

MENU Tab_m_func5_AI_FSafe
{
    LABEL [menu_fail_safe] ;
    ITEMS
    {
        func5_AI_FSafeType	(READ_ONLY),
        func5_AI_FSafeValue	(READ_ONLY)
    }
}


MENU Tab_s_func5_AI_limits
{
    LABEL		[menu_output_limits];
    ITEMS
    {
        func5_AI_lo_lo_lim,
        func5_AI_lo_lim,
        func5_AI_hi_lim,
        func5_AI_hi_hi_lim,
        func5_AI_alarm_hys
    }
}


MENU Tab_m_func5_AI_limits
{
    LABEL		[menu_output_limits];
    ITEMS
    {
        func5_AI_lo_lo_lim (READ_ONLY),
        func5_AI_lo_lim (READ_ONLY),
        func5_AI_hi_lim (READ_ONLY),
        func5_AI_hi_hi_lim (READ_ONLY),
        func5_AI_alarm_hys (READ_ONLY)
    }
}


MENU Tab_s_func5_AI_interface
{
    LABEL		[menu_interface];
    ITEMS
    {
        func5_AI_out_decimal_point
    }
}


//--- AI 00 : BLOCK_OBJECT ------------------------------------------------------------------------
//--- AI 01 : ST_REV ------------------------------------------------------------------------------
//--- AI 02 : TAG_DESC ----------------------------------------------------------------------------
//--- AI 03 : STRATEGY ----------------------------------------------------------------------------
//--- AI 04 : ALERT_KEY ---------------------------------------------------------------------------
//--- AI 05 : TARGET_MODE -------------------------------------------------------------------------
//--- AI 06 : MODE_BLK ----------------------------------------------------------------------------
//--- AI 07 : ALARM_SUM ---------------------------------------------------------------------------
//--- AI 08 : BATCH -------------------------------------------------------------------------------
//--- AI 10 : OUT ---------------------------------------------------------------------------------
//--- AI 11 : PV_SCALE ----------------------------------------------------------------------------
//--- AI 12 : OUT_SCALE ---------------------------------------------------------------------------
//--- AI 13 : LIN_TYPE ----------------------------------------------------------------------------
//--- AI 14 : CHANNEL -----------------------------------------------------------------------------
//--- AI 16 : PV_FTIME ----------------------------------------------------------------------------
//--- AI 17 : FSAFE_TYPE --------------------------------------------------------------------------
//--- AI 18 : FSAFE_VALUE -------------------------------------------------------------------------
//--- AI 19 : ALARM_HYS ---------------------------------------------------------------------------
//--- AI 21 : HI_HI_LIM ---------------------------------------------------------------------------
//--- AI 23 : HI_LIM ------------------------------------------------------------------------------
//--- AI 25 : LO_LIM ------------------------------------------------------------------------------
//--- AI 27 : LO_LO_LIM ---------------------------------------------------------------------------
//--- AI 30 : HI_HI_ALM ---------------------------------------------------------------------------
//--- AI 31 : HI_ALM ------------------------------------------------------------------------------
//--- AI 32 : LO_ALM ------------------------------------------------------------------------------
//--- AI 33 : LO_LO_ALM ---------------------------------------------------------------------------
//--- AI 34 : SIMULATE ----------------------------------------------------------------------------
//--- AI 35 : OUT_UNIT_TEXT -----------------------------------------------------------------------
//--- AI 46 : CALPRD_MODE ------------------------------------------------------------------------
//--- AI 47 : CALPRD_SAMPLE ----------------------------------------------------------------------
//--- AI 48 : CALPRD_STORED_VAL ------------------------------------------------------------------
//--- AI 49 : CALPRD_TRUE_VAL --------------------------------------------------------------------
//--- AI 50 : CALPRD_STEP ------------------------------------------------------------------------
//--- AI 51 : CALPRD_RESULT ----------------------------------------------------------------------

//		func5_AI_blk_reserve
//		func5_AI_blk_object
//		func5_AI_blk_parent_class
//		func5_AI_blk_class
//		func5_AI_blk_dd_reference
//		func5_AI_blk_dd_rev
//		func5_AI_blk_profile
//		func5_AI_blk_profile_rev
//		func5_AI_blk_execution_time
//		func5_AI_blk_num_parameters
//		func5_AI_blk_index_view_1
//		func5_AI_blk_num_view_lists
//		func5_AI_st_rev
//		func5_AI_tag_desc
//		func5_AI_strategy
//		func5_AI_alert_key
//		func5_AI_target_mode
//		func5_AI_actual_mode
//		func5_AI_permitted_mode
//		func5_AI_normal_mode
//		func5_AI_current_state_alarm_sum
//		func5_AI_unacknowledged_state_alarm_sum
//		func5_AI_unreported_state_alarm_sum
//		func5_AI_disabled_state_alarm_sum
//		func5_AI_batch_id
//		func5_AI_batch_unit
//		func5_AI_batch_operation
//		func5_AI_batch_phase
//		func5_AI_out_value
//		func5_AI_out_status_quality
//		func5_AI_out_status_limit
//		func5_AI_pv_upper_range_value
//		func5_AI_pv_lower_range_value
//		func5_AI_out_upper_range_value
//		func5_AI_out_lower_range_value
//		func5_AI_out_unit
//		func5_AI_out_decimal_point
//		func5_AI_lin_type
//		func5_AI_channel
//		func5_AI_pv_ftime
//		func5_AI_FSafeType
//		func5_AI_FSafeValue
//		func5_AI_alarm_hys
//		func5_AI_hi_hi_lim
//		func5_AI_hi_lim
//		func5_AI_lo_lim
//		func5_AI_lo_lo_lim
//		func5_AI_hi_hi_alm_unacknowledged
//		func5_AI_hi_hi_alm_state
//		func5_AI_hi_hi_alm_time_stamp
//		func5_AI_hi_hi_alm_subcode
//		func5_AI_hi_hi_alm_value
//		func5_AI_hi_alm_unacknowledged
//		func5_AI_hi_alm_state
//		func5_AI_hi_alm_time_stamp
//		func5_AI_hi_alm_subcode
//		func5_AI_hi_alm_value
//		func5_AI_lo_alm_unacknowledged
//		func5_AI_lo_alm_state
//		func5_AI_lo_alm_time_stamp
//		func5_AI_lo_alm_subcode
//		func5_AI_lo_alm_value
//		func5_AI_lo_lo_alm_unacknowledged
//		func5_AI_lo_lo_alm_state
//		func5_AI_lo_lo_alm_time_stamp
//		func5_AI_lo_lo_alm_subcode
//		func5_AI_lo_lo_alm_value
//		func5_AI_simulate_value
//		func5_AI_simulate_status_quality
//		func5_AI_simulate_status_limit
//		func5_AI_simulation_enabled
//		func5_AI_out_unit_text
//		func5_AI_calprd_mode
//		func5_AI_calprd_sample
//		func5_AI_calprd_stored_val
//		func5_AI_calprd_true_val
//		func5_AI_calprd_step
//		func5_AI_calprd_result






