
/*
 * $Id$
 * 
 * Copyright (C) PI 2007-2012. All rights reserved.
 * 
 * Version: 2.0.5
 * 
 */

/**
 * \file 0000_4402_0302_0001.ddl
 * \brief Function Block Discrete Output 'V3.02'.
 * This file contains all definitions for Function Block Discrete Output Profile Version 3.02
 * 
 * \section func2_DI_import How to import
 * For use of all mandatory parameters for a Class A device use the macro USE_FUNC2_DO_MANDATORY_A.
 * For use of all mandatory parameters for a Class B device use the macro USE_FUNC2_DO_MANDATORY_B.
 * Use 'EVERYTHING' for importing of all available parameters
 * 
 * Example for Class B:
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC2_DO, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
 * {
 *   USE_FUNC2_DO_MANDATORY_B;
 * }
 * \endcode 
 * 
 * \section func2_DO_def_list This file contains the following definitions
 * \subsection func2_DO_def_list_variable List of Variables
 * - func2_DO_BLOCK_OBJECT_Reserved
 * - func2_DO_BLOCK_OBJECT_Block_Object
 * - func2_DO_BLOCK_OBJECT_Parent_Class
 * - func2_DO_BLOCK_OBJECT_Class
 * - func2_DO_BLOCK_OBJECT_Dev_Rev
 * - func2_DO_BLOCK_OBJECT_Dev_Rev_Comp
 * - func2_DO_BLOCK_OBJECT_DD_Revision
 * - func2_DO_BLOCK_OBJECT_Profile
 * - func2_DO_BLOCK_OBJECT_Profile_Revision
 * - func2_DO_BLOCK_OBJECT_Execution_Time
 * - func2_DO_BLOCK_OBJECT_Number_of_Parameters
 * - func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
 * - func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index
 * - func2_DO_BLOCK_OBJECT_Number_of_Views
 * - func2_DO_ST_REV
 * - func2_DO_TAG_DESC
 * - func2_DO_STRATEGY
 * - func2_DO_ALERT_KEY
 * - func2_DO_TARGET_MODE
 * - func2_DO_MODE_BLK_Actual
 * - func2_DO_MODE_BLK_Permitted
 * - func2_DO_MODE_BLK_Normal
 * - func2_DO_ALARM_SUM_Current
 * - func2_DO_ALARM_SUM_Unacknowledged
 * - func2_DO_ALARM_SUM_Unreported
 * - func2_DO_ALARM_SUM_Disabled
 * - func2_DO_BATCH_Batch_ID
 * - func2_DO_BATCH_Rup
 * - func2_DO_BATCH_Operation
 * - func2_DO_BATCH_Phase
 * - func2_DO_SP_D_Value
 * - func2_DO_SP_D_Status_Condensed
 * - func2_DO_SP_D_Status_Quality
 * - func2_DO_SP_D_Status_Limit
 * - func2_DO_OUT_D_Value
 * - func2_DO_OUT_D_Status_Condensed
 * - func2_DO_OUT_D_Status_Quality
 * - func2_DO_OUT_D_Status_Limit
 * - func2_DO_READBACK_D_Value
 * - func2_DO_READBACK_D_Status_Condensed
 * - func2_DO_READBACK_D_Status_Quality
 * - func2_DO_READBACK_D_Status_Limit
 * - func2_DO_RCAS_IN_D_Value
 * - func2_DO_RCAS_IN_D_Status_Condensed
 * - func2_DO_RCAS_IN_D_Status_Quality
 * - func2_DO_RCAS_IN_D_Status_Limit
 * - func2_DO_IN_CHANNEL
 * - func2_DO_INVERT
 * - func2_DO_FSAFE_TIME
 * - func2_DO_FSAFE_TYPE
 * - func2_DO_FSAFE_VAL_D
 * - func2_DO_RCAS_OUT_D_Value
 * - func2_DO_RCAS_OUT_D_Status_Condensed
 * - func2_DO_RCAS_OUT_D_Status_Quality
 * - func2_DO_RCAS_OUT_D_Status_Limit
 * - func2_DO_SIMULATE_Status_Condensed
 * - func2_DO_SIMULATE_Value
 * - func2_DO_SIMULATE_Enabled
 * - func2_DO_SIMULATE_Status_Quality
 * - func2_DO_SIMULATE_Status_Limit
 * - func2_DO_CHECK_BACK
 * - func2_DO_CHECK_BACK_MASK
 * - func2_DO_OUT_CHANNEL
 * .
 * \subsection func2_DO_def_list_command List of Commands
 * - func2_DO_BLOCK_OBJECT_read
 * - func2_DO_ST_REV_read
 * - func2_DO_TAG_DESC_read
 * - func2_DO_TAG_DESC_write
 * - func2_DO_STRATEGY_read
 * - func2_DO_STRATEGY_write
 * - func2_DO_ALERT_KEY_read
 * - func2_DO_ALERT_KEY_write
 * - func2_DO_TARGET_MODE_read
 * - func2_DO_TARGET_MODE_write
 * - func2_DO_MODE_BLK_read
 * - func2_DO_ALARM_SUM_read
 * - func2_DO_BATCH_read
 * - func2_DO_BATCH_write
 * - func2_DO_SP_D_read
 * - func2_DO_SP_D_write
 * - func2_DO_OUT_D_read
 * - func2_DO_OUT_D_write
 * - func2_DO_READBACK_D_read
 * - func2_DO_RCAS_IN_D_read
 * - func2_DO_RCAS_IN_D_write
 * - func2_DO_IN_CHANNEL_read
 * - func2_DO_IN_CHANNEL_write
 * - func2_DO_INVERT_read
 * - func2_DO_INVERT_write
 * - func2_DO_FSAFE_TIME_read
 * - func2_DO_FSAFE_TIME_write
 * - func2_DO_FSAFE_TYPE_read
 * - func2_DO_FSAFE_TYPE_write
 * - func2_DO_FSAFE_VAL_D_read
 * - func2_DO_FSAFE_VAL_D_write
 * - func2_DO_RCAS_OUT_D_read
 * - func2_DO_SIMULATE_read
 * - func2_DO_SIMULATE_write
 * - func2_DO_CHECK_BACK_read
 * - func2_DO_CHECK_BACK_MASK_read
 * - func2_DO_OUT_CHANNEL_read
 * - func2_DO_OUT_CHANNEL_write
 * .
 * \subsection func2_DO_def_list_menu List of Menus
 * - func2_DO_BLOCK_OBJECT_page
 * - func2_DO_ST_REV_page
 * - func2_DO_TAG_DESC_page
 * - func2_DO_STRATEGY_page
 * - func2_DO_ALERT_KEY_page
 * - func2_DO_TARGET_MODE_page
 * - func2_DO_MODE_BLK_page
 * - func2_DO_ALARM_SUM_page
 * - func2_DO_BATCH_page
 * - func2_DO_SP_D_page
 * - func2_DO_OUT_D_page
 * - func2_DO_READBACK_D_page
 * - func2_DO_RCAS_IN_D_page
 * - func2_DO_IN_CHANNEL_page
 * - func2_DO_INVERT_page
 * - func2_DO_FSAFE_TIME_page
 * - func2_DO_FSAFE_TYPE_page
 * - func2_DO_FSAFE_VAL_D_page
 * - func2_DO_RCAS_OUT_D_page
 * - func2_DO_SIMULATE_page
 * - func2_DO_CHECK_BACK_page
 * - func2_DO_CHECK_BACK_MASK_page
 * - func2_DO_OUT_CHANNEL_page
 * - func2_DO_VIEW_1_page
 * - func2_DO_VIEW_2_page
 * - func2_DO_VIEW_3_page
 * .
 * \subsection func2_DO_def_list_method List of Methods
 * - None
 * .
 *
 * \section func2_DO_upload_download Upload and Download
 * \subsection func2_DO_upload_download_upload Upload
 * To upload the VARIABLEs you can use the following macro definition:
 * \code
 * func2_DO_BLOCK_OBJECT_Reserved,                   // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Block_Object,               // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Parent_Class,               // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Class,                      // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Dev_Rev,                    // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Dev_Rev_Comp,               // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_DD_Revision,                // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Profile,                    // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Profile_Revision,           // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Execution_Time,             // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Number_of_Parameters,       // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot,     // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index,    // Mand A, Mand B
 * func2_DO_BLOCK_OBJECT_Number_of_Views,            // Mand A, Mand B
 * func2_DO_ST_REV,                                  // Mand A, Mand B
 * func2_DO_TAG_DESC,                                // Mand A, Mand B
 * func2_DO_STRATEGY,                                // Mand A, Mand B
 * func2_DO_ALERT_KEY,                               // Mand A, Mand B
 * func2_DO_TARGET_MODE,                             // Mand A, Mand B
 * func2_DO_MODE_BLK_Actual,                         // Mand A, Mand B
 * func2_DO_MODE_BLK_Permitted,                      // Mand A, Mand B
 * func2_DO_MODE_BLK_Normal,                         // Mand A, Mand B
 * func2_DO_ALARM_SUM_Current,                       // Mand A, Mand B
 * func2_DO_ALARM_SUM_Unacknowledged,                // Mand A, Mand B
 * func2_DO_ALARM_SUM_Unreported,                    // Mand A, Mand B
 * func2_DO_ALARM_SUM_Disabled,                      // Mand A, Mand B
 * func2_DO_BATCH_Batch_ID,                          // Mand A, Mand B
 * func2_DO_BATCH_Rup,                               // Mand A, Mand B
 * func2_DO_BATCH_Operation,                         // Mand A, Mand B
 * func2_DO_BATCH_Phase,                             // Mand A, Mand B
 * func2_DO_SP_D_Value,                              // Mand A, Mand B
 * func2_DO_SP_D_Status_Condensed,                   // Mand A, Mand B
 * func2_DO_OUT_D_Value,                             // Mand B, Opt A
 * func2_DO_OUT_D_Status_Condensed,                  // Mand B, Opt A
 * func2_DO_READBACK_D_Value,                        // Opt A, Opt B
 * func2_DO_READBACK_D_Status_Condensed,             // Opt A, Opt B
 * func2_DO_RCAS_IN_D_Value,                         // Opt A, Opt B
 * func2_DO_RCAS_IN_D_Status_Condensed,              // Opt A, Opt B
 * func2_DO_IN_CHANNEL,                              // Mand B, Opt A
 * func2_DO_INVERT,                                  // Mand A, Mand B
 * func2_DO_FSAFE_TIME,                              // Mand B, Opt A
 * func2_DO_FSAFE_TYPE,                              // Mand B, Opt A
 * func2_DO_FSAFE_VAL_D,                             // Mand B, Opt A
 * func2_DO_RCAS_OUT_D_Value,                        // Opt A, Opt B
 * func2_DO_RCAS_OUT_D_Status_Condensed,             // Opt A, Opt B
 * func2_DO_SIMULATE_Status_Condensed,               // Mand B, Opt A
 * func2_DO_SIMULATE_Value,                          // Mand B, Opt A
 * func2_DO_SIMULATE_Enabled,                        // Mand B, Opt A
 * func2_DO_CHECK_BACK,                              // Mand A, Mand B
 * func2_DO_CHECK_BACK_MASK,                         // Mand A, Mand B
 * func2_DO_OUT_CHANNEL                              // Opt A, Opt B
 * \endcode
 * \subsection func2_DO_upload_download_download Download
 * To download the VARIABLEs you can use the following macro definition:
 * \code
 * func2_DO_TAG_DESC,                      // Mand A, Mand B
 * func2_DO_STRATEGY,                      // Mand A, Mand B
 * func2_DO_ALERT_KEY,                     // Mand A, Mand B
 * func2_DO_TARGET_MODE,                   // Mand A, Mand B
 * func2_DO_BATCH_Batch_ID,                // Mand A, Mand B
 * func2_DO_BATCH_Rup,                     // Mand A, Mand B
 * func2_DO_BATCH_Operation,               // Mand A, Mand B
 * func2_DO_BATCH_Phase,                   // Mand A, Mand B
 * func2_DO_SP_D_Value,                    // Mand A, Mand B
 * func2_DO_SP_D_Status_Condensed,         // Mand A, Mand B
 * func2_DO_OUT_D_Value,                   // Mand B, Opt A
 * func2_DO_OUT_D_Status_Condensed,        // Mand B, Opt A
 * func2_DO_RCAS_IN_D_Value,               // Opt A, Opt B
 * func2_DO_RCAS_IN_D_Status_Condensed,    // Opt A, Opt B
 * func2_DO_IN_CHANNEL,                    // Mand B, Opt A
 * func2_DO_INVERT,                        // Mand A, Mand B
 * func2_DO_FSAFE_TIME,                    // Mand B, Opt A
 * func2_DO_FSAFE_TYPE,                    // Mand B, Opt A
 * func2_DO_FSAFE_VAL_D,                   // Mand B, Opt A
 * func2_DO_SIMULATE_Status_Condensed,     // Mand B, Opt A
 * func2_DO_SIMULATE_Value,                // Mand B, Opt A
 * func2_DO_SIMULATE_Enabled,              // Mand B, Opt A
 * func2_DO_OUT_CHANNEL                    // Opt A, Opt B
 * \endcode
 *
 * \section func2_DO_necessary_changes Necessary changes on variables
 * \subsection func2_DO_Channel_changes func2_DO_CHANNEL
 * To use this parameter in your EDD you must redefine the specific enumeration of this block parameter.
 * \n For example:
 * \code
 * TYPE ENUMERATED(2)
 * {
 *    { 0x0108, "TB 1" },
 *    { 0x0208, "TB 2" }
 * }
 * \endcode
 */

#include "pa_import_0302.h"
#include "pa_status.h"

/** \cond SKIP_THIS */
MANUFACTURER 0x0000, DEVICE_TYPE 0x4402, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
/** \endcond */

BLOCK func2_DO_block
{
	TYPE FUNCTION;
	NUMBER 2;
}

COLLECTION func2_DO_BLOCK_OBJECT
{
	MEMBERS
	{
		Reserved, func2_DO_BLOCK_OBJECT_Reserved;
		Block_Object, func2_DO_BLOCK_OBJECT_Block_Object;
		Parent_Class, func2_DO_BLOCK_OBJECT_Parent_Class;
		Class, func2_DO_BLOCK_OBJECT_Class;
		Dev_Rev, func2_DO_BLOCK_OBJECT_Dev_Rev;
		Dev_Rev_Comp, func2_DO_BLOCK_OBJECT_Dev_Rev_Comp;
		DD_Revision, func2_DO_BLOCK_OBJECT_DD_Revision;
		Profile, func2_DO_BLOCK_OBJECT_Profile;
		Profile_Revision, func2_DO_BLOCK_OBJECT_Profile_Revision;
		Execution_Time, func2_DO_BLOCK_OBJECT_Execution_Time;
		Number_of_Parameters, func2_DO_BLOCK_OBJECT_Number_of_Parameters;
		Address_of_VIEW_1_Slot, func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot;
		Address_of_VIEW_1_Index, func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index;
		Number_of_Views, func2_DO_BLOCK_OBJECT_Number_of_Views;
	}
}

VARIABLE func2_DO_BLOCK_OBJECT_Reserved
{
	LABEL [PI_BLOCK_OBJECT_Reserved_label];
	HELP [PI_BLOCK_OBJECT_Reserved_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_BLOCK_OBJECT_Block_Object
{
	LABEL [PI_BLOCK_OBJECT_Block_Object_label];
	HELP [PI_BLOCK_OBJECT_Block_Object_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 2;
		{ 1, [PI_BLOCK_OBJECT_Block_Object_enum_1] },
		{ 2, [PI_BLOCK_OBJECT_Block_Object_enum_2] },
		{ 3, [PI_BLOCK_OBJECT_Block_Object_enum_3] }
	}
}

VARIABLE func2_DO_BLOCK_OBJECT_Parent_Class
{
	LABEL [PI_BLOCK_OBJECT_Parent_Class_label];
	HELP [PI_BLOCK_OBJECT_Parent_Class_help_1];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 2;
		{ 1, [PI_BLOCK_OBJECT_Parent_Class_enum_1_1] },
		{ 2, [PI_BLOCK_OBJECT_Parent_Class_enum_2_1] },
		{ 3, [PI_BLOCK_OBJECT_Parent_Class_enum_3_1] },
		{ 4, [PI_BLOCK_OBJECT_Parent_Class_enum_4_1] },
		{ 5, [PI_BLOCK_OBJECT_Parent_Class_enum_5_1] },
		{ 6, [PI_BLOCK_OBJECT_Parent_Class_enum_8] },
		{ 7, [PI_BLOCK_OBJECT_Parent_Class_enum_7_1] }
	}
}

VARIABLE func2_DO_BLOCK_OBJECT_Class
{
	LABEL [PI_BLOCK_OBJECT_Class_label];
	HELP [PI_BLOCK_OBJECT_Class_help_1];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 2, [PI_func_DO_BLOCK_OBJECT_Class_enum_2] }
	}
}

VARIABLE func2_DO_BLOCK_OBJECT_Dev_Rev
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func2_DO_BLOCK_OBJECT_Dev_Rev_Comp
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_Comp_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_Comp_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func2_DO_BLOCK_OBJECT_DD_Revision
{
	LABEL [PI_BLOCK_OBJECT_DD_Revision_label];
	HELP [PI_BLOCK_OBJECT_DD_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func2_DO_BLOCK_OBJECT_Profile
{
	LABEL [PI_BLOCK_OBJECT_Profile_label];
	HELP [PI_BLOCK_OBJECT_Profile_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		{ 0x4001, [PI_BLOCK_OBJECT_Profile_enum_0x4001] },
		{ 0x4002, [PI_BLOCK_OBJECT_Profile_enum_0x4002] },
		{ 0x4081, [PI_BLOCK_OBJECT_Profile_enum_0x4081] },
		{ 0x4082, [PI_BLOCK_OBJECT_Profile_enum_0x4082] }
	}
}

VARIABLE func2_DO_BLOCK_OBJECT_Profile_Revision
{
	LABEL [PI_BLOCK_OBJECT_Profile_Revision_label];
	HELP [PI_BLOCK_OBJECT_Profile_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 0x302;
		{ 0x0200, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0200] },
		{ 0x0300, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0300] },
		{ 0x0301, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0301] },
		{ 0x0302, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0302] }
	}
}

VARIABLE func2_DO_BLOCK_OBJECT_Execution_Time
{
	LABEL [PI_BLOCK_OBJECT_Execution_Time_label];
	HELP [PI_BLOCK_OBJECT_Execution_Time_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_BLOCK_OBJECT_Number_of_Parameters
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Parameters_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Parameters_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_label];
	HELP [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Index_label];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_BLOCK_OBJECT_Number_of_Views
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Views_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Views_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_ST_REV
{
	LABEL [PI_ST_REV_label];
	HELP [PI_ST_REV_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func2_DO_TAG_DESC
{
	LABEL [PI_TAG_DESC_label];
	HELP [PI_TAG_DESC_help];
	CLASS CONTAINED;
	TYPE ASCII(32)
	{
		DEFAULT_VALUE " ";
	}
}

VARIABLE func2_DO_STRATEGY
{
	LABEL [PI_STRATEGY_label];
	HELP [PI_STRATEGY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func2_DO_ALERT_KEY
{
	LABEL [PI_ALERT_KEY_label];
	HELP [PI_ALERT_KEY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func2_DO_TARGET_MODE
{
	LABEL [PI_TARGET_MODE_label];
	HELP [PI_TARGET_MODE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0x02, [PI_mode_RCAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION func2_DO_MODE_BLK
{
	MEMBERS
	{
		Actual, func2_DO_MODE_BLK_Actual;
		Permitted, func2_DO_MODE_BLK_Permitted;
		Normal, func2_DO_MODE_BLK_Normal;
	}
}

VARIABLE func2_DO_MODE_BLK_Actual
{
	LABEL [PI_MODE_BLK_Actual_label];
	HELP [PI_MODE_BLK_Actual_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE func2_DO_MODE_BLK_Permitted
{
	LABEL [PI_MODE_BLK_Permitted_label];
	HELP [PI_MODE_BLK_Permitted_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(1)
	{
		DEFAULT_VALUE 0x98;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE func2_DO_MODE_BLK_Normal
{
	LABEL [PI_MODE_BLK_Normal_label];
	HELP [PI_MODE_BLK_Normal_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION func2_DO_ALARM_SUM
{
	MEMBERS
	{
		Current, func2_DO_ALARM_SUM_Current;
		Unacknowledged, func2_DO_ALARM_SUM_Unacknowledged;
		Unreported, func2_DO_ALARM_SUM_Unreported;
		Disabled, func2_DO_ALARM_SUM_Disabled;
	}
}

VARIABLE func2_DO_ALARM_SUM_Current
{
	LABEL [PI_ALARM_SUM_Current_label];
	HELP [PI_ALARM_SUM_Current_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func2_DO_ALARM_SUM_Unacknowledged
{
	LABEL [PI_ALARM_SUM_Unacknowledged_label];
	HELP [PI_ALARM_SUM_Unacknowledged_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func2_DO_ALARM_SUM_Unreported
{
	LABEL [PI_ALARM_SUM_Unreported_label];
	HELP [PI_ALARM_SUM_Unreported_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func2_DO_ALARM_SUM_Disabled
{
	LABEL [PI_ALARM_SUM_Disabled_label];
	HELP [PI_ALARM_SUM_Disabled_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

COLLECTION func2_DO_BATCH
{
	MEMBERS
	{
		Batch_ID, func2_DO_BATCH_Batch_ID;
		Rup, func2_DO_BATCH_Rup;
		Operation, func2_DO_BATCH_Operation;
		Phase, func2_DO_BATCH_Phase;
	}
}

VARIABLE func2_DO_BATCH_Batch_ID
{
	LABEL [PI_BATCH_Batch_ID_label];
	HELP [PI_BATCH_Batch_ID_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(4)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func2_DO_BATCH_Rup
{
	LABEL [PI_BATCH_Rup_label];
	HELP [PI_BATCH_Rup_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func2_DO_BATCH_Operation
{
	LABEL [PI_BATCH_Operation_label];
	HELP [PI_BATCH_Operation_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func2_DO_BATCH_Phase
{
	LABEL [PI_BATCH_Phase_label];
	HELP [PI_BATCH_Phase_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

COLLECTION func2_DO_SP_D
{
	MEMBERS
	{
		Value, func2_DO_SP_D_Value;
		Status_Condensed, func2_DO_SP_D_Status_Condensed;
	}
}

VARIABLE func2_DO_SP_D_Value
{
	LABEL [PI_func_DO_SP_D_Value_label];
	HELP [PI_func_DO_SP_D_Value_help];
	CLASS INPUT & DYNAMIC;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_SP_D_Status_Condensed
{
	LABEL [PI_func_DO_SP_D_Status_Condensed_label];
	CLASS INPUT & DYNAMIC;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func2_DO_SP_D_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func2_DO_SP_D_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

COLLECTION func2_DO_OUT_D
{
	MEMBERS
	{
		Value, func2_DO_OUT_D_Value;
		Status_Condensed, func2_DO_OUT_D_Status_Condensed;
	}
}

VARIABLE func2_DO_OUT_D_Value
{
	LABEL [PI_func_DO_OUT_D_Value_label];
	HELP [PI_OUT_Value_help_1];
	CLASS CONTAINED & DYNAMIC;
	HANDLING IF (func2_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_OUT_D_Status_Condensed
{
	LABEL [PI_OUT_D_Status_Condensed_label];
	CLASS CONTAINED & DYNAMIC;
	HANDLING IF (func2_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_STANDARD_INPUT // rth: an dieser Stelle gibts nur classic status, früherer Wert: PI_STATUS_LIST_WITHOUT_CAS		
	}
}

VARIABLE func2_DO_OUT_D_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING IF (func2_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func2_DO_OUT_D_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING IF (func2_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

COLLECTION func2_DO_READBACK_D
{
	MEMBERS
	{
		Value, func2_DO_READBACK_D_Value;
		Status_Condensed, func2_DO_READBACK_D_Status_Condensed;
	}
}

VARIABLE func2_DO_READBACK_D_Value
{
	LABEL [PI_func_DO_READBACK_D_Value_label];
	HELP [PI_func_DO_READBACK_D_Value_help];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_READBACK_D_Status_Condensed
{
	LABEL [PI_func_DO_READBACK_D_Status_Condensed_label];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func2_DO_READBACK_D_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func2_DO_READBACK_D_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

COLLECTION func2_DO_RCAS_IN_D
{
	MEMBERS
	{
		Value, func2_DO_RCAS_IN_D_Value;
		Status_Condensed, func2_DO_RCAS_IN_D_Status_Condensed;
	}
}

VARIABLE func2_DO_RCAS_IN_D_Value
{
	LABEL [PI_RCAS_IN_Value_label];
	HELP [PI_RCAS_IN_Value_help];
	CLASS INPUT & DYNAMIC;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_RCAS_IN_D_Status_Condensed
{
	LABEL [PI_func_DO_RCAS_IN_D_Status_Condensed_label];
	CLASS INPUT & DYNAMIC;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_ALL
	}
}

VARIABLE func2_DO_RCAS_IN_D_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] },
		{ 0x30, [PI_status_GOOD_RCAS_00] },
		{ 0x31, [PI_status_GOOD_RCAS_01] },
		{ 0x32, [PI_status_GOOD_RCAS_02] },
		{ 0x33, [PI_status_GOOD_RCAS_03] },
		{ 0x35, [PI_status_GOOD_RCAS_05] },
		{ 0x36, [PI_status_GOOD_RCAS_06] },
		{ 0x38, [PI_status_GOOD_RCAS_08] }
	}
}

VARIABLE func2_DO_RCAS_IN_D_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

VARIABLE func2_DO_IN_CHANNEL
{
	LABEL [PI_IN_CHANNEL_label];
	HELP [PI_func_DO_IN_CHANNEL_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, [PI_IDENT_NUMBER_SELECTOR_enum_1] }
	}
}

VARIABLE func2_DO_INVERT
{
	LABEL [PI_func_DO_INVERT_label];
	HELP [PI_func_DO_INVERT_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_WRITE_LOCKING_enum_2457] },
		{ 1, [PI_WRITE_LOCKING_enum_0] }
	}
}

VARIABLE func2_DO_FSAFE_TIME
{
	LABEL [PI_FSAFE_TIME_label];
	HELP [PI_FSAFE_TIME_help];
	CLASS CONTAINED;
	CONSTANT_UNIT [PI_unit_1054];
	TYPE FLOAT
	{
		DEFAULT_VALUE 0;
		MIN_VALUE 0.0;
	}
	VALIDITY IF (func2_DO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
}

VARIABLE func2_DO_FSAFE_TYPE
{
	LABEL [PI_FSAFE_TYPE_label];
	HELP [PI_FSAFE_TYPE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0, [PI_FSAFE_TYPE_enum_0_1] },
		{ 1, [PI_FSAFE_TYPE_enum_1_1] },
		//{ 2, [PI_FSAFE_TYPE_enum_2_1] }
	}
}

VARIABLE func2_DO_FSAFE_VAL_D
{
	LABEL [PI_func_DO_FSAFE_VAL_D_label];
	HELP [PI_FSAFE_VALUE_help_1];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

COLLECTION func2_DO_RCAS_OUT_D
{
	MEMBERS
	{
		Value, func2_DO_RCAS_OUT_D_Value;
		Status_Condensed, func2_DO_RCAS_OUT_D_Status_Condensed;
	}
}

VARIABLE func2_DO_RCAS_OUT_D_Value
{
	LABEL [PI_RCAS_OUT_Value_label];
	HELP [PI_RCAS_OUT_Value_help];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_RCAS_OUT_D_Status_Condensed
{
	LABEL [PI_func_DO_RCAS_OUT_D_Status_Condensed_label];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_ALL
	}
}

VARIABLE func2_DO_RCAS_OUT_D_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] },
		{ 0x30, [PI_status_GOOD_RCAS_00] },
		{ 0x31, [PI_status_GOOD_RCAS_01] },
		{ 0x32, [PI_status_GOOD_RCAS_02] },
		{ 0x33, [PI_status_GOOD_RCAS_03] },
		{ 0x35, [PI_status_GOOD_RCAS_05] },
		{ 0x36, [PI_status_GOOD_RCAS_06] },
		{ 0x38, [PI_status_GOOD_RCAS_08] }
	}
}

VARIABLE func2_DO_RCAS_OUT_D_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

COLLECTION func2_DO_SIMULATE
{
	MEMBERS
	{
		Status_Condensed, func2_DO_SIMULATE_Status_Condensed;
		Value, func2_DO_SIMULATE_Value;
		Enabled, func2_DO_SIMULATE_Enabled;
	}
}

VARIABLE func2_DO_SIMULATE_Status_Condensed
{
	LABEL  [PI_SIMULATE_Status_Condensed_label];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func2_DO_SIMULATE_Value
{
	LABEL [PI_SIMULATE_Value_label];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func2_DO_SIMULATE_Enabled
{
	LABEL [PI_SIMULATE_Enabled_label];
	HELP [PI_SIMULATE_Enabled_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0, [PI_disabled] },
		{ 1, [PI_enabled] }
	}
}

VARIABLE func2_DO_SIMULATE_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_SIMULATE_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func2_DO_SIMULATE_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_SIMULATE_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

#define CB_FAIL_SAFE                  0x00010000 /* Bit  0 */
#define CB_REQ_LOC_OP                 0x00020000 /* Bit  1 */
#define CB_LOCAL_OP                   0x00040000 /* Bit  2 */
#define CB_OVERRIDE                   0x00080000 /* Bit  3 */
#define CB_DISC_DIR                   0x00100000 /* Bit  4 */
#define CB_LEAD_BREAK_VALVE           0x00200000 /* Bit  5 */
#define CB_SHORT_CIRCUIT_VALVE        0x00400000 /* Bit  6 */
#define CB_ACT_OPEN                   0x00000100 /* Bit  8 */
#define CB_ACT_CLOSE                  0x00000200 /* Bit  9 */
#define CB_UPDATE_EVT                 0x00000400 /* Bit 10 */
#define CB_SIMULATE                   0x00000800 /* Bit 11 */
#define CB_CONTR_ERR                  0x00002000 /* Bit 13 */
#define CB_CONTR_INACT                0x00004000 /* Bit 14 */
#define CB_SELFTEST                   0x00008000 /* Bit 15 */
#define CB_TOT_VALVE_TRAV             0x00000001 /* Bit 16 */
#define CB_BREAK_TIME_OPEN_TO_CLOSE   0x00000002 /* Bit 17 */
#define CB_BREAK_TIME_CLOSE_TO_OPEN   0x00000004 /* Bit 18 */
#define CB_CYCLE_TEST                 0x00000008 /* Bit 19 */
#define CB_TRAVEL_TIME_OPEN_TO_CLOSE  0x00000010 /* Bit 20 */
#define CB_TRAVEL_TIME_CLOSE_TO_OPEN  0x00000020 /* Bit 21 */
#define CB_TRAVEL_BLOCKED             0x00000040 /* Bit 22 */
#define CB_ZERO_POINT_ERROR           0x00000080 /* Bit 23 */

VARIABLE func2_DO_CHECK_BACK
{
	LABEL [PI_CHECK_BACK_label];
	HELP [PI_CHECK_BACK_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(3)
	{
		{ 0, [PI_CHECK_BACK_enum_0], [PI_CHECK_BACK_enum_0] }
	}
}

VARIABLE func2_DO_CHECK_BACK_MASK
{
	LABEL [PI_CHECK_BACK_MASK_label];
	HELP [PI_CHECK_BACK_MASK_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE BIT_ENUMERATED(3)
	{
		{ 0, [PI_CHECK_BACK_enum_0], [PI_CHECK_BACK_enum_0] }
	}
}

VARIABLE func2_DO_OUT_CHANNEL
{
	LABEL [PI_IN_CHANNEL_label];
	HELP [PI_func_DO_OUT_CHANNEL_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, [PI_IDENT_NUMBER_SELECTOR_enum_1] }
	}
}

COLLECTION func2_DO_VIEW_1
{
	MEMBERS
	{
		ST_REV, func2_DO_ST_REV;
		MODE_BLK, func2_DO_MODE_BLK;
		ALARM_SUM, func2_DO_ALARM_SUM;
		SP_D, func2_DO_SP_D;
		OUT_D, func2_DO_OUT_D;
		CHECK_BACK, func2_DO_CHECK_BACK;
	}
}

COLLECTION func2_DO_VIEW_2
{
	MEMBERS
	{
		ST_REV, func2_DO_ST_REV;
		MODE_BLK, func2_DO_MODE_BLK;
		ALARM_SUM, func2_DO_ALARM_SUM;
		SP_D, func2_DO_SP_D;
		OUT_D, func2_DO_OUT_D;
		READBACK_D, func2_DO_READBACK_D;
		RCAS_IN_D, func2_DO_RCAS_IN_D;
		RCAS_OUT_D, func2_DO_RCAS_OUT_D;
		SIMULATE, func2_DO_SIMULATE;
		CHECK_BACK, func2_DO_CHECK_BACK;
		CHECK_BACK_MASK, func2_DO_CHECK_BACK_MASK;
	}
}

COLLECTION func2_DO_VIEW_3
{
	MEMBERS
	{
		TAG_DESC, func2_DO_TAG_DESC;
		STRATEGY, func2_DO_STRATEGY;
		ALERT_KEY, func2_DO_ALERT_KEY;
		TARGET_MODE, func2_DO_TARGET_MODE;
		BATCH, func2_DO_BATCH;
		IN_CHANNEL, func2_DO_IN_CHANNEL;
		INVERT, func2_DO_INVERT;
		FSAFE_TIME, func2_DO_FSAFE_TIME;
		FSAFE_TYPE, func2_DO_FSAFE_TYPE;
		FSAFE_VAL_D, func2_DO_FSAFE_VAL_D;
		SIMULATE, func2_DO_SIMULATE;
		OUT_CHANNEL, func2_DO_OUT_CHANNEL;
	}
}

/* simple GUI */

MENU func2_DO_Simple_Dialog_Mandatory_A
{
	LABEL [PI_func2_DO_Simple_Dialog_Mandatory_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func2_DO_BLOCK_OBJECT_page,
		func2_DO_ST_REV_page,
		func2_DO_TAG_DESC_page,
		func2_DO_STRATEGY_page,
		func2_DO_ALERT_KEY_page,
		func2_DO_TARGET_MODE_page,
		func2_DO_MODE_BLK_page,
		func2_DO_ALARM_SUM_page,
		func2_DO_BATCH_page,
		func2_DO_SP_D_page,
		func2_DO_INVERT_page,
		func2_DO_CHECK_BACK_page,
		func2_DO_CHECK_BACK_MASK_page
	}
}

MENU func2_DO_Simple_Dialog_Optional_A
{
	LABEL [PI_func2_DO_Simple_Dialog_Optional_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func2_DO_BLOCK_OBJECT_page,
		func2_DO_ST_REV_page,
		func2_DO_TAG_DESC_page,
		func2_DO_STRATEGY_page,
		func2_DO_ALERT_KEY_page,
		func2_DO_TARGET_MODE_page,
		func2_DO_MODE_BLK_page,
		func2_DO_ALARM_SUM_page,
		func2_DO_BATCH_page,
		func2_DO_SP_D_page,
		func2_DO_OUT_D_page,
		func2_DO_READBACK_D_page,
		func2_DO_RCAS_IN_D_page,
		func2_DO_IN_CHANNEL_page,
		func2_DO_INVERT_page,
		func2_DO_FSAFE_TIME_page,
		func2_DO_FSAFE_TYPE_page,
		func2_DO_FSAFE_VAL_D_page,
		func2_DO_RCAS_OUT_D_page,
		func2_DO_SIMULATE_page,
		func2_DO_CHECK_BACK_page,
		func2_DO_CHECK_BACK_MASK_page,
		func2_DO_OUT_CHANNEL_page,
		func2_DO_VIEW_1_page,
		func2_DO_VIEW_2_page,
		func2_DO_VIEW_3_page
	}
}

MENU func2_DO_Simple_Dialog_Mandatory_B
{
	LABEL [PI_func2_DO_Simple_Dialog_Mandatory_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func2_DO_BLOCK_OBJECT_page,
		func2_DO_ST_REV_page,
		func2_DO_TAG_DESC_page,
		func2_DO_STRATEGY_page,
		func2_DO_ALERT_KEY_page,
		func2_DO_TARGET_MODE_page,
		func2_DO_MODE_BLK_page,
		func2_DO_ALARM_SUM_page,
		func2_DO_BATCH_page,
		func2_DO_SP_D_page,
		func2_DO_OUT_D_page,
		func2_DO_IN_CHANNEL_page,
		func2_DO_INVERT_page,
		func2_DO_FSAFE_TIME_page,
		func2_DO_FSAFE_TYPE_page,
		func2_DO_FSAFE_VAL_D_page,
		func2_DO_SIMULATE_page,
		func2_DO_CHECK_BACK_page,
		func2_DO_CHECK_BACK_MASK_page,
		func2_DO_VIEW_1_page
	}
}

MENU func2_DO_Simple_Dialog_Optional_B
{
	LABEL [PI_func2_DO_Simple_Dialog_Optional_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func2_DO_BLOCK_OBJECT_page,
		func2_DO_ST_REV_page,
		func2_DO_TAG_DESC_page,
		func2_DO_STRATEGY_page,
		func2_DO_ALERT_KEY_page,
		func2_DO_TARGET_MODE_page,
		func2_DO_MODE_BLK_page,
		func2_DO_ALARM_SUM_page,
		func2_DO_BATCH_page,
		func2_DO_SP_D_page,
		func2_DO_OUT_D_page,
		func2_DO_READBACK_D_page,
		func2_DO_RCAS_IN_D_page,
		func2_DO_IN_CHANNEL_page,
		func2_DO_INVERT_page,
		func2_DO_FSAFE_TIME_page,
		func2_DO_FSAFE_TYPE_page,
		func2_DO_FSAFE_VAL_D_page,
		func2_DO_RCAS_OUT_D_page,
		func2_DO_SIMULATE_page,
		func2_DO_CHECK_BACK_page,
		func2_DO_CHECK_BACK_MASK_page,
		func2_DO_OUT_CHANNEL_page,
		func2_DO_VIEW_1_page,
		func2_DO_VIEW_2_page,
		func2_DO_VIEW_3_page
	}
}

MENU func2_DO_BLOCK_OBJECT_page
{
	LABEL [PI_BLOCK_OBJECT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_BLOCK_OBJECT
	}
}

MENU func2_DO_ST_REV_page
{
	LABEL [PI_ST_REV_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_ST_REV
	}
}

MENU func2_DO_TAG_DESC_page
{
	LABEL [PI_TAG_DESC_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_TAG_DESC
	}
}

MENU func2_DO_STRATEGY_page
{
	LABEL [PI_STRATEGY_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_STRATEGY
	}
}

MENU func2_DO_ALERT_KEY_page
{
	LABEL [PI_ALERT_KEY_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_ALERT_KEY
	}
}

MENU func2_DO_TARGET_MODE_page
{
	LABEL [PI_TARGET_MODE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_TARGET_MODE
	}
}

MENU func2_DO_MODE_BLK_page
{
	LABEL [PI_MODE_BLK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_MODE_BLK
	}
}

MENU func2_DO_ALARM_SUM_page
{
	LABEL [PI_ALARM_SUM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_ALARM_SUM
	}
}

MENU func2_DO_BATCH_page
{
	LABEL [PI_BATCH_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_BATCH
	}
}

MENU func2_DO_SP_D_page
{
	LABEL [PI_SP_D_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_SP_D
	}
}

MENU func2_DO_OUT_D_page
{
	LABEL [PI_OUT_D_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_OUT_D
	}
}

MENU func2_DO_READBACK_D_page
{
	LABEL [PI_READBACK_D_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_READBACK_D
	}
}

MENU func2_DO_RCAS_IN_D_page
{
	LABEL [PI_RCAS_IN_D_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_RCAS_IN_D
	}
}

MENU func2_DO_IN_CHANNEL_page
{
	LABEL [PI_IN_CHANNEL_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_IN_CHANNEL
	}
}

MENU func2_DO_INVERT_page
{
	LABEL [PI_INVERT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_INVERT
	}
}

MENU func2_DO_FSAFE_TIME_page
{
	LABEL [PI_FSAFE_TIME_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_FSAFE_TIME
	}
}

MENU func2_DO_FSAFE_TYPE_page
{
	LABEL [PI_FSAFE_TYPE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_FSAFE_TYPE
	}
}

MENU func2_DO_FSAFE_VAL_D_page
{
	LABEL [PI_FSAFE_VAL_D_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_FSAFE_VAL_D
	}
}

MENU func2_DO_RCAS_OUT_D_page
{
	LABEL [PI_RCAS_OUT_D_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_RCAS_OUT_D
	}
}

MENU func2_DO_SIMULATE_page
{
	LABEL [PI_SIMULATE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_SIMULATE
	}
}

MENU func2_DO_CHECK_BACK_page
{
	LABEL [PI_CHECK_BACK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_CHECK_BACK
	}
}

MENU func2_DO_CHECK_BACK_MASK_page
{
	LABEL [PI_CHECK_BACK_MASK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_CHECK_BACK_MASK
	}
}

MENU func2_DO_OUT_CHANNEL_page
{
	LABEL [PI_OUT_CHANNEL_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_OUT_CHANNEL
	}
}

MENU func2_DO_VIEW_1_page
{
	LABEL [PI_VIEW_1_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_VIEW_1
	}
}

MENU func2_DO_VIEW_2_page
{
	LABEL [PI_VIEW_2_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_VIEW_2
	}
}

MENU func2_DO_VIEW_3_page
{
	LABEL [PI_VIEW_3_page_label];
	STYLE PAGE;
	ITEMS
	{
		func2_DO_VIEW_3
	}
}

/* COMMANDs */

COMMAND func2_DO_BLOCK_OBJECT_read
{
	BLOCK func2_DO_block;
	INDEX 0;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_BLOCK_OBJECT_Reserved,
			func2_DO_BLOCK_OBJECT_Block_Object,
			func2_DO_BLOCK_OBJECT_Parent_Class,
			func2_DO_BLOCK_OBJECT_Class,
			func2_DO_BLOCK_OBJECT_Dev_Rev,
			func2_DO_BLOCK_OBJECT_Dev_Rev_Comp,
			func2_DO_BLOCK_OBJECT_DD_Revision,
			func2_DO_BLOCK_OBJECT_Profile,
			func2_DO_BLOCK_OBJECT_Profile_Revision,
			func2_DO_BLOCK_OBJECT_Execution_Time,
			func2_DO_BLOCK_OBJECT_Number_of_Parameters,
			func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Slot,
			func2_DO_BLOCK_OBJECT_Address_of_VIEW_1_Index,
			func2_DO_BLOCK_OBJECT_Number_of_Views
		}
	}
}

COMMAND func2_DO_ST_REV_read
{
	BLOCK func2_DO_block;
	INDEX 1;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_ST_REV
		}
	}
}

COMMAND func2_DO_TAG_DESC_read
{
	BLOCK func2_DO_block;
	INDEX 2;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_TAG_DESC
		}
	}
}

COMMAND func2_DO_TAG_DESC_write
{
	BLOCK func2_DO_block;
	INDEX 2;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_TAG_DESC
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_STRATEGY_read
{
	BLOCK func2_DO_block;
	INDEX 3;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_STRATEGY
		}
	}
}

COMMAND func2_DO_STRATEGY_write
{
	BLOCK func2_DO_block;
	INDEX 3;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_STRATEGY
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_ALERT_KEY_read
{
	BLOCK func2_DO_block;
	INDEX 4;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_ALERT_KEY
		}
	}
}

COMMAND func2_DO_ALERT_KEY_write
{
	BLOCK func2_DO_block;
	INDEX 4;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_ALERT_KEY
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_TARGET_MODE_read
{
	BLOCK func2_DO_block;
	INDEX 5;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_TARGET_MODE
		}
	}
}

COMMAND func2_DO_TARGET_MODE_write
{
	BLOCK func2_DO_block;
	INDEX 5;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_TARGET_MODE
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_MODE_BLK_read
{
	BLOCK func2_DO_block;
	INDEX 6;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_MODE_BLK_Actual,
			func2_DO_MODE_BLK_Permitted,
			func2_DO_MODE_BLK_Normal
		}
	}
}

COMMAND func2_DO_ALARM_SUM_read
{
	BLOCK func2_DO_block;
	INDEX 7;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_ALARM_SUM_Current,
			func2_DO_ALARM_SUM_Unacknowledged,
			func2_DO_ALARM_SUM_Unreported,
			func2_DO_ALARM_SUM_Disabled
		}
	}
}

COMMAND func2_DO_BATCH_read
{
	BLOCK func2_DO_block;
	INDEX 8;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_BATCH_Batch_ID,
			func2_DO_BATCH_Rup,
			func2_DO_BATCH_Operation,
			func2_DO_BATCH_Phase
		}
	}
}

COMMAND func2_DO_BATCH_write
{
	BLOCK func2_DO_block;
	INDEX 8;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_BATCH_Batch_ID,
			func2_DO_BATCH_Rup,
			func2_DO_BATCH_Operation,
			func2_DO_BATCH_Phase
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_SP_D_read
{
	BLOCK func2_DO_block;
	INDEX 9;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_SP_D_Value,
			func2_DO_SP_D_Status_Condensed
		}
	}
}

COMMAND func2_DO_SP_D_write
{
	BLOCK func2_DO_block;
	INDEX 9;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_SP_D_Value,
			func2_DO_SP_D_Status_Condensed
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_OUT_D_read
{
	BLOCK func2_DO_block;
	INDEX 10;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_OUT_D_Value,
			func2_DO_OUT_D_Status_Condensed
		}
	}
}

COMMAND func2_DO_OUT_D_write
{
	BLOCK func2_DO_block;
	INDEX 10;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_OUT_D_Value,
			func2_DO_OUT_D_Status_Condensed
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_READBACK_D_read
{
	BLOCK func2_DO_block;
	INDEX 12;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_READBACK_D_Value,
			func2_DO_READBACK_D_Status_Condensed
		}
	}
}

COMMAND func2_DO_RCAS_IN_D_read
{
	BLOCK func2_DO_block;
	INDEX 14;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_RCAS_IN_D_Value,
			func2_DO_RCAS_IN_D_Status_Condensed
		}
	}
}

COMMAND func2_DO_RCAS_IN_D_write
{
	BLOCK func2_DO_block;
	INDEX 14;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_RCAS_IN_D_Value,
			func2_DO_RCAS_IN_D_Status_Condensed
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_IN_CHANNEL_read
{
	BLOCK func2_DO_block;
	INDEX 17;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_IN_CHANNEL
		}
	}
}

COMMAND func2_DO_IN_CHANNEL_write
{
	BLOCK func2_DO_block;
	INDEX 17;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_IN_CHANNEL
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_INVERT_read
{
	BLOCK func2_DO_block;
	INDEX 18;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_INVERT
		}
	}
}

COMMAND func2_DO_INVERT_write
{
	BLOCK func2_DO_block;
	INDEX 18;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_INVERT
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_FSAFE_TIME_read
{
	BLOCK func2_DO_block;
	INDEX 19;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_FSAFE_TIME
		}
	}
}

COMMAND func2_DO_FSAFE_TIME_write
{
	BLOCK func2_DO_block;
	INDEX 19;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_FSAFE_TIME
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_FSAFE_TYPE_read
{
	BLOCK func2_DO_block;
	INDEX 20;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_FSAFE_TYPE
		}
	}
}

COMMAND func2_DO_FSAFE_TYPE_write
{
	BLOCK func2_DO_block;
	INDEX 20;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_FSAFE_TYPE
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_FSAFE_VAL_D_read
{
	BLOCK func2_DO_block;
	INDEX 21;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_FSAFE_VAL_D
		}
	}
}

COMMAND func2_DO_FSAFE_VAL_D_write
{
	BLOCK func2_DO_block;
	INDEX 21;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_FSAFE_VAL_D
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_RCAS_OUT_D_read
{
	BLOCK func2_DO_block;
	INDEX 22;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_RCAS_OUT_D_Value,
			func2_DO_RCAS_OUT_D_Status_Condensed
		}
	}
}

COMMAND func2_DO_SIMULATE_read
{
	BLOCK func2_DO_block;
	INDEX 24;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_SIMULATE_Status_Condensed,
			func2_DO_SIMULATE_Value,
			func2_DO_SIMULATE_Enabled
		}
	}
}

COMMAND func2_DO_SIMULATE_write
{
	BLOCK func2_DO_block;
	INDEX 24;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_SIMULATE_Status_Condensed,
			func2_DO_SIMULATE_Value,
			func2_DO_SIMULATE_Enabled
		}
		REPLY
		{
		}
	}
}

COMMAND func2_DO_CHECK_BACK_read
{
	BLOCK func2_DO_block;
	INDEX 33;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_CHECK_BACK
		}
	}
}

COMMAND func2_DO_CHECK_BACK_MASK_read
{
	BLOCK func2_DO_block;
	INDEX 34;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_CHECK_BACK_MASK
		}
	}
}

COMMAND func2_DO_OUT_CHANNEL_read
{
	BLOCK func2_DO_block;
	INDEX 35;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DO_OUT_CHANNEL
		}
	}
}

COMMAND func2_DO_OUT_CHANNEL_write
{
	BLOCK func2_DO_block;
	INDEX 35;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func2_DO_OUT_CHANNEL
		}
		REPLY
		{
		}
	}
}

