/* ----------------------------------------------------------------------

FILE_NAME          stratos_menu.ddl



FUNCTIONAL_MODULE_DESCRIPTION

 Einstiegspunkt fr die 3 Standard-Mens
 process_variables_root_menu, diagnostic_root_menu, offline_root_menu

---------------------------------------------------------------------- */

/*******************************************************************************
 *      Menus
 *******************************************************************************/

/*******************************************************************************
 *      Root menus / entry points
 *******************************************************************************/

/*
####################################
Function Block : Online-Windows
####################################
 */
MENU process_variables_root_menu
{
    //
    // Process variables view.
    // One of the three entry points for GUI-based host applications.
    // Provides a "face plate" of the device with access to all
    // process measurements and set points with their quality and
    // interested information for process operators.
    // Standard root menu, supported by:
    // SDC625, AMS, PDM, FDM
    //
    LABEL TXT_PROCESS_VALUES;
    STYLE WINDOW;
    ITEMS
    {
		process_value_overview,
        PageGraph,
		
		display_out_func1_AI,
        display_out_func2_AI,
        display_out_func3_AI,
        display_out_func4_AI,
        display_out_func5_AI,
        display_out_func6_AI,
        display_out_func7_AI,
        display_out_func8_AI,
		
		display_out_func1_DI,
		
		display_out_func1_AO
		

#ifdef STRATOS_DP		
		,display_out_func1_DO,
		display_out_func2_DO
#endif

    }
}
MENU func_display_ai
{
    LABEL [label_process_values] + " (AI1-8)";
    ITEMS
    {
        display_out_func1_AI,
        display_out_func2_AI,
        display_out_func3_AI,
        display_out_func4_AI,
        display_out_func5_AI,
        display_out_func6_AI,
        display_out_func7_AI,
        display_out_func8_AI
    }
}
MENU func_display_ao
{
    LABEL [label_compensation] + " (AO1)";
    ITEMS
    {
		display_out_func1_AO
    }
}
MENU func_display_do
{
    LABEL [label_control] + " (DO1-2)";
    ITEMS
    {
		display_out_func1_DO,
		display_out_func2_DO
    }
}
MENU func_display_di
{
    LABEL [label_digital] + " (DI1)";
    ITEMS
    {
		display_out_func1_DI
    }
}

MENU process_value_overview
{
    LABEL TXT_OVERVIEW;
    STYLE PAGE;
    ITEMS
    {
		refarray_func1_AI_CHANNEL[meas_type] (HIDDEN), 
		refarray_func2_AI_CHANNEL[meas_type] (HIDDEN), 
		refarray_func3_AI_CHANNEL[meas_type] (HIDDEN), 
		refarray_func4_AI_CHANNEL[meas_type] (HIDDEN), 
		refarray_func5_AI_CHANNEL[meas_type] (HIDDEN), 
		refarray_func6_AI_CHANNEL[meas_type] (HIDDEN), 
		refarray_func7_AI_CHANNEL[meas_type] (HIDDEN), 
		refarray_func8_AI_CHANNEL[meas_type] (HIDDEN), 
		phys_FEATURE_Enabled (HIDDEN),
		
        func1_AI_ovw,COLUMNBREAK,
        func2_AI_ovw,ROWBREAK,
        func3_AI_ovw,COLUMNBREAK,
        func4_AI_ovw,ROWBREAK,
        func5_AI_ovw,COLUMNBREAK,
        func6_AI_ovw,ROWBREAK,
        func7_AI_ovw,COLUMNBREAK,
        func8_AI_ovw,ROWBREAK,

        func1_AO_ovw,COLUMNBREAK,

        func1_DI_ovw

#ifdef STRATOS_DP
        ,ROWBREAK,
		func1_DO_ovw,COLUMNBREAK,
        func2_DO_ovw
#endif   
    }
}


MENU PageGraph
{
    LABEL [menu_yt_diagram];
    ITEMS
    {
        meas_type (HIDDEN),
		func1_AI_OUT_SCALE_Units_Index (HIDDEN),
		func2_AI_OUT_SCALE_Units_Index (HIDDEN),
		func3_AI_OUT_SCALE_Units_Index (HIDDEN),
		func4_AI_OUT_SCALE_Units_Index (HIDDEN),
		func5_AI_OUT_SCALE_Units_Index (HIDDEN),
		func6_AI_OUT_SCALE_Units_Index (HIDDEN),
		func7_AI_OUT_SCALE_Units_Index (HIDDEN),
		func8_AI_OUT_SCALE_Units_Index (HIDDEN),
		func1_AO_OUT_SCALE_Units_Index (HIDDEN),

		yt_selector,
		COLUMNBREAK,
		Chart_yt
    }
    PRE_READ_ACTIONS { method_refresh_ai_chanels(99) }
}

CHART Chart_yt
{
    LABEL [menu_yt_diagram];
    TYPE       	STRIP;
    WIDTH      	LARGE;
    HEIGHT     	X_LARGE;
    CYCLE_TIME 	1000; // 1s
    MEMBERS
    {
        IF (0x01 & yt_selector) { CHART1, ai1_value_source; }
        IF (0x02 & yt_selector) { CHART2, ai2_value_source; }
        IF (0x04 & yt_selector) { CHART3, ai3_value_source; }
        IF (0x08 & yt_selector) { CHART4, ai4_value_source; }
        IF (0x10 & yt_selector) { CHART5, ai5_value_source; }
        IF (0x20 & yt_selector) { CHART6, ai6_value_source; }
        IF (0x40 & yt_selector) { CHART7, ai7_value_source; }
        IF (0x80 & yt_selector) { CHART8, ai8_value_source; }
		IF (0x100 & yt_selector){ CHART9, ao1_value_source; }
    }
}


MENU yt_selector_group
{
    LABEL "";
    STYLE   GROUP;
    ITEMS
    {
        yt_selector
    }
}

VARIABLE yt_selector
{
    LABEL "";
    CLASS LOCAL;
    STYLE "MULTILINE 10 23";
    TYPE BIT_ENUMERATED (2)
    {
        DEFAULT_VALUE    0x03;

        {	0x01, [LABEL_AI1] },
        {	0x02, [LABEL_AI2] },
        {	0x04, [LABEL_AI3] },
        {	0x08, [LABEL_AI4] },
        {	0x10, [LABEL_AI5] },
        {	0x20, [LABEL_AI6] },
        {	0x40, [LABEL_AI7] },
        {	0x80, [LABEL_AI8] },
        { 0x0100, [LABEL_AO1] }
    }
}

MENU diagnostic_root_menu
{
    //
    // Diagnostic view.
    // One of the three entry points for GUI-based host applications.
    // Includes views to show the device state and detailed diagnostic
    // information.
    // Standard root menu, supported by:
    // SDC625, AMS, PDM, FDM
    //
    LABEL TXT_DIAGNOSIC_VALUES;
    STYLE WINDOW;
    ITEMS
    {
        iam1_IMData_IM0_page,
        diag_fb_window,
        diag_window,
        sensor_window,
        logbook_page
    }
}


MENU device_root_menu
{
    //
    // Device feature view.
    // One of the three entry points for GUI-based host applications.
    // Includes views to show the device state and detailed diagnostic
    // information.
    // Standard root menu, supported by:
    // SDC625, AMS, PDM, FDM
    //
    LABEL TXT_DEVICE_VALUES;
    STYLE MENU;
    ITEMS
    {
        ident_window,
        device_root_menu_setup,
		simulation_root_menu,
        std_cal_page,
        device_root_menu_lock,
        device_root_menu_reset
    }
}

MENU offline_root_menu
{
    //
    // Entry point for offline operation.
    // One of the three entry points for GUI-based host applications.
    // Includes views to show the device state and detailed diagnostic
    // information.
    // Standard root menu, supported by:
    // SDC625, AMS, PDM, FDM
    //
    LABEL TXT_OFFLINE_VALUES;
    STYLE MENU;
    ITEMS
    {
        ident_window,
        device_root_menu_setup
    }
}

