/* ----------------------------------------------------------------------

 FILE_NAME          sensor.ddl



 FUNCTIONAL_MODULE_DESCRIPTION

 Zeigt die verfgbaren Sensorinfos

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */
#define NO_SENSOR           1
#define SENSOR_PH           0x0000
#define SENSOR_COND         0x0100
#define SENSOR_CONDI        0x0200
#define SENSOR_CC           0x0300
#define SENSOR_DO           0x0400
#define SENSOR_ISFET        0x0500
#define SENSOR_ORP          0x0600

#define SENSOR_PH_ORP       0x4000     // mask: 0xC000
#define SENSOR_PHV1         0x8000     // mask: 0xC000

#define SENSOR_STD          0x0000
#define SENSOR_MS           0x1000
#define SENSOR_ISM          0x2000

#define SENSOR_TRACES       0x3000
#define SENSOR_SUBTRACES    0x4000

#define SMILEY_GOOD         0x0000
#define SMILEY_NEUTRAL      0x0001
#define SMILEY_BAD          0x0002

/* Bilder fr die Smileys anlegen */
IMAGE img_smiley_hq
{
    PATH "SensoFaceGood.png";
    VALIDITY IF (( sensocheck == 1 ) && (smiley_39 == SMILEY_GOOD )) /* nur, wenn  der Smiley gut ist*/
    {
        TRUE;
    }
    ELSE
    {
        FALSE;
    }
}

IMAGE img_smiley_mq
{
    PATH "SensoFaceMedium.png";
    VALIDITY IF (( sensocheck == 1 ) && (smiley_39 == SMILEY_NEUTRAL )) /* nur, wenn  der Smiley neutral ist*/
    {
        TRUE;
    }
    ELSE
    {
        FALSE;
    }
}

IMAGE img_smiley_lq
{
    PATH "SensoFaceBad.png";
    VALIDITY IF (( sensocheck == 1 ) && (smiley_39 == SMILEY_BAD )) /* nur, wenn  der Smiley traurig ist*/
    {
        TRUE;
    }
    ELSE
    {
        FALSE;
    }
}

IMAGE img_memosens
{
    PATH "memo.jpg";
}

/*
 Menuedefinition - Root-Men
 */
/*MENU diagnostic_root_menu
 {
 LABEL   "|en|Diagnostic";
 STYLE MENU;
 ITEMS
 {
 diag_window,
 sensor_window,
 logbook_window
 }
 }*/

/*
 ------------------------------------------------------
 ####   #####   ###    ####
 #   #    #    #   #  #
 #   #    #    #####  # ###
 #   #    #    #   #  #   #
 ####   #####  #   #   ####
 ------------------------------------------------------
 */

/*
 ------------------------------------------------------
 ####  #####  #   #   ####   ###   ####
 #      #      ##  #  #      #   #  #   #
 ###   ###    # # #   ###   #   #  ####
 #  #      #  ##      #  #   #  #   #
 ####   #####  #   #  ####    ###   #   #
 ------------------------------------------------------
 */
MENU sensor_window
{
    LABEL [sensor];
    STYLE PAGE;
    ACCESS ONLINE;
    ITEMS
    {
        sns_status_39 (HIDDEN),	
		current_error (HIDDEN),

		IF (NO_SENSOR == sns_connection_status()) {

            std_cal_page_no_sensor,
        }
		ELSE {
			
			std_sensor_ph_page, 
			std_sensor_cond_page,
			std_sensor_condi_page,
			std_sensor_cc_page,
			std_sensor_oxy_page
		}
    }
    PRE_READ_ACTIONS {method_read_smiley_state}
}

METHOD sns_connection_status
{
    LABEL "";
    CLASS OUTPUT;
	TYPE int;
    DEFINITION
    {
		if (current_error >= 1 && current_error <= 3) {
			return NO_SENSOR;
		}
		return 0;
    }
}
/* -----------------------------------------------------------------
 #### #####  ###  #   # ####   ###  ####  ####
 #       #   #   # ##  # #   # #   # #   # #   #
 ###    #   ##### # # # #   # ##### ####  #   #
 #   #   #   # #  ## #   # #   # # #   #   #
 ####    #   #   # #   # ####  #   # #  #  ####

 Seite "pH"

 Calibration data
 Caltime
 Zero/Offset/Zero ORP
 Slope

 SensorInformation (MS)         SensorInformation (ISM)
 Serial No.                     Serial No.
 Order No.                      Order No.
 TAG

 Sensor Wear
 Runtime
 SIP-Cycles
 CIP-Cycles
 TTM
 DLI
 ACT
 Wear
 Caltimer

 */

MENU std_sensor_info_page_ms
{
    LABEL TXT_DIAG_SNS_INFO;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        img_memosens,
        serial_no_100,
        order_no_100,
        tag_100,
        manu_100,
        init_operation_100
    }
    VALIDITY IF ((sns_status_39 & 0x3000) == SENSOR_MS ) {TRUE;}ELSE {FALSE;}
}

MENU std_sensor_info_page_ism
{
    LABEL TXT_DIAG_SNS_INFO;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        serial_no_100,
        order_no_100
    }
    VALIDITY IF ((sns_status_39 & 0x3000) == SENSOR_ISM ) {TRUE;}ELSE {FALSE;}
}
/* -----------------------------------------------------------------
 ####   #   #
 #   #  #   #
 ####   #####
 #      #   #
 #      #   #
 Caldaten
 Sensorinfo zu digitalen Snesoren
 Verschleissdaten
 -----------------------------------------------------------------
 */
MENU std_sensor_ph_page
{
    LABEL LBL_SENSOR_39 + " " + LBL_MEAS_TYPE_18_VAL_0;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        current_error,
        //std_sensor_smileyDisp,
        std_sensor_ph_page_caldata_std,
        std_sensor_ph_page_caldata_isfet,
        std_sensor_ph_page_caldata_orp,
        std_sensor_info_page_ms,
        std_sensor_info_page_ism,
        /* Sensor wear */
        /* ph */
        std_sensor_wear_ph_page_std,
        std_sensor_wear_ph_page_ms,
        std_sensor_wear_ph_page_ism
    }
    VALIDITY IF ((((sns_status_39 & 0x0F00 ) == SENSOR_PH) ||
				 ((sns_status_39 & 0x0F00 ) == SENSOR_ISFET) ||
				 ((sns_status_39 & 0x0F00 ) == SENSOR_ORP )))
    {   TRUE;}ELSE {FALSE;}
}
/* Caldaten pH Std*/
MENU std_sensor_ph_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
		sensocheck(HIDDEN),
		
        img_smiley_hq, img_smiley_mq, img_smiley_lq,
        cal_timestamp(READ_ONLY),
        ph_cal_zero(READ_ONLY),
        ph_cal_slope(READ_ONLY)
    }
    VALIDITY IF ((sns_status_39 & 0x0F00 ) == SENSOR_PH) {TRUE;}ELSE {FALSE;}
}
/* Caldaten pH Isfet */
MENU std_sensor_ph_page_caldata_isfet
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
		sensocheck(HIDDEN),
		
		img_smiley_hq, img_smiley_mq, img_smiley_lq,
        cal_timestamp(READ_ONLY),
        ph_cal_offset_isfet(READ_ONLY),
        ph_cal_slope(READ_ONLY)
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_ISFET ) {TRUE;}ELSE {FALSE;}
}

/* Caldaten ORP*/
MENU std_sensor_ph_page_caldata_orp
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
		sensocheck(HIDDEN),
		
        img_smiley_hq, img_smiley_mq, img_smiley_lq,
        cal_timestamp(READ_ONLY),
        ph_calzero_orp(READ_ONLY)
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_ORP ) {TRUE;}ELSE {FALSE;}
}

/* Men fr Standard pH */
MENU std_sensor_wear_ph_page_std
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        // cip_cycles_39,// rth: Ronny sagt, CIP/SIP gibts nicht als Anzeige bei analog
        // sip_cycles_39,
        caltimer_39
    }
    VALIDITY IF( (sns_status_39 & 0xF000 ) == SENSOR_STD ) {TRUE;}ELSE {FALSE;}
}

/* Men fr MS pH */
MENU std_sensor_wear_ph_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        sip_cycles_39,

        IF ((sns_status_39 & 0xC000) == SENSOR_PHV1 ||
                (sns_status_39 & 0xC000) == SENSOR_PH_ORP) {

            cip_cycles_39,
        }
        runtime_39,
        dli_39,
        wear_39,
        caltimer_39
    }
    VALIDITY IF ((sns_status_39 & 0x3000) == SENSOR_MS ) {TRUE;}ELSE {FALSE;}

}
/* Men fr ISM pH */
MENU std_sensor_wear_ph_page_ism
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        cip_cycles_39,
        sip_cycles_39,
        autoclave_39,
        runtime_39,
        ttm_39,
        dli_39,
        act_39
    }
    VALIDITY IF( (sns_status_39 & 0x3000 ) == SENSOR_ISM ) {TRUE;}ELSE {FALSE;}
}

/*
 //------------------------------
 //   ###    ###   #   #  ####
 //  #   #  #   #  ##  #  #   #
 //  #      #   #  # # #  #   #
 //  #   #  #   #  #  ##  #   #
 //   ###    ###   #   #  ####

 Caldaten
 Sensorinfo zu digitalen Snesoren
 Verschleissdaten
 //------------------------------
 */
MENU std_sensor_cond_page
{
    LABEL TXT_SENSOR_COND;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        std_sensor_cond_page_caldata_std,
        std_sensor_info_page_ms,
        /* Sensor wear */
        /* Cond */
        std_sensor_wear_cond_page_std,
        std_sensor_wear_cond_page_ms
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_COND ) {TRUE;}ELSE {FALSE;}
}

/* Caldaten Cond*/
MENU std_sensor_cond_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),

        cal_timestamp(READ_ONLY),
        cond_cellconst(READ_ONLY)
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_COND ) {TRUE;}ELSE {FALSE;}
}

/* Men fr Standard Cond */
MENU std_sensor_wear_cond_page_std
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        cip_cycles_39,
        sip_cycles_39
    }
    VALIDITY IF( (sns_status_39 & 0x3000 ) == SENSOR_STD ) {TRUE;}ELSE {FALSE;}
}

/* Men fr MS Cond */
MENU std_sensor_wear_cond_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        cip_cycles_39,
        sip_cycles_39,
        runtime_39,
        dli_39
    }
    VALIDITY IF((sns_status_39 & 0x3000) == SENSOR_MS ) {TRUE;}ELSE {FALSE;}
}

/*
 //------------------------------
 //   ###    ###   #   #  ####   #####
 //  #   #  #   #  ##  #  #   #    #
 //  #      #   #  # # #  #   #    #
 //  #   #  #   #  #  ##  #   #    #
 //   ###    ###   #   #  ####   #####

 Caldaten
 Sensorinfo zu digitalen Snesoren
 Verschleissdaten
 //------------------------------
 */
MENU std_sensor_condi_page
{
    LABEL TXT_SENSOR_CONDI;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        current_error,
        //std_sensor_smileyDisp,
        std_sensor_condi_page_caldata_std,
        std_sensor_info_page_ms,
        /* Sensor wear */
        /* Cond */
        std_sensor_wear_condi_page_std,
        std_sensor_wear_condi_page_ms
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_CONDI ) {TRUE;}ELSE {FALSE;}
}

/* Caldaten CondI*/
MENU std_sensor_condi_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),

        cal_timestamp(READ_ONLY),
        tc_cellfactor(READ_ONLY),
        tc_install(READ_ONLY),
        tc_zero(READ_ONLY),
        tc_trans_ratio(READ_ONLY)
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_CONDI ) {TRUE;}ELSE {FALSE;}
}

/* Men fr Standard CondI */
MENU std_sensor_wear_condi_page_std
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        cip_cycles_39,
        sip_cycles_39
    }
    VALIDITY IF( (sns_status_39 & 0x3000 ) == SENSOR_STD ) {TRUE;}ELSE {FALSE;}
}

/* Men fr MS CondI */
MENU std_sensor_wear_condi_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        cip_cycles_39,
        sip_cycles_39,
        runtime_39,
        dli_39
    }
    VALIDITY IF((sns_status_39 & 0x3000) == SENSOR_MS) {TRUE;}ELSE {FALSE;}
}

/*
 //-------------------------------------
 //   ###    ###
 //  #   #  #   #
 //  #      #
 //  #   #  #   #
 //   ###    ###

 Caldaten
 //-------------------------------------
 */
MENU std_sensor_cc_page
{
    LABEL LBL_SENSOR_39 + " " + LBL_MEAS_TYPE_18_VAL_3;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        std_sensor_cc_page_caldata_std
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_CC ) {TRUE;}ELSE {FALSE;}
}

/* Caldaten CC*/
MENU std_sensor_cc_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        current_error,
        cal_timestamp(READ_ONLY),
        cc_cellfactor_a(READ_ONLY),
        cc_cellfactor_b(READ_ONLY)
    }
}

/* -----------------------------------------------------------------
 //   ###   #   #  #   #
 //  #   #   # #    # #
 //  #   #    #      #
 //  #   #   # #     #
 //   ###   #   #    #
 Caldaten
 Sensorinfo zu digitalen Snesoren
 Verschleissdaten
 -----------------------------------------------------------------
 */
MENU std_sensor_oxy_page
{
    LABEL TXT_SENSOR_DO;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        current_error,
        //std_sensor_smileyDisp,
        std_sensor_oxy_page_caldata_std,
        std_sensor_info_page_ms,
        std_sensor_info_page_ism,
        /* Sensor wear */
        /* ph */
        std_sensor_wear_oxy_page_std,
        std_sensor_wear_oxy_page_ms,
        std_sensor_wear_oxy_page_ism
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_DO ) {TRUE;}ELSE {FALSE;}
}

/* Caldaten Oxy Std*/
MENU std_sensor_oxy_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),

        cal_timestamp(READ_ONLY),
        do_cal_zero(READ_ONLY),
        do_cal_slope(READ_ONLY)
    }
    VALIDITY IF( (sns_status_39 & 0x0F00 ) == SENSOR_DO ) {TRUE;}ELSE {FALSE;}
}

/* Men fr Standard Oxy */
MENU std_sensor_wear_oxy_page_std
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        cip_cycles_39,
        sip_cycles_39,
        caltimer_39
    }
    VALIDITY IF( (sns_status_39 & 0x3000 ) == SENSOR_STD ) {TRUE;}ELSE {FALSE;}
}
/* Men fr MS Oxy */
MENU std_sensor_wear_oxy_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        sip_cycles_39,
        runtime_39,
        dli_39,
        wear_39,
        caltimer_39
    }
    VALIDITY IF((sns_status_39 & 0x3000) == SENSOR_MS ) {TRUE;}ELSE {FALSE;}
}
/* Men fr ISM pH */
MENU std_sensor_wear_oxy_page_ism
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        cip_cycles_39,
        sip_cycles_39,
        autoclave_39,
        runtime_39,
        ttm_39,
        dli_39,
        act_39
    }
    VALIDITY IF( (sns_status_39 & 0x3000 ) == SENSOR_ISM ) {TRUE;}ELSE {FALSE;}
}

/*-------------------------------------------------------------------*/
/*  Methode zum auslesen des Smileystatus  */
/*-------------------------------------------------------------------*/
METHOD method_read_smiley_state
{
    LABEL "";
    CLASS OUTPUT;
    DEFINITION
    {
        ReadCommand(tb1_sensor_read);
    }
}
