/* ----------------------------------------------------------------------

 FILE_NAME          ao1.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
 ###    ###    ###
 #   #  #   #  #  #
 #   #  #   #     #
 #####  #   #     #
 #   #   ###      #
 ------------------------------------------------------
 */
/*
 ####################################
 Configuration vom AO
 ####################################
 */
MENU output_ao1_window
{
    LABEL [LABEL_AO1];
    STYLE WINDOW;
    ITEMS
    {
        meas_type (HIDDEN),
        func1_AO_OUT_SCALE (HIDDEN),

        conf_out_ao1_ident,
        conf_out_ao1_process,
        conf_out_ao1_alarm,
        conf_out_ao1_batch
    }
}

/* TAG... */
MENU conf_out_ao1_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func1_AO_TAG_DESC,
        func1_AO_STRATEGY,
        func1_AO_ST_REV
    }
}

/* OUT,CHANNEL... */
MENU conf_out_ao1_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        func1_AO_OUT_CHANNEL,
        func1_AO_PV_SCALE_Lower_Value,
        func1_AO_PV_SCALE_Upper_Value,
        func1_AO_PV_SCALE_Units_Index,
        func1_AO_PV_SCALE_Decimal_Point,
        func1_AO_OUT_SCALE_Lower_Value,
        func1_AO_OUT_SCALE_Upper_Value,
        func1_AO_OUT_SCALE_Units_Index,
        func1_AO_OUT_SCALE_Decimal_Point,
        func1_AO_SETP_DEVIATION,
        meas_type(HIDDEN)
        //func1_AO_CHECK_BACK_MASK
    }
}

/* Alarm, limits... */
MENU conf_out_ao1_alarm
{
    LABEL TXT_FB_FAIL;
    STYLE GROUP;
    ITEMS
    {
        func1_AO_FSAFE_TYPE,
        func1_AO_FSAFE_VALUE,
        func1_AO_FSAFE_TIME
    }
}

/* Batch.. */
MENU conf_out_ao1_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func1_AO_BATCH_Batch_ID,
        func1_AO_BATCH_Rup,
        func1_AO_BATCH_Operation,
        func1_AO_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_ao1_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func1_AO_TARGET_MODE,
        func1_AO_MODE_BLK_Actual,
        func1_AO_SIMULATE_Enabled,
        func1_AO_SIMULATE_Value,
        func1_AO_SIMULATE_Status_Condensed
    }
}

/*
 ####################################
 Diagnose vom AI
 ####################################
 */
MENU output_ao1_diag_window
{
    LABEL "Output AO1";
    STYLE WINDOW;
    ITEMS
    {
        diag_out_ao1_alarm
    }
}

/* Alarms... */
MENU diag_out_ao1_alarm
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func1_AO_ALARM_SUM_Current,
        func1_AO_ALARM_SUM_Unacknowledged,
        func1_AO_ALARM_SUM_Unreported,
        func1_AO_ALARM_SUM_Disabled
    }
}

SOURCE ao1_value_source
{
    LABEL [LABEL_AO1];
    Y_AXIS func1_AO_Display_BarVal_out_axis_mandatory_B;
    MEMBERS
    {
        PRIM_VAL, func1_AO_OUT_Value;
    }
}

CHART ao1_value_chart
{
    LABEL "AO1 Value";
    TYPE HORIZONTAL_BAR;    //GAUGE;
    MEMBERS {CHART1, ao1_value_source;}
}

AXIS func1_AO_Display_BarVal_out_axis_mandatory_B
{
	MIN_VALUE func1_AO_OUT_SCALE_Lower_Value;
	MAX_VALUE func1_AO_OUT_SCALE_Upper_Value;
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

/* Messwerte */
MENU display_out_func1_AO
{
    LABEL [LABEL_AO1];
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),

        out_ao1_value,
        out_ao1_simu,
        out_ao1_alarms/*,
         conf_out_ao1_simu*/
    }
}

MENU func1_AO_ovw
{
    LABEL [LABEL_AO1];
    STYLE GROUP;
    ITEMS
    {
        meas_type (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
        func1_AO_OUT_CHANNEL (HIDDEN),
        func1_AO_OUT_SCALE_Units_Index(HIDDEN),
        func1_AO_PV_SCALE_Units_Index(HIDDEN),

        func1_AO_SP_Value (READ_ONLY),
        ROWBREAK,
        func1_AO_SP_Status_Condensed (READ_ONLY),
    }
}

MENU out_ao1_value
{
    LABEL [PI_OUT_Value_label];
    STYLE GROUP;
    ITEMS
    {
        meas_type (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
        func1_AO_OUT_CHANNEL (HIDDEN),
        func1_AO_OUT_SCALE_Units_Index(HIDDEN),
        func1_AO_PV_SCALE_Units_Index(HIDDEN),

        func1_AO_OUT_CHANNEL (READ_ONLY),
		func1_AO_OUT_Value,
        func1_AO_SP_Value (READ_ONLY),
        func1_AO_SP_Status_Condensed (READ_ONLY),
        //func1_AO_SP_Status_Quality,
        //func1_AO_SP_Status_Limit,
        //func1_AO_OUT_Value,
        //func1_AO_OUT_Status_Condensed
        //func1_AO_CHECK_BACK,
    }
}
MENU out_ao1_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func1_AO_MODE_BLK_Actual,
        ROWBREAK ,
        func1_AO_SIMULATE_Enabled (READ_ONLY)
    }
}
/* Alarme */
MENU out_ao1_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func1_AO_ALARM_SUM_Current
    }
}

MENU overview_ao1_alarms
{
    LABEL [LABEL_AO1];
    STYLE GROUP;
    ITEMS
    {
        func1_AO_ALARM_SUM_Current
        /*,
         COLUMNBREAK,
         func1_AO_ALARM_SUM_Unacknowledged,
         COLUMNBREAK,
         func1_AO_ALARM_SUM_Unreported,
         COLUMNBREAK,
         func1_AO_ALARM_SUM_Disabled
         */
    }
}

MENU simulation_window_ao1
{
    LABEL [LABEL_AO1];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),

        func1_AO_OUT_CHANNEL (READ_ONLY),
        simulation_wnd_ao1_output,
        simulation_wnd_ao1_input
    }
}

MENU simulation_wnd_ao1_input
{
    LABEL TXT_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_AO_SIMULATE_Enabled,
        func1_AO_SIMULATE_Value,
        func1_AO_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_ao1_output
{
    LABEL TXT_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_AO_TARGET_MODE,
        func1_AO_MODE_BLK_Actual,
        func1_AO_SP_Value,
        func1_AO_SP_Status_Condensed
    }
}
