/*
--------------------------------------------------------------------------------------
  Datei:          StratosPro.ddl
  Ersteller:      msh
  Datum           21.10.2013

  Inhalt:         EDD fr Stratos Bus PA
                  Haupteinstiegsdatei

  Aufbau der EDD:
  -------------------------

  Funktionsblock          | Slot  |       Datei
  --------------------------------------------------------------------
  Physical Block          | 0     |   PI/0000_0101_0302_0001_pb.ddl   \
  Analog Input Block 1    | 1     |   PI/0000_4001_0302_0001_ai1.ddl   \
  Analog Input Block 2    | 2     |   PI/0000_4002_0302_0001_ai2.ddl    \
  Analog Input Block 3    | 3     |   PI/0000_4003_0302_0001_ai3.ddl     \
  Analog Input Block 4    | 4     |   PI/0000_4004_0302_0001_ai4.ddl      \
  Analog Input Block 5    | 5     |   PI/0000_4005_0302_0001_ai5.ddl       \
  Analog Input Block 6    | 6     |   PI/0000_4006_0302_0001_ai6.ddl        \     import_fb.inc  (Function Blocks)  \  StratosPro.ddl
  Analog Input Block 7    | 7     |   PI/0000_4007_0302_0001_ai7.ddl        /     import_mnu.inc (Menues)           /
  Analog Input Block 8    | 8     |   PI/0000_4008_0302_0001_ai8.ddl       /
  Analog Output Block 1   | 9     |   PI/0000_4201_0302_0001_ao1.ddl      /
  Discret Input Block 1   | 10    |   PI/0000_4301_0302_0001_di1.ddl     /
  Discret Output Block 1  | 11    |   PI/0000_4401_0302_0001_do1.ddl    /
  Discret Output Block 2  | 12    |   PI/0000_4402_0302_0001_do2.ddl   /
  Custom Transducer Block | 13    |   std_tb.ddl                      /
                                  |   stratos_tb.ddl                 
  -------------------------------------------------------------------
  Dictionary                          standard.dct
  Definitionen                        pa_import.h        (PI)
                                      pa_import_0302.h   (PI)
                                      pa_macros.h        (PI)
                                      pa_macros_0302.h   (PI)
                                      pa_status.h        (PI)
                                      pa_units.h         (PI)
                                      pa_units_0302.h    (PI)
                                      rsp_codes          (PI)
                                      stratos.h
  -------------------------------------------------------------------
  Configuration (Device)              config.ddl
  Logbook                             logbook.ddl
  Diagnose (Sensor,Caldata)           Sensor.ddl
  Identification                      ident.ddl
  Prozesswerte                        tb_processvar.ddl

--------------------------------------------------------------------------------------
*/
#include "texte.h"
#include "pa_import_0302.h"

#if _PDM_ >= 800
#define row           ROWBREAK,
#define column        COLUMNBREAK,
#else
#define row
#define column
#endif

// #define STRATOS_DP

/* Manufacturer ID von Knick ist 97*/
MANUFACTURER 97, DEVICE_TYPE 1, DEVICE_REVISION 1, DD_REVISION 4
#define MAN_ID            97
#define MAN_ID_NAME       "Knick"

#include "stratos_tb.h"
#include "import_mnu.inc"
/*#include "std_tb.ddl"*/

#include "stratos_tb.ddl"
#include "ai1.inc"
#include "ai2.inc"
#include "ai3.inc"
#include "ai4.inc"
#include "ai5.inc"
#include "ai6.inc"
#include "ai7.inc"
#include "ai8.inc"
#include "ao1.inc"
#include "di1.inc"
#include "do1.inc"
#include "do2.inc"
#include "simulation.ddl"
#include "config.ddl"
#include "logbook.ddl"
#include "sensor.ddl"
#include "cal.ddl"
#include "diag.ddl"

#include "stratos_menu.ddl"

/* Hier stehen alle Varianlen, die vom Gert ins Leitsystem geladen werden sollen */
#include "download.inc"

/* Hier stehen alle Varianlen, die vom Leitsystem ins Gert geladen werden sollen */
#include "upload.inc"

