
/*
 * $Id$
 * 
 * Copyright (C) PI 2007-2012. All rights reserved.
 * 
 * Version: 2.0.5
 * 
 */

/**
 * \file 0000_0101_0302_0001.ddl
 * \brief Physical Block Transmitter 'V3.02'.
 * This file contains all definitions for Physical Block Transmitter Profile Version 3.02
 * 
 * \section phys_import How to import
 * For use of all mandatory parameters for a Class A device use the macro USE_PHYS_MANDATORY_A.
 * For use of all mandatory parameters for a Class B device use the macro USE_PHYS_MANDATORY_B.
 * Use 'EVERYTHING' for importing of all available parameters
 * 
 * Example for Class B:
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __PHYSICAL_TRANSMITTER, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
 * {
 *   USE_PHYS_MANDATORY_B;
 * }
 * \endcode 
 *
 * \section phys_def_list This file contains the following definitions
 * \subsection phys_def_list_variable List of Variables
 * - phys_BLOCK_OBJECT_Reserved
 * - phys_BLOCK_OBJECT_Block_Object
 * - phys_BLOCK_OBJECT_Parent_Class
 * - phys_BLOCK_OBJECT_Class
 * - phys_BLOCK_OBJECT_Dev_Rev
 * - phys_BLOCK_OBJECT_Dev_Rev_Comp
 * - phys_BLOCK_OBJECT_DD_Revision
 * - phys_BLOCK_OBJECT_Profile
 * - phys_BLOCK_OBJECT_Profile_Revision
 * - phys_BLOCK_OBJECT_Execution_Time
 * - phys_BLOCK_OBJECT_Number_of_Parameters
 * - phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot
 * - phys_BLOCK_OBJECT_Address_of_VIEW_1_Index
 * - phys_BLOCK_OBJECT_Number_of_Views
 * - phys_ST_REV
 * - phys_TAG_DESC
 * - phys_STRATEGY
 * - phys_ALERT_KEY
 * - phys_TARGET_MODE
 * - phys_MODE_BLK_Actual
 * - phys_MODE_BLK_Permitted
 * - phys_MODE_BLK_Normal
 * - phys_ALARM_SUM_Current
 * - phys_ALARM_SUM_Unacknowledged
 * - phys_ALARM_SUM_Unreported
 * - phys_ALARM_SUM_Disabled
 * - phys_SOFTWARE_REVISION
 * - phys_HARDWARE_REVISION
 * - phys_DEVICE_MAN_ID
 * - phys_DEVICE_ID
 * - phys_DEVICE_SER_NUM
 * - phys_DIAGNOSIS
 * - phys_DIAGNOSIS_EXTENSION
 * - phys_DIAGNOSIS_MASK
 * - phys_DIAGNOSIS_MASK_EXTENSION
 * - phys_DEVICE_CERTIFICATION
 * - phys_WRITE_LOCKING
 * - phys_FACTORY_RESET
 * - phys_DESCRIPTOR
 * - phys_DEVICE_MESSAGE
 * - phys_DEVICE_INSTAL_DATE
 * - phys_LOCAL_OP_ENA
 * - phys_IDENT_NUMBER_SELECTOR
 * - phys_HW_WRITE_PROTECTION
 * - phys_FEATURE_Supported
 * - phys_FEATURE_Enabled
 * - phys_COND_STATUS_DIAG
 * - phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_1_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_2_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_2_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_3_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_3_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_4_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_4_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_5_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_5_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_6_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_6_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_7_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_7_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_8_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_8_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_9_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_9_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_10_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_10_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_11_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_11_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_12_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_12_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_13_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_13_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_14_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_14_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_15_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_15_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_16_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_16_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_17_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_17_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_18_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_18_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_19_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_19_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_20_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_20_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_21_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_21_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_22_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_22_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_23_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_23_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_24_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_24_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_25_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_25_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_26_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_26_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_27_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_27_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_28_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_28_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_29_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_29_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_30_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_30_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_31_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_31_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_32_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_32_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_33_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_34_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_35_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_36_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_37_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_38_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_39_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_40_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_41_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_42_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_43_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_44_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_45_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_46_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_47_Status
 * - phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag
 * - phys_DIAG_EVENT_SWITCH_Status_Link_48_Status
 * - phys_DIAG_EVENT_SWITCH_Slot
 * - phys_DIAG_EVENT_SWITCH_Index
 * - phys_PTA_OP_CODE
 * - phys_PTA_STATUS
 * .
 * \subsection phys_def_list_command List of Commands
 * - phys_BLOCK_OBJECT_read
 * - phys_ST_REV_read
 * - phys_TAG_DESC_read
 * - phys_TAG_DESC_write
 * - phys_STRATEGY_read
 * - phys_STRATEGY_write
 * - phys_ALERT_KEY_read
 * - phys_ALERT_KEY_write
 * - phys_TARGET_MODE_read
 * - phys_TARGET_MODE_write
 * - phys_MODE_BLK_read
 * - phys_ALARM_SUM_read
 * - phys_SOFTWARE_REVISION_read
 * - phys_HARDWARE_REVISION_read
 * - phys_DEVICE_MAN_ID_read
 * - phys_DEVICE_ID_read
 * - phys_DEVICE_SER_NUM_read
 * - phys_DIAGNOSIS_read
 * - phys_DIAGNOSIS_EXTENSION_read
 * - phys_DIAGNOSIS_MASK_read
 * - phys_DIAGNOSIS_MASK_EXTENSION_read
 * - phys_DEVICE_CERTIFICATION_read
 * - phys_WRITE_LOCKING_read
 * - phys_WRITE_LOCKING_write
 * - phys_FACTORY_RESET_read
 * - phys_FACTORY_RESET_write
 * - phys_DESCRIPTOR_read
 * - phys_DESCRIPTOR_write
 * - phys_DEVICE_MESSAGE_read
 * - phys_DEVICE_MESSAGE_write
 * - phys_DEVICE_INSTAL_DATE_read
 * - phys_DEVICE_INSTAL_DATE_write
 * - phys_LOCAL_OP_ENA_read
 * - phys_LOCAL_OP_ENA_write
 * - phys_IDENT_NUMBER_SELECTOR_read
 * - phys_IDENT_NUMBER_SELECTOR_write
 * - phys_HW_WRITE_PROTECTION_read
 * - phys_FEATURE_read
 * - phys_COND_STATUS_DIAG_read
 * - phys_COND_STATUS_DIAG_write
 * - phys_DIAG_EVENT_SWITCH_read
 * - phys_DIAG_EVENT_SWITCH_write
 * - phys_PTA_OP_CODE_read
 * - phys_PTA_OP_CODE_write
 * - phys_PTA_STATUS_read
 * .
 * \subsection phys_def_list_menu List of Menu
 * - phys_BLOCK_OBJECT_page
 * - phys_ST_REV_page
 * - phys_TAG_DESC_page
 * - phys_STRATEGY_page
 * - phys_ALERT_KEY_page
 * - phys_TARGET_MODE_page
 * - phys_MODE_BLK_page
 * - phys_ALARM_SUM_page
 * - phys_SOFTWARE_REVISION_page
 * - phys_HARDWARE_REVISION_page
 * - phys_DEVICE_MAN_ID_page
 * - phys_DEVICE_ID_page
 * - phys_DEVICE_SER_NUM_page
 * - phys_DIAGNOSIS_page
 * - phys_DIAGNOSIS_EXTENSION_page
 * - phys_DIAGNOSIS_MASK_page
 * - phys_DIAGNOSIS_MASK_EXTENSION_page
 * - phys_DEVICE_CERTIFICATION_page
 * - phys_WRITE_LOCKING_page
 * - phys_FACTORY_RESET_page
 * - phys_DESCRIPTOR_page
 * - phys_DEVICE_MESSAGE_page
 * - phys_DEVICE_INSTAL_DATE_page
 * - phys_LOCAL_OP_ENA_page
 * - phys_IDENT_NUMBER_SELECTOR_page
 * - phys_HW_WRITE_PROTECTION_page
 * - phys_FEATURE_page
 * - phys_COND_STATUS_DIAG_page
 * - phys_DIAG_EVENT_SWITCH_page
 * - phys_PTA_OP_CODE_page
 * - phys_PTA_STATUS_page
 * - phys_VIEW_1_page
 * - phys_VIEW_2_page
 * - phys_VIEW_3_page
 * - phys_VIEW_4_page
 * - phys_Reset
 * - phys_Reset_page
 * - phys_Dialog_Write_Locking
 * - phys_Dialog_Ident_Number_Selector
 * - phys_Diagnosis_page
 * .
 * \subsection phys_def_list_method List of Methods
 * - phys_method_factory_reset_params
 * - phys_method_factory_reset_warm
 * - phys_method_factory_reset_address
 * - phys_method_factory_reset_device_specific
 * .
 *
 * \section phys_upload_download Upload and Download
 * \subsection phys_upload_download_upload Upload
 * To upload the VARIABLEs you can use the following macro definition:
 * \code
 * phys_BLOCK_OBJECT_Reserved,                      // Mand A, Mand B
 * phys_BLOCK_OBJECT_Block_Object,                  // Mand A, Mand B
 * phys_BLOCK_OBJECT_Parent_Class,                  // Mand A, Mand B
 * phys_BLOCK_OBJECT_Class,                         // Mand A, Mand B
 * phys_BLOCK_OBJECT_Dev_Rev,                       // Mand A, Mand B
 * phys_BLOCK_OBJECT_Dev_Rev_Comp,                  // Mand A, Mand B
 * phys_BLOCK_OBJECT_DD_Revision,                   // Mand A, Mand B
 * phys_BLOCK_OBJECT_Profile,                       // Mand A, Mand B
 * phys_BLOCK_OBJECT_Profile_Revision,              // Mand A, Mand B
 * phys_BLOCK_OBJECT_Execution_Time,                // Mand A, Mand B
 * phys_BLOCK_OBJECT_Number_of_Parameters,          // Mand A, Mand B
 * phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot,        // Mand A, Mand B
 * phys_BLOCK_OBJECT_Address_of_VIEW_1_Index,       // Mand A, Mand B
 * phys_BLOCK_OBJECT_Number_of_Views,               // Mand A, Mand B
 * phys_ST_REV,                                     // Mand A, Mand B
 * phys_TAG_DESC,                                   // Mand A, Mand B
 * phys_STRATEGY,                                   // Mand A, Mand B
 * phys_ALERT_KEY,                                  // Mand A, Mand B
 * phys_TARGET_MODE,                                // Mand A, Mand B
 * phys_MODE_BLK_Actual,                            // Mand A, Mand B
 * phys_MODE_BLK_Permitted,                         // Mand A, Mand B
 * phys_MODE_BLK_Normal,                            // Mand A, Mand B
 * phys_ALARM_SUM_Current,                          // Mand A, Mand B
 * phys_ALARM_SUM_Unacknowledged,                   // Mand A, Mand B
 * phys_ALARM_SUM_Unreported,                       // Mand A, Mand B
 * phys_ALARM_SUM_Disabled,                         // Mand A, Mand B
 * phys_SOFTWARE_REVISION,                          // Mand A, Mand B
 * phys_HARDWARE_REVISION,                          // Mand A, Mand B
 * phys_DEVICE_MAN_ID,                              // Mand A, Mand B
 * phys_DEVICE_ID,                                  // Mand A, Mand B
 * phys_DEVICE_SER_NUM,                             // Mand A, Mand B
 * phys_DIAGNOSIS,                                  // Mand A, Mand B
 * phys_DIAGNOSIS_EXTENSION,                        // Opt A, Opt B
 * phys_DIAGNOSIS_MASK,                             // Mand A, Mand B
 * phys_DIAGNOSIS_MASK_EXTENSION,                   // Opt A, Opt B
 * phys_DEVICE_CERTIFICATION,                       // Opt A, Opt B
 * phys_WRITE_LOCKING,                              // Opt A, Opt B
 * phys_FACTORY_RESET,                              // Opt A, Opt B
 * phys_DESCRIPTOR,                                 // Opt A, Opt B
 * phys_DEVICE_MESSAGE,                             // Opt A, Opt B
 * phys_DEVICE_INSTAL_DATE,                         // Opt A, Opt B
 * phys_LOCAL_OP_ENA,                               // Opt A, Opt B
 * phys_IDENT_NUMBER_SELECTOR,                      // Mand B, Opt A
 * phys_HW_WRITE_PROTECTION,                        // Opt A, Opt B
 * phys_FEATURE_Supported,                          // Mand A, Mand B
 * phys_FEATURE_Enabled,                            // Mand A, Mand B
 * phys_COND_STATUS_DIAG,                           // Mand A, Mand B
 * phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_1_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_2_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_2_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_3_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_3_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_4_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_4_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_5_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_5_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_6_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_6_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_7_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_7_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_8_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_8_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_9_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_9_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_10_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_10_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_11_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_11_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_12_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_12_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_13_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_13_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_14_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_14_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_15_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_15_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_16_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_16_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_17_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_17_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_18_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_18_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_19_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_19_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_20_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_20_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_21_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_21_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_22_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_22_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_23_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_23_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_24_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_24_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_25_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_25_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_26_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_26_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_27_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_27_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_28_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_28_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_29_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_29_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_30_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_30_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_31_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_31_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_32_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_32_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_33_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_34_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_35_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_36_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_37_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_38_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_39_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_40_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_41_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_42_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_43_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_44_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_45_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_46_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_47_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_48_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Slot,                     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Index,                    // Opt A, Opt B
 * phys_PTA_OP_CODE,                                // Opt A, Opt B
 * phys_PTA_STATUS                                  // Opt A, Opt B
 * \endcode
 * \subsection phys_upload_download_download Download
 * To download the VARIABLEs you can use the following macro definition:
 * \code
 * phys_TAG_DESC,                                   // Mand A, Mand B
 * phys_STRATEGY,                                   // Mand A, Mand B
 * phys_ALERT_KEY,                                  // Mand A, Mand B
 * phys_TARGET_MODE,                                // Mand A, Mand B
 * phys_DESCRIPTOR,                                 // Opt A, Opt B
 * phys_DEVICE_MESSAGE,                             // Opt A, Opt B
 * phys_DEVICE_INSTAL_DATE,                         // Opt A, Opt B
 * phys_LOCAL_OP_ENA,                               // Opt A, Opt B
 * phys_COND_STATUS_DIAG,                           // Mand A, Mand B
 * phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_1_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_2_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_2_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_3_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_3_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_4_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_4_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_5_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_5_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_6_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_6_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_7_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_7_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_8_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_8_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_9_Diag,       // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_9_Status,     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_10_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_10_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_11_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_11_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_12_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_12_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_13_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_13_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_14_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_14_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_15_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_15_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_16_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_16_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_17_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_17_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_18_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_18_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_19_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_19_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_20_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_20_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_21_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_21_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_22_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_22_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_23_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_23_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_24_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_24_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_25_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_25_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_26_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_26_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_27_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_27_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_28_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_28_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_29_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_29_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_30_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_30_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_31_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_31_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_32_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_32_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_33_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_34_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_35_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_36_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_37_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_38_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_39_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_40_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_41_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_42_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_43_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_44_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_45_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_46_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_47_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag,      // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Status_Link_48_Status,    // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Slot,                     // Opt A, Opt B
 * phys_DIAG_EVENT_SWITCH_Index,                    // Opt A, Opt B
 * phys_PTA_OP_CODE                                 // Opt A, Opt B
 * \endcode
 *
 */

#include "pa_import_0302.h"

/** \cond SKIP_THIS */
MANUFACTURER 0x0000, DEVICE_TYPE 0x0101, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
/** \endcond */

#include "rsp_codes.h"

BLOCK phys_block
{
	TYPE PHYSICAL;
	NUMBER 1;
}

COLLECTION phys_BLOCK_OBJECT
{
	LABEL [PI_BLOCK_OBJECT_label];
	HELP [PI_BLOCK_OBJECT_help];
	MEMBERS
	{
		Reserved, phys_BLOCK_OBJECT_Reserved;
		Block_Object, phys_BLOCK_OBJECT_Block_Object;
		Parent_Class, phys_BLOCK_OBJECT_Parent_Class;
		Class, phys_BLOCK_OBJECT_Class;
		Dev_Rev, phys_BLOCK_OBJECT_Dev_Rev;
		Dev_Rev_Comp, phys_BLOCK_OBJECT_Dev_Rev_Comp;
		DD_Revision, phys_BLOCK_OBJECT_DD_Revision;
		Profile, phys_BLOCK_OBJECT_Profile;
		Profile_Revision, phys_BLOCK_OBJECT_Profile_Revision;
		Execution_Time, phys_BLOCK_OBJECT_Execution_Time;
		Number_of_Parameters, phys_BLOCK_OBJECT_Number_of_Parameters;
		Address_of_VIEW_1_Slot, phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot;
		Address_of_VIEW_1_Index, phys_BLOCK_OBJECT_Address_of_VIEW_1_Index;
		Number_of_Views, phys_BLOCK_OBJECT_Number_of_Views;
	}
}

VARIABLE phys_BLOCK_OBJECT_Reserved
{
	LABEL [PI_BLOCK_OBJECT_Reserved_label];
	HELP [PI_BLOCK_OBJECT_Reserved_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE phys_BLOCK_OBJECT_Block_Object
{
	LABEL [PI_BLOCK_OBJECT_Block_Object_label];
	HELP [PI_BLOCK_OBJECT_Block_Object_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 1;
		{ 1, [PI_BLOCK_OBJECT_Block_Object_enum_1] },
		{ 2, [PI_BLOCK_OBJECT_Block_Object_enum_2] },
		{ 3, [PI_BLOCK_OBJECT_Block_Object_enum_3] }
	}
}

VARIABLE phys_BLOCK_OBJECT_Parent_Class
{
	LABEL [PI_BLOCK_OBJECT_Parent_Class_label];
	HELP [PI_phys_BLOCK_OBJECT_Parent_Class_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 1, [PI_phys_BLOCK_OBJECT_Parent_Class_enum_1] },
		{ 2, [PI_phys_BLOCK_OBJECT_Parent_Class_enum_2] },
		{ 3, [PI_phys_BLOCK_OBJECT_Parent_Class_enum_3] },
		{ 4, [PI_phys_BLOCK_OBJECT_Parent_Class_enum_4] },
		{ 5, [PI_phys_BLOCK_OBJECT_Parent_Class_enum_5] },
		{ 6, [PI_phys_BLOCK_OBJECT_Parent_Class_enum_6] },
		{ 127, [PI_phys_BLOCK_OBJECT_Parent_Class_enum_127] }
	}
}

VARIABLE phys_BLOCK_OBJECT_Class
{
	LABEL [PI_BLOCK_OBJECT_Class_label];
	HELP [PI_phys_BLOCK_OBJECT_Class_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 250;
		{ 250, [PI_not_used] }
	}
}

VARIABLE phys_BLOCK_OBJECT_Dev_Rev
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE phys_BLOCK_OBJECT_Dev_Rev_Comp
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_Comp_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_Comp_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE phys_BLOCK_OBJECT_DD_Revision
{
	LABEL [PI_BLOCK_OBJECT_DD_Revision_label];
	HELP [PI_BLOCK_OBJECT_DD_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE phys_BLOCK_OBJECT_Profile
{
	LABEL [PI_BLOCK_OBJECT_Profile_label];
	HELP [PI_BLOCK_OBJECT_Profile_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		{ 0x4001, [PI_BLOCK_OBJECT_Profile_enum_0x4001] },
		{ 0x4002, [PI_BLOCK_OBJECT_Profile_enum_0x4002] },
		{ 0x4081, [PI_BLOCK_OBJECT_Profile_enum_0x4081] },
		{ 0x4082, [PI_BLOCK_OBJECT_Profile_enum_0x4082] }
	}
}

VARIABLE phys_BLOCK_OBJECT_Profile_Revision
{
	LABEL [PI_BLOCK_OBJECT_Profile_Revision_label];
	HELP [PI_BLOCK_OBJECT_Profile_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 0x302;
		{ 0x0200, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0200] },
		{ 0x0300, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0300] },
		{ 0x0301, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0301] },
		{ 0x0302, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0302] }
	}
}

VARIABLE phys_BLOCK_OBJECT_Execution_Time
{
	LABEL [PI_BLOCK_OBJECT_Execution_Time_label];
	HELP [PI_BLOCK_OBJECT_Execution_Time_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE phys_BLOCK_OBJECT_Number_of_Parameters
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Parameters_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Parameters_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_label];
	HELP [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE phys_BLOCK_OBJECT_Address_of_VIEW_1_Index
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Index_label];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE phys_BLOCK_OBJECT_Number_of_Views
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Views_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Views_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE phys_ST_REV
{
	LABEL [PI_ST_REV_label];
	HELP [PI_ST_REV_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE phys_TAG_DESC
{
	LABEL [PI_TAG_DESC_label];
	HELP [PI_TAG_DESC_help];
	CLASS CONTAINED;
	TYPE ASCII(32)
	{
		DEFAULT_VALUE " ";
	}
}

VARIABLE phys_STRATEGY
{
	LABEL [PI_STRATEGY_label];
	HELP [PI_STRATEGY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE phys_ALERT_KEY
{
	LABEL [PI_ALERT_KEY_label];
	HELP [PI_ALERT_KEY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE phys_TARGET_MODE
{
	LABEL [PI_TARGET_MODE_label];
	HELP [PI_TARGET_MODE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		//{ 0x01, [PI_mode_ROUT] },
		//{ 0x02, [PI_mode_RCAS] },
		//{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		//{ 0x10, [PI_mode_MAN] },
		//{ 0x20, [PI_mode_LO] },
		//{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION phys_MODE_BLK
{
	LABEL [PI_MODE_BLK_label];
	HELP [PI_MODE_BLK_help];
	MEMBERS
	{
		Actual, phys_MODE_BLK_Actual;
		Permitted, phys_MODE_BLK_Permitted;
		Normal, phys_MODE_BLK_Normal;
	}
}

VARIABLE phys_MODE_BLK_Actual
{
	LABEL [PI_MODE_BLK_Actual_label];
	HELP [PI_MODE_BLK_Actual_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE phys_MODE_BLK_Permitted
{
	LABEL [PI_MODE_BLK_Permitted_label];
	HELP [PI_MODE_BLK_Permitted_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(1)
	{
		DEFAULT_VALUE 0x88;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE phys_MODE_BLK_Normal
{
	LABEL [PI_MODE_BLK_Normal_label];
	HELP [PI_MODE_BLK_Normal_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION phys_ALARM_SUM
{
	LABEL [PI_ALARM_SUM_label];
	HELP [PI_ALARM_SUM_help];
	MEMBERS
	{
		Current, phys_ALARM_SUM_Current;
		Unacknowledged, phys_ALARM_SUM_Unacknowledged;
		Unreported, phys_ALARM_SUM_Unreported;
		Disabled, phys_ALARM_SUM_Disabled;
	}
}

VARIABLE phys_ALARM_SUM_Current
{
	LABEL [PI_ALARM_SUM_Current_label];
	HELP [PI_ALARM_SUM_Current_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE phys_ALARM_SUM_Unacknowledged
{
	LABEL [PI_ALARM_SUM_Unacknowledged_label];
	HELP [PI_ALARM_SUM_Unacknowledged_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE phys_ALARM_SUM_Unreported
{
	LABEL [PI_ALARM_SUM_Unreported_label];
	HELP [PI_ALARM_SUM_Unreported_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE phys_ALARM_SUM_Disabled
{
	LABEL [PI_ALARM_SUM_Disabled_label];
	HELP [PI_ALARM_SUM_Disabled_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE phys_SOFTWARE_REVISION
{
	LABEL [PI_phys_SOFTWARE_REVISION_label];
	HELP [PI_phys_SOFTWARE_REVISION_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ASCII(16);
}

VARIABLE phys_HARDWARE_REVISION
{
	LABEL [PI_phys_HARDWARE_REVISION_label];
	HELP [PI_phys_HARDWARE_REVISION_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ASCII(16);
}

VARIABLE phys_DEVICE_MAN_ID
{
	LABEL [PI_DEVICE_MAN_ID_label];
	HELP [PI_DEVICE_MAN_ID_help];
	CLASS CONTAINED;
	HANDLING READ;
  TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 97;
		{ 97, "Knick" }
  }
	//TYPE UNSIGNED_INTEGER(2);
}

VARIABLE phys_DEVICE_ID
{
	LABEL [PI_phys_DEVICE_ID_label];
	HELP [PI_phys_DEVICE_ID_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ASCII(16);
}

VARIABLE phys_DEVICE_SER_NUM
{
	LABEL [PI_phys_DEVICE_SER_NUM_label];
	HELP [PI_phys_DEVICE_SER_NUM_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ASCII(16);
}

#define DIA_HW_ELECTR        0x01000000 /* 0x00000001 */
#define DIA_HW_MECH          0x02000000 /* 0x00000002 */
#define DIA_TEMP_MOTOR       0x04000000 /* 0x00000004 */
#define DIA_TEMP_ELECTR      0x08000000 /* 0x00000008 */
#define DIA_MEM_CHKSUM       0x10000000 /* 0x00000010 */
#define DIA_MEASUREMENT      0x20000000 /* 0x00000020 */
#define DIA_NOT_INIT         0x40000000 /* 0x00000040 */
#define DIA_INIT_ERR         0x80000000 /* 0x00000080 */
#define DIA_ZERO_ERR         0x00010000 /* 0x00000100 */
#define DIA_SUPPLY           0x00020000 /* 0x00000200 */
#define DIA_CONF_INVAL       0x00040000 /* 0x00000400 */
#define DIA_WARMSTART        0x00080000 /* 0x00000800 */
#define DIA_COLDSTART        0x00100000 /* 0x00001000 */
#define DIA_MAINTENANCE      0x00200000 /* 0x00002000 */
#define DIA_CHARACT          0x00400000 /* 0x00004000 */
#define DIA_IDENT_VIOL       0x00800000 /* 0x00008000 */
#define DIA_DEV_FAILURE      0x00000100
#define DIA_MAINTEN_DEM      0x00000200
#define DIA_FUNCTION_CHECK   0x00000400
#define DIA_INVAL_PROC_COND  0x00000800
#define EXTENSION_AVAILABLE  0x00000080 /* 0x80000000 */

VARIABLE phys_DIAGNOSIS
{
	LABEL [PI_phys_DIAGNOSIS_label];
	HELP [PI_phys_DIAGNOSIS_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;	
	TYPE BIT_ENUMERATED(4)
	{
		{ 0, [PI_phys_DIAGNOSIS_enum_0], [PI_empty] },
		{ DIA_HW_ELECTR, [PI_DIAGNOSIS_enum_DIA_HW_ELECTR], [PI_empty] },
		{ DIA_HW_MECH, [PI_DIAGNOSIS_enum_DIA_HW_MECH], [PI_empty] },
		{ DIA_TEMP_MOTOR, [PI_DIAGNOSIS_enum_DIA_TEMP_MOTOR], [PI_empty] },
		{ DIA_TEMP_ELECTR, [PI_DIAGNOSIS_enum_DIA_TEMP_ELECTR], [PI_empty] },
		{ DIA_MEM_CHKSUM, [PI_DIAGNOSIS_enum_DIA_MEM_CHKSUM], [PI_empty] },
		{ DIA_MEASUREMENT, [PI_DIAGNOSIS_enum_DIA_MEASUREMENT], [PI_empty] },
		{ DIA_NOT_INIT, [PI_DIAGNOSIS_enum_DIA_NOT_INIT], [PI_empty] },
		{ DIA_INIT_ERR, [PI_DIAGNOSIS_enum_DIA_INIT_ERR], [PI_empty] },
		{ DIA_ZERO_ERR, [PI_DIAGNOSIS_enum_DIA_ZERO_ERR], [PI_empty] },
		{ DIA_SUPPLY, [PI_DIAGNOSIS_enum_DIA_SUPPLY], [PI_empty] },
		{ DIA_CONF_INVAL, [PI_DIAGNOSIS_enum_DIA_CONF_INVAL], [PI_empty] },
		{ DIA_WARMSTART, [PI_DIAGNOSIS_enum_DIA_WARMSTART], [PI_empty] },
		{ DIA_COLDSTART, [PI_DIAGNOSIS_enum_DIA_COLDSTART], [PI_empty] },
		{ DIA_MAINTENANCE, [PI_DIAGNOSIS_enum_DIA_MAINTENANCE], [PI_empty] },
		{ DIA_CHARACT, [PI_DIAGNOSIS_enum_DIA_CHARACT], [PI_empty] },
		{ DIA_IDENT_VIOL, [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL], [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL_help] },
		{ DIA_DEV_FAILURE, [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE], [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE_help] },
		{ DIA_MAINTEN_DEM, [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM], [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM] },
		{ DIA_FUNCTION_CHECK, [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK], [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK_help] },
		{ DIA_INVAL_PROC_COND, [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND], [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND_help] },
		{ EXTENSION_AVAILABLE, [PI_DIAGNOSIS_enum_EXTENSION_AVAILABLE], [PI_empty] }
	}
}                                              

VARIABLE phys_DIAGNOSIS_EXTENSION
{
	LABEL [PI_phys_DIAGNOSIS_EXTENSION_label];
	HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;  
	
	TYPE BIT_ENUMERATED(6)      
	{
	}
}
VARIABLE phys_DIAGNOSIS_EXTENSION2
{
	LABEL [PI_phys_DIAGNOSIS_EXTENSION_label];
	HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
  TYPE ASCII(2);
}

VARIABLE phys_DIAGNOSIS_MASK
{
	LABEL [PI_phys_DIAGNOSIS_MASK_label];
	HELP [PI_phys_DIAGNOSIS_MASK_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE BIT_ENUMERATED(4)
	{
		{ DIA_HW_ELECTR, [PI_DIAGNOSIS_enum_DIA_HW_ELECTR], [PI_empty] },
		{ DIA_HW_MECH, [PI_DIAGNOSIS_enum_DIA_HW_MECH], [PI_empty] },
		{ DIA_TEMP_MOTOR, [PI_DIAGNOSIS_enum_DIA_TEMP_MOTOR], [PI_empty] },
		{ DIA_TEMP_ELECTR, [PI_DIAGNOSIS_enum_DIA_TEMP_ELECTR], [PI_empty] },
		{ DIA_MEM_CHKSUM, [PI_DIAGNOSIS_enum_DIA_MEM_CHKSUM], [PI_empty] },
		{ DIA_MEASUREMENT, [PI_DIAGNOSIS_enum_DIA_MEASUREMENT], [PI_empty] },
		{ DIA_NOT_INIT, [PI_DIAGNOSIS_enum_DIA_NOT_INIT], [PI_empty] },
		{ DIA_INIT_ERR, [PI_DIAGNOSIS_enum_DIA_INIT_ERR], [PI_empty] },
		{ DIA_ZERO_ERR, [PI_DIAGNOSIS_enum_DIA_ZERO_ERR], [PI_empty] },
		{ DIA_SUPPLY, [PI_DIAGNOSIS_enum_DIA_SUPPLY], [PI_empty] },
		{ DIA_CONF_INVAL, [PI_DIAGNOSIS_enum_DIA_CONF_INVAL], [PI_empty] },
		{ DIA_WARMSTART, [PI_DIAGNOSIS_enum_DIA_WARMSTART], [PI_empty] },
		{ DIA_COLDSTART, [PI_DIAGNOSIS_enum_DIA_COLDSTART], [PI_empty] },
		{ DIA_MAINTENANCE, [PI_DIAGNOSIS_enum_DIA_MAINTENANCE], [PI_empty] },
		{ DIA_CHARACT, [PI_DIAGNOSIS_enum_DIA_CHARACT], [PI_empty] },
		{ DIA_IDENT_VIOL, [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL], [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL_help] },
		{ DIA_DEV_FAILURE, [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE], [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE_help] },
		{ DIA_MAINTEN_DEM, [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM], [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM] },
		{ DIA_FUNCTION_CHECK, [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK], [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK_help] },
		{ DIA_INVAL_PROC_COND, [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND], [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND_help] },
		{ EXTENSION_AVAILABLE, [PI_DIAGNOSIS_enum_EXTENSION_AVAILABLE], [PI_empty] }
	}
}

VARIABLE phys_DIAGNOSIS_MASK_EXTENSION
{
	LABEL [PI_phys_DIAGNOSIS_MASK_EXTENSION_label];
	HELP [PI_phys_DIAGNOSIS_MASK_EXTENSION_help];
	CLASS CONTAINED;
	HANDLING READ;  
	TYPE BIT_ENUMERATED(6)      
	{
	}
}

VARIABLE phys_DIAGNOSIS_MASK_EXTENSION2
{
	LABEL [PI_phys_DIAGNOSIS_EXTENSION_label];
	HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
  TYPE ASCII(2);
}

VARIABLE phys_DEVICE_CERTIFICATION
{
	LABEL [PI_phys_DEVICE_CERTIFICATION_label];
	HELP [PI_phys_DEVICE_CERTIFICATION_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ASCII(32);
}

VARIABLE phys_WRITE_LOCKING
{
	LABEL [PI_WRITE_LOCKING_label];
	HELP [PI_WRITE_LOCKING_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 2457;
		{ 2457, [PI_WRITE_LOCKING_enum_2457] },
		{ 0, [PI_WRITE_LOCKING_enum_0] }
	}
}

VARIABLE phys_FACTORY_RESET
{
	LABEL [PI_FACTORY_RESET_label];
	HELP [PI_phys_FACTORY_RESET_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_phys_FACTORY_RESET_enum_0] },
		{ 1, [PI_FACTORY_RESET_label] },
		{ 2, [PI_phys_FACTORY_RESET_enum_2] },
		{ 3, [PI_phys_FACTORY_RESET_enum_3] },
		{ 2506, [PI_FACTORY_RESET_enum_2506] },
		{ 2712, [PI_FACTORY_RESET_enum_2712] }
	}
}

VARIABLE phys_DESCRIPTOR
{
	LABEL [PI_phys_DESCRIPTOR_label];
	HELP [PI_phys_DESCRIPTOR_help];
	CLASS CONTAINED;
	TYPE ASCII(32);
}

VARIABLE phys_DEVICE_MESSAGE
{
	LABEL [PI_phys_DEVICE_MESSAGE_label];
	HELP [PI_phys_DEVICE_MESSAGE_help];
	CLASS CONTAINED;
	TYPE ASCII(32);
}

VARIABLE phys_DEVICE_INSTAL_DATE
{
	LABEL [PI_phys_DEVICE_INSTAL_DATE_label];
	HELP [PI_phys_DEVICE_INSTAL_DATE_help];
	CLASS CONTAINED;
	TYPE ASCII(16);
}

VARIABLE phys_LOCAL_OP_ENA
{
	LABEL [PI_phys_LOCAL_OP_ENA_label];
	HELP [PI_phys_LOCAL_OP_ENA_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 1;
		{ 0, [PI_disabled] },
		{ 1, [PI_enabled] }
	}
}

VARIABLE phys_IDENT_NUMBER_SELECTOR
{
	LABEL [PI_IDENT_NUMBER_SELECTOR_label];
	HELP [PI_IDENT_NUMBER_SELECTOR_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 127;
		{ 0, [PI_phys_IDENT_NUMBER_SELECTOR_enum_0] },
		{ 1, [PI_IDENT_NUMBER_SELECTOR_enum_1] },
		/*{ 2, [PI_phys_IDENT_NUMBER_SELECTOR_enum_2] },
		{ 3, [PI_phys_IDENT_NUMBER_SELECTOR_enum_3] },*/
		{ 127, [PI_phys_IDENT_NUMBER_SELECTOR_enum_127] }
	}
}

VARIABLE phys_HW_WRITE_PROTECTION
{
	LABEL [PI_phys_HW_WRITE_PROTECTION_label];
	HELP [PI_phys_HW_WRITE_PROTECTION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 1, [PI_phys_HW_WRITE_PROTECTION_enum_1] },
		{ 0, [PI_WRITE_LOCKING_enum_2457] },
		{ 2, [PI_phys_HW_WRITE_PROTECTION_enum_2] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

COLLECTION phys_FEATURE
{
	LABEL [PI_phys_FEATURE_label];
	HELP [PI_phys_FEATURE_help];
	MEMBERS
	{
		Supported, phys_FEATURE_Supported;
		Enabled, phys_FEATURE_Enabled;
	}
}

VARIABLE phys_FEATURE_Supported
{
	LABEL [PI_phys_FEATURE_Supported_label];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE BIT_ENUMERATED(4)
	{
    /* Aenderung msh: */
		{ 0x02000000, [PI_FEATURE_Supported_enum_0x02], [PI_phys_FEATURE_Supported_enum_0x02_help] },
		{ 0x01000000, [PI_FEATURE_Supported_enum_0x01], [PI_phys_FEATURE_Supported_enum_0x01_help] },
		{ 0x04000000, [PI_FEATURE_Supported_enum_0x04], [PI_phys_FEATURE_Supported_enum_0x04_help] },
		{ 0x08000000, [PI_FEATURE_Supported_enum_0x08], [PI_phys_FEATURE_Supported_enum_0x08_help] },
		{ 0x10000000, [PI_FEATURE_Supported_enum_0x10], [PI_phys_FEATURE_Supported_enum_0x10_help] }
	}
}

VARIABLE phys_FEATURE_Enabled
{
	LABEL [PI_phys_FEATURE_Enabled_label];
	CLASS CONTAINED;
	HANDLING READ;	
	TYPE BIT_ENUMERATED(4)
	{    
		{ 0x01000000, [PI_FEATURE_Supported_enum_0x01], [PI_phys_FEATURE_Enabled_enum_0x01_help] },
		{ 0x02000000, [PI_FEATURE_Supported_enum_0x02], [PI_phys_FEATURE_Enabled_enum_0x02_help] },
		{ 0x04000000, [PI_FEATURE_Supported_enum_0x04], [PI_phys_FEATURE_Enabled_enum_0x04_help] },
		{ 0x08000000, [PI_FEATURE_Supported_enum_0x08], [PI_phys_FEATURE_Enabled_enum_0x08_help] },
		{ 0x10000000, [PI_FEATURE_Supported_enum_0x10], [PI_phys_FEATURE_Enabled_enum_0x10_help] }
	}
}

VARIABLE phys_COND_STATUS_DIAG
{
	LABEL [PI_phys_COND_STATUS_DIAG_label];
	HELP [PI_phys_COND_STATUS_DIAG_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 1;
		{ 0, [PI_phys_COND_STATUS_DIAG_enum_0] },
		{ 1, [PI_phys_COND_STATUS_DIAG_enum_1] }
	}
}

#include "texte.h"
COLLECTION phys_DIAG_EVENT_SWITCH
{
	LABEL [PI_phys_DIAG_EVENT_SWITCH_label];
	HELP [PI_phys_DIAG_EVENT_SWITCH_help];
	MEMBERS
	{
		Status_Link_1_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_1;		
		Status_Link_2_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_2;	
		Status_Link_3_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_3;
		Status_Link_4_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_4;
		/*Status_Link_5_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_5;
		Status_Link_6_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_6;
		Status_Link_7_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_7;*/
		Status_Link_8_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_8;
		Status_Link_9_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_9;
		Status_Link_10_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_10;
		Status_Link_11_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_11;
		Status_Link_12_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_12;
		Status_Link_13_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_13;
		/*Status_Link_14_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_14;
		Status_Link_15_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_15;*/
		Status_Link_16_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_16;
		Status_Link_17_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_17;
		Status_Link_18_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_18;
		/*Status_Link_19_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_19;*/
		Status_Link_20_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_20;
		Status_Link_21_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_21;
		Status_Link_22_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_22;
		/*Status_Link_23_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_23;*/
		Status_Link_24_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_24;
		Status_Link_25_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_25;
		Status_Link_26_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_26;
		Status_Link_27_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_27;
		Status_Link_28_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_28;
		Status_Link_29_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_29;
		Status_Link_30_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_30;
		/*Status_Link_31_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_31;*/
    /* Unser Gert hat nur 32 Meldungen */
		/*Status_Link_33_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag;
		Status_Link_33_Status, phys_DIAG_EVENT_SWITCH_Status_Link_33_Status;
		Status_Link_34_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag;
		Status_Link_34_Status, phys_DIAG_EVENT_SWITCH_Status_Link_34_Status;
		Status_Link_35_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag;
		Status_Link_35_Status, phys_DIAG_EVENT_SWITCH_Status_Link_35_Status;
		Status_Link_36_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag;
		Status_Link_36_Status, phys_DIAG_EVENT_SWITCH_Status_Link_36_Status;
		Status_Link_37_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag;
		Status_Link_37_Status, phys_DIAG_EVENT_SWITCH_Status_Link_37_Status;
		Status_Link_38_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag;
		Status_Link_38_Status, phys_DIAG_EVENT_SWITCH_Status_Link_38_Status;
		Status_Link_39_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag;
		Status_Link_39_Status, phys_DIAG_EVENT_SWITCH_Status_Link_39_Status;
		Status_Link_40_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag;
		Status_Link_40_Status, phys_DIAG_EVENT_SWITCH_Status_Link_40_Status;
		Status_Link_41_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag;
		Status_Link_41_Status, phys_DIAG_EVENT_SWITCH_Status_Link_41_Status;
		Status_Link_42_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag;
		Status_Link_42_Status, phys_DIAG_EVENT_SWITCH_Status_Link_42_Status;
		Status_Link_43_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag;
		Status_Link_43_Status, phys_DIAG_EVENT_SWITCH_Status_Link_43_Status;
		Status_Link_44_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag;
		Status_Link_44_Status, phys_DIAG_EVENT_SWITCH_Status_Link_44_Status;
		Status_Link_45_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag;
		Status_Link_45_Status, phys_DIAG_EVENT_SWITCH_Status_Link_45_Status;
		Status_Link_46_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag;
		Status_Link_46_Status, phys_DIAG_EVENT_SWITCH_Status_Link_46_Status;
		Status_Link_47_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag;
		Status_Link_47_Status, phys_DIAG_EVENT_SWITCH_Status_Link_47_Status;
		Status_Link_48_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag;
		Status_Link_48_Status, phys_DIAG_EVENT_SWITCH_Status_Link_48_Status;*/
		Slot, phys_DIAG_EVENT_SWITCH_Slot;
		Index, phys_DIAG_EVENT_SWITCH_Index;
	}
}

/*VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag
{
	LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag_label];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag_enum_0] },
		{ 1, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag_enum_1] },
		{ 2, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag_enum_2] },
		{ 3, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag_enum_3] },
		{ 4, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag_enum_4] },
		{ 5, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag_enum_5] }
	}
}

VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1_Status
{
	LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_label];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_0] },
		{ 1, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_1] },
		{ 2, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_2] },
		{ 3, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_3] },
		{ 4, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_4] },
		{ 5, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_5] },
		{ 6, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_6] },
		{ 7, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_7] },
		{ 8, [PI_phys_DIAG_EVENT_SWITCH_Status_Link_1_Status_enum_8] }
	}
}*/

#define DIAG_EVENT_SWITCH_DIAG_STATUS_NO_INFLUENCE_GOOD_OK         0x00
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_REQUEST_GOOD     0x12
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_DEMAND_UNCERTAIN 0x25
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MEASUREMENT_UNCERTAIN_CL     0x25
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_ALARM_BAD        0x34
#define DIAG_EVENT_SWITCH_DIAG_STATUS_HW_ELECTR_BAD_CL             0x34
#define DIAG_EVENT_SWITCH_DIAG_STATUS_INVALID_PROCESS_COND_UNC     0x45
#define DIAG_EVENT_SWITCH_DIAG_STATUS_INVALID_PROCESS_COND_BAD     0x46
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MEASUREMENT_BAD_CL           0x46
#define DIAG_EVENT_SWITCH_DIAG_STATUS_FUNCTION_CHECK_GOOD          0x58
#define DIAG_EVENT_SWITCH_DIAG_STATUS_NO_INFLUENCE_UNCERTAIN_CL    0x58

#define PHYS_EVENT_SWITCH_DIAG_STATUS_CONDENSED \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_NO_INFLUENCE_GOOD_OK,          TXT_DIAG_EVENT_NOINFLUENCE_OK }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_REQUEST_GOOD,      TXT_DIAG_EVENT_MAINTREQ_GOOD }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_DEMAND_UNCERTAIN,  TXT_DIAG_EVENT_MAINTDEMAND_UNCERTAIN }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_ALARM_BAD,         TXT_DIAG_EVENT_MAINTALARM_MAINTALARM }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_INVALID_PROCESS_COND_UNC,      TXT_DIAG_EVENT_INV_PROC_COND_UNCERT }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_FUNCTION_CHECK_GOOD,           TXT_DIAG_EVENT_FUNCTCHECK_GOOD }


VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT1;
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		PHYS_EVENT_SWITCH_DIAG_STATUS_CONDENSED
	}
}

phys_DIAG_EVENT_SWITCH_Status_Link_0 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT0;
}

phys_DIAG_EVENT_SWITCH_Status_Link_2 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT2;
}

phys_DIAG_EVENT_SWITCH_Status_Link_3 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT3;
}

phys_DIAG_EVENT_SWITCH_Status_Link_4 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT4;
}

phys_DIAG_EVENT_SWITCH_Status_Link_5 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT5;
}

phys_DIAG_EVENT_SWITCH_Status_Link_6 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT6;
}

phys_DIAG_EVENT_SWITCH_Status_Link_7 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT7;
}

phys_DIAG_EVENT_SWITCH_Status_Link_8 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT8;
}

phys_DIAG_EVENT_SWITCH_Status_Link_9 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT9;
}

phys_DIAG_EVENT_SWITCH_Status_Link_10 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT10;
}

phys_DIAG_EVENT_SWITCH_Status_Link_11 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT11;
}

phys_DIAG_EVENT_SWITCH_Status_Link_12 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT12;
}

phys_DIAG_EVENT_SWITCH_Status_Link_13 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT13;
}

phys_DIAG_EVENT_SWITCH_Status_Link_14 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT14;
}

phys_DIAG_EVENT_SWITCH_Status_Link_15 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT15;
}

phys_DIAG_EVENT_SWITCH_Status_Link_16 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT16;
}

phys_DIAG_EVENT_SWITCH_Status_Link_17 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT17;
}

phys_DIAG_EVENT_SWITCH_Status_Link_18 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT18;
}

phys_DIAG_EVENT_SWITCH_Status_Link_19 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT19;
}

phys_DIAG_EVENT_SWITCH_Status_Link_20 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT20;
}

phys_DIAG_EVENT_SWITCH_Status_Link_21 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT21;
}

phys_DIAG_EVENT_SWITCH_Status_Link_22 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT22;
}

phys_DIAG_EVENT_SWITCH_Status_Link_23 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT23;
}

phys_DIAG_EVENT_SWITCH_Status_Link_24 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT24;
}

phys_DIAG_EVENT_SWITCH_Status_Link_25 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT25;
}

phys_DIAG_EVENT_SWITCH_Status_Link_26 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT26;
}

phys_DIAG_EVENT_SWITCH_Status_Link_27 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT27;
}

phys_DIAG_EVENT_SWITCH_Status_Link_28 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT28;
}

phys_DIAG_EVENT_SWITCH_Status_Link_29 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT29;
}

phys_DIAG_EVENT_SWITCH_Status_Link_30 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT30;
}

phys_DIAG_EVENT_SWITCH_Status_Link_31 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT31;
}

phys_DIAG_EVENT_SWITCH_Status_Link_32 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT31;
}

phys_DIAG_EVENT_SWITCH_Status_Link_33 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_34 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_35 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_36 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_37 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_38 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_39 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_40 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_41 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_42 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_43 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_44 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_45 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_46 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag_label];
}

phys_DIAG_EVENT_SWITCH_Status_Link_47 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag_label];
}
/*
phys_DIAG_EVENT_SWITCH_Status_Link_48 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
{
	REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag_label];
}*/

VARIABLE phys_DIAG_EVENT_SWITCH_Slot
{
	LABEL [PI_phys_DIAG_EVENT_SWITCH_Slot_label];
	HELP [PI_phys_DIAG_EVENT_SWITCH_Slot_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE phys_DIAG_EVENT_SWITCH_Index
{
	LABEL [PI_phys_DIAG_EVENT_SWITCH_Index_label];
	HELP [PI_phys_DIAG_EVENT_SWITCH_Index_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE phys_DEVICE_LOCK
{
	LABEL TXT_DEVICE_LOCK;
	HELP TXT_DEVICE_LOCK_HLP;
	CLASS CONTAINED;
	HANDLING READ & WRITE;
	TYPE ENUMERATED(1)
	{
		{ 0, TXT_DEVICE_LOCK_0, " " },
		{ 1, TXT_DEVICE_LOCK_1, " " }
	}
}

VARIABLE phys_PTA_OP_CODE
{
	LABEL [PI_phys_PTA_OP_CODE_label];
	HELP [PI_phys_PTA_OP_CODE_help];
	CLASS CONTAINED & DYNAMIC;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_phys_PTA_OP_CODE_enum_0], [PI_phys_PTA_OP_CODE_enum_0_help] },
		{ 1, [PI_phys_PTA_OP_CODE_enum_1], [PI_phys_PTA_OP_CODE_enum_1_help] },
		{ 2, [PI_phys_PTA_OP_CODE_enum_2], [PI_phys_PTA_OP_CODE_enum_2_help] },
		{ 3, [PI_phys_PTA_OP_CODE_enum_3], [PI_phys_PTA_OP_CODE_enum_3_help] },
		{ 4, [PI_phys_PTA_OP_CODE_enum_4], [PI_phys_PTA_OP_CODE_enum_4_help] },
		{ 5, [PI_phys_PTA_OP_CODE_enum_5], [PI_phys_PTA_OP_CODE_enum_5_help] }
	}
}

VARIABLE phys_PTA_STATUS
{
	LABEL [PI_phys_PTA_STATUS_label];
	HELP [PI_phys_PTA_STATUS_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 1, [PI_phys_PTA_STATUS_enum_1], [PI_phys_PTA_STATUS_enum_1_help] },
		{ 2, [PI_phys_PTA_STATUS_enum_2], [PI_phys_PTA_STATUS_enum_2_help] },
		{ 3, [PI_phys_PTA_STATUS_enum_3], [PI_phys_PTA_STATUS_enum_3_help] },
		{ 4, [PI_phys_PTA_STATUS_enum_4], [PI_phys_PTA_STATUS_enum_4_help] },
		{ 5, [PI_phys_PTA_STATUS_enum_5], [PI_phys_PTA_STATUS_enum_5_help] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

COLLECTION phys_VIEW_1
{
	LABEL [PI_phys_VIEW_1_label];
	HELP [PI_VIEW_1_help];
	MEMBERS
	{
		ST_REV, phys_ST_REV;
		MODE_BLK, phys_MODE_BLK;
		ALARM_SUM, phys_ALARM_SUM;
		DIAGNOSIS, phys_DIAGNOSIS;
	}
}

COLLECTION phys_VIEW_2
{
	LABEL [PI_phys_VIEW_2_label];
	HELP [PI_VIEW_2_help];
	MEMBERS
	{
		ST_REV, phys_ST_REV;
		MODE_BLK, phys_MODE_BLK;
		ALARM_SUM, phys_ALARM_SUM;
		DIAGNOSIS, phys_DIAGNOSIS;
		DIAGNOSIS_EXTENSION, phys_DIAGNOSIS_EXTENSION;
		WRITE_LOCKING, phys_WRITE_LOCKING;
		HW_WRITE_PROTECTION, phys_HW_WRITE_PROTECTION;
		FEATURE, phys_FEATURE;
		COND_STATUS_DIAG, phys_COND_STATUS_DIAG;
	}
}

COLLECTION phys_VIEW_3
{
	LABEL [PI_phys_VIEW_3_label];
	HELP [PI_VIEW_3_help];
	MEMBERS
	{
		TAG_DESC, phys_TAG_DESC;
		STRATEGY, phys_STRATEGY;
		ALERT_KEY, phys_ALERT_KEY;
		TARGET_MODE, phys_TARGET_MODE;
		DESCRIPTOR, phys_DESCRIPTOR;
		DEVICE_MESSAGE, phys_DEVICE_MESSAGE;
		DEVICE_INSTAL_DATE, phys_DEVICE_INSTAL_DATE;
		LOCAL_OP_ENA, phys_LOCAL_OP_ENA;
		IDENT_NUMBER_SELECTOR, phys_IDENT_NUMBER_SELECTOR;
	}
}

COLLECTION phys_VIEW_4
{
	LABEL [PI_phys_VIEW_4_label];
	HELP [PI_VIEW_4_help];
	MEMBERS
	{
		SOFTWARE_REVISION, phys_SOFTWARE_REVISION;
		HARDWARE_REVISION, phys_HARDWARE_REVISION;
		DEVICE_MAN_ID, phys_DEVICE_MAN_ID;
		DEVICE_ID, phys_DEVICE_ID;
		DEVICE_SER_NUM, phys_DEVICE_SER_NUM;
		DIAGNOSIS_MASK, phys_DIAGNOSIS_MASK;
		DIAGNOSIS_MASK_EXTENSION, phys_DIAGNOSIS_MASK_EXTENSION;
		DEVICE_CERTIFICATION, phys_DEVICE_CERTIFICATION;
	}
}

/* simple GUI */

MENU phys_Simple_Dialog_Mandatory_A
{
	LABEL [PI_phys_Simple_Dialog_Mandatory_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		phys_BLOCK_OBJECT_page,
		phys_ST_REV_page,
		phys_TAG_DESC_page,
		phys_STRATEGY_page,
		phys_ALERT_KEY_page,
		phys_TARGET_MODE_page,
		phys_MODE_BLK_page,
		phys_ALARM_SUM_page,
		phys_SOFTWARE_REVISION_page,
		phys_HARDWARE_REVISION_page,
		phys_DEVICE_MAN_ID_page,
		phys_DEVICE_ID_page,
		phys_DEVICE_SER_NUM_page,
		phys_DIAGNOSIS_page,
		phys_DIAGNOSIS_MASK_page,
		phys_FEATURE_page,
		phys_COND_STATUS_DIAG_page
	}
}

MENU phys_Simple_Dialog_Optional_A
{
	LABEL [PI_phys_Simple_Dialog_Optional_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		phys_BLOCK_OBJECT_page,
		phys_ST_REV_page,
		phys_TAG_DESC_page,
		phys_STRATEGY_page,
		phys_ALERT_KEY_page,
		phys_TARGET_MODE_page,
		phys_MODE_BLK_page,
		phys_ALARM_SUM_page,
		phys_SOFTWARE_REVISION_page,
		phys_HARDWARE_REVISION_page,
		phys_DEVICE_MAN_ID_page,
		phys_DEVICE_ID_page,
		phys_DEVICE_SER_NUM_page,
		phys_DIAGNOSIS_page,
		phys_DIAGNOSIS_EXTENSION_page,
		phys_DIAGNOSIS_MASK_page,
		phys_DIAGNOSIS_MASK_EXTENSION_page,
		phys_DEVICE_CERTIFICATION_page,
		phys_WRITE_LOCKING_page,
		phys_FACTORY_RESET_page,
		phys_DESCRIPTOR_page,
		phys_DEVICE_MESSAGE_page,
		phys_DEVICE_INSTAL_DATE_page,
		phys_LOCAL_OP_ENA_page,
		phys_IDENT_NUMBER_SELECTOR_page,
		phys_HW_WRITE_PROTECTION_page,
		phys_FEATURE_page,
		phys_COND_STATUS_DIAG_page,
		phys_DIAG_EVENT_SWITCH_page,
		/*MSH. PTA wird vom Geraet nicht unterstuetzt, ist optional, steuert sonst wie mit Fehlern in Parametern umgegangen wird
    phys_PTA_OP_CODE_page,
		phys_PTA_STATUS_page,*/
		phys_VIEW_1_page,
		phys_VIEW_2_page,
		phys_VIEW_3_page,
		phys_VIEW_4_page
	}
}

MENU phys_Simple_Dialog_Mandatory_B
{
	LABEL [PI_phys_Simple_Dialog_Mandatory_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		phys_BLOCK_OBJECT_page,
		phys_ST_REV_page,
		phys_TAG_DESC_page,
		phys_STRATEGY_page,
		phys_ALERT_KEY_page,
		phys_TARGET_MODE_page,
		phys_MODE_BLK_page,
		phys_ALARM_SUM_page,
		phys_SOFTWARE_REVISION_page,
		phys_HARDWARE_REVISION_page,
		phys_DEVICE_MAN_ID_page,
		phys_DEVICE_ID_page,
		phys_DEVICE_SER_NUM_page,
		phys_DIAGNOSIS_page,
		phys_DIAGNOSIS_MASK_page,
		phys_IDENT_NUMBER_SELECTOR_page,
		phys_FEATURE_page,
		phys_COND_STATUS_DIAG_page,
		phys_VIEW_1_page
	}
}

MENU phys_Simple_Dialog_Optional_B
{
	LABEL [PI_phys_Simple_Dialog_Optional_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		phys_BLOCK_OBJECT_page,
		phys_ST_REV_page,
		phys_TAG_DESC_page,
		phys_STRATEGY_page,
		phys_ALERT_KEY_page,
		phys_TARGET_MODE_page,
		phys_MODE_BLK_page,
		phys_ALARM_SUM_page,
		phys_SOFTWARE_REVISION_page,
		phys_HARDWARE_REVISION_page,
		phys_DEVICE_MAN_ID_page,
		phys_DEVICE_ID_page,
		phys_DEVICE_SER_NUM_page,
		phys_DIAGNOSIS_page,
		phys_DIAGNOSIS_EXTENSION_page,
		phys_DIAGNOSIS_MASK_page,
		phys_DIAGNOSIS_MASK_EXTENSION_page,
		phys_DEVICE_CERTIFICATION_page,
		phys_WRITE_LOCKING_page,
		phys_FACTORY_RESET_page,
		phys_DESCRIPTOR_page,
		phys_DEVICE_MESSAGE_page,
		phys_DEVICE_INSTAL_DATE_page,
		phys_LOCAL_OP_ENA_page,
		phys_IDENT_NUMBER_SELECTOR_page,
		phys_HW_WRITE_PROTECTION_page,
		phys_FEATURE_page,
		phys_COND_STATUS_DIAG_page,
		phys_DIAG_EVENT_SWITCH_page,
		/*MSH. PTA wird vom Geraet nicht unterstuetzt, ist optional, steuert sonst wie mit Fehlern in Parametern umgegangen wird
    phys_PTA_OP_CODE_page,
		phys_PTA_STATUS_page,*/
		phys_VIEW_1_page,
		phys_VIEW_2_page,
		phys_VIEW_3_page,
		phys_VIEW_4_page
	}
}

MENU phys_BLOCK_OBJECT_page
{
	LABEL [PI_BLOCK_OBJECT_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_BLOCK_OBJECT
	}
}

MENU phys_ST_REV_page
{
	LABEL [PI_ST_REV_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_ST_REV
	}
}

MENU phys_TAG_DESC_page
{
	LABEL [PI_TAG_DESC_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_TAG_DESC
	}
}

MENU phys_STRATEGY_page
{
	LABEL [PI_STRATEGY_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_STRATEGY
	}
}

MENU phys_ALERT_KEY_page
{
	LABEL [PI_ALERT_KEY_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_ALERT_KEY
	}
}

MENU phys_TARGET_MODE_page
{
	LABEL [PI_TARGET_MODE_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_TARGET_MODE
	}
}

MENU phys_MODE_BLK_page
{
	LABEL [PI_MODE_BLK_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_MODE_BLK
	}
}

MENU phys_ALARM_SUM_page
{
	LABEL [PI_ALARM_SUM_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_ALARM_SUM
	}
}

MENU phys_SOFTWARE_REVISION_page
{
	LABEL [PI_phys_SOFTWARE_REVISION_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_SOFTWARE_REVISION
	}
}

MENU phys_HARDWARE_REVISION_page
{
	LABEL [PI_phys_HARDWARE_REVISION_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_HARDWARE_REVISION
	}
}

MENU phys_DEVICE_MAN_ID_page
{
	LABEL [PI_phys_DEVICE_MAN_ID_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DEVICE_MAN_ID
	}
}

MENU phys_DEVICE_ID_page
{
	LABEL [PI_phys_DEVICE_ID_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DEVICE_ID
	}
}

MENU phys_DEVICE_SER_NUM_page
{
	LABEL [PI_phys_DEVICE_SER_NUM_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DEVICE_SER_NUM
	}
}

MENU phys_DIAGNOSIS_page
{
	LABEL [PI_phys_DIAGNOSIS_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DIAGNOSIS
	}
}

MENU phys_DIAGNOSIS_EXTENSION_page
{
	LABEL [PI_phys_DIAGNOSIS_EXTENSION_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DIAGNOSIS_EXTENSION
	}
}

MENU phys_DIAGNOSIS_MASK_page
{
	LABEL [PI_phys_DIAGNOSIS_MASK_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DIAGNOSIS_MASK
	}
}

MENU phys_DIAGNOSIS_MASK_EXTENSION_page
{
	LABEL [PI_phys_DIAGNOSIS_MASK_EXTENSION_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DIAGNOSIS_MASK_EXTENSION
	}
}

MENU phys_DEVICE_CERTIFICATION_page
{
	LABEL [PI_phys_DEVICE_CERTIFICATION_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DEVICE_CERTIFICATION
	}
}

MENU phys_WRITE_LOCKING_page
{
	LABEL [PI_phys_WRITE_LOCKING_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_WRITE_LOCKING
	}
}

MENU phys_FACTORY_RESET_page
{
	LABEL [PI_phys_FACTORY_RESET_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_FACTORY_RESET
	}
}

MENU phys_DESCRIPTOR_page
{
	LABEL [PI_phys_DESCRIPTOR_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DESCRIPTOR
	}
}

MENU phys_DEVICE_MESSAGE_page
{
	LABEL [PI_phys_DEVICE_MESSAGE_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DEVICE_MESSAGE
	}
}

MENU phys_DEVICE_INSTAL_DATE_page
{
	LABEL [PI_phys_DEVICE_INSTAL_DATE_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DEVICE_INSTAL_DATE
	}
}

MENU phys_LOCAL_OP_ENA_page
{
	LABEL [PI_phys_LOCAL_OP_ENA_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_LOCAL_OP_ENA
	}
}

MENU phys_IDENT_NUMBER_SELECTOR_page
{
	LABEL [PI_phys_IDENT_NUMBER_SELECTOR_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_IDENT_NUMBER_SELECTOR
	}
}

MENU phys_HW_WRITE_PROTECTION_page
{
	LABEL [PI_phys_HW_WRITE_PROTECTION_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_HW_WRITE_PROTECTION
	}
}

MENU phys_FEATURE_page
{
	LABEL [PI_phys_FEATURE_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_FEATURE
	}
}

MENU phys_COND_STATUS_DIAG_page
{
	LABEL [PI_phys_COND_STATUS_DIAG_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_COND_STATUS_DIAG
	}
}

MENU phys_DIAG_EVENT_SWITCH_page
{
	LABEL [PI_phys_DIAG_EVENT_SWITCH_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_DIAG_EVENT_SWITCH
	}
}

MENU phys_PTA_OP_CODE_page
{
	LABEL [PI_phys_PTA_OP_CODE_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_PTA_OP_CODE
	}
}

MENU phys_PTA_STATUS_page
{
	LABEL [PI_phys_PTA_STATUS_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_PTA_STATUS
	}
}

MENU phys_VIEW_1_page
{
	LABEL [PI_VIEW_1_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_VIEW_1
	}
}

MENU phys_VIEW_2_page
{
	LABEL [PI_VIEW_2_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_VIEW_2
	}
}

MENU phys_VIEW_3_page
{
	LABEL [PI_VIEW_3_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_VIEW_3
	}
}

MENU phys_VIEW_4_page
{
	LABEL [PI_VIEW_4_page_label];
	STYLE PAGE;
	ITEMS
	{
		phys_VIEW_4
	}
}

/* COMMANDs */

COMMAND phys_BLOCK_OBJECT_read
{
	BLOCK phys_block;
	INDEX 0;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_BLOCK_OBJECT_Reserved,
			phys_BLOCK_OBJECT_Block_Object,
			phys_BLOCK_OBJECT_Parent_Class,
			phys_BLOCK_OBJECT_Class,
			phys_BLOCK_OBJECT_Dev_Rev,
			phys_BLOCK_OBJECT_Dev_Rev_Comp,
			phys_BLOCK_OBJECT_DD_Revision,
			phys_BLOCK_OBJECT_Profile,
			phys_BLOCK_OBJECT_Profile_Revision,
			phys_BLOCK_OBJECT_Execution_Time,
			phys_BLOCK_OBJECT_Number_of_Parameters,
			phys_BLOCK_OBJECT_Address_of_VIEW_1_Slot,
			phys_BLOCK_OBJECT_Address_of_VIEW_1_Index,
			phys_BLOCK_OBJECT_Number_of_Views
		}
	}
}

COMMAND phys_ST_REV_read
{
	BLOCK phys_block;
	INDEX 1;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ST_REV
		}
	}
}

COMMAND phys_TAG_DESC_read
{
	BLOCK phys_block;
	INDEX 2;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_TAG_DESC
		}
	}
}

COMMAND phys_TAG_DESC_write
{
	BLOCK phys_block;
	INDEX 2;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_TAG_DESC
		}
		REPLY
		{
		}
	}
}

COMMAND phys_STRATEGY_read
{
	BLOCK phys_block;
	INDEX 3;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_STRATEGY
		}
	}
}

COMMAND phys_STRATEGY_write
{
	BLOCK phys_block;
	INDEX 3;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_STRATEGY
		}
		REPLY
		{
		}
	}
}

COMMAND phys_ALERT_KEY_read
{
	BLOCK phys_block;
	INDEX 4;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ALERT_KEY
		}
	}
}

COMMAND phys_ALERT_KEY_write
{
	BLOCK phys_block;
	INDEX 4;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_ALERT_KEY
		}
		REPLY
		{
		}
	}
}

COMMAND phys_TARGET_MODE_read
{
	BLOCK phys_block;
	INDEX 5;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_TARGET_MODE
		}
	}
}

COMMAND phys_TARGET_MODE_write
{
	BLOCK phys_block;
	INDEX 5;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_TARGET_MODE
		}
		REPLY
		{
		}
	}
}

COMMAND phys_MODE_BLK_read
{
	BLOCK phys_block;
	INDEX 6;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_MODE_BLK_Actual,
			phys_MODE_BLK_Permitted,
			phys_MODE_BLK_Normal
		}
	}
}

COMMAND phys_ALARM_SUM_read
{
	BLOCK phys_block;
	INDEX 7;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ALARM_SUM_Current,
			phys_ALARM_SUM_Unacknowledged,
			phys_ALARM_SUM_Unreported,
			phys_ALARM_SUM_Disabled
		}
	}
}

COMMAND phys_SOFTWARE_REVISION_read
{
	BLOCK phys_block;
	INDEX 8;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_SOFTWARE_REVISION
		}
	}
}

COMMAND phys_HARDWARE_REVISION_read
{
	BLOCK phys_block;
	INDEX 9;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_HARDWARE_REVISION
		}
	}
}

COMMAND phys_DEVICE_MAN_ID_read
{
	BLOCK phys_block;
	INDEX 10;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DEVICE_MAN_ID
		}
	}
}

COMMAND phys_DEVICE_ID_read
{
	BLOCK phys_block;
	INDEX 11;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DEVICE_ID
		}
	}
}

COMMAND phys_DEVICE_SER_NUM_read
{
	BLOCK phys_block;
	INDEX 12;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DEVICE_SER_NUM
		}
	}
}

COMMAND phys_DIAGNOSIS_read
{
	BLOCK phys_block;
	INDEX 13;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DIAGNOSIS
		}
	}
}

COMMAND phys_DIAGNOSIS_EXTENSION_read
{
	BLOCK phys_block;
	INDEX 14;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DIAGNOSIS_EXTENSION,
      phys_DIAGNOSIS_EXTENSION2
		}
	}
}

COMMAND phys_DIAGNOSIS_MASK_read
{
	BLOCK phys_block;
	INDEX 15;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DIAGNOSIS_MASK
		}
	}
}

COMMAND phys_DIAGNOSIS_MASK_EXTENSION_read
{
	BLOCK phys_block;
	INDEX 16;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DIAGNOSIS_MASK_EXTENSION,
      phys_DIAGNOSIS_MASK_EXTENSION2
		}
	}
}

COMMAND phys_DEVICE_CERTIFICATION_read
{
	BLOCK phys_block;
	INDEX 17;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DEVICE_CERTIFICATION
		}
	}
}

COMMAND phys_WRITE_LOCKING_read
{
	BLOCK phys_block;
	INDEX 18;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_WRITE_LOCKING
		}
	}
}

COMMAND phys_WRITE_LOCKING_write
{
	BLOCK phys_block;
	INDEX 18;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_WRITE_LOCKING
		}
		REPLY
		{
		}
	}
}

COMMAND phys_FACTORY_RESET_read
{
	BLOCK phys_block;
	INDEX 19;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_FACTORY_RESET
		}
	}
}

COMMAND phys_FACTORY_RESET_write
{
	BLOCK phys_block;
	INDEX 19;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_FACTORY_RESET
		}
		REPLY
		{
		}
	}
}

COMMAND phys_DESCRIPTOR_read
{
	BLOCK phys_block;
	INDEX 20;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DESCRIPTOR
		}
	}
}

COMMAND phys_DESCRIPTOR_write
{
	BLOCK phys_block;
	INDEX 20;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_DESCRIPTOR
		}
		REPLY
		{
		}
	}
}

COMMAND phys_DEVICE_MESSAGE_read
{
	BLOCK phys_block;
	INDEX 21;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DEVICE_MESSAGE
		}
	}
}

COMMAND phys_DEVICE_MESSAGE_write
{
	BLOCK phys_block;
	INDEX 21;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_DEVICE_MESSAGE
		}
		REPLY
		{
		}
	}
}

COMMAND phys_DEVICE_INSTAL_DATE_read
{
	BLOCK phys_block;
	INDEX 22;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DEVICE_INSTAL_DATE
		}
	}
}

COMMAND phys_DEVICE_INSTAL_DATE_write
{
	BLOCK phys_block;
	INDEX 22;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_DEVICE_INSTAL_DATE
		}
		REPLY
		{
		}
	}
}

COMMAND phys_LOCAL_OP_ENA_read
{
	BLOCK phys_block;
	INDEX 23;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_LOCAL_OP_ENA
		}
	}
}

COMMAND phys_LOCAL_OP_ENA_write
{
	BLOCK phys_block;
	INDEX 23;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_LOCAL_OP_ENA
		}
		REPLY
		{
		}
	}
}

COMMAND phys_IDENT_NUMBER_SELECTOR_read
{
	BLOCK phys_block;
	INDEX 24;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_IDENT_NUMBER_SELECTOR
		}
	}
}

COMMAND phys_IDENT_NUMBER_SELECTOR_write
{
	BLOCK phys_block;
	INDEX 24;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_IDENT_NUMBER_SELECTOR
		}
		REPLY
		{
		}
	}
}

COMMAND phys_HW_WRITE_PROTECTION_read
{
	BLOCK phys_block;
	INDEX 25;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_HW_WRITE_PROTECTION
		}
	}
}

COMMAND phys_FEATURE_read
{
	BLOCK phys_block;
	INDEX 26;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_FEATURE_Supported,
			phys_FEATURE_Enabled
		}
	}
}

COMMAND phys_COND_STATUS_DIAG_read
{
	BLOCK phys_block;
	INDEX 27;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_COND_STATUS_DIAG
		}
	}
}

COMMAND phys_COND_STATUS_DIAG_write
{
	BLOCK phys_block;
	INDEX 27;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_COND_STATUS_DIAG
		}
		REPLY
		{
		}
	}
}

COMMAND phys_DIAG_EVENT_SWITCH_read
{
	BLOCK phys_block;
	INDEX 28;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
      phys_DIAG_EVENT_SWITCH_Status_Link_0,
      phys_DIAG_EVENT_SWITCH_Status_Link_1,
      phys_DIAG_EVENT_SWITCH_Status_Link_2,
      phys_DIAG_EVENT_SWITCH_Status_Link_3,
      phys_DIAG_EVENT_SWITCH_Status_Link_4,
      phys_DIAG_EVENT_SWITCH_Status_Link_5,
      phys_DIAG_EVENT_SWITCH_Status_Link_6,
      phys_DIAG_EVENT_SWITCH_Status_Link_7,
      phys_DIAG_EVENT_SWITCH_Status_Link_8,
      phys_DIAG_EVENT_SWITCH_Status_Link_9,
      phys_DIAG_EVENT_SWITCH_Status_Link_10,
      phys_DIAG_EVENT_SWITCH_Status_Link_11,
      phys_DIAG_EVENT_SWITCH_Status_Link_12,
      phys_DIAG_EVENT_SWITCH_Status_Link_13,
      phys_DIAG_EVENT_SWITCH_Status_Link_14,
      phys_DIAG_EVENT_SWITCH_Status_Link_15,
      phys_DIAG_EVENT_SWITCH_Status_Link_16,
      phys_DIAG_EVENT_SWITCH_Status_Link_17,
      phys_DIAG_EVENT_SWITCH_Status_Link_18,
      phys_DIAG_EVENT_SWITCH_Status_Link_19,
      phys_DIAG_EVENT_SWITCH_Status_Link_20,
      phys_DIAG_EVENT_SWITCH_Status_Link_21,
      phys_DIAG_EVENT_SWITCH_Status_Link_22,
      phys_DIAG_EVENT_SWITCH_Status_Link_23,
      phys_DIAG_EVENT_SWITCH_Status_Link_24,
      phys_DIAG_EVENT_SWITCH_Status_Link_25,
      phys_DIAG_EVENT_SWITCH_Status_Link_26,
      phys_DIAG_EVENT_SWITCH_Status_Link_27,
      phys_DIAG_EVENT_SWITCH_Status_Link_28,
      phys_DIAG_EVENT_SWITCH_Status_Link_29,
      phys_DIAG_EVENT_SWITCH_Status_Link_30,
      phys_DIAG_EVENT_SWITCH_Status_Link_31,
      phys_DIAG_EVENT_SWITCH_Status_Link_32,
      phys_DIAG_EVENT_SWITCH_Status_Link_33,
      phys_DIAG_EVENT_SWITCH_Status_Link_34,
      phys_DIAG_EVENT_SWITCH_Status_Link_35,
      phys_DIAG_EVENT_SWITCH_Status_Link_36,
      phys_DIAG_EVENT_SWITCH_Status_Link_37,
      phys_DIAG_EVENT_SWITCH_Status_Link_38,
      phys_DIAG_EVENT_SWITCH_Status_Link_39,
      phys_DIAG_EVENT_SWITCH_Status_Link_40,
      phys_DIAG_EVENT_SWITCH_Status_Link_41,
      phys_DIAG_EVENT_SWITCH_Status_Link_42,
      phys_DIAG_EVENT_SWITCH_Status_Link_43,
      phys_DIAG_EVENT_SWITCH_Status_Link_44,
      phys_DIAG_EVENT_SWITCH_Status_Link_45,
      phys_DIAG_EVENT_SWITCH_Status_Link_46,
      phys_DIAG_EVENT_SWITCH_Status_Link_47,      
			/*phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_1_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_2_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_2_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_3_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_3_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_4_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_4_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_5_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_5_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_6_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_6_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_7_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_7_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_8_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_8_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_9_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_9_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_10_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_10_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_11_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_11_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_12_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_12_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_13_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_13_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_14_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_14_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_15_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_15_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_16_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_16_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_17_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_17_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_18_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_18_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_19_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_19_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_20_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_20_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_21_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_21_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_22_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_22_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_23_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_23_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_24_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_24_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_25_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_25_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_26_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_26_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_27_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_27_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_28_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_28_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_29_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_29_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_30_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_30_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_31_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_31_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_32_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_32_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_33_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_34_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_35_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_36_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_37_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_38_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_39_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_40_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_41_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_42_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_43_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_44_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_45_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_46_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_47_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_48_Status <0x0f>,*/
			phys_DIAG_EVENT_SWITCH_Slot,
			phys_DIAG_EVENT_SWITCH_Index
		}
	}
}

COMMAND phys_DIAG_EVENT_SWITCH_write
{
	BLOCK phys_block;
	INDEX 28;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
      phys_DIAG_EVENT_SWITCH_Status_Link_0,
      phys_DIAG_EVENT_SWITCH_Status_Link_1,
      phys_DIAG_EVENT_SWITCH_Status_Link_2,
      phys_DIAG_EVENT_SWITCH_Status_Link_3,
      phys_DIAG_EVENT_SWITCH_Status_Link_4,
      phys_DIAG_EVENT_SWITCH_Status_Link_5,
      phys_DIAG_EVENT_SWITCH_Status_Link_6,
      phys_DIAG_EVENT_SWITCH_Status_Link_7,
      phys_DIAG_EVENT_SWITCH_Status_Link_8,
      phys_DIAG_EVENT_SWITCH_Status_Link_9,
      phys_DIAG_EVENT_SWITCH_Status_Link_10,
      phys_DIAG_EVENT_SWITCH_Status_Link_11,
      phys_DIAG_EVENT_SWITCH_Status_Link_12,
      phys_DIAG_EVENT_SWITCH_Status_Link_13,
      phys_DIAG_EVENT_SWITCH_Status_Link_14,
      phys_DIAG_EVENT_SWITCH_Status_Link_15,
      phys_DIAG_EVENT_SWITCH_Status_Link_16,
      phys_DIAG_EVENT_SWITCH_Status_Link_17,
      phys_DIAG_EVENT_SWITCH_Status_Link_18,
      phys_DIAG_EVENT_SWITCH_Status_Link_19,
      phys_DIAG_EVENT_SWITCH_Status_Link_20,
      phys_DIAG_EVENT_SWITCH_Status_Link_21,
      phys_DIAG_EVENT_SWITCH_Status_Link_22,
      phys_DIAG_EVENT_SWITCH_Status_Link_23,
      phys_DIAG_EVENT_SWITCH_Status_Link_24,
      phys_DIAG_EVENT_SWITCH_Status_Link_25,
      phys_DIAG_EVENT_SWITCH_Status_Link_26,
      phys_DIAG_EVENT_SWITCH_Status_Link_27,
      phys_DIAG_EVENT_SWITCH_Status_Link_28,
      phys_DIAG_EVENT_SWITCH_Status_Link_29,
      phys_DIAG_EVENT_SWITCH_Status_Link_30,
      phys_DIAG_EVENT_SWITCH_Status_Link_31,
      phys_DIAG_EVENT_SWITCH_Status_Link_32,
      phys_DIAG_EVENT_SWITCH_Status_Link_33,
      phys_DIAG_EVENT_SWITCH_Status_Link_34,
      phys_DIAG_EVENT_SWITCH_Status_Link_35,
      phys_DIAG_EVENT_SWITCH_Status_Link_36,
      phys_DIAG_EVENT_SWITCH_Status_Link_37,
      phys_DIAG_EVENT_SWITCH_Status_Link_38,
      phys_DIAG_EVENT_SWITCH_Status_Link_39,
      phys_DIAG_EVENT_SWITCH_Status_Link_40,
      phys_DIAG_EVENT_SWITCH_Status_Link_41,
      phys_DIAG_EVENT_SWITCH_Status_Link_42,
      phys_DIAG_EVENT_SWITCH_Status_Link_43,
      phys_DIAG_EVENT_SWITCH_Status_Link_44,
      phys_DIAG_EVENT_SWITCH_Status_Link_45,
      phys_DIAG_EVENT_SWITCH_Status_Link_46,
      phys_DIAG_EVENT_SWITCH_Status_Link_47,      
      /*
			phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_1_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_2_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_2_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_3_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_3_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_4_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_4_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_5_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_5_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_6_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_6_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_7_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_7_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_8_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_8_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_9_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_9_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_10_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_10_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_11_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_11_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_12_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_12_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_13_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_13_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_14_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_14_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_15_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_15_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_16_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_16_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_17_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_17_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_18_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_18_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_19_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_19_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_20_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_20_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_21_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_21_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_22_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_22_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_23_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_23_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_24_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_24_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_25_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_25_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_26_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_26_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_27_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_27_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_28_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_28_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_29_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_29_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_30_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_30_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_31_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_31_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_32_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_32_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_33_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_34_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_35_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_36_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_37_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_38_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_39_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_40_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_41_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_42_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_43_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_44_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_45_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_46_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_47_Status <0x0f>,
			phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag <0xf0>,
			phys_DIAG_EVENT_SWITCH_Status_Link_48_Status <0x0f>,*/
			phys_DIAG_EVENT_SWITCH_Slot,
			phys_DIAG_EVENT_SWITCH_Index
		}
		REPLY
		{
		}
	}
}

COMMAND phys_DEVICE_LOCK_read
{
	BLOCK phys_block;
	INDEX 34;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_DEVICE_LOCK
		}
	}
}

COMMAND phys_DEVICE_LOCK_write
{
	BLOCK phys_block;
	INDEX 34;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_DEVICE_LOCK
		}
		REPLY
		{
		}
	}
}

COMMAND phys_PTA_OP_CODE_read
{
	BLOCK phys_block;
	INDEX 48;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_PTA_OP_CODE
		}
	}
}

COMMAND phys_PTA_OP_CODE_write
{
	BLOCK phys_block;
	INDEX 48;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			phys_PTA_OP_CODE
		}
		REPLY
		{
		}
	}
}

COMMAND phys_PTA_STATUS_read
{
	BLOCK phys_block;
	INDEX 49;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_PTA_STATUS
		}
	}
}

/* BEGIN post EDD */


// Aopt, Bopt:
// - MENU phys_Reset
// - MENU phys_Reset_page
// - METHOD phys_method_factory_reset_params
// - METHOD phys_method_factory_reset_warm
// - METHOD phys_method_factory_reset_address
// - METHOD phys_method_factory_reset_device_specific

MENU phys_Reset
{
	LABEL [PI_master_reset];
	HELP [PI_master_reset_help];
	STYLE WINDOW;
	ITEMS
	{
		phys_Reset_page
	}
}

MENU phys_Reset_page
{
	LABEL [PI_master_reset];
	HELP [PI_master_reset_help];
	STYLE PAGE;
	ITEMS
	{
		phys_DIAGNOSIS,
		ROWBREAK,
		phys_method_factory_reset_params,
		phys_method_factory_reset_warm,
		phys_method_factory_reset_address,
		phys_method_factory_reset_device_specific
	}
}

METHOD phys_method_factory_reset_params
{
	LABEL [PI_FACTORY_RESET_label];
	DEFINITION
	{
		ACKNOWLEDGE([PI_FACTORY_RESET_label]);

		phys_FACTORY_RESET = 1;

		WriteCommand(phys_FACTORY_RESET_write);
	}
}

METHOD phys_method_factory_reset_warm
{
	LABEL [PI_FACTORY_RESET_enum_2506];
	DEFINITION
	{
		char sz[512]; int iLen;
		int status;

		iLen = 500;
		get_dictionary_string(PI_FACTORY_RESET_enum_2506, sz, iLen);
		sz += "\r\n\r\n" ;
		sz += [PI_note_connection_will_be_aborted];

		ACKNOWLEDGE(sz);

		phys_FACTORY_RESET = 2506;

		status = WriteCommand(phys_FACTORY_RESET_write);
		if (status == 17456)
			ACKNOWLEDGE([PI_not_supported]);
	}
}

METHOD phys_method_factory_reset_address
{
	LABEL [PI_FACTORY_RESET_enum_2712];
	DEFINITION
	{
		char sz[512]; int iLen;
		int status;

		iLen = 500;
		get_dictionary_string(PI_FACTORY_RESET_enum_2712, sz, iLen);
		sz += "\r\n\r\n" ;
		sz += [PI_note_connection_will_be_aborted];

		ACKNOWLEDGE(sz);

		phys_FACTORY_RESET = 2712;

		status = WriteCommand(phys_FACTORY_RESET_write);
		if (status == 17456)
			ACKNOWLEDGE([PI_not_supported]);
	}
}

METHOD phys_method_factory_reset_device_specific
{
	LABEL [PI_device_specific_reset];
	DEFINITION
	{
		int status;

		GET_DEV_VAR_VALUE([PI_reset], phys_FACTORY_RESET);

		status = WriteCommand(phys_FACTORY_RESET_write);
		if (status == 17456)
			ACKNOWLEDGE([PI_not_supported]);
	}
}

// Aopt, Bopt:
// - MENU phys_Dialog_Write_Locking

MENU phys_Dialog_Write_Locking
{
	LABEL [PI_WRITE_LOCKING_label];
	HELP [PI_WRITE_LOCKING_help];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		phys_WRITE_LOCKING,
		phys_HW_WRITE_PROTECTION
	}
}

// Aopt, Bopt:
// - MENU phys_Dialog_Ident_Number_Selector

MENU phys_Dialog_Ident_Number_Selector
{
	LABEL [PI_IDENT_NUMBER_SELECTOR_label];
	HELP [PI_IDENT_NUMBER_SELECTOR_help];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		phys_IDENT_NUMBER_SELECTOR
	}
}

// Aman, Bman:
// - MENU phys_Diagnosis_page

MENU phys_Diagnosis_page
{
	LABEL [PI_BLOCK_OBJECT_Block_Object_enum_1];
	STYLE PAGE;
	ITEMS
	{
		phys_BLOCK_OBJECT_Block_Object,
		phys_BLOCK_OBJECT_Parent_Class,
		phys_BLOCK_OBJECT_Class,
		phys_BLOCK_OBJECT_Dev_Rev,
		phys_BLOCK_OBJECT_Dev_Rev_Comp,
		phys_BLOCK_OBJECT_DD_Revision,
		phys_BLOCK_OBJECT_Profile,
		phys_BLOCK_OBJECT_Profile_Revision,
		phys_ST_REV,
		phys_MODE_BLK_Actual
	}
}
/* END post EDD */
