
/*
 * $Id$
 * 
 * Copyright (C) PI 2007-2012. All rights reserved.
 * 
 * Version: 2.0.5
 * 
 */

#ifndef __STATUS_H
#define __STATUS_H

/**
 * Status enumeration list (complete).
 * This is the complete enumeration list of all defined status values.
 * The enumeration list can be used to define the enumerations of an
 * ENUMERATED status VARIABLE. The element 'Condensed_Status' of the 
 * Physical Block parameter FEATURE switch the enumeration between 
 * condensed and standard.
 */
/*IF ((phys_FEATURE_Enabled & 0x1) == 0x01) \*/
/*IF ((phys_FEATURE_Enabled & 0x01000000) == 0x01000000) \*/
#define PI_STATUS_LIST_ALL \
  IF ((phys_FEATURE_Enabled & 0x01000000) == 0x01000000) \
	{ \
		PI_STATUS_LIST_CONDENSED \
	} \
	ELSE \
	{ \
		PI_STATUS_LIST_STANDARD_ALL \
	}

/**
 * Status enumeration list (without standard status GOOD(C)).
 * This is the enumeration list of defined status values without the 
 * Quality GOOD(C) for standard status.
 * The enumeration list can be used to define the enumerations of an
 * ENUMERATED status VARIABLE. The element 'Condensed_Status' of the 
 * Physical Block parameter FEATURE switch the enumeration between 
 * condensed and standard.
 */
  /*IF ((phys_FEATURE_Enabled & 0x1) == 0x01) \*/
  /*IF ((phys_FEATURE_Enabled & 0x01000000) == 0x01000000) \*/
#define PI_STATUS_LIST_WITHOUT_CAS \
  IF ((phys_FEATURE_Enabled & 0x01000000) == 0x01000000) \
	{ \
		PI_STATUS_LIST_CONDENSED \
	} \
	ELSE \
	{ \
		PI_STATUS_LIST_STANDARD_INPUT \
	}

/**
 * Standard Status enumeration list (complete).
 * This is a internal enumeration list for all standard status elements.
 */
#define PI_STATUS_LIST_STANDARD_ALL \
		PI_STATUS_LIST_STANDARD_INPUT,\
		PI_STATUS_LIST_STANDARD_CAS

/**
 * Condensed Status enumeration list.
 * This is the complete enumeration list of all defined condensed status values.
 * The enumeration list can be used to define the enumerations of an
 * ENUMERATED condensed status VARIABLE, if standard status is not supported 
 * from the device. 
 */
#define PI_STATUS_LIST_CONDENSED \
		{ 0x00, [PI_status_BAD_00] },	\
		{ 0x23, [PI_Status_Quality_Limit_enum_0x23] },	\
		{ 0x24, [PI_Status_Quality_Limit_enum_0x24] },	\
		{ 0x25, [PI_Status_Quality_Limit_enum_0x25] },	\
		{ 0x26, [PI_Status_Quality_Limit_enum_0x26] },	\
		{ 0x27, [PI_Status_Quality_Limit_enum_0x27] },	\
		{ 0x28, [PI_Status_Quality_Limit_enum_0x28] },	\
		{ 0x29, [PI_Status_Quality_Limit_enum_0x29] },	\
		{ 0x2A, [PI_Status_Quality_Limit_enum_0x2A] },	\
		{ 0x2B, [PI_Status_Quality_Limit_enum_0x2B] },	\
		{ 0x3C, [PI_Status_Quality_Limit_enum_0x3C] },	\
		{ 0x3D, [PI_Status_Quality_Limit_enum_0x3D] },	\
		{ 0x3E, [PI_Status_Quality_Limit_enum_0x3E] },	\
		{ 0x3F, [PI_Status_Quality_Limit_enum_0x3F] },	\
		{ 0x4B, [PI_Status_Quality_Limit_enum_0x4B] },	\
		{ 0x4F, [PI_Status_Quality_Limit_enum_0x4F] },	\
		{ 0x68, [PI_Status_Quality_Limit_enum_0x68] },	\
		{ 0x69, [PI_Status_Quality_Limit_enum_0x69] },	\
		{ 0x6A, [PI_Status_Quality_Limit_enum_0x6A] },	\
		{ 0x6B, [PI_Status_Quality_Limit_enum_0x6B] },	\
		{ 0x73, [PI_Status_Quality_Limit_enum_0x73] },	\
		{ 0x74, [PI_Status_Quality_Limit_enum_0x74] },	\
		{ 0x75, [PI_Status_Quality_Limit_enum_0x75] },	\
		{ 0x76, [PI_Status_Quality_Limit_enum_0x76] },	\
		{ 0x77, [PI_Status_Quality_Limit_enum_0x77] },	\
		{ 0x78, [PI_Status_Quality_Limit_enum_0x78] },	\
		{ 0x79, [PI_Status_Quality_Limit_enum_0x79] },	\
		{ 0x7A, [PI_Status_Quality_Limit_enum_0x7A] },	\
		{ 0x7B, [PI_Status_Quality_Limit_enum_0x7B] },	\
		{ 0x80, [PI_Status_Quality_Limit_enum_0x80] },	\
		{ 0x83, [PI_Status_Quality_Limit_enum_0x83] },	\
		{ 0x84, [PI_Status_Quality_Limit_enum_0x84] },	\
		{ 0x85, [PI_Status_Quality_Limit_enum_0x85] },	\
		{ 0x86, [PI_Status_Quality_Limit_enum_0x86] },	\
		{ 0x87, [PI_Status_Quality_Limit_enum_0x87] },	\
		{ 0x89, [PI_Status_Quality_Limit_enum_0x89] },	\
		{ 0x8A, [PI_Status_Quality_Limit_enum_0x8A] },	\
		{ 0x8D, [PI_Status_Quality_Limit_enum_0x8D] },	\
		{ 0x8E, [PI_Status_Quality_Limit_enum_0x8E] },	\
		{ 0xA0, [PI_Status_Quality_Limit_enum_0xA0] },	\
		{ 0xA1, [PI_Status_Quality_Limit_enum_0xA1] },	\
		{ 0xA2, [PI_Status_Quality_Limit_enum_0xA2] },	\
		{ 0xA3, [PI_Status_Quality_Limit_enum_0xA3] },	\
		{ 0xA4, [PI_Status_Quality_Limit_enum_0xA4] },	\
		{ 0xA5, [PI_Status_Quality_Limit_enum_0xA5] },	\
		{ 0xA6, [PI_Status_Quality_Limit_enum_0xA6] },	\
		{ 0xA7, [PI_Status_Quality_Limit_enum_0xA7] },	\
		{ 0xA8, [PI_Status_Quality_Limit_enum_0xA8] },	\
		{ 0xA9, [PI_Status_Quality_Limit_enum_0xA9] },	\
		{ 0xAA, [PI_Status_Quality_Limit_enum_0xAA] },	\
		{ 0xAB, [PI_Status_Quality_Limit_enum_0xAB] },	\
		{ 0xBC, [PI_Status_Quality_Limit_enum_0xBC] },	\
		{ 0xBD, [PI_Status_Quality_Limit_enum_0xBD] },	\
		{ 0xBE, [PI_Status_Quality_Limit_enum_0xBE] },	\
		{ 0xBF, [PI_Status_Quality_Limit_enum_0xBF] }


/**
 * Standard Status enumeration list (without GOOD(C)).
 * This is a internal enumeration list for standard status 
 * without the Quality GOOD(C).
 */
#define PI_STATUS_LIST_STANDARD_INPUT \
		{ 0x80, [PI_status_GOOD_00_0] },	\
		{ 0x81, [PI_status_GOOD_00_1] },	\
		{ 0x82, [PI_status_GOOD_00_2] },	\
		{ 0x83, [PI_status_GOOD_00_3] },	\
		{ 0x84, [PI_status_GOOD_01_0] },	\
		{ 0x85, [PI_status_GOOD_01_1] },	\
		{ 0x86, [PI_status_GOOD_01_2] },	\
		{ 0x87, [PI_status_GOOD_01_3] },	\
		{ 0x88, [PI_status_GOOD_02_0] },	\
		{ 0x89, [PI_status_GOOD_02_1] },	\
		{ 0x8A, [PI_status_GOOD_02_2] },	\
		{ 0x8B, [PI_status_GOOD_02_3] },	\
		{ 0x8C, [PI_status_GOOD_03_0] },	\
		{ 0x8D, [PI_status_GOOD_03_1] },	\
		{ 0x8E, [PI_status_GOOD_03_2] },	\
		{ 0x8F, [PI_status_GOOD_03_3] },	\
		{ 0x90, [PI_status_GOOD_04_0] },	\
		{ 0x91, [PI_status_GOOD_04_1] },	\
		{ 0x92, [PI_status_GOOD_04_2] },	\
		{ 0x93, [PI_status_GOOD_04_3] },	\
		{ 0x94, [PI_status_GOOD_05_0] },	\
		{ 0x95, [PI_status_GOOD_05_1] },	\
		{ 0x96, [PI_status_GOOD_05_2] },	\
		{ 0x97, [PI_status_GOOD_05_3] },	\
		{ 0x98, [PI_status_GOOD_06_0] },	\
		{ 0x99, [PI_status_GOOD_06_1] },	\
		{ 0x9A, [PI_status_GOOD_06_2] },	\
		{ 0x9B, [PI_status_GOOD_06_3] },	\
		{ 0xA0, [PI_status_GOOD_08_0] },	\
		{ 0xA1, [PI_status_GOOD_08_1] },	\
		{ 0xA2, [PI_status_GOOD_08_2] },	\
		{ 0xA3, [PI_status_GOOD_08_3] },	\
		{ 0xA4, [PI_status_GOOD_09_0] },	\
		{ 0xA5, [PI_status_GOOD_09_1] },	\
		{ 0xA6, [PI_status_GOOD_09_2] },	\
		{ 0xA7, [PI_status_GOOD_09_3] },	\
		{ 0x40, [PI_status_UNCERTAIN_00_0] },	\
		{ 0x41, [PI_status_UNCERTAIN_00_1] },	\
		{ 0x42, [PI_status_UNCERTAIN_00_2] },	\
		{ 0x43, [PI_status_UNCERTAIN_00_3] },	\
		{ 0x44, [PI_status_UNCERTAIN_01_0] },	\
		{ 0x45, [PI_status_UNCERTAIN_01_1] },	\
		{ 0x46, [PI_status_UNCERTAIN_01_2] },	\
		{ 0x47, [PI_status_UNCERTAIN_01_3] },	\
		{ 0x48, [PI_status_UNCERTAIN_02_0] },	\
		{ 0x49, [PI_status_UNCERTAIN_02_1] },	\
		{ 0x4A, [PI_status_UNCERTAIN_02_2] },	\
		{ 0x4B, [PI_status_UNCERTAIN_02_3] },	\
		{ 0x4C, [PI_status_UNCERTAIN_03_0] },	\
		{ 0x4D, [PI_status_UNCERTAIN_03_1] },	\
		{ 0x4E, [PI_status_UNCERTAIN_03_2] },	\
		{ 0x4F, [PI_status_UNCERTAIN_03_3] },	\
		{ 0x50, [PI_status_UNCERTAIN_04_0] },	\
		{ 0x51, [PI_status_UNCERTAIN_04_1] },	\
		{ 0x52, [PI_status_UNCERTAIN_04_2] },	\
		{ 0x53, [PI_status_UNCERTAIN_04_3] },	\
		{ 0x54, [PI_status_UNCERTAIN_05_0] },	\
		{ 0x55, [PI_status_UNCERTAIN_05_1] },	\
		{ 0x56, [PI_status_UNCERTAIN_05_2] },	\
		{ 0x57, [PI_status_UNCERTAIN_05_3] },	\
		{ 0x58, [PI_status_UNCERTAIN_06_0] },	\
		{ 0x59, [PI_status_UNCERTAIN_06_1] },	\
		{ 0x5A, [PI_status_UNCERTAIN_06_2] },	\
		{ 0x5B, [PI_status_UNCERTAIN_06_3] },	\
		{ 0x5C, [PI_status_UNCERTAIN_07_0] },	\
		{ 0x5D, [PI_status_UNCERTAIN_07_1] },	\
		{ 0x5E, [PI_status_UNCERTAIN_07_2] },	\
		{ 0x5F, [PI_status_UNCERTAIN_07_3] },	\
		{ 0x60, [PI_status_UNCERTAIN_08_0] },	\
		{ 0x61, [PI_status_UNCERTAIN_08_1] },	\
		{ 0x62, [PI_status_UNCERTAIN_08_2] },	\
		{ 0x63, [PI_status_UNCERTAIN_08_3] },	\
		{ 0x64, [PI_status_UNCERTAIN_09_0] },	\
		{ 0x65, [PI_status_UNCERTAIN_09_1] },	\
		{ 0x66, [PI_status_UNCERTAIN_09_2] },	\
		{ 0x67, [PI_status_UNCERTAIN_09_3] },	\
		{ 0x00, [PI_status_BAD_00_0] },	\
		{ 0x01, [PI_status_BAD_00_1] },	\
		{ 0x02, [PI_status_BAD_00_2] },	\
		{ 0x03, [PI_status_BAD_00_3] },	\
		{ 0x04, [PI_status_BAD_01_0] },	\
		{ 0x05, [PI_status_BAD_01_1] },	\
		{ 0x06, [PI_status_BAD_01_2] },	\
		{ 0x07, [PI_status_BAD_01_3] },	\
		{ 0x08, [PI_status_BAD_02_0] },	\
		{ 0x09, [PI_status_BAD_02_1] },	\
		{ 0x0A, [PI_status_BAD_02_2] },	\
		{ 0x0B, [PI_status_BAD_02_3] },	\
		{ 0x0C, [PI_status_BAD_03_0] },	\
		{ 0x0D, [PI_status_BAD_03_1] },	\
		{ 0x0E, [PI_status_BAD_03_2] },	\
		{ 0x0F, [PI_status_BAD_03_3] },	\
		{ 0x10, [PI_status_BAD_04_0] },	\
		{ 0x11, [PI_status_BAD_04_1] },	\
		{ 0x12, [PI_status_BAD_04_2] },	\
		{ 0x13, [PI_status_BAD_04_3] },	\
		{ 0x14, [PI_status_BAD_05_0] },	\
		{ 0x15, [PI_status_BAD_05_1] },	\
		{ 0x16, [PI_status_BAD_05_2] },	\
		{ 0x17, [PI_status_BAD_05_3] },	\
		{ 0x18, [PI_status_BAD_06_0] },	\
		{ 0x19, [PI_status_BAD_06_1] },	\
		{ 0x1A, [PI_status_BAD_06_2] },	\
		{ 0x1B, [PI_status_BAD_06_3] },	\
		{ 0x1C, [PI_status_BAD_07_0] },	\
		{ 0x1D, [PI_status_BAD_07_1] },	\
		{ 0x1E, [PI_status_BAD_07_2] },	\
		{ 0x1F, [PI_status_BAD_07_3] }

/**
 * Standard Status enumeration list of all GOOD(C).
 * This is a internal enumeration list for all standard status 
 * elements of the Quality GOOD(C).
 */
#define PI_STATUS_LIST_STANDARD_CAS \
		{ 0xC0, [PI_status_GOOD_RCAS_00_0] },	\
		{ 0xC1, [PI_status_GOOD_RCAS_00_1] },	\
		{ 0xC2, [PI_status_GOOD_RCAS_00_2] },	\
		{ 0xC3, [PI_status_GOOD_RCAS_00_3] },	\
		{ 0xC4, [PI_status_GOOD_RCAS_01_0] },	\
		{ 0xC5, [PI_status_GOOD_RCAS_01_1] },	\
		{ 0xC6, [PI_status_GOOD_RCAS_01_2] },	\
		{ 0xC7, [PI_status_GOOD_RCAS_01_3] },	\
		{ 0xC8, [PI_status_GOOD_RCAS_02_0] },	\
		{ 0xC9, [PI_status_GOOD_RCAS_02_1] },	\
		{ 0xCA, [PI_status_GOOD_RCAS_02_2] },	\
		{ 0xCB, [PI_status_GOOD_RCAS_02_3] },	\
		{ 0xCC, [PI_status_GOOD_RCAS_03_0] },	\
		{ 0xCD, [PI_status_GOOD_RCAS_03_1] },	\
		{ 0xCE, [PI_status_GOOD_RCAS_03_2] },	\
		{ 0xCF, [PI_status_GOOD_RCAS_03_3] },	\
		{ 0xD4, [PI_status_GOOD_RCAS_05_0] },	\
		{ 0xD5, [PI_status_GOOD_RCAS_05_1] },	\
		{ 0xD6, [PI_status_GOOD_RCAS_05_2] },	\
		{ 0xD7, [PI_status_GOOD_RCAS_05_3] },	\
		{ 0xD8, [PI_status_GOOD_RCAS_06_0] },	\
		{ 0xD9, [PI_status_GOOD_RCAS_06_1] },	\
		{ 0xDA, [PI_status_GOOD_RCAS_06_2] },	\
		{ 0xDB, [PI_status_GOOD_RCAS_06_3] },	\
		{ 0xE0, [PI_status_GOOD_RCAS_08_0] },	\
		{ 0xE1, [PI_status_GOOD_RCAS_08_1] },	\
		{ 0xE2, [PI_status_GOOD_RCAS_08_2] },	\
		{ 0xE3, [PI_status_GOOD_RCAS_08_3] }


#endif /* __STATUS_H */
