
/*
 * $Id$
 * 
 * Copyright (C) PI 2007-2012. All rights reserved.
 * 
 * Version: 2.0.5
 * 
 */

/**
 * \file 0000_4005_0302_0001.ddl
 * \brief Function Block Analog Input 'V3.02'.
 * This file contains all definitions for Function Block Analog Input Profile Version 3.02
 * 
 * \section func5_AI_import How to import
 * For use of all mandatory parameters for a Class A device use the macro USE_FUNC5_AI_MANDATORY_A.
 * For use of all mandatory parameters for a Class B device use the macro USE_FUNC5_AI_MANDATORY_B.
 * Use 'EVERYTHING' for importing of all available parameters
 * 
 * Example for Class B:
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC5_AI, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
 * {
 *   USE_FUNC5_AI_MANDATORY_B;
 * }
 * \endcode 
 * 
 * \section func5_AI_def_list This file contains the following definitions
 * \subsection func5_AI_def_list_variable List of Variables
 * - func5_AI_BLOCK_OBJECT_Reserved
 * - func5_AI_BLOCK_OBJECT_Block_Object
 * - func5_AI_BLOCK_OBJECT_Parent_Class
 * - func5_AI_BLOCK_OBJECT_Class
 * - func5_AI_BLOCK_OBJECT_Dev_Rev
 * - func5_AI_BLOCK_OBJECT_Dev_Rev_Comp
 * - func5_AI_BLOCK_OBJECT_DD_Revision
 * - func5_AI_BLOCK_OBJECT_Profile
 * - func5_AI_BLOCK_OBJECT_Profile_Revision
 * - func5_AI_BLOCK_OBJECT_Execution_Time
 * - func5_AI_BLOCK_OBJECT_Number_of_Parameters
 * - func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot
 * - func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index
 * - func5_AI_BLOCK_OBJECT_Number_of_Views
 * - func5_AI_ST_REV
 * - func5_AI_TAG_DESC
 * - func5_AI_STRATEGY
 * - func5_AI_ALERT_KEY
 * - func5_AI_TARGET_MODE
 * - func5_AI_MODE_BLK_Actual
 * - func5_AI_MODE_BLK_Permitted
 * - func5_AI_MODE_BLK_Normal
 * - func5_AI_ALARM_SUM_Current
 * - func5_AI_ALARM_SUM_Unacknowledged
 * - func5_AI_ALARM_SUM_Unreported
 * - func5_AI_ALARM_SUM_Disabled
 * - func5_AI_BATCH_Batch_ID
 * - func5_AI_BATCH_Rup
 * - func5_AI_BATCH_Operation
 * - func5_AI_BATCH_Phase
 * - func5_AI_OUT_Value
 * - func5_AI_OUT_Status_Condensed
 * - func5_AI_OUT_Status_Quality
 * - func5_AI_OUT_Status_Limit
 * - func5_AI_PV_SCALE_Upper_Value
 * - func5_AI_PV_SCALE_Lower_Value
 * - func5_AI_OUT_SCALE_Upper_Value
 * - func5_AI_OUT_SCALE_Lower_Value
 * - func5_AI_OUT_SCALE_Units_Index
 * - func5_AI_OUT_SCALE_Decimal_Point
 * - func5_AI_LIN_TYPE
 * - func5_AI_CHANNEL
 * - func5_AI_PV_FTIME
 * - func5_AI_FSAFE_TYPE
 * - func5_AI_FSAFE_VALUE
 * - func5_AI_ALARM_HYS
 * - func5_AI_HI_HI_LIM
 * - func5_AI_HI_LIM
 * - func5_AI_LO_LIM
 * - func5_AI_LO_LO_LIM
 * - func5_AI_HI_HI_ALM_Unacknowledged
 * - func5_AI_HI_HI_ALM_Alarm_State
 * - func5_AI_HI_HI_ALM_Time_Stamp
 * - func5_AI_HI_HI_ALM_Subcode
 * - func5_AI_HI_HI_ALM_Value
 * - func5_AI_HI_ALM_Unacknowledged
 * - func5_AI_HI_ALM_Alarm_State
 * - func5_AI_HI_ALM_Time_Stamp
 * - func5_AI_HI_ALM_Subcode
 * - func5_AI_HI_ALM_Value
 * - func5_AI_LO_ALM_Unacknowledged
 * - func5_AI_LO_ALM_Alarm_State
 * - func5_AI_LO_ALM_Time_Stamp
 * - func5_AI_LO_ALM_Subcode
 * - func5_AI_LO_ALM_Value
 * - func5_AI_LO_LO_ALM_Unacknowledged
 * - func5_AI_LO_LO_ALM_Alarm_State
 * - func5_AI_LO_LO_ALM_Time_Stamp
 * - func5_AI_LO_LO_ALM_Subcode
 * - func5_AI_LO_LO_ALM_Value
 * - func5_AI_SIMULATE_Status_Condensed
 * - func5_AI_SIMULATE_Value
 * - func5_AI_SIMULATE_Enabled
 * - func5_AI_SIMULATE_Status_Quality
 * - func5_AI_SIMULATE_Status_Limit
 * - func5_AI_OUT_UNIT_TEXT
 * .
 * \subsection func5_AI_def_list_command List of Commands
 * - func5_AI_BLOCK_OBJECT_read
 * - func5_AI_ST_REV_read
 * - func5_AI_TAG_DESC_read
 * - func5_AI_TAG_DESC_write
 * - func5_AI_STRATEGY_read
 * - func5_AI_STRATEGY_write
 * - func5_AI_ALERT_KEY_read
 * - func5_AI_ALERT_KEY_write
 * - func5_AI_TARGET_MODE_read
 * - func5_AI_TARGET_MODE_write
 * - func5_AI_MODE_BLK_read
 * - func5_AI_ALARM_SUM_read
 * - func5_AI_BATCH_read
 * - func5_AI_BATCH_write
 * - func5_AI_OUT_read
 * - func5_AI_OUT_write
 * - func5_AI_PV_SCALE_read
 * - func5_AI_PV_SCALE_write
 * - func5_AI_OUT_SCALE_read
 * - func5_AI_OUT_SCALE_write
 * - func5_AI_LIN_TYPE_read
 * - func5_AI_LIN_TYPE_write
 * - func5_AI_CHANNEL_read
 * - func5_AI_CHANNEL_write
 * - func5_AI_PV_FTIME_read
 * - func5_AI_PV_FTIME_write
 * - func5_AI_FSAFE_TYPE_read
 * - func5_AI_FSAFE_TYPE_write
 * - func5_AI_FSAFE_VALUE_read
 * - func5_AI_FSAFE_VALUE_write
 * - func5_AI_ALARM_HYS_read
 * - func5_AI_ALARM_HYS_write
 * - func5_AI_HI_HI_LIM_read
 * - func5_AI_HI_HI_LIM_write
 * - func5_AI_HI_LIM_read
 * - func5_AI_HI_LIM_write
 * - func5_AI_LO_LIM_read
 * - func5_AI_LO_LIM_write
 * - func5_AI_LO_LO_LIM_read
 * - func5_AI_LO_LO_LIM_write
 * - func5_AI_HI_HI_ALM_read
 * - func5_AI_HI_ALM_read
 * - func5_AI_LO_ALM_read
 * - func5_AI_LO_LO_ALM_read
 * - func5_AI_SIMULATE_read
 * - func5_AI_SIMULATE_write
 * - func5_AI_OUT_UNIT_TEXT_read
 * - func5_AI_OUT_UNIT_TEXT_write
 * .
 * \subsection func5_AI_def_list_menu List of Menus
 * - func5_AI_BLOCK_OBJECT_page
 * - func5_AI_ST_REV_page
 * - func5_AI_TAG_DESC_page
 * - func5_AI_STRATEGY_page
 * - func5_AI_ALERT_KEY_page
 * - func5_AI_TARGET_MODE_page
 * - func5_AI_MODE_BLK_page
 * - func5_AI_ALARM_SUM_page
 * - func5_AI_BATCH_page
 * - func5_AI_OUT_page
 * - func5_AI_PV_SCALE_page
 * - func5_AI_OUT_SCALE_page
 * - func5_AI_LIN_TYPE_page
 * - func5_AI_CHANNEL_page
 * - func5_AI_PV_FTIME_page
 * - func5_AI_FSAFE_TYPE_page
 * - func5_AI_FSAFE_VALUE_page
 * - func5_AI_ALARM_HYS_page
 * - func5_AI_HI_HI_LIM_page
 * - func5_AI_HI_LIM_page
 * - func5_AI_LO_LIM_page
 * - func5_AI_LO_LO_LIM_page
 * - func5_AI_HI_HI_ALM_page
 * - func5_AI_HI_ALM_page
 * - func5_AI_LO_ALM_page
 * - func5_AI_LO_LO_ALM_page
 * - func5_AI_SIMULATE_page
 * - func5_AI_OUT_UNIT_TEXT_page
 * - func5_AI_VIEW_1_page
 * - func5_AI_VIEW_2_page
 * - func5_AI_VIEW_3_page
 * - func5_AI_Simulation
 * - func5_AI_Simulation_input
 * - func5_AI_Simulation_input_group
 * - func5_AI_Simulation_output
 * - func5_AI_Simulation_output_group
 * - func5_AI_Display_mandatory_A
 * - func5_AI_Display_out_mandatory_A
 * - func5_AI_Display_mandatory_B
 * - func5_AI_Display_out_mandatory_B
 * - func5_AI_Display_in_mandatory_B
 * - func5_AI_Tab_s_mandatory_A
 * - func5_AI_Tab_s_pv_range_mandatory_A
 * - func5_AI_Tab_s_limits_mandatory_A
 * - func5_AI_Tab_m_mandatory_A
 * - func5_AI_Tab_m_pv_range_mandatory_A
 * - func5_AI_Tab_m_limits_mandatory_A
 * - func5_AI_Tab_s_mandatory_B
 * - func5_AI_Tab_s_pv_range_mandatory_B
 * - func5_AI_Tab_s_outscale_mandatory_B
 * - func5_AI_Tab_s_limits_mandatory_B
 * - func5_AI_Tab_s_interface_mandatory_B
 * - func5_AI_Tab_m_mandatory_B
 * - func5_AI_Tab_m_pv_range_mandatory_B
 * - func5_AI_Tab_m_outscale_mandatory_B
 * - func5_AI_Tab_m_limits_mandatory_B
 * .
 * \subsection func5_AI_def_list_method List of Methods
 * - None
 * .
 *
 *
 * \section func5_AI_Alarm_parameter Special notes for time stamp of alarm parameter
 * The time stamp component (e.g. func5_AI_HI_HI_ALM_Time_Stamp) of parameters HI_HI_ALM, HI_ALM,
 * LO_LO_ALM and LO_ALM are defined as OCTET[8] for communication. 
 * To display the value in a readable form it must be converted with a device specific method.
 *
 * \section func5_AI_upload_download Upload and Download
 * \subsection func5_AI_upload_download_upload Upload
 * To upload the VARIABLEs you can use the following macro definition:
 * \code
 * func5_AI_BLOCK_OBJECT_Reserved,                   // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Block_Object,               // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Parent_Class,               // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Class,                      // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Dev_Rev,                    // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Dev_Rev_Comp,               // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_DD_Revision,                // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Profile,                    // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Profile_Revision,           // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Execution_Time,             // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Number_of_Parameters,       // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot,     // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index,    // Mand A, Mand B
 * func5_AI_BLOCK_OBJECT_Number_of_Views,            // Mand A, Mand B
 * func5_AI_ST_REV,                                  // Mand A, Mand B
 * func5_AI_TAG_DESC,                                // Mand A, Mand B
 * func5_AI_STRATEGY,                                // Mand A, Mand B
 * func5_AI_ALERT_KEY,                               // Mand A, Mand B
 * func5_AI_TARGET_MODE,                             // Mand A, Mand B
 * func5_AI_MODE_BLK_Actual,                         // Mand A, Mand B
 * func5_AI_MODE_BLK_Permitted,                      // Mand A, Mand B
 * func5_AI_MODE_BLK_Normal,                         // Mand A, Mand B
 * func5_AI_ALARM_SUM_Current,                       // Mand A, Mand B
 * func5_AI_ALARM_SUM_Unacknowledged,                // Mand A, Mand B
 * func5_AI_ALARM_SUM_Unreported,                    // Mand A, Mand B
 * func5_AI_ALARM_SUM_Disabled,                      // Mand A, Mand B
 * func5_AI_BATCH_Batch_ID,                          // Mand A, Mand B
 * func5_AI_BATCH_Rup,                               // Mand A, Mand B
 * func5_AI_BATCH_Operation,                         // Mand A, Mand B
 * func5_AI_BATCH_Phase,                             // Mand A, Mand B
 * func5_AI_OUT_Value,                               // Mand A, Mand B
 * func5_AI_OUT_Status_Condensed,                    // Mand A, Mand B
 * func5_AI_PV_SCALE_Upper_Value,                    // Mand A, Mand B
 * func5_AI_PV_SCALE_Lower_Value,                    // Mand A, Mand B
 * func5_AI_OUT_SCALE_Upper_Value,                   // Mand B, Opt A
 * func5_AI_OUT_SCALE_Lower_Value,                   // Mand B, Opt A
 * func5_AI_OUT_SCALE_Units_Index,                   // Mand B, Opt A
 * func5_AI_OUT_SCALE_Decimal_Point,                 // Mand B, Opt A
 * func5_AI_LIN_TYPE,                                // Mand B, Opt A
 * func5_AI_CHANNEL,                                 // Mand B, Opt A
 * func5_AI_PV_FTIME,                                // Mand A, Mand B
 * func5_AI_FSAFE_TYPE,                              // Opt A, Opt B
 * func5_AI_FSAFE_VALUE,                             // Opt A, Opt B
 * func5_AI_ALARM_HYS,                               // Mand A, Mand B
 * func5_AI_HI_HI_LIM,                               // Mand A, Mand B
 * func5_AI_HI_LIM,                                  // Mand A, Mand B
 * func5_AI_LO_LIM,                                  // Mand A, Mand B
 * func5_AI_LO_LO_LIM,                               // Mand A, Mand B
 * func5_AI_HI_HI_ALM_Unacknowledged,                // Opt A, Opt B
 * func5_AI_HI_HI_ALM_Alarm_State,                   // Opt A, Opt B
 * func5_AI_HI_HI_ALM_Time_Stamp,                    // Opt A, Opt B
 * func5_AI_HI_HI_ALM_Subcode,                       // Opt A, Opt B
 * func5_AI_HI_HI_ALM_Value,                         // Opt A, Opt B
 * func5_AI_HI_ALM_Unacknowledged,                   // Opt A, Opt B
 * func5_AI_HI_ALM_Alarm_State,                      // Opt A, Opt B
 * func5_AI_HI_ALM_Time_Stamp,                       // Opt A, Opt B
 * func5_AI_HI_ALM_Subcode,                          // Opt A, Opt B
 * func5_AI_HI_ALM_Value,                            // Opt A, Opt B
 * func5_AI_LO_ALM_Unacknowledged,                   // Opt A, Opt B
 * func5_AI_LO_ALM_Alarm_State,                      // Opt A, Opt B
 * func5_AI_LO_ALM_Time_Stamp,                       // Opt A, Opt B
 * func5_AI_LO_ALM_Subcode,                          // Opt A, Opt B
 * func5_AI_LO_ALM_Value,                            // Opt A, Opt B
 * func5_AI_LO_LO_ALM_Unacknowledged,                // Opt A, Opt B
 * func5_AI_LO_LO_ALM_Alarm_State,                   // Opt A, Opt B
 * func5_AI_LO_LO_ALM_Time_Stamp,                    // Opt A, Opt B
 * func5_AI_LO_LO_ALM_Subcode,                       // Opt A, Opt B
 * func5_AI_LO_LO_ALM_Value,                         // Opt A, Opt B
 * func5_AI_SIMULATE_Status_Condensed,               // Mand B, Opt A
 * func5_AI_SIMULATE_Value,                          // Mand B, Opt A
 * func5_AI_SIMULATE_Enabled,                        // Mand B, Opt A
 * func5_AI_OUT_UNIT_TEXT                            // Opt A, Opt B
 * \endcode
 * \subsection func5_AI_upload_download_download Download
 * To download the VARIABLEs you can use the following macro definition:
 * \code
 * func5_AI_PV_SCALE_Upper_Value,         // Mand A, Mand B
 * func5_AI_PV_SCALE_Lower_Value,         // Mand A, Mand B
 * func5_AI_LIN_TYPE,                     // Mand B, Opt A
 * func5_AI_OUT_SCALE_Upper_Value,        // Mand B, Opt A
 * func5_AI_OUT_SCALE_Lower_Value,        // Mand B, Opt A
 * func5_AI_OUT_SCALE_Units_Index,        // Mand B, Opt A
 * func5_AI_OUT_SCALE_Decimal_Point,      // Mand B, Opt A
 * func5_AI_HI_HI_LIM,                    // Mand A, Mand B
 * func5_AI_HI_LIM,                       // Mand A, Mand B
 * func5_AI_LO_LIM,                       // Mand A, Mand B
 * func5_AI_LO_LO_LIM,                    // Mand A, Mand B
 * func5_AI_TAG_DESC,                     // Mand A, Mand B
 * func5_AI_STRATEGY,                     // Mand A, Mand B
 * func5_AI_ALERT_KEY,                    // Mand A, Mand B
 * func5_AI_TARGET_MODE,                  // Mand A, Mand B
 * func5_AI_BATCH_Batch_ID,               // Mand A, Mand B
 * func5_AI_BATCH_Rup,                    // Mand A, Mand B
 * func5_AI_BATCH_Operation,              // Mand A, Mand B
 * func5_AI_BATCH_Phase,                  // Mand A, Mand B
 * func5_AI_OUT_Value,                    // Mand A, Mand B
 * func5_AI_OUT_Status_Condensed,         // Mand A, Mand B
 * func5_AI_CHANNEL,                      // Mand B, Opt A
 * func5_AI_PV_FTIME,                     // Mand A, Mand B
 * func5_AI_FSAFE_TYPE,                   // Opt A, Opt B
 * func5_AI_FSAFE_VALUE,                  // Opt A, Opt B
 * func5_AI_ALARM_HYS,                    // Mand A, Mand B
 * func5_AI_SIMULATE_Status_Condensed,    // Mand B, Opt A
 * func5_AI_SIMULATE_Value,               // Mand B, Opt A
 * func5_AI_SIMULATE_Enabled,             // Mand B, Opt A
 * func5_AI_OUT_UNIT_TEXT                 // Opt A, Opt B
 * \endcode
 *
 * \section func5_AI_necessary_changes Necessary changes on variables
 * \subsection func5_AI_Channel_changes func5_AI_CHANNEL
 * To use this parameter in your EDD you must redefine the specific enumeration of this block parameter.
 * \n For example:
 * \code
 * TYPE ENUMERATED(2)
 * {
 *    { 0x0108, "primary temperature value - TB 1" },
 *    { 0x010A, "secondary value -TB 1" },
 *    { 0x0208, "primary temperature value - TB 2" },
 *    { 0x020A, "secondary value -TB 2" }
 * }
 * \endcode
 * 
 * 
 */

#include "pa_import_0302.h"
#include "pa_units_0302.h"
#include "pa_status.h"

/** \cond SKIP_THIS */
MANUFACTURER 0x0000, DEVICE_TYPE 0x4005, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
/** \endcond */

BLOCK func5_AI_block
{
	TYPE FUNCTION;
	NUMBER 5;
}

COLLECTION func5_AI_BLOCK_OBJECT
{
	MEMBERS
	{
		Reserved, func5_AI_BLOCK_OBJECT_Reserved;
		Block_Object, func5_AI_BLOCK_OBJECT_Block_Object;
		Parent_Class, func5_AI_BLOCK_OBJECT_Parent_Class;
		Class, func5_AI_BLOCK_OBJECT_Class;
		Dev_Rev, func5_AI_BLOCK_OBJECT_Dev_Rev;
		Dev_Rev_Comp, func5_AI_BLOCK_OBJECT_Dev_Rev_Comp;
		DD_Revision, func5_AI_BLOCK_OBJECT_DD_Revision;
		Profile, func5_AI_BLOCK_OBJECT_Profile;
		Profile_Revision, func5_AI_BLOCK_OBJECT_Profile_Revision;
		Execution_Time, func5_AI_BLOCK_OBJECT_Execution_Time;
		Number_of_Parameters, func5_AI_BLOCK_OBJECT_Number_of_Parameters;
		Address_of_VIEW_1_Slot, func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot;
		Address_of_VIEW_1_Index, func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index;
		Number_of_Views, func5_AI_BLOCK_OBJECT_Number_of_Views;
	}
}

VARIABLE func5_AI_BLOCK_OBJECT_Reserved
{
	LABEL [PI_BLOCK_OBJECT_Reserved_label];
	HELP [PI_BLOCK_OBJECT_Reserved_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func5_AI_BLOCK_OBJECT_Block_Object
{
	LABEL [PI_BLOCK_OBJECT_Block_Object_label];
	HELP [PI_BLOCK_OBJECT_Block_Object_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 2;
		{ 1, [PI_BLOCK_OBJECT_Block_Object_enum_1] },
		{ 2, [PI_BLOCK_OBJECT_Block_Object_enum_2] },
		{ 3, [PI_BLOCK_OBJECT_Block_Object_enum_3] }
	}
}

VARIABLE func5_AI_BLOCK_OBJECT_Parent_Class
{
	LABEL [PI_BLOCK_OBJECT_Parent_Class_label];
	HELP [PI_BLOCK_OBJECT_Parent_Class_help_1];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 1;
		{ 1, [PI_BLOCK_OBJECT_Parent_Class_enum_1_1] },
		{ 2, [PI_BLOCK_OBJECT_Parent_Class_enum_2_1] },
		{ 3, [PI_BLOCK_OBJECT_Parent_Class_enum_3_1] },
		{ 4, [PI_BLOCK_OBJECT_Parent_Class_enum_4_1] },
		{ 5, [PI_BLOCK_OBJECT_Parent_Class_enum_5_1] },
		{ 6, [PI_BLOCK_OBJECT_Parent_Class_enum_8] },
		{ 7, [PI_BLOCK_OBJECT_Parent_Class_enum_7_1] }
	}
}

VARIABLE func5_AI_BLOCK_OBJECT_Class
{
	LABEL [PI_BLOCK_OBJECT_Class_label];
	HELP [PI_BLOCK_OBJECT_Class_help_1];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 1;
		{ 1, [PI_func_AI_BLOCK_OBJECT_Class_enum_1] }
	}
}

VARIABLE func5_AI_BLOCK_OBJECT_Dev_Rev
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_BLOCK_OBJECT_Dev_Rev_Comp
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_Comp_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_Comp_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_BLOCK_OBJECT_DD_Revision
{
	LABEL [PI_BLOCK_OBJECT_DD_Revision_label];
	HELP [PI_BLOCK_OBJECT_DD_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_BLOCK_OBJECT_Profile
{
	LABEL [PI_BLOCK_OBJECT_Profile_label];
	HELP [PI_BLOCK_OBJECT_Profile_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		{ 0x4001, [PI_BLOCK_OBJECT_Profile_enum_0x4001] },
		{ 0x4002, [PI_BLOCK_OBJECT_Profile_enum_0x4002] },
		{ 0x4081, [PI_BLOCK_OBJECT_Profile_enum_0x4081] },
		{ 0x4082, [PI_BLOCK_OBJECT_Profile_enum_0x4082] }
	}
}

VARIABLE func5_AI_BLOCK_OBJECT_Profile_Revision
{
	LABEL [PI_BLOCK_OBJECT_Profile_Revision_label];
	HELP [PI_BLOCK_OBJECT_Profile_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 0x302;
		{ 0x0200, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0200] },
		{ 0x0300, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0300] },
		{ 0x0301, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0301] },
		{ 0x0302, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0302] }
	}
}

VARIABLE func5_AI_BLOCK_OBJECT_Execution_Time
{
	LABEL [PI_BLOCK_OBJECT_Execution_Time_label];
	HELP [PI_BLOCK_OBJECT_Execution_Time_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func5_AI_BLOCK_OBJECT_Number_of_Parameters
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Parameters_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Parameters_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_label];
	HELP [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Index_label];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func5_AI_BLOCK_OBJECT_Number_of_Views
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Views_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Views_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func5_AI_ST_REV
{
	LABEL [PI_ST_REV_label];
	HELP [PI_ST_REV_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_TAG_DESC
{
	LABEL [PI_TAG_DESC_label];
	HELP [PI_TAG_DESC_help];
	CLASS CONTAINED;
	TYPE ASCII(32)
	{
		DEFAULT_VALUE " ";
	}
}

VARIABLE func5_AI_STRATEGY
{
	LABEL [PI_STRATEGY_label];
	HELP [PI_STRATEGY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_ALERT_KEY
{
	LABEL [PI_ALERT_KEY_label];
	HELP [PI_ALERT_KEY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_TARGET_MODE
{
	LABEL [PI_TARGET_MODE_label];
	HELP [PI_TARGET_MODE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION func5_AI_MODE_BLK
{
	MEMBERS
	{
		Actual, func5_AI_MODE_BLK_Actual;
		Permitted, func5_AI_MODE_BLK_Permitted;
		Normal, func5_AI_MODE_BLK_Normal;
	}
}

VARIABLE func5_AI_MODE_BLK_Actual
{
	LABEL [PI_MODE_BLK_Actual_label];
	HELP [PI_MODE_BLK_Actual_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE func5_AI_MODE_BLK_Permitted
{
	LABEL [PI_MODE_BLK_Permitted_label];
	HELP [PI_MODE_BLK_Permitted_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(1)
	{
		DEFAULT_VALUE 0x98;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE func5_AI_MODE_BLK_Normal
{
	LABEL [PI_MODE_BLK_Normal_label];
	HELP [PI_MODE_BLK_Normal_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION func5_AI_ALARM_SUM
{
	MEMBERS
	{
		Current, func5_AI_ALARM_SUM_Current;
		Unacknowledged, func5_AI_ALARM_SUM_Unacknowledged;
		Unreported, func5_AI_ALARM_SUM_Unreported;
		Disabled, func5_AI_ALARM_SUM_Disabled;
	}
}

VARIABLE func5_AI_ALARM_SUM_Current
{
	LABEL [PI_ALARM_SUM_Current_label];
	HELP [PI_ALARM_SUM_Current_help];	
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func5_AI_ALARM_SUM_Unacknowledged
{
	LABEL [PI_ALARM_SUM_Unacknowledged_label];
	HELP [PI_ALARM_SUM_Unacknowledged_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func5_AI_ALARM_SUM_Unreported
{
	LABEL [PI_ALARM_SUM_Unreported_label];
	HELP [PI_ALARM_SUM_Unreported_help];	
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func5_AI_ALARM_SUM_Disabled
{
	LABEL [PI_ALARM_SUM_Disabled_label];
	HELP [PI_ALARM_SUM_Disabled_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

COLLECTION func5_AI_BATCH
{
	MEMBERS
	{
		Batch_ID, func5_AI_BATCH_Batch_ID;
		Rup, func5_AI_BATCH_Rup;
		Operation, func5_AI_BATCH_Operation;
		Phase, func5_AI_BATCH_Phase;
	}
}

VARIABLE func5_AI_BATCH_Batch_ID
{
	LABEL [PI_BATCH_Batch_ID_label];
	HELP [PI_BATCH_Batch_ID_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(4)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_BATCH_Rup
{
	LABEL [PI_BATCH_Rup_label];
	HELP [PI_BATCH_Rup_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_BATCH_Operation
{
	LABEL [PI_BATCH_Operation_label];
	HELP [PI_BATCH_Operation_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_BATCH_Phase
{
	LABEL [PI_BATCH_Phase_label];
	HELP [PI_BATCH_Phase_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

COLLECTION func5_AI_OUT
{
	MEMBERS
	{
		Value, func5_AI_OUT_Value;
		Status_Condensed, func5_AI_OUT_Status_Condensed;
	}
}

VARIABLE func5_AI_OUT_Value
{
	LABEL [PI_OUT_Value_label];
	HELP [PI_OUT_Value_help];
	CLASS OUTPUT & DYNAMIC;
	HANDLING IF (func5_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE FLOAT;
}

VARIABLE func5_AI_OUT_Status_Condensed
{
	LABEL [PI_OUT_Status_Condensed_label];
	CLASS OUTPUT & DYNAMIC;
	HANDLING IF (func5_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func5_AI_OUT_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_PRIMARY_VALUE_Status_Quality_help];
	CLASS LOCAL;
	HANDLING IF (func5_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func5_AI_OUT_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_PRIMARY_VALUE_Status_Quality_help];
	CLASS LOCAL;
	HANDLING IF (func5_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

COLLECTION func5_AI_PV_SCALE
{
	MEMBERS
	{
		Upper_Value, func5_AI_PV_SCALE_Upper_Value;
		Lower_Value, func5_AI_PV_SCALE_Lower_Value;
	}
}

VARIABLE func5_AI_PV_SCALE_Upper_Value
{
	LABEL [PI_PV_SCALE_Upper_Value_label];
	HELP [PI_PV_SCALE_Upper_Value_help];
	CLASS CONTAINED;
	CONSTANT_UNIT [PI_unit_1342];
	TYPE FLOAT
	{
		DEFAULT_VALUE 100;
	}
}

VARIABLE func5_AI_PV_SCALE_Lower_Value
{
	LABEL [PI_PV_SCALE_Lower_Value_label];
	HELP [PI_PV_SCALE_Lower_Value_help];
	CLASS CONTAINED;
	CONSTANT_UNIT [PI_unit_1342];
	TYPE FLOAT
	{
		DEFAULT_VALUE 0;
	}
}

COLLECTION func5_AI_OUT_SCALE
{
	MEMBERS
	{
		Upper_Value, func5_AI_OUT_SCALE_Upper_Value;
		Lower_Value, func5_AI_OUT_SCALE_Lower_Value;
		Units_Index, func5_AI_OUT_SCALE_Units_Index;
		Decimal_Point, func5_AI_OUT_SCALE_Decimal_Point;
	}
}

VARIABLE func5_AI_OUT_SCALE_Upper_Value
{
	LABEL [PI_OUT_SCALE_Upper_Value_label];
	HELP [PI_OUT_SCALE_Upper_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 100;
	}
}

VARIABLE func5_AI_OUT_SCALE_Lower_Value
{
	LABEL [PI_OUT_SCALE_Lower_Value_label];
	HELP [PI_OUT_SCALE_Lower_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_OUT_SCALE_Units_Index
{
	LABEL [PI_PRIMARY_VALUE_UNIT_label];
	HELP [PI_PRIMARY_VALUE_UNIT_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 1342;
		PI_UNIT_LIST
	}
}

VARIABLE func5_AI_OUT_SCALE_Decimal_Point
{
	LABEL [PI_OUT_SCALE_Decimal_Point_label];
	HELP [PI_OUT_SCALE_Decimal_Point_help];
	CLASS CONTAINED;
	TYPE INTEGER(1)
	{
		DEFAULT_VALUE 2;
		MIN_VALUE 0;
		{ 0, [PI_OUT_SCALE_Decimal_Point_enum_0] },
		{ 1, [PI_OUT_SCALE_Decimal_Point_enum_1] },
		{ 2, [PI_OUT_SCALE_Decimal_Point_enum_2] },
		{ 3, [PI_OUT_SCALE_Decimal_Point_enum_3] },
		{ 4, [PI_OUT_SCALE_Decimal_Point_enum_4] },
		{ 5, [PI_OUT_SCALE_Decimal_Point_enum_5] },
		{ 6, [PI_OUT_SCALE_Decimal_Point_enum_6] },
		{ 7, [PI_OUT_SCALE_Decimal_Point_enum_7] }
	}
}

VARIABLE func5_AI_LIN_TYPE
{
	LABEL [PI_LIN_TYPE_label];
	HELP [PI_LIN_TYPE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_LIN_TYPE_enum_0], [PI_LIN_TYPE_enum_0] },
		{ 1, [PI_LIN_TYPE_enum_1] },
		{ 10, [PI_LIN_TYPE_enum_10], [PI_LIN_TYPE_enum_10_help] },
		{ 20, [PI_LIN_TYPE_enum_20] },
		{ 21, [PI_LIN_TYPE_enum_21] },
		{ 50, [PI_LIN_TYPE_enum_50] },
		{ 51, [PI_LIN_TYPE_enum_51] },
		{ 52, [PI_LIN_TYPE_enum_52] },
		{ 53, [PI_LIN_TYPE_enum_53] },
		{ 54, [PI_LIN_TYPE_enum_54] },
		{ 55, [PI_LIN_TYPE_enum_55] },
		{ 100, [PI_LIN_TYPE_enum_100] },
		{ 101, [PI_LIN_TYPE_enum_101] },
		{ 102, [PI_LIN_TYPE_enum_102] },
		{ 103, [PI_LIN_TYPE_enum_103] },
		{ 104, [PI_LIN_TYPE_enum_104] },
		{ 105, [PI_LIN_TYPE_enum_105] },
		{ 106, [PI_LIN_TYPE_enum_106] },
		{ 107, [PI_LIN_TYPE_enum_107] },
		{ 108, [PI_LIN_TYPE_enum_108] },
		{ 109, [PI_LIN_TYPE_enum_109] },
		{ 110, [PI_LIN_TYPE_enum_110] },
		{ 111, [PI_LIN_TYPE_enum_111] },
		{ 112, [PI_LIN_TYPE_enum_112] },
		{ 113, [PI_LIN_TYPE_enum_113] },
		{ 114, [PI_LIN_TYPE_enum_114] },
		{ 115, [PI_LIN_TYPE_enum_115] },
		{ 116, [PI_LIN_TYPE_enum_116] },
		{ 117, [PI_LIN_TYPE_enum_117] },
		{ 118, [PI_LIN_TYPE_enum_118] },
		{ 119, [PI_LIN_TYPE_enum_119] },
		{ 120, [PI_LIN_TYPE_enum_120] },
		{ 121, [PI_LIN_TYPE_enum_121] },
		{ 122, [PI_LIN_TYPE_enum_122] },
		{ 123, [PI_LIN_TYPE_enum_123] },
		{ 124, [PI_LIN_TYPE_enum_124] },
		{ 125, [PI_LIN_TYPE_enum_125] },
		{ 126, [PI_LIN_TYPE_enum_126] },
		{ 127, [PI_LIN_TYPE_enum_127] },
		{ 128, [PI_LIN_TYPE_enum_128] },
		{ 129, [PI_LIN_TYPE_enum_129] },
		{ 130, [PI_LIN_TYPE_enum_130] },
		{ 131, [PI_LIN_TYPE_enum_131] },
		{ 132, [PI_LIN_TYPE_enum_132] },
		{ 133, [PI_LIN_TYPE_enum_133] },
		{ 134, [PI_LIN_TYPE_enum_134] },
		{ 135, [PI_LIN_TYPE_enum_135] },
		{ 136, [PI_LIN_TYPE_enum_136] },
		{ 137, [PI_LIN_TYPE_enum_137] },
		{ 138, [PI_LIN_TYPE_enum_138] },
		{ 139, [PI_LIN_TYPE_enum_139] },
		{ 140, [PI_LIN_TYPE_enum_140] },
		{ 141, [PI_LIN_TYPE_enum_141] },
		{ 142, [PI_LIN_TYPE_enum_142] },
		{ 143, [PI_LIN_TYPE_enum_143] },
		{ 144, [PI_LIN_TYPE_enum_144] }
	}
}

VARIABLE func5_AI_CHANNEL
{
	LABEL [PI_CHANNEL_label];
	HELP [PI_CHANNEL_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_PV_FTIME
{
	LABEL [PI_func_AI_PV_FTIME_label];
	HELP [PI_func_AI_PV_FTIME_help];
	CLASS CONTAINED;
	CONSTANT_UNIT [PI_unit_1054];
	TYPE FLOAT
	{
		DEFAULT_VALUE 0.0;
		MIN_VALUE 0.0;
	}
}

VARIABLE func5_AI_FSAFE_TYPE
{
	LABEL [PI_FSAFE_TYPE_label];
	HELP [PI_FSAFE_TYPE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 1;
		{ 0, [PI_FSAFE_TYPE_enum_0] },
		{ 1, [PI_FSAFE_TYPE_enum_1] },
		{ 2, [PI_FSAFE_TYPE_enum_2] }
	}
}

VARIABLE func5_AI_FSAFE_VALUE
{
	LABEL [PI_FSAFE_VALUE_label];
	HELP [PI_FSAFE_VALUE_help];
	CLASS CONTAINED;
	TYPE FLOAT;
	VALIDITY IF (func5_AI_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
}

VARIABLE func5_AI_ALARM_HYS
{
	LABEL [PI_ALARM_HYS_label];
	HELP [PI_ALARM_HYS_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		MIN_VALUE 0.0;
	}
}

VARIABLE func5_AI_HI_HI_LIM
{
	LABEL [PI_HI_HI_LIM_label];
	HELP [PI_HI_HI_LIM_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE FLT_MAX;
	}
}

VARIABLE func5_AI_HI_LIM
{
	LABEL [PI_HI_LIM_label];
	HELP [PI_HI_LIM_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE FLT_MAX;
	}
}

VARIABLE func5_AI_LO_LIM
{
	LABEL [PI_LO_LIM_label];
	HELP [PI_LO_LIM_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE -FLT_MAX;
	}
}

VARIABLE func5_AI_LO_LO_LIM
{
	LABEL [PI_LO_LO_LIM_label];
	HELP [PI_LO_LO_LIM_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE -FLT_MAX;
	}
}

COLLECTION func5_AI_HI_HI_ALM
{
	MEMBERS
	{
		Unacknowledged, func5_AI_HI_HI_ALM_Unacknowledged;
		Alarm_State, func5_AI_HI_HI_ALM_Alarm_State;
		Time_Stamp, func5_AI_HI_HI_ALM_Time_Stamp;
		Subcode, func5_AI_HI_HI_ALM_Subcode;
		Value, func5_AI_HI_HI_ALM_Value;
	}
}

VARIABLE func5_AI_HI_HI_ALM_Unacknowledged
{
	LABEL [PI_HI_HI_ALM_Unacknowledged_label];
	HELP [PI_DEVICE_STATE_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_HI_HI_ALM_Alarm_State
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_HI_HI_ALM_Alarm_State_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 1, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func5_AI_HI_HI_ALM_Time_Stamp
{
	LABEL [PI_HI_HI_ALM_Time_Stamp_label];
	HELP [PI_HI_HI_ALM_Time_Stamp_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE OCTET(8);
}

VARIABLE func5_AI_HI_HI_ALM_Subcode
{
	LABEL [PI_HI_HI_ALM_Subcode_label];
	HELP [PI_HI_HI_ALM_Subcode_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_HI_HI_ALM_Value
{
	LABEL [PI_HI_HI_ALM_Value_label];
	HELP [PI_HI_HI_ALM_Value_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE FLOAT;
}

COLLECTION func5_AI_HI_ALM
{
	MEMBERS
	{
		Unacknowledged, func5_AI_HI_ALM_Unacknowledged;
		Alarm_State, func5_AI_HI_ALM_Alarm_State;
		Time_Stamp, func5_AI_HI_ALM_Time_Stamp;
		Subcode, func5_AI_HI_ALM_Subcode;
		Value, func5_AI_HI_ALM_Value;
	}
}

VARIABLE func5_AI_HI_ALM_Unacknowledged
{
	LABEL [PI_HI_ALM_Unacknowledged_label];
	HELP [PI_DEVICE_STATE_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_HI_ALM_Alarm_State
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_HI_ALM_Alarm_State_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_HI_ALM_Alarm_State_enum_0] },
		{ 1, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func5_AI_HI_ALM_Time_Stamp
{
	LABEL [PI_HI_HI_ALM_Time_Stamp_label];
	HELP [PI_HI_HI_ALM_Time_Stamp_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE OCTET(8);
}

VARIABLE func5_AI_HI_ALM_Subcode
{
	LABEL [PI_HI_ALM_Subcode_label];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_HI_ALM_Value
{
	LABEL [PI_HI_ALM_Value_label];
	HELP [PI_HI_ALM_Value_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE FLOAT;
}

COLLECTION func5_AI_LO_ALM
{
	MEMBERS
	{
		Unacknowledged, func5_AI_LO_ALM_Unacknowledged;
		Alarm_State, func5_AI_LO_ALM_Alarm_State;
		Time_Stamp, func5_AI_LO_ALM_Time_Stamp;
		Subcode, func5_AI_LO_ALM_Subcode;
		Value, func5_AI_LO_ALM_Value;
	}
}

VARIABLE func5_AI_LO_ALM_Unacknowledged
{
	LABEL [PI_HI_ALM_Unacknowledged_label];
	HELP [PI_DEVICE_STATE_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_LO_ALM_Alarm_State
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_LO_ALM_Alarm_State_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_HI_ALM_Alarm_State_enum_0] },
		{ 1, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func5_AI_LO_ALM_Time_Stamp
{
	LABEL [PI_HI_HI_ALM_Time_Stamp_label];
	HELP [PI_HI_HI_ALM_Time_Stamp_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE OCTET(8);
}

VARIABLE func5_AI_LO_ALM_Subcode
{
	LABEL [PI_HI_HI_ALM_Subcode_label];
	HELP [PI_LO_ALM_Subcode_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_LO_ALM_Value
{
	LABEL [PI_HI_ALM_Value_label];
	HELP [PI_LO_ALM_Value_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE FLOAT;
}

COLLECTION func5_AI_LO_LO_ALM
{
	MEMBERS
	{
		Unacknowledged, func5_AI_LO_LO_ALM_Unacknowledged;
		Alarm_State, func5_AI_LO_LO_ALM_Alarm_State;
		Time_Stamp, func5_AI_LO_LO_ALM_Time_Stamp;
		Subcode, func5_AI_LO_LO_ALM_Subcode;
		Value, func5_AI_LO_LO_ALM_Value;
	}
}

VARIABLE func5_AI_LO_LO_ALM_Unacknowledged
{
	LABEL [PI_HI_HI_ALM_Unacknowledged_label];
	HELP [PI_DEVICE_STATE_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func5_AI_LO_LO_ALM_Alarm_State
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_LO_LO_ALM_Alarm_State_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 1, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func5_AI_LO_LO_ALM_Time_Stamp
{
	LABEL [PI_HI_HI_ALM_Time_Stamp_label];
	HELP [PI_HI_HI_ALM_Time_Stamp_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE OCTET(8);
}

VARIABLE func5_AI_LO_LO_ALM_Subcode
{
	LABEL [PI_HI_HI_ALM_Subcode_label];
	HELP [PI_LO_LO_ALM_Subcode_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func5_AI_LO_LO_ALM_Value
{
	LABEL [PI_HI_HI_ALM_Value_label];
	HELP [PI_LO_LO_ALM_Value_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE FLOAT;
}

COLLECTION func5_AI_SIMULATE
{
	MEMBERS
	{
		Status_Condensed, func5_AI_SIMULATE_Status_Condensed;
		Value, func5_AI_SIMULATE_Value;
		Enabled, func5_AI_SIMULATE_Enabled;
	}
}

VARIABLE func5_AI_SIMULATE_Status_Condensed
{
	LABEL [PI_SIMULATE_Status_Condensed_label];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func5_AI_SIMULATE_Value
{
	LABEL [PI_SIMULATE_Value_label];
	HELP [PI_func_AI_SIMULATE_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0.0;
	}
}

VARIABLE func5_AI_SIMULATE_Enabled
{
	LABEL [PI_SIMULATE_Enabled_label];
	HELP [PI_SIMULATE_Enabled_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_disabled] },
		{ 1, [PI_enabled] }
	}
}

VARIABLE func5_AI_SIMULATE_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_SIMULATE_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func5_AI_SIMULATE_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_SIMULATE_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

VARIABLE func5_AI_OUT_UNIT_TEXT
{
	LABEL [PI_func_AI_OUT_UNIT_TEXT_label];
	HELP [PI_func_AI_OUT_UNIT_TEXT_help];
	CLASS CONTAINED;
	TYPE ASCII(16);
}

COLLECTION func5_AI_VIEW_1
{
	MEMBERS
	{
		ST_REV, func5_AI_ST_REV;
		MODE_BLK, func5_AI_MODE_BLK;
		ALARM_SUM, func5_AI_ALARM_SUM;
		OUT, func5_AI_OUT;
	}
}

COLLECTION func5_AI_VIEW_2
{
	MEMBERS
	{
		ST_REV, func5_AI_ST_REV;
		MODE_BLK, func5_AI_MODE_BLK;
		ALARM_SUM, func5_AI_ALARM_SUM;
		OUT, func5_AI_OUT;
		SIMULATE, func5_AI_SIMULATE;
	}
}

COLLECTION func5_AI_VIEW_3
{
	MEMBERS
	{
		TAG_DESC, func5_AI_TAG_DESC;
		STRATEGY, func5_AI_STRATEGY;
		ALERT_KEY, func5_AI_ALERT_KEY;
		TARGET_MODE, func5_AI_TARGET_MODE;
		BATCH, func5_AI_BATCH;
		PV_SCALE, func5_AI_PV_SCALE;
		OUT_SCALE, func5_AI_OUT_SCALE;
		LIN_TYPE, func5_AI_LIN_TYPE;
		CHANNEL, func5_AI_CHANNEL;
		PV_FTIME, func5_AI_PV_FTIME;
		FSAFE_TYPE, func5_AI_FSAFE_TYPE;
		FSAFE_VALUE, func5_AI_FSAFE_VALUE;
		ALARM_HYS, func5_AI_ALARM_HYS;
		HI_HI_LIM, func5_AI_HI_HI_LIM;
		HI_LIM, func5_AI_HI_LIM;
		LO_LIM, func5_AI_LO_LIM;
		LO_LO_LIM, func5_AI_LO_LO_LIM;
		OUT_UNIT_TEXT, func5_AI_OUT_UNIT_TEXT;
	}
}

/* simple GUI */

MENU func5_AI_Simple_Dialog_Mandatory_A
{
	LABEL [PI_func5_AI_Simple_Dialog_Mandatory_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func5_AI_BLOCK_OBJECT_page,
		func5_AI_ST_REV_page,
		func5_AI_TAG_DESC_page,
		func5_AI_STRATEGY_page,
		func5_AI_ALERT_KEY_page,
		func5_AI_TARGET_MODE_page,
		func5_AI_MODE_BLK_page,
		func5_AI_ALARM_SUM_page,
		func5_AI_BATCH_page,
		func5_AI_OUT_page,
		func5_AI_PV_SCALE_page,
		func5_AI_PV_FTIME_page,
		func5_AI_ALARM_HYS_page,
		func5_AI_HI_HI_LIM_page,
		func5_AI_HI_LIM_page,
		func5_AI_LO_LIM_page,
		func5_AI_LO_LO_LIM_page
	}
}

MENU func5_AI_Simple_Dialog_Optional_A
{
	LABEL [PI_func5_AI_Simple_Dialog_Optional_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func5_AI_BLOCK_OBJECT_page,
		func5_AI_ST_REV_page,
		func5_AI_TAG_DESC_page,
		func5_AI_STRATEGY_page,
		func5_AI_ALERT_KEY_page,
		func5_AI_TARGET_MODE_page,
		func5_AI_MODE_BLK_page,
		func5_AI_ALARM_SUM_page,
		func5_AI_BATCH_page,
		func5_AI_OUT_page,
		func5_AI_PV_SCALE_page,
		func5_AI_OUT_SCALE_page,
		func5_AI_LIN_TYPE_page,
		func5_AI_CHANNEL_page,
		func5_AI_PV_FTIME_page,
		func5_AI_FSAFE_TYPE_page,
		func5_AI_FSAFE_VALUE_page,
		func5_AI_ALARM_HYS_page,
		func5_AI_HI_HI_LIM_page,
		func5_AI_HI_LIM_page,
		func5_AI_LO_LIM_page,
		func5_AI_LO_LO_LIM_page,
		func5_AI_HI_HI_ALM_page,
		func5_AI_HI_ALM_page,
		func5_AI_LO_ALM_page,
		func5_AI_LO_LO_ALM_page,
		func5_AI_SIMULATE_page,
		func5_AI_OUT_UNIT_TEXT_page,
		func5_AI_VIEW_1_page,
		func5_AI_VIEW_2_page,
		func5_AI_VIEW_3_page
	}
}

MENU func5_AI_Simple_Dialog_Mandatory_B
{
	LABEL [PI_func5_AI_Simple_Dialog_Mandatory_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func5_AI_BLOCK_OBJECT_page,
		func5_AI_ST_REV_page,
		func5_AI_TAG_DESC_page,
		func5_AI_STRATEGY_page,
		func5_AI_ALERT_KEY_page,
		func5_AI_TARGET_MODE_page,
		func5_AI_MODE_BLK_page,
		func5_AI_ALARM_SUM_page,
		func5_AI_BATCH_page,
		func5_AI_OUT_page,
		func5_AI_PV_SCALE_page,
		func5_AI_OUT_SCALE_page,
		func5_AI_LIN_TYPE_page,
		func5_AI_CHANNEL_page,
		func5_AI_PV_FTIME_page,
		func5_AI_ALARM_HYS_page,
		func5_AI_HI_HI_LIM_page,
		func5_AI_HI_LIM_page,
		func5_AI_LO_LIM_page,
		func5_AI_LO_LO_LIM_page,
		func5_AI_SIMULATE_page,
		func5_AI_VIEW_1_page
	}
}

MENU func5_AI_Simple_Dialog_Optional_B
{
	LABEL [PI_func5_AI_Simple_Dialog_Optional_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func5_AI_BLOCK_OBJECT_page,
		func5_AI_ST_REV_page,
		func5_AI_TAG_DESC_page,
		func5_AI_STRATEGY_page,
		func5_AI_ALERT_KEY_page,
		func5_AI_TARGET_MODE_page,
		func5_AI_MODE_BLK_page,
		func5_AI_ALARM_SUM_page,
		func5_AI_BATCH_page,
		func5_AI_OUT_page,
		func5_AI_PV_SCALE_page,
		func5_AI_OUT_SCALE_page,
		func5_AI_LIN_TYPE_page,
		func5_AI_CHANNEL_page,
		func5_AI_PV_FTIME_page,
		func5_AI_FSAFE_TYPE_page,
		func5_AI_FSAFE_VALUE_page,
		func5_AI_ALARM_HYS_page,
		func5_AI_HI_HI_LIM_page,
		func5_AI_HI_LIM_page,
		func5_AI_LO_LIM_page,
		func5_AI_LO_LO_LIM_page,
		func5_AI_HI_HI_ALM_page,
		func5_AI_HI_ALM_page,
		func5_AI_LO_ALM_page,
		func5_AI_LO_LO_ALM_page,
		func5_AI_SIMULATE_page,
		func5_AI_OUT_UNIT_TEXT_page,
		func5_AI_VIEW_1_page,
		func5_AI_VIEW_2_page,
		func5_AI_VIEW_3_page
	}
}

MENU func5_AI_BLOCK_OBJECT_page
{
	LABEL [PI_BLOCK_OBJECT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_BLOCK_OBJECT
	}
}

MENU func5_AI_ST_REV_page
{
	LABEL [PI_ST_REV_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_ST_REV
	}
}

MENU func5_AI_TAG_DESC_page
{
	LABEL [PI_TAG_DESC_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_TAG_DESC
	}
}

MENU func5_AI_STRATEGY_page
{
	LABEL [PI_STRATEGY_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_STRATEGY
	}
}

MENU func5_AI_ALERT_KEY_page
{
	LABEL [PI_ALERT_KEY_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_ALERT_KEY
	}
}

MENU func5_AI_TARGET_MODE_page
{
	LABEL [PI_TARGET_MODE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_TARGET_MODE
	}
}

MENU func5_AI_MODE_BLK_page
{
	LABEL [PI_MODE_BLK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_MODE_BLK
	}
}

MENU func5_AI_ALARM_SUM_page
{
	LABEL [PI_ALARM_SUM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_ALARM_SUM
	}
}

MENU func5_AI_BATCH_page
{
	LABEL [PI_BATCH_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_BATCH
	}
}

MENU func5_AI_OUT_page
{
	LABEL [PI_OUT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_OUT
	}
}

MENU func5_AI_PV_SCALE_page
{
	LABEL [PI_PV_SCALE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_PV_SCALE
	}
}

MENU func5_AI_OUT_SCALE_page
{
	LABEL [PI_OUT_SCALE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_OUT_SCALE
	}
}

MENU func5_AI_LIN_TYPE_page
{
	LABEL [PI_LIN_TYPE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_LIN_TYPE
	}
}

MENU func5_AI_CHANNEL_page
{
	LABEL [PI_CHANNEL_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_CHANNEL
	}
}

MENU func5_AI_PV_FTIME_page
{
	LABEL [PI_PV_FTIME_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_PV_FTIME
	}
}

MENU func5_AI_FSAFE_TYPE_page
{
	LABEL [PI_FSAFE_TYPE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_FSAFE_TYPE
	}
}

MENU func5_AI_FSAFE_VALUE_page
{
	LABEL [PI_FSAFE_VALUE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_FSAFE_VALUE
	}
}

MENU func5_AI_ALARM_HYS_page
{
	LABEL [PI_ALARM_HYS_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_ALARM_HYS
	}
}

MENU func5_AI_HI_HI_LIM_page
{
	LABEL [PI_HI_HI_LIM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_HI_HI_LIM
	}
}

MENU func5_AI_HI_LIM_page
{
	LABEL [PI_HI_LIM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_HI_LIM
	}
}

MENU func5_AI_LO_LIM_page
{
	LABEL [PI_LO_LIM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_LO_LIM
	}
}

MENU func5_AI_LO_LO_LIM_page
{
	LABEL [PI_LO_LO_LIM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_LO_LO_LIM
	}
}

MENU func5_AI_HI_HI_ALM_page
{
	LABEL [PI_HI_HI_ALM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_HI_HI_ALM
	}
}

MENU func5_AI_HI_ALM_page
{
	LABEL [PI_HI_ALM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_HI_ALM
	}
}

MENU func5_AI_LO_ALM_page
{
	LABEL [PI_LO_ALM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_LO_ALM
	}
}

MENU func5_AI_LO_LO_ALM_page
{
	LABEL [PI_LO_LO_ALM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_LO_LO_ALM
	}
}

MENU func5_AI_SIMULATE_page
{
	LABEL [PI_SIMULATE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_SIMULATE
	}
}

MENU func5_AI_OUT_UNIT_TEXT_page
{
	LABEL [PI_OUT_UNIT_TEXT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_OUT_UNIT_TEXT
	}
}

MENU func5_AI_VIEW_1_page
{
	LABEL [PI_VIEW_1_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_VIEW_1
	}
}

MENU func5_AI_VIEW_2_page
{
	LABEL [PI_VIEW_2_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_VIEW_2
	}
}

MENU func5_AI_VIEW_3_page
{
	LABEL [PI_VIEW_3_page_label];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_VIEW_3
	}
}

/* COMMANDs */

COMMAND func5_AI_BLOCK_OBJECT_read
{
	BLOCK func5_AI_block;
	INDEX 0;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_BLOCK_OBJECT_Reserved,
			func5_AI_BLOCK_OBJECT_Block_Object,
			func5_AI_BLOCK_OBJECT_Parent_Class,
			func5_AI_BLOCK_OBJECT_Class,
			func5_AI_BLOCK_OBJECT_Dev_Rev,
			func5_AI_BLOCK_OBJECT_Dev_Rev_Comp,
			func5_AI_BLOCK_OBJECT_DD_Revision,
			func5_AI_BLOCK_OBJECT_Profile,
			func5_AI_BLOCK_OBJECT_Profile_Revision,
			func5_AI_BLOCK_OBJECT_Execution_Time,
			func5_AI_BLOCK_OBJECT_Number_of_Parameters,
			func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Slot,
			func5_AI_BLOCK_OBJECT_Address_of_VIEW_1_Index,
			func5_AI_BLOCK_OBJECT_Number_of_Views
		}
	}
}

COMMAND func5_AI_ST_REV_read
{
	BLOCK func5_AI_block;
	INDEX 1;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_ST_REV
		}
	}
}

COMMAND func5_AI_TAG_DESC_read
{
	BLOCK func5_AI_block;
	INDEX 2;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_TAG_DESC
		}
	}
}

COMMAND func5_AI_TAG_DESC_write
{
	BLOCK func5_AI_block;
	INDEX 2;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_TAG_DESC
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_STRATEGY_read
{
	BLOCK func5_AI_block;
	INDEX 3;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_STRATEGY
		}
	}
}

COMMAND func5_AI_STRATEGY_write
{
	BLOCK func5_AI_block;
	INDEX 3;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_STRATEGY
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_ALERT_KEY_read
{
	BLOCK func5_AI_block;
	INDEX 4;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_ALERT_KEY
		}
	}
}

COMMAND func5_AI_ALERT_KEY_write
{
	BLOCK func5_AI_block;
	INDEX 4;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_ALERT_KEY
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_TARGET_MODE_read
{
	BLOCK func5_AI_block;
	INDEX 5;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_TARGET_MODE
		}
	}
}

COMMAND func5_AI_TARGET_MODE_write
{
	BLOCK func5_AI_block;
	INDEX 5;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_TARGET_MODE
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_MODE_BLK_read
{
	BLOCK func5_AI_block;
	INDEX 6;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_MODE_BLK_Actual,
			func5_AI_MODE_BLK_Permitted,
			func5_AI_MODE_BLK_Normal
		}
	}
}

COMMAND func5_AI_ALARM_SUM_read
{
	BLOCK func5_AI_block;
	INDEX 7;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_ALARM_SUM_Current,
			func5_AI_ALARM_SUM_Unacknowledged,
			func5_AI_ALARM_SUM_Unreported,
			func5_AI_ALARM_SUM_Disabled
		}
	}
}

COMMAND func5_AI_BATCH_read
{
	BLOCK func5_AI_block;
	INDEX 8;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_BATCH_Batch_ID,
			func5_AI_BATCH_Rup,
			func5_AI_BATCH_Operation,
			func5_AI_BATCH_Phase
		}
	}
}

COMMAND func5_AI_BATCH_write
{
	BLOCK func5_AI_block;
	INDEX 8;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_BATCH_Batch_ID,
			func5_AI_BATCH_Rup,
			func5_AI_BATCH_Operation,
			func5_AI_BATCH_Phase
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_OUT_read
{
	BLOCK func5_AI_block;
	INDEX 10;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_OUT_Value,
			func5_AI_OUT_Status_Condensed
		}
	}
}

COMMAND func5_AI_OUT_write
{
	BLOCK func5_AI_block;
	INDEX 10;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_OUT_Value,
			func5_AI_OUT_Status_Condensed
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_PV_SCALE_read
{
	BLOCK func5_AI_block;
	INDEX 11;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_PV_SCALE_Upper_Value,
			func5_AI_PV_SCALE_Lower_Value
		}
	}
}

COMMAND func5_AI_PV_SCALE_write
{
	BLOCK func5_AI_block;
	INDEX 11;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_PV_SCALE_Upper_Value,
			func5_AI_PV_SCALE_Lower_Value
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_OUT_SCALE_read
{
	BLOCK func5_AI_block;
	INDEX 12;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_OUT_SCALE_Upper_Value,
			func5_AI_OUT_SCALE_Lower_Value,
			func5_AI_OUT_SCALE_Units_Index,
			func5_AI_OUT_SCALE_Decimal_Point
		}
	}
}

COMMAND func5_AI_OUT_SCALE_write
{
	BLOCK func5_AI_block;
	INDEX 12;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_OUT_SCALE_Upper_Value,
			func5_AI_OUT_SCALE_Lower_Value,
			func5_AI_OUT_SCALE_Units_Index,
			func5_AI_OUT_SCALE_Decimal_Point
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_LIN_TYPE_read
{
	BLOCK func5_AI_block;
	INDEX 13;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_LIN_TYPE
		}
	}
}

COMMAND func5_AI_LIN_TYPE_write
{
	BLOCK func5_AI_block;
	INDEX 13;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_LIN_TYPE
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_CHANNEL_read
{
	BLOCK func5_AI_block;
	INDEX 14;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_CHANNEL
		}
	}
}

COMMAND func5_AI_CHANNEL_write
{
	BLOCK func5_AI_block;
	INDEX 14;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_CHANNEL
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_PV_FTIME_read
{
	BLOCK func5_AI_block;
	INDEX 16;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_PV_FTIME
		}
	}
}

COMMAND func5_AI_PV_FTIME_write
{
	BLOCK func5_AI_block;
	INDEX 16;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_PV_FTIME
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_FSAFE_TYPE_read
{
	BLOCK func5_AI_block;
	INDEX 17;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_FSAFE_TYPE
		}
	}
}

COMMAND func5_AI_FSAFE_TYPE_write
{
	BLOCK func5_AI_block;
	INDEX 17;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_FSAFE_TYPE
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_FSAFE_VALUE_read
{
	BLOCK func5_AI_block;
	INDEX 18;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_FSAFE_VALUE
		}
	}
}

COMMAND func5_AI_FSAFE_VALUE_write
{
	BLOCK func5_AI_block;
	INDEX 18;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_FSAFE_VALUE
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_ALARM_HYS_read
{
	BLOCK func5_AI_block;
	INDEX 19;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_ALARM_HYS
		}
	}
}

COMMAND func5_AI_ALARM_HYS_write
{
	BLOCK func5_AI_block;
	INDEX 19;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_ALARM_HYS
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_HI_HI_LIM_read
{
	BLOCK func5_AI_block;
	INDEX 21;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_HI_HI_LIM
		}
	}
}

COMMAND func5_AI_HI_HI_LIM_write
{
	BLOCK func5_AI_block;
	INDEX 21;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_HI_HI_LIM
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_HI_LIM_read
{
	BLOCK func5_AI_block;
	INDEX 23;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_HI_LIM
		}
	}
}

COMMAND func5_AI_HI_LIM_write
{
	BLOCK func5_AI_block;
	INDEX 23;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_HI_LIM
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_LO_LIM_read
{
	BLOCK func5_AI_block;
	INDEX 25;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_LO_LIM
		}
	}
}

COMMAND func5_AI_LO_LIM_write
{
	BLOCK func5_AI_block;
	INDEX 25;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_LO_LIM
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_LO_LO_LIM_read
{
	BLOCK func5_AI_block;
	INDEX 27;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_LO_LO_LIM
		}
	}
}

COMMAND func5_AI_LO_LO_LIM_write
{
	BLOCK func5_AI_block;
	INDEX 27;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_LO_LO_LIM
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_HI_HI_ALM_read
{
	BLOCK func5_AI_block;
	INDEX 30;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_HI_HI_ALM_Unacknowledged,
			func5_AI_HI_HI_ALM_Alarm_State,
			func5_AI_HI_HI_ALM_Time_Stamp,
			func5_AI_HI_HI_ALM_Subcode,
			func5_AI_HI_HI_ALM_Value
		}
	}
}

COMMAND func5_AI_HI_ALM_read
{
	BLOCK func5_AI_block;
	INDEX 31;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_HI_ALM_Unacknowledged,
			func5_AI_HI_ALM_Alarm_State,
			func5_AI_HI_ALM_Time_Stamp,
			func5_AI_HI_ALM_Subcode,
			func5_AI_HI_ALM_Value
		}
	}
}

COMMAND func5_AI_LO_ALM_read
{
	BLOCK func5_AI_block;
	INDEX 32;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_LO_ALM_Unacknowledged,
			func5_AI_LO_ALM_Alarm_State,
			func5_AI_LO_ALM_Time_Stamp,
			func5_AI_LO_ALM_Subcode,
			func5_AI_LO_ALM_Value
		}
	}
}

COMMAND func5_AI_LO_LO_ALM_read
{
	BLOCK func5_AI_block;
	INDEX 33;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_LO_LO_ALM_Unacknowledged,
			func5_AI_LO_LO_ALM_Alarm_State,
			func5_AI_LO_LO_ALM_Time_Stamp,
			func5_AI_LO_LO_ALM_Subcode,
			func5_AI_LO_LO_ALM_Value
		}
	}
}

COMMAND func5_AI_SIMULATE_read
{
	BLOCK func5_AI_block;
	INDEX 34;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_SIMULATE_Status_Condensed,
			func5_AI_SIMULATE_Value,
			func5_AI_SIMULATE_Enabled
		}
	}
}

COMMAND func5_AI_SIMULATE_write
{
	BLOCK func5_AI_block;
	INDEX 34;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_SIMULATE_Status_Condensed,
			func5_AI_SIMULATE_Value,
			func5_AI_SIMULATE_Enabled
		}
		REPLY
		{
		}
	}
}

COMMAND func5_AI_OUT_UNIT_TEXT_read
{
	BLOCK func5_AI_block;
	INDEX 35;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func5_AI_OUT_UNIT_TEXT
		}
	}
}

COMMAND func5_AI_OUT_UNIT_TEXT_write
{
	BLOCK func5_AI_block;
	INDEX 35;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func5_AI_OUT_UNIT_TEXT
		}
		REPLY
		{
		}
	}
}

/* BEGIN post EDD */


// Aopt:
// - UNIT func5_AI_OUT_SCALE_unit_1
// - UNIT func5_AI_OUT_SCALE_unit_2

// Bman:
// - UNIT func5_AI_OUT_SCALE_unit_1

// Bopt:
// - UNIT func5_AI_OUT_SCALE_unit_2

UNIT func5_AI_OUT_SCALE_unit_1
{
	func5_AI_OUT_SCALE_Units_Index:

	func5_AI_OUT_Value,
	func5_AI_OUT_SCALE_Upper_Value,
	func5_AI_OUT_SCALE_Lower_Value,
	func5_AI_ALARM_HYS,
	func5_AI_HI_HI_LIM,
	func5_AI_HI_LIM,
	func5_AI_LO_LIM,
	func5_AI_LO_LO_LIM
}

UNIT func5_AI_OUT_SCALE_unit_2
{
	func5_AI_OUT_SCALE_Units_Index:

	func5_AI_HI_HI_ALM_Value,
	func5_AI_HI_ALM_Value,
	func5_AI_LO_ALM_Value,
	func5_AI_LO_LO_ALM_Value,
	func5_AI_FSAFE_VALUE
}

// Bmand:
// - MENU func5_AI_Simulation
// - MENU func5_AI_Simulation_input
// - MENU func5_AI_Simulation_input_group
// - MENU func5_AI_Simulation_output
// - MENU func5_AI_Simulation_output_group

MENU func5_AI_Simulation
{
	LABEL [PI_func1_AI];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func5_AI_Simulation_input,
		func5_AI_Simulation_output
	}
}

MENU func5_AI_Simulation_input
{
	LABEL [PI_menu_dialog_simulation_input];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_SIMULATE_Enabled,
		func5_AI_Simulation_input_group
	}
}

MENU func5_AI_Simulation_input_group
{
	LABEL [PI_SIMULATE_Value_label];
	STYLE GROUP;
	ITEMS
	{
		func5_AI_SIMULATE_Value,
		COLUMNBREAK,
		func5_AI_SIMULATE_Status_Condensed
	}
}

MENU func5_AI_Simulation_output
{
	LABEL [PI_menu_dialog_simulation_output];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_TARGET_MODE,
		func5_AI_MODE_BLK_Actual,
		func5_AI_Simulation_output_group
	}
}

MENU func5_AI_Simulation_output_group
{
	LABEL [PI_OUT_Value_label];
	STYLE GROUP;
	ITEMS
	{
		func5_AI_OUT_Value,
		COLUMNBREAK,
		func5_AI_OUT_Status_Condensed
	}
}

// Amand:
// - MENU func5_AI_Display_mandatory_A
// - CHART func5_AI_Display_BarVal_out_mandatory_A
// - SOURCE func5_AI_Display_BarVal_out_source_mandatory_A
// - MENU func5_AI_Display_out_mandatory_A

MENU func5_AI_Display_mandatory_A
{
	LABEL [PI_func1_AI];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_TAG_DESC,
		func5_AI_Display_BarVal_out_mandatory_A,
		func5_AI_Display_out_mandatory_A
	}
}

CHART func5_AI_Display_BarVal_out_mandatory_A
{
	LABEL [PI_OUT_Value_label];
	HELP [PI_OUT_Value_help];
	TYPE HORIZONTAL_BAR;
	MEMBERS
	{
		func5_AI_chart_member1, func5_AI_Display_BarVal_out_source_mandatory_A;
	}
}

SOURCE func5_AI_Display_BarVal_out_source_mandatory_A
{
	MEMBERS
	{
		func5_AI_src_member1, func5_AI_OUT_Value;
	}
}

MENU func5_AI_Display_out_mandatory_A
{
	LABEL [PI_BLOCK_OBJECT_Parent_Class_enum_2_1];
	STYLE GROUP;
	ITEMS
	{
		func5_AI_MODE_BLK_Actual,
		COLUMNBREAK,
		func5_AI_OUT_Status_Condensed (READ_ONLY),
		func5_AI_ALARM_SUM_Current
	}
}

// Bmand:
// - MENU func5_AI_Display_mandatory_B
// - CHART func5_AI_Display_BarVal_out_mandatory_B
// - SOURCE func5_AI_Display_BarVal_out_source_mandatory_B
// - AXIS func5_AI_Display_BarVal_out_axis_mandatory_B
// - MENU func5_AI_Display_out_mandatory_B
// - MENU func5_AI_Display_in_mandatory_B

MENU func5_AI_Display_mandatory_B
{
	LABEL [PI_func1_AI];
	STYLE PAGE;
	ITEMS
	{
		func5_AI_TAG_DESC,
		func5_AI_Display_BarVal_out_mandatory_B,
		func5_AI_Display_out_mandatory_B,
		func5_AI_Display_in_mandatory_B
	}
}

CHART func5_AI_Display_BarVal_out_mandatory_B
{
	LABEL [PI_OUT_Value_label];
	HELP [PI_OUT_Value_help];
	TYPE HORIZONTAL_BAR;
	MEMBERS
	{
		func5_AI_chart_member1, func5_AI_Display_BarVal_out_source_mandatory_B;
	}
}

SOURCE func5_AI_Display_BarVal_out_source_mandatory_B
{
	Y_AXIS func5_AI_Display_BarVal_out_axis_mandatory_B;
	MEMBERS
	{
		func5_AI_src_member1, func5_AI_OUT_Value;
	}
}

AXIS func5_AI_Display_BarVal_out_axis_mandatory_B
{
	MIN_VALUE func5_AI_OUT_SCALE_Lower_Value;
	MAX_VALUE func5_AI_OUT_SCALE_Upper_Value;
}

MENU func5_AI_Display_out_mandatory_B
{
	LABEL [PI_BLOCK_OBJECT_Parent_Class_enum_2_1];
	STYLE GROUP;
	ITEMS
	{
		func5_AI_MODE_BLK_Actual,
		COLUMNBREAK,
		func5_AI_OUT_Status_Condensed (READ_ONLY),
		func5_AI_ALARM_SUM_Current
	}
}

MENU func5_AI_Display_in_mandatory_B
{
	LABEL [PI_BLOCK_OBJECT_Parent_Class_enum_1_1];
	ITEMS
	{
		func5_AI_CHANNEL (READ_ONLY),
		COLUMNBREAK,
		func5_AI_SIMULATE_Enabled (READ_ONLY)
	}
}

// Aman:
// - MENU func5_AI_Tab_s_mandatory_A
// - MENU func5_AI_Tab_s_pv_range_mandatory_A
// - MENU func5_AI_Tab_s_limits_mandatory_A
// - MENU func5_AI_Tab_m_mandatory_A
// - MENU func5_AI_Tab_m_pv_range_mandatory_A
// - MENU func5_AI_Tab_m_limits_mandatory_A

MENU func5_AI_Tab_s_mandatory_A
{
	LABEL [PI_func1_AI];
	ITEMS
	{
		func5_AI_ST_REV,
		func5_AI_TAG_DESC,
		func5_AI_PV_FTIME,
		func5_AI_Tab_s_pv_range_mandatory_A,
		func5_AI_Tab_s_limits_mandatory_A
	}
}

MENU func5_AI_Tab_s_pv_range_mandatory_A
{
	LABEL [PI_menu_input_measwindow];
	ITEMS
	{
		func5_AI_PV_SCALE_Lower_Value,
		func5_AI_PV_SCALE_Upper_Value
	}
}


MENU func5_AI_Tab_s_limits_mandatory_A
{
	LABEL [PI_menu_output_limits];
	ITEMS
	{
		func5_AI_LO_LO_LIM,
		func5_AI_LO_LIM,
		func5_AI_HI_LIM,
		func5_AI_HI_HI_LIM,
		func5_AI_ALARM_HYS
	}
}

MENU func5_AI_Tab_m_mandatory_A
{
	LABEL [PI_func1_AI];
	ITEMS
	{
		func5_AI_ST_REV,
		func5_AI_TAG_DESC (READ_ONLY),
		func5_AI_PV_FTIME (READ_ONLY),
		func5_AI_Tab_m_pv_range_mandatory_A,
		func5_AI_Tab_m_limits_mandatory_A
	}
}

MENU func5_AI_Tab_m_pv_range_mandatory_A
{
	LABEL [PI_menu_input_measwindow];
	ITEMS
	{
		func5_AI_PV_SCALE_Lower_Value (READ_ONLY),
		func5_AI_PV_SCALE_Upper_Value (READ_ONLY)
	}
}


MENU func5_AI_Tab_m_limits_mandatory_A
{
	LABEL [PI_menu_output_limits];
	ITEMS
	{
		func5_AI_LO_LO_LIM (READ_ONLY),
		func5_AI_LO_LIM (READ_ONLY),
		func5_AI_HI_LIM (READ_ONLY),
		func5_AI_HI_HI_LIM (READ_ONLY),
		func5_AI_ALARM_HYS (READ_ONLY)
	}
}

// Bman:
// - MENU func5_AI_Tab_s_mandatory_B
// - MENU func5_AI_Tab_s_pv_range_mandatory_B
// - MENU func5_AI_Tab_s_outscale_mandatory_B
// - MENU func5_AI_Tab_s_limits_mandatory_B
// - MENU func5_AI_Tab_s_interface_mandatory_B
// - MENU func5_AI_Tab_m_mandatory_B
// - MENU func5_AI_Tab_m_pv_range_mandatory_B
// - MENU func5_AI_Tab_m_outscale_mandatory_B
// - MENU func5_AI_Tab_m_limits_mandatory_B

MENU func5_AI_Tab_s_mandatory_B
{
	LABEL [PI_func1_AI];
	ITEMS
	{
		func5_AI_ST_REV,
		func5_AI_TAG_DESC,
		func5_AI_CHANNEL,
		func5_AI_OUT_SCALE_Units_Index,
		func5_AI_PV_FTIME,
		func5_AI_Tab_s_pv_range_mandatory_B,
		func5_AI_Tab_s_outscale_mandatory_B,
		func5_AI_Tab_s_limits_mandatory_B,
		func5_AI_Tab_s_interface_mandatory_B
	}
}

MENU func5_AI_Tab_s_pv_range_mandatory_B
{
	LABEL [PI_menu_input_measwindow];
	ITEMS
	{
		func5_AI_PV_SCALE_Lower_Value,
		func5_AI_PV_SCALE_Upper_Value
	}
}

MENU func5_AI_Tab_s_outscale_mandatory_B
{
	LABEL [PI_menu_output_scalewindow];
	ITEMS
	{
		func5_AI_OUT_SCALE_Lower_Value,
		func5_AI_OUT_SCALE_Upper_Value
	}
}

MENU func5_AI_Tab_s_limits_mandatory_B
{
	LABEL [PI_menu_output_limits];
	ITEMS
	{
		func5_AI_LO_LO_LIM,
		func5_AI_LO_LIM,
		func5_AI_HI_LIM,
		func5_AI_HI_HI_LIM,
		func5_AI_ALARM_HYS
	}
}

MENU func5_AI_Tab_s_interface_mandatory_B
{
	LABEL [PI_menu_interface];
	ITEMS
	{
		func5_AI_OUT_SCALE_Decimal_Point
	}
}

MENU func5_AI_Tab_m_mandatory_B
{
	LABEL [PI_func1_AI];
	ITEMS
	{
		func5_AI_ST_REV,
		func5_AI_TAG_DESC (READ_ONLY),
		func5_AI_CHANNEL (READ_ONLY),
		func5_AI_OUT_SCALE_Units_Index (READ_ONLY),
		func5_AI_PV_FTIME (READ_ONLY),
		func5_AI_Tab_m_pv_range_mandatory_B,
		func5_AI_Tab_m_outscale_mandatory_B,
		func5_AI_Tab_m_limits_mandatory_B,
		func5_AI_Tab_s_interface_mandatory_B
	}
}

MENU func5_AI_Tab_m_pv_range_mandatory_B
{
	LABEL [PI_menu_input_measwindow];
	ITEMS
	{
		func5_AI_PV_SCALE_Lower_Value (READ_ONLY),
		func5_AI_PV_SCALE_Upper_Value (READ_ONLY)
	}
}

MENU func5_AI_Tab_m_outscale_mandatory_B
{
	LABEL [PI_menu_output_scalewindow];
	ITEMS
	{
		func5_AI_OUT_SCALE_Lower_Value (READ_ONLY),
		func5_AI_OUT_SCALE_Upper_Value (READ_ONLY)
	}
}

MENU func5_AI_Tab_m_limits_mandatory_B
{
	LABEL [PI_menu_output_limits];
	ITEMS
	{
		func5_AI_LO_LO_LIM (READ_ONLY),
		func5_AI_LO_LIM (READ_ONLY),
		func5_AI_HI_LIM (READ_ONLY),
		func5_AI_HI_HI_LIM (READ_ONLY),
		func5_AI_ALARM_HYS (READ_ONLY)
	}
}

/* END post EDD */
