#define DSTAT       /*if( status != BLTIN_SUCCESS ) display_builtin_error( status ) */

#define str_Info_Logbook      "|en|Reading logbook may take several minutes.|de|Das Auslesen des Logbuchs kann mehrere Minuten dauern."

MENU logbook_window
{
    LABEL TXT_LOGBOOK;
    STYLE WINDOW;
    ITEMS
    {
        logbook_page
    }
}

MENU logbook_page
{
    LABEL TXT_LOGBOOK;
    STYLE PAGE;
    ITEMS
    {
        //lookbook_info,
        str_Info_Logbook,
		ROWBREAK,
        method_logbook, COLUMNBREAK, method_logbook_erase, COLUMNBREAK, "  ", COLUMNBREAK, "  ", 
		ROWBREAK,
        logbook_summary(NO_LABEL)
    }
}

/* ----- Entry ----- */
VARIABLE LogbookEntry
{
    LABEL "Count";
    CLASS LOCAL;
    TYPE UNSIGNED_INTEGER(4);
    HANDLING READ;
}

VARIABLE LogbookCount
{
    LABEL "Entry";
    CLASS LOCAL;
    TYPE UNSIGNED_INTEGER(4);
    DEFAULT_VALUE 0;
    HANDLING READ;
}

/* ----- Zeit ----- */
VARIABLE LogbookTime
{
    LABEL "Time";
    CLASS LOCAL;
    TYPE ASCII(20);
    HANDLING READ;
}

/* ----- Messagetype STATIC,BEGIN... ----- */
VARIABLE LogbookMessageType
{
    LABEL "Type";
    CLASS LOCAL;
    TYPE ASCII(15);
    HANDLING READ;
}

/* ----- Message ----- */
VARIABLE LogbookMessage
{
    LABEL "Message";
    CLASS LOCAL;
    TYPE ASCII(42);
    HANDLING READ;
}

/* ----- Text ----- */
VARIABLE LogbookText
{
    LABEL "Value";
    CLASS LOCAL;
    TYPE ASCII(16);
    HANDLING READ;
}

VARIABLE logbook_summary
{
    LABEL "";
    CLASS LOCAL;
    TYPE ASCII(10201);
    STYLE "MULTILINE 80 40";
    HANDLING READ;
    PRE_EDIT_ACTIONS
    {
        DEFINITION
        {
            get_dictionary_string(str_Logbook_Title, logbook_summary);
            save_values();
        }
    }
}

COLLECTION LogbookDataCollection
{
    LABEL "Logbook entry collection";
    MEMBERS
    {
        ID, LogbookEntry;
        TIMESTAMP, LogbookTime;
        ENTRYTYPE, LogbookMessageType;
        MESSAGE, LogbookMessage;
        VALUE, LogbookText;
    }
}

ARRAY LogbookDataArray
{
    LABEL "Logbook array";
    NUMBER_OF_ELEMENTS 105;
    TYPE LogbookDataCollection;
}

/*
 VARIABLE LogbookStop
 {
 LABEL               "|en|Stop|de|Stopp";
 CLASS               LOCAL;
 TYPE                UNSIGNED_INTEGER(1);
 HANDLING            READ & WRITE;
 }*/

#define LOGBOOK_ENTRY_CNT           50               /* Anazhl der Eintraege im Logbuch */

#define LGB_BUF_SIZE                38              /* Gre des Eintrages */
#define LGB_BUF_MESSAGE_ID          3               /* steht an Buffer 3 + n * LGB_BUF_MESSAGE_ID */
#define LGB_BUF_TIME_ID             4               /* Anfang der Zeit */
#define LGB_BUF_TIME_SIZE           19              /* Gre der Zeitstring */
#define LGB_BUF_TIME_BITS           23              /* Kodierung der Message */
#define LGB_BUF_STRING_ID           24              /* ab hier steht der Eintragstext z.B. Steilheit oder MS-Seriennummer als ASCII */

METHOD strfmt(DD_STRING txt, unsigned int length) {
    TYPE DD_STRING;
DEFINITION
{
    char buf[1000];
    int i;

    buf = txt;

    for (i = strlen(txt); i < length; i++) {
        buf[i] += ' ';
    }

    return buf;
}
}

/*-------------------------------------------------------------------*/
/*  Methode zum Fllen des Strings                                */
/*-------------------------------------------------------------------*/
METHOD method_format_logbook_entry(unsigned int index) 
{
	LABEL "|en|Read Logbook|de|Logbuch auslesen";
	CLASS OUTPUT;
	TYPE DD_STRING;
	DEFINITION
	{
		
		DD_STRING buf_message;
		/*
		buf_message += strfmt("" + LogbookDataArray[index].ID, 4);

		buf_message += strfmt(LogbookDataArray[index].TIMESTAMP, 20);

		buf_message += strfmt(LogbookDataArray[index].ENTRYTYPE, 16);

		buf_message += strfmt(LogbookDataArray[index].MESSAGE, 47);

		buf_message += strfmt(LogbookDataArray[index].VALUE, 20);

		buf_message += "\n";
		*/
		buf_message += LogbookDataArray[index].ID + "\t" + 
					   LogbookDataArray[index].TIMESTAMP + "\t" + 
					   LogbookDataArray[index].ENTRYTYPE + "\t" + 
					   LogbookDataArray[index].MESSAGE + "\t\t\t" + 
					   LogbookDataArray[index].VALUE;
		buf_message += "\n";
		
		return buf_message;
	}
}

METHOD method_logbook
{
LABEL "|en|Read Logbook|de|Logbuch auslesen";
CLASS OUTPUT;
DEFINITION
{
int i,j,n,m;
unsigned char buf[128];
int messagetype;
int index; /* Index vom Grid, der gerade befllt wird */
char str_buf[256];
char msg_buf[256];
char timeBuf[LGB_BUF_TIME_SIZE+1];

save_values();

/* es gibt caching und non-caching hosts.
 Bei einem Caching-Host muss man immer mit read_value() und send_value()
 die Wertte aktualisieren, da die Werte nur in der Device-Table zwischengespeichert werden
 Bei einem non-caching- Host werden die diese Funktionen ignoriert und immer mit get_... und put_...
 aktualisiert
 Ablauf:
 ---------------
 Wir schreiben in die Variable LOGBOOK_ENTRY den Index, den wir dann mit der Variable LOGBOOK_BINARY_DATA
 auslesen mchten.
 Wenn wir LOGBOOK_BINARY_DATA ausgelesen haben, mssen wir den Bytestream dekodieren.
 Insgesamt gibt es 200 Eintrge.
 Der Datenstream enthlt 2 Datenstze, um die Anzahl der Zugriffe zu verringern.
 Aufbau des Streams
 Byte 2      First Entry Index       [u8]
 Byte 3      Message ID_1            [u8]
 Byte 4      Day_1                   [u8]
 Byte 5      Month_1                 [u8]
 Byte 6..7   Year_1                  [u16]
 Byte 8      Hour_1                  [u8]
 Byte 9      Minute_1                [u8]
 Byte 10     Second_1                [u8]
 Byte 11     Bits_1                  [u8]
 0..1 Sensoface
 0 ? Sensoface Good
 1 ? Sensoface Medium
 2 ? Sensoface Bad
 3 ? Sensoface Unknown
 5..7 Info-Typ
 0 ? STATIC
 1 ? BEGIN (of Message)
 2 ? END (of Message)
 3 ? FLOAT (mit Wert)
 4 ? U32
 5 ? CHAR12 (wird ausgepackt bertragen)
 Byte 12..15 Float_1                 [float]
 Byte 16..19 Integer_1               [u32]
 Byte 20..35 String_1                [16 x u8]
 Byte 36     Second Entry Index      [u8]
 Byte 37..69 siehe Beschreibung zum ersten Eintrag

 Die Darstellung erfolgt bei DD5 mit einem Grid
 Aufbau des Grids:
 --------------------
 Eintrag  |  Datum  |  Type  |  Message  |  Value 1 | Value 2 | Text

 */
// Zuerst lschen wir das Grid
/* mhu
 for( i = 0; i < LOGBOOK_ENTRY_CNT * 2 ; i++ )
 {
 LogbookDataArray[i].ID = i+1;
 LogbookDataArray[i].TIMESTAMP = " ";
 LogbookDataArray[i].ENTRYTYPE = " ";
 LogbookDataArray[i].MESSAGE = " ";
 LogbookDataArray[i].VALUE = " ";
 }
 */

method_empty_local_logbook();

index = 0;

logbook_summary = [str_Logbook_reading];

for( i = 0; i < LOGBOOK_ENTRY_CNT; i++ )
{
    /* ---------- Logbuchdaten vom Gert auslesen -------------- */
    /* Zuerst die Eintrge bestimmen, die wir brauchen. Dazu schreiben wir die Nummer nach LOGBOOK_ENTRY */
    //assign_int( logbook_entry, i );
    logbook_entry = i;

    WriteCommand(tb1_logbook_entry_write);

    /* ---------- Jetzt lesen wir die Logbook- Binr- Daten aus ---------- */
    ReadCommand(tb1_logbook_binary_data_read);

    /* Hinweis: Das Einfachste wre es, wenn man die Binrdaten einfach in ein Char-Buffer ldt, da wir hier aber
     eine FF-DD schreiben, wre das einfach zu einfach.
     Die Funktion get_string_value() liest zwar die Binrdaten ein,
     macht aber dann z.B. aus einer Hex-Zahl 0x23 zwei Bytes '2' und '3' Damit kann man nichts anfangen, weil hier
     ein Rckcodieren nicht besonders spaig werden wrde.
     Merkwrdig ist nur, dass Herr Klemp diesen Weg beim Cal-Protokoll gegangen ist und es dort anscheinend ging.
     Frher wurde aber nur mit dem NI-Configurator getestet. Ich habe es mit AMS getestet, das sich in vielen Fllen
     anders als NI verhlt.
     Nach ein paar Stunden Trial&Error bin ich auf folgende Lsung gekommen:
     Also belassen wir den Variablentyp im Gert als Octet, ndern die Variable in der DD aber ein ein ARRAY of u8[]
     Dadurch knnen wir mit read_value das gesamte Array auslesen und dann in einer Schleife schn die Bytes in den
     Buffer kopieren (mit get_unsigned_value())*/

    for( j = 0;j < LGB_BUF_SIZE*2; j ++) {

        buf[j] = logbook_binary_data[j];
    }

    /* Jetzt haben wir alles ausgelesen, nun die Werte formatieren und anzeigen */

    /* Der Stream besteht aus 2 Eintrgen, also die Dekodierung 2 Mal rberlaufen lassen */
    for( m = 0; m < 2; m++ ) {

        if( buf[LGB_BUF_MESSAGE_ID + m * LGB_BUF_SIZE] == 0xFF ) { /* 0xFF heit leerer Eintrag, dann also abbrechen */

            break;
        }

        /* ------------------------ Eintrag ins Grid eintragen ------------------------ */
        LogbookDataArray[index].ID = index;

        /* ------------------------ Datum ------------------------
         Die Zeit wird in 19 Bytes als ASCII bertragen
         z.B. "2013-12-13 23:42:22"
         Daher kopieren wir den String in eine Variable und zeigen ihn an*/
        for( j = 0; j < LGB_BUF_TIME_SIZE; j++ ) {

            timeBuf[j] = buf[LGB_BUF_TIME_ID + m * LGB_BUF_SIZE + j];
        }

        LogbookDataArray[index].TIMESTAMP = timeBuf;
		LogbookDataArray[index].ENTRYTYPE = "\t";
		
        /* ------------------------ Der Message-Typ ist in den oberen 3 Bits kodiert ------------------------*/
        if( ( buf[LGB_BUF_TIME_BITS + m * LGB_BUF_SIZE] & 0xE0 ) == 0 ) {

            messagetype = 0;
            get_dictionary_string(str_Message_static, LogbookDataArray[index].ENTRYTYPE);
        }
        else if( ( buf[LGB_BUF_TIME_BITS + m * LGB_BUF_SIZE] & 0xE0 ) == 0x20 ) {
            messagetype = 1; /* Messagetype BEGIN*/
            get_dictionary_string(str_Message_begin, LogbookDataArray[index].ENTRYTYPE);
        }
        else if( ( buf[LGB_BUF_TIME_BITS + m * LGB_BUF_SIZE] & 0xE0 ) == 0x40 ) {

            messagetype = 2; /* Messagetype END*/
            get_dictionary_string(str_Message_end, LogbookDataArray[index].ENTRYTYPE);
        }
        else if( ( ( buf[LGB_BUF_TIME_BITS + m * LGB_BUF_SIZE] & 0xE0 ) == 0x60 ) ||
                ( ( buf[LGB_BUF_TIME_BITS + m * LGB_BUF_SIZE] & 0xE0 ) == 0x80 ) ||
                ( ( buf[LGB_BUF_TIME_BITS + m * LGB_BUF_SIZE] & 0xE0 ) == 0xA0 ) ) {

            messagetype = 5;
            str_buf = "";
            for( n = 0; n < 16; n++) {

                if (buf[LGB_BUF_STRING_ID + m * LGB_BUF_SIZE + n] == 0x00)
                break;

                str_buf[n] = buf[LGB_BUF_STRING_ID + m * LGB_BUF_SIZE + n];
            }

            LogbookDataArray[index].VALUE = strtrim(str_buf);
        }
        else if( ( buf[LGB_BUF_TIME_BITS + m * LGB_BUF_SIZE] & 0xE0 ) == 0xC0 ) {
            /* Wenn 6, dann hat sich das Logbuch verndert und muss neu gelesen werden */
            PUT_MESSAGE( "\nLogbook data changed. Please read again.\n");
            return;
        }

        /* ------- Jetzt die Message dekodieren -----------
         dazu muss man umstndlich den Textbuffer in eine Variable kopieren */
        switch(buf[LGB_BUF_MESSAGE_ID + m * LGB_BUF_SIZE] ) {

            case 0: msg_buf = TXT_MSG_0; break;
            case 1: msg_buf = TXT_MSG_1; break;
            case 2: msg_buf = TXT_MSG_2; break;
            case 3: msg_buf = TXT_MSG_3; break;
            case 4: msg_buf = TXT_MSG_4; break;
            case 5: msg_buf = TXT_MSG_5; break;
            case 6: msg_buf = TXT_MSG_6; break;
            case 7: msg_buf = TXT_MSG_7; break;
            case 8: msg_buf = TXT_MSG_8; break;
            case 9: msg_buf = TXT_MSG_9; break;
            case 10: msg_buf = TXT_MSG_10; break;
            case 11: msg_buf = TXT_MSG_11; break;
            case 12: msg_buf = TXT_MSG_12; break;
            case 13: msg_buf = TXT_MSG_13; break;
            case 14: msg_buf = TXT_MSG_14; break;
            case 15: msg_buf = TXT_MSG_15; break;
            case 16: msg_buf = TXT_MSG_16; break;
            case 17: msg_buf = TXT_MSG_17; break;
            case 18: msg_buf = TXT_MSG_18; break;
            case 19: msg_buf = TXT_MSG_19; break;
            case 20: msg_buf = TXT_MSG_20; break;
            case 21: msg_buf = TXT_MSG_21; break;
            case 22: msg_buf = TXT_MSG_22; break;
            case 23: msg_buf = TXT_MSG_23; break;
            case 24: msg_buf = TXT_MSG_24; break;
            case 25: msg_buf = TXT_MSG_25; break;
            case 26: msg_buf = TXT_MSG_26; break;
            case 27: msg_buf = TXT_MSG_27; break;
            case 28: msg_buf = TXT_MSG_28; break;
            case 29: msg_buf = TXT_MSG_29; break;
            case 30: msg_buf = TXT_MSG_30; break;
            case 31: msg_buf = TXT_MSG_31; break;
            case 32: msg_buf = TXT_MSG_32; break;
            case 33: msg_buf = TXT_MSG_33; break;
            case 34: msg_buf = TXT_MSG_34; break;
            case 35: msg_buf = TXT_MSG_35; break;
            case 36: msg_buf = TXT_MSG_36; break;
            case 37: msg_buf = TXT_MSG_37; break;
            case 38: msg_buf = TXT_MSG_38; break;
            case 39: msg_buf = TXT_MSG_39; break;
            case 40: msg_buf = TXT_MSG_40; break;
            case 41: msg_buf = TXT_MSG_41; break;
            case 42: msg_buf = TXT_MSG_42; break;
            case 43: msg_buf = TXT_MSG_43; break;
            case 44: msg_buf = TXT_MSG_44; break;
            case 45: msg_buf = TXT_MSG_45; break;
            case 46: msg_buf = TXT_MSG_46; break;
            case 47: msg_buf = TXT_MSG_47; break;
            case 48: msg_buf = TXT_MSG_48; break;
            case 49: msg_buf = TXT_MSG_49; break;
            case 50: msg_buf = TXT_MSG_50; break;
            case 51: msg_buf = TXT_MSG_51; break;
            case 52: msg_buf = TXT_MSG_52; break;
            case 53: msg_buf = TXT_MSG_53; break;
            case 54: msg_buf = TXT_MSG_54; break;
            case 55: msg_buf = TXT_MSG_55; break;
            case 56: msg_buf = TXT_MSG_56; break;
            case 57: msg_buf = TXT_MSG_57; break;
            case 58: msg_buf = TXT_MSG_58; break;
            case 59: msg_buf = TXT_MSG_59; break;
            case 60: msg_buf = TXT_MSG_60; break;
            case 61: msg_buf = TXT_MSG_61; break;
            case 62: msg_buf = TXT_MSG_62; break;
            case 63: msg_buf = TXT_MSG_63; break;
            case 64: msg_buf = TXT_MSG_64; break;
            case 65: msg_buf = TXT_MSG_65; break;
            case 66: msg_buf = TXT_MSG_66; break;
            case 67: msg_buf = TXT_MSG_67; break;
            case 68: msg_buf = TXT_MSG_68; break;
            case 69: msg_buf = TXT_MSG_69; break;
            case 70: msg_buf = TXT_MSG_70; break;
            case 71: msg_buf = TXT_MSG_71; break;
            case 72: msg_buf = TXT_MSG_72; break;
            case 73: msg_buf = TXT_MSG_73; break;
            case 74: msg_buf = TXT_MSG_74; break;
            case 75: msg_buf = TXT_MSG_75; break;
            case 76: msg_buf = TXT_MSG_76; break;
            case 77: msg_buf = TXT_MSG_77; break;
            case 78: msg_buf = TXT_MSG_78; break;
            case 79: msg_buf = TXT_MSG_79; break;
            case 80: msg_buf = TXT_MSG_80; break;
            case 81: msg_buf = TXT_MSG_81; break;
            case 82: msg_buf = TXT_MSG_82; break;
            default: break;
        } /* end switch */

        if( buf[LGB_BUF_MESSAGE_ID + m * LGB_BUF_SIZE] == 0xFF ) { /* 0xFF heit leerer Eintrag, dann also abbrechen */

            break;
        }

        LogbookDataArray[index].MESSAGE = msg_buf;

        //logbook_summary += method_format_logbook_entry(index);
        //save_values();

        index++; /* Index vom Grid, der gerade befllt wird */

        logbook_summary += ".";

        //if (index % 20 == 0)
        //logbook_summary += "\n                     ";
    }

    if( buf[LGB_BUF_MESSAGE_ID + m * LGB_BUF_SIZE] == 0xFF ) { /* 0xFF heit leerer Eintrag, dann also abbrechen */

        break;
    } /* Ende for-Schleife */

}

get_dictionary_string(str_Logbook_Title, logbook_summary);
for (i=0; i<index; i++) {

    logbook_summary += method_format_logbook_entry(i);
}

if (index == 0)
logbook_summary += "Das Logbuch ist leer.";

save_on_exit();

save_values();
}
}

/*-------------------------------------------------------------------
 Methode zum Lschen des Logbuchs
 -------------------------------------------------------------------*/
METHOD method_logbook_erase
{
                //LABEL       "|en|Erase Logbook|de|Logbuch lschen";
LABEL "|en|Erase Logbook|de|Logbuch lschen";
CLASS OUTPUT;
DEFINITION
{
/* Logbuch lschen */
assign_int( logbook_erase, 1 );
WriteCommand(tb1_logbook_erase_write);
// Jetzt das Grid lschen
/* mhu		for( i = 0; i < LOGBOOK_ENTRY_CNT * 2 ; i++ )
 {
 LogbookDataArray[i].ID = i+1;
 LogbookDataArray[i].TIMESTAMP = " ";
 LogbookDataArray[i].ENTRYTYPE = " ";
 LogbookDataArray[i].MESSAGE = " ";
 LogbookDataArray[i].VALUE = " ";
 }
 */
method_empty_local_logbook();
}
}

/*-------------------------------------------------------------------
 Methode zum Lschen des Logbuchs
 -------------------------------------------------------------------*/
METHOD method_empty_local_logbook
{
LABEL "";
CLASS OUTPUT;
DEFINITION
{
int i;

for( i = 0; i < LOGBOOK_ENTRY_CNT * 2; i++ ) {

    LogbookDataArray[i].ID = 0;
    LogbookDataArray[i].TIMESTAMP = " ";
    LogbookDataArray[i].ENTRYTYPE = " ";
    LogbookDataArray[i].MESSAGE = " ";
    LogbookDataArray[i].VALUE = " ";
}

// table header
get_dictionary_string(str_Logbook_Title, logbook_summary);

}
}

