/*
 --------------------------------------------------------------------------------------
 Datei:          import_fb.ddl
 Ersteller:      msh
 Datum           28.10.2013

 Inhalt:         EDD fr Stratos Bus PA
 Import aller Funktionsblcke, PB, TB
 --------------------------------------------------------------------------------------
 */
/*
 -----------------------------
 ####  ####
 #   # #   #
 ####  ####
 #     #   #
 #     ####

 Physical Block importieren
 -----------------------------
 */
#define DEXT_BIT_00           0x01000000     /* 0x00000001 */   /* |||||||| |||||||| |||||||| |||||||+-------- 0 :        reserviert (Check Function bei FF )     Good                                                */
#define DEXT_BIT_01           0x02000000     /* 0x00000002 */   /* |||||||| |||||||| |||||||| ||||||+--------- 1 :        Autoklavierzhler                       Good                                                */
#define DEXT_BIT_02           0x04000000     /* 0x00000004 */   /* |||||||| |||||||| |||||||| |||||+---------- 2 :        CIP Zyklen berschritten                Good                                                */
#define DEXT_BIT_03           0x08000000     /* 0x00000008 */   /* |||||||| |||||||| |||||||| ||||+----------- 3 :        SIP-Zyklen berschritten                Good                                                */
#define DEXT_BIT_04           0x10000000     /* 0x00000010 */   /* |||||||| |||||||| |||||||| |||+------------ 4 :        Parametrierfehler User Buffer           Good                                                */
#define DEXT_BIT_05           0x20000000     /* 0x00000020 */   /* |||||||| |||||||| |||||||| ||+------------- 5 :        reserviert                                                                                  */
#define DEXT_BIT_06           0x40000000     /* 0x00000040 */   /* |||||||| |||||||| |||||||| |+-------------- 6 :        reserviert                                                                                  */
#define DEXT_BIT_07           0x80000000     /* 0x00000080 */   /* |||||||| |||||||| |||||||| +--------------- 7 :        reserviert                                                                                  */
                                                                /*                                                                                                                                                    */
#define DEXT_BIT_08           0x00010000     /* 0x00000100 */   /* |||||||| |||||||| |||||||+----------------- 8 :        Sensorverschlei                        Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_09           0x00020000     /* 0x00000200 */   /* |||||||| |||||||| ||||||+------------------ 9 :        TTM                                     Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_10           0x00040000     /* 0x00000400 */   /* |||||||| |||||||| |||||+------------------- 10:        Kalibriertimer abgelaufen               Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_11           0x00080000     /* 0x00000800 */   /* |||||||| |||||||| ||||+-------------------- 11:        Sensor Einstellzeit                     Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_12           0x00100000     /* 0x00001000 */   /* |||||||| |||||||| |||+--------------------- 12:        Cal-Daten schlecht(Smiley)              Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_13           0x00200000     /* 0x00002000 */   /* |||||||| |||||||| ||+---------------------- 13:        Sensocheck                              Bad | Sensor_Failure                                */
#define DEXT_BIT_14           0x00400000     /* 0x00004000 */   /* |||||||| |||||||| |+----------------------- 14:        reserviert                                                                                  */
#define DEXT_BIT_15           0x00800000     /* 0x00008000 */   /* |||||||| |||||||| +------------------------ 15:        reserviert                                                                                  */
                                                                /*                                                                                                                                                    */
#define DEXT_BIT_16           0x00000100     /* 0x00010000 */   /* |||||||| |||||||+-------------------------- 16:        Temp. auerhalb Tabelle                 Bad | Sensor_Failure                                */
#define DEXT_BIT_17           0x00000200     /* 0x00020000 */   /* |||||||| ||||||+--------------------------- 17:        Temperaturbereich ber/unterschritten   Bad | Sensor_Failure                                */
#define DEXT_BIT_18           0x00000400     /* 0x00040000 */   /* |||||||| |||||+---------------------------- 18:        Messbereich ber/unterschritten         Bad | Sensor_Failure                                */
#define DEXT_BIT_19           0x00000800     /* 0x00080000 */   /* |||||||| ||||+----------------------------- 19:        reserviert                                                                                  */
#define DEXT_BIT_20           0x00001000     /* 0x00100000 */   /* |||||||| |||+------------------------------ 20:        Kalibrierung aktiv                      Uncertain |LUV / Good (Hngt von Para ab)           */
#define DEXT_BIT_21           0x00002000     /* 0x00200000 */   /* |||||||| ||+------------------------------- 21:        Konfigurierung aktiv                    Uncertain |LUV / Good (Hngt von Para ab)           */
#define DEXT_BIT_22           0x00004000     /* 0x00400000 */   /* |||||||| |+-------------------------------- 22:        Service aktiv                           Uncertain |LUV / Good (Hngt von Para ab)           */
#define DEXT_BIT_23           0x00008000     /* 0x00800000 */   /* |||||||| +--------------------------------- 23:        reserviert                                                                                  */
                                                                /*                                                                                                                                                    */
#define DEXT_BIT_24           0x00000001     /* 0x01000000 */   /* |||||||+----------------------------------- 24:        Fehler in Cal-Daten                     Bad | Sensor_Failure                                */
#define DEXT_BIT_25           0x00000002     /* 0x02000000 */   /* ||||||+------------------------------------ 25:        Sensor entwertet                        Bad | Sensor_Failure                                */
#define DEXT_BIT_26           0x00000004     /* 0x04000000 */   /* |||||+------------------------------------- 26:        Falsches Modul/ Sensor                  Bad | Sensor_Failure                                */
#define DEXT_BIT_27           0x00000008     /* 0x08000000 */   /* ||||+-------------------------------------- 27:        Kein Sensor/Modul                       Bad | Sensor_Failure                                */
#define DEXT_BIT_28           0x00000010     /* 0x10000000 */   /* |||+--------------------------------------- 28:        Sensor defekt                           Bad | Sensor_Failure                                */
#define DEXT_BIT_29           0x00000020     /* 0x20000000 */   /* ||+---------------------------------------- 29:        Konfigurierdaten defekt                 Bad | Device_Failure                                */
#define DEXT_BIT_30           0x00000040     /* 0x40000000 */   /* |+----------------------------------------- 30:        Abgleichdaten defekt                    Bad | Device_Failure                                */
#define DEXT_BIT_31           0x00000080     /* 0x80000000 */   /* +------------------------------------------ 31:        reserviert                                                                                  */
 

IMPORT "PI/0000_0101_0302_0001_pb.ddl"
{
    EVERYTHING;
	REDEFINITIONS
    {
		REDEFINE VARIABLE phys_FEATURE_Enabled
		{
			LABEL [PI_phys_FEATURE_Enabled_label];
			CLASS CONTAINED;
			HANDLING READ;
			TYPE BIT_ENUMERATED(4)
			{    
				{ 0x02000000, [PI_FEATURE_Supported_enum_0x02], [PI_phys_FEATURE_Enabled_enum_0x02_help] },
				{ 0x01000000, [PI_FEATURE_Supported_enum_0x01], [PI_phys_FEATURE_Enabled_enum_0x01_help] }
			}
		}
		
		REDEFINE VARIABLE phys_DIAGNOSIS
		{
			LABEL [PI_phys_DIAGNOSIS_label];
			HELP [PI_phys_DIAGNOSIS_help];
			CLASS CONTAINED & DYNAMIC;
			HANDLING READ;	
			TYPE BIT_ENUMERATED(4)
			{
				{ 0x00200000, [PI_DIAGNOSIS_enum_DIA_MAINTENANCE], [PI_empty] },
				{ 0x00800000, [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL], [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL_help] },
				{ 0x00000100, [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE], [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE_help] },
				{ 0x00000200, [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM], [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM] },
				{ 0x00000400, [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK], [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK_help] },
				{ 0x00000800, [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND], [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND_help] },
				{ 0x00000080, [PI_DIAGNOSIS_enum_EXTENSION_AVAILABLE], [PI_empty] }
			}
		}
		REDEFINE VARIABLE phys_DIAGNOSIS_EXTENSION
		{
			LABEL [PI_phys_DIAGNOSIS_EXTENSION_label];
			HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
			CLASS CONTAINED & DYNAMIC;
			HANDLING READ;  

			TYPE BIT_ENUMERATED(4)      /* eigentlich 6 Byte, wir brauchen aber nur 4 Bytes, die beiden anderen Bytes werden separat abgeholt, damit PDM nicht abstrzt */
			{
			{ DEXT_BIT_01,  "Autoclave cycles overrun|de|Autoklavierzhler berschritten",          "Check/change sensor" },
			{ DEXT_BIT_02,  "CIP cycles overrun|de|CIP-Zyklen berschritten",                "Check/change sensor" },
			{ DEXT_BIT_03,  "SIP cycles overrun|de|SIP-Zyklen berschritten",                "Check/change sensor" },
			{ DEXT_BIT_04,  "Failure user table|de|Parametrierfehler Anwender-Puffer",                "Check the user table" },
			{ DEXT_BIT_08,  "Sensor wear|de|Sensorverschlei (Memosens)",                       "Check/change sensor" },
			{ DEXT_BIT_09,  "Out of maintenance|de|Wartungszhler berschritten",                "Clean sensor" },
			{ DEXT_BIT_10,  "Out of cal time|de|Kalibriertimer abgelaufen",                   "Calibrate or change sensor" },
			{ DEXT_BIT_11,  "Sensor drift|de|Sensor Einstellzeit berschritten (Drift)",                      "Calibrate or change sensor" },
			{ DEXT_BIT_12,  "Bad cal data|de|Kalibrierdaten schlecht",                      "Calibrate or change sensor" },
			{ DEXT_BIT_13,  "Sensocheck|de|Sensocheck (Glasimpedanz, Bezugsimpedanz)",                        "Check sensor" },
			{ DEXT_BIT_16,  "Out of internal table|de|Temperatur auerhalb Tabellenbereich",             "Check sensor" },
			{ DEXT_BIT_17,  "Temperature range|de|Temperaturbereich unter-/berschritten",                 "Check sensor" },
			{ DEXT_BIT_18,  "Meas value range|de|Messbereich unter-/berschritten",                  "Check sensor" },
			{ DEXT_BIT_20,  "Calibration is active|de|Kalibrierung ist aktiv",             "Finish calibration" },
			{ DEXT_BIT_21,  "Configuration is active|de|Konfigurierung ist aktiv",           "Finish configuration" },
			{ DEXT_BIT_22,  "Service is active|de|Service ist aktiv",                 "Finish service" },
			{ DEXT_BIT_24,  "Wrong cal data|de|Kalibrierdaten fehlerhaft",                    "Calibrate or change sensor" },
			{ DEXT_BIT_25,  "Canceled sensor|de|Sensor entwertet",                   "Change sensor" },
			{ DEXT_BIT_26,  "Wrong sensor/module|de|Falsches Modul/Sensor",               "Check configuration (Meas Mode) or use correct sensor/module" },
			{ DEXT_BIT_27,  "No sensor/module|de|Kein Sensor/Modul",                  "Check sensor/module connection" },
			{ DEXT_BIT_28,  "Sensor failure|de|Sensor defekt",                    "Return sensor to manufacturer" },
			{ DEXT_BIT_29,  "Configuration error|de|Konfigurierdaten defekt",               "Check every configuration parameter" },
			{ DEXT_BIT_30,  "Device failure|de|Abgleichdaten defekt",                    "Return device to manufacturer" },
			}
		}		
	}
}

/* Hier sind alle Units aufgefhrt, die vorkommen knnen */
#define AI_UNIT_LIST   	  	{ 1001,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1001,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1001    },    \
                            { 1002,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1002,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1002    },    \
                            { 1059,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1059,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1059    },    \
                            { 1133,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1133,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1133    },    \
                            { 1137,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1137,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1137    },    \
                            { 1138,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1138,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1138    },    \
                            { 1141,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1141,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1141    },    \
                            { 1213,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1213,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1213    },    \
                            { 1243,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1243,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1243    },    \
                            { 1281,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1281,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1281    },    \
                            { 1342,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1342,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1342    },    \
                            { 1353,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1353,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1353    },    \
                            { 1422,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1422,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1422    },    \
                            { 1423,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1423,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1423    },    \
                            { 1523,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1523,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1523    },    \
                            { 1524,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1524,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1524    },    \
                            { 1552,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1552,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1552    },    \
                            { 1555,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1555,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1555    },    \
                            { 1558,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1558,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1558    },    \
                            { 1559,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1559,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1559    },    \
                            { 1562,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1562,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1562    },    \
                            {   0,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_0,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_0    }    \


/* Hier sind alle Units aufgefhrt, die vorkommen knnen */
#define AO_UNIT_LIST_TEMP    { 1001,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1001,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1001    },    \
                             { 1002,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1002,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1002    }    \

#define AO_UNIT_LIST_PESSURE { 1133,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1133,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1133    },    \
                             { 1138,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1138,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1138    },    \
                             { 1141,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1141,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1141    }    \

#define MEAS_TYPE_PH 	0
#define MEAS_TYPE_COND 	1
#define MEAS_TYPE_CONDI	2
#define MEAS_TYPE_CC	3
#define MEAS_TYPE_OXY	4

#define AI_CHANNEL_LIST             { 0x015a, TXT_CH_PH }, \
                                    { 0x0134, TXT_CH_PH }, \
                                    { 0x0135, TXT_CH_PH_VOLTAGE }, \
                                    { 0x0136, TXT_CH_ORP }, \
                                    { 0x0137, TXT_CH_GLSIMP }, \
                                    { 0x0138, TXT_CH_BZGIMP }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x0140, TXT_CH_FLOW }, \
                                    { 0x0141, "DO Saturation Air" }, \
                                    { 0x0142, "DO Concentration" }, \
                                    { 0x0144, "Gas V Concentration" }, \
                                    { 0x0145, "DO Partial Pressure" }, \
                                    { 0x0146, TXT_CH_COND }, \
                                    { 0x0148, TXT_CH_MOHMCM }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014a, "Conductance" }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, "TDS" }, \
                                    { 0x014d, "Conductivity 2" }, \
                                    { 0x014e, "Calculation" }, \
                                    { 0x014f, TXT_CH_CELL }, \
                                    { 0x0150, "Temperature 2" }

#define AI_CHANNEL_LIST_PH          { 0x015a, TXT_CH_PH }, \
                                    { 0x0135, TXT_CH_PH_VOLTAGE }, \
                                    { 0x0136, TXT_CH_ORP }, \
                                    { 0x0137, TXT_CH_GLSIMP }, \
                                    { 0x0138, TXT_CH_BZGIMP }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x0140, TXT_CH_FLOW }

#define AI_CHANNEL_LIST_COND        { 0x015a, TXT_CH_COND }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x0148, TXT_CH_MOHMCM }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, TXT_CH_TDS }, \
                                    { 0x014f, TXT_CH_CELL }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x015c, TXT_CH_MOHMCM_B }, \
                                    { 0x0140, TXT_CH_FLOW }

#define AI_CHANNEL_LIST_CONDI       { 0x015a, TXT_CH_COND }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x0148, TXT_CH_MOHMCM }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, TXT_CH_TDS }, \
                                    { 0x014f, TXT_CH_CELL }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x0137, TXT_CH_GLSIMP }, \
                                    { 0x0138, TXT_CH_BZGIMP }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x015c, TXT_CH_MOHMCM_B }, \
                                    { 0x0140, TXT_CH_FLOW }

#define AI_CHANNEL_LIST_CC          { 0x0146, TXT_CH_COND_A }, \
                                    { 0x014d, TXT_CH_COND_B }, \
                                    { 0x0139, TXT_CH_TEMP_A }, \
                                    { 0x0150, TXT_CH_TEMP_B }, \
                                    { 0x015a, TXT_CH_COND_A }, \
                                    { 0x014e, TXT_CH_CALC }, \
                                    { 0x014f, TXT_CH_CELL_A }, \
                                    { 0x013e, TXT_CH_CELL_B }, \
                                    { 0x0148, TXT_CH_MOHMCM_A }, \
                                    { 0x015c, TXT_CH_MOHMCM_B }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, TXT_CH_TDS }, \
                                    { 0x0140, TXT_CH_FLOW }

#define AI_CHANNEL_LIST_OXY         { 0x015a, TXT_CH_DO_SAT }, \
                                    { 0x0142, TXT_CH_DO_CONC }, \
                                    { 0x0144, TXT_CH_DO_VCONC }, \
                                    { 0x0145, TXT_CH_DO_PART }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x0137, TXT_CH_GLSIMP }, \
                                    { 0x0138, TXT_CH_BZGIMP }, \
                                    { 0x0148, TXT_CH_MOHMCM }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, TXT_CH_TDS }, \
                                    { 0x014e, TXT_CH_CALC }, \
                                    { 0x0140, TXT_CH_FLOW }

#define AO_CHANNEL_LIST             { 0x0153, TXT_CH_TEMP }

#define AO_CHANNEL_LIST_OXY         { 0x0153, TXT_CH_TEMP }, \
                                    { 0x0155, TXT_CH_PRESS }

#define DI1_CHANNEL_LIST            { 0x0159, "USP" }

#define DO1_CHANNEL_LIST            { 0x0157, TXT_CH_RELAY1 }

#define DO2_CHANNEL_LIST            { 0x0158, TXT_CH_RELAY2 }

#include "pa_units_0302.h"
#include "pa_status.h"


#define DEF_DISPLAY_FORMAT(dec)			\
		SELECT(dec)		\
		{									\
			CASE 0:		".0f";				\
			CASE 1:		".1f";				\
			CASE 2:		".2f";				\
			CASE 3:		".3f";				\
			CASE 4:		".4f";				\
			CASE 5:		".5f";				\
			CASE 6:		".6f";				\
			CASE 7:		".7f";				\
			CASE 127:	"8.6f";				\
		}

/*
 -----------------------------
 ###    ###     ###
 #   #  #   #   #  #
 #   #  #   #      #
 #####  #   #      #
 #   #   ###       #

 Analog Output Block 1 importieren
 -----------------------------
 */
IMPORT "PI/0000_4201_0302_0001_ao1.ddl"
{

    EVERYTHING;

    REDEFINITIONS
    {
        BLOCK func1_AO_block
        {
            REDEFINE NUMBER 9;
        }
        REDEFINE VARIABLE func1_AO_PV_SCALE_Units_Index
        {
            LABEL [PI_func_AO_PV_SCALE_label];
            HELP [PI_func_AO_PV_SCALE_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(2)
            {
                //DEFAULT_VALUE 1001;
				IF (func1_AO_OUT_CHANNEL == 0x0153) { // Temperatur
					
					AO_UNIT_LIST_TEMP
				}
				IF (func1_AO_OUT_CHANNEL == 0x0155) { // Pressure
					
					AO_UNIT_LIST_PESSURE
				}
            }
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func1_AO_OUT_CHANNEL
        {
            LABEL "AO1 " + [PI_IN_CHANNEL_label];
            HELP [PI_func_AO_OUT_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                SELECT ( meas_type )
                {
                    CASE MEAS_TYPE_OXY: AO_CHANNEL_LIST_OXY
                    DEFAULT: AO_CHANNEL_LIST
                }
            }
            HANDLING READ & WRITE;
        }
		
		/* this variable can only have values from classic status */
		REDEFINE VARIABLE func1_AO_SP_Status_Condensed
		{
			LABEL [SP_Status_label];
			CLASS INPUT & DYNAMIC;
			HANDLING IF (func1_AO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }			
			TYPE ENUMERATED(1)
			{
				PI_STATUS_LIST_STANDARD_INPUT // rth: war vorher der _CAS enum, kann aber nur 
			}
		}
    }
}

/*
 -----------------------------
 ####   #####    ###
 #   #    #     #  #
 #   #    #        #
 #   #    #        #
 ####   #####      #

 Discret Input Block 1 importieren
 -----------------------------
 */
IMPORT "PI/0000_4301_0302_0001_di1.ddl"
{
    EVERYTHING;
    REDEFINITIONS
    {
        BLOCK func1_DI_block
        {
            REDEFINE NUMBER 10;
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func1_DI_CHANNEL
        {
            LABEL "DI1 " + [PI_CHANNEL_label];
            HELP [PI_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                DI1_CHANNEL_LIST
            }
            HANDLING READ & WRITE;
        }
		REDEFINE VARIABLE func1_DI_FSAFE_VAL_D
		{
			LABEL [PI_FSAFE_VALUE_label];
			HELP [PI_FSAFE_VALUE_help];
			CLASS CONTAINED;
			TYPE ENUMERATED(1)
			{
				{   0x00, [USP_valid], [USP_valid]},
				{   0x02, [USP_reduced_limit], [USP_reduced_limit]},
				{   0x01, [USP_limit], [USP_limit]}
			}	
			VALIDITY IF (func1_DI_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
		}
		REDEFINE VARIABLE func1_DI_OUT_D_Value
		{
			LABEL [PI_OUT_Value_label];
			HELP [PI_OUT_Value_help];
			CLASS OUTPUT & DYNAMIC;
			HANDLING IF (func1_DI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
			TYPE ENUMERATED(1)
			{
				{   0x00, [USP_valid], [USP_valid]},
				{   0x02, [USP_reduced_limit], [USP_reduced_limit]},
				{   0x01, [USP_limit], [USP_limit]}
			}
		}

		REDEFINE VARIABLE func1_DI_SIMULATE_Value
		{
			LABEL [PI_SIMULATE_Value_label];
			CLASS CONTAINED;
			TYPE ENUMERATED(1)
			{
				{   0x00, [USP_valid], [USP_valid]},
				{   0x02, [USP_reduced_limit], [USP_reduced_limit]},
				{   0x01, [USP_limit], [USP_limit]}
			}
		}
	}
}

/*
 -----------------------------
 ####    ###     ###
 #   #  #   #   #  #
 #   #  #   #      #
 #   #  #   #      #
 ####    ###       #

 Discret Output Block 1 importieren
 -----------------------------
 */
IMPORT "PI/0000_4401_0302_0001_do1.ddl"
{
    EVERYTHING;
    REDEFINITIONS
    {
        BLOCK func1_DO_block
        {
            REDEFINE NUMBER 11;
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func1_DO_IN_CHANNEL
        {
            LABEL "DO1 " + [PI_IN_CHANNEL_label];
            HELP [PI_func_DO_IN_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                DO1_CHANNEL_LIST
            }
            HANDLING READ & WRITE;
        }
		
		REDEFINE VARIABLE func1_DO_SP_D_Status_Condensed
		{
			LABEL [SP_Status_label];
			CLASS INPUT & DYNAMIC;
			TYPE ENUMERATED(1)
			{
				PI_STATUS_LIST_STANDARD_INPUT
			}
		}
		REDEFINE VARIABLE func1_DO_FSAFE_VAL_D
		{
			LABEL [PI_func_DO_FSAFE_VAL_D_label];
			HELP [PI_FSAFE_VALUE_help_1];
			CLASS CONTAINED;
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
			VALIDITY IF (func1_DO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
		}
		REDEFINE VARIABLE func1_DO_SP_D_Value
		{
			LABEL [PI_func_DO_SP_D_Value_label];
			HELP [PI_func_DO_SP_D_Value_help];
			CLASS INPUT & DYNAMIC;
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
		}
		REDEFINE VARIABLE func1_DO_OUT_D_Value
		{
			LABEL [PI_func_DO_OUT_D_Value_label];
			HELP [PI_OUT_Value_help_1];
			CLASS CONTAINED & DYNAMIC;
			HANDLING IF (func1_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
		}	

		REDEFINE VARIABLE func1_DO_SIMULATE_Value
		{
			LABEL [PI_DO_SIMULATE_Value_label];
			CLASS CONTAINED;
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
		}
	}

}

/*
 -----------------------------
 ####    ###    ####
 #   #  #   #       #
 #   #  #   #    ###
 #   #  #   #   #
 ####    ###    #####

 Discret Output Block 2 importieren
 -----------------------------
 */
IMPORT "PI/0000_4402_0302_0001_do2.ddl"
{
    EVERYTHING;
    REDEFINITIONS
    {
        BLOCK func2_DO_block
        {
            REDEFINE NUMBER 12;
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func2_DO_IN_CHANNEL
        {
            LABEL "DO2 " + [PI_IN_CHANNEL_label];
            HELP [PI_func_DO_IN_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                DO2_CHANNEL_LIST
            }
            HANDLING READ & WRITE;
        }
		REDEFINE VARIABLE func2_DO_SP_D_Status_Condensed
		{
			LABEL [SP_Status_label];
			CLASS INPUT & DYNAMIC;
			TYPE ENUMERATED(1)
			{
				PI_STATUS_LIST_STANDARD_INPUT
			}
		}
		REDEFINE VARIABLE func2_DO_FSAFE_VAL_D
		{
			LABEL [PI_func_DO_FSAFE_VAL_D_label];
			HELP [PI_FSAFE_VALUE_help_1];
			CLASS CONTAINED;
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
			VALIDITY IF (func2_DO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
		}
		REDEFINE VARIABLE func2_DO_SP_D_Value
		{
			LABEL [PI_func_DO_SP_D_Value_label];
			HELP [PI_func_DO_SP_D_Value_help];
			CLASS INPUT & DYNAMIC;
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
		}
		REDEFINE VARIABLE func2_DO_OUT_D_Value
		{
			LABEL [PI_func_DO_OUT_D_Value_label];
			HELP [PI_OUT_Value_help_1];
			CLASS CONTAINED & DYNAMIC;
			HANDLING IF (func2_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
		}
	REDEFINE VARIABLE func2_DO_SIMULATE_Value
		{
			LABEL [PI_DO_SIMULATE_Value_label];
			CLASS CONTAINED;
			TYPE ENUMERATED(1)
			{
				{   0, [off], [off]},
				{   1, [on], [on]}
			}
		}		
    }
}

/*
 -----------------------------
 #####  ####     ###
 #    #   #   #  #
 #    ####       #
 #    #   #      #
 #    ####       #

 Transducer Block 1 importieren
 -----------------------------
 */

IMPORT "std_tb.ddl"
{
    EVERYTHING;
}

//#include "PI/0000_7001_0302_0001.ddl"
//STANDARD, DEVICE_TYPE __IAM1_IMDATA, DEVICE_REVISION PROFILE_302, DD_REVISION 0x0001
IMPORT "PI/0000_7001_0302_0001.ddl"
{
    EVERYTHING;
}
