/*
Filename:            STRATOS_MULTI_TEXT.h
Function:            Device Description for .......
Device:              Stratos Multi
Device Revision:     1
DD Revision:         1
Last edit:           stz
Manufacturer:        KNICK GmbH & Co.,
                                Beuckestr.22,
                                D-14163 Berlin
                                Tel: +49 (0) 30-80191-0,
                                Fax: +49 (0) 30-80191-200
                                Internet: http://www.knick.de
                                email: knick@knick.de
Copyright:           (C) Knick GmbH & Co., 2019 All Rights Reserved.
*/

// Symbole --> Nicht zum bersetzen gedacht
#define CHANNEL_1                                              "CH1:" 
#define CHANNEL_2                                              "CH2:"
#define CHANNEL_3                                              "CH3:"
#define CHANNEL_VB1                                            "VB1:"
#define CHANNEL_VB2                                            "VB2:"
#define NO_CHANNEL                                             ""

#define EXTENTION_PH                                           "PH:"
#define EXTENTION_OXY                                          "DO:"
#define EXTENTION_COND                                         "COND:"
#define EXTENTION_DIAG                                         "DIAG:"
#define EXTENTION_CALC                                         "CALC:"
#define OTHER                                                  ""


// Diese Header Datei enthlt generierte Texte welche automatisch aus dem Stratos Dictionary entnommen wurden
// Hier werden bereits bersetzte Texte aus dem Stratos fr die Gerte Parameter herausgezogen
#include "STRATOS_MULTI_TEXT_gen.h"


// Stratos Spezifische Texte
#define STR_DEVICE_TYPE_STRATOS                                "Stratos Multi E401"
#define STR_DEVICE_TYPE                                        "|en|Device Type"\
                                                               "|de|Gertetyp"

// Menberschriften/Variablen Anzeigetexte
#define STR_DEVICE_ROOT_MENU                                   "|en|Device Menue"\
                                                               "|de|Gerte Men"

#define STR_PROCESS_VARIABLES_ROOT_MENU                        "|en|Process Variables"\
                                                               "|de|Prozessgren"

#define STR_DIAGNOSTIC_ROOT_MENU                               "|en|Diagnostic"\
                                                               "|de|Diagnose"

#define STR_OFFLINE_ROOT_MENU                                  "|en|Offline Menue"\
                                                               "|de|Offline Men"

#define STR_LOOP_CURRENT_UNIT                                  "|en|Loop current Unit"\
                                                               "|de|Einheit Stromausgang"

#define STR_MANUFACTURER                                       "|en|Manufacturer"\
                                                               "|de|Hersteller"

#define STR_PV_LOOP_CURRENT                                    "|en|Loop Current 1"\
                                                               "|de|Stromausgang 1"

#define STR_SIMULATED                                          "|en|Simulated"\
                                                               "|de|Simuliert"

#define STR_UPDATE_PERIOD                                      "|en|Update Period"\
                                                               "|de|Aktuallisierungsintervall"                    

#define STR_PRIVATE_LABEL                                      "|en|Private Label"\
                                                               "|de|Private Label"

#define STR_PV_ANALOG_CHANNEL_SAT                              "|en|PV Current Loop Saturated"\
                                                               "|de|PV Strom in Sttignung"
                                                             
#define STR_PV_ANALOG_CHANNEL_FIXED                            "|en|PV Analog Channel Fixed"\
                                                               "|de|PV Stromwert fixiert"

#define STR_FAILURE                                            "|en|Failure"\
                                                               "|de|Ausfall"

#define STR_OUT_OF_SPEC                                        "|en|Out Of Specification"\
                                                               "|de|Auerhalb der Spezifikation"

#define STR_FUNCTION_CHECK                                     "|en|Function Check"\
                                                               "|de|Funktionskontrolle"

#define STR_DEVICE_LOCKED                                      "|en|Device Configuration Locked"\
                                                               "|de|Gert Konfigurationssperre"

#define STR_CONFIGURATION_CHANGED_COUNTER                      "|en|Configuration Changed Counter"\
                                                               "|de|nderungszhler"

#define STR_FIELD_DEVICE_REVISION                              "|en|Field Device Revision"\
                                                               "|de|Feldgerte Revision"

#define STR_DEVICE_ID                                          "|en|Device ID"\
                                                               "|de|Gerte ID"

#define STR_PROTOCOL_REVISION                                  "|en|HART Protocol Revision"\
                                                               "|de|HART Protokoll Revision"

#define STR_PERCENT_OF_RANGE                                   "|en|Range"\
                                                               "|de|Bereichsauslastung"

#define STR_TRANSFER_FUNCTION                                  "|en|Transfer Function"\
                                                               "|de|Transfer Funktion"

#define STR_UPPER_RANGE_VALUE                                  "|en|Upper Range Value"\
                                                               "|de|Skallierung [20mA]"

#define STR_LOWER_RANGE_VALUE                                  "|en|Lower Range Value"\
                                                               "|de|Skallierung [4mA]"

#define STR_UPPER_SENSOR_LIMIT                                 "|en|Upper Sensor Limit"\
                                                               "|de|Skallierung [Max]"

#define STR_LOWER_SENSOR_LIMIT                                 "|en|Upper Sensor Limit"\
                                                               "|de|Skallierung [Min]"

#define STR_MINIMUM_SPAN                                       "|en|Minimum Span"\
                                                               "|de|Minimale Spanne"

#define STR_DAMPING                                            "|en|Damping"\
                                                               "|de|Dmpfung"

#define STR_DEVICE_SPECIFIC_STATUS                             "|en|Device Stratos"\
                                                               "|de|Gert Stratos"

#define STR_SENSOR_CHANNEL_1                                   "|en|Sensor 1"\
                                                               "|de|Sensor 1"

#define STR_SENSOR_CHANNEL_2                                   "|en|Sensor 2"\
                                                               "|de|Sensor 2"

#define STR_SENSOR_CHANNEL_3                                   "|en|Sensor 3"\
                                                               "|de|Sensor 3"

#define STR_CALCULATION_1                                      "|en|Calculation Block 1"\
                                                               "|de|Verrechnungsblock 1"

#define STR_CALCULATION_2                                      "|en|Calculation Block 2"\
                                                               "|de|Verrechnungsblock 2"

#define STR_OTHER_DEVICE_VARIABLE                              "|en|Other Variables"\
                                                               "|de|Sonstige Variablen"

#define STR_STANDARDIZED_STATUS                                "|en|Standardized Status"\
                                                               "|de|Standardisierter Status"

#define STR_SENSOR_PH                                          "|en|[pH]"\
                                                               "|de|[pH]"

#define STR_SENSOR_OXY                                         "|en|[DO]"\
                                                               "|de|[OXY]"

#define STR_SENSOR_COND                                        "|en|[COND]"\
                                                               "|de|[COND]"

#define STR_HART_AND_DEVICE_CONFIG                             "|en|HART Configuration"\
                                                               "|de|HART Konfiguration"

#define STR_ONLINE_DIAGNOSTIC                                  "|en|Online/Diagnostic"\
                                                               "|de|Online/Diagnose"

#define STR_PRIMARY_VALUE                                      "|en|Primary Value"\
                                                               "|de|Primre Messgre"

#define STR_SECONDAY_VALUE                                     "|en|Secondary Value"\
                                                               "|de|Sekundre Messgre"

#define STR_TERTIARY_VALUE                                     "|en|Tertiary Value"\
                                                               "|de|Tertire Messgre"

#define STR_QUATERNARY_VALUE                                   "|en|Quaternary Value"\
                                                               "|de|Quartre Messgre"

#define STR_DYNAMIC_VARIABLES_MAPPING                          "|en|Dynamic Variables Mapping"\
                                                               "|de|Dynamische Variablen Zuordnung"

#define STR_RESET_CONFIG_CHANGED                               "|en|Reset Bit: Configuration Changed"\
                                                               "|de|Lsche Bit: Konfigurationsnderung"

#define STR_RESET_MORE_STATUS                                  "|en|Reset Bit: More Status"\
                                                               "|de|Lsche Bit: Weiterer Status"

#define STR_REFRESH_DEVICE_STATUS                              "|en|Refresh Device Specific Status"\
                                                               "|de|Erneuere gertespezifischen Status"

// Stratos Meldungen berschriften
#define STR_ERROR_GENERAL                                      "|en|General"\
                                                               "|de|Allgemein"

#define STR_ERROR_LOCKBOOK                                     "|en|Logbook and Storage"\
                                                               "|de|Logbuch und Speicher"

#define STR_ERROR_CURRENT_LOOP                                 "|en|Current Loop"\
                                                               "|de|Stromschleife"

#define STR_ERROR_SENSOR_1_AND_2                               "|en|Sensor [I + II]"\
                                                               "|de|Sensor [I + II]"

#define STR_ERROR_SENSOR_2_AND_3                               "|en|Sensor [II + III]"\
                                                               "|de|Sensor [II + III]"

#define STR_ERROR_CHANNEL_MESSAGES                             "|en|General Sensor Messages"\
                                                               "|de|Allgemeine kanalorientierte Meldungen"

#define STR_ERROR_SENSOR_SPECIFIC_MESSAGES                     "|en|Sensor Specific Messages"\
                                                               "|de|Sensorspezifische Meldungen"

#define STR_CURRENT_LOOP_SCALING                               "|en|Current Loop - Scaling"\
                                                               "|de|Stromschleife - Skallierung"

#define STR_CURRENT_LOOP_ADDITIONAL_SETTINGS                   "|en|Current Loop - Additional Settings"\
                                                               "|de|Stromschleife - Weitere Einstellungen"

// Button Beschriftungen
#define STR_BT_DEVICE_INFORMATION                              "|en|Device Information"\
                                                               "|de|Gerte Informationen"

#define STR_BT_HART_IDENTIFICATION                             "|en|HART Identification"\
                                                               "|de|HART Identifikation"

#define STR_HART_INFORMATION                                   "|en|HART Information"\
                                                               "|de|HART Informationen"

#define STR_HART_PROTOCOL_SETTINGS                             "|en|HART Protocol Settings"\
                                                               "|de|HART Protokoll Einstellungen"

#define STR_BT_DEVICE_DESCRIPTION                              "|en|Device Description"\
                                                               "|de|Gerte Beschreibung"

#define STR_BT_DYNAMIC_VARIABLES                               "|en|Dynamic Variables"\
                                                               "|de|Dynamische Variablen"

#define STR_BT_DEVICE_VARIABLES                                "|en|Device Variables"\
                                                               "|de|Gerte Variablen"

#define STR_BT_SENSOR_CH_1_PH                                  "|en|Sensor 1 - pH"\
                                                               "|de|Sensor 1 - pH"

#define STR_BT_SENSOR_CH_1_OXY                                 "|en|Sensor 1 - Do"\
                                                               "|de|Sensor 1 - Oxy"

#define STR_BT_SENSOR_CH_1_COND                                "|en|Sensor 1 - Cond"\
                                                               "|de|Sensor 1 - Cond"

#define STR_BT_SENSOR_CH_1_DIAG                                "|en|Sensor 1 - Diagnostic"\
                                                               "|de|Sensor 1 - Diagnose"

#define STR_BT_SENSOR_CH_2_PH                                  "|en|Sensor 2 - pH"\
                                                               "|de|Sensor 2 - pH"

#define STR_BT_SENSOR_CH_2_OXY                                 "|en|Sensor 2 - Do"\
                                                               "|de|Sensor 2 - Oxy"

#define STR_BT_SENSOR_CH_2_COND                                "|en|Sensor 2 - Cond"\
                                                               "|de|Sensor 2 - Cond"

#define STR_BT_SENSOR_CH_2_DIAG                                "|en|Sensor 2 - Diagnostic"\
                                                               "|de|Sensor 2 - Diagnose"

#define STR_BT_SENSOR_CH_3_COND                                "|en|Sensor 3 - Cond"\
                                                               "|de|Sensor 3 - Cond"

#define STR_BT_SENSOR_CH_3_DIAG                                "|en|Sensor 3 - Diagnostic"\
                                                               "|de|Sensor 3 - Diagnose"

#define STR_BT_CALCULATION_1                                   "|en|Calculation Block 1"\
                                                               "|de|Verrechnungsblock 1"

#define STR_BT_CALCULATION_2                                   "|en|Calculation Block 2"\
                                                               "|de|Verrechnungsblock 2"

#define STR_BT_OTHER_DEVICE_VARIABLE                           "|en|Other Device Variables"\
                                                               "|de|Sonstige Gerte Variablen"

#define STR_SENSOR_TEMPERATURE                                 "|en|Sensor Temperature"\
                                                               "|de|Sensor Temperatur"

#define STR_PH_MEASURING                                       "|en|Measuring pH"\
                                                               "|de|pH - Messung"

#define STR_OXY_MEASURING                                      "|en|Measuring Do"\
                                                               "|de|Oxy - Messung"

#define STR_COND_MEASURING                                     "|en|Measuring Cond"\
                                                               "|de|Cond - Messung"

#define STR_CALIBRATION                                        "|en|Calibration"\
                                                               "|de|Kalibrierung"

#define STR_DIAGNOSTIC                                         "|en|Diagnostic"\
                                                               "|de|Diagnose"

#define STR_DIAGNOSTIC_COUNTER                                 "|en|Counter"\
                                                               "|de|Zhler"

#define STR_ISM                                                "|en|ISM"\
                                                               "|de|ISM"

#define STR_TEMPERATURE_DIFF                                   "|en|Temperature Difference"\
                                                               "|de|Temperatur Differnez"

#define STR_PH_DIFF                                            "|en|pH Difference"\
                                                               "|de|pH Differnez"

#define STR_OXY_DIFF                                           "|en|Do Difference"\
                                                               "|de|Oxy Differnez"

#define STR_COND_DIFF                                          "|en|Cond Difference"\
                                                               "|de|Cond Differenz"

#define STR_COND_OTHERS                                        "|en|Others Values Cond"\
                                                               "|de|Weitere Messgren Cond"

#define STR_BT_DIAGNOSTIC                                      "|en|Diagnostics Overview"\
                                                               "|de|Diagnose bersicht"

#define STR_HART_DEVICE_STATUS                                 "|en|HART Device Status"\
                                                               "|de|HART Gerte Status"

// Stratos Meldungen
#define STR_ERROR_009_FIRMWARE                                 "|en|Firmware Error (C/D/P/T 009)"\
                                                               "|de|Firmware-Fehler (C/D/P/T 009)"

#define STR_ERROR_202_SYSTEM_FAILURE                           "|en|System Failure (F202)"\
                                                               "|de|Systemausfall (F202)"

#define STR_ERROR_000_INTERNAL                                 "|en|Interal Error"\
                                                               "|de|Interner Fehler"

#define STR_ERROR_210_SELFTEST                                 "|en|Device Diagnostic: Selftest (F210)"\
                                                               "|de|Gertediagnose: Selbsttest (F210)"

#define STR_ERROR_230_FACTORY_DEFAULT                          "|en|Factory Default State (F230)"\
                                                               "|de|Zustand Werkseinstellung (F230)"

#define STR_ERROR_200_CONFIGURATION_DATA_LOSS                  "|en|Configuration Data Loss (F200)"\
                                                               "|de|Datenverlust Parametrierung (F200)"

#define STR_ERROR_203_INCONSISTENT_CONFIGURATION               "|en|Inconsistent Parameter Set (F203)"\
                                                               "|de|Parametrierung Inkonsistent (F203)"

#define STR_ERROR_212_CLOCK                                    "|en|Time/Date (F212)"\
                                                               "|de|Uhrzeit/Datum (F212)"

#define STR_ERROR_190_RECORDER_FULL                            "|en|Recoder full (F190)"\
                                                               "|de|Messwertrekorder voll"

#define STR_ERROR_215_STORAGE_FULL                             "|en|Storage full (F215)"\
                                                               "|de|Speicherkarte voll (F215)"

#define STR_ERROR_211_STORAGE                                  "|en|Error Storage (F211)"\
                                                               "|de|Speicherkartenfehler (F211)"

#define STR_ERROR_216_AUDIT_TRAIL_STORAGE                      "|en|Error Audit Trail Storage (F216)"\
                                                               "|de|Audit Trail Speicherfehler (F216)"

#define STR_ERROR_226_ENERGY                                   "|en|Energy (F226)"\
                                                               "|de|Hilfsenergie (F226)"

#define STR_ERROR_074_LOOP_1_PARAMETER                         "|en|Current Loop 1: Parameter (B074)"\
                                                               "|de|Stromausgang 1: Parameter (B074)"

#define STR_ERROR_079_LOOP_2_PARAMETER                         "|en|Current Loop 2: Parameter (B079)"\
                                                               "|de|Stromausgang 2: Parameter (B079)"

#define STR_ERROR_084_LOOP_3_PARAMETER                         "|en|Current Loop 3: Parameter (B084)"\
                                                               "|de|Stromausgang 3: Parameter (B084)"

#define STR_ERROR_089_LOOP_4_PARAMETER                         "|en|Current Loop 4: Parameter (B089)"\
                                                               "|de|Stromausgang 4: Parameter (B089)"

#define STR_ERROR_070_LOOP_1_SPAN                              "|en|Current Loop 1: Span (B070)"\
                                                               "|de|Stromausgang 1: Spanne (B070)"

#define STR_ERROR_075_LOOP_2_SPAN                              "|en|Current Loop 2: Span (B075)"\
                                                               "|de|Stromausgang 2: Spanne (B075)"

#define STR_ERROR_080_LOOP_3_SPAN                              "|en|Current Loop 3: Span (B080)"\
                                                               "|de|Stromausgang 3: Spanne (B080)"

#define STR_ERROR_085_LOOP_4_SPAN                              "|en|Current Loop 4: Span (B085)"\
                                                               "|de|Stromausgang 4: Spanne (B085)"

#define STR_ERROR_029_CH1_NO_SENSOR                            "|en|Sensor [I]: No Sensor Connected (F029/F031)"\
                                                               "|de|Sensor [I]: Kein Sensor/Modul angeschlossen (F029/F031)"

#define STR_ERROR_030_CH1_WRONG_SENSOR                         "|en|Sensor [I]: Wrong Sensor Connected (F030)"\
                                                               "|de|Sensor [I]: Falscher Sensor angeschlossen (F030)"

#define STR_ERROR_036_CH1_INVALID_SENSOR                       "|en|Sensor [I]: Invalid Sensor (F036)"\
                                                               "|de|Sensor [I]: Ungltiger Sensor (F036)"

#define STR_ERROR_121_CH1_ERROR_SENSOR                         "|en|Sensor [I]: Error Sensor (C/D/P/T 121)"\
                                                               "|de|Sensor [I]: Sensorfehler (C/D/P/T 121)"

#define STR_ERROR_050_CH1_MANUEL_RANGE                         "|en|Sensor [I]: Costumer Range (C/D/T 050)"\
                                                               "|de|Sensor [I]: Benutzerspanne (C/D/T 050)"

#define STR_ERROR_029_CH2_NO_SENSOR                            "|en|Sensor [II]: No Sensor Connected (F029/F031)"\
                                                               "|de|Sensor [II]: Kein Sensor/Modul angeschlossen (F029/F031)"

#define STR_ERROR_030_CH2_WRONG_SENSOR                         "|en|Sensor [II]: Wrong Sensor Connected (F030)"\
                                                               "|de|Sensor [II]: Falscher Sensor angeschlossen (F030)"

#define STR_ERROR_036_CH2_INVALID_SENSOR                       "|en|Sensor [II]: Invalid Sensor (F036)"\
                                                               "|de|Sensor [II]: Ungltiger Sensor (F036)"

#define STR_ERROR_121_CH2_ERROR_SENSOR                         "|en|Sensor [II]: Error Sensor (C/D/P/T 121)"\
                                                               "|de|Sensor [II]: Sensorfehler (C/D/P/T 121)"

#define STR_ERROR_050_CH2_MANUEL_RANGE                         "|en|Sensor [II]: Costumer Range (C/D/T 050)"\
                                                               "|de|Sensor [II]: Benutzerspanne (C/D/T 050)"

#define STR_ERROR_029_CH3_NO_SENSOR                            "|en|Sensor [III]: No Sensor Connected (F029/F031)"\
                                                               "|de|Sensor [III]: Kein Sensor/Modul angeschlossen (F029/F031)"

#define STR_ERROR_030_CH3_WRONG_SENSOR                         "|en|Sensor [III]: Wrong Sensor Connected (F030)"\
                                                               "|de|Sensor [III]: Falscher Sensor angeschlossen (F030)"

#define STR_ERROR_036_CH3_INVALID_SENSOR                       "|en|Sensor [III]: Invalid Sensor (F036)"\
                                                               "|de|Sensor [III]: Ungltiger Sensor (F036)"

#define STR_ERROR_121_CH3_ERROR_SENSOR                         "|en|Sensor [III]: Error Sensor (C/D/P/T 121)"\
                                                               "|de|Sensor [III]: Sensorfehler (C/D/P/T 121)"

#define STR_ERROR_050_CH3_MANUEL_RANGE                         "|en|Sensor [III]: Costumer Range (C/D/T 050)"\
                                                               "|de|Sensor [III]: Benutzerspanne (C/D/T 050)"

#define STR_ERROR_008_CH1_ADJUSTMENT_DATA                      "|en|Sensor [I]: Adjustment Data (C/D/F/P/T 008)"\
                                                               "|de|Sensor [I]: Abgleichdaten (C/D/F/P/T 008)"

#define STR_ERROR_240_CH1_CALIBRATION_MODE                     "|en|Sensor [I]: Calibration Mode Is Active (F240)"\
                                                               "|de|Sensor [I]: Kalibrierung ist aktiv (F240)"

#define STR_ERROR_122_CH1_CALIBRATION_DATA                     "|en|Sensor [I]: Calibration Data Error (C/D/P/T 122)"\
                                                               "|de|Sensor [I]: Sensor Kalibrierdatenfehler (C/D/P/T 122)"

#define STR_ERROR_123_CH1_JUSTAGE_REQUIRED                     "|en|Sensor [I]: Adjustment Required (C/D/P/T 123)"\
                                                               "|de|Sensor [I]: Justierung erforderlich (C/D/P/T 123)"

#define STR_ERROR_124_CH1_SENSOR_DATE                          "|en|Sensor [I]: Sensor Date (C/D/P/T 124)"\
                                                               "|de|Sensir [I]: Sensordatum (C/D/P/T 124)"

#define STR_ERROR_110_CH1_CIP_LIMIT                            "|en|Sensor [I]: CIP Counter (C/D/P/T 110)"\
                                                               "|de|Sensor [I]: CIP-Zhler (C/D/P/T 110)"

#define STR_ERROR_111_CH1_SIP_LIMIT                            "|en|Sensor [I]: SIP Counter (C/D/P/T 111)"\
                                                               "|de|Sensor [I]: SIP-Zhler (C/D/P/T 111)"

#define STR_ERROR_112_CH1_AUTOCLAVE_LIMIT                      "|en|Sensor [I]: Autoclave Counter (D/P/T 112)"\
                                                               "|de|Sensor [I]: Autoklavier-Zhler (D/P/T 112)"

#define STR_ERROR_073_CH1_TTM                                  "|en|Sensor [I]: Time To Maintenance (P073)"\
                                                               "|de|Sensor [I]: Zeit zut Wartung (P073)"

#define STR_ERROR_090_CH1_BUFFER_DISTANCE                      "|en|Sensor [I]: Error In Buffer Table (P090)"\
                                                               "|de|Sensor [I]: Puffertabelle fehlerhaft (P090)"

#define STR_ERROR_080_CH1_RANGE_SENSOR_CURRENT                 "|en|Sensor [I]: Range Sensor Current (D080)"\
                                                               "|de|Sensor [I]: Sensorstrom Messbereich (D080)"

#define STR_ERROR_081_CH1_O2_MEASURING                         "|en|Sensor [I]: O2 Measuring off (D081)"\
                                                               "|de|Sensor [I]: O2-Messung aus (D081)"

#define STR_ERROR_045_CH1_RANGE_CONDUCTANCE                    "|en|Sensor [I]: Range Conductance (C045)"\
                                                               "|de|Sensor [I]: Leitwert Messbereich (C045)"

#define STR_ERROR_008_CH2_ADJUSTMENT_DATA                      "|en|Sensor [II]: Adjustment Data (C/D/F/P/T 008)"\
                                                               "|de|Sensor [II]: Abgleichdaten (C/D/F/P/T 008)"

#define STR_ERROR_240_CH2_CALIBRATION_MODE                     "|en|Sensor [II]: Calibration Mode Is Active (F240)"\
                                                               "|de|Sensor [II]: Kalibrierung aktiv (F240)"

#define STR_ERROR_122_CH2_CALIBRATION_DATA                     "|en|Sensor [II]: Calibration Data Error (C/D/P/T 122)"\
                                                               "|de|Sensor [II]: Sensor Kalibrierdatenfehler (C/D/P/T 122)"

#define STR_ERROR_123_CH2_JUSTAGE_REQUIRED                     "|en|Sensor [II]: Adjustment Required (C/D/P/T 123)"\
                                                               "|de|Sensor [II]: Justierung erforderlich (C/D/P/T 123)"

#define STR_ERROR_124_CH2_SENSOR_DATE                          "|en|Sensor [II]: Sensor Date (C/D/P/T 124)"\
                                                               "|de|Sensir [II]: Sensordatum (C/D/P/T 124)"

#define STR_ERROR_110_CH2_CIP_LIMIT                            "|en|Sensor [II]: CIP Counter (C/D/P/T 110)"\
                                                               "|de|Sensor [II]: CIP-Zhler (C/D/P/T 110)"

#define STR_ERROR_111_CH2_SIP_LIMIT                            "|en|Sensor [II]: SIP Counter (C/D/P/T 111)"\
                                                               "|de|Sensor [II]: SIP-Zhler (C/D/P/T 111)"

#define STR_ERROR_112_CH2_AUTOCLAVE_LIMIT                      "|en|Sensor [II]: Autoclave Counter (D/P/T 112)"\
                                                               "|de|Sensor [II]: Autoklavier-Zhler (D/P/T 112)"

#define STR_ERROR_073_CH2_TTM                                  "|en|Sensor [II]: Time To Maintenance (P073)"\
                                                               "|de|Sensor [II]: Zeit zut Wartung (P073)"

#define STR_ERROR_090_CH2_BUFFER_DISTANCE                      "|en|Sensor [II]: Error In Buffer Table (P090)"\
                                                               "|de|Sensor [II]: Puffertabelle fehlerhaft (P090)"

#define STR_ERROR_080_CH2_RANGE_SENSOR_CURRENT                 "|en|Sensor [II]: Range Sensor Current (D080)"\
                                                               "|de|Sensor [II]: Sensorstrom Messbereich (D080)"

#define STR_ERROR_081_CH2_O2_MEASURING                         "|en|Sensor [II]: O2 Measuring off (D081)"\
                                                               "|de|Sensor [II]: O2-Messung aus (D081)"

#define STR_ERROR_045_CH2_RANGE_CONDUCTANCE                    "|en|Sensor [II]: Range Conductance (C045)"\
                                                               "|de|Sensor [II]: Leitwert Messbereich (C045)"

#define STR_ERROR_008_CH3_ADJUSTMENT_DATA                      "|en|Sensor [III]: Adjustment Data (C/D/F/P/T 008)"\
                                                               "|de|Sensor [III]: Abgleichdaten (C/D/F/P/T 008)"

#define STR_ERROR_240_CH3_CALIBRATION_MODE                     "|en|Sensor [III]: Calibration Mode Is Active (F240)"\
                                                               "|de|Sensor [III]: Kalibrierung aktiv (F240)"

#define STR_ERROR_122_CH3_CALIBRATION_DATA                     "|en|Sensor [III]: Calibration Data Error (C/D/P/T 122)"\
                                                               "|de|Sensor [III]: Sensor Kalibrierdatenfehler (C/D/P/T 122)"

#define STR_ERROR_123_CH3_JUSTAGE_REQUIRED                     "|en|Sensor [III]: Adjustment Required (C/D/P/T 123)"\
                                                               "|de|Sensor [III]: Justierung erforderlich (C/D/P/T 123)"

#define STR_ERROR_124_CH3_SENSOR_DATE                          "|en|Sensor [III]: Sensor Date (C/D/P/T 124)"\
                                                               "|de|Sensir [III]: Sensordatum (C/D/P/T 124)"

#define STR_ERROR_110_CH3_CIP_LIMIT                            "|en|Sensor [III]: CIP Counter (C/D/P/T 110)"\
                                                               "|de|Sensor [III]: CIP-Zhler (C/D/P/T 110)"

#define STR_ERROR_111_CH3_SIP_LIMIT                            "|en|Sensor [III]: SIP Counter (C/D/P/T 111)"\
                                                               "|de|Sensor [III]: SIP-Zhler (C/D/P/T 111)"

#define STR_ERROR_112_CH3_AUTOCLAVE_LIMIT                      "|en|Sensor [III]: Autoclave Counter (D/P/T 112)"\
                                                               "|de|Sensor [III]: Autoklavier-Zhler (D/P/T 112)"

#define STR_ERROR_073_CH3_TTM                                  "|en|Sensor [III]: Time To Maintenance (P073)"\
                                                               "|de|Sensor [III]: Zeit zut Wartung (P073)"

#define STR_ERROR_090_CH3_BUFFER_DISTANCE                      "|en|Sensor [III]: Error In Buffer Table (P090)"\
                                                               "|de|Sensor [III]: Puffertabelle fehlerhaft (P090)"

#define STR_ERROR_080_CH3_RANGE_SENSOR_CURRENT                 "|en|Sensor [III]: Range Sensor Current (D080)"\
                                                               "|de|Sensor [III]: Sensorstrom Messbereich (D080)"

#define STR_ERROR_081_CH3_O2_MEASURING                         "|en|Sensor [III]: O2 Measuring off (D081)"\
                                                               "|de|Sensor [III]: O2-Messung aus (D081)"

#define STR_ERROR_045_CH3_RANGE_CONDUCTANCE                    "|en|Sensor [III]: Range Conductance (C045)"\
                                                               "|de|Sensor [III]: Leitwert Messbereich (C045)"



/*----------------------------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------------------------
  Device Revision 2
  ----------------------------------------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------*/


#define STR_SENSOR_SELECTOR_REQ                                 "|en|Select Sensor"\
                                                                "|de|Sensorauswahl"

#define STR_SENSOR_SELECTOR_RES                                 "|en|Selected Sensor"\
                                                                "|de|Ausgewhlter Sensor"

#define STR_SENSOR_SELECTOR_HELP                                "|en|Sensor Identifcaion Data for Selected Information"\
                                                                "|de|Sensor Identifikation fr die ausgewhlte Information"

#define STR_SELECT_SENSOR_1                                     "|en|Sensor 1"\
                                                                "|de|Sensor 1"

#define STR_SELECT_SENSOR_2                                     "|en|Sensor 2"\
                                                                "|de|Sensor 2"

#define STR_SELECT_SENSOR_3                                     "|en|Sensor 3"\
                                                                "|de|Sensor 3"

#define STR_INFO_SELECTOR_REQ                                   "|en|Select Sensor Information"\
                                                                "|de|Auswahl Sensor Information"

#define STR_INFO_SELECTOR_RES                                   "|en|Selected Sensor Information"\
                                                                "|de|Ausgewhlte Sensor Information"

#define STR_INFO_SELECTOR_HELP                                  "|en|Information of Selected Sensor"\
                                                                "|de|Information des ausgewhlten Sensors zur Identifikation"

#define STR_SELECT_INFO_MANUFACTURER                            "|en|Manufacturer"\
                                                                "|de|Hersteller"

#define STR_SELECT_ORDER_CODE                                   "|en|Order Code"\
                                                                "|de|Bestellnummer"

#define STR_SELECT_SERIAL_NUMBER                                "|en|Serial Number"\
                                                                "|de|Seriennummer"


#define STR_SENSOR_CONNECTION_STATE                             "|en|Connection State"\
                                                                "|de|Verbindungszustand"

#define STR_SENSOR_CONNECTION_STATE_HELP                        "|en|Connection State"\
                                                                "|de|Verbindungszustand"

#define STR_SENSOR_CONNECTION_STATE_UNKNOWN                     "|en|Unknown"\
                                                                "|de|Unbekannt"

#define STR_SENSOR_CONNECTION_STATE_CONNECTED                   "|en|Connected"\
                                                                "|de|Verbunden"

#define STR_SENSOR_CONNECTION_STATE_DISCONNECTED                "|en|Disconnected"\
                                                                "|de|Getrennt"

#define STR_SENSOR_IDENTIFICATION_ERROR                         "|en|Identification Error"\
                                                                "|de|Identifikationsfehler"

#define STR_SENSOR_IDENTIFICATION_ERROR_HELP                    "|en|Identification Error"\
                                                                "|de|Identifikationsfehler"

#define STR_SENSOR_IDENT_ERROR_NONE                             "|en|None"\
                                                                "|de|Keiner"

#define STR_SENSOR_IDENT_ERROR_LAST_CONNECTED_SENSOR            "|en|Last Connected Sensor Information"\
                                                                "|de|Informationen des letzten angeschlossenen Sensors"

#define STR_SENSOR_IDENT_ERROR_SENSOR_IDENT_NOT_AVAILIBLE       "|en|Identification not Availible"\
                                                                "|de|Identifikation nicht verfgbar"

#define STR_SENSOR_IDENT_ERROR_NONE_SENSOR_CONFIGURED           "|en|Sensor not Configured/Availible"\
                                                                "|de|Sensor ist nicht konfiguriert/verfbar"

#define STR_SENSOR_IDENT_ERROR_TAN_OPTION                       "|en|Error TAN Option"\
                                                                "|de|Fehler TAN Option"

#define STR_SENSOR_IDENT_ERROR_SENSOR_INFORMATION               "|en|Error: Sensor Information"\
                                                                "|de|Fehler: Sensor Information"

#define STR_SENSOR_IDENT_ERROR_MAX_LENGTH_INFORMATION           "|en|Identification: Max. Length (Character)"\
                                                                "|de|Identifikation: Max. Lnge (Zeichen)"

#define STR_SENSOR_IDENT_ERROR_UNKNOWN_CONNECTION_STATE         "|en|Unknown Sensor Connection State"\
                                                                "|de|Unbekannter Sensor Verbindungszustand"

#define STR_SENSOR_IDENTIFICATION_DATA                          "|en|Requested Identification Data"\
                                                                "|de|Angeforderte Identifikationsdaten"

#define STR_SENSOR_IDENTIFICATION_DATA_HELP                     "|en|Requested Identification Data"\
                                                                "|de|Angeforderte Identifikationsdaten"

#define STR_HART_SENSOR_IDENTIFICATION                          "|en|Sensor Identification"\
                                                                "|de|Sensor Identifikation"

#define STR_HART_REQ_SENSOR_IDENT                               "|en|Sensor Identification"\
                                                                "|de|Sensor Identifikation"

#define STR_HART_READ_SENSOR_IDENTIFICATION                     "|en|Read: Sensor Identification"\
                                                                "|de|Lese: Sensor Identifikation"





/***************************/

