/*
Filename:        .DDL
Function:        Device Description for .......
Device:          Stratos Pro CondI 2-wire
Device Revision: 2
DD Revision:     1
Last edit:
Manufacturer:		KNICK GmbH & Co.,
								Beuckestr.22,
								D-14163 Berlin
								Tel: +49 (0) 30-80191-0,
								Fax: +49 (0) 30-80191-200
								Internet: http://www.knick.de
								email: knick@knick.de
Copyright:			(C) Knick GmbH & Co., 2011 All Rights Reserved.
*/

MANUFACTURER KNICK, DEVICE_TYPE 0x00E4, DEVICE_REVISION 3, DD_REVISION 1


/*
---------------------------------------------------------------
Note:
max. string length for label or text is 18 character for HC375
max. string for BIT_ENUMERATED is 16 character for HC375

use Tabsize 2
for HC375 delete #define AMS

---------------------------------------------------------------

*/
// #define AMS  // define for AMS

/*-------------------Select one system  ----------------*/

/*-----------------------------------------------------------*/


/* old version is macros.ddl */
#include "macros.h"
#include "methods.h"

#include "SI_MainMenu.inc"
//#include "SIHA.inc"
//#include "SIHASTIdent02.inc"
#include "Diagnosis.inc"
//#include "SIHASTDiag_02.inc"
//#include "si__global_02.ddl"


#include "HA_DEF.h"
#include "HA_DCT.h"
	
	#include "HA_LOG.dd"
	#include "HA_MENU.dd"
	#include "HA_COMMON.dd"
	#include "HA_DEVVAR.dd"
	#include "HA_GRAPH.dd"
		#include "HA_COND.dd"

/*------------------------------------------------------------------------------------*/

/*  	import standard tables					*/

IMPORT STANDARD _TABLES, DEVICE_REVISION 20, DD_REVISION 4
{
    VARIABLE device_status;
    VARIABLE units_code;
    VARIABLE transfer_function_code;
    //VARIABLE material_code;
    VARIABLE alarm_selection_code;
    VARIABLE write_protect_code;
    //VARIABLE company_identification_code;
    //VARIABLE burst_mode_control_code;
    VARIABLE physical_signaling_codes;
    VARIABLE flag_assignment;
    VARIABLE operating_mode_code;
    //VARIABLE analog_output_numbers_code;
    VARIABLE loop_current_mode_codes;
    VARIABLE extended_device_status_codes;
    VARIABLE lock_device_codes;
    VARIABLE write_device_variable_codes;
    VARIABLE device_variable_family_codes;
    VARIABLE device_variable_classification_codes;
    //VARIABLE trim_point_codes;
    //VARIABLE capture_mode_codes;
    VARIABLE physical_layer_type_codes;
    VARIABLE lock_device_status_codes;
    VARIABLE analog_channel_flags;
    VARIABLE process_data_status;
    VARIABLE limit_status;
    VARIABLE device_family_status;
    VARIABLE manufacturer_id;
    VARIABLE private_label_distributor;
    VARIABLE device_type;
    VARIABLE write_protect;
    VARIABLE physical_signaling_code;
    VARIABLE operatingMode;
    VARIABLE extended_fld_device_status;
    VARIABLE loop_current_mode;
    VARIABLE device_flags;
    VARIABLE analog_channel_saturated1;
    VARIABLE analog_channel_fixed1;
    VARIABLE analog_channel_saturated_codes;
    VARIABLE analog_channel_fixed_codes;
    VARIABLE lock_device_status_code;
		REDEFINITIONS
		{
			VARIABLE device_status
			{
				REDEFINE LABEL str_field_device_status;
				REDEFINE HELP str_field_device_status_help;
			REDEFINE TYPE BIT_ENUMERATED {
				{ 0x01, [PV_out_of_limits],						DV1 (AUTO & BAD) },
				{ 0x02, [Non_PV_out_of_limits],				DV2 (AUTO & BAD) },
				{ 0x04, [PV_analog_output_saturated],	AO1 (AUTO & BAD) },
				{ 0x08, [PV_analog_output_fixed],			AO1 (MANUAL & GOOD) },
					{ 0x10, str_more_status_available,		MORE },
				{ 0x20, [cold_start],									MISC },
				{ 0x40, [configuration_changed],			MISC & IGNORE_IN_HANDHELD },
				{ 0x80, [device_malfunction],					MORE }
			}
				REDEFINE STYLE "MULTILINE 30 8" ;
			}
				VARIABLE analog_channel_saturated1 {
		 REDEFINE LABEL str_analog_channel_saturated;
		 REDEFINE TYPE  BIT_ENUMERATED {
			{ 0x01, str_AnaChSat_0, MISC }
			IF(DevConf_NumberCurrentOutput==TWO_OUTPUT)
			{ {0x02, str_AnaChSat_1, MISC }}}
			REDEFINE STYLE "MULTILINE 16 2";
		 
		 }

		VARIABLE analog_channel_fixed1 {
			REDEFINE LABEL str_analog_output_fixed;
			REDEFINE HELP str_analog_output_fixed_help;
		 REDEFINE TYPE  BIT_ENUMERATED{
			{ 0x01, str_AnaChFix_0, MISC}
			IF(DevConf_NumberCurrentOutput==TWO_OUTPUT)
			{ {0x02, str_AnaChFix_1, MISC}}}
		REDEFINE STYLE "MULTILINE 16 2" ;
			}
		/*	redefine for every device			*/
		/*
		* The entire variable must be redefined since Device Type is defined as a two-byte 
		* Enumerated and the Tokenizer will not allow the type to be redefined from size 2 to 1.
		*/
		REDEFINE VARIABLE device_type
		{
			LABEL [device_type];
			HELP [manufacturers_device_type_help];
			CLASS HART;
			HANDLING READ;
			TYPE ENUMERATED
			{{
				0xe4
			,str_device_type_CONDI 
		}}}
			/*
			 * The entire variable must be redefined since Manufacturer ID is defined as a two-byte
			 * Enumerated and the Tokenizer will not allow the type to be redefined from size 2 to 1.
			 */
		REDEFINE VARIABLE manufacturer_id
		{
			LABEL [manufacturer_id];
			HELP [manufacturer_id_code_help];
			CLASS HART;
			HANDLING READ;
			TYPE ENUMERATED
			{
			{ 0x61,	[Knick] }
	 	 }
		}
		REDEFINE VARIABLE private_label_distributor
		{
			/*
			* The entire variable must be redefined since Private Label is defined as a two-byte
			* Enumerated and the Tokenizer will not allow the type to be redefined from size 2 to 1.
			*/
				LABEL [private_label_distributor];
				HELP [private_label_distributor_help];
				CLASS DEVICE;
				HANDLING READ;
				TYPE ENUMERATED
				{
			{ 0x61,	[Knick] }
			}
		}
		VARIABLE extended_device_status_codes
		{  REDEFINE TYPE ENUMERATED
			{
        { 0x01, str_maintenance_required },
        { 0x02, str_device_variable_alert},
		{ 0x04, str_critical_power_failure}
			}
		}
		VARIABLE loop_current_mode_codes
		{  REDEFINE TYPE ENUMERATED
			{
        { 0, str_disabled_loop_current_mode },
        { 1, str_enabled_loop_current_mode }
			}
		}
		VARIABLE extended_fld_device_status
		{ REDEFINE LABEL str_extended_field_device_status;
			REDEFINE HELP  str_extended_field_device_status_help;
			REDEFINE STYLE "MULTILINE 16 3" ;
		}
		VARIABLE loop_current_mode
		{ REDEFINE LABEL str_loop_current_mode;
			REDEFINE HELP  str_loop_current_mode_help;}
		VARIABLE physical_signaling_code
		{	REDEFINE LABEL str_physical_signalling_code;}
		VARIABLE lock_device_status_code{
			REDEFINE LABEL	str_lock_device_status_code;
			REDEFINE HELP		str_lock_device_status_code_help;
			REDEFINE TYPE BIT_ENUMERATED
			{
				{ 0x01, str_device_is_locked },
				{ 0x02, str_lock_is_permanent },
				{ 0x04, str_locked_by_primary_master },
				{ 0x08, str_Config_not_changed},
				{ 0x10, str_locked_by_gateway}
			}
			REDEFINE STYLE "MULTILINE 16 5" ;
		}
	}// REDEFINITIONS
}//IMPORT STANDARD _TABLES

/*	importing standard universal commands			*/
IMPORT STANDARD _UNIVERSAL, DEVICE_REVISION 6, DD_REVISION 2
{
	EVERYTHING ;
	REDEFINITIONS{
			VARIABLE tag
			{	REDEFINE LABEL 	str_tag;
				REDEFINE HELP 	str_tag_help;}
			VARIABLE longTag
			{	REDEFINE LABEL 	str_long_tag;
				REDEFINE HELP 	str_long_tag_help;}
			VARIABLE config_change_counter
			{ REDEFINE LABEL str_configuration_change_counter;
				REDEFINE HELP 	str_configuration_change_counter_help;}
			VARIABLE max_num_device_variables
			{	REDEFINE LABEL str_maximum_number_of_device_variables;
				REDEFINE HELP str_maximum_number_of_device_variables_help;}
			VARIABLE request_preambles
			{	REDEFINE LABEL str_number_of_request_preambles;}
			VARIABLE universal_revision
			{	REDEFINE LABEL str_universal_revision;}
			VARIABLE transmitter_revision
			{	REDEFINE LABEL str_transmitter_revision;}
			VARIABLE software_revision
			{	REDEFINE LABEL str_software_revision;}
			VARIABLE hardware_revision
			{	REDEFINE LABEL str_hardware_revision;}
			VARIABLE device_id
			{	REDEFINE LABEL str_device_identification;}
			VARIABLE polling_address
			{	REDEFINE LABEL str_polling_address;}
			VARIABLE final_assembly_number
			{	REDEFINE LABEL str_final_assembly_number;}
			VARIABLE response_preambles
			{	REDEFINE LABEL str_number_of_response_preambles;}
		VARIABLE response_preambles
		{	REDEFINE HANDLING READ & WRITE;}
		
		/*	redefinition of command #1				*/
		COMMAND read_pv
		{
			REDEFINE TRANSACTION
			{
				REQUEST {}
				REPLY
				{
					response_code, device_status,
					PV.OUT_UNIT,
					PV.VALUE
				}
			}
		}// COMMAND read_pv
    
		/*	redefinition of command #2				*/
		COMMAND read_pv_current_and_percent_range
		{
			REDEFINE TRANSACTION
			{
					REQUEST {}
					REPLY
					{
							response_code, device_status,
							PV.ANALOG_VALUE,
							PV.PERCENT_RANGE
					}
			}
		}//COMMAND read_pv_current_and_percent_range
				
		/*	redefinition of command #3				*/
        COMMAND read_dynamic_variables_and_pv_current
        {
            REDEFINE TRANSACTION {
                REQUEST {}
                REPLY {
                    response_code, device_status,
                    PV.ANALOG_VALUE,
                    PV.OUT_UNIT,
                    PV.VALUE,
                    SV.OUT_UNIT,
                    SV.VALUE,
                    TV.OUT_UNIT,
                    TV.VALUE,
                    QV.OUT_UNIT,
                    QV.VALUE
                 }
            }
        }    //COMMAND read_dynamic_variables_and_pv_current

        /* redefine of command #8				*/
        COMMAND read_dynamic_variable_classification
        {
            REDEFINE TRANSACTION
            {
                REQUEST {}
                REPLY
                {
                    response_code, device_status,
                    PV.CLASSIFICATION,
                    SV.CLASSIFICATION,
                    TV.CLASSIFICATION,
                    QV.CLASSIFICATION
                }
            }
        }    //COMMAND read_dynamic_variable_classification


	
		DELETE COMMAND read_device_variables_and_status /*COMMAND 9*/;
		/*	redefinition of command #14	*/
		COMMAND read_pv_sensor_info
		{
			REDEFINE TRANSACTION
			{
				REQUEST {}
				REPLY
				{
					response_code, device_status,
					Arr_Sensor[FIRST_CHANNEL].SENSOR_SERIAL_NUMBER,
					Arr_Sensor[FIRST_CHANNEL].DIGITAL_UNITS,
					Arr_Sensor[FIRST_CHANNEL].UPPER_SENSOR_LIMIT,
					Arr_Sensor[FIRST_CHANNEL].LOWER_SENSOR_LIMIT,
					Arr_Sensor[FIRST_CHANNEL].MINIMUM_SPAN
				}
			}
		}// redefinition of command #14	*/

		/*	redefinition of command #15	*/
		COMMAND read_pv_output_info
		{
			REDEFINE TRANSACTION
			{
				REQUEST {}
				REPLY
				{
					response_code, device_status,
					PV.ALARM_CODE,
					PV.TRANSFER_FUNCTION,
					arrParaVal_AB[ActParaSetVal].OUT1_UNIT,
					PV.UPPER_RANGE_VALUE, //arrParaVal_AB[ActParaSetVal].OUT1_END,
					PV.LOWER_RANGE_VALUE, //arrParaVal_AB[ActParaSetVal].OUT1_BEGIN,
					arrParaVal_AB[ActParaSetVal].OUT1_FILTERTIME,
					write_protect,
					private_label_distributor,
					PV.ANALOG_CHANNEL_FLAGS
				}
			}
		}// redefinition of command #15	*/
	}  /* end of REDEFINITIONS */
} // IMPORT STANDARD _UNIVERSAL
/*	END  importing standard universal commands			*/



/*------------------------------------------------------------------------------------*/
/*	transmitter status variables (command #48)					*/
VARIABLE dummy_status
{	LABEL		"dummy" ;
	HELP		" " ;
	HANDLING READ ;
	TYPE		BIT_ENUMERATED {
     /* HC375:"1234567890123456789" */
		{ 0x01, " ", MISC & IGNORE_IN_HANDHELD } ,
		{ 0x02, " ", MISC & IGNORE_IN_HANDHELD } ,
		{ 0x04, " ", MISC & IGNORE_IN_HANDHELD } ,
		{ 0x08, " ", MISC & IGNORE_IN_HANDHELD } ,
		{ 0x10, " ", MISC & IGNORE_IN_HANDHELD } ,
		{ 0x20, " ", MISC & IGNORE_IN_HANDHELD } ,
		{ 0x40, " ", MISC & IGNORE_IN_HANDHELD } ,
		{ 0x80, " ", MISC & IGNORE_IN_HANDHELD }
	}
}
/*
VARIABLE function_check_status {
	CLASS    DEVICE & DYNAMIC;
	LABEL		"Device Status" ;
	HELP		"Device status and mode" ;
	HANDLING READ ;
	TYPE		BIT_ENUMERATED {
     // HC375:"1234567890123456789"
		{ 0x01, "Configuration", MODE & IGNORE_IN_HANDHELD } ,
		{ 0x02, "Calibration", MODE & IGNORE_IN_HANDHELD } ,
		{ 0x04, "Sample was taken", MISC & IGNORE_IN_HANDHELD }
	}
}
*/
// CMD 48 Byte 0
VARIABLE device_specific_status_error_number
{
	LABEL		str_error_number;
	HELP		str_error_number_help;
	CLASS	DEVICE & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED
	{
		{0,str_MsgID_No_Failure},
		{1,str_error_1},
		{2,str_error_2},
		{3,str_error_3},
		{4,str_error_4},
		{5,str_error_5},
		{6,"6"},
		{7,"7"},
		{8,"8"},
		{9,"9"},
		{10,str_error_10},
		{11,str_error_11},
		{12,"12"},
		{13,"13"},
		{14,"14"},
		{15,str_error_15},
		{16,"16"},
		{17,"17"},
		{18,"18"},
		{19,"19"},
		{20,"20"},
		{21,"21"},
		{22,"22"},
		{23,"23"},
		{24,"24"},
		{25,"25"},
		{26,"26"},
		{27,"27"},
		{28,"28"},
		{29,"29"},
		{30,"30"},
		{31,str_error_31},
		{32,str_error_32},
		{33,str_error_33},
		{34,str_error_34},
		{35,str_error_35},
		{36,"36"},
		{37,"37"},
		{38,"38"},
		{39,"39"},
		{40,"40"},
		{41,"41"},
		{42,"42"},
		{43,str_error_43},
		{44,"44"},
		{45,"45"},
		{46,"46"},
		{47,"47"},
		{48,"48"},
		{49,"49"},
		{50,"50"},
		{51,"51"},
		{52,"52"},
		{53,"53"},
		{54,"54"},
		{55,"55"},
		{56,"56"},
		{57,"57"},
		{58,"58"},
		{59,"59"},
		{60,str_error_60},
		{61,str_error_61},
		{62,str_error_62},
		{63,str_error_63},
		{64,str_error_64},
		{65,"65"},
		{66,"66"},
		{67,"67"},
		{68,"68"},
		{69,"69"},
		{70,str_error_70},
		{71,str_error_71},
		{72,str_error_72},
		{73,str_error_73},
		{74,"74"},
		{75,"75"},
		{76,"76"},
		{77,"77"},
		{78,"78"},
		{79,"79"},
		{80,"80"},
		{81,"81"},
		{82,"82"},
		{83,"83"},
		{84,"84"},
		{85,"85"},
		{86,"86"},
		{87,"87"},
		{88,"88"},
		{89,"89"},
		{90,"90"},
		{91,"91"},
		{92,"92"},
		{93,"93"},
		{94,"94"},
		{95,str_error_95},
		{96,str_error_96},
		{97,str_error_97},
		{98,str_error_98},
		{99,str_error_99},
		{100,str_error_100},
		{101,str_error_101},
		{102,"102"},
		{103,"103"},
		{104,str_error_104},
		{105,str_error_105},
		{106,str_error_106},
		{107,str_error_107},
		{108,str_error_108},
		{109,str_error_109},
		{110,"110"},
		{111,"111"},
		{112,"112"},
		{113,"113"},
		{114,"114"},
		{115,"115"},
		{116,"116"},
		{117,"117"},
		{118,"118"},
		{119,"119"},
		{120,"120"}
	}
	DEFAULT_VALUE 0;
}

// CMD 48 Byte 2
VARIABLE device_specific_menu_mode
{
	LABEL			str_DeviceMenuMode_Label;
	HELP			str_DeviceMenuMode_Help;
	HANDLING	READ;
	TYPE  		ENUMERATED {
		{ MENU_MODE_MEAS, str_Meas},
		{ MENU_MODE_DIAG, str_Diag},
		{ MENU_MODE_CAL, 	str_CAL},
		{ MENU_MODE_CONF, str_Conf},
		{ MENU_MODE_Serv, str_Service}
	}
}
// CMD 48 Byte 3
VARIABLE device_specific_status_sensoface
{
	LABEL			str_device_specific_status_sensoface;
	HELP			str_device_specific_status_sensoface_help;
	CLASS			DEVICE & DIAGNOSTIC & DYNAMIC;
	HANDLING	READ;
	TYPE ENUMERATED
	{	DEF_ENUM_LIST_SENSOFACE	}
}

// CMD 48 Byte 5
VARIABLE device_specific_status_hold_mode
{
	LABEL			str_hold_mode;
	HELP			str_hold_mode_help;
	CLASS			DEVICE & DIAGNOSTIC & DYNAMIC;
	HANDLING	READ;
	TYPE ENUMERATED
	{
		{0,str_hold_mode_inactive},
		{1,str_hold_mode_active}
	}
}
// CMD 48 Byte 5
VARIABLE device_specific_status_prod_calib_sensor_1
{
	LABEL			str_prod_calib_sensor;
	HELP			str_prod_calib_sensor_help;
	CLASS			DEVICE & DIAGNOSTIC & DYNAMIC;
	HANDLING	READ;
	TYPE ENUMERATED
	{
		{0,str_prod_calib_inactive},
		{1,str_prod_calib_active}
	}
}
VARIABLE device_specific_status_prod_calib_sensor_2
{
	LABEL			str_prod_calib_sensor_2;
	HELP			str_prod_calib_sensor_2_help;
	CLASS			DEVICE & DIAGNOSTIC & DYNAMIC;
	HANDLING	READ;
	TYPE ENUMERATED
	{
		{0,str_prod_calib_inactive},
		{1,str_prod_calib_active}
	}
}
VARIABLE device_specific_status_scon_sensor_connec
{
	LABEL			str_scon_sensor_connec;
	HELP			str_scon_sensor_connec_help;
	CLASS			DEVICE & DYNAMIC;
	HANDLING	READ;
	TYPE ENUMERATED
	{
		{0,str_scon_senso_disconnected},
		{1,str_scon_senso_connected}
	}
}
VARIABLE device_specific_status_alarm
{
	LABEL			str_device_specific_alarm;
	HELP			str_device_specific_alarm_help;
	CLASS			DEVICE & DIAGNOSTIC & DYNAMIC;
	HANDLING	READ;
	TYPE ENUMERATED
	{
		{0,str_device_specific_alarm_inactive},
		{1,str_device_specific_alarm_active}
	}
}

/*		import standard common practice commands			*/
IMPORT STANDARD _COMMON_PRACTICE, DEVICE_REVISION 8, DD_REVISION 2
{
	VARIABLE device_variable_code;
  VARIABLE primary_variable_code;				// used for actual HART, paraset A PDM
  VARIABLE secondary_variable_code;			// used for actual HART, paraset A PDM
	VARIABLE tertiary_variable_code;			// used for actual HART, paraset A PDM
	VARIABLE quaternary_variable_code;		// used for actual HART, paraset A PDM

	VARIABLE analog_channel_number_code;							/* for Command  60	*/
	VARIABLE lock_device_code;												/* for Command  71	*/

	METHOD applied_rerange;


	METHOD lock_unlock_device;
	METHOD valve_loop_test;

	METHOD return_to_normal;
	METHOD warning_message;

	COMMAND read_device_variables; 														/* Command  33	*/
	COMMAND set_pv_upper_range_value;													/* Command  36	*/
	COMMAND set_pv_lower_range_value;													/* Command  37	*/
	COMMAND reset_configuration_change_flag;									/* Command  38	*/
	COMMAND perform_self_test;																/* Command  41	*/
	COMMAND read_additional_device_status;										/* Command  48	*/

	COMMAND read_device_variable_information;								/* Command  54	*/
	COMMAND write_number_of_response_preambles;								/* Command  59	*/
	COMMAND read_analog_output_and_percent_of_range;					/* Command  60	*/
	COMMAND read_analog_channel_information;									/* Command  63	*/
	COMMAND lock_device;																			/* Command  71	*/
	COMMAND squawk;																						/* Command  72	*/
	COMMAND read_lock_device_state;														/* Command  76	*/

	REDEFINITIONS {
		
		
		REDEFINE VARIABLE tertiary_variable_code
        {
            LABEL [tertiary_variable_is];
            HELP [tertiary_variable_code_is_help];
            CLASS HART;
            TYPE INDEX deviceVariables;
        }

        REDEFINE VARIABLE quaternary_variable_code
        {
            LABEL [quaternary_variable_is];
            HELP [quaternary_variable_code_is_help];
            CLASS HART;
            TYPE INDEX deviceVariables;
        }
		
METHOD lock_unlock_device
{
    REDEFINE LABEL str_lock_unlock_device;
    REDEFINE HELP  str_lock_unlock_device_help;
    REDEFINE DEFINITION 
    {  
        char status[STATUS_SIZE];
        //char disp_string1[60];
        //char disp_string2[60];
        //long var_id[1];
        //int use_abort_method;
        int choice;
        int result;
        int locked;
        int slen1;
        int slen2;

        slen1 = 60;
        slen2 = 60;

        IGNORE_ALL_DEVICE_STATUS();
        IGNORE_ALL_RESPONSE_CODES();
        XMTR_IGNORE_ALL_DEVICE_STATUS();
        XMTR_IGNORE_ALL_RESPONSE_CODES();

        /* 
         * Send command 76 to read the lock device state
         */
        send(76, status);

        if(status[STATUS_RESPONSE_CODE])
        {
            display_response_status(76, status[STATUS_RESPONSE_CODE]);
            DELAY(2, str_abort_last_error);
            process_abort();
        }

            locked = (ivar_value(lock_device_status_code) & 0x01);

            if (locked)
            {
                /*  locked = 1 */
								choice = SELECT_FROM_LIST(str_device_locked, str_yes_no);
            }
            else
            {
                /* locked = 0 */
								choice = SELECT_FROM_LIST(str_device_unlocked, str_yes_no);
            }

            

            if (choice == 0)      /* If yes, user wants to change the lock state */
            {
                if (locked == 0)    /* If it is not locked */
                {
                    /* Lock the device */

                    /* 
                     * Determine if user wants to lock the device, Temporarly or Permanently 
                     */
                    result = SELECT_FROM_LIST(str_make_permanent, str_yes_no);

                    if (result == 0)      /* If yes */
                    {
                        /* 
                         * Lock it Permanently
                         */
                        lassign (lock_device_code, 2);
                    }
                    else
                    {
                        /* 
                         * Lock it Temporarly
                         */
                        lassign (lock_device_code, 1);
                    }
                }
                else
                {
                    /* 
                     * Unlock the device
                     */
                    lassign (lock_device_code, 0);
                }

                /*
                 * Send command 71 to lock or Unlock the device
                 */
                send(71, status);
    
                if(status[STATUS_RESPONSE_CODE])
                {
                    display_response_status(71, status[STATUS_RESPONSE_CODE]);
                    DELAY(2, str_abort_last_error);
                    process_abort();
                }

                /* 
                 * Send command 76 to read the lock device state to update it as a result of
                 * sending command 71
                 */
                send(76, status); 

                if(status[STATUS_RESPONSE_CODE])
                {
                    display_response_status(76, status[STATUS_RESPONSE_CODE]);
                    DELAY(2, str_abort_last_error);
                    process_abort();
                }
            }
    }
}



		VARIABLE quaternary_variable_code
		{
			REDEFINE LABEL	str_quaternary_variable_is;
			REDEFINE HELP		str_quaternary_variable_code_is_help;
		}

		/*	redefinition of command #48				*/
		COMMAND read_additional_device_status{
			REDEFINE TRANSACTION {
				REQUEST {}
				REPLY {
					response_code,	device_status,
					device_specific_status_error_number,								/*	0	*/
					dummy_status, 																			/*	1	*/
					dummy_status                               <0xF8>,	/*	2	*/
					device_specific_menu_mode 								 <0x07>,	/*  2 */
					dummy_status	 														 <0xFC>,	/*	3	*/
					device_specific_status_sensoface	 				 <0x03>,	/*	3	*/
					ActParaSetVal ,																			/*  4	*/
					dummy_status															 <0xE0>,	/*	5	*/
					device_specific_status_alarm						   <0x10>,  /*	5	*/
					device_specific_status_scon_sensor_connec  <0x08>,	/*	5	*/
					device_specific_status_prod_calib_sensor_2 			<0x04>,  /*	5	*/
					device_specific_status_prod_calib_sensor_1 			<0x02>,  /*	5	*/
					device_specific_status_hold_mode           			<0x01>,  /*	5	*/
					extended_fld_device_status ,												/*	6	*/
					0x00,																								/*	7	*/
					0x00,																								/*  8	*/
					0x00,																								/*  9	*/
					analog_channel_saturated1,													/* 10	*/
					0x00,																								/* 11	*/
					0x00,																								/* 12	*/
					analog_channel_fixed1,
					dummy_status,
					dummy_status
					}
				}
			}// COMMAND read_additional_device_status
			// redefinition of CMD 60
			COMMAND read_analog_output_and_percent_of_range
			{
				REDEFINE TRANSACTION
				{
					REQUEST
					{
							analog_channel_number_code (INFO,INDEX)
					}
					REPLY
					{
							response_code, device_status, analog_channel_number_code (INFO,INDEX),
							dynamic_variables[analog_channel_number_code].ANALOG_UNITS,
							dynamic_variables[analog_channel_number_code].ANALOG_VALUE,
							dynamic_variables[analog_channel_number_code].PERCENT_RANGE
					}
				}
			}
		COMMAND read_analog_channel_information
		{
    REDEFINE TRANSACTION
    {
        REQUEST
        {
            analog_channel_number_code (INFO,INDEX)
        }
        REPLY
        {
            response_code, device_status, analog_channel_number_code (INFO,INDEX),
            dynamic_variables[analog_channel_number_code].ALARM_CODE,  // PV. or SV.
            dynamic_variables[analog_channel_number_code].TRANSFER_FUNCTION,
            dynamic_variables[analog_channel_number_code].RANGE_UNITS,
            dynamic_variables[analog_channel_number_code].UPPER_RANGE_VALUE,
            dynamic_variables[analog_channel_number_code].LOWER_RANGE_VALUE,
            dynamic_variables[analog_channel_number_code].ANALOG_DAMPING,
            dynamic_variables[analog_channel_number_code].ANALOG_CHANNEL_FLAGS
        }
    }
	}
			
			
		METHOD valve_loop_test
		{
			REDEFINE    DEFINITION
			{
        char status[STATUS_SIZE];
        char disp_string1[77];
        char disp_string2[60];
        long var_id[1];
        int choice;
        int slen1;
        int slen2;
        float current;

        slen1 = 77;
        slen2 = 60;

        IGNORE_ALL_RESPONSE_CODES();
        IGNORE_ALL_DEVICE_STATUS();
        XMTR_IGNORE_ALL_DEVICE_STATUS();
        XMTR_IGNORE_ALL_RESPONSE_CODES();

        get_dictionary_string(remove_loop_from_auto, disp_string1, slen1);
        ACKNOWLEDGE(disp_string1);
        add_abort_method(return_to_normal);

					var_id[0] = VARID(PV.ANALOG_VALUE);

        /*
         * Here comes the standard part for analog inputs, e.g. valves
         */
        do
        {
            get_dictionary_string(choose_analog_input_level, disp_string1, slen1);
            get_dictionary_string(choices_4_20_other_end, disp_string2, slen2);

            choice = SELECT_FROM_LIST(disp_string1, disp_string2);

            switch (choice)
            {
            case 0:
                current = 4.0;
                get_dictionary_string(apply_current_input_to_value, disp_string1, slen1);
                break;

            case 1:
                current = 20.0;
                get_dictionary_string(apply_current_input_to_value, disp_string1, slen1);
                break;

            case 2:
                get_dictionary_string(apply_current_input_to_desired_value, disp_string1, slen1);
                break;

            case 3:
            default:
                process_abort();
                break;
            }

            send(2, status);     /*Test the device to see if all is ok */

            if ((status[STATUS_RESPONSE_CODE] != 0) && (status[STATUS_RESPONSE_CODE] != 8))
            {
                /*
                 * Only abort if the response code something value other
                 * than 0 (sucess) or 8 (warning)
                 */
                display_response_status(2, status[STATUS_RESPONSE_CODE]);
                get_dictionary_string(abort_last_error, disp_string1, slen1);
                DELAY(2, disp_string1);
                process_abort();
            }

            acknowledge(disp_string1, var_id); /* disp_string1 is defined in switch/case above */

        } while (choice < 3);

        process_abort();
    }
}
		METHOD applied_rerange
		{
    REDEFINE DEFINITION
    {
        char status[STATUS_SIZE];
        char disp_string1[60];
        char disp_string2[60];
        long varid[3];
        int choice;
        int slen1;
        int slen2;

        slen1 = 60;
        slen2 = 60;

        IGNORE_ALL_RESPONSE_CODES();
        IGNORE_ALL_DEVICE_STATUS();
        XMTR_IGNORE_ALL_RESPONSE_CODES();
        XMTR_IGNORE_ALL_DEVICE_STATUS();

        get_dictionary_string(remove_loop_from_auto, disp_string1, slen1);
        ACKNOWLEDGE(disp_string1);
        add_abort_method(return_to_normal);

					varid[0] = VARID(PV.VALUE);
					varid[1] = VARID(PV.OUT_UNIT);

        while (1)
        {
            get_dictionary_string(set_the, disp_string1, slen1);
            get_dictionary_string(choice_4_20_exit, disp_string2, slen2);

            switch (SELECT_FROM_LIST(disp_string1, disp_string2))
            {
                case 0:
                    get_dictionary_string(apply_new_4ma_input, disp_string1,slen1);
                    ACKNOWLEDGE(disp_string1);

                    do
                    {
                        send_command(1);

                        get_dictionary_string(current_applied_process_val, disp_string1, slen1);
                        get_dictionary_string(set_4ma_read_new_leave, disp_string2, slen2);

                        choice = select_from_list(disp_string1, varid, disp_string2);

                    } while (choice == 1);

                    if (choice == 0)
                    {
                        send(37, status);

                        if (status[STATUS_RESPONSE_CODE])
                        {
                            display_response_status(37, status[STATUS_RESPONSE_CODE]);
                        }

                        send_command(15);
                    }
                    break ;

                case 1:
                    get_dictionary_string(apply_new_20ma_input, disp_string1, slen1);
                    ACKNOWLEDGE(disp_string1);

                    do
                    {
                        send_command(1);

                        get_dictionary_string(current_applied_process_val, disp_string1, slen1);
                        get_dictionary_string(set_20ma_read_new_leave, disp_string2, slen2);

                        choice = select_from_list(disp_string1, varid,disp_string2);

                    } while (choice == 1);

                    if (choice == 0)
                    {
                        send(36,status);

                        if (status[STATUS_RESPONSE_CODE])
                        {
                            display_response_status(36, status[STATUS_RESPONSE_CODE]);
                        }

                        send_command(15);
                    }
                    break;

                case 2:
                    process_abort();

                default:
                    process_abort();
            }
        }
    }
}



	}  /* end of REDEFINITIONS */
}//IMPORT STANDARD _COMMON_PRACTICE

VARIABLE dummy_variable
{
    HANDLING READ;
    TYPE UNSIGNED_INTEGER;
}

/**********************************************************************************************/
/*                                                                                            */
/*               D E V I C E   V A R I A B L E S                                              */
/*                                                                                            */
/**********************************************************************************************/

/*
ARRAY OF COLLECTION deviceVariables
{
	ELEMENTS
	{
		DEVICE_VARIABLE_LIST_COND_CH1
	}
}*/

/*--------------------------------------------------------------------------------------*/
/*
 * Used by the HART Communicator for two things
 *
 * The first is a write order list. If there are 4 variables
 * in the queue to be written and sensor_units was the third
 * item placed in the queue it will be the first variable
 * written when the send key is press because it is the first variable
 * in this list. If the variables in the queue are not in this list
 * they will be taken in the order of their ID's.
 *
 * Second this is the list of variables that the user will be
 * allowed to view and modify under the offline configure.
 * Any variable not in this list will not appear to the user
 * in offline configure.
 */
/* Variablen die durch offline Konfigurierung im Ger?t ge?ndert werden k?nnen */
/* Reihenfolge wie in menu_rev_config und menu_device_info */

/* End */


MENU download_variables
{
	LABEL "Lesen vom Gert";
	ITEMS
	{
		tag,
		longTag,
		Device_Tag,
 		descriptor,
 		message,
		manufacturer_id,
		Serial_CH1_Device_Type,
		private_label_distributor,
 		device_type,
 		device_id,
		final_assembly_number,
 		universal_revision,
 		transmitter_revision,
 		software_revision,
 		hardware_revision,
 		date,
		DevConf_VariantEx,
		DevConf_NumberCurrentOutput,
		DevConf_I_Input,
		DevConf_LogBook,
		DevConf_ISM_Option,
		DevConf_AuditTrail,
		Serial_Serialnumber,
		Serial_HardwareVersion,
		Serial_SoftwareVersion,
		Serial_IF3000_SoftwareVersion,
		Serial_CH1_Serialnumber,
		Serial_CH1_HardwareVersion,
		Serial_CH1_SoftwareVersion,
		DEF_SENSOR_1_PARA,
		DEF_SENSOR_1_PARA_INFO,
		DEF_OUT_PARA,
		DEF_CORRECTION_PARA,
		DEF_CNTR_IN_PARA,
		DEF_ALARM_PARA,
/* Para Config*/
		PAR_Conf_Switch,
		DEF_CLOCK_PARA,
		physical_signaling_code,
    device_flags,
		max_num_device_variables,
		config_change_counter,
		extended_fld_device_status,
		polling_address,
		loop_current_mode,
		request_preambles,
		response_preambles,
		tertiary_variable_code,
        quaternary_variable_code
		}
		POST_READ_ACTIONS
    {
   		METHOD_post_read_download_variables
    }
}

MENU upload_variables
{
	LABEL "Upload Variables";
	ITEMS
	{
		tag,
		longTag,
		Device_Tag,
 		descriptor,
 		message,
		date,
		final_assembly_number,
		DEF_SENSOR_1_PARA,
		DEF_OUT_PARA,
		DEF_CORRECTION_PARA,
		DEF_CNTR_IN_PARA,
		DEF_ALARM_PARA,
	/* Para Config*/
		PAR_Conf_Switch,
		tertiary_variable_code,
        quaternary_variable_code

		}
		POST_WRITE_ACTIONS
		{
			METHOD_post_write_upload_variables
		}
}
METHOD METHOD_post_read_download_variables
{
	CLASS CORRECTION;
	DEFINITION
	{
		char status[STATUS_SIZE];
		DEF_COMMON_CMD_SETTING(3);
		SEND_CMD_AND_CHECK_STATUS(38);  /* CMD38 - reset_configuration_change_flag */
	}
}
METHOD METHOD_post_write_upload_variables
{
	CLASS CORRECTION;
	DEFINITION
	{
		char status[STATUS_SIZE];
		DEF_COMMON_CMD_SETTING(3);
		SEND_CMD_AND_CHECK_STATUS(38);  /* CMD38 - reset_configuration_change_flag */
	}
}
/*
 * Relationships
 */

UNIT DevVar1_Ch1_UnitsRelation
{
	device_var1_Ch1_Units:
  device_var1_Ch1_Value,
  device_var1_Ch1_USL,
  device_var1_Ch1_LSL,
  device_var1_Ch1_MinimumSpan
}

UNIT temp_Ch1_UnitRelation
{
  temp_device_var_Ch1_Units:
  temp_device_var_Ch1_Value,
  temp_device_var_Ch1_USL,
  temp_device_var_Ch1_LSL,
  temp_device_var_Ch1_MinimumSpan
}


/************************************************************************************************************/
/*                         SPECIAL MENUs																	*/
/************************************************************************************************************/



