/*
 --------------------------------------------------------------------------------------
 Datei:          import_fb.ddl
 Ersteller:      msh
 Datum           28.10.2013

 Inhalt:         EDD fr Stratos Bus PA
 Import aller Funktionsblcke, PB, TB
 --------------------------------------------------------------------------------------
 */
/*
 -----------------------------
 ####  ####
 #   # #   #
 ####  ####
 #     #   #
 #     ####

 Physical Block importieren
 -----------------------------
 */
#define DEXT_BIT_00           0x01000000     /* 0x00000001 */   /* |||||||| |||||||| |||||||| |||||||+-------- 0 :        reserviert (Check Function bei FF )     Good                                                */
#define DEXT_BIT_01           0x02000000     /* 0x00000002 */   /* |||||||| |||||||| |||||||| ||||||+--------- 1 :        Autoklavierzhler                       Good                                                */
#define DEXT_BIT_02           0x04000000     /* 0x00000004 */   /* |||||||| |||||||| |||||||| |||||+---------- 2 :        CIP Zyklen berschritten                Good                                                */
#define DEXT_BIT_03           0x08000000     /* 0x00000008 */   /* |||||||| |||||||| |||||||| ||||+----------- 3 :        SIP-Zyklen berschritten                Good                                                */
#define DEXT_BIT_04           0x10000000     /* 0x00000010 */   /* |||||||| |||||||| |||||||| |||+------------ 4 :        Parametrierfehler User Buffer           Good                                                */
#define DEXT_BIT_05           0x20000000     /* 0x00000020 */   /* |||||||| |||||||| |||||||| ||+------------- 5 :        reserviert                                                                                  */
#define DEXT_BIT_06           0x40000000     /* 0x00000040 */   /* |||||||| |||||||| |||||||| |+-------------- 6 :        reserviert                                                                                  */
#define DEXT_BIT_07           0x80000000     /* 0x00000080 */   /* |||||||| |||||||| |||||||| +--------------- 7 :        reserviert                                                                                  */
                                                                /*                                                                                                                                                    */
#define DEXT_BIT_08           0x00010000     /* 0x00000100 */   /* |||||||| |||||||| |||||||+----------------- 8 :        Sensorverschlei                        Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_09           0x00020000     /* 0x00000200 */   /* |||||||| |||||||| ||||||+------------------ 9 :        TTM                                     Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_10           0x00040000     /* 0x00000400 */   /* |||||||| |||||||| |||||+------------------- 10:        Kalibriertimer abgelaufen               Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_11           0x00080000     /* 0x00000800 */   /* |||||||| |||||||| ||||+-------------------- 11:        Sensor Einstellzeit                     Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_12           0x00100000     /* 0x00001000 */   /* |||||||| |||||||| |||+--------------------- 12:        Cal-Daten schlecht(Smiley)              Uncertain | Sensor_Conversion_Not_Accurate          */
#define DEXT_BIT_13           0x00200000     /* 0x00002000 */   /* |||||||| |||||||| ||+---------------------- 13:        Sensocheck                              Bad | Sensor_Failure                                */
#define DEXT_BIT_14           0x00400000     /* 0x00004000 */   /* |||||||| |||||||| |+----------------------- 14:        reserviert                                                                                  */
#define DEXT_BIT_15           0x00800000     /* 0x00008000 */   /* |||||||| |||||||| +------------------------ 15:        reserviert                                                                                  */
                                                                /*                                                                                                                                                    */
#define DEXT_BIT_16           0x00000100     /* 0x00010000 */   /* |||||||| |||||||+-------------------------- 16:        Temp. auerhalb Tabelle                 Bad | Sensor_Failure                                */
#define DEXT_BIT_17           0x00000200     /* 0x00020000 */   /* |||||||| ||||||+--------------------------- 17:        Temperaturbereich ber/unterschritten   Bad | Sensor_Failure                                */
#define DEXT_BIT_18           0x00000400     /* 0x00040000 */   /* |||||||| |||||+---------------------------- 18:        Messbereich ber/unterschritten         Bad | Sensor_Failure                                */
#define DEXT_BIT_19           0x00000800     /* 0x00080000 */   /* |||||||| ||||+----------------------------- 19:        reserviert                                                                                  */
#define DEXT_BIT_20           0x00001000     /* 0x00100000 */   /* |||||||| |||+------------------------------ 20:        Kalibrierung aktiv                      Uncertain |LUV / Good (Hngt von Para ab)           */
#define DEXT_BIT_21           0x00002000     /* 0x00200000 */   /* |||||||| ||+------------------------------- 21:        Konfigurierung aktiv                    Uncertain |LUV / Good (Hngt von Para ab)           */
#define DEXT_BIT_22           0x00004000     /* 0x00400000 */   /* |||||||| |+-------------------------------- 22:        Service aktiv                           Uncertain |LUV / Good (Hngt von Para ab)           */
#define DEXT_BIT_23           0x00008000     /* 0x00800000 */   /* |||||||| +--------------------------------- 23:        reserviert                                                                                  */
                                                                /*                                                                                                                                                    */
#define DEXT_BIT_24           0x00000001     /* 0x01000000 */   /* |||||||+----------------------------------- 24:        Fehler in Cal-Daten                     Bad | Sensor_Failure                                */
#define DEXT_BIT_25           0x00000002     /* 0x02000000 */   /* ||||||+------------------------------------ 25:        Sensor entwertet                        Bad | Sensor_Failure                                */
#define DEXT_BIT_26           0x00000004     /* 0x04000000 */   /* |||||+------------------------------------- 26:        Falsches Modul/ Sensor                  Bad | Sensor_Failure                                */
#define DEXT_BIT_27           0x00000008     /* 0x08000000 */   /* ||||+-------------------------------------- 27:        Kein Sensor/Modul                       Bad | Sensor_Failure                                */
#define DEXT_BIT_28           0x00000010     /* 0x10000000 */   /* |||+--------------------------------------- 28:        Sensor defekt                           Bad | Sensor_Failure                                */
#define DEXT_BIT_29           0x00000020     /* 0x20000000 */   /* ||+---------------------------------------- 29:        Konfigurierdaten defekt                 Bad | Device_Failure                                */
#define DEXT_BIT_30           0x00000040     /* 0x40000000 */   /* |+----------------------------------------- 30:        Abgleichdaten defekt                    Bad | Device_Failure                                */
#define DEXT_BIT_31           0x00000080     /* 0x80000000 */   /* +------------------------------------------ 31:        reserviert                                                                                  */
 
#define DIAG_EVENT_SWITCH_DIAG_STATUS_NO_INFLUENCE_GOOD_OK         0x00
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_REQUEST_GOOD     0x12
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_DEMAND_UNCERTAIN 0x25
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MEASUREMENT_UNCERTAIN_CL     0x25
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_ALARM_BAD        0x34
#define DIAG_EVENT_SWITCH_DIAG_STATUS_HW_ELECTR_BAD_CL             0x34
#define DIAG_EVENT_SWITCH_DIAG_STATUS_INVALID_PROCESS_COND_UNC     0x45
#define DIAG_EVENT_SWITCH_DIAG_STATUS_INVALID_PROCESS_COND_BAD     0x46
#define DIAG_EVENT_SWITCH_DIAG_STATUS_MEASUREMENT_BAD_CL           0x46
#define DIAG_EVENT_SWITCH_DIAG_STATUS_FUNCTION_CHECK_GOOD          0x58
#define DIAG_EVENT_SWITCH_DIAG_STATUS_NO_INFLUENCE_UNCERTAIN_CL    0x58

#define PHYS_EVENT_SWITCH_DIAG_STATUS_CONDENSED \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_NO_INFLUENCE_GOOD_OK,          TXT_DIAG_EVENT_NOINFLUENCE_OK }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_REQUEST_GOOD,      TXT_DIAG_EVENT_MAINTREQ_GOOD }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_DEMAND_UNCERTAIN,  TXT_DIAG_EVENT_MAINTDEMAND_UNCERTAIN }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_MAINTENANCE_ALARM_BAD,         TXT_DIAG_EVENT_MAINTALARM_MAINTALARM }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_INVALID_PROCESS_COND_UNC,      TXT_DIAG_EVENT_INV_PROC_COND_UNCERT }, \
    { DIAG_EVENT_SWITCH_DIAG_STATUS_FUNCTION_CHECK_GOOD,           TXT_DIAG_EVENT_FUNCTCHECK_GOOD }

IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __PHYSICAL_TRANSMITTER, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{
    //USE_PHYS_MANDATORY_B;
    EVERYTHING;
    REDEFINITIONS
    {    
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_2_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_2_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_3_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_3_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_4_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_4_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_5_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_5_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_6_Diag; 
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_6_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_7_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_7_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_8_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_8_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_9_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_9_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_10_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_10_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_11_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_11_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_12_Diag; 
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_12_Status;        
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_13_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_13_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_14_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_14_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_15_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_15_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_16_Diag; 
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_16_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_17_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_17_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_18_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_18_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_19_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_19_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_20_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_20_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_21_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_21_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_22_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_22_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_23_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_23_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_24_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_24_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_25_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_25_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_26_Diag; 
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_26_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_27_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_27_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_28_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_28_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_29_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_29_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_30_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_30_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_31_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_31_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_32_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_32_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_33_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_34_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_35_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag; 
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_36_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_37_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_38_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_39_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_40_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_41_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_42_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_43_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_44_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_45_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag; 
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_46_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_47_Status;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_48_Diag;
        DELETE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_48_Status;
                 
        REDEFINE VARIABLE phys_TARGET_MODE
        {        
            LABEL [PI_TARGET_MODE_label];
            HELP [PI_TARGET_MODE_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                //{ 0x01, [PI_mode_ROUT] }, // smt: nicht auswhlbar
                //{ 0x02, [PI_mode_RCAS] }, // smt: nicht auswhlbar
                //{ 0x04, [PI_mode_CAS] },  // smt: nicht auswhlbar
                { 0x08, [PI_mode_AUTO] },
                //{ 0x10, [PI_mode_MAN] },  // smt: nicht auswhlbar
                //{ 0x20, [PI_mode_LO] },   // smt: nicht auswhlbar
                //{ 0x40, [PI_mode_IMAN] }, // smt: nicht auswhlbar
                { 0x80, [PI_mode_OUT_OF_SERVICE] }
            }
        }
        
        REDEFINE VARIABLE phys_DEVICE_MAN_ID
        {
            LABEL [PI_DEVICE_MAN_ID_label];
            HELP [PI_DEVICE_MAN_ID_help];
            CLASS CONTAINED;
            HANDLING READ;
            TYPE ENUMERATED(2)    // smt: statt TYPE UNSIGNED_INTEGER(2);
            {
                DEFAULT_VALUE 97;
                { 97, "Knick" }
              }
        }
        
        REDEFINE VARIABLE phys_DIAGNOSIS
        {
            LABEL [PI_phys_DIAGNOSIS_label];
            HELP [PI_phys_DIAGNOSIS_help];
            CLASS CONTAINED & DYNAMIC;
            HANDLING READ;    
            TYPE BIT_ENUMERATED(4)
            {
                { 0x00200000, [PI_DIAGNOSIS_enum_DIA_MAINTENANCE], [PI_empty] },
                { 0x00800000, [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL], [PI_DIAGNOSIS_enum_DIA_IDENT_VIOL_help] },
                { 0x00000100, [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE], [PI_DIAGNOSIS_enum_DIA_DEV_FAILURE_help] },
                { 0x00000200, [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM], [PI_DIAGNOSIS_enum_DIA_MAINTEN_DEM] },
                { 0x00000400, [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK], [PI_DIAGNOSIS_enum_DIA_FUNCTION_CHECK_help] },
                { 0x00000800, [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND], [PI_DIAGNOSIS_enum_DIA_INVAL_PROC_COND_help] },
                { 0x00000080, [PI_DIAGNOSIS_enum_EXTENSION_AVAILABLE], [PI_empty] }
            }
        }
        
        REDEFINE VARIABLE phys_DIAGNOSIS_EXTENSION
        {
            LABEL [PI_phys_DIAGNOSIS_EXTENSION_label];
            HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
            CLASS CONTAINED & DYNAMIC;
            HANDLING READ;  
            TYPE BIT_ENUMERATED(4)      /* eigentlich 6 Byte, wir brauchen aber nur 4 Bytes, die beiden anderen Bytes werden separat abgeholt, damit PDM nicht abstrzt */
            {
                { DEXT_BIT_00,  "|en|Reserved Cond00",                   "|en|No help availablep" },
                { DEXT_BIT_01,  "|en|Autoclave cycles overrun",          "|en|Check/change sensor" },
                { DEXT_BIT_02,  "|en|CIP cycles overrun",                "|en|Check/change sensor" },
                { DEXT_BIT_03,  "|en|SIP cycles overrun",                "|en|Check/change sensor" },
                { DEXT_BIT_04,  "|en|Failure user table",                "|en|Check the user table" },
                { DEXT_BIT_05,  "|en|Reserved Cond05",                   "|en|No help available" },
                { DEXT_BIT_06,  "|en|Reserved Cond06",                   "|en|No help available" },
                { DEXT_BIT_07,  "|en|Reserved Cond07",                   "|en|No help available" },
                { DEXT_BIT_08,  "|en|Sensor wear",                       "|en|Check/change sensor" },
                { DEXT_BIT_09,  "|en|Out of maintenance",                "|en|Clean sensor" },
                { DEXT_BIT_10,  "|en|Out of cal time",                   "|en|Calibrate or change sensor" },
                { DEXT_BIT_11,  "|en|Sensor drift",                      "|en|Calibrate or change sensor" },
                { DEXT_BIT_12,  "|en|Bad cal data",                      "|en|Calibrate or change sensor" },
                { DEXT_BIT_13,  "|en|Sensocheck",                        "|en|Check sensor" },
                { DEXT_BIT_14,  "|en|Reserved Cond14",                   "|en|No help available" },
                { DEXT_BIT_15,  "|en|Reserved Cond15",                   "|en|No help available" },
                { DEXT_BIT_16,  "|en|Out of internal table",             "|en|Check sensor" },
                { DEXT_BIT_17,  "|en|Temperature range",                 "|en|Check sensor" },
                { DEXT_BIT_18,  "|en|Meas value range",                  "|en|Check sensor" },
                { DEXT_BIT_19,  "|en|Reserved Cond19",                   "|en|No help available" },
                { DEXT_BIT_20,  "|en|Calibration is active",             "|en|Finish calibration" },
                { DEXT_BIT_21,  "|en|Configuration is active",           "|en|Finish configuration" },
                { DEXT_BIT_22,  "|en|Service is active",                 "|en|Finish service" },
                { DEXT_BIT_23,  "|en|Reserved Cond23",                   "|en|No help available" },
                { DEXT_BIT_24,  "|en|Wrong cal data",                    "|en|Calibrate or change sensor" },
                { DEXT_BIT_25,  "|en|Canceled sensor",                   "|en|Change sensor" },
                { DEXT_BIT_26,  "|en|Wrong sensor/module",               "|en|Check configuration (Meas Mode) or use correct sensor/module" },
                { DEXT_BIT_27,  "|en|No sensor/module",                  "|en|Check sensor/module connection" },
                { DEXT_BIT_28,  "|en|Sensor failure",                    "|en|Return sensor to manufacturer" },
                { DEXT_BIT_29,  "|en|Configuration error",               "|en|Check every configuration parameter" },
                { DEXT_BIT_30,  "|en|Device failure",                    "|en|Return device to manufacturer" },
                { DEXT_BIT_31,  "|en|Reserved Cond31",                   "|en|No help available" }
            }
        }
        
        REDEFINE VARIABLE phys_DIAGNOSIS_MASK_EXTENSION
        {
            LABEL [PI_phys_DIAGNOSIS_MASK_EXTENSION_label];
            HELP [PI_phys_DIAGNOSIS_MASK_EXTENSION_help];
            CLASS CONTAINED;
            HANDLING READ;  
            TYPE BIT_ENUMERATED(4)      /* eigentlich 6 Byte, wir brauchen aber nur 4 Bytes */
            {
                { DEXT_BIT_00,  "|en|Check Function",                    "|en|Check Function help" },
                { DEXT_BIT_01,  "|en|Autoclave cycles overrun",          "|en|Check/ change sensor" },
                { DEXT_BIT_02,  "|en|CIP cycles overrun",                "|en|Check/ change sensor" },
                { DEXT_BIT_03,  "|en|SIP cycles overrun",                "|en|Check/ change sensor" },
                { DEXT_BIT_04,  "|en|Failure user table",                "|en|Check the user table" },
                { DEXT_BIT_05,  "|en|Reserved Cond05",                   "|en|No help available" },
                { DEXT_BIT_06,  "|en|Reserved Cond06",                   "|en|No help available" },
                { DEXT_BIT_07,  "|en|Reserved Cond07",                   "|en|No help available" },
                { DEXT_BIT_08,  "|en|Sensor wear",                       "|en|Check/ change sensor" },
                { DEXT_BIT_09,  "|en|Out of maintenance",                "|en|Clean sensor" },
                { DEXT_BIT_10,  "|en|Out of cal time",                   "|en|Calibrate or change sensor" },
                { DEXT_BIT_11,  "|en|Sensor drift",                      "|en|Calibrate or change sensor" },
                { DEXT_BIT_12,  "|en|Bad cal data",                      "|en|Calibrate or change sensor" },
                { DEXT_BIT_13,  "|en|Sensocheck",                        "|en|Check sensor" },
                { DEXT_BIT_14,  "|en|Reserved Cond14",                   "|en|No help available" },
                { DEXT_BIT_15,  "|en|Reserved Cond15",                   "|en|No help available" },
                { DEXT_BIT_16,  "|en|Out of internal table",             "|en|Check sensor" },
                { DEXT_BIT_17,  "|en|Temperature range",                 "|en|Check sensor" },
                { DEXT_BIT_18,  "|en|Meas value range",                  "|en|Check sensor" },
                { DEXT_BIT_19,  "|en|Reserved Cond19",                   "|en|No help available" },
                { DEXT_BIT_20,  "|en|Calibration is active",             "|en|Finish calibration" },
                { DEXT_BIT_21,  "|en|Configuration is active",           "|en|Finish configuration" },
                { DEXT_BIT_22,  "|en|Service is active",                 "|en|Finish service" },
                { DEXT_BIT_23,  "|en|Reserved Cond23",                   "|en|No help available" },
                { DEXT_BIT_24,  "|en|Wrong cal data",                    "|en|Calibrate or change sensor" },
                { DEXT_BIT_25,  "|en|Canceled sensor",                   "|en|Change sensor" },
                { DEXT_BIT_26,  "|en|Wrong sensor/module",               "|en|Check configuration (Meas Mode) or use correct sensor/module" },
                { DEXT_BIT_27,  "|en|No sensor/module",                  "|en|Check sensor/module connection" },
                { DEXT_BIT_28,  "|en|Sensor failure",                    "|en|Return sensor to manufacturer" },
                { DEXT_BIT_29,  "|en|Configuration error",               "|en|Check every configuration parameter" },
                { DEXT_BIT_30,  "|en|Device failure",                    "|en|Return device to manufacturer" },
                { DEXT_BIT_31,  "|en|Reserved Cond31",                   "|en|No help available" }
            }
        }
        
        REDEFINE VARIABLE phys_IDENT_NUMBER_SELECTOR
        {
            LABEL [PI_IDENT_NUMBER_SELECTOR_label];
            HELP [PI_IDENT_NUMBER_SELECTOR_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                DEFAULT_VALUE 127;
                { 0, [PI_phys_IDENT_NUMBER_SELECTOR_enum_0] },
                { 1, [PI_IDENT_NUMBER_SELECTOR_enum_1] },
                //{ 2, [PI_phys_IDENT_NUMBER_SELECTOR_enum_2] }, // smt: nicht untersttzt
                //{ 3, [PI_phys_IDENT_NUMBER_SELECTOR_enum_3] }, // smt: nicht untersttzt
                { 127, [PI_phys_IDENT_NUMBER_SELECTOR_enum_127] }
            }
        }
        
        // nderung msh:  
        REDEFINE VARIABLE phys_FEATURE_Supported
        {
            LABEL [PI_phys_FEATURE_Supported_label];
            CLASS CONTAINED;
            HANDLING READ;
            TYPE BIT_ENUMERATED(4)
            {
                { 0x01000000, [PI_FEATURE_Supported_enum_0x01], [PI_phys_FEATURE_Supported_enum_0x01_help] },
                { 0x02000000, [PI_FEATURE_Supported_enum_0x02], [PI_phys_FEATURE_Supported_enum_0x02_help] },
                { 0x04000000, [PI_FEATURE_Supported_enum_0x04], [PI_phys_FEATURE_Supported_enum_0x04_help] },
                { 0x08000000, [PI_FEATURE_Supported_enum_0x08], [PI_phys_FEATURE_Supported_enum_0x08_help] },
                { 0x10000000, [PI_FEATURE_Supported_enum_0x10], [PI_phys_FEATURE_Supported_enum_0x10_help] }
            }
        }

        // nderung msh:
        REDEFINE VARIABLE phys_FEATURE_Enabled
        {
            LABEL [PI_phys_FEATURE_Enabled_label];
            CLASS CONTAINED;
            HANDLING READ;    
            TYPE BIT_ENUMERATED(4)
            {    
                { 0x01000000, [PI_FEATURE_Supported_enum_0x01], [PI_phys_FEATURE_Enabled_enum_0x01_help] },
                { 0x02000000, [PI_FEATURE_Supported_enum_0x02], [PI_phys_FEATURE_Enabled_enum_0x02_help] },
                { 0x04000000, [PI_FEATURE_Supported_enum_0x04], [PI_phys_FEATURE_Enabled_enum_0x04_help] },
                { 0x08000000, [PI_FEATURE_Supported_enum_0x08], [PI_phys_FEATURE_Enabled_enum_0x08_help] },
                { 0x10000000, [PI_FEATURE_Supported_enum_0x10], [PI_phys_FEATURE_Enabled_enum_0x10_help] }
            }
        }
        
        REDEFINE COLLECTION phys_DIAG_EVENT_SWITCH
        {
            LABEL [PI_phys_DIAG_EVENT_SWITCH_label];
            HELP [PI_phys_DIAG_EVENT_SWITCH_help];
            MEMBERS
            {
                // msh: A221 hat nur 32 Meldungen
                Status_Link_1_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_1;        
                Status_Link_2_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_2;    
                Status_Link_3_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_3;
                Status_Link_4_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_4;
                //Status_Link_5_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_5;
                //Status_Link_6_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_6;
                //Status_Link_7_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_7;
                Status_Link_8_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_8;
                Status_Link_9_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_9;
                Status_Link_10_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_10;
                Status_Link_11_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_11;
                Status_Link_12_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_12;
                Status_Link_13_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_13;
                //Status_Link_14_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_14;
                //Status_Link_15_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_15;
                Status_Link_16_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_16;
                Status_Link_17_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_17;
                Status_Link_18_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_18;
                //Status_Link_19_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_19;
                Status_Link_20_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_20;
                Status_Link_21_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_21;
                Status_Link_22_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_22;
                //Status_Link_23_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_23;
                Status_Link_24_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_24;
                Status_Link_25_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_25;
                Status_Link_26_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_26;
                Status_Link_27_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_27;
                Status_Link_28_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_28;
                Status_Link_29_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_29;
                Status_Link_30_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_30;
                //Status_Link_31_Diag, phys_DIAG_EVENT_SWITCH_Status_Link_31;
            }
        }
        
        REDEFINE MENU phys_Simple_Dialog_Optional_A
        {
            LABEL [PI_phys_Simple_Dialog_Optional_A_label];
            STYLE DIALOG;
            ACCESS ONLINE;
            ITEMS
            {
                phys_BLOCK_OBJECT_page,
                phys_ST_REV_page,
                phys_TAG_DESC_page,
                phys_STRATEGY_page,
                phys_ALERT_KEY_page,
                phys_TARGET_MODE_page,
                phys_MODE_BLK_page,
                phys_ALARM_SUM_page,
                phys_SOFTWARE_REVISION_page,
                phys_HARDWARE_REVISION_page,
                phys_DEVICE_MAN_ID_page,
                phys_DEVICE_ID_page,
                phys_DEVICE_SER_NUM_page,
                phys_DIAGNOSIS_page,
                phys_DIAGNOSIS_EXTENSION_page,
                phys_DIAGNOSIS_MASK_page,
                phys_DIAGNOSIS_MASK_EXTENSION_page,
                phys_DEVICE_CERTIFICATION_page,
                phys_WRITE_LOCKING_page,
                phys_FACTORY_RESET_page,
                phys_DESCRIPTOR_page,
                phys_DEVICE_MESSAGE_page,
                phys_DEVICE_INSTAL_DATE_page,
                phys_LOCAL_OP_ENA_page,
                phys_IDENT_NUMBER_SELECTOR_page,
                phys_HW_WRITE_PROTECTION_page,
                phys_FEATURE_page,
                phys_COND_STATUS_DIAG_page,
                phys_DIAG_EVENT_SWITCH_page,
                // phys_PTA_OP_CODE_page, msh: PTA wird vom Geraet nicht unterstuetzt, ist optional, steuert sonst wie mit Fehlern in Parametern umgegangen wird
                // phys_PTA_STATUS_page,
                phys_VIEW_1_page,
                phys_VIEW_2_page,
                phys_VIEW_3_page,
                phys_VIEW_4_page
            }
        }
        
        REDEFINE MENU phys_Simple_Dialog_Optional_B
        {    
            LABEL [PI_phys_Simple_Dialog_Optional_B_label];
            STYLE DIALOG;
            ACCESS ONLINE;
            ITEMS
            {
                phys_BLOCK_OBJECT_page,
                phys_ST_REV_page,
                phys_TAG_DESC_page,
                phys_STRATEGY_page,
                phys_ALERT_KEY_page,
                phys_TARGET_MODE_page,
                phys_MODE_BLK_page,
                phys_ALARM_SUM_page,
                phys_SOFTWARE_REVISION_page,
                phys_HARDWARE_REVISION_page,
                phys_DEVICE_MAN_ID_page,
                phys_DEVICE_ID_page,
                phys_DEVICE_SER_NUM_page,
                phys_DIAGNOSIS_page,
                phys_DIAGNOSIS_EXTENSION_page,
                phys_DIAGNOSIS_MASK_page,
                phys_DIAGNOSIS_MASK_EXTENSION_page,
                phys_DEVICE_CERTIFICATION_page,
                phys_WRITE_LOCKING_page,
                phys_FACTORY_RESET_page,
                phys_DESCRIPTOR_page,
                phys_DEVICE_MESSAGE_page,
                phys_DEVICE_INSTAL_DATE_page,
                phys_LOCAL_OP_ENA_page,
                phys_IDENT_NUMBER_SELECTOR_page,
                phys_HW_WRITE_PROTECTION_page,
                phys_FEATURE_page,
                phys_COND_STATUS_DIAG_page,
                phys_DIAG_EVENT_SWITCH_page,
                // phys_PTA_OP_CODE_page, msh: PTA wird vom Geraet nicht unterstuetzt, ist optional, steuert sonst wie mit Fehlern in Parametern umgegangen wird
                // phys_PTA_STATUS_page,
                phys_VIEW_1_page,
                phys_VIEW_2_page,
                phys_VIEW_3_page,
                phys_VIEW_4_page
            }
        }
        
        REDEFINE COMMAND phys_DIAGNOSIS_EXTENSION_read
        {
            BLOCK phys_block;
            INDEX 14;
            OPERATION READ;
            RESPONSE_CODES DPV1_PA_rsp_codes;
            TRANSACTION
            {
                REQUEST
                {
                }
                REPLY
                {
                    phys_DIAGNOSIS_EXTENSION,
                    phys_DIAGNOSIS_EXTENSION2 // smt: hinzugefgt, Dummy-Variable
                }
            }
        }
        
        REDEFINE COMMAND phys_DIAGNOSIS_MASK_EXTENSION_read
        {
            BLOCK phys_block;
            INDEX 16;
            OPERATION READ;
            RESPONSE_CODES DPV1_PA_rsp_codes;
            TRANSACTION
            {
                REQUEST
                {
                }
                REPLY
                {
                    phys_DIAGNOSIS_MASK_EXTENSION,
                    phys_DIAGNOSIS_MASK_EXTENSION2 // smt: hinzugefgt, Dummy-Variable
                }
            }
        }
        
        REDEFINE COMMAND phys_DIAG_EVENT_SWITCH_read
        {
            BLOCK phys_block;
            INDEX 28;
            OPERATION READ;
            RESPONSE_CODES DPV1_PA_rsp_codes;
            TRANSACTION
            {
                REQUEST
                {
                }
                REPLY
                {
                    phys_DIAG_EVENT_SWITCH_Status_Link_0,
                    phys_DIAG_EVENT_SWITCH_Status_Link_1,
                    phys_DIAG_EVENT_SWITCH_Status_Link_2,
                    phys_DIAG_EVENT_SWITCH_Status_Link_3,
                    phys_DIAG_EVENT_SWITCH_Status_Link_4,
                    phys_DIAG_EVENT_SWITCH_Status_Link_5,
                    phys_DIAG_EVENT_SWITCH_Status_Link_6,
                    phys_DIAG_EVENT_SWITCH_Status_Link_7,
                    phys_DIAG_EVENT_SWITCH_Status_Link_8,
                     phys_DIAG_EVENT_SWITCH_Status_Link_9,
                    phys_DIAG_EVENT_SWITCH_Status_Link_10,
                    phys_DIAG_EVENT_SWITCH_Status_Link_11,
                    phys_DIAG_EVENT_SWITCH_Status_Link_12,
                    phys_DIAG_EVENT_SWITCH_Status_Link_13,
                    phys_DIAG_EVENT_SWITCH_Status_Link_14,
                    phys_DIAG_EVENT_SWITCH_Status_Link_15,
                    phys_DIAG_EVENT_SWITCH_Status_Link_16,
                    phys_DIAG_EVENT_SWITCH_Status_Link_17,
                    phys_DIAG_EVENT_SWITCH_Status_Link_18,
                    phys_DIAG_EVENT_SWITCH_Status_Link_19,
                    phys_DIAG_EVENT_SWITCH_Status_Link_20,
                    phys_DIAG_EVENT_SWITCH_Status_Link_21,
                    phys_DIAG_EVENT_SWITCH_Status_Link_22,
                     phys_DIAG_EVENT_SWITCH_Status_Link_23,
                    phys_DIAG_EVENT_SWITCH_Status_Link_24,
                    phys_DIAG_EVENT_SWITCH_Status_Link_25,
                    phys_DIAG_EVENT_SWITCH_Status_Link_26,
                    phys_DIAG_EVENT_SWITCH_Status_Link_27,
                    phys_DIAG_EVENT_SWITCH_Status_Link_28,
                    phys_DIAG_EVENT_SWITCH_Status_Link_29,
                    phys_DIAG_EVENT_SWITCH_Status_Link_30,
                    phys_DIAG_EVENT_SWITCH_Status_Link_31,
                    phys_DIAG_EVENT_SWITCH_Status_Link_32,
                    phys_DIAG_EVENT_SWITCH_Status_Link_33,
                    phys_DIAG_EVENT_SWITCH_Status_Link_34,
                    phys_DIAG_EVENT_SWITCH_Status_Link_35,
                    phys_DIAG_EVENT_SWITCH_Status_Link_36,
                    phys_DIAG_EVENT_SWITCH_Status_Link_37,
                    phys_DIAG_EVENT_SWITCH_Status_Link_38,
                    phys_DIAG_EVENT_SWITCH_Status_Link_39,
                    phys_DIAG_EVENT_SWITCH_Status_Link_40,
                    phys_DIAG_EVENT_SWITCH_Status_Link_41,
                    phys_DIAG_EVENT_SWITCH_Status_Link_42,
                    phys_DIAG_EVENT_SWITCH_Status_Link_43,
                    phys_DIAG_EVENT_SWITCH_Status_Link_44,
                    phys_DIAG_EVENT_SWITCH_Status_Link_45,
                    phys_DIAG_EVENT_SWITCH_Status_Link_46,
                    phys_DIAG_EVENT_SWITCH_Status_Link_47,      
                    phys_DIAG_EVENT_SWITCH_Slot,
                    phys_DIAG_EVENT_SWITCH_Index
                }
            }
        }    
        
        REDEFINE COMMAND phys_DIAG_EVENT_SWITCH_write
        {
            BLOCK phys_block;
            INDEX 28;
            OPERATION WRITE;
            RESPONSE_CODES DPV1_PA_rsp_codes;
            TRANSACTION
            {
                REQUEST
                {
                    phys_DIAG_EVENT_SWITCH_Status_Link_0,
                    phys_DIAG_EVENT_SWITCH_Status_Link_1,
                    phys_DIAG_EVENT_SWITCH_Status_Link_2,
                    phys_DIAG_EVENT_SWITCH_Status_Link_3,
                    phys_DIAG_EVENT_SWITCH_Status_Link_4,
                    phys_DIAG_EVENT_SWITCH_Status_Link_5,
                    phys_DIAG_EVENT_SWITCH_Status_Link_6,
                    phys_DIAG_EVENT_SWITCH_Status_Link_7,
                    phys_DIAG_EVENT_SWITCH_Status_Link_8,
                     phys_DIAG_EVENT_SWITCH_Status_Link_9,
                    phys_DIAG_EVENT_SWITCH_Status_Link_10,
                    phys_DIAG_EVENT_SWITCH_Status_Link_11,
                    phys_DIAG_EVENT_SWITCH_Status_Link_12,
                    phys_DIAG_EVENT_SWITCH_Status_Link_13,
                    phys_DIAG_EVENT_SWITCH_Status_Link_14,
                    phys_DIAG_EVENT_SWITCH_Status_Link_15,
                    phys_DIAG_EVENT_SWITCH_Status_Link_16,
                    phys_DIAG_EVENT_SWITCH_Status_Link_17,
                    phys_DIAG_EVENT_SWITCH_Status_Link_18,
                    phys_DIAG_EVENT_SWITCH_Status_Link_19,
                    phys_DIAG_EVENT_SWITCH_Status_Link_20,
                    phys_DIAG_EVENT_SWITCH_Status_Link_21,
                    phys_DIAG_EVENT_SWITCH_Status_Link_22,
                     phys_DIAG_EVENT_SWITCH_Status_Link_23,
                    phys_DIAG_EVENT_SWITCH_Status_Link_24,
                    phys_DIAG_EVENT_SWITCH_Status_Link_25,
                    phys_DIAG_EVENT_SWITCH_Status_Link_26,
                    phys_DIAG_EVENT_SWITCH_Status_Link_27,
                    phys_DIAG_EVENT_SWITCH_Status_Link_28,
                    phys_DIAG_EVENT_SWITCH_Status_Link_29,
                    phys_DIAG_EVENT_SWITCH_Status_Link_30,
                    phys_DIAG_EVENT_SWITCH_Status_Link_31,
                    phys_DIAG_EVENT_SWITCH_Status_Link_32,
                    phys_DIAG_EVENT_SWITCH_Status_Link_33,
                    phys_DIAG_EVENT_SWITCH_Status_Link_34,
                    phys_DIAG_EVENT_SWITCH_Status_Link_35,
                    phys_DIAG_EVENT_SWITCH_Status_Link_36,
                    phys_DIAG_EVENT_SWITCH_Status_Link_37,
                    phys_DIAG_EVENT_SWITCH_Status_Link_38,
                    phys_DIAG_EVENT_SWITCH_Status_Link_39,
                    phys_DIAG_EVENT_SWITCH_Status_Link_40,
                    phys_DIAG_EVENT_SWITCH_Status_Link_41,
                    phys_DIAG_EVENT_SWITCH_Status_Link_42,
                    phys_DIAG_EVENT_SWITCH_Status_Link_43,
                    phys_DIAG_EVENT_SWITCH_Status_Link_44,
                    phys_DIAG_EVENT_SWITCH_Status_Link_45,
                    phys_DIAG_EVENT_SWITCH_Status_Link_46,
                    phys_DIAG_EVENT_SWITCH_Status_Link_47,      
                    phys_DIAG_EVENT_SWITCH_Slot,
                    phys_DIAG_EVENT_SWITCH_Index 
                }
                REPLY
                {
                }
            }    
        }
    }  
}

    VARIABLE phys_DIAGNOSIS_EXTENSION2
    {
        LABEL [PI_phys_DIAGNOSIS_EXTENSION_label];
        HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
        CLASS CONTAINED & DYNAMIC;
        HANDLING READ;
        TYPE ASCII(2);
    }
    
    VARIABLE phys_DIAGNOSIS_MASK_EXTENSION2
    {
        LABEL [PI_phys_DIAGNOSIS_EXTENSION_label];
        HELP [PI_phys_DIAGNOSIS_EXTENSION_help];
        CLASS CONTAINED & DYNAMIC;
        HANDLING READ;
        TYPE ASCII(2);
    }
    
    VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT1;
        CLASS CONTAINED;
        TYPE ENUMERATED(1)
        {
            PHYS_EVENT_SWITCH_DIAG_STATUS_CONDENSED
        }
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_0 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT0;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_2 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT2;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_3 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT3;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_4 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT4;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_5 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT5;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_6 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT6;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_7 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT7;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_8 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT8;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_9 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT9;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_10 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT10;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_11 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT11;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_12 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT12;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_13 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT13;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_14 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT14;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_15 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT15;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_16 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT16;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_17 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT17;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_18 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT18;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_19 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT19;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_20 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT20;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_21 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT21;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_22 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT22;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_23 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT23;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_24 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT24;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_25 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT25;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_26 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT26;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_27 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT27;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_28 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT28;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_29 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT29;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_30 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT30;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_31 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT31;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_32 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL TXT_PHYS_DIAG_EVENT_LINK_BIT31;
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_33 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_33_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_34 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_34_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_35 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_35_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_36 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_36_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_37 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_37_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_38 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_38_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_39 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_39_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_40 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_40_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_41 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_41_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_42 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_42_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_43 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_43_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_44 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_44_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_45 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_45_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_46 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_46_Diag_label];
    }
    
    phys_DIAG_EVENT_SWITCH_Status_Link_47 LIKE VARIABLE phys_DIAG_EVENT_SWITCH_Status_Link_1
    {
        REDEFINE LABEL [PI_phys_DIAG_EVENT_SWITCH_Status_Link_47_Diag_label];
    }
    
    VARIABLE phys_DEVICE_LOCK
    {
        LABEL TXT_DEVICE_LOCK;
        HELP TXT_DEVICE_LOCK_HLP;
        CLASS CONTAINED;
        HANDLING READ & WRITE;
        TYPE ENUMERATED(1)
        {
            { 0, TXT_DEVICE_LOCK_0, " " },
            { 1, TXT_DEVICE_LOCK_1, " " }
        }
    }
    
    COMMAND phys_DEVICE_LOCK_read
    {
        BLOCK phys_block;
        INDEX 34;
        OPERATION READ;
        RESPONSE_CODES DPV1_PA_rsp_codes;
        TRANSACTION
        {
            REQUEST
            {
            }
            REPLY
            {
                phys_DEVICE_LOCK
            }
        }
    }
    
    COMMAND phys_DEVICE_LOCK_write
    {
        BLOCK phys_block;
        INDEX 34;
        OPERATION WRITE;
        RESPONSE_CODES DPV1_PA_rsp_codes;
        TRANSACTION
        {
            REQUEST
            {
                phys_DEVICE_LOCK
            }
            REPLY
            {
            }
        }
    }

/*
 -----------------------------
  ###    ### 
 #   #    #   
 #   #    #   
 #####    #
 #   #   ###    

 General Definitions
 -----------------------------
 */

/* Hier sind alle Units aufgefhrt, die vorkommen knnen */
#define AI_UNIT_LIST             { 1001,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1001,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1001    },    \
                            { 1002,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1002,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1002    },    \
                            { 1059,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1059,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1059    },    \
                            { 1133,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1133,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1133    },    \
                            { 1137,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1137,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1137    },    \
                            { 1138,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1138,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1138    },    \
                            { 1141,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1141,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1141    },    \
                            { 1213,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1213,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1213    },    \
                            { 1243,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1243,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1243    },    \
                            { 1281,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1281,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1281    },    \
                            { 1290,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1290,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1290    },    \
                            { 1342,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1342,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1342    },    \
                            { 1353,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1353,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1353    },    \
                            { 1422,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1422,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1422    },    \
                            { 1423,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1423,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1423    },    \
                            { 1523,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1523,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1523    },    \
                            { 1524,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1524,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1524    },    \
                            { 1552,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1552,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1552    },    \
                            { 1555,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1555,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1555    },    \
                            { 1558,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1558,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1558    },    \
                            { 1559,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1559,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1559    },    \
                            { 1562,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1562,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1562    },    \
                            {    0,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_0,   HLP_PV_TEMPERATURE_2_UNIT_88_VAL_0       }     \


/* Hier sind alle Units aufgefhrt, die vorkommen knnen */
#define AO_UNIT_LIST_TEMP    { 1001,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1001,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1001    },    \
                             { 1002,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1002,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1002    }    \

#define AO_UNIT_LIST_PESSURE { 1133,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1133,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1133    },    \
                             { 1138,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1138,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1138    },    \
                             { 1141,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1141,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1141    }    \

#define MEAS_TYPE_PH     0
#define MEAS_TYPE_COND     1
#define MEAS_TYPE_CONDI    2
#define MEAS_TYPE_CC    3
#define MEAS_TYPE_OXY    4

/*#define AI_CHANNEL_LIST             { 0x015a, TXT_CH_PH }, \
                                    { 0x0134, TXT_CH_PH }, \
                                    { 0x0135, TXT_CH_PH_VOLTAGE }, \
                                    { 0x0136, TXT_CH_ORP }, \
                                    { 0x0137, TXT_CH_GLSIMP }, \
                                    { 0x0138, TXT_CH_BZGIMP }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x0140, TXT_CH_FLOW }, \
                                    { 0x0141, "DO Saturation Air" }, \
                                    { 0x0142, "DO Concentration" }, \
                                    { 0x0144, "Gas V Concentration" }, \
                                    { 0x0145, "DO Partial Pressure" }, \
                                    { 0x0146, TXT_CH_COND }, \
                                    { 0x0148, TXT_CH_MOHMCM }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014a, "Conductance" }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, "TDS" }, \
                                    { 0x014d, "Conductivity 2" }, \
                                    { 0x014e, "Calculation" }, \
                                    { 0x014f, TXT_CH_CELL }, \
                                    { 0x0150, "Temperature 2" } */

#define AI_CHANNEL_LIST_PH          { 0x015a, TXT_CH_PH }, \
                                    { 0x0135, TXT_CH_PH_VOLTAGE }, \
                                    { 0x0136, TXT_CH_ORP }, \
                                    { 0x0137, TXT_CH_GLSIMP }, \
                                    { 0x0138, TXT_CH_BZGIMP }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x0140, TXT_CH_FLOW }

#define AI_CHANNEL_LIST_COND        { 0x015a, TXT_CH_COND }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x0148, TXT_CH_MOHMCM }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, TXT_CH_TDS }, \
                                    { 0x014f, TXT_CH_CELL }, \
                                    { 0x0140, TXT_CH_FLOW }, \
                                    { 0x014D, TXT_CH_COND_UNCOMP }

#define AI_CHANNEL_LIST_CONDI       { 0x015a, TXT_CH_COND }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x0148, TXT_CH_MOHMCM }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x014b, TXT_CH_SAL }, \
                                    { 0x014c, TXT_CH_TDS }, \
                                    { 0x014f, TXT_CH_CELL }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x0140, TXT_CH_FLOW }, \
                                    { 0x014D, TXT_CH_COND_UNCOMP }

#define AI_CHANNEL_LIST_CC          { 0x0146, TXT_CH_COND_A }, \
                                    { 0x014d, TXT_CH_COND_B }, \
                                    { 0x0139, TXT_CH_TEMP_A }, \
                                    { 0x0150, TXT_CH_TEMP_B }, \
                                    { 0x015a, TXT_CH_COND_A }, \
                                    { 0x014e, TXT_CH_CALC }, \
                                    { 0x014f, TXT_CH_CELL_A }, \
                                    { 0x013e, TXT_CH_CELL_B }, \
                                    { 0x0148, TXT_CH_MOHMCM_A }, \
                                    { 0x015c, TXT_CH_MOHMCM_B }, \
                                    { 0x0149, TXT_CH_CONCENTRATION }, \
                                    { 0x0140, TXT_CH_FLOW }, \
                                    { 0x013f, TXT_CH_K_REST }

#define AI_CHANNEL_LIST_OXY         { 0x015a, TXT_CH_DO_SAT }, \
                                    { 0x0142, TXT_CH_DO_CONC }, \
                                    { 0x0144, TXT_CH_DO_VCONC }, \
                                    { 0x0145, TXT_CH_DO_PART }, \
                                    { 0x0139, TXT_CH_TEMP }, \
                                    { 0x013b, TXT_CH_CALTIMER }, \
                                    { 0x013c, TXT_CH_SLOPE }, \
                                    { 0x013e, TXT_CH_ZERO }, \
                                    { 0x013f, TXT_CH_WEAR }, \
                                    { 0x0140, TXT_CH_FLOW }

#define AO_CHANNEL_LIST             { 0x0153, TXT_CH_TEMP }

#define AO_CHANNEL_LIST_OXY         { 0x0153, TXT_CH_TEMP }, \
                                    { 0x0155, TXT_CH_PRESS }

#define DI1_CHANNEL_LIST            { 0x0159, "USP" }

#define DO1_CHANNEL_LIST            { 0x0157, TXT_CH_RELAY1 }

#define DO2_CHANNEL_LIST            { 0x0158, TXT_CH_RELAY2 }

#include "pa_units_0302.h"
#include "pa_status.h"

#define DEF_DISPLAY_FORMAT(dec)            \
        SELECT(dec)        \
        {                                    \
            CASE 0:        ".0f";                \
            CASE 1:        ".1f";                \
            CASE 2:        ".2f";                \
            CASE 3:        ".3f";                \
            CASE 4:        ".4f";                \
            CASE 5:        ".5f";                \
            CASE 6:        ".6f";                \
            CASE 7:        ".7f";                \
            CASE 127:    "8.6f";                \
        }

/*
 -----------------------------
  ###    ###     ###
 #   #  #   #   #  #
 #   #  #   #      #
 #####  #   #      #
 #   #   ###       #

 Analog Output Block 1 importieren
 -----------------------------
 */
#define CB_FAIL_SAFE            0x00010000 /* Bit  0 */
#define CB_LOCAL_OP             0x00040000 /* Bit  2 */
#define CB_OVERRIDE             0x00080000 /* Bit  3 */
#define CB_UPDATE_EVT           0x00000400 /* Bit 10 */
#define CB_SIMULATE             0x00000800 /* Bit 11 */
#define CB_CONTR_INACT          0x00004000 /* Bit 14 */
 
IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_AO, DEVICE_REVISION 0x0302, DD_REVISION 0x0001 
{
    EVERYTHING;

    REDEFINITIONS
    {
        BLOCK func1_AO_block
        {
            REDEFINE NUMBER 9;
        }
        REDEFINE VARIABLE func1_AO_PV_SCALE_Units_Index
        {
            LABEL [PI_func_AO_PV_SCALE_label];
            HELP [PI_func_AO_PV_SCALE_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(2)
            {
                //DEFAULT_VALUE 1001;
                IF (func1_AO_OUT_CHANNEL == 0x0153) { // Temperatur
                    
                    AO_UNIT_LIST_TEMP
                }
                IF (func1_AO_OUT_CHANNEL == 0x0155) { // Pressure
                    
                    AO_UNIT_LIST_PESSURE
                }
            }
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func1_AO_OUT_CHANNEL
        {
            LABEL "AO1 " + [PI_IN_CHANNEL_label];
            HELP [PI_func_AO_OUT_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                SELECT ( meas_type )
                {
                    CASE MEAS_TYPE_OXY: AO_CHANNEL_LIST_OXY
                    DEFAULT: AO_CHANNEL_LIST
                }
            }
            HANDLING READ & WRITE;
        }
        
        /* this variable can only have values from classic status */
        REDEFINE VARIABLE func1_AO_SP_Status_Condensed
        {
            LABEL [SP_Status_label];
            CLASS INPUT & DYNAMIC;
            HANDLING IF (func1_AO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }            
            TYPE ENUMERATED(1)
            {
                PI_STATUS_LIST_STANDARD_INPUT // rth: an dieser Stelle gibts nur classic status, frherer Wert: PI_STATUS_LIST_WITHOUT_CAS
            }
        }
        
        REDEFINE VARIABLE func1_AO_FSAFE_TIME
        {
            LABEL [PI_FSAFE_TIME_label];
            HELP [PI_FSAFE_TIME_help];
            CLASS CONTAINED;
            CONSTANT_UNIT [PI_unit_1054];
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
                MIN_VALUE 0.0;
            }
            VALIDITY IF (func1_AO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; } // smt: VALIDITY ist hinzugekommen
        }
        
        REDEFINE VARIABLE func1_AO_FSAFE_TYPE
        {
            LABEL [PI_FSAFE_TYPE_label];
            HELP [PI_func_AO_FSAFE_TYPE_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                DEFAULT_VALUE 1;
                { 0, [PI_FSAFE_TYPE_enum_0_1] },
                { 1, [PI_FSAFE_TYPE_enum_1_1] }    
                // { 2, [PI_FSAFE_TYPE_enum_1_2] } // smt: FSAFE_TYPE = 2 nicht untersttzt
            }
        }
        
        REDEFINE VARIABLE func1_AO_FSAFE_VALUE
        {
            LABEL [PI_func_AO_FSAFE_VALUE_label];
            HELP [PI_FSAFE_VALUE_help_1];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
            }
            VALIDITY IF (func1_AO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
        }
        
        REDEFINE VARIABLE func1_AO_CHECK_BACK
        {
            LABEL [PI_CHECK_BACK_label];
            HELP [PI_CHECK_BACK_help];
            CLASS OUTPUT & DYNAMIC;
            HANDLING READ;
            TYPE BIT_ENUMERATED(3)
            {
                { 0, [PI_CHECK_BACK_enum_0], [PI_CHECK_BACK_enum_0] },
                { CB_FAIL_SAFE,     "Fail Safe", " " },                    // smt: hinzugefgt
                { CB_LOCAL_OP,      "Local Operator", " " },            // smt: hinzugefgt
                { CB_OVERRIDE,      "Override", " " },                  // smt: hinzugefgt
                { CB_UPDATE_EVT,    "Update Event", " " },                // smt: hinzugefgt
                { CB_SIMULATE,      "Simulation", " " },                // smt: hinzugefgt
                { CB_CONTR_INACT,   "Block is Out Of Service", " " }    // smt: hinzugefgt
            }
        }
        
        REDEFINE VARIABLE func1_AO_CHECK_BACK_MASK
        {
            LABEL [PI_CHECK_BACK_MASK_label];
            HELP [PI_CHECK_BACK_MASK_help];
            CLASS CONTAINED;
            HANDLING READ;
            TYPE BIT_ENUMERATED(3)
            {
                { 0, [PI_CHECK_BACK_enum_0], [PI_CHECK_BACK_enum_0] },
                { 0x000001, "Fail Safe", " " },                            // smt: hinzugefgt
                { 0x000004, "Local Operator", " " },                    // smt: hinzugefgt
                { 0x000008, "Override", " " },                            // smt: hinzugefgt
                { 0x000400, "Update Event", " " },                        // smt: hinzugefgt
                { 0x000800, "Simulation", " " },                        // smt: hinzugefgt
                { 0x004000, "Block is Out Of Service", " " }            // smt: hinzugefgt
            }
        }
        
        REDEFINE VARIABLE func1_AO_OUT_SCALE_Upper_Value
        {
            LABEL [PI_OUT_SCALE_Upper_Value_label];                        // smt: Label anders
            HELP [PI_OUT_SCALE_Upper_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 100;
            }
        }

        REDEFINE VARIABLE func1_AO_OUT_SCALE_Lower_Value
        {
            LABEL [PI_OUT_SCALE_Lower_Value_label];                        // smt: Label anders
            HELP [PI_OUT_SCALE_Lower_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
            }
        }
    }
}

/*
 -----------------------------
 ####   #####    ###
 #   #    #     #  #
 #   #    #        #
 #   #    #        #
 ####   #####      #

 Discret Input Block 1 importieren
 -----------------------------
 */
IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_DI, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{
    EVERYTHING;
    REDEFINITIONS
    {
        BLOCK func1_DI_block
        {
            REDEFINE NUMBER 10;
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func1_DI_CHANNEL
        {
            LABEL "DI1 " + [PI_CHANNEL_label];
            HELP [PI_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                DI1_CHANNEL_LIST
            }
            HANDLING READ & WRITE;
        }
        
        REDEFINE VARIABLE func1_DI_FSAFE_VAL_D
        {
            LABEL [PI_FSAFE_VALUE_label];
            HELP [PI_FSAFE_VALUE_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                {   0x00, [USP_valid], [USP_valid]},
                {   0x02, [USP_reduced_limit], [USP_reduced_limit]},
                {   0x01, [USP_limit], [USP_limit]}
            }    
            VALIDITY IF (func1_DI_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
        }
        
        REDEFINE VARIABLE func1_DI_OUT_D_Value
        {
            LABEL [PI_OUT_Value_label];
            HELP [PI_OUT_Value_help];
            CLASS OUTPUT & DYNAMIC;
            HANDLING IF (func1_DI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE ENUMERATED(1)
            {
                {   0x00, [USP_valid], [USP_valid]},
                {   0x02, [USP_reduced_limit], [USP_reduced_limit]},
                {   0x01, [USP_limit], [USP_limit]}
            }
        }
        
        REDEFINE VARIABLE func1_DI_SIMULATE_Value
        {
            LABEL [PI_SIMULATE_Value_label];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                {   0x00, [USP_valid], [USP_valid]},
                {   0x02, [USP_reduced_limit], [USP_reduced_limit]},
                {   0x01, [USP_limit], [USP_limit]}
            }
        }
        
        REDEFINE VARIABLE func1_DI_OUT_D_Status_Condensed
        {
            LABEL [PI_SIMULATE_Status_Condensed_label];
            CLASS OUTPUT & DYNAMIC;
            HANDLING IF (func1_DI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE ENUMERATED(1)
            {
                PI_STATUS_LIST_WITHOUT_CAS
            }
        }
    }
}

/*
 -----------------------------
 ####    ###     ###
 #   #  #   #   #  #
 #   #  #   #      #
 #   #  #   #      #
 ####    ###       #

 Discrete Output Block 1 importieren
 -----------------------------
 */
IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_DO, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{
    EVERYTHING;
    REDEFINITIONS
    {
        BLOCK func1_DO_block
        {
            REDEFINE NUMBER 11;
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func1_DO_IN_CHANNEL
        {
            LABEL "DO1 " + [PI_IN_CHANNEL_label];
            HELP [PI_func_DO_IN_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                DO1_CHANNEL_LIST
            }
            HANDLING READ & WRITE;
        }
        
        REDEFINE VARIABLE func1_DO_SP_D_Status_Condensed
        {
            LABEL [SP_Status_label];
            CLASS INPUT & DYNAMIC;
            TYPE ENUMERATED(1)
            {
                PI_STATUS_LIST_STANDARD_INPUT
            }
        }
        
        REDEFINE VARIABLE func1_DO_FSAFE_TIME
        {
            LABEL [PI_FSAFE_TIME_label];
            HELP [PI_FSAFE_TIME_help];
            CLASS CONTAINED;
            CONSTANT_UNIT [PI_unit_1054];
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
                MIN_VALUE 0.0;
            }
            VALIDITY IF (func1_DO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; } // smt: VALIDITY ist hinzugekommen
        }

        VARIABLE func1_DO_FSAFE_TYPE
        {
            LABEL [PI_FSAFE_TYPE_label];
            HELP [PI_FSAFE_TYPE_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                { 0, [PI_FSAFE_TYPE_enum_0_1] },
                { 1, [PI_FSAFE_TYPE_enum_1_1] } 
                //{ 2, [PI_FSAFE_TYPE_enum_2_1] } // smt: FSAFE_TYPE = 2 wird nicht untersttzt
            }
        }
    
        REDEFINE VARIABLE func1_DO_FSAFE_VAL_D
        {
            LABEL [PI_func_DO_FSAFE_VAL_D_label];
            HELP [PI_FSAFE_VALUE_help_1];
            CLASS CONTAINED;
            TYPE UNSIGNED_INTEGER(1)
            {
                DEFAULT_VALUE 0;
            }
            VALIDITY IF (func1_DO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; } // smt: VALIDITY ist hinzugekommen
        }
        
        REDEFINE VARIABLE func1_DO_SP_D_Value
        {
            LABEL [PI_func_DO_SP_D_Value_label];
            HELP [PI_func_DO_SP_D_Value_help];
            CLASS INPUT & DYNAMIC;
            TYPE ENUMERATED(1)
            {
                {   0, [off], [off]},
                {   1, [on], [on]}
            }
        }
        
        REDEFINE VARIABLE func1_DO_OUT_D_Value
        {
            LABEL [PI_func_DO_OUT_D_Value_label];
            HELP [PI_OUT_Value_help_1];
            CLASS CONTAINED & DYNAMIC;
            HANDLING IF (func1_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE ENUMERATED(1)
            {
                {   0, [off], [off]},
                {   1, [on], [on]}
            }
        }    

        REDEFINE VARIABLE func1_DO_SIMULATE_Value
        {
            LABEL [PI_DO_SIMULATE_Value_label];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                {   0, [off], [off]},
                {   1, [on], [on]}
            }
        }
    }
}

/*
 -----------------------------
 ####    ###    ####
 #   #  #   #       #
 #   #  #   #    ###
 #   #  #   #   #
 ####    ###    #####

 Discrete Output Block 2 importieren
 -----------------------------
 */
IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC2_DO, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{
    EVERYTHING;
    REDEFINITIONS
    {
        BLOCK func2_DO_block
        {
            REDEFINE NUMBER 12;
        }
        /* CHANNEL als ENUM verndern, damit je nach Messgre nur die notwendigen CHANNELS angezeigt werden */
        REDEFINE VARIABLE func2_DO_IN_CHANNEL
        {
            LABEL "DO2 " + [PI_IN_CHANNEL_label];
            HELP [PI_func_DO_IN_CHANNEL_help];
            CLASS CONTAINED;
            TYPE ENUMERATED (2)
            {
                DO2_CHANNEL_LIST
            }
            HANDLING READ & WRITE;
        }
        REDEFINE VARIABLE func2_DO_SP_D_Status_Condensed
        {
            LABEL [SP_Status_label];
            CLASS INPUT & DYNAMIC;
            TYPE ENUMERATED(1)
            {
                PI_STATUS_LIST_STANDARD_INPUT
            }
        }
        
        REDEFINE VARIABLE func2_DO_FSAFE_TIME
        {
            LABEL [PI_FSAFE_TIME_label];
            HELP [PI_FSAFE_TIME_help];
            CLASS CONTAINED;
            CONSTANT_UNIT [PI_unit_1054];
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
                MIN_VALUE 0.0;
            }
            VALIDITY IF (func2_DO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; } // smt: VALIDITY ist hinzugekommen
        }    

        REDEFINE VARIABLE func2_DO_FSAFE_TYPE
        {
            LABEL [PI_FSAFE_TYPE_label];
            HELP [PI_FSAFE_TYPE_help];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                { 0, [PI_FSAFE_TYPE_enum_0_1] },
                { 1, [PI_FSAFE_TYPE_enum_1_1] }    // smt: FSAFE_TYPE = 2 wird nicht untersttzt
            }
        }
        
        REDEFINE VARIABLE func2_DO_FSAFE_VAL_D
        {
            LABEL [PI_func_DO_FSAFE_VAL_D_label];
            HELP [PI_FSAFE_VALUE_help_1];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                {   0, [off], [off]},
                {   1, [on], [on]}
            }
            VALIDITY IF (func2_DO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
        }
        
        REDEFINE VARIABLE func2_DO_SP_D_Value
        {
            LABEL [PI_func_DO_SP_D_Value_label];
            HELP [PI_func_DO_SP_D_Value_help];
            CLASS INPUT & DYNAMIC;
            TYPE ENUMERATED(1)
            {
                {   0, [off], [off]},
                {   1, [on], [on]}
            }
        }
        
        REDEFINE VARIABLE func2_DO_OUT_D_Value
        {
            LABEL [PI_func_DO_OUT_D_Value_label];
            HELP [PI_OUT_Value_help_1];
            CLASS CONTAINED & DYNAMIC;
            HANDLING IF (func2_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE ENUMERATED(1)
            {
                {   0, [off], [off]},
                {   1, [on], [on]}
            }
        }
        
        VARIABLE func2_DO_OUT_D_Status_Condensed
        {
            LABEL [PI_OUT_D_Status_Condensed_label];
            CLASS CONTAINED & DYNAMIC;
            HANDLING IF (func2_DO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE ENUMERATED(1)
            {
                PI_STATUS_LIST_STANDARD_INPUT // rth: an dieser Stelle gibts nur classic status, frherer Wert: PI_STATUS_LIST_WITHOUT_CAS        
            }
        }
        
        REDEFINE VARIABLE func2_DO_SIMULATE_Value
        {
            LABEL [PI_DO_SIMULATE_Value_label];
            CLASS CONTAINED;
            TYPE ENUMERATED(1)
            {
                {   0, [off], [off]},
                {   1, [on], [on]}
            }
        }        
    }
}

/*
 -----------------------------
 #####       #   # 
   #     #   ## ##
   #   ##### # # #
   #     #   #   #
 #####       #   #

 Identification & Maintenance importieren
 -----------------------------
 */
IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __IAM1_IMDATA, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{
    EVERYTHING;
    REDEFINITIONS {
        REDEFINE MENU iam1_IMData_Simple_Dialog
        {
            LABEL        "Identification and Maintenance";
            HELP        [PI_IaM_Simple_Dialog_help];
            STYLE        WINDOW;
            ACCESS    ONLINE;
            ITEMS
            {
                iam1_IMData_IM0_page
                //iam1_IMData_IM1_page,
                //iam1_IMData_IM2_page,
                //iam1_IMData_IM3_page,
                //iam1_IMData_IM4_page,
                //iam1_IMData_PA_IM0_page
            }
        }
  
        REDEFINE MENU iam1_IMData_IM0_page
        {
            LABEL    "Identification and Maintenance";
            HELP    [PI_IM0_page_help];
            STYLE    PAGE;
            ITEMS
            {
                iam1_IMData_IM0_MANUFACTURER_ID,
                iam1_IMData_IM0_ORDER_ID,
                iam1_IMData_IM0_SERIAL_NUMBER,
                iam1_IMData_IM1_TAG_FUNCTION, // msh: hinzugefgt
                iam1_IMData_IM1_TAG_LOCATION, // msh: hinzugefgt
                iam1_IMData_IM2_INSTALLATION_DATE, // msh: hinzugefgt
                iam1_IMData_IM3_DESCRIPTOR, // msh: hinzugefgt
                //iam1_IMData_IM4_SIGNATURE,
                iam1_IMData_PA_IM0_PA_HARDWARE_REVISION, // msh: hinzugefgt
                iam1_IMData_PA_IM0_PA_SOFTWARE_REVISION, // msh: hinzugefgt
                //iam1_IMData_IM0_HARDWARE_REVISION,
                //iam1_IMData_IM0_SOFTWARE_REVISION_group,
                iam1_IMData_IM0_REVISION_COUNTER,
                iam1_IMData_IM0_PROFILE_ID_Displ (READ_ONLY),
                iam1_IMData_IM0_PROFILE_SPECIFIC_TYPE,
                iam1_IMData_IM0_IM_VERSION_group,
                //iam1_IMData_PA_IM0_PA_IM_VERSION_group, // msh: hinzugefgt, funktioniert nicht
                iam1_IMData_IM0_IM_SUPPORTED (HIDDEN)
            }
        }
    }
}

/*
 -----------------------------
 #####  ####     ###
   #    #   #   #  #
   #    ####       #
   #    #   #      #
   #    ####       #

 Transducer Block (Hersteller) importieren
 -----------------------------
 */

IMPORT "std_tb.ddl"
{
    EVERYTHING;
}
