/* ----------------------------------------------------------------------

 FILE_NAME          sensor.ddl



 FUNCTIONAL_MODULE_DESCRIPTION

 Zeigt die verfgbaren Sensorinfos

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */
#define NO_SENSOR           1
#define SENSOR_PH           0x0000
#define SENSOR_COND         0x0100
#define SENSOR_CONDI        0x0200
#define SENSOR_CC           0x0300
#define SENSOR_DO           0x0400
#define SENSOR_ISFET        0x0500
#define SENSOR_ORP          0x0600
#define SENSOR_MASK         0x0F00

#define SENSOR_STD          0x0000        // Mask: 0x3000
#define SENSOR_MEMOSENS     0x1000        // Mask: 0x3000
#define SENSOR_ISM          0x2000        // Mask: 0x3000
#define SENSOR_TYPE_MASK    0x3000

#define SENSOR_PH_ORP       0x4000        // Mask: 0xC000
#define SENSOR_PHV1         0x8000        // Mask: 0xC000
#define SENSOR_PH_MASK      0xC000

#define SENSOR_TRACES       0x3000
#define SENSOR_SUBTRACES    0x4000

#define SMILEY_GOOD         0x0000
#define SMILEY_NEUTRAL      0x0001
#define SMILEY_BAD          0x0002

/* Bilder fr die Smileys anlegen */
IMAGE img_smiley_hq
{
    PATH "SensofaceGood.png";
    VALIDITY IF ( ( sensocheck == 1 ) && ( smiley_39 == SMILEY_GOOD ) ) /* nur, wenn  der Smiley gut ist*/
    {
        TRUE;
    }
    ELSE
    {
        FALSE;
    }
}

IMAGE img_smiley_mq
{
    PATH "SensofaceMedium.png";
    VALIDITY IF ( ( sensocheck == 1 ) && ( smiley_39 == SMILEY_NEUTRAL ) ) /* nur, wenn  der Smiley neutral ist*/
    {
        TRUE;
    }
    ELSE
    {
        FALSE;
    }
}

IMAGE img_smiley_lq
{
    PATH "SensofaceBad.png";
    VALIDITY IF ( ( sensocheck == 1 ) && ( smiley_39 == SMILEY_BAD ) ) /* nur, wenn  der Smiley traurig ist*/
    {
        TRUE;
    }
    ELSE
    {
        FALSE;
    }
}

IMAGE img_memosens
{
    PATH "memo.jpg";
}

/*
 ------------------------------------------------------
  ####  #####  #   #   ####   ###   ####
 #      #      ##  #  #      #   #  #   #
  ###   ###    # # #   ###   #   #  ####
     #  #      #  ##      #  #   #  #   #
 ####   #####  #   #  ####    ###   #   #
 ------------------------------------------------------
 */
MENU sensor_page
{
    LABEL [sensor];
    STYLE PAGE;
    ACCESS ONLINE;
    ITEMS
    {
        current_error (HIDDEN),

        IF ( ( current_error >= 1 ) && 
             ( current_error <= 3 ) ) {
            std_cal_page_no_sensor
        }
        ELSE {
            IF ( ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_PH ) ||
                 ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_ISFET ) ||
                 ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_ORP ) ) {    
                std_sensor_ph_page
            } 
            IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_COND ) {
                std_sensor_cond_page
            }
            IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_CONDI ) {
                std_sensor_condi_page
            }
            IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_CC ) {
                std_sensor_cc_page
            }
            IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_DO ) {
                std_sensor_oxy_page
            }
        }
    }
    PRE_READ_ACTIONS { method_read_smiley_state }
}

/*
/* -----------------------------------------------------------------
  #### #####  ###  #   # ####   ###  ####  ####
 #       #   #   # ##  # #   # #   # #   # #   #
  ###    #   ##### # # # #   # ##### ####  #   #
     #   #   #   # #  ## #   # #   # # #   #   #
 ####    #   #   # #   # ####  #   # #  #  ####

 Seite "pH"

 Calibration data
 Caltime
 Zero/Offset/Zero ORP
 Slope

 SensorInformation (MS)         SensorInformation (ISM)
 Serial No.                     Serial No.
 Order No.                      Order No.
 TAG

 Sensor Wear
 Runtime
 SIP-Cycles
 CIP-Cycles
 TTM
 DLI
 ACT
 Wear
 Caltimer

 */

MENU std_sensor_info_page_ms
{
    LABEL TXT_DIAG_SNS_INFO;
    STYLE GROUP;
    ITEMS
    {
        img_memosens,
        serial_no_100,
        order_no_100,
        tag_100,
        manu_100,
        init_operation_100
    }
}

MENU std_sensor_info_page_ism
{
    LABEL TXT_DIAG_SNS_INFO;
    STYLE GROUP;
    ITEMS
    {
        serial_no_100,
        order_no_100
    }
}

/* -----------------------------------------------------------------
 ####   #   #
 #   #  #   #
 ####   #####
 #      #   #
 #      #   #
 Caldaten
 Sensorinfo zu digitalen Sensoren
 Verschleissdaten
 -----------------------------------------------------------------
 */
MENU std_sensor_ph_page
{
    LABEL LBL_SENSOR_39 + " " + LBL_MEAS_TYPE_18_VAL_0;
    ITEMS
    {
        sns_status_39 (HIDDEN)
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_PH ) {
            std_sensor_ph_page_caldata_ph
        }
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_ISFET ) {
            std_sensor_ph_page_caldata_isfet
        }
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_ORP ) {
            std_sensor_ph_page_caldata_orp
        }
        IF ( ( sns_status_39 & SENSOR_TYPE_MASK ) == SENSOR_STD ) {
            std_sensor_wear_ph_page_std
        }
        IF ( ( sns_status_39 & SENSOR_TYPE_MASK ) == SENSOR_MEMOSENS ) {
            std_sensor_info_page_ms,
            std_sensor_wear_ph_page_ms        
        }
        IF ( ( sns_status_39 & SENSOR_TYPE_MASK ) == SENSOR_ISM ) {
            std_sensor_info_page_ism,
            std_sensor_wear_ph_page_ism
        }
    }
}

/* Caldaten pH Standard */
MENU std_sensor_ph_page_caldata_ph
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sensocheck(HIDDEN),
        img_smiley_hq, img_smiley_mq, img_smiley_lq,
        cal_timestamp(READ_ONLY),
        ph_cal_zero(READ_ONLY),
        ph_cal_slope(READ_ONLY)
    }
}

/* Caldaten pH Isfet */
MENU std_sensor_ph_page_caldata_isfet
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sensocheck(HIDDEN),
        img_smiley_hq, img_smiley_mq, img_smiley_lq,
        cal_timestamp(READ_ONLY),
        ph_cal_offset_isfet(READ_ONLY),
        ph_cal_slope(READ_ONLY)
    }
}

/* Caldaten ORP */
MENU std_sensor_ph_page_caldata_orp
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        sensocheck(HIDDEN),
        img_smiley_hq, img_smiley_mq, img_smiley_lq,
        cal_timestamp(READ_ONLY),
        ph_calzero_orp(READ_ONLY)
    }
}

/* Men fr Standard pH */
MENU std_sensor_wear_ph_page_std
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        caltimer_39
    }
}

/* Men fr MS pH */
MENU std_sensor_wear_ph_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        IF ( ( ( sns_status_39 & 0xC000 ) == SENSOR_PH_ORP ) || 
             ( ( sns_status_39 & 0xC000 ) == SENSOR_PHV1 ) ) {
            cip_cycles_39
        } 
        sip_cycles_39,
        runtime_39,
        dli_39,
        wear_39,
        caltimer_39
    }
}

/* Men fr ISM pH */
MENU std_sensor_wear_ph_page_ism
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        cip_cycles_39,
        sip_cycles_39,
        autoclave_39,
        runtime_39,
        ttm_39,
        dli_39,
        act_39
    }
}

/*
 //------------------------------
 //   ###    ###   #   #  ####
 //  #   #  #   #  ##  #  #   #
 //  #      #   #  # # #  #   #
 //  #   #  #   #  #  ##  #   #
 //   ###    ###   #   #  ####

 Caldaten
 Sensorinfo zu digitalen Snesoren
 Verschleissdaten
 //------------------------------
 */
MENU std_sensor_cond_page
{
    LABEL TXT_SENSOR_COND;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        std_sensor_cond_page_caldata_std
        IF ( ( sns_status_39 & SENSOR_TYPE_MASK ) == SENSOR_MEMOSENS ) {
            std_sensor_info_page_ms,
            std_sensor_wear_cond_page_ms
        }
    }
}

/* Caldaten Cond*/
MENU std_sensor_cond_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        cal_timestamp (READ_ONLY),
        cond_cellconst (READ_ONLY)
    }
}

/* Men fr MS Cond */
MENU std_sensor_wear_cond_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sip_cycles_39,
        runtime_39,
        dli_39
    }
}

/*
 //------------------------------
 //   ###    ###   #   #  ####   #####
 //  #   #  #   #  ##  #  #   #    #
 //  #      #   #  # # #  #   #    #
 //  #   #  #   #  #  ##  #   #    #
 //   ###    ###   #   #  ####   #####

 Caldaten
 Sensorinfo zu digitalen Snesoren
 Verschleissdaten
 //------------------------------
 */
MENU std_sensor_condi_page
{
    LABEL TXT_SENSOR_CONDI;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        current_error,
        std_sensor_condi_page_caldata_std,
        IF ( ( sns_status_39 & SENSOR_TYPE_MASK ) == SENSOR_MEMOSENS ) {
            std_sensor_info_page_ms,
            std_sensor_wear_condi_page_ms
        }
    }
}

/* Caldaten CondI*/
MENU std_sensor_condi_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        cal_timestamp(READ_ONLY),
        tc_cellfactor(READ_ONLY),
        tc_install(READ_ONLY),
        tc_zero(READ_ONLY),
        tc_trans_ratio(READ_ONLY)
    }
}

/* Men fr MS CondI */
MENU std_sensor_wear_condi_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        cip_cycles_39,
        sip_cycles_39,
        runtime_39,
        dli_39
    }
}

/*
 //-------------------------------------
 //   ###    ###
 //  #   #  #   #
 //  #      #
 //  #   #  #   #
 //   ###    ###

 Caldaten
 //-------------------------------------
 */
MENU std_sensor_cc_page
{
    LABEL LBL_SENSOR_39 + " " + LBL_MEAS_TYPE_18_VAL_3;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        current_error,
        std_sensor_cc_page_caldata_std
    }
}

/* Caldaten CC*/
MENU std_sensor_cc_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        cal_timestamp(READ_ONLY),
        cc_cellfactor_a(READ_ONLY),
        cc_cellfactor_b(READ_ONLY)
    }
}

/* -----------------------------------------------------------------
 //   ###   #   #  #   #
 //  #   #   # #    # #
 //  #   #    #      #
 //  #   #   # #     #
 //   ###   #   #    #
 Caldaten
 Sensorinfo zu digitalen Snesoren
 Verschleissdaten
 -----------------------------------------------------------------
 */
MENU std_sensor_oxy_page
{
    LABEL TXT_SENSOR_DO;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        current_error,
        std_sensor_oxy_page_caldata_std
        IF ( ( sns_status_39 & SENSOR_TYPE_MASK ) == SENSOR_MEMOSENS ) {
            std_sensor_info_page_ms,
            std_sensor_wear_oxy_page_ms
        }
        IF ( ( sns_status_39 & SENSOR_TYPE_MASK ) == SENSOR_ISM ) {
            std_sensor_info_page_ism,
            std_sensor_wear_oxy_page_ism
        }
    }
}

/* Caldaten Oxy Std*/
MENU std_sensor_oxy_page_caldata_std
{
    LABEL TXT_CALIBRATION_DATA;
    STYLE GROUP;
    ITEMS
    {
        cal_timestamp(READ_ONLY),
        do_cal_zero(READ_ONLY),
        do_cal_slope(READ_ONLY)
    }
}

/* Men fr MS Oxy */
MENU std_sensor_wear_oxy_page_ms
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        sip_cycles_39,
        runtime_39,
        dli_39,
        wear_39,
        caltimer_39
    }
}

/* Men fr ISM pH */
MENU std_sensor_wear_oxy_page_ism
{
    LABEL TXT_SENSOR_WEAR;
    STYLE GROUP;
    ITEMS
    {
        cip_cycles_39,
        sip_cycles_39,
        autoclave_39,
        runtime_39,
        ttm_39,
        dli_39,
        act_39
    }
}

/*-------------------------------------------------------------------*/
/*  Methode zum auslesen des Smileystatus  */
/*-------------------------------------------------------------------*/
METHOD method_read_smiley_state
{
    LABEL "";
    CLASS OUTPUT;
    DEFINITION
    {
        ReadCommand(tb1_sensor_read);
    }
}
