
//-------------------------------------------------------------------------------------------------
//    DO Function Blocks
//-------------------------------------------------------------------------------------------------

// TAG ins Online Window Function Block Ausgnge
#define FUNCX_DO_TAG_IN_PAGE_DISPLAY

#define THEME_DO	" (Control)""|de| (Steuerung)"
//-------------------------------------------------------------------------------------------------
//
//  ####   ###          ##
//  #   # #   #        # #
//  #   # #   #       #  #
//  #   # #   #          #
//  #   # #   #          #
//  #   # #   #          #
//  ####   ###         ####
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDO1_300.ddl"
//-------------------------------------------------------------------------------------------------

#define FUNC1_DO_TITLE	"Hold"
#define FUNC1_DO_BLOCKNUMBER	9		// DO1 = FB9
#define FUNC1_DO_GLOBAL_SIMULATION_MASK	0x00000100

#include "KNPASTDO1_300.ddl"

//-------------------------------------------------------------------------------------------------
//    VARIABLE (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 09 : SP_D --------------------------------------------------------------------------------

VARIABLE func1_DO_sp_d_value
{
    LABEL		[func_do_sp_d_value];
    HELP		[func_do_sp_d_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x00;
        { 0x00,	"Run"			},
        { 0x01,	"Hold"		}
    }
    HANDLING	READ & WRITE;
}


//--- DO 10 : OUT_D -------------------------------------------------------------------------------

func1_DO_out_d_value	  						LIKE VARIABLE	func1_DO_sp_d_value
{
    REDEFINE LABEL		"Device State" "|de|Betriebszustand";
    REDEFINE HELP		[func_do_out_d_value_help];
    REDEFINE HANDLING
        IF (func1_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

func1_DO_readback_d_value  				LIKE VARIABLE	func1_DO_out_d_value
{
    REDEFINE HELP		[func_do_readback_value_help];
    REDEFINE HANDLING READ;
}


//--- DO 21 : FSAFE_VAL_D -------------------------------------------------------------------------

func1_DO_FSafeValue 							LIKE VARIABLE func1_DO_out_d_value
{
     REDEFINE LABEL		[func_do_fsafe_value];
     REDEFINE HELP		[func_ao_fsafe_value_help];
     REDEFINE CLASS		CONTAINED;
     REDEFINE HANDLING	READ & WRITE;
   REDEFINE VALIDITY	IF (func1_DO_FSafeType == FUNC_AI_FAIL_SAFE_VALUE)
                            {
                                TRUE;
                            }
                            ELSE
                            {
                                FALSE;
                            }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

func1_DO_simulate_value						LIKE VARIABLE func1_DO_readback_d_value
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func1_DO_out_d
{
    BLOCK func1_DO_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DO_out_d_value,
            func1_DO_out_d_status_quality	<0xFC>,
            func1_DO_out_d_status_limit	<0x03>
        }
    }
}


COMMAND write_func1_DO_out_d
{
    BLOCK func1_DO_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DO_out_d_value,
            func1_DO_out_d_status_quality	<0xFC>,
            func1_DO_out_d_status_limit	<0x03>
        }
        REPLY
        {
        }
    }
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

COMMAND read_func1_DO_readback_d
{
    BLOCK func1_DO_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DO_readback_d_value,
            func1_DO_readback_d_status_quality	<0xFC>,
            func1_DO_readback_d_status_limit		<0x03>
        }
    }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func1_DO_simulate
{
    BLOCK func1_DO_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_DO_simulate_status_quality		<0xFC>,
            func1_DO_simulate_status_limit		<0x03>,
            func1_DO_simulate_value,
            func1_DO_simulation_enabled
        }
    }
}


COMMAND write_func1_DO_simulate
{
    BLOCK func1_DO_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_DO_simulate_status_quality		<0xFC>,
            func1_DO_simulate_status_limit		<0x03>,
            func1_DO_simulate_value,
            func1_DO_simulation_enabled
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

MENU Page_display_func1_DO
{
    LABEL		FUNC1_DO_TITLE;
    ITEMS
    {
#ifdef FUNCX_DO_TAG_IN_PAGE_DISPLAY
        func1_DO_tag_desc							(READ_ONLY),
#endif
        Group_display_out_func1_DO_out_d,
        Group_display_out_func1_DO_readback_d,
        Group_display_func1_DO_simulation
    }
}


MENU Group_display_out_func1_DO_out_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_out_d];
    ITEMS
    {
        func1_DO_out_d_value						(READ_ONLY),
        SEPARATOR,
        func1_DO_out_d_status_quality			(READ_ONLY),
        func1_DO_out_d_status_limit			(READ_ONLY),
    }
}


MENU Group_display_out_func1_DO_readback_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_readback_d];
    ITEMS
    {
        func1_DO_readback_d_value				(READ_ONLY),
        SEPARATOR,
        func1_DO_readback_d_status_quality 	(READ_ONLY),
        func1_DO_readback_d_status_limit 	(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func1_DO
{
    LABEL		[func_simulate_value];
    ITEMS
    {
        func1_DO_simulate_value,
        SEPARATOR,
        func1_DO_simulate_status_quality,
        func1_DO_simulate_status_limit
    }
}


MENU Group_simulate_output_func1_DO
{
    LABEL		[func_out_value];
    ITEMS
    {
        func1_DO_out_d_value,
        SEPARATOR,
        func1_DO_out_d_status_quality,
        func1_DO_out_d_status_limit
    }
}


//-------------------------------------------------------------------------------------------------
//
//  ####   ###        ###
//  #   # #   #      #   #
//  #   # #   #          #
//  #   # #   #         #
//  #   # #   #        #
//  #   # #   #       #
//  ####   ###       #####
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDO2_300.ddl"
//-------------------------------------------------------------------------------------------------

#define FUNC2_DO_TITLE	"Parameter Set""|de|Parametersatz"
#define FUNC2_DO_BLOCKNUMBER	10		// DO2 = FB10
#define FUNC2_DO_GLOBAL_SIMULATION_MASK	0x00000200

#include "KNPASTDO2_300.ddl"

//-------------------------------------------------------------------------------------------------
//    VARIABLE (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 09 : SP_D --------------------------------------------------------------------------------

VARIABLE func2_DO_sp_d_value
{
    LABEL		[func_do_sp_d_value];
    HELP		[func_do_sp_d_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0x00,	"not used"	}
    }
    HANDLING	READ & WRITE;
}


//--- DO 10 : OUT_D -------------------------------------------------------------------------------

#define HANDLING_FUNC2_DO_BLK_MODE_MAN						\
        IF (func2_DO_target_mode == BLOCK_MODE_MAN)		\
        {																\
            READ & WRITE;											\
        }																\
        ELSE															\
        {																\
            READ;														\
        }

VARIABLE func2_DO_out_d_value_set_A_B
{
    LABEL		"Parameter Set""|de|Parametersatz";
    CLASS       CONTAINED & DYNAMIC;
    HELP		[func_do_out_d_value_help];
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0x00,	"Set A""|de|Satz A"	},
        { 0x01,	"Set B""|de|Satz B"	}
    }
    HANDLING	HANDLING_FUNC2_DO_BLK_MODE_MAN
}


VARIABLE func2_DO_out_d_value_card_set
{
    LABEL		"Set from card""|de|Satz von Karte";
    CLASS       CONTAINED & DYNAMIC;
    HELP		[func_do_out_d_value_help];
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0x00,	"Not from card"	"|de|Nicht von der Karte"	},
        { 0x01,	"Set 1"				"|de|Satz 1"					},
        { 0x02,	"Set 2"				"|de|Satz 2"					},
        { 0x03,	"Set 3"				"|de|Satz 3"					},
        { 0x04,	"Set 4"				"|de|Satz 4"					},
        { 0x05,	"Set 5"				"|de|Satz 5"					}
    }
    HANDLING	HANDLING_FUNC2_DO_BLK_MODE_MAN
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

func2_DO_readback_d_value_set_A_B  		LIKE VARIABLE	func2_DO_out_d_value_set_A_B
{
    REDEFINE HELP		[func_do_readback_value_help];
    REDEFINE HANDLING READ;
}


func2_DO_readback_d_value_card_set  	LIKE VARIABLE	func2_DO_out_d_value_card_set
{
    REDEFINE HELP		[func_do_readback_value_help];
    REDEFINE HANDLING READ;
}


//--- DO 21 : FSAFE_VAL_D -------------------------------------------------------------------------

func2_DO_FSafeValue							LIKE VARIABLE func2_DO_out_d_value_set_A_B
{
    REDEFINE LABEL		[func_do_fsafe_value];
    REDEFINE HELP		[func_ao_fsafe_value_help];
    REDEFINE CLASS		CONTAINED;
    REDEFINE HANDLING	READ & WRITE;
   REDEFINE VALIDITY	IF (func2_DO_FSafeType == FUNC_AI_FAIL_SAFE_VALUE)
                            {
                                TRUE;
                            }
                            ELSE
                            {
                                FALSE;
                            }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

func2_DO_simulate_value_set_A_B			LIKE VARIABLE func2_DO_readback_d_value_set_A_B
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


func2_DO_simulate_value_card_set			LIKE VARIABLE func2_DO_readback_d_value_card_set
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func2_DO_out_d
{
    BLOCK func2_DO_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func2_DO_out_d_value_card_set	<0x0E>,
            func2_DO_out_d_value_set_A_B	<0x01>,		// LSB gesetzt -> nchstes Byte
            func2_DO_out_d_status_quality	<0xFC>,
            func2_DO_out_d_status_limit	<0x03>
        }
    }
}


COMMAND write_func2_DO_out_d
{
    BLOCK func2_DO_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func2_DO_out_d_value_card_set	<0x0E>,
            func2_DO_out_d_value_set_A_B	<0x01>,		// LSB gesetzt -> nchstes Byte
            func2_DO_out_d_status_quality	<0xFC>,
            func2_DO_out_d_status_limit	<0x03>
        }
        REPLY
        {
        }
    }
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

COMMAND read_func2_DO_readback_d
{
    BLOCK func2_DO_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func2_DO_readback_d_value_card_set	<0x0E>,
            func2_DO_readback_d_value_set_A_B	<0x01>,		// LSB gesetzt -> nchstes Byte
            func2_DO_readback_d_status_quality	<0xFC>,
            func2_DO_readback_d_status_limit		<0x03>
        }
    }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func2_DO_simulate
{
    BLOCK func2_DO_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func2_DO_simulate_status_quality		<0xFC>,
            func2_DO_simulate_status_limit		<0x03>,		// LSB gesetzt -> nchstes Byte
            func2_DO_simulate_value_card_set		<0x0E>,
            func2_DO_simulate_value_set_A_B		<0x01>,		// LSB gesetzt -> nchstes Byte
            func2_DO_simulation_enabled
        }
    }
}


COMMAND write_func2_DO_simulate
{
    BLOCK func2_DO_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func2_DO_simulate_status_quality		<0xFC>,
            func2_DO_simulate_status_limit		<0x03>,		// LSB gesetzt -> nchstes Byte
            func2_DO_simulate_value_card_set		<0x0E>,
            func2_DO_simulate_value_set_A_B		<0x01>,		// LSB gesetzt -> nchstes Byte
            func2_DO_simulation_enabled
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

MENU Page_display_func2_DO
{
    LABEL		FUNC2_DO_TITLE;
    ITEMS
    {
#ifdef FUNCX_DO_TAG_IN_PAGE_DISPLAY
        func2_DO_tag_desc							(READ_ONLY),
#endif
        Group_display_out_func2_DO_out_d,
        Group_display_out_func2_DO_readback_d,
        Group_display_func2_DO_simulation
    }
}


MENU Group_display_out_func2_DO_out_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_out_d];
    ITEMS
    {
        func2_DO_out_d_value_set_A_B			(READ_ONLY),
        func2_DO_out_d_value_card_set			(READ_ONLY),
        SEPARATOR,
        func2_DO_out_d_status_quality			(READ_ONLY),
        func2_DO_out_d_status_limit			(READ_ONLY),
    }
}


MENU Group_display_out_func2_DO_readback_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_readback_d];
    ITEMS
    {
        func2_DO_readback_d_value_set_A_B 	(READ_ONLY),
        func2_DO_readback_d_value_card_set	(READ_ONLY),
        SEPARATOR,
        func2_DO_readback_d_status_quality 	(READ_ONLY),
        func2_DO_readback_d_status_limit 	(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func2_DO
{
    LABEL		[func_simulate_value];
    ITEMS
    {
        func2_DO_simulate_value_set_A_B,
        func2_DO_simulate_value_card_set,
        SEPARATOR,
        func2_DO_simulate_status_quality,
        func2_DO_simulate_status_limit
    }
}


MENU Group_simulate_output_func2_DO
{
    LABEL		[func_out_value];
    ITEMS
    {
        func2_DO_out_d_value_set_A_B,
        func2_DO_out_d_value_card_set,
        SEPARATOR,
        func2_DO_out_d_status_quality,
        func2_DO_out_d_status_limit
    }
}


//-------------------------------------------------------------------------------------------------
//
//  ####   ###        ###
//  #   # #   #      #   #
//  #   # #   #          #
//  #   # #   #        ##
//  #   # #   #          #
//  #   # #   #      #   #
//  ####   ###        ###
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDO3_300.ddl"
//-------------------------------------------------------------------------------------------------

#define DO3_UNICAL // (re!)

#ifdef DO3_UNICAL
  #define FUNC3_DO_TITLE	"Unical"		// (re!)
#else  // DO3_UNICAL
  #define FUNC3_DO_TITLE	"Polarization Voltage" "|de|Polarisationsspannung"
#endif // DO3_UNICAL
#define FUNC3_DO_BLOCKNUMBER	11		// DO3 = FB11
#define FUNC3_DO_GLOBAL_SIMULATION_MASK	0x00000400

#include "KNPASTDO3_300.ddl"

//-------------------------------------------------------------------------------------------------
//    VARIABLE (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 09 : SP_D --------------------------------------------------------------------------------

VARIABLE func3_DO_sp_d_value
{
    LABEL		[func_do_sp_d_value];
    HELP		[func_do_sp_d_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0x00,	"not used"	}
    }
    HANDLING	READ & WRITE;
}


//--- DO 10 : OUT_D -------------------------------------------------------------------------------

#ifdef DO3_UNICAL
VARIABLE func3_DO_out_d_value_unical_position
{
    LABEL		"Probe Position" "|de|Sondenstellung";
//	HELP		[func_do_out_d_value_help];
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x00;
        {	0x00,	"MEASURE" "|de|MESSEN"	},
        {	0x01,	"SERVICE" "|de|SERVICE"	}
    }
    HANDLING
        IF (func3_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


VARIABLE func3_DO_out_d_value_unical_auto
{
    LABEL		"Mode" "|de|Betriebsart";
//	HELP		[func_do_out_d_value_help];
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x00;
        {	0x00,	"Auto" 	"|de|Auto"		},
        {	0x01,	"Manual" "|de|Manuell"	},
    }
    HANDLING
        IF (func3_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


VARIABLE func3_DO_out_d_value_unical_prg
{
//	LABEL		[func_out_value];
    LABEL		"Program" "|de|Programm";
//	HELP		[func_ai_out_value_help];
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x00;
        {	0x00,	"Off"						"|de|kein Programm"	},
        {	0x01,	"Cleaning"				"|de|Reinigen"			},
        {	0x02,	"Cal 2point"			"|de|Cal 2Pkt"			},
        {	0x03,	"Cal 1point"			"|de|Cal 1Pkt"			},
        {	0x04,	"Park"					"|de|Parken"			},
        {	0x05,	"USER 1"					"|de|USER 1"			},
        {	0x06,	"USER 2"					"|de|USER 2"			}
    }
    HANDLING
        IF (func3_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


VARIABLE func3_DO_out_d_value_bit0
{
    LABEL "";
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x00;
        {	0x00,	"0" 	},
        {	0x01,	"1"	}
    }
    HANDLING
        IF (func3_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

#else  // DO3_UNICAL
VARIABLE func3_DO_out_d_value
{
    LABEL		"Polarization Voltage" "|de|Polarisationsspannung";
    CLASS		OUTPUT & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0x00;
    }
    HANDLING
        IF (func3_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}
#endif // DO3_UNICAL

//--- DO 12 : READBACK_D --------------------------------------------------------------------------

#ifdef DO3_UNICAL
VARIABLE func3_DO_readback_d_value_unical_state
{
    LABEL		"Probe Position" "|de|Sondenstellung";
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x01;
        {	0x00,	"Probe is moving"		"|de|Sonde fhrt"	},
        {	0x01,	"MEASURE"				"|de|MESSEN"		},
        {	0x02,	"SERVICE"				"|de|SERVICE"		},
        {	0x03,	"Probe is moving"		"|de|Sonde fhrt"	}
    }
    HANDLING READ;
}


VARIABLE func3_DO_readback_d_value_unical_service_switch
{
    LABEL		"Service Switch" "|de|Service Schalter";
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x00;
        {	0x00,	"Not Pressed"	"|de|Nicht bettigt"	},
        {	0x01,	"Pressed"		"|de|Bettigt"			}
    }
    HANDLING READ;
}


VARIABLE func3_DO_readback_d_value_unical_alarm
{
    LABEL		"Alarm" "|de|Alarm";
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x00;
        {	0x00,	"Not aktive"	"|de|Nicht aktiv"	},
        {	0x01,	"Aktive"			"|de|Aktiv"			}
    }
    HANDLING READ;
}


VARIABLE func3_DO_readback_d_value_unical_prg
{
    LABEL		"Program" "|de|Aktives Programm";
    CLASS		OUTPUT & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x00;
        {	0x00,	"Off"						"|de|kein Programm"	},
        {	0x01,	"Cleaning"				"|de|Reinigen"			},
        {	0x02,	"Cal 2point"			"|de|Cal 2Pkt"			},
        {	0x03,	"Cal 1point"			"|de|Cal 1Pkt"			},
        {	0x04,	"Park"					"|de|Parken"			},
        {	0x05,	"USER 1"					"|de|USER 1"			},
        {	0x06,	"USER 2"					"|de|USER 2"			}
        {	0x07,	"Service"				"|de|Service"			}
    }
    HANDLING READ;
}

#else  // DO3_UNICAL

VARIABLE func3_DO_readback_d_value
{
    LABEL		"Readback" "|de|Readback";
//	HELP		[func_do_readback_value_help];
    CLASS		OUTPUT & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE	0x00;
    }
    HANDLING READ;
}
#endif  // DO3_UNICAL

//--- DO 21 : FSAFE_VAL_D -------------------------------------------------------------------------

VARIABLE func3_DO_FSafeValue
{
    LABEL		[func_do_fsafe_value];
    HELP		[func_ao_fsafe_value_help];
    CLASS		CONTAINED;
#ifdef DO3_UNICAL
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x02;
        {	0x00,	"MEASURE" "|de|MESSEN"	},
        {	0x02,	"SERVICE" "|de|SERVICE"	}
    }
#else  // DO3_UNICAL
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE    0x00;
    }
#endif // DO3_UNICAL
    HANDLING	READ & WRITE;
   VALIDITY	IF (func3_DO_FSafeType == FUNC_AI_FAIL_SAFE_VALUE)
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

#ifdef DO3_UNICAL
func3_DO_simulate_value_unical_state		LIKE VARIABLE func3_DO_readback_d_value_unical_state
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


func3_DO_simulate_value_unical_service_switch		LIKE VARIABLE func3_DO_readback_d_value_unical_service_switch
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


func3_DO_simulate_value_unical_alarm		LIKE VARIABLE func3_DO_readback_d_value_unical_alarm
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


func3_DO_simulate_value_unical_prg			LIKE VARIABLE func3_DO_readback_d_value_unical_prg
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}

#else   // DO3_UNICAL

func3_DO_simulate_value		LIKE VARIABLE func3_DO_readback_d_value
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}
#endif  // DO3_UNICAL

//-------------------------------------------------------------------------------------------------
//    COMMAND (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func3_DO_out_d
{
    BLOCK func3_DO_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
#ifdef DO3_UNICAL
            func3_DO_out_d_value_unical_prg 			<0xE0>,
            func3_DO_out_d_value_unical_auto 	   <0x04>,
            func3_DO_out_d_value_unical_position 	<0x02>,
            func3_DO_out_d_value_bit0					<0x01>,	// LSB gesetzt -> nchstes Byte
#else  // DO3_UNICAL
            func3_DO_out_d_value,
#endif // DO3_UNICAL
            func3_DO_out_d_status_quality				<0xFC>,
            func3_DO_out_d_status_limit				<0x03>
        }
    }
}


COMMAND write_func3_DO_out_d
{
    BLOCK func3_DO_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
#ifdef DO3_UNICAL
            func3_DO_out_d_value_unical_prg 			<0xE0>,
            func3_DO_out_d_value_unical_auto 	   <0x04>,
            func3_DO_out_d_value_unical_position 	<0x02>,
            func3_DO_out_d_value_bit0					<0x01>,	// LSB gesetzt -> nchstes Byte
#else  // DO3_UNICAL
            func3_DO_out_d_value,
#endif // DO3_UNICAL
            func3_DO_out_d_status_quality				<0xFC>,
            func3_DO_out_d_status_limit				<0x03>
        }
        REPLY
        {
        }
    }
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

COMMAND read_func3_DO_readback_d
{
    BLOCK func3_DO_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
#ifdef DO3_UNICAL
            func3_DO_readback_d_value_unical_prg				<0xE0>,
            func3_DO_readback_d_value_unical_alarm				<0x08>,
            func3_DO_readback_d_value_unical_service_switch	<0x04>,
            func3_DO_readback_d_value_unical_state				<0x03>,	// LSB gesetzt -> nchstes Byte
#else   // DO3_UNICAL
            func3_DO_readback_d_value,
#endif  // DO3_UNICAL
            func3_DO_readback_d_status_quality					<0xFC>,
            func3_DO_readback_d_status_limit						<0x03>
        }
    }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func3_DO_simulate
{
    BLOCK func3_DO_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func3_DO_simulate_status_quality						<0xFC>,
            func3_DO_simulate_status_limit						<0x03>,	// LSB gesetzt -> nchstes Byte
#ifdef DO3_UNICAL
            func3_DO_simulate_value_unical_prg					<0xE0>,
            func3_DO_simulate_value_unical_alarm				<0x08>,
            func3_DO_simulate_value_unical_service_switch	<0x04>,
            func3_DO_simulate_value_unical_state				<0x03>,	// LSB gesetzt -> nchstes Byte
#else   // DO3_UNICAL
            func3_DO_simulate_value,
#endif  // DO3_UNICAL
            func3_DO_simulation_enabled
        }
    }
}


COMMAND write_func3_DO_simulate
{
    BLOCK func3_DO_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func3_DO_simulate_status_quality						<0xFC>,
            func3_DO_simulate_status_limit						<0x03>,	// LSB gesetzt -> nchstes Byte
#ifdef DO3_UNICAL
            func3_DO_simulate_value_unical_prg					<0xE0>,
            func3_DO_simulate_value_unical_alarm				<0x08>,
            func3_DO_simulate_value_unical_service_switch	<0x04>,
            func3_DO_simulate_value_unical_state				<0x03>,	// LSB gesetzt -> nchstes Byte
#else   // DO3_UNICAL
            func3_DO_simulate_value,
#endif  // DO3_UNICAL
            func3_DO_simulation_enabled
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

MENU Page_display_func3_DO
{
    LABEL		FUNC3_DO_TITLE;
    ITEMS
    {
#ifdef FUNCX_DO_TAG_IN_PAGE_DISPLAY
        func3_DO_tag_desc								(READ_ONLY),
#endif
        Group_display_out_func3_DO_out_d,
        Group_display_out_func3_DO_readback_d,
        Group_display_func3_DO_simulation
    }
}


MENU Group_display_out_func3_DO_out_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_out_d];
    ITEMS
    {
#ifdef DO3_UNICAL
        func3_DO_out_d_value_unical_position	(READ_ONLY),
        func3_DO_out_d_value_unical_auto	   	(READ_ONLY),
        func3_DO_out_d_value_unical_prg			(READ_ONLY),
#else   // DO3_UNICAL
        func3_DO_out_d_value							(READ_ONLY),
#endif  // DO3_UNICAL
        SEPARATOR,
        func3_DO_out_d_status_quality				(READ_ONLY),
        func3_DO_out_d_status_limit				(READ_ONLY)
    }
}


MENU Group_display_out_func3_DO_readback_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_readback_d];
    ITEMS
    {
#ifdef DO3_UNICAL
        func3_DO_readback_d_value_unical_state				(READ_ONLY),
        func3_DO_readback_d_value_unical_alarm				(READ_ONLY),
        func3_DO_readback_d_value_unical_service_switch	(READ_ONLY),
        func3_DO_readback_d_value_unical_prg				(READ_ONLY),
#else   // DO3_UNICAL
        func3_DO_readback_d_value								(READ_ONLY),
#endif  // DO3_UNICAL
        SEPARATOR,
        func3_DO_readback_d_status_quality					(READ_ONLY),
        func3_DO_readback_d_status_limit						(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func3_DO
{
    LABEL		[func_simulate_value];
    ITEMS
    {
#ifdef DO3_UNICAL
        func3_DO_simulate_value_unical_state,
        func3_DO_simulate_value_unical_alarm,
        func3_DO_simulate_value_unical_service_switch,
        func3_DO_simulate_value_unical_prg,
#else   // DO3_UNICAL
        func3_DO_simulate_value,
#endif  // DO3_UNICAL
        SEPARATOR,
        func3_DO_simulate_status_quality,
        func3_DO_simulate_status_limit
    }
}


MENU Group_simulate_output_func3_DO
{
    LABEL		[func_out_value];
    ITEMS
    {
#ifdef DO3_UNICAL
        func3_DO_out_d_value_unical_position,
        func3_DO_out_d_value_unical_auto,
        func3_DO_out_d_value_unical_prg,
#else   // DO3_UNICAL
        func3_DO_out_d_value,
#endif  // DO3_UNICAL
        SEPARATOR,
        func3_DO_out_d_status_quality,
        func3_DO_out_d_status_limit
    }
}


//-------------------------------------------------------------------------------------------------
//
//  ####   ###           #
//  #   # #   #         #
//  #   # #   #        #
//  #   # #   #       #
//  #   # #   #      ######
//  #   # #   #          #
//  ####   ###           #
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDO4_300.ddl"
//-------------------------------------------------------------------------------------------------

#define FUNC4_DO_TITLE	"Lock""|de|Freigabe"
#define FUNC4_DO_BLOCKNUMBER	14		// DO4 = FB14
#define FUNC4_DO_GLOBAL_SIMULATION_MASK	0x00002000

#include "KNPASTDO4_300.ddl"

//-------------------------------------------------------------------------------------------------
//    VARIABLE (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 09 : SP_D --------------------------------------------------------------------------------

VARIABLE func4_DO_sp_d_value
{
    LABEL		[func_do_sp_d_value];
    HELP		[func_do_sp_d_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0x00,	"Measure (locked)""|de|Messmodus (gesperrt)"		},
        { 0x01,	"Unlocked""|de|Freigegeben"							},
        { 0x02,	"Busy""|de|Warten..."									}
    }
    HANDLING	READ & WRITE;
}


//--- DO 10 : OUT_D -------------------------------------------------------------------------------

func4_DO_out_d_value	  						LIKE VARIABLE	func4_DO_sp_d_value
{
    REDEFINE LABEL		"Lock-State""|de|Freigabe-Besttigung";
    REDEFINE HELP		[func_do_out_d_value_help];
    REDEFINE HANDLING
        IF (func4_DO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

VARIABLE func4_DO_readback_d_value_lock_state
{
    LABEL		"Lock-State""|de|Freigabe-Anforderung";
    HELP		[func_do_readback_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0x00,	"Measure (locked)""|de|Messmodus (gesperrt)"											},
        { 0x01,	"Unlock Request (unacknowledged)""|de|Freigabeanforderung (unbesttigt)"	},
        { 0x02,	"Unlock Request (acknowledged)""|de|Freigabeanforderung (besttigt)"			},
        { 0x03,	"Unlocked""|de|Freigegeben"																}
    }
    HANDLING	READ;
}


VARIABLE func4_DO_readback_d_value_dummy
{
    LABEL		"DO4 readback dummy bits";
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0x00,	"not used"	}
    }
    HANDLING	READ;
}


//--- DO 21 : FSAFE_VAL_D -------------------------------------------------------------------------

func4_DO_FSafeValue							LIKE VARIABLE func4_DO_out_d_value
{
    REDEFINE LABEL		[func_do_fsafe_value];
    REDEFINE HELP		[func_ao_fsafe_value_help];
    REDEFINE CLASS		CONTAINED;
    REDEFINE HANDLING	READ & WRITE;
   REDEFINE VALIDITY	IF (func4_DO_FSafeType == FUNC_AI_FAIL_SAFE_VALUE)
                            {
                                TRUE;
                            }
                            ELSE
                            {
                                FALSE;
                            }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

func4_DO_simulate_value_lock_state		LIKE VARIABLE func4_DO_readback_d_value_lock_state
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


func4_DO_simulate_value_dummy				LIKE VARIABLE func4_DO_readback_d_value_dummy
{
    REDEFINE HELP		[func_ai_simulate_value_help];
    REDEFINE CLASS		CONTAINED & SERVICE;
    REDEFINE HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DO Parameter)
//-------------------------------------------------------------------------------------------------

//--- DO 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func4_DO_out_d
{
    BLOCK func4_DO_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_out_d_value				<0x03>,	// LSB gesetzt -> nchstes Byte
            func4_DO_out_d_status_quality	<0xFC>,
            func4_DO_out_d_status_limit	<0x03>
        }
    }
}


COMMAND write_func4_DO_out_d
{
    BLOCK func4_DO_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_out_d_value				<0x03>,	// LSB gesetzt -> nchstes Byte
            func4_DO_out_d_status_quality	<0xFC>,
            func4_DO_out_d_status_limit	<0x03>
        }
        REPLY
        {
        }
    }
}


//--- DO 12 : READBACK_D --------------------------------------------------------------------------

COMMAND read_func4_DO_readback_d
{
    BLOCK func4_DO_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_readback_d_value_lock_state	<0xC0>,
            func4_DO_readback_d_value_dummy			<0x3F>,	// LSB gesetzt -> nchstes Byte
            func4_DO_readback_d_status_quality		<0xFC>,
            func4_DO_readback_d_status_limit			<0x03>
        }
    }
}


//--- DO 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func4_DO_simulate
{
    BLOCK func4_DO_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func4_DO_simulate_status_quality		<0xFC>,
            func4_DO_simulate_status_limit		<0x03>,	// LSB gesetzt -> nchstes Byte
            func4_DO_simulate_value_lock_state	<0xC0>,
            func4_DO_simulate_value_dummy			<0x3F>, 	// LSB gesetzt -> nchstes Byte
            func4_DO_simulation_enabled
        }
    }
}


COMMAND write_func4_DO_simulate
{
    BLOCK func4_DO_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func4_DO_simulate_status_quality		<0xFC>,
            func4_DO_simulate_status_limit		<0x03>,	// LSB gesetzt -> nchstes Byte
            func4_DO_simulate_value_lock_state	<0xC0>,
            func4_DO_simulate_value_dummy			<0x3F>, 	// LSB gesetzt -> nchstes Byte
            func4_DO_simulation_enabled
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

MENU Page_display_func4_DO
{
    LABEL		FUNC4_DO_TITLE;
    ITEMS
    {
#ifdef FUNCX_DO_TAG_IN_PAGE_DISPLAY
        func4_DO_tag_desc							(READ_ONLY),
#endif
        Group_display_out_func4_DO_out_d,
        Group_display_out_func4_DO_readback_d,
        Group_display_func4_DO_simulation
    }
}


MENU Group_display_out_func4_DO_out_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_out_d];
    ITEMS
    {
        func4_DO_out_d_value						(READ_ONLY),
        SEPARATOR,
        func4_DO_out_d_status_quality			(READ_ONLY),
        func4_DO_out_d_status_limit			(READ_ONLY),
    }
}


MENU Group_display_out_func4_DO_readback_d
{
    LABEL		[menu_OnlineWindow_func_DO_display_readback_d];
    ITEMS
    {
        func4_DO_readback_d_value_lock_state	(READ_ONLY),
        SEPARATOR,
        func4_DO_readback_d_status_quality 		(READ_ONLY),
        func4_DO_readback_d_status_limit 		(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func4_DO
{
    LABEL		[func_simulate_value];
    ITEMS
    {
        func4_DO_simulate_value_lock_state,
        SEPARATOR,
        func4_DO_simulate_status_quality,
        func4_DO_simulate_status_limit
    }
}


MENU Group_simulate_output_func4_DO
{
    LABEL		[func_out_value];
    ITEMS
    {
        func4_DO_out_d_value
        SEPARATOR,
        func4_DO_out_d_status_quality,
        func4_DO_out_d_status_limit
    }
}



