
// for method device_self_test and other
#define UPDATE_IN_PROGRESS      8
#define DEVICE_BUSY             32
#define MAXIMUM_RESET_RETRIES   10

#ifndef DIA_PV_OUT_OF_LIMITS
#define DIA_PV_OUT_OF_LIMITS				0x01
#endif

#ifndef DIA_NON_PV_OUT_OF_LIMITS
#define DIA_NON_PV_OUT_OF_LIMITS			0x02
#endif

#ifndef DIA_PV_ANALOG_OUTPUT_SATURATED
#define DIA_PV_ANALOG_OUTPUT_SATURATED		0x04
#endif

#ifndef DIA_PV_ANALOG_OUTPUT_FIXED
#define DIA_PV_ANALOG_OUTPUT_FIXED			0x08
#endif

#ifndef DIA_MORE_STATUS_AVAILABLE
#define DIA_MORE_STATUS_AVAILABLE			0x10
#endif

#ifndef DIA_COLD_START
#define DIA_COLD_START						0x20
#endif

#ifndef DIA_CONFIGURATION_CHANGED
#define DIA_CONFIGURATION_CHANGED			0x40
#endif

#ifndef DIA_DEVICE_MALFUNCTION
#define DIA_DEVICE_MALFUNCTION				0x80
#endif

// Channel definition
	#define DEV_VAR_PH1  	0
	#define DEV_VAR_ORP1  1
	#define DEV_VAR_TMP1  2



#define SEL_CNTR_PARSET							0
#define SEL_CNTR_IN_FLOW						1

#define PV_CHANNEL					0  // Index in scaling array for channel output
#define SV_CHANNEL					1
#define TV_CHANNEL					2
#define QV_CHANNEL					3

#define PARA_SET_A					0
#define PARA_SET_B					1

#define	ONE_CHANNEL					0
#define	TWO_CHANNEL					1

#define	TWO_WIRE						0
#define	FOUR_WIRE						1

#define	NONE_EX_DEVICE			0
#define	EX_DEVICE						1

#define ONE_OUTPUT					0
#define TWO_OUTPUT					1

	#define	SENSOR_STANDARD			0
	#define	SENSOR_ISFET				1
	#define	SENSOR_INDUCON			2
	#define	SENSOR_ISM_DISO			3
	#define	SENSOR_MEMOSENS			4
#define CORR_SEL_OFF					0
#define CORR_SEL_LIN					1
#define CORR_SEL_USER_TAB			2
#define CORR_SEL_PURE_WATER		3






// Menu Mode of Device
#define MENU_MODE_MEAS				0
#define MENU_MODE_DIAG				1
#define MENU_MODE_CAL					2
#define MENU_MODE_CONF				3
#define MENU_MODE_Serv				4

#define DEF_SENS_GOOD				0
#define DEF_SENS_MEDIUM			1
#define DEF_SENS_BAD				2
#define DEF_SENS_UNKNOWN		3


/* array index*/
#define	FIRST_CHANNEL						0
#define	SECOND_CHANNEL					1
#define	DEF_PARA_A_OUT1					0
#define	DEF_PARA_B_OUT1					1
#define	DEF_PARA_A_OUT2					2
#define	DEF_PARA_B_OUT2					3
#define DEF_PARA_A_MINMAX_MIN 	0
#define DEF_PARA_B_MINMAX_MIN 	1
#define DEF_PARA_A_MINMAX_MAX 	2
#define DEF_PARA_B_MINMAX_MAX 	3


#define SENS1_INFO_TYPE         0
#define SENS1_INFO_MANF					1
#define SENS1_INFO_DESC					2
#define SENS1_INFO_NUMB					3
#define SENS1_INFO_LAST_CALIB		4
#define SENS2_INFO_TYPE					5
#define SENS2_INFO_MANF					6
#define SENS2_INFO_DESC					7
#define	SENS2_INFO_NUMB					8
#define	SENS2_INFO_LAST_CALIB		9

#define SERIAL_DEVICE_SOFT_VERSION					0
#define SERIAL_DEVICE_HARD_VERSION					1
#define SERIAL_DEVICE_SERIALNUMBER					2
#define SERIAL_DEVICE_IF3000_SOFT_VERSION		4
#define SERIAL_CHANNEL1_SOFT_VERSION				7
#define SERIAL_CHANNEL1_HARD_VERSION				8
#define SERIAL_CHANNEL1_SERIALNUMBER				9
#define SERIAL_CHANNEL2_SOFT_VERSION				11
#define SERIAL_CHANNEL2_HARD_VERSION				12
#define SERIAL_CHANNEL2_SERIALNUMBER				13

	#define CALIBR_VALUES_ZERO								0
	#define CALIBR_VALUES_SLOPE								1
	#define CALIBR_VALUES_ISFET_OFFSET				2
	#define CALIBR_VALUES_TIME_NEXT_CALIB			3

#define PROC_VALUES_RESISTANCE						0
#define PROC_VALUES_TEMPERATURE						1
#define PROC_VALUES_IMP_GLASS_ELECTRODE   2
#define PROC_VALUES_IMP_REF_ELECTRODE			3
#define PROC_VALUES_PH										4
#define PROC_VALUES_ORP										5
#define PROC_VALUES_GLASS_PH							6
#define PROC_VALUES_GLASS_ORP							7
#define PROC_VALUES_IN_CURRENT						8
#define PROC_VALUES_FLOW									9

/* DSM  Info */
#define DSM_INFO_VALUES_SENS_OPERATION_TIME  		0
#define DSM_INFO_VALUES_SENS_WEAR								1
#define DSM_INFO_VALUES_SENS_REMAIN_TIME	  		2
#define DSM_INFO_VALUES_CIP_COUNTER				  		3
#define DSM_INFO_VALUES_SIP_COUNTER				  		4
#define DSM_INFO_VALUES_AUTOCLAVE_CYCLES				5
#define DSM_INFO_VALUES_DLI											6
#define DSM_INFO_VALUES_AD_CALIB_TIMER					7
#define DSM_INFO_VALUES_TIME_TO_MAINTENANCE			8


/**************/

#define	DISABLED						0
#define ENABLED							1

#define SENSOR_DISCONNECTED	0
#define SENSOR_CONNECTED		1


/* RTD Type*/
#define	TYPE_100PT					0
#define	TYPE_1000PT					1
#define	TYPE_8_55K_NTC			2
#define	TYPE_NTC855K_Bet  	3 // Betatherm (Cond/CondI)
#define TYPE_30_NTC					5
#define TYPE_BALCO_3k				8
/* end RTD Type*/

#define	MODE_AUTO						0
#define	MODE_MAN						1
#define	MODE_EXT						2
#define	MODE_DAT						2

#define SENS_MODE_OFF			0
#define SENS_MODE_AUTO		1
#define SENS_MODE_MAN			2


#define	BUFFER_MT						1
#define	BUFFER_KNICK_CALI		2
#define	BUFFER_CIBA					3
#define	BUFFER_NIST_TECH		4
#define	BUFFER_NIST_STD			5
#define	BUFFER_HACH					6
#define	BUFFER_WTW					7
#define	BUFFER_HAMILTON			8
#define	BUFFER_REAGECON			9
#define	BUFFER_DIN					10
#define	BUFFER_U1						11
#define	SEL_OFF							0
#define	SEL_ON							1

#define BUFFER_CHECK_FAILED_OK			0
#define BUFFER_CHECK_FAILED					1
#define TC_VALUES_CHECK_OK					0
#define TC_VALUES_CHECK_FAILED			1

#define DEF_NO											0
#define DEF_YES											1


// 22mA fail
#define	SEL_FAIL_OFF						0
#define	SEL_FAIL_ON							1

	#define	SEL_FIX							1
	#define	SEL_ADAPT						2
	#define	SEL_LAST						3

// out range, input type
#define	RANGE_0_20					0
#define	RANGE_4_20					1

#define	CTR_TYPE_PLC				0
#define	CTR_TYPE_PFC				1

#define	WASH_WASH						0
//#define	WASH_EASYCLEAN			1		// only pH-devices
#define	WASH_PARAMETERSET		1


#define	MIN_MAX_LIMIT				0
#define	MIN_MAX_CONTROLER		1
#define	MIN_MAX_USP					2

#define N_OPEN							0
#define N_CLOSE							1

#define CNTR_INPUT_PARSET   0
#define MANUAL_PARSET				1
#define A_FIX_PARSET				2

//logbook
#define MESSAGE_STATIC			0
#define MESSAGE_BEGIN				1
#define MESSAGE_END					2
#define MESSAGE_FLOAT				3
#define MESSAGE_U32					4
#define MESSAGE_ASC					5

#define CYCLE_TIME_PV_CHART 				3000 // 3s update time
#define CYCLE_TIME_SV_CHART 				3000 // 3s update time
#define CYCLE_TIME_CURRENT_CHART		3000 // 3s update time

#define UNIT_PH		[pH]
#define UNIT_MV		[mV]
#define UNIT_TEMP_C	"C"
#define UNIT_TEMP_F	"F"
#define UNIT_MA		[mA]
#define UNIT_PERC		"%"
#define UNIT_HOURS	"h"
#define UNIT_SEC		"s"
#define UNIT_TC		"%/K"

#define UNITS_CODE_EMPTY			0
#define UNITS_CODE_PH			59
#define UNITS_CODE_ORP		36
#define UNITS_CODE_MV			36
#define UNITS_CODE_TEMP_C	32
#define UNITS_CODE_TEMP_F	33
#define UNITS_CODE_TEMP_K	35
#define UNITS_CODE_L_h		138


#define UNITS_CODE_OHM      37
#define UNITS_CODE_K_OHM   163

#define UNITS_CODE_SEC    51
#define UNITS_CODE_HOUR 	52

#define UNITS_CODE_M_A		39

#define UNITS_CODE_PERCENT	57
//#define UNITS_CODE_MG_L
#define UNITS_CODE_PPM     139
#define UNITS_CODE_BAR       7

#define UNITS_CODE_DAY   53
#define UNITS_CODE_HOUR 52



#define DEVICE_FAMILY_PH				8
#define DEVICE_FAMILY_TEMP			4
#define DEVICE_FAMILY_NOT_USED	250

#define CLASSIFICATION_PH							81
#define CLASSIFICATION_TEMP 					64
#define CLASSIFICATION_CONCENTRATION	90

#define UPPER_LIMIT_PH			  16.0
#define UPPER_LIMIT_ORP			1500.0

#define LOWER_LIMIT_PH			  -2.0
#define LOWER_LIMIT_ORP		 -1500.0


#define UPPER_LIMIT_OXY				600.0
#define LOWER_LIMIT_OXY				  0.0


#define _24H							0
#define _12H							1

#define DISPLAY_PH							 ".2f"
#define DISPLAY_ORP							 ".0f"
//#define DISPLAY_MV						 ".0f"
#define DISPLAY_TEMP_C					 ".1f"
#define DISPLAY_TEMP_F					"5.0f"
#define DISPLAY_CURR						"4.1f"
#define DISPLAY_PERC						"5.1f"
#define DISPLAY_SLOPE						"5.0f"
#define DISPLAY_SEC							"5.1f"
#define DISPLAY_TC							"5.2f"
#define DISPLAY_OXY							 ".2f"



#define MIN_ASYM_POT_MV								  -60.0
#define MAX_ASYM_POT_MV									 60.0

#define MIN_SLOPE												 85.0
#define MAX_SLOPE												103.0
/*
#define DEF_MEAS_MODE 		 0
#define DEF_HOLD_MODE 		 1
#define DEF_PCAL_SENS1 		 2
#define DEF_PCAL_SENS2 		 4
#define DEF_CAL 					 8
#define DEF_CONF 					16
#define DEF_SERVICE 			32
#define DEF_DIG					 	24
*/

#define USED_UNITS      UNITS_CODE (UNITS_CODE_MV), UNITS_CODE (UNITS_CODE_PH)
#define TEMP_UNITS      UNITS_CODE (UNITS_CODE_TEMP_C), UNITS_CODE (UNITS_CODE_TEMP_F)



#define DEVICE_UNITS \
		{ UNITS_CODE_EMPTY,			str_Unit_empty}, \
			UNITS_CODE(32), \
			UNITS_CODE(33), \
			UNITS_CODE(34), \
			UNITS_CODE(35), \
			UNITS_CODE(1), \
			UNITS_CODE(2), \
			UNITS_CODE(3), \
			UNITS_CODE(4), \
			UNITS_CODE(5), \
			UNITS_CODE(6), \
			UNITS_CODE(7), \
			UNITS_CODE(8), \
			UNITS_CODE(9), \
			UNITS_CODE(10), \
			UNITS_CODE(11), \
			UNITS_CODE(12), \
			UNITS_CODE(13), \
			UNITS_CODE(14), \
			UNITS_CODE(145), \
			UNITS_CODE(237), \
			UNITS_CODE(238), \
			UNITS_CODE(239), \
			UNITS_CODE(15), \
			UNITS_CODE(16), \
			UNITS_CODE(17), \
			UNITS_CODE(18), \
			UNITS_CODE(19), \
			UNITS_CODE(22), \
			UNITS_CODE(23), \
			UNITS_CODE(24), \
			UNITS_CODE(25), \
			UNITS_CODE(26), \
			UNITS_CODE(27), \
			UNITS_CODE(28), \
			UNITS_CODE(29), \
			UNITS_CODE(30), \
			UNITS_CODE(31), \
			UNITS_CODE(121), \
			UNITS_CODE(122), \
			UNITS_CODE(123), \
			UNITS_CODE(130), \
			UNITS_CODE(131), \
			UNITS_CODE(132), \
			UNITS_CODE(133), \
			UNITS_CODE(134), \
			UNITS_CODE(135), \
			UNITS_CODE(136), \
			UNITS_CODE(137), \
			UNITS_CODE(138), \
			UNITS_CODE(235), \
			UNITS_CODE(20), \
			UNITS_CODE(21), \
			UNITS_CODE(114), \
			UNITS_CODE(115), \
			UNITS_CODE(116), \
			UNITS_CODE(120), \
			UNITS_CODE(40), \
			UNITS_CODE(41), \
			UNITS_CODE(42), \
			UNITS_CODE(43), \
			UNITS_CODE(46), \
			UNITS_CODE(110), \
			UNITS_CODE(111), \
			UNITS_CODE(112), \
			UNITS_CODE(113), \
			UNITS_CODE(124), \
			UNITS_CODE(166), \
			UNITS_CODE(167), \
			UNITS_CODE(168), \
			UNITS_CODE(236), \
			UNITS_CODE(44), \
			UNITS_CODE(45), \
			UNITS_CODE(47), \
			UNITS_CODE(48), \
			UNITS_CODE(49), \
			UNITS_CODE(50), \
			UNITS_CODE(51), \
			UNITS_CODE(52), \
			UNITS_CODE(53), \
			UNITS_CODE(60), \
			UNITS_CODE(61), \
			UNITS_CODE(62), \
			UNITS_CODE(63), \
			UNITS_CODE(64), \
			UNITS_CODE(65), \
			UNITS_CODE(125), \
			UNITS_CODE(70), \
			UNITS_CODE(71), \
			UNITS_CODE(72), \
			UNITS_CODE(73), \
			UNITS_CODE(74), \
			UNITS_CODE(75), \
			UNITS_CODE(76), \
			UNITS_CODE(77), \
			UNITS_CODE(78), \
			UNITS_CODE(79), \
			UNITS_CODE(80), \
			UNITS_CODE(81), \
			UNITS_CODE(82), \
			UNITS_CODE(83), \
			UNITS_CODE(84), \
			UNITS_CODE(85), \
			UNITS_CODE(86), \
			UNITS_CODE(87), \
			UNITS_CODE(88), \
			UNITS_CODE(90), \
			UNITS_CODE(91), \
			UNITS_CODE(92), \
			UNITS_CODE(93), \
			UNITS_CODE(94), \
			UNITS_CODE(95), \
			UNITS_CODE(96), \
			UNITS_CODE(97), \
			UNITS_CODE(98), \
			UNITS_CODE(99), \
			UNITS_CODE(100), \
			UNITS_CODE(102), \
			UNITS_CODE(103), \
			UNITS_CODE(104), \
			UNITS_CODE(146), \
			UNITS_CODE(147), \
			UNITS_CODE(54), \
			UNITS_CODE(55), \
			UNITS_CODE(36), \
			UNITS_CODE(58), \
			UNITS_CODE(39), \
			UNITS_CODE(37), \
			UNITS_CODE(163), \
			UNITS_CODE(69), \
			UNITS_CODE(89), \
			UNITS_CODE(126), \
			UNITS_CODE(128), \
			UNITS_CODE(162), \
			UNITS_CODE(164), \
			UNITS_CODE(165), \
			UNITS_CODE(127), \
			UNITS_CODE(129), \
			UNITS_CODE(140), \
			UNITS_CODE(141), \
			UNITS_CODE(142), \
			UNITS_CODE(117), \
			UNITS_CODE(118), \
			UNITS_CODE(119), \
			UNITS_CODE(38), \
			UNITS_CODE(56), \
			UNITS_CODE(57), \
			UNITS_CODE(59), \
			UNITS_CODE(66), \
			UNITS_CODE(67), \
			UNITS_CODE(68), \
			UNITS_CODE(101), \
			UNITS_CODE(105), \
			UNITS_CODE(106), \
			UNITS_CODE(107), \
			UNITS_CODE(108), \
			UNITS_CODE(109), \
			UNITS_CODE(139), \
			UNITS_CODE(143), \
			UNITS_CODE(144), \
			UNITS_CODE(148), \
			UNITS_CODE(149), \
			UNITS_CODE(150), \
			UNITS_CODE(151), \
			UNITS_CODE(152), \
			UNITS_CODE(153), \
			UNITS_CODE(154), \
			UNITS_CODE(155), \
			UNITS_CODE(160), \
			UNITS_CODE(161), \
			UNITS_CODE(169), \
			UNITS_CODE(250), \
			UNITS_CODE(251), \
			UNITS_CODE(252), \
			UNITS_CODE(253)


#define DEF_ENUM_LIST_UNITS	\
			DEVICE_UNITS



#define DEF_ENUM_LIST_SENSOFACE \
		{DEF_SENS_GOOD,		str_sensoface_good},\
		{DEF_SENS_MEDIUM,	str_sensoface_medium},\
		{DEF_SENS_BAD,		str_sensoface_bad},\
		{DEF_SENS_UNKNOWN,str_sensoface_unknown}


/* var def macros */

#define DEF_TYPE_RANGE_CURRENT_ENUM 	TYPE	ENUMERATED\
														{{RANGE_0_20, str_Range_0_20_mA},\
														{RANGE_4_20, str_Range_4_20_mA}}\
														DEFAULT_VALUE		RANGE_4_20;

#define DEF_TYPE_PH_ENUM_UNIT_SELECT(index) TYPE	ENUMERATED (2)\
	{	IF (index==0) { UNITS_CODE(UNITS_CODE_PH)  } \
		ELSE\
		{ IF (index==1)	{UNITS_CODE(UNITS_CODE_ORP)}\
			ELSE {TEMP_UNITS}}}

#define DEF_TYPE_OXY_ENUM_UNIT_SELECT(index) TYPE	ENUMERATED (2)\
	{	IF (index==0) { UNITS_CODE(UNITS_CODE_)  } \
		ELSE\
		{ IF (index==1)	{UNITS_CODE(UNITS_CODE_)}\
			ELSE {TEMP_UNITS}}}

#define DEF_TYPE_PH_FLOAT_LIMIT_MIN_MAX(CHANNEL,TEMP_UNIT)	TYPE	FLOAT { \
				MIN_VALUE		SELECT ( CHANNEL ) {	\
											CASE 0:	-2.0; \
											CASE 1: -1999.0; \
											CASE 2: IF ( TEMP_UNIT == UNITS_CODE_TEMP_C) {-20.0;} ELSE {-4.0;}	} \
				MAX_VALUE		SELECT (CHANNEL) {\
											CASE 0:	16.0; \
											CASE 1:	1999.0; \
											CASE 2:	IF (TEMP_UNIT == UNITS_CODE_TEMP_C) {300.0;} ELSE {572.0;}}}






#define DEF_CONSTANT_UNIT_PH_CHANNEL_TEMP_UNIT(CHANNEL,TEMP_UNIT) \
						CONSTANT_UNIT	SELECT ( CHANNEL ) { \
									CASE 0:	[pH]; \
									CASE 1:	[mV]; \
									CASE 2:	IF (SENSOR_1_Temp_Unit == UNITS_CODE_TEMP_C) {[degC];} ELSE {[degF];}\
									CASE 3: [l_hr];}







#define 	DEF_DISPLAY_FORMAT_MEASUREMENT_VALUE(VAR_CODE) \
					DISPLAY_FORMAT  SELECT (VAR_CODE) \
										{\
											CASE DEV_VAR_PH1:		DISPLAY_PH;\
											CASE DEV_VAR_ORP1:	DISPLAY_ORP;\
											CASE DEV_VAR_TMP1:	DISPLAY_TEMP_C;\
											DEFAULT: ".2f";	}

#define	DEF_TYPE_ENUM_AUTO_MAN_EXT	TYPE	ENUMERATED\
	{	{MODE_AUTO,	str_Auto},	{MODE_MAN,	str_Man}	IF(DevConf_I_Input==ENABLED)	{{MODE_EXT,	str_Ext}}	}


#define DEF_TYPE_ENUM_OFF_ON_DEFAULT_OFF TYPE ENUMERATED\
					{	{SEL_OFF,	str_Off}, {SEL_ON,	str_On} 	}\
					DEFAULT_VALUE SEL_OFF;

#define DEF_TYPE_ENUM_FAIL_OFF_ON_DEFAULT_OFF TYPE ENUMERATED\
					{	{SEL_FAIL_OFF,	str_Off}, {SEL_FAIL_ON,	str_On}	}\
					DEFAULT_VALUE SEL_FAIL_OFF;

#define DEF_TYPE_FLOAT_MIN_MAX_TEMP_UNIT(temp_unit)	TYPE	FLOAT { \
		MIN_VALUE	SELECT (temp_unit){ \
								CASE UNITS_CODE_TEMP_C:	-20.0; \
								CASE UNITS_CODE_TEMP_F:	-4.0; \
								DEFAULT:	-20.0;}\
		MAX_VALUE	SELECT (temp_unit){\
								CASE UNITS_CODE_TEMP_C:	200.0; \
								CASE UNITS_CODE_TEMP_F:	392.0;\
								DEFAULT:	392.0;}}
								
#define DEF_TYPE_FLOAT_MIN_MAX_TEMP_UNIT_DISPL_1(temp_unit)	TYPE	FLOAT { \
		MIN_VALUE	SELECT (temp_unit){ \
								CASE UNITS_CODE_TEMP_C:	-20.0; \
								CASE UNITS_CODE_TEMP_F:	-4.0; \
								DEFAULT:	-20.0;}\
		MAX_VALUE	SELECT (temp_unit){\
								CASE UNITS_CODE_TEMP_C:	200.0; \
								CASE UNITS_CODE_TEMP_F:	392.0;\
								DEFAULT:	392.0;} \
		DISPLAY_FORMAT  ".1f";}



		#define DEF_VALIDITY_CORRECTION VALIDITY \
						IF((SENSOR_1_Temp_Meas==MODE_EXT)||(SENSOR_1_Temp_Cal==MODE_EXT))\
							{TRUE;}ELSE{FALSE;}




#define IF_SENSOR_TYPE_OXY_ANALOG(SENSOR_TYPE) \
			IF ((SENSOR_TYPE==SENSOR_STANDARD_oxy)||\
				  (SENSOR_TYPE==SENSOR_TRACES_oxy)||\
					(SENSOR_TYPE==SENSOR_SUBTRACES_oxy))\
				{TRUE;}ELSE{FALSE;}
#define IF_SENSOR_TYPE_OXY_NOT_ANALOG(SENSOR_TYPE) \
			IF ((SENSOR_TYPE!=SENSOR_STANDARD_oxy)&&\
				  (SENSOR_TYPE!=SENSOR_TRACES_oxy)&&\
					(SENSOR_TYPE!=SENSOR_SUBTRACES_oxy))\
				{TRUE;}ELSE{FALSE;}


	#define DEF_MIN_MAX_CHANNEL_PH \
			{0, str_pH_Label},\
			{1, str_ORP__Label},\
			{2, str_TEMP__Label},\
			{3, str_FLOW__Label}	

	#define DEF_CTR_CHANNEL_PH \
			{0, str_pH_Label},\
			{1, str_ORP__Label},\
			{2, str_TEMP__Label}
		


/****************** device variable list for specific devices and common *************/
	#define		DEVICE_VARIABLE_LIST_PH_CH1 \
			DEV_VAR_PH1,		device_var1_Ch1,			str_DevVar1_Label;\
			DEV_VAR_ORP1,		device_var2_Ch1,			str_ORP_Label;\
			DEV_VAR_TMP1,		temp_device_var_Ch1,	str_Temp_Label;	

		#define ENUM_DEVICE_VARIABLE_LIST_PH_CH1 \
			TYPE ENUMERATED(1) \
			{		{DEV_VAR_PH1,		str_pH}, \
					{DEV_VAR_ORP1,	str_ORP}, \
					{DEV_VAR_TMP1,	str_Temp}}
	








/****************** END  --  Device variable list for specific devices and common *************/

/* 375: transparence only available at gif, not available at png */
/* PDM not support transparence */
/* SDC625 support transparence (gif and png) */
#define IMAGE_PARASET_A				"paraset_A.gif"
#define IMAGE_PARASET_B				"paraset_B.gif"
			#define IMAGE_DEVICE					"KNA211PHdevice.gif"
			#define IMAGE_MANUFAC					"KNA211PHlogo.gif"


#define IMAGE_HOLD						"hold.gif"
#define IMAGE_SMILEY_GOOD			"smiley_good.gif"
#define IMAGE_SMILEY_MED			"smiley_med.gif"
#define IMAGE_SMILEY_BAD			"smiley_bad.gif"

#define IMAGE_NOT_HOLD				"not_hold.gif"
#define IMAGE_NO_SMILEY				"no_smiley.gif"

/***********************************************************/
#define MAIN_MENUE_ENTRIES  /* device_setup_page,*/	\
		process_variables_page,			\
		diag_service_page,					\
		Show_Logbook,								\
		device_information,					\
		SEPARATOR, 									\
		detailed_setup_page,


#define	READ_DEVICE_CONFIG					128
/* Sensor */
#define	READ_PH_SENSOR_DATA					129
#define	WRITE_PH_SENSOR_DATA				130
#define	READ_NOMINAL_ZERO_SLOPE			131
#define	WRITE_NOMINAL_ZERO_SLOPE		132

#define	READ_DEV_VAR_ASSIGNMENT			139
#define	WRITE_DEV_VAR_ASSIGNMENT		140
/* OUT */
#define	READ_PH_OUT_DATA						141
#define	WRITE_PH_OUT_DATA						142
//#define	READ_CO2_OUT_DATA						149
//#define	WRITE_CO2_OUT_DATA					150

/* CORRECTION */
#define	READ_PH_CORRECTION_DATA			151
#define	WRITE_PH_CORRECTION_DATA		152
//#define	READ_CO2_CORRECTION_DATA		159
//#define	WRITE_CO2_CORRECTION_DATA		160

#define	READ_CONTROL_INPUT_DATA			159
#define	WRITE_CONTROL_INPUT_DATA		160

#define	READ_ALARM_DATA							161
#define	WRITE_ALARM_DATA						162
#define	READ_MIN_MAX_RELAIS_SELECT	163
#define	WRITE_MIN_MAX_RELAIS_SELECT	164
#define	READ_MIN_MAX_RELAIS					165
#define	WRITE_MIN_MAX_RELAIS				166
#define	READ_CTR_DATA								167
#define	WRITE_CTR_DATA							168
#define READ_USP_DATA 							169
#define WRITE_USP_DATA							170
#define	READ_WASH_DATA							171
#define	WRITE_WASH_DATA							172
#define	READ_CLOCK_DATA							173
#define	WRITE_CLOCK_DATA						174
#define	READ_LOGBOOK_ENTRIES				175

#define STORE_PROCESS_VALUE					176
#define READ_CALIB_VALUE						177
#define WRITE_CALIB_LAB_VALUE				178
#define READ_SLOPE_ZERO_VAL					179

#define WRITE_ACTIVE_PARASET_CONF		180
#define READ_CONF_PARSET						181
#define WRITE_CONF_PARSET						182

#define READ_DEVICE_TAG							183
#define WRITE_DEVICE_TAG						184
#define READ_SENSOR_INFO						185
#define READ_OUT_UNIT								186
#define READ_SERIAL_NUMBERS					187
#define READ_CALIBRATION_VALUES			188
#define READ_PROCESS_VALUES					189
#define READ_DSM_INFO								190
#define READ_LAST_CALIB_DATE				191

#define READ_BUFFER_VALUES					192
#define WRITE_BUFFER_VALUES					193
#define READ_BUFFER_CONS_CHECK			194
#define READ_TC_VALUES							195
#define WRITE_TC_VALUES							196
#define READ_TC_VALUES_CONS_CHECK		197


// CMD specific defines

#define RES_SUCCESS 									0
#define RES_INVALID_SELECTION 				2
#define RES_PARAM_TOO_LARGE 					3
#define RES_PARAM_TOO_SMALL 					4
#define RES_TOO_FEW_DATA 							5
#define RES_DEVICE_SPEC_CMD_ERROR			6
#define RES_IN_WRITE_PROTECT 					7
#define RES_ACCESS_RESTRICTED				 16
#define RES_DEVICE_BUSY							 32
#define RES_CMD_NOT_IMPL						 64


#define SEND_CMD_AND_CHECK_STATUS(CMD_NUM) send(CMD_NUM, status); \
		if(status[STATUS_RESPONSE_CODE] != RES_SUCCESS) \
		{ if((status[STATUS_RESPONSE_CODE] == RES_INVALID_SELECTION) \
			|| (status[STATUS_RESPONSE_CODE] == RES_PARAM_TOO_LARGE) \
			|| (status[STATUS_RESPONSE_CODE] == RES_PARAM_TOO_SMALL) \
			|| (status[STATUS_RESPONSE_CODE] == RES_TOO_FEW_DATA) \
			|| (status[STATUS_RESPONSE_CODE] == RES_DEVICE_SPEC_CMD_ERROR) \
			|| (status[STATUS_RESPONSE_CODE] == RES_IN_WRITE_PROTECT) \
			|| (status[STATUS_RESPONSE_CODE] == RES_ACCESS_RESTRICTED)) \
			{ display_response_status(CMD_NUM, status[STATUS_RESPONSE_CODE]);}}

#define SEND_CMD_AND_CHECK_STATUS_TRANS(CMD_NUM,TRANS_NUM) send_trans(CMD_NUM,TRANS_NUM, status); \
		if(status[STATUS_RESPONSE_CODE] != RES_SUCCESS) \
		{ if((status[STATUS_RESPONSE_CODE] == RES_INVALID_SELECTION) \
			|| (status[STATUS_RESPONSE_CODE] == RES_PARAM_TOO_LARGE) \
			|| (status[STATUS_RESPONSE_CODE] == RES_PARAM_TOO_SMALL) \
			|| (status[STATUS_RESPONSE_CODE] == RES_TOO_FEW_DATA) \
			|| (status[STATUS_RESPONSE_CODE] == RES_DEVICE_SPEC_CMD_ERROR) \
			|| (status[STATUS_RESPONSE_CODE] == RES_IN_WRITE_PROTECT) \
			|| (status[STATUS_RESPONSE_CODE] == RES_ACCESS_RESTRICTED)) \
			{ display_response_status(CMD_NUM, status[STATUS_RESPONSE_CODE]);}}


#define DEF_COMMON_CMD_SETTING(NUMBER_OF_RETRIES) \
                SET_NUMBER_OF_RETRIES(NUMBER_OF_RETRIES); \
                RETRY_ON_NO_DEVICE(); \
                IGNORE_ALL_RESPONSE_CODES(); \
                IGNORE_ALL_DEVICE_STATUS(); \
                XMTR_IGNORE_ALL_RESPONSE_CODES(); \
                XMTR_IGNORE_ALL_DEVICE_STATUS();


	#define DEF_READ_A_PH_CONFIG_DATA \
			sensor_index_code=FIRST_CHANNEL; \
			send_command(READ_PH_SENSOR_DATA);\
			send_command(READ_NOMINAL_ZERO_SLOPE);\
			ParaSetValues_OUT_code=DEF_PARA_A_OUT1;\
			send_command(READ_PH_OUT_DATA); \
			ParaSetValues_OUT_code=DEF_PARA_A_OUT1;\
			send_command(READ_OUT_UNIT); \
			ParaSetValues_OUT_code=DEF_PARA_A_OUT2;\
			send_command(READ_PH_OUT_DATA); \
			ParaSetValues_OUT_code=DEF_PARA_A_OUT2;\
			send_command(READ_OUT_UNIT); \
			ParaSetValues_code=PARA_SET_A;\
			send_command(READ_PH_CORRECTION_DATA);\
			ParaSetValues_code=PARA_SET_A;\
			send_command(READ_ALARM_DATA); \
			send_command(READ_CONF_PARSET)

	#define DEF_READ_B_PH_CONFIG_DATA \
			ParaSetValues_OUT_code=DEF_PARA_B_OUT1;\
			send_command(READ_PH_OUT_DATA); \
			ParaSetValues_OUT_code=DEF_PARA_B_OUT1;\
			send_command(READ_OUT_UNIT); \
			ParaSetValues_OUT_code=DEF_PARA_B_OUT2;\
			send_command(READ_PH_OUT_DATA); \
			ParaSetValues_OUT_code=DEF_PARA_B_OUT2;\
			send_command(READ_OUT_UNIT); \
			ParaSetValues_code=PARA_SET_B;\
			send_command(READ_PH_CORRECTION_DATA);\
			ParaSetValues_code=PARA_SET_B;\
			send_command(READ_ALARM_DATA)

#define DEF_READ_A_TC_VALUES_CONFIG_DATA \
		iassign(TC_Values_index_code,0);\
		send_command(READ_TC_VALUES);\
		iassign(TC_Values_index_code,1);\
		send_command(READ_TC_VALUES);
		
#define DEF_READ_B_TC_VALUES_CONFIG_DATA \
		iassign(TC_Values_index_code,2);\
		send_command(READ_TC_VALUES);\
		iassign(TC_Values_index_code,3);\
		send_command(READ_TC_VALUES)
		
#define DEF_WRITE_A_TC_VALUES_CONFIG_DATA \
		iassign(TC_Values_index_code,0);\
		send_command(WRITE_TC_VALUES);\
		iassign(TC_Values_index_code,1);\
		send_command(WRITE_TC_VALUES);
		
#define DEF_WRITE_B_TC_VALUES_CONFIG_DATA \
		iassign(TC_Values_index_code,2);\
		send_command(WRITE_TC_VALUES);\
		iassign(TC_Values_index_code,3);\
		send_command(WRITE_TC_VALUES)

	#define DEF_READ_BUFFER_CONFIG_DATA\
		iassign(buffer_index_code,0);\
		send_command(READ_BUFFER_VALUES);\
		iassign(buffer_index_code,1);\
		send_command(READ_BUFFER_VALUES);\
		iassign(buffer_index_code,2);\
		send_command(READ_BUFFER_VALUES);\
		iassign(buffer_index_code,3);\
		send_command(READ_BUFFER_VALUES)
		
	#define DEF_WRITE_BUFFER_CONFIG_DATA\
		iassign(buffer_index_code,0);\
		send_command(WRITE_BUFFER_VALUES);\
		iassign(buffer_index_code,1);\
		send_command(WRITE_BUFFER_VALUES);\
		iassign(buffer_index_code,2);\
		send_command(WRITE_BUFFER_VALUES);\
		iassign(buffer_index_code,3);\
		send_command(WRITE_BUFFER_VALUES)

		





// define for upload / download_variables
/* Sensor */
	#define DEF_SENSOR_1_PARA_INFO \
		SENSOR_1_Info_Sensor_Type,\
		SENSOR_1_Info_Manufac_Desc,\
		SENSOR_1_Info_Sensor_Desc,\
		SENSOR_1_Info_Sensor_Number,\
		SENSOR_1_Info_Last_Calib

	#define DEF_SENSOR_1_PARA \
		/*Arr_Sensor[FIRST_CHANNEL].SENSOR_SERIAL_NUMBER,*/\
		Arr_Sensor[FIRST_CHANNEL].SENSOR_TYPE, \
		Arr_Sensor[FIRST_CHANNEL].RTD_TYPE,\
		Arr_Sensor[FIRST_CHANNEL].TEMP_UNIT,\
		Arr_Sensor[FIRST_CHANNEL].MEAS,\
		Arr_Sensor[FIRST_CHANNEL].MEAS_VALUE,\
		Arr_Sensor[FIRST_CHANNEL].TEMP_CAL,\
		Arr_Sensor[FIRST_CHANNEL].TEMP_CAL_VALUE,\
		Arr_Sensor[FIRST_CHANNEL].CALMODE,\
		Arr_Sensor[FIRST_CHANNEL].BUFFER_SET,\
		Arr_Sensor[FIRST_CHANNEL].CAL_TIMER,\
		Arr_Sensor[FIRST_CHANNEL].CAL_CYCLE,\
		Arr_Sensor[FIRST_CHANNEL].CIP_COUNT,\
		Arr_Sensor[FIRST_CHANNEL].CIP_CYCLE,\
		Arr_Sensor[FIRST_CHANNEL].SIP_COUNT,\
		Arr_Sensor[FIRST_CHANNEL].SIP_CYCLE,\
		Arr_Sensor[FIRST_CHANNEL].ACT_MODE,\
		Arr_Sensor[FIRST_CHANNEL].ACT_CYCLE,\
		Arr_Sensor[FIRST_CHANNEL].TTM_MODE,\
		Arr_Sensor[FIRST_CHANNEL].TTM_CYCLE,\
		Arr_Sensor[FIRST_CHANNEL].AUTOCLAVE_COUNT,\
		Arr_Sensor[FIRST_CHANNEL].AUTOCLAVE_CYCLES,\
		Arr_Sensor[FIRST_CHANNEL].NOM_ZERO_VALUE,\
		Arr_Sensor[FIRST_CHANNEL].NOM_SLOPE_VALUE,\
		Arr_Sensor[FIRST_CHANNEL].PH_ISO_VALUE
			
		
		







		#define DEF_OUT_PARA \
			DEF_OUT_PARA_PDM_LIST,\
			A_OUT_1_Face22mA,\
			A_OUT_2_Face22mA,\
			B_OUT_1_Face22mA,\
			B_OUT_2_Face22mA

#define DEF_OUT_PARA_PDM_LIST \
		A_OUT_1_Range,\
		A_OUT_1_Channel,\
		A_OUT_1_Begin,\
		A_OUT_1_End,\
		A_OUT_1_Filtertime,\
		A_OUT_1_22mA_Fail,\
		A_OUT_1_HoldMode,\
		A_OUT_1_Hold_Fix,\
		A_OUT_2_Range,\
		A_OUT_2_Channel,\
		A_OUT_2_Begin,\
		A_OUT_2_End,\
		A_OUT_2_Filtertime,\
		A_OUT_2_22mA_Fail,\
		A_OUT_2_HoldMode,\
		A_OUT_2_Hold_Fix,\
		B_OUT_1_Range,\
		B_OUT_1_Channel,\
		B_OUT_1_Begin,\
		B_OUT_1_End,\
		B_OUT_1_Filtertime,\
		B_OUT_1_22mA_Fail,\
		B_OUT_1_HoldMode,\
		B_OUT_1_Hold_Fix,\
		B_OUT_2_Range,\
		B_OUT_2_Channel,\
		B_OUT_2_Begin,\
		B_OUT_2_End,\
		B_OUT_2_Filtertime,\
		B_OUT_2_22mA_Fail,\
		B_OUT_2_HoldMode,\
		B_OUT_2_Hold_Fix


	#define DEF_CORRECTION_PARA \
		ParaSetValues[PARA_SET_A].CORRECTION_TC_SELECT,\
		ParaSetValues[PARA_SET_A].CORRECTION_TC_LIQUID,\
		ParaSetValues[PARA_SET_A].CORRECTION_I_INPUT,\
		ParaSetValues[PARA_SET_A].CORRECTION_BEGIN,\
		ParaSetValues[PARA_SET_A].CORRECTION_END,\
		ParaSetValues[PARA_SET_B].CORRECTION_TC_SELECT,\
		ParaSetValues[PARA_SET_B].CORRECTION_TC_LIQUID,\
		ParaSetValues[PARA_SET_B].CORRECTION_I_INPUT,\
		ParaSetValues[PARA_SET_B].CORRECTION_BEGIN,\
		ParaSetValues[PARA_SET_B].CORRECTION_END

#define DEF_CNTR_IN_PARA \
		CNTR_IN_Control_Mode,\
		CNTR_IN_Flow_Adjust

#define	DEF_ALARM_PARA \
		ParaSetValues[PARA_SET_A].ALARM_DELAY_TIME,\
		ParaSetValues[PARA_SET_A].ALARM_SENSO_CHECK,\
		ParaSetValues[PARA_SET_A].ALARM_FLOW_CTRL,\
		ParaSetValues[PARA_SET_A].ALARM_FLOW_MIN,\
		ParaSetValues[PARA_SET_A].ALARM_FLOW_MAX,\
		ParaSetValues[PARA_SET_B].ALARM_DELAY_TIME,\
		ParaSetValues[PARA_SET_B].ALARM_SENSO_CHECK,\
		ParaSetValues[PARA_SET_B].ALARM_FLOW_CTRL,\
		ParaSetValues[PARA_SET_B].ALARM_FLOW_MIN,\
		ParaSetValues[PARA_SET_B].ALARM_FLOW_MAX


#define DEF_TC_VALUES \
		Arr_TC_Values[0].FIRST_BUFF,\
		Arr_TC_Values[0].SECOND_BUFF,\
		Arr_TC_Values[0].THIRD_BUFF,\
		Arr_TC_Values[0].FOURTH_BUFF,\
		Arr_TC_Values[0].FIFTH_BUFF,\
		Arr_TC_Values[0].SIXTH_BUFF,\
		Arr_TC_Values[0].SEVENTH_BUFF,\
		Arr_TC_Values[0].EIGHTH_BUFF,\
		Arr_TC_Values[0].NINTH_BUFF,\
		Arr_TC_Values[0].TENTH_BUFF,\
		Arr_TC_Values[1].FIRST_BUFF,\
		Arr_TC_Values[1].SECOND_BUFF,\
		Arr_TC_Values[1].THIRD_BUFF,\
		Arr_TC_Values[1].FOURTH_BUFF,\
		Arr_TC_Values[1].FIFTH_BUFF,\
		Arr_TC_Values[1].SIXTH_BUFF,\
		Arr_TC_Values[1].SEVENTH_BUFF,\
		Arr_TC_Values[1].EIGHTH_BUFF,\
		Arr_TC_Values[1].NINTH_BUFF,\
		Arr_TC_Values[1].TENTH_BUFF,\
		Arr_TC_Values[2].FIRST_BUFF,\
		Arr_TC_Values[2].SECOND_BUFF,\
		Arr_TC_Values[2].THIRD_BUFF,\
		Arr_TC_Values[2].FOURTH_BUFF,\
		Arr_TC_Values[2].FIFTH_BUFF,\
		Arr_TC_Values[2].SIXTH_BUFF,\
		Arr_TC_Values[2].SEVENTH_BUFF,\
		Arr_TC_Values[2].EIGHTH_BUFF,\
		Arr_TC_Values[2].NINTH_BUFF,\
		Arr_TC_Values[2].TENTH_BUFF,\
		Arr_TC_Values[3].FIRST_BUFF,\
		Arr_TC_Values[3].SECOND_BUFF,\
		Arr_TC_Values[3].THIRD_BUFF,\
		Arr_TC_Values[3].FOURTH_BUFF,\
		Arr_TC_Values[3].FIFTH_BUFF,\
		Arr_TC_Values[3].SIXTH_BUFF,\
		Arr_TC_Values[3].SEVENTH_BUFF,\
		Arr_TC_Values[3].EIGHTH_BUFF,\
		Arr_TC_Values[3].NINTH_BUFF,\
		Arr_TC_Values[3].TENTH_BUFF

#define DEF_CLOCK_PARA \
		Device_Time_Hour,\
		Device_Time_Minutes,\
		Device_Time_Milliseconds,\
		Device_Time_Standard_Summer,\
		Device_Date



#define DEF_MSG_ID \
		{  0, str_MsgID_No_Failure},\
		{  1, str_MsgID_Invalid_Parameter},\
		{  2, str_MsgID_Invalid_Span_Out2},\
		{  3, str_MsgID_Invalid_Span_Out1},\
		{  4, str_MsgID_Output2_Too_High},\
		{  5, str_MsgID_Output2_Too_Low},\
		{  6, str_MsgID_Output1_Too_High},\
		{  7, str_MsgID_Output1_Too_Low},\
		{  8, str_MsgID_Output_Burden},\
		{  9, str_MsgID_NoFailure},\
		{ 10, str_MsgID_NoFailure},\
		{ 11, str_MsgID_NoFailure},\
		{ 12, str_MsgID_NoFailure},\
		{ 13, str_MsgID_NoFailure},\
		{ 14, str_MsgID_NoFailure},\
		{ 15, str_MsgID_NoFailure},\
		{ 16, str_MsgID_NoFailure},\
		{ 17, str_MsgID_NoFailure},\
		{ 18, str_MsgID_NoFailure},\
		{ 19, str_MsgID_NoFailure},\
		{ 20, str_MsgID_Sens1_Sensocheck_Ref_El},\
		{ 21, str_MsgID_Sens1_Sensocheck_Glas_El},\
		{ 22, str_MsgID_Sens1_Range_ORP},\
		{ 23, str_MsgID_Sens1_Range_PH},\
		{ 24, str_MsgID_Sens1_Range_Temp},\
		{ 25, str_MsgID_Sens1_Range_MV},\
		{ 26, str_MsgID_Sens1_Cal_Data},\
		{ 27, str_MsgID_Sens1_Sensor_Failure},\
		{ 28, str_MsgID_Sens1_Canceled_Sensor},\
		{ 29, str_MsgID_Sens1_Wrong_Sensor},\
		{ 30, str_MsgID_Sens1_No_Sensor},\
		{ 31, str_MsgID_Wrong_Module},\
		{ 32, str_MsgID_No_Module_Installed},\
		{ 33, str_MsgID_System_Failure},\
		{ 34, str_MsgID_Configuration_Error},\
		{ 35, str_MsgID_Device_Failure},\
		{ 36, str_MsgID_Sip_Cycle},\
		{ 37, str_MsgID_Cip_Cycle},\
		{ 38, str_MsgID_Calibration},\
		{ 39, str_MsgID_Service},\
		{ 40, str_MsgID_ParaSet_A},\
		{ 41, str_MsgID_ParaSet_B},\
		{ 42, str_MsgID_Configuration},\
		{ 43, str_MsgID_Door_Open},\
		{ 44, str_MsgID_Power},\
		{ 45, str_MsgID_Temp_Outside_Table},\
		{ 46, str_MsgID_NoFailure},\
		{ 47, str_MsgID_NoFailure},\
		{ 48, str_MsgID_NoFailure},\
		{ 49, str_MsgID_NoFailure},\
		{ 50, str_MsgID_NoFailure},\
		{ 51, str_MsgID_NoFailure},\
		{ 52, str_MsgID_NoFailure},\
		{ 53, str_MsgID_NoFailure},\
		{ 54, str_MsgID_NoFailure},\
		{ 55, str_MsgID_NoFailure},\
		{ 56, str_MsgID_NoFailure},\
		{ 57, str_MsgID_NoFailure},\
		{ 58, str_MsgID_NoFailure},\
		{ 59, str_MsgID_Sens1_Memosens},\
		{ 60, str_MsgID_Sens1_ISM_Sens},\
		{ 61, str_MsgID_Sens1_Inducon},\
		{ 62, str_MsgID_Sens1_PH},\
		{ 63, str_MsgID_Sens1_TMAX},\
		{ 64, str_MsgID_Sens1_Slope_Percent},\
		{ 65, str_MsgID_Sens1_Zero_mV},\
		{ 66, str_MsgID_Sens1_Sip_Cycles_Overrun},\
		{ 67, str_MsgID_Sens1_Cip_Cycles_Overrun},\
		{ 68, str_MsgID_Sens1_Sensor_Wear},\
		{ 69, str_MsgID_Sens1_Sensor_Drift},\
		{ 70, str_MsgID_Sens1_Sensor_Zero_Slope},\
		{ 71, str_MsgID_Sens1_Out_Of_Cal_Time},\
		{ 72, str_MsgID_FailureBufferSet},\
		{ 73, str_MsgID_ParaCtrlInvalid},\
		{ 74, str_MsgID_InvalidSpanInput},\
		{ 75, str_MsgID_Sens1_ISFET_ZERO_CalibOrChange},\
		{ 76, str_MsgID_NoFailure},\
		{ 77, str_MsgID_Flow_to_Low},\
		{ 78, str_MsgID_Flow_to_High},\
		{ 79, str_MsgID_Invalid_Relais_Channel},






