/* ----------------------------------------------------------------------

 FILE_NAME          ai7.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
 ###   #####   ###
 #   #    #    #  #
 #   #    #       #
 #####    #       #
 #   #  #####     #
 ------------------------------------------------------
 */

IMPORT "PI/0000_4007_0302_0001_ai7.ddl"
{

    EVERYTHING;

    REDEFINITIONS
    {

		REDEFINE VARIABLE func7_AI_OUT_Value
		{
			LABEL [PI_OUT_Value_label];
			HELP [PI_OUT_Value_help];
			CLASS OUTPUT & DYNAMIC;
			HANDLING IF (func7_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
			TYPE FLOAT { DISPLAY_FORMAT DEF_DISPLAY_FORMAT(func7_AI_OUT_SCALE_Decimal_Point); }
		}
		
        REDEFINE VARIABLE func7_AI_OUT_SCALE_Units_Index
        {
            LABEL [PI_PRIMARY_VALUE_UNIT_label];
            HELP [PI_PRIMARY_VALUE_UNIT_help];
            CLASS CONTAINED & SERVICE;
            TYPE ENUMERATED(2)
            {
                DEFAULT_VALUE 1342;
                AI_UNIT_LIST
            }
        }

        REDEFINE VARIABLE func7_AI_CHANNEL
        {
            LABEL "AI7 " + [PI_CHANNEL_label];
            HELP [PI_CHANNEL_help];
            CLASS CONTAINED;			
            TYPE ENUMERATED (2)
            {
                SELECT ( meas_type )
                {
                    CASE MEAS_TYPE_PH: AI_CHANNEL_LIST_PH
                    CASE MEAS_TYPE_COND: AI_CHANNEL_LIST_COND
                    CASE MEAS_TYPE_CONDI: AI_CHANNEL_LIST_CONDI
                    CASE MEAS_TYPE_CC: AI_CHANNEL_LIST_CC
                    CASE MEAS_TYPE_OXY: AI_CHANNEL_LIST_OXY
                    //DEFAULT: AI_CHANNEL_LIST
                }
            }
            HANDLING READ & WRITE;
            POST_EDIT_ACTIONS {method_func7_set_default_unit}
        }
		
	}
	
}

ARRAY OF VARIABLE refarray_func7_AI_CHANNEL
{
    LABEL "";	
    ELEMENTS
    {
        0, func7_AI_CHANNEL;
        1, func7_AI_CHANNEL;
        2, func7_AI_CHANNEL;
        3, func7_AI_CHANNEL;
        4, func7_AI_CHANNEL;
    }
}

/*
 ####################################
 Configuration vom AI
 ####################################
 */
MENU output_ai7_window
{
    LABEL [LABEL_AI7];
    STYLE WINDOW;
    ITEMS
    {
        meas_type(HIDDEN),
        conf_out_ai7_ident,
        conf_out_ai7_process,
        conf_out_ai7_alarm,
        conf_out_ai7_fail,
        conf_out_ai7_batch
    }
    POST_READ_ACTIONS {method_refresh_ai_chanels(1)}
}

MENU out_ai7_value
{
    LABEL [PI_display_measure];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_OUT_SCALE_Units_Index (HIDDEN),
        refarray_func7_AI_CHANNEL[meas_type] (READ_ONLY),
        ROWBREAK,
        func7_AI_OUT_Value (READ_ONLY),
        ROWBREAK,
        func7_AI_OUT_Status_Condensed (READ_ONLY)
    }
}

/* TAG... */
MENU conf_out_ai7_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func7_AI_TAG_DESC,
        func7_AI_STRATEGY,
        func7_AI_ST_REV
    }
}

/* OUT,CHANNEL... */
MENU conf_out_ai7_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        refarray_func7_AI_CHANNEL[meas_type],
        func7_AI_PV_FTIME,
        func7_AI_PV_SCALE_Lower_Value,
        func7_AI_PV_SCALE_Upper_Value,
        func7_AI_OUT_SCALE_Lower_Value,
        func7_AI_OUT_SCALE_Upper_Value,
		//    func7_AI_OUT_SCALE_Units_Index(READ_ONLY),
        func7_AI_OUT_SCALE_Decimal_Point
    }
}

/* Alarm, limits... */
MENU conf_out_ai7_alarm
{
    LABEL TXT_FB_ALARM;
    STYLE GROUP;
    ITEMS
    {
        func7_AI_HI_HI_LIM,
        func7_AI_HI_LIM,
        func7_AI_LO_LIM,
        func7_AI_LO_LO_LIM,
        func7_AI_ALARM_HYS
    }
}

/* fail safe... */
MENU conf_out_ai7_fail
{
    LABEL TXT_FB_FAIL;
    STYLE GROUP;
    ITEMS
    {
        func7_AI_FSAFE_TYPE,
        func7_AI_FSAFE_VALUE
    }
}

/* Batch.. */
MENU conf_out_ai7_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func7_AI_BATCH_Batch_ID,
        func7_AI_BATCH_Rup,
        func7_AI_BATCH_Operation,
        func7_AI_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_ai7_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func7_AI_TARGET_MODE,
        func7_AI_MODE_BLK_Actual,
        func7_AI_SIMULATE_Enabled,
        func7_AI_SIMULATE_Value,
        func7_AI_SIMULATE_Status_Condensed
    }
}

MENU out_ai7_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_MODE_BLK_Actual,
        ROWBREAK ,
        func7_AI_SIMULATE_Enabled (READ_ONLY)
    }
}

MENU simulation_window_ai7
{
    LABEL [LABEL_AI7];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
		func7_AI_OUT_SCALE_Units_Index (HIDDEN),

		func7_AI_CHANNEL (READ_ONLY),
        simulation_wnd_ai7_input,
        simulation_wnd_ai7_output
    }
}
MENU simulation_wnd_ai7_input
{
    LABEL TXT_AI_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func7_AI_SIMULATE_Enabled,
        func7_AI_SIMULATE_Value,
        func7_AI_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_ai7_output
{
    LABEL TXT_AI_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func7_AI_TARGET_MODE,
        func7_AI_MODE_BLK_Actual,
        func7_AI_OUT_Value,
        func7_AI_OUT_Status_Condensed
    }
}
/*
 ####################################
 Diagnose vom AI
 ####################################
 */
MENU output_ai7_diag_window
{
    LABEL "Output AI7";
    STYLE WINDOW;
    ITEMS
    {
        diag_out_ai7_alarm
    }
}

/* Alarms... */
MENU diag_out_ai7_alarm
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        func7_AI_ALARM_SUM_Current,
        func7_AI_ALARM_SUM_Unacknowledged,
        func7_AI_ALARM_SUM_Unreported,
        func7_AI_ALARM_SUM_Disabled,
        func7_AI_HI_HI_ALM_Unacknowledged,
        func7_AI_HI_HI_ALM_Alarm_State,
        //func7_AI_HI_HI_ALM_Time_Stamp,
        func7_AI_HI_HI_ALM_Subcode,
        func7_AI_HI_HI_ALM_Value,
        /* -------------------------- */
        func7_AI_HI_ALM_Unacknowledged,
        func7_AI_HI_ALM_Alarm_State,
        // func7_AI_HI_ALM_Time_Stamp,
        func7_AI_HI_ALM_Subcode,
        func7_AI_HI_ALM_Value,
        /* -------------------------- */
        func7_AI_LO_ALM_Unacknowledged,
        func7_AI_LO_ALM_Alarm_State,
        // func7_AI_LO_ALM_Time_Stamp,
        func7_AI_LO_ALM_Subcode,
        func7_AI_LO_ALM_Value,
        /* -------------------------- */
        func7_AI_LO_LO_ALM_Unacknowledged,
        func7_AI_LO_LO_ALM_Alarm_State,
        // func7_AI_LO_LO_ALM_Time_Stamp,
        func7_AI_LO_LO_ALM_Subcode,
        func7_AI_LO_LO_ALM_Value
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

SOURCE ai7_value_source
{
	LABEL [LABEL_AI7];
    Y_AXIS func7_AI_Display_BarVal_out_axis_mandatory_B;
    MEMBERS
    {
        PRIM_VAL, func7_AI_OUT_Value;
    }
}

CHART ai7_value_chart
{
    LABEL "AI7 Value";
    TYPE HORIZONTAL_BAR;    //GAUGE;
    MEMBERS {CHART1, ai7_value_source;}
}

/* Messwerte */
MENU display_out_func7_AI
{
    LABEL [LABEL_AI7];
    ITEMS 
	{
		meas_type (HIDDEN),
		phys_FEATURE_Enabled (HIDDEN),
		
        out_ai7_value,
        ROWBREAK,
        out_ai7_simu,
        ROWBREAK,
        out_ai7_alarms
    }
    //POST_READ_ACTIONS{ method_refresh_ai_chanels(1) }
}
MENU func7_AI_ovw
{
    LABEL [LABEL_AI7];
	STYLE GROUP;
    ITEMS 
	{
		meas_type (HIDDEN),		
        func7_AI_OUT_SCALE_Units_Index (HIDDEN),
		phys_FEATURE_Enabled (HIDDEN),
				
		func7_AI_CHANNEL (READ_ONLY),
		func7_AI_OUT_Value,        
        func7_AI_OUT_Status_Condensed
    }
}

/* Alarme */

MENU out_ai7_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_ALARM_SUM_Current
    }
}

MENU overview_ai7_alarms
{
    LABEL [LABEL_AI7];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_ALARM_SUM_Current
		/*
		,
        COLUMNBREAK,
		func7_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func7_AI_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func7_AI_ALARM_SUM_Disabled		
		*/
    }
}

//MENU OnlineWindow_S_alarm_func7_AI
MENU Win_alarm_func7_AI
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        alarm_sum_func7_AI,
        alarm_hi_hi_alm_func7_AI,
        alarm_hi_alm_func7_AI,
        alarm_lo_alm_func7_AI,
        alarm_lo_lo_alm_func7_AI
    }
}

MENU alarm_sum_func7_AI
{
    LABEL [PI_ALARM_SUM_label];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_ALARM_SUM_Current,
        func7_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func7_AI_ALARM_SUM_Unreported,
        func7_AI_ALARM_SUM_Disabled
    }
}

MENU alarm_hi_hi_alm_func7_AI
{
    LABEL [PI_HI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_HI_HI_ALM_Unacknowledged,
        func7_AI_HI_HI_ALM_Alarm_State,
        //func7_AI_HI_HI_ALM_Time_Stamp,
        func7_AI_HI_HI_ALM_Subcode,
        func7_AI_HI_HI_LIM (READ_ONLY),
        func7_AI_HI_HI_ALM_Value
    }
}

MENU alarm_hi_alm_func7_AI
{
    LABEL [PI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_HI_ALM_Unacknowledged,
        func7_AI_HI_ALM_Alarm_State,
        //func7_AI_HI_ALM_Time_Stamp,
        func7_AI_HI_ALM_Subcode,
        func7_AI_HI_LIM (READ_ONLY),
        func7_AI_HI_ALM_Value
    }
}

MENU alarm_lo_alm_func7_AI
{
    LABEL [PI_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_LO_ALM_Unacknowledged,
        func7_AI_LO_ALM_Alarm_State,
        //func7_AI_LO_ALM_Time_Stamp,
        func7_AI_LO_ALM_Subcode,
        func7_AI_LO_LIM (READ_ONLY),
        func7_AI_LO_ALM_Value
    }
}

MENU alarm_lo_lo_alm_func7_AI
{
    LABEL [PI_LO_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func7_AI_LO_LO_ALM_Unacknowledged,
        func7_AI_LO_LO_ALM_Alarm_State,
        //func7_AI_LO_LO_ALM_Time_Stamp,
        func7_AI_LO_LO_ALM_Subcode,
        func7_AI_LO_LO_LIM (READ_ONLY),
        func7_AI_LO_LO_ALM_Value
    }
}

METHOD method_func7_set_default_unit
{
    LABEL "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    DEFINITION {func7_AI_OUT_SCALE_Units_Index = method_set_default_unit(func7_AI_CHANNEL);}
}

UNIT func7_AI_OUT_SCALE_unit_x
{
	func7_AI_OUT_SCALE_Units_Index:			
	func7_AI_SIMULATE_Value
}
