
/*
 * $Id$
 * 
 * Copyright (C) PI 2007-2012. All rights reserved.
 * 
 * Version: 2.0.5
 * 
 */

/**
 * \file 0000_4201_0302_0001.ddl
 * \brief Function Block Analog Output 'V3.02'.
 * This file contains all definitions for Function Block Analog Output Profile Version 3.02
 * 
 * \section func1_AO_import How to import
 * For use of all mandatory parameters for a Class A device use the macro USE_FUNC1_AO_MANDATORY_A.
 * For use of all mandatory parameters for a Class B device use the macro USE_FUNC1_AO_MANDATORY_B.
 * Use 'EVERYTHING' for importing of all available parameters
 * 
 * Example for Class B:
 * \code
 * IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_AO, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
 * {
 *   USE_FUNC1_AO_MANDATORY_B;
 * }
 * \endcode 
 * 
 * \section func1_AO_def_list This file contains the following definitions
 * \subsection func1_AO_def_list_variable List of Variables
 * - func1_AO_BLOCK_OBJECT_Reserved
 * - func1_AO_BLOCK_OBJECT_Block_Object
 * - func1_AO_BLOCK_OBJECT_Parent_Class
 * - func1_AO_BLOCK_OBJECT_Class
 * - func1_AO_BLOCK_OBJECT_Dev_Rev
 * - func1_AO_BLOCK_OBJECT_Dev_Rev_Comp
 * - func1_AO_BLOCK_OBJECT_DD_Revision
 * - func1_AO_BLOCK_OBJECT_Profile
 * - func1_AO_BLOCK_OBJECT_Profile_Revision
 * - func1_AO_BLOCK_OBJECT_Execution_Time
 * - func1_AO_BLOCK_OBJECT_Number_of_Parameters
 * - func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
 * - func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Index
 * - func1_AO_BLOCK_OBJECT_Number_of_Views
 * - func1_AO_ST_REV
 * - func1_AO_TAG_DESC
 * - func1_AO_STRATEGY
 * - func1_AO_ALERT_KEY
 * - func1_AO_TARGET_MODE
 * - func1_AO_MODE_BLK_Actual
 * - func1_AO_MODE_BLK_Permitted
 * - func1_AO_MODE_BLK_Normal
 * - func1_AO_ALARM_SUM_Current
 * - func1_AO_ALARM_SUM_Unacknowledged
 * - func1_AO_ALARM_SUM_Unreported
 * - func1_AO_ALARM_SUM_Disabled
 * - func1_AO_BATCH_Batch_ID
 * - func1_AO_BATCH_Rup
 * - func1_AO_BATCH_Operation
 * - func1_AO_BATCH_Phase
 * - func1_AO_SP_Value
 * - func1_AO_SP_Status_Condensed
 * - func1_AO_SP_Status_Quality
 * - func1_AO_SP_Status_Limit
 * - func1_AO_PV_SCALE_Upper_Value
 * - func1_AO_PV_SCALE_Lower_Value
 * - func1_AO_PV_SCALE_Units_Index
 * - func1_AO_PV_SCALE_Decimal_Point
 * - func1_AO_READBACK_Value
 * - func1_AO_READBACK_Status_Condensed
 * - func1_AO_READBACK_Status_Quality
 * - func1_AO_READBACK_Status_Limit
 * - func1_AO_RCAS_IN_Value
 * - func1_AO_RCAS_IN_Status_Condensed
 * - func1_AO_RCAS_IN_Status_Quality
 * - func1_AO_RCAS_IN_Status_Limit
 * - func1_AO_IN_CHANNEL
 * - func1_AO_OUT_CHANNEL
 * - func1_AO_FSAFE_TIME
 * - func1_AO_FSAFE_TYPE
 * - func1_AO_FSAFE_VALUE
 * - func1_AO_RCAS_OUT_Value
 * - func1_AO_RCAS_OUT_Status_Condensed
 * - func1_AO_RCAS_OUT_Status_Quality
 * - func1_AO_RCAS_OUT_Status_Limit
 * - func1_AO_POS_D_Value
 * - func1_AO_POS_D_Status_Condensed
 * - func1_AO_POS_D_Status_Quality
 * - func1_AO_POS_D_Status_Limit
 * - func1_AO_SETP_DEVIATION
 * - func1_AO_CHECK_BACK
 * - func1_AO_CHECK_BACK_MASK
 * - func1_AO_SIMULATE_Status_Condensed
 * - func1_AO_SIMULATE_Value
 * - func1_AO_SIMULATE_Enabled
 * - func1_AO_SIMULATE_Status_Quality
 * - func1_AO_SIMULATE_Status_Limit
 * - func1_AO_INCREASE_CLOSE
 * - func1_AO_OUT_Value
 * - func1_AO_OUT_Status_Condensed
 * - func1_AO_OUT_Status_Quality
 * - func1_AO_OUT_Status_Limit
 * - func1_AO_OUT_SCALE_Upper_Value
 * - func1_AO_OUT_SCALE_Lower_Value
 * - func1_AO_OUT_SCALE_Units_Index
 * - func1_AO_OUT_SCALE_Decimal_Point
 * .
 * \subsection func1_AO_def_list_command List of Commands
 * - func1_AO_BLOCK_OBJECT_read
 * - func1_AO_ST_REV_read
 * - func1_AO_TAG_DESC_read
 * - func1_AO_TAG_DESC_write
 * - func1_AO_STRATEGY_read
 * - func1_AO_STRATEGY_write
 * - func1_AO_ALERT_KEY_read
 * - func1_AO_ALERT_KEY_write
 * - func1_AO_TARGET_MODE_read
 * - func1_AO_TARGET_MODE_write
 * - func1_AO_MODE_BLK_read
 * - func1_AO_ALARM_SUM_read
 * - func1_AO_BATCH_read
 * - func1_AO_BATCH_write
 * - func1_AO_SP_read
 * - func1_AO_SP_write
 * - func1_AO_PV_SCALE_read
 * - func1_AO_PV_SCALE_write
 * - func1_AO_READBACK_read
 * - func1_AO_RCAS_IN_read
 * - func1_AO_RCAS_IN_write
 * - func1_AO_IN_CHANNEL_read
 * - func1_AO_IN_CHANNEL_write
 * - func1_AO_OUT_CHANNEL_read
 * - func1_AO_OUT_CHANNEL_write
 * - func1_AO_FSAFE_TIME_read
 * - func1_AO_FSAFE_TIME_write
 * - func1_AO_FSAFE_TYPE_read
 * - func1_AO_FSAFE_TYPE_write
 * - func1_AO_FSAFE_VALUE_read
 * - func1_AO_FSAFE_VALUE_write
 * - func1_AO_RCAS_OUT_read
 * - func1_AO_POS_D_read
 * - func1_AO_SETP_DEVIATION_read
 * - func1_AO_CHECK_BACK_read
 * - func1_AO_CHECK_BACK_MASK_read
 * - func1_AO_SIMULATE_read
 * - func1_AO_SIMULATE_write
 * - func1_AO_INCREASE_CLOSE_read
 * - func1_AO_INCREASE_CLOSE_write
 * - func1_AO_OUT_read
 * - func1_AO_OUT_write
 * - func1_AO_OUT_SCALE_read
 * - func1_AO_OUT_SCALE_write
 * .
 * \subsection func1_AO_def_list_menu List of Menus
 * - func1_AO_BLOCK_OBJECT_page
 * - func1_AO_ST_REV_page
 * - func1_AO_TAG_DESC_page
 * - func1_AO_STRATEGY_page
 * - func1_AO_ALERT_KEY_page
 * - func1_AO_TARGET_MODE_page
 * - func1_AO_MODE_BLK_page
 * - func1_AO_ALARM_SUM_page
 * - func1_AO_BATCH_page
 * - func1_AO_SP_page
 * - func1_AO_PV_SCALE_page
 * - func1_AO_READBACK_page
 * - func1_AO_RCAS_IN_page
 * - func1_AO_IN_CHANNEL_page
 * - func1_AO_OUT_CHANNEL_page
 * - func1_AO_FSAFE_TIME_page
 * - func1_AO_FSAFE_TYPE_page
 * - func1_AO_FSAFE_VALUE_page
 * - func1_AO_RCAS_OUT_page
 * - func1_AO_POS_D_page
 * - func1_AO_SETP_DEVIATION_page
 * - func1_AO_CHECK_BACK_page
 * - func1_AO_CHECK_BACK_MASK_page
 * - func1_AO_SIMULATE_page
 * - func1_AO_INCREASE_CLOSE_page
 * - func1_AO_OUT_page
 * - func1_AO_OUT_SCALE_page
 * - func1_AO_VIEW_1_page
 * - func1_AO_VIEW_2_page
 * - func1_AO_VIEW_3_page
 * .
 * \subsection func1_AO_def_list_method List of Methods
 * - None
 * .
 *
 * \section func1_AO_upload_download Upload and Download
 * \subsection func1_AO_upload_download_upload Upload
 * To upload the VARIABLEs you can use the following macro definition:
 * \code
 * func1_AO_BLOCK_OBJECT_Reserved,                   // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Block_Object,               // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Parent_Class,               // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Class,                      // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Dev_Rev,                    // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Dev_Rev_Comp,               // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_DD_Revision,                // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Profile,                    // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Profile_Revision,           // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Execution_Time,             // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Number_of_Parameters,       // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Slot,     // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Index,    // Mand A, Mand B
 * func1_AO_BLOCK_OBJECT_Number_of_Views,            // Mand A, Mand B
 * func1_AO_ST_REV,                                  // Mand A, Mand B
 * func1_AO_TAG_DESC,                                // Mand A, Mand B
 * func1_AO_STRATEGY,                                // Mand A, Mand B
 * func1_AO_ALERT_KEY,                               // Mand A, Mand B
 * func1_AO_TARGET_MODE,                             // Mand A, Mand B
 * func1_AO_MODE_BLK_Actual,                         // Mand A, Mand B
 * func1_AO_MODE_BLK_Permitted,                      // Mand A, Mand B
 * func1_AO_MODE_BLK_Normal,                         // Mand A, Mand B
 * func1_AO_ALARM_SUM_Current,                       // Mand A, Mand B
 * func1_AO_ALARM_SUM_Unacknowledged,                // Mand A, Mand B
 * func1_AO_ALARM_SUM_Unreported,                    // Mand A, Mand B
 * func1_AO_ALARM_SUM_Disabled,                      // Mand A, Mand B
 * func1_AO_BATCH_Batch_ID,                          // Mand A, Mand B
 * func1_AO_BATCH_Rup,                               // Mand A, Mand B
 * func1_AO_BATCH_Operation,                         // Mand A, Mand B
 * func1_AO_BATCH_Phase,                             // Mand A, Mand B
 * func1_AO_SP_Value,                                // Mand A, Mand B
 * func1_AO_SP_Status_Condensed,                     // Mand A, Mand B
 * func1_AO_PV_SCALE_Upper_Value,                    // Mand A, Mand B
 * func1_AO_PV_SCALE_Lower_Value,                    // Mand A, Mand B
 * func1_AO_PV_SCALE_Units_Index,                    // Mand A, Mand B
 * func1_AO_PV_SCALE_Decimal_Point,                  // Mand A, Mand B
 * func1_AO_READBACK_Value,                          // Mand B, Opt A
 * func1_AO_READBACK_Status_Condensed,               // Mand B, Opt A
 * func1_AO_RCAS_IN_Value,                           // Opt A, Opt B
 * func1_AO_RCAS_IN_Status_Condensed,                // Opt A, Opt B
 * func1_AO_IN_CHANNEL,                              // Mand B, Opt A
 * func1_AO_OUT_CHANNEL,                             // Mand B, Opt A
 * func1_AO_FSAFE_TIME,                              // Mand B, Opt A
 * func1_AO_FSAFE_TYPE,                              // Mand B, Opt A
 * func1_AO_FSAFE_VALUE,                             // Mand B, Opt A
 * func1_AO_RCAS_OUT_Value,                          // Opt A, Opt B
 * func1_AO_RCAS_OUT_Status_Condensed,               // Opt A, Opt B
 * func1_AO_POS_D_Value,                             // Mand A, Mand B
 * func1_AO_POS_D_Status_Condensed,                  // Mand A, Mand B
 * func1_AO_SETP_DEVIATION,                          // Opt A, Opt B
 * func1_AO_CHECK_BACK,                              // Mand B, Opt A
 * func1_AO_CHECK_BACK_MASK,                         // Mand B, Opt A
 * func1_AO_SIMULATE_Status_Condensed,               // Mand B, Opt A
 * func1_AO_SIMULATE_Value,                          // Mand B, Opt A
 * func1_AO_SIMULATE_Enabled,                        // Mand B, Opt A
 * func1_AO_INCREASE_CLOSE,                          // Mand B, Opt A
 * func1_AO_OUT_Value,                               // Mand B, Opt A
 * func1_AO_OUT_Status_Condensed,                    // Mand B, Opt A
 * func1_AO_OUT_SCALE_Upper_Value,                   // Mand A, Mand B
 * func1_AO_OUT_SCALE_Lower_Value,                   // Mand A, Mand B
 * func1_AO_OUT_SCALE_Units_Index,                   // Mand A, Mand B
 * func1_AO_OUT_SCALE_Decimal_Point                  // Mand A, Mand B
 * \endcode
 * \subsection func1_AO_upload_download_download Download
 * To download the VARIABLEs you can use the following macro definition:
 * \code
 * func1_AO_TAG_DESC,                     // Mand A, Mand B
 * func1_AO_STRATEGY,                     // Mand A, Mand B
 * func1_AO_ALERT_KEY,                    // Mand A, Mand B
 * func1_AO_TARGET_MODE,                  // Mand A, Mand B
 * func1_AO_BATCH_Batch_ID,               // Mand A, Mand B
 * func1_AO_BATCH_Rup,                    // Mand A, Mand B
 * func1_AO_BATCH_Operation,              // Mand A, Mand B
 * func1_AO_BATCH_Phase,                  // Mand A, Mand B
 * func1_AO_SP_Value,                     // Mand A, Mand B
 * func1_AO_SP_Status_Condensed,          // Mand A, Mand B
 * func1_AO_PV_SCALE_Upper_Value,         // Mand A, Mand B
 * func1_AO_PV_SCALE_Lower_Value,         // Mand A, Mand B
 * func1_AO_PV_SCALE_Units_Index,         // Mand A, Mand B
 * func1_AO_PV_SCALE_Decimal_Point,       // Mand A, Mand B
 * func1_AO_RCAS_IN_Value,                // Opt A, Opt B
 * func1_AO_RCAS_IN_Status_Condensed,     // Opt A, Opt B
 * func1_AO_IN_CHANNEL,                   // Mand B, Opt A
 * func1_AO_OUT_CHANNEL,                  // Mand B, Opt A
 * func1_AO_FSAFE_TIME,                   // Mand B, Opt A
 * func1_AO_FSAFE_TYPE,                   // Mand B, Opt A
 * func1_AO_FSAFE_VALUE,                  // Mand B, Opt A
 * func1_AO_SIMULATE_Status_Condensed,    // Mand B, Opt A
 * func1_AO_SIMULATE_Value,               // Mand B, Opt A
 * func1_AO_SIMULATE_Enabled,             // Mand B, Opt A
 * func1_AO_INCREASE_CLOSE,               // Mand B, Opt A
 * func1_AO_OUT_Value,                    // Mand B, Opt A
 * func1_AO_OUT_Status_Condensed,         // Mand B, Opt A
 * func1_AO_OUT_SCALE_Upper_Value,        // Mand A, Mand B
 * func1_AO_OUT_SCALE_Lower_Value,        // Mand A, Mand B
 * func1_AO_OUT_SCALE_Units_Index,        // Mand A, Mand B
 * func1_AO_OUT_SCALE_Decimal_Point       // Mand A, Mand B
 * \endcode
 *
 * \section func1_AO_necessary_changes Necessary changes on variables
 * \subsection func1_AO_IN_Channel_changes func1_AO_IN_CHANNEL and func1_AO_OUT_CHANNEL
 * To use this parameters in your EDD you must redefine the specific enumeration of this block parameter.
 * \n For example:
 * \code
 * TYPE ENUMERATED(2)
 * {
 *    { 0x0108, "TB 1" },
 *    { 0x0208, "TB 2" }
 * }
 * \endcode
 * 
 */

#include "pa_import_0302.h"
#include "pa_units_0302.h"
#include "pa_status.h"

/** \cond SKIP_THIS */
MANUFACTURER 0x0000, DEVICE_TYPE 0x4201, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
/** \endcond */

BLOCK func1_AO_block
{
	TYPE FUNCTION;
	NUMBER 1;
}

COLLECTION func1_AO_BLOCK_OBJECT
{
	LABEL [PI_BLOCK_OBJECT_label];
	HELP [PI_BLOCK_OBJECT_help];
	MEMBERS
	{
		Reserved, func1_AO_BLOCK_OBJECT_Reserved;
		Block_Object, func1_AO_BLOCK_OBJECT_Block_Object;
		Parent_Class, func1_AO_BLOCK_OBJECT_Parent_Class;
		Class, func1_AO_BLOCK_OBJECT_Class;
		Dev_Rev, func1_AO_BLOCK_OBJECT_Dev_Rev;
		Dev_Rev_Comp, func1_AO_BLOCK_OBJECT_Dev_Rev_Comp;
		DD_Revision, func1_AO_BLOCK_OBJECT_DD_Revision;
		Profile, func1_AO_BLOCK_OBJECT_Profile;
		Profile_Revision, func1_AO_BLOCK_OBJECT_Profile_Revision;
		Execution_Time, func1_AO_BLOCK_OBJECT_Execution_Time;
		Number_of_Parameters, func1_AO_BLOCK_OBJECT_Number_of_Parameters;
		Address_of_VIEW_1_Slot, func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Slot;
		Address_of_VIEW_1_Index, func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Index;
		Number_of_Views, func1_AO_BLOCK_OBJECT_Number_of_Views;
	}
}

VARIABLE func1_AO_BLOCK_OBJECT_Reserved
{
	LABEL [PI_BLOCK_OBJECT_Reserved_label];
	HELP [PI_BLOCK_OBJECT_Reserved_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func1_AO_BLOCK_OBJECT_Block_Object
{
	LABEL [PI_BLOCK_OBJECT_Block_Object_label];
	HELP [PI_BLOCK_OBJECT_Block_Object_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 2;
		{ 1, [PI_BLOCK_OBJECT_Block_Object_enum_1] },
		{ 2, [PI_BLOCK_OBJECT_Block_Object_enum_2] },
		{ 3, [PI_BLOCK_OBJECT_Block_Object_enum_3] }
	}
}

VARIABLE func1_AO_BLOCK_OBJECT_Parent_Class
{
	LABEL [PI_BLOCK_OBJECT_Parent_Class_label];
	HELP [PI_BLOCK_OBJECT_Parent_Class_help_1];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 2;
		{ 1, [PI_BLOCK_OBJECT_Parent_Class_enum_1_1] },
		{ 2, [PI_BLOCK_OBJECT_Parent_Class_enum_2_1] },
		{ 3, [PI_BLOCK_OBJECT_Parent_Class_enum_3_1] },
		{ 4, [PI_BLOCK_OBJECT_Parent_Class_enum_4_1] },
		{ 5, [PI_BLOCK_OBJECT_Parent_Class_enum_5_1] },
		{ 6, [PI_BLOCK_OBJECT_Parent_Class_enum_8] },
		{ 7, [PI_BLOCK_OBJECT_Parent_Class_enum_7_1] }
	}
}

VARIABLE func1_AO_BLOCK_OBJECT_Class
{
	LABEL [PI_BLOCK_OBJECT_Class_label];
	HELP [PI_BLOCK_OBJECT_Class_help_1];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 1, [PI_func_AO_BLOCK_OBJECT_Class_enum_1] }
	}
}

VARIABLE func1_AO_BLOCK_OBJECT_Dev_Rev
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func1_AO_BLOCK_OBJECT_Dev_Rev_Comp
{
	LABEL [PI_BLOCK_OBJECT_Dev_Rev_Comp_label];
	HELP [PI_BLOCK_OBJECT_Dev_Rev_Comp_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func1_AO_BLOCK_OBJECT_DD_Revision
{
	LABEL [PI_BLOCK_OBJECT_DD_Revision_label];
	HELP [PI_BLOCK_OBJECT_DD_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func1_AO_BLOCK_OBJECT_Profile
{
	LABEL [PI_BLOCK_OBJECT_Profile_label];
	HELP [PI_BLOCK_OBJECT_Profile_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		{ 0x4001, [PI_BLOCK_OBJECT_Profile_enum_0x4001] },
		{ 0x4002, [PI_BLOCK_OBJECT_Profile_enum_0x4002] },
		{ 0x4081, [PI_BLOCK_OBJECT_Profile_enum_0x4081] },
		{ 0x4082, [PI_BLOCK_OBJECT_Profile_enum_0x4082] }
	}
}

VARIABLE func1_AO_BLOCK_OBJECT_Profile_Revision
{
	LABEL [PI_BLOCK_OBJECT_Profile_Revision_label];
	HELP [PI_BLOCK_OBJECT_Profile_Revision_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 0x302;
		{ 0x0200, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0200] },
		{ 0x0300, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0300] },
		{ 0x0301, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0301] },
		{ 0x0302, [PI_BLOCK_OBJECT_Profile_Revision_enum_0x0302] }
	}
}

VARIABLE func1_AO_BLOCK_OBJECT_Execution_Time
{
	LABEL [PI_BLOCK_OBJECT_Execution_Time_label];
	HELP [PI_BLOCK_OBJECT_Execution_Time_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func1_AO_BLOCK_OBJECT_Number_of_Parameters
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Parameters_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Parameters_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2);
}

VARIABLE func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Slot
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_label];
	HELP [PI_BLOCK_OBJECT_Address_of_VIEW_1_Slot_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Index
{
	LABEL [PI_BLOCK_OBJECT_Address_of_VIEW_1_Index_label];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func1_AO_BLOCK_OBJECT_Number_of_Views
{
	LABEL [PI_BLOCK_OBJECT_Number_of_Views_label];
	HELP [PI_BLOCK_OBJECT_Number_of_Views_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(1);
}

VARIABLE func1_AO_ST_REV
{
	LABEL [PI_ST_REV_label];
	HELP [PI_ST_REV_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_TAG_DESC
{
	LABEL [PI_TAG_DESC_label];
	HELP [PI_TAG_DESC_help];
	CLASS CONTAINED;
	TYPE ASCII(32)
	{
		DEFAULT_VALUE " ";
	}
}

VARIABLE func1_AO_STRATEGY
{
	LABEL [PI_STRATEGY_label];
	HELP [PI_STRATEGY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_ALERT_KEY
{
	LABEL [PI_ALERT_KEY_label];
	HELP [PI_ALERT_KEY_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(1)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_TARGET_MODE
{
	LABEL [PI_TARGET_MODE_label];
	HELP [PI_TARGET_MODE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0x02, [PI_mode_RCAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION func1_AO_MODE_BLK
{
	LABEL [PI_MODE_BLK_label];
	HELP [PI_MODE_BLK_help];
	MEMBERS
	{
		Actual, func1_AO_MODE_BLK_Actual;
		Permitted, func1_AO_MODE_BLK_Permitted;
		Normal, func1_AO_MODE_BLK_Normal;
	}
}

VARIABLE func1_AO_MODE_BLK_Actual
{
	LABEL [PI_MODE_BLK_Actual_label];
	HELP [PI_MODE_BLK_Actual_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE func1_AO_MODE_BLK_Permitted
{
	LABEL [PI_MODE_BLK_Permitted_label];
	HELP [PI_MODE_BLK_Permitted_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(1)
	{
		DEFAULT_VALUE 0x98;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

VARIABLE func1_AO_MODE_BLK_Normal
{
	LABEL [PI_MODE_BLK_Normal_label];
	HELP [PI_MODE_BLK_Normal_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0x8;
		{ 0x01, [PI_mode_ROUT] },
		{ 0x02, [PI_mode_RCAS] },
		{ 0x04, [PI_mode_CAS] },
		{ 0x08, [PI_mode_AUTO] },
		{ 0x10, [PI_mode_MAN] },
		{ 0x20, [PI_mode_LO] },
		{ 0x40, [PI_mode_IMAN] },
		{ 0x80, [PI_mode_OUT_OF_SERVICE] }
	}
}

COLLECTION func1_AO_ALARM_SUM
{
	LABEL [PI_ALARM_SUM_label];
	HELP [PI_ALARM_SUM_help];
	MEMBERS
	{
		Current, func1_AO_ALARM_SUM_Current;
		Unacknowledged, func1_AO_ALARM_SUM_Unacknowledged;
		Unreported, func1_AO_ALARM_SUM_Unreported;
		Disabled, func1_AO_ALARM_SUM_Disabled;
	}
}

VARIABLE func1_AO_ALARM_SUM_Current
{
	LABEL [PI_ALARM_SUM_Current_label];
	HELP [PI_ALARM_SUM_Current_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func1_AO_ALARM_SUM_Unacknowledged
{
	LABEL [PI_ALARM_SUM_Unacknowledged_label];
	HELP [PI_ALARM_SUM_Unacknowledged_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func1_AO_ALARM_SUM_Unreported
{
	LABEL [PI_ALARM_SUM_Unreported_label];
	HELP [PI_ALARM_SUM_Unreported_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

VARIABLE func1_AO_ALARM_SUM_Disabled
{
	LABEL [PI_ALARM_SUM_Disabled_label];
	HELP [PI_ALARM_SUM_Disabled_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(2)
	{
		DEFAULT_VALUE 0;
		{ 0x0000, [PI_ALARM_SUM_Current_enum_0x0000] },
		{ 0x0200, [PI_ALARM_SUM_Current_enum_0x0200] },
		{ 0x0400, [PI_ALARM_SUM_Current_enum_0x0400] },
		{ 0x0800, [PI_ALARM_SUM_Current_enum_0x0800] },
		{ 0x1000, [PI_ALARM_SUM_Current_enum_0x1000] },
		{ 0x8000, [PI_ALARM_SUM_Current_enum_0x8000] }
	}
}

COLLECTION func1_AO_BATCH
{
	LABEL [PI_BATCH_label];
	HELP [PI_BATCH_help];
	MEMBERS
	{
		Batch_ID, func1_AO_BATCH_Batch_ID;
		Rup, func1_AO_BATCH_Rup;
		Operation, func1_AO_BATCH_Operation;
		Phase, func1_AO_BATCH_Phase;
	}
}

VARIABLE func1_AO_BATCH_Batch_ID
{
	LABEL [PI_BATCH_Batch_ID_label];
	HELP [PI_BATCH_Batch_ID_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(4)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_BATCH_Rup
{
	LABEL [PI_BATCH_Rup_label];
	HELP [PI_BATCH_Rup_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_BATCH_Operation
{
	LABEL [PI_BATCH_Operation_label];
	HELP [PI_BATCH_Operation_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_BATCH_Phase
{
	LABEL [PI_BATCH_Phase_label];
	HELP [PI_BATCH_Phase_help];
	CLASS CONTAINED;
	TYPE UNSIGNED_INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
}

COLLECTION func1_AO_SP
{
	LABEL [PI_func_AO_SP_label];
	HELP [PI_func_AO_SP_help];
	MEMBERS
	{
		Value, func1_AO_SP_Value;
		Status_Condensed, func1_AO_SP_Status_Condensed;
	}
}

VARIABLE func1_AO_SP_Value
{
	LABEL [PI_func_AO_SP_Value_label];
	HELP [PI_func_AO_SP_Value_help];
	CLASS INPUT & DYNAMIC;
	TYPE FLOAT;
}

VARIABLE func1_AO_SP_Status_Condensed
{
	LABEL [PI_func_AO_SP_Status_Condensed_label];
	CLASS INPUT & DYNAMIC;
	HANDLING IF (func1_AO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func1_AO_SP_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_SP_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func1_AO_SP_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_SP_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

COLLECTION func1_AO_PV_SCALE
{
	LABEL [PI_func_AO_PV_SCALE_label];
	HELP [PI_func_AO_PV_SCALE_help];
	MEMBERS
	{
		Upper_Value, func1_AO_PV_SCALE_Upper_Value;
		Lower_Value, func1_AO_PV_SCALE_Lower_Value;
		Units_Index, func1_AO_PV_SCALE_Units_Index;
		Decimal_Point, func1_AO_PV_SCALE_Decimal_Point;
	}
}

VARIABLE func1_AO_PV_SCALE_Upper_Value
{
	LABEL [PI_PV_SCALE_Upper_Value_label];
	HELP [PI_PV_SCALE_Upper_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 100;
	}
}

VARIABLE func1_AO_PV_SCALE_Lower_Value
{
	LABEL [PI_PV_SCALE_Lower_Value_label];
	HELP [PI_PV_SCALE_Lower_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_PV_SCALE_Units_Index
{
	LABEL [PI_PRIMARY_VALUE_UNIT_label];
	HELP [PI_PRIMARY_VALUE_UNIT_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 1342;
		{ 1342, [PI_unit_1342], [PI_unit_1342_help] }
	}
}

VARIABLE func1_AO_PV_SCALE_Decimal_Point
{
	LABEL [PI_OUT_SCALE_Decimal_Point_label];
	HELP [PI_OUT_SCALE_Decimal_Point_help];
	CLASS CONTAINED;
	TYPE INTEGER(1)
	{
		DEFAULT_VALUE 2;
		MIN_VALUE 0;
		{ 0, [PI_OUT_SCALE_Decimal_Point_enum_0] },
		{ 1, [PI_OUT_SCALE_Decimal_Point_enum_1] },
		{ 2, [PI_OUT_SCALE_Decimal_Point_enum_2] },
		{ 3, [PI_OUT_SCALE_Decimal_Point_enum_3] },
		{ 4, [PI_OUT_SCALE_Decimal_Point_enum_4] },
		{ 5, [PI_OUT_SCALE_Decimal_Point_enum_5] },
		{ 6, [PI_OUT_SCALE_Decimal_Point_enum_6] },
		{ 7, [PI_OUT_SCALE_Decimal_Point_enum_7] }
	}
}

COLLECTION func1_AO_READBACK
{
	LABEL [PI_func_AO_READBACK_label];
	HELP [PI_func_AO_READBACK_help];
	MEMBERS
	{
		Value, func1_AO_READBACK_Value;
		Status_Condensed, func1_AO_READBACK_Status_Condensed;
	}
}

VARIABLE func1_AO_READBACK_Value
{
	LABEL [PI_func_AO_READBACK_Value_label];
	HELP [PI_func_AO_READBACK_Value_help];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE FLOAT;
}

VARIABLE func1_AO_READBACK_Status_Condensed
{
	LABEL [PI_func_AO_READBACK_Status_Condensed_label];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func1_AO_READBACK_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_READBACK_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func1_AO_READBACK_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_READBACK_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

COLLECTION func1_AO_RCAS_IN
{
	LABEL [PI_func_AO_RCAS_IN_label];
	HELP [PI_func_AO_RCAS_IN_help];
	MEMBERS
	{
		Value, func1_AO_RCAS_IN_Value;
		Status_Condensed, func1_AO_RCAS_IN_Status_Condensed;
	}
}

VARIABLE func1_AO_RCAS_IN_Value
{
	LABEL [PI_RCAS_IN_Value_label];
	HELP [PI_RCAS_IN_Value_help];
	CLASS INPUT & DYNAMIC;
	TYPE FLOAT;
}

VARIABLE func1_AO_RCAS_IN_Status_Condensed
{
	LABEL [PI_func_AO_RCAS_IN_Status_Condensed_label];
	CLASS INPUT & DYNAMIC;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_ALL
	}
}

VARIABLE func1_AO_RCAS_IN_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_RCAS_IN_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] },
		{ 0x30, [PI_status_GOOD_RCAS_00] },
		{ 0x31, [PI_status_GOOD_RCAS_01] },
		{ 0x32, [PI_status_GOOD_RCAS_02] },
		{ 0x33, [PI_status_GOOD_RCAS_03] },
		{ 0x35, [PI_status_GOOD_RCAS_05] },
		{ 0x36, [PI_status_GOOD_RCAS_06] },
		{ 0x38, [PI_status_GOOD_RCAS_08] }
	}
}

VARIABLE func1_AO_RCAS_IN_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_RCAS_IN_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

VARIABLE func1_AO_IN_CHANNEL
{
	LABEL [PI_IN_CHANNEL_label];
	HELP [PI_func_AO_IN_CHANNEL_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, [PI_IDENT_NUMBER_SELECTOR_enum_1] }
	}
}

VARIABLE func1_AO_OUT_CHANNEL
{
	LABEL [PI_IN_CHANNEL_label];
	HELP [PI_func_AO_OUT_CHANNEL_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		{ 0, [PI_IDENT_NUMBER_SELECTOR_enum_1] }
	}
}

VARIABLE func1_AO_FSAFE_TIME
{
	LABEL [PI_FSAFE_TIME_label];
	HELP [PI_FSAFE_TIME_help];
	CLASS CONTAINED;
	CONSTANT_UNIT [PI_unit_1054];
	TYPE FLOAT
	{
		DEFAULT_VALUE 0;
		MIN_VALUE 0.0;
	}
	VALIDITY IF (func1_AO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
}

VARIABLE func1_AO_FSAFE_TYPE
{
	LABEL [PI_FSAFE_TYPE_label];
	HELP [PI_func_AO_FSAFE_TYPE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 1;
		{ 0, [PI_FSAFE_TYPE_enum_0_1] },
		{ 1, [PI_FSAFE_TYPE_enum_1_1] },
		//{ 2, [PI_FSAFE_TYPE_enum_2_1] }
	}
}

VARIABLE func1_AO_FSAFE_VALUE
{
	LABEL [PI_func_AO_FSAFE_VALUE_label];
	HELP [PI_FSAFE_VALUE_help_1];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0;
	}
	VALIDITY IF (func1_AO_FSAFE_TYPE == 0) { TRUE; } ELSE { FALSE; }
}

COLLECTION func1_AO_RCAS_OUT
{
	LABEL [PI_func_AO_RCAS_OUT_label];
	HELP [PI_func_AO_RCAS_OUT_help];
	MEMBERS
	{
		Value, func1_AO_RCAS_OUT_Value;
		Status_Condensed, func1_AO_RCAS_OUT_Status_Condensed;
	}
}

VARIABLE func1_AO_RCAS_OUT_Value
{
	LABEL [PI_RCAS_OUT_Value_label];
	HELP [PI_RCAS_OUT_Value_help];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE FLOAT;
}

VARIABLE func1_AO_RCAS_OUT_Status_Condensed
{
	LABEL [PI_func_AO_RCAS_OUT_Status_Condensed_label];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_ALL
	}
}

VARIABLE func1_AO_RCAS_OUT_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_RCAS_OUT_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] },
		{ 0x30, [PI_status_GOOD_RCAS_00] },
		{ 0x31, [PI_status_GOOD_RCAS_01] },
		{ 0x32, [PI_status_GOOD_RCAS_02] },
		{ 0x33, [PI_status_GOOD_RCAS_03] },
		{ 0x35, [PI_status_GOOD_RCAS_05] },
		{ 0x36, [PI_status_GOOD_RCAS_06] },
		{ 0x38, [PI_status_GOOD_RCAS_08] }
	}
}

VARIABLE func1_AO_RCAS_OUT_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_RCAS_OUT_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

COLLECTION func1_AO_POS_D
{
	LABEL [PI_func_AO_POS_D_label];
	HELP [PI_func_AO_POS_D_help];
	MEMBERS
	{
		Value, func1_AO_POS_D_Value;
		Status_Condensed, func1_AO_POS_D_Status_Condensed;
	}
}

VARIABLE func1_AO_POS_D_Value
{
	LABEL [PI_func_AO_POS_D_Value_label];
	HELP [PI_func_AO_POS_D_Value_help];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0, [PI_func_AO_POS_D_Value_enum_0] },
		{ 1, [PI_func_AO_POS_D_Value_enum_1] },
		{ 2, [PI_func_AO_POS_D_Value_enum_2] },
		{ 3, [PI_func_AO_POS_D_Value_enum_3] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func1_AO_POS_D_Status_Condensed
{
	LABEL [PI_func_AO_POS_D_Status_Condensed_label];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func1_AO_POS_D_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_POS_D_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func1_AO_POS_D_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_POS_D_Status_Quality_help];
	CLASS LOCAL;
	HANDLING READ;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] },
		{ 250, [PI_HW_WRITE_PROTECTION_enum_250] },
		{ 251, [PI_HW_WRITE_PROTECTION_enum_251] },
		{ 252, [PI_HW_WRITE_PROTECTION_enum_252] },
		{ 253, [PI_HW_WRITE_PROTECTION_enum_253] },
		{ 254, [PI_HW_WRITE_PROTECTION_enum_254] },
		{ 255, [PI_HW_WRITE_PROTECTION_enum_255] }
	}
}

VARIABLE func1_AO_SETP_DEVIATION
{
	LABEL [PI_func_AO_SETP_DEVIATION_label];
	HELP [PI_func_AO_SETP_DEVIATION_help];
	CLASS CONTAINED & DYNAMIC;
	HANDLING READ;
	CONSTANT_UNIT [PI_unit_1342];
	TYPE FLOAT;
}

#define CB_FAIL_SAFE            0x00010000 /* Bit  0 */
#define CB_REQ_LOC_OP           0x00020000 /* Bit  1 */
#define CB_LOCAL_OP             0x00040000 /* Bit  2 */
#define CB_OVERRIDE             0x00080000 /* Bit  3 */
#define CB_DISC_DIR             0x00100000 /* Bit  4 */
#define CB_TORQUE_D_OP          0x00200000 /* Bit  5 */
#define CB_TORQUE_D_CL          0x00400000 /* Bit  6 */
#define CB_TRAV_TIME            0x00800000 /* Bit  7 */
#define CB_ACT_OPEN             0x00000100 /* Bit  8 */
#define CB_ACT_CLOSE            0x00000200 /* Bit  9 */
#define CB_UPDATE_EVT           0x00000400 /* Bit 10 */
#define CB_SIMULATE             0x00000800 /* Bit 11 */
#define CB_CONTR_ERR            0x00002000 /* Bit 13 */
#define CB_CONTR_INACT          0x00004000 /* Bit 14 */
#define CB_SELFTEST             0x00008000 /* Bit 15 */
#define CB_TOT_VALVE_TRAV       0x00000001 /* Bit 16 */
#define CB_ADD_INPUT            0x00000002 /* Bit 17 */
#define CB_ZERO_POINT_ERROR     0x00000080 /* Bit 23 */

VARIABLE func1_AO_CHECK_BACK
{
	LABEL [PI_CHECK_BACK_label];
	HELP [PI_CHECK_BACK_help];
	CLASS OUTPUT & DYNAMIC;
	HANDLING READ;
	TYPE BIT_ENUMERATED(3)
	{
		{ 0x000000, [PI_CHECK_BACK_enum_0], [PI_CHECK_BACK_enum_0] },
    { CB_FAIL_SAFE,     "Fails Safe", " " },
    { CB_LOCAL_OP,      "Local Operator", " " },
    { CB_OVERRIDE,      "Override", " " },
    { CB_UPDATE_EVT,    "Update Event", " " },
    { CB_SIMULATE,      "Simulation", " " },
    { CB_CONTR_INACT,   "Block is Out Of Service", " " }
	}
}

VARIABLE func1_AO_CHECK_BACK_MASK
{
	LABEL [PI_CHECK_BACK_MASK_label];
	HELP [PI_CHECK_BACK_MASK_help];
	CLASS CONTAINED;
	HANDLING READ;
	TYPE BIT_ENUMERATED(3)
	{
		{ 0, [PI_CHECK_BACK_enum_0], [PI_CHECK_BACK_enum_0] },
    { 0x000001, "Fails Safe", " " },
    { 0x000004, "Local Operator", " " },
    { 0x000008, "Override", " " },
    { 0x000400, "Update Event", " " },
    { 0x000800, "Simulation", " " },
    { 0x004000, "Block is Out Of Service", " " }
	}
}

COLLECTION func1_AO_SIMULATE
{
	LABEL [PI_SIMULATE_label];
	HELP [PI_SIMULATE_help];
	MEMBERS
	{
		Status_Condensed, func1_AO_SIMULATE_Status_Condensed;
		Value, func1_AO_SIMULATE_Value;
		Enabled, func1_AO_SIMULATE_Enabled;
	}
}

VARIABLE func1_AO_SIMULATE_Status_Condensed
{
	LABEL [PI_SIMULATE_Status_Condensed_label];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func1_AO_SIMULATE_Value
{
	LABEL  [PI_SIMULATE_Value_label];
	HELP [PI_func_AO_SIMULATE_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT;
}

VARIABLE func1_AO_SIMULATE_Enabled
{
	LABEL [PI_SIMULATE_Enabled_label];
	HELP [PI_SIMULATE_Enabled_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		{ 0, [PI_disabled] },
		{ 1, [PI_enabled] }
	}
}

VARIABLE func1_AO_SIMULATE_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_SIMULATE_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func1_AO_SIMULATE_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_SIMULATE_Status_Quality_help];
	CLASS LOCAL;
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

VARIABLE func1_AO_INCREASE_CLOSE
{
	LABEL [PI_func_AO_INCREASE_CLOSE_label];
	HELP [PI_func_AO_INCREASE_CLOSE_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(1)
	{
		DEFAULT_VALUE 0;
		{ 0, [PI_func_AO_INCREASE_CLOSE_enum_0] },
		{ 1, [PI_func_AO_INCREASE_CLOSE_enum_1] }
	}
}

COLLECTION func1_AO_OUT
{
	LABEL [PI_OUT_label];
	HELP [PI_func_AO_OUT_help];
	MEMBERS
	{
		Value, func1_AO_OUT_Value;
		Status_Condensed, func1_AO_OUT_Status_Condensed;
	}
}

VARIABLE func1_AO_OUT_Value
{
	LABEL [PI_OUT_Value_label];
	HELP [PI_OUT_Value_help_1];
	CLASS CONTAINED & DYNAMIC;
	HANDLING IF (func1_AO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE FLOAT;
}

VARIABLE func1_AO_OUT_Status_Condensed
{
	LABEL [PI_OUT_Status_Condensed_label];
	CLASS CONTAINED & DYNAMIC;
	HANDLING IF (func1_AO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		PI_STATUS_LIST_WITHOUT_CAS
	}
}

VARIABLE func1_AO_OUT_Status_Quality
{
	LABEL [PI_PRIMARY_VALUE_Status_Quality_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING IF (func1_AO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		{ 0x20, [PI_status_GOOD_00] },
		{ 0x21, [PI_status_GOOD_01] },
		{ 0x22, [PI_status_GOOD_02] },
		{ 0x23, [PI_status_GOOD_03] },
		{ 0x24, [PI_status_GOOD_04] },
		{ 0x25, [PI_status_GOOD_05] },
		{ 0x26, [PI_status_GOOD_06] },
		{ 0x28, [PI_status_GOOD_08] },
		{ 0x29, [PI_status_GOOD_09] },
		{ 0x10, [PI_status_UNCERTAIN_00] },
		{ 0x11, [PI_status_UNCERTAIN_01] },
		{ 0x12, [PI_status_UNCERTAIN_02] },
		{ 0x13, [PI_status_UNCERTAIN_03] },
		{ 0x14, [PI_status_UNCERTAIN_04] },
		{ 0x15, [PI_status_UNCERTAIN_05] },
		{ 0x16, [PI_status_UNCERTAIN_06] },
		{ 0x17, [PI_status_UNCERTAIN_07] },
		{ 0x00, [PI_status_BAD_00] },
		{ 0x01, [PI_status_BAD_01] },
		{ 0x02, [PI_status_BAD_02] },
		{ 0x03, [PI_status_BAD_03] },
		{ 0x04, [PI_status_BAD_04] },
		{ 0x05, [PI_status_BAD_05] },
		{ 0x06, [PI_status_BAD_06] },
		{ 0x07, [PI_status_BAD_07] }
	}
}

VARIABLE func1_AO_OUT_Status_Limit
{
	LABEL [PI_PRIMARY_VALUE_Status_Limit_label];
	HELP [PI_MASS_FLOW_Status_Quality_help];
	CLASS LOCAL;
	HANDLING IF (func1_AO_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
	TYPE ENUMERATED(1)
	{
		{ 0x00, [PI_status_limit_OK] },
		{ 0x01, [PI_status_limit_UNDERFLOW] },
		{ 0x02, [PI_status_limit_OVERFLOW] },
		{ 0x03, [PI_status_limit_VALUE_CONSTANT] }
	}
}

COLLECTION func1_AO_OUT_SCALE
{
	LABEL [PI_OUT_SCALE_label];
	HELP [PI_func_AO_OUT_SCALE_help];
	MEMBERS
	{
		Upper_Value, func1_AO_OUT_SCALE_Upper_Value;
		Lower_Value, func1_AO_OUT_SCALE_Lower_Value;
		Units_Index, func1_AO_OUT_SCALE_Units_Index;
		Decimal_Point, func1_AO_OUT_SCALE_Decimal_Point;
	}
}

VARIABLE func1_AO_OUT_SCALE_Upper_Value
{
	LABEL [PI_OUT_SCALE_Upper_Value_label];
	HELP [PI_OUT_SCALE_Upper_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 100;
	}
}

VARIABLE func1_AO_OUT_SCALE_Lower_Value
{
	LABEL [PI_OUT_SCALE_Lower_Value_label];
	HELP [PI_OUT_SCALE_Lower_Value_help];
	CLASS CONTAINED;
	TYPE FLOAT
	{
		DEFAULT_VALUE 0;
	}
}

VARIABLE func1_AO_OUT_SCALE_Units_Index
{
	LABEL [PI_PRIMARY_VALUE_UNIT_label];
	HELP [PI_PRIMARY_VALUE_UNIT_help];
	CLASS CONTAINED;
	TYPE ENUMERATED(2)
	{
		DEFAULT_VALUE 1342;
		PI_UNIT_LIST
	}
}

VARIABLE func1_AO_OUT_SCALE_Decimal_Point
{
	LABEL [PI_OUT_SCALE_Decimal_Point_label];
	HELP [PI_OUT_SCALE_Decimal_Point_help];
	CLASS CONTAINED;
	TYPE INTEGER(1)
	{
		DEFAULT_VALUE 2;
		MIN_VALUE 0;
		{ 0, [PI_OUT_SCALE_Decimal_Point_enum_0] },
		{ 1, [PI_OUT_SCALE_Decimal_Point_enum_1] },
		{ 2, [PI_OUT_SCALE_Decimal_Point_enum_2] },
		{ 3, [PI_OUT_SCALE_Decimal_Point_enum_3] },
		{ 4, [PI_OUT_SCALE_Decimal_Point_enum_4] },
		{ 5, [PI_OUT_SCALE_Decimal_Point_enum_5] },
		{ 6, [PI_OUT_SCALE_Decimal_Point_enum_6] },
		{ 7, [PI_OUT_SCALE_Decimal_Point_enum_7] }
	}
}

COLLECTION func1_AO_VIEW_1
{
	LABEL [PI_func_AO_VIEW_1_label];
	HELP [PI_VIEW_1_help];
	MEMBERS
	{
		ST_REV, func1_AO_ST_REV;
		MODE_BLK, func1_AO_MODE_BLK;
		ALARM_SUM, func1_AO_ALARM_SUM;
		READBACK, func1_AO_READBACK;
		POS_D, func1_AO_POS_D;
		CHECK_BACK, func1_AO_CHECK_BACK;
	}
}

COLLECTION func1_AO_VIEW_2
{
	LABEL [PI_func_AO_VIEW_2_label];
	HELP [PI_VIEW_2_help];
	MEMBERS
	{
		ST_REV, func1_AO_ST_REV;
		MODE_BLK, func1_AO_MODE_BLK;
		ALARM_SUM, func1_AO_ALARM_SUM;
		SP, func1_AO_SP;
		READBACK, func1_AO_READBACK;
		RCAS_IN, func1_AO_RCAS_IN;
		RCAS_OUT, func1_AO_RCAS_OUT;
		POS_D, func1_AO_POS_D;
		SETP_DEVIATION, func1_AO_SETP_DEVIATION;
		CHECK_BACK, func1_AO_CHECK_BACK;
		CHECK_BACK_MASK, func1_AO_CHECK_BACK_MASK;
		SIMULATE, func1_AO_SIMULATE;
		OUT, func1_AO_OUT;
	}
}

COLLECTION func1_AO_VIEW_3
{
	LABEL [PI_func_AO_VIEW_3_label];
	HELP [PI_VIEW_3_help];
	MEMBERS
	{
		TAG_DESC, func1_AO_TAG_DESC;
		STRATEGY, func1_AO_STRATEGY;
		ALERT_KEY, func1_AO_ALERT_KEY;
		TARGET_MODE, func1_AO_TARGET_MODE;
		BATCH, func1_AO_BATCH;
		PV_SCALE, func1_AO_PV_SCALE;
		IN_CHANNEL, func1_AO_IN_CHANNEL;
		OUT_CHANNEL, func1_AO_OUT_CHANNEL;
		FSAFE_TIME, func1_AO_FSAFE_TIME;
		FSAFE_TYPE, func1_AO_FSAFE_TYPE;
		FSAFE_VALUE, func1_AO_FSAFE_VALUE;
		INCREASE_CLOSE, func1_AO_INCREASE_CLOSE;
		OUT_SCALE, func1_AO_OUT_SCALE;
	}
}

/* simple GUI */

MENU func1_AO_Simple_Dialog_Mandatory_A
{
	LABEL [PI_func1_AO_Simple_Dialog_Mandatory_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func1_AO_BLOCK_OBJECT_page,
		func1_AO_ST_REV_page,
		func1_AO_TAG_DESC_page,
		func1_AO_STRATEGY_page,
		func1_AO_ALERT_KEY_page,
		func1_AO_TARGET_MODE_page,
		func1_AO_MODE_BLK_page,
		func1_AO_ALARM_SUM_page,
		func1_AO_BATCH_page,
		func1_AO_SP_page,
		func1_AO_PV_SCALE_page,
		func1_AO_POS_D_page,
		func1_AO_OUT_SCALE_page
	}
}

MENU func1_AO_Simple_Dialog_Optional_A
{
	LABEL [PI_func1_AO_Simple_Dialog_Optional_A_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func1_AO_BLOCK_OBJECT_page,
		func1_AO_ST_REV_page,
		func1_AO_TAG_DESC_page,
		func1_AO_STRATEGY_page,
		func1_AO_ALERT_KEY_page,
		func1_AO_TARGET_MODE_page,
		func1_AO_MODE_BLK_page,
		func1_AO_ALARM_SUM_page,
		func1_AO_BATCH_page,
		func1_AO_SP_page,
		func1_AO_PV_SCALE_page,
		func1_AO_READBACK_page,
		func1_AO_RCAS_IN_page,
		func1_AO_IN_CHANNEL_page,
		func1_AO_OUT_CHANNEL_page,
		func1_AO_FSAFE_TIME_page,
		func1_AO_FSAFE_TYPE_page,
		func1_AO_FSAFE_VALUE_page,
		func1_AO_RCAS_OUT_page,
		func1_AO_POS_D_page,
		func1_AO_SETP_DEVIATION_page,
		func1_AO_CHECK_BACK_page,
		func1_AO_CHECK_BACK_MASK_page,
		func1_AO_SIMULATE_page,
		func1_AO_INCREASE_CLOSE_page,
		func1_AO_OUT_page,
		func1_AO_OUT_SCALE_page,
		func1_AO_VIEW_1_page,
		func1_AO_VIEW_2_page,
		func1_AO_VIEW_3_page
	}
}

MENU func1_AO_Simple_Dialog_Mandatory_B
{
	LABEL [PI_func1_AO_Simple_Dialog_Mandatory_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func1_AO_BLOCK_OBJECT_page,
		func1_AO_ST_REV_page,
		func1_AO_TAG_DESC_page,
		func1_AO_STRATEGY_page,
		func1_AO_ALERT_KEY_page,
		func1_AO_TARGET_MODE_page,
		func1_AO_MODE_BLK_page,
		func1_AO_ALARM_SUM_page,
		func1_AO_BATCH_page,
		func1_AO_SP_page,
		func1_AO_PV_SCALE_page,
		func1_AO_READBACK_page,
		func1_AO_IN_CHANNEL_page,
		func1_AO_OUT_CHANNEL_page,
		func1_AO_FSAFE_TIME_page,
		func1_AO_FSAFE_TYPE_page,
		func1_AO_FSAFE_VALUE_page,
		func1_AO_POS_D_page,
		func1_AO_CHECK_BACK_page,
		func1_AO_CHECK_BACK_MASK_page,
		func1_AO_SIMULATE_page,
		func1_AO_INCREASE_CLOSE_page,
		func1_AO_OUT_page,
		func1_AO_OUT_SCALE_page,
		func1_AO_VIEW_1_page
	}
}

MENU func1_AO_Simple_Dialog_Optional_B
{
	LABEL [PI_func1_AO_Simple_Dialog_Optional_B_label];
	STYLE DIALOG;
	ACCESS ONLINE;
	ITEMS
	{
		func1_AO_BLOCK_OBJECT_page,
		func1_AO_ST_REV_page,
		func1_AO_TAG_DESC_page,
		func1_AO_STRATEGY_page,
		func1_AO_ALERT_KEY_page,
		func1_AO_TARGET_MODE_page,
		func1_AO_MODE_BLK_page,
		func1_AO_ALARM_SUM_page,
		func1_AO_BATCH_page,
		func1_AO_SP_page,
		func1_AO_PV_SCALE_page,
		func1_AO_READBACK_page,
		func1_AO_RCAS_IN_page,
		func1_AO_IN_CHANNEL_page,
		func1_AO_OUT_CHANNEL_page,
		func1_AO_FSAFE_TIME_page,
		func1_AO_FSAFE_TYPE_page,
		func1_AO_FSAFE_VALUE_page,
		func1_AO_RCAS_OUT_page,
		func1_AO_POS_D_page,
		func1_AO_SETP_DEVIATION_page,
		func1_AO_CHECK_BACK_page,
		func1_AO_CHECK_BACK_MASK_page,
		func1_AO_SIMULATE_page,
		func1_AO_INCREASE_CLOSE_page,
		func1_AO_OUT_page,
		func1_AO_OUT_SCALE_page,
		func1_AO_VIEW_1_page,
		func1_AO_VIEW_2_page,
		func1_AO_VIEW_3_page
	}
}

MENU func1_AO_BLOCK_OBJECT_page
{
	LABEL [PI_BLOCK_OBJECT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_BLOCK_OBJECT
	}
}

MENU func1_AO_ST_REV_page
{
	LABEL [PI_ST_REV_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_ST_REV
	}
}

MENU func1_AO_TAG_DESC_page
{
	LABEL [PI_TAG_DESC_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_TAG_DESC
	}
}

MENU func1_AO_STRATEGY_page
{
	LABEL [PI_STRATEGY_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_STRATEGY
	}
}

MENU func1_AO_ALERT_KEY_page
{
	LABEL [PI_ALERT_KEY_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_ALERT_KEY
	}
}

MENU func1_AO_TARGET_MODE_page
{
	LABEL [PI_TARGET_MODE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_TARGET_MODE
	}
}

MENU func1_AO_MODE_BLK_page
{
	LABEL [PI_MODE_BLK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_MODE_BLK
	}
}

MENU func1_AO_ALARM_SUM_page
{
	LABEL [PI_ALARM_SUM_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_ALARM_SUM
	}
}

MENU func1_AO_BATCH_page
{
	LABEL [PI_BATCH_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_BATCH
	}
}

MENU func1_AO_SP_page
{
	LABEL [PI_SP_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_SP
	}
}

MENU func1_AO_PV_SCALE_page
{
	LABEL [PI_PV_SCALE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_PV_SCALE
	}
}

MENU func1_AO_READBACK_page
{
	LABEL [PI_READBACK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_READBACK
	}
}

MENU func1_AO_RCAS_IN_page
{
	LABEL [PI_RCAS_IN_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_RCAS_IN
	}
}

MENU func1_AO_IN_CHANNEL_page
{
	LABEL [PI_IN_CHANNEL_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_IN_CHANNEL
	}
}

MENU func1_AO_OUT_CHANNEL_page
{
	LABEL [PI_OUT_CHANNEL_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_OUT_CHANNEL
	}
}

MENU func1_AO_FSAFE_TIME_page
{
	LABEL [PI_FSAFE_TIME_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_FSAFE_TIME
	}
}

MENU func1_AO_FSAFE_TYPE_page
{
	LABEL [PI_FSAFE_TYPE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_FSAFE_TYPE
	}
}

MENU func1_AO_FSAFE_VALUE_page
{
	LABEL [PI_FSAFE_VALUE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_FSAFE_VALUE
	}
}

MENU func1_AO_RCAS_OUT_page
{
	LABEL [PI_RCAS_OUT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_RCAS_OUT
	}
}

MENU func1_AO_POS_D_page
{
	LABEL [PI_POS_D_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_POS_D
	}
}

MENU func1_AO_SETP_DEVIATION_page
{
	LABEL [PI_SETP_DEVIATION_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_SETP_DEVIATION
	}
}

MENU func1_AO_CHECK_BACK_page
{
	LABEL [PI_CHECK_BACK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_CHECK_BACK
	}
}

MENU func1_AO_CHECK_BACK_MASK_page
{
	LABEL [PI_CHECK_BACK_MASK_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_CHECK_BACK_MASK
	}
}

MENU func1_AO_SIMULATE_page
{
	LABEL [PI_SIMULATE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_SIMULATE
	}
}

MENU func1_AO_INCREASE_CLOSE_page
{
	LABEL [PI_INCREASE_CLOSE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_INCREASE_CLOSE
	}
}

MENU func1_AO_OUT_page
{
	LABEL [PI_OUT_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_OUT
	}
}

MENU func1_AO_OUT_SCALE_page
{
	LABEL [PI_OUT_SCALE_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_OUT_SCALE
	}
}

MENU func1_AO_VIEW_1_page
{
	LABEL [PI_VIEW_1_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_VIEW_1
	}
}

MENU func1_AO_VIEW_2_page
{
	LABEL [PI_VIEW_2_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_VIEW_2
	}
}

MENU func1_AO_VIEW_3_page
{
	LABEL [PI_VIEW_3_page_label];
	STYLE PAGE;
	ITEMS
	{
		func1_AO_VIEW_3
	}
}

/* COMMANDs */

COMMAND func1_AO_BLOCK_OBJECT_read
{
	BLOCK func1_AO_block;
	INDEX 0;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_BLOCK_OBJECT_Reserved,
			func1_AO_BLOCK_OBJECT_Block_Object,
			func1_AO_BLOCK_OBJECT_Parent_Class,
			func1_AO_BLOCK_OBJECT_Class,
			func1_AO_BLOCK_OBJECT_Dev_Rev,
			func1_AO_BLOCK_OBJECT_Dev_Rev_Comp,
			func1_AO_BLOCK_OBJECT_DD_Revision,
			func1_AO_BLOCK_OBJECT_Profile,
			func1_AO_BLOCK_OBJECT_Profile_Revision,
			func1_AO_BLOCK_OBJECT_Execution_Time,
			func1_AO_BLOCK_OBJECT_Number_of_Parameters,
			func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Slot,
			func1_AO_BLOCK_OBJECT_Address_of_VIEW_1_Index,
			func1_AO_BLOCK_OBJECT_Number_of_Views
		}
	}
}

COMMAND func1_AO_ST_REV_read
{
	BLOCK func1_AO_block;
	INDEX 1;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_ST_REV
		}
	}
}

COMMAND func1_AO_TAG_DESC_read
{
	BLOCK func1_AO_block;
	INDEX 2;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_TAG_DESC
		}
	}
}

COMMAND func1_AO_TAG_DESC_write
{
	BLOCK func1_AO_block;
	INDEX 2;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_TAG_DESC
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_STRATEGY_read
{
	BLOCK func1_AO_block;
	INDEX 3;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_STRATEGY
		}
	}
}

COMMAND func1_AO_STRATEGY_write
{
	BLOCK func1_AO_block;
	INDEX 3;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_STRATEGY
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_ALERT_KEY_read
{
	BLOCK func1_AO_block;
	INDEX 4;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_ALERT_KEY
		}
	}
}

COMMAND func1_AO_ALERT_KEY_write
{
	BLOCK func1_AO_block;
	INDEX 4;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_ALERT_KEY
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_TARGET_MODE_read
{
	BLOCK func1_AO_block;
	INDEX 5;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_TARGET_MODE
		}
	}
}

COMMAND func1_AO_TARGET_MODE_write
{
	BLOCK func1_AO_block;
	INDEX 5;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_TARGET_MODE
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_MODE_BLK_read
{
	BLOCK func1_AO_block;
	INDEX 6;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_MODE_BLK_Actual,
			func1_AO_MODE_BLK_Permitted,
			func1_AO_MODE_BLK_Normal
		}
	}
}

COMMAND func1_AO_ALARM_SUM_read
{
	BLOCK func1_AO_block;
	INDEX 7;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_ALARM_SUM_Current,
			func1_AO_ALARM_SUM_Unacknowledged,
			func1_AO_ALARM_SUM_Unreported,
			func1_AO_ALARM_SUM_Disabled
		}
	}
}

COMMAND func1_AO_BATCH_read
{
	BLOCK func1_AO_block;
	INDEX 8;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_BATCH_Batch_ID,
			func1_AO_BATCH_Rup,
			func1_AO_BATCH_Operation,
			func1_AO_BATCH_Phase
		}
	}
}

COMMAND func1_AO_BATCH_write
{
	BLOCK func1_AO_block;
	INDEX 8;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_BATCH_Batch_ID,
			func1_AO_BATCH_Rup,
			func1_AO_BATCH_Operation,
			func1_AO_BATCH_Phase
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_SP_read
{
	BLOCK func1_AO_block;
	INDEX 9;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_SP_Value,
			func1_AO_SP_Status_Condensed
		}
	}
}

COMMAND func1_AO_SP_write
{
	BLOCK func1_AO_block;
	INDEX 9;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_SP_Value,
			func1_AO_SP_Status_Condensed
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_PV_SCALE_read
{
	BLOCK func1_AO_block;
	INDEX 11;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_PV_SCALE_Upper_Value,
			func1_AO_PV_SCALE_Lower_Value,
			func1_AO_PV_SCALE_Units_Index,
			func1_AO_PV_SCALE_Decimal_Point
		}
	}
}

COMMAND func1_AO_PV_SCALE_write
{
	BLOCK func1_AO_block;
	INDEX 11;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_PV_SCALE_Upper_Value,
			func1_AO_PV_SCALE_Lower_Value,
			func1_AO_PV_SCALE_Units_Index,
			func1_AO_PV_SCALE_Decimal_Point
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_READBACK_read
{
	BLOCK func1_AO_block;
	INDEX 12;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_READBACK_Value,
			func1_AO_READBACK_Status_Condensed
		}
	}
}

COMMAND func1_AO_RCAS_IN_read
{
	BLOCK func1_AO_block;
	INDEX 14;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_RCAS_IN_Value,
			func1_AO_RCAS_IN_Status_Condensed
		}
	}
}

COMMAND func1_AO_RCAS_IN_write
{
	BLOCK func1_AO_block;
	INDEX 14;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_RCAS_IN_Value,
			func1_AO_RCAS_IN_Status_Condensed
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_IN_CHANNEL_read
{
	BLOCK func1_AO_block;
	INDEX 21;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_IN_CHANNEL
		}
	}
}

COMMAND func1_AO_IN_CHANNEL_write
{
	BLOCK func1_AO_block;
	INDEX 21;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_IN_CHANNEL
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_OUT_CHANNEL_read
{
	BLOCK func1_AO_block;
	INDEX 22;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_OUT_CHANNEL
		}
	}
}

COMMAND func1_AO_OUT_CHANNEL_write
{
	BLOCK func1_AO_block;
	INDEX 22;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_OUT_CHANNEL
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_FSAFE_TIME_read
{
	BLOCK func1_AO_block;
	INDEX 23;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_FSAFE_TIME
		}
	}
}

COMMAND func1_AO_FSAFE_TIME_write
{
	BLOCK func1_AO_block;
	INDEX 23;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_FSAFE_TIME
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_FSAFE_TYPE_read
{
	BLOCK func1_AO_block;
	INDEX 24;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_FSAFE_TYPE
		}
	}
}

COMMAND func1_AO_FSAFE_TYPE_write
{
	BLOCK func1_AO_block;
	INDEX 24;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_FSAFE_TYPE
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_FSAFE_VALUE_read
{
	BLOCK func1_AO_block;
	INDEX 25;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_FSAFE_VALUE
		}
	}
}

COMMAND func1_AO_FSAFE_VALUE_write
{
	BLOCK func1_AO_block;
	INDEX 25;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_FSAFE_VALUE
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_RCAS_OUT_read
{
	BLOCK func1_AO_block;
	INDEX 27;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_RCAS_OUT_Value,
			func1_AO_RCAS_OUT_Status_Condensed
		}
	}
}

COMMAND func1_AO_POS_D_read
{
	BLOCK func1_AO_block;
	INDEX 31;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_POS_D_Value,
			func1_AO_POS_D_Status_Condensed
		}
	}
}

COMMAND func1_AO_SETP_DEVIATION_read
{
	BLOCK func1_AO_block;
	INDEX 32;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_SETP_DEVIATION
		}
	}
}

COMMAND func1_AO_CHECK_BACK_read
{
	BLOCK func1_AO_block;
	INDEX 33;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_CHECK_BACK
		}
	}
}

COMMAND func1_AO_CHECK_BACK_MASK_read
{
	BLOCK func1_AO_block;
	INDEX 34;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_CHECK_BACK_MASK
		}
	}
}

COMMAND func1_AO_SIMULATE_read
{
	BLOCK func1_AO_block;
	INDEX 35;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_SIMULATE_Status_Condensed,
			func1_AO_SIMULATE_Value,
			func1_AO_SIMULATE_Enabled
		}
	}
}

COMMAND func1_AO_SIMULATE_write
{
	BLOCK func1_AO_block;
	INDEX 35;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_SIMULATE_Status_Condensed,
			func1_AO_SIMULATE_Value,
			func1_AO_SIMULATE_Enabled
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_INCREASE_CLOSE_read
{
	BLOCK func1_AO_block;
	INDEX 36;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_INCREASE_CLOSE
		}
	}
}

COMMAND func1_AO_INCREASE_CLOSE_write
{
	BLOCK func1_AO_block;
	INDEX 36;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_INCREASE_CLOSE
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_OUT_read
{
	BLOCK func1_AO_block;
	INDEX 37;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_OUT_Value,
			func1_AO_OUT_Status_Condensed
		}
	}
}

COMMAND func1_AO_OUT_write
{
	BLOCK func1_AO_block;
	INDEX 37;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_OUT_Value,
			func1_AO_OUT_Status_Condensed
		}
		REPLY
		{
		}
	}
}

COMMAND func1_AO_OUT_SCALE_read
{
	BLOCK func1_AO_block;
	INDEX 38;
	OPERATION READ;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_AO_OUT_SCALE_Upper_Value,
			func1_AO_OUT_SCALE_Lower_Value,
			func1_AO_OUT_SCALE_Units_Index,
			func1_AO_OUT_SCALE_Decimal_Point
		}
	}
}

COMMAND func1_AO_OUT_SCALE_write
{
	BLOCK func1_AO_block;
	INDEX 38;
	OPERATION WRITE;
	RESPONSE_CODES DPV1_PA_rsp_codes;
	TRANSACTION
	{
		REQUEST
		{
			func1_AO_OUT_SCALE_Upper_Value,
			func1_AO_OUT_SCALE_Lower_Value,
			func1_AO_OUT_SCALE_Units_Index,
			func1_AO_OUT_SCALE_Decimal_Point
		}
		REPLY
		{
		}
	}
}

/* BEGIN post EDD */


// Aman, Bman:
// - UNIT func1_AO_PV_SCALE_unit_1

UNIT func1_AO_PV_SCALE_unit_1
{
	func1_AO_PV_SCALE_Units_Index:

	func1_AO_PV_SCALE_Upper_Value,
	func1_AO_PV_SCALE_Lower_Value,
        func1_AO_SP_Value
}

// Aopt, Bman:
// - UNIT func1_AO_PV_SCALE_unit_2

UNIT func1_AO_PV_SCALE_unit_2
{
	func1_AO_PV_SCALE_Units_Index:

	func1_AO_FSAFE_VALUE,
	func1_AO_SIMULATE_Value,
        func1_AO_READBACK_Value  
}

// Aopt, Bopt:
// - UNIT func1_AO_PV_SCALE_unit_3

UNIT func1_AO_PV_SCALE_unit_3
{
	func1_AO_PV_SCALE_Units_Index:

	func1_AO_RCAS_OUT_Value,
        func1_AO_RCAS_IN_Value
}

// Aman, Bman:
// - UNIT func1_AO_OUT_SCALE_unit_1

UNIT func1_AO_OUT_SCALE_unit_1
{
	func1_AO_OUT_SCALE_Units_Index:

	func1_AO_OUT_SCALE_Upper_Value,
	func1_AO_OUT_SCALE_Lower_Value
}

// Aopt, Bman:
// - UNIT func1_AO_OUT_SCALE_unit_2

UNIT func1_AO_OUT_SCALE_unit_2
{
	func1_AO_OUT_SCALE_Units_Index:

	func1_AO_OUT_Value
}
/* END post EDD */
