/*
//----------------------------------------------------------------------------
// TRANSDUCER BLOCK PARAMETER DEFINES
//----------------------------------------------------------------------------

*/
/*
//----------------------------------------------------------------------------
// Variable MEAS_TYPE: !!! Important !!! Select the Meas Type according to your sensor
//----------------------------------------------------------------------------
*/
#define LBL_MEAS_TYPE_18                             "Meas Type|de|Messgre"
#define HLP_MEAS_TYPE_18                             "!!! Important !!! Select the Meas Type according to your sensor|de|!!!Wichtig!!!Setzen Sie hier Ihre Messgre entsprechend Ihrem Sensor (pH, Leitfhigkeit, Sauerstoff)"
#define LBL_MEAS_TYPE_18_VAL_0                       "pH"
#define HLP_MEAS_TYPE_18_VAL_0                       "Select pH to measure with pH sensors"
#define LBL_MEAS_TYPE_18_VAL_1                       "Conductivity|de|Leifhigkeit"
#define HLP_MEAS_TYPE_18_VAL_1                       "Select Cond to measure conductivity"
#define LBL_MEAS_TYPE_18_VAL_2                       "Torodial Conductivity|de|Induktive Leitfhigkeit"
#define HLP_MEAS_TYPE_18_VAL_2                       "Select CondI to measure torodial conductivity"
#define LBL_MEAS_TYPE_18_VAL_3                       "Conductivity-Conductivity|de|Leitfhigkeit-Leitfhigkeit"
#define HLP_MEAS_TYPE_18_VAL_3                       "Select CC to measure with two conductivity sensors"
#define LBL_MEAS_TYPE_18_VAL_4                       "Disolved Oxygen|de|Sauerstoff"
#define HLP_MEAS_TYPE_18_VAL_4                       "Select DO to measure oxygen"
/*
//----------------------------------------------------------------------------
// Variable pH: PH-parameters
//----------------------------------------------------------------------------
*/
#define LBL_PH_19                                    "pH"
#define HLP_PH_19                                    "PH-parameters"
/*
//----------------------------------------------------------------------------
// Variable SENSORTYPE: Select the sensor type for pH.|de|Whlen Sie den Sensortyp fr pH
//----------------------------------------------------------------------------
*/
#define LBL_SENSORTYPE_19                            "Sensortype|de|Sensortyp"
#define HLP_SENSORTYPE_19                            "Select the sensor type for pH.|de|Whlen Sie den Sensortyp fr pH"
#define LBL_SENSORTYPE_19_VAL_6                      "Standard"
#define HLP_SENSORTYPE_19_VAL_6                      "Select to meas with analogue pH sensors"
#define LBL_SENSORTYPE_19_VAL_7                      "Isfet"
#define HLP_SENSORTYPE_19_VAL_7                      "Select to meas with pH Isfet sensors"
#define LBL_SENSORTYPE_19_VAL_14                     "Memosens"
#define HLP_SENSORTYPE_19_VAL_14                     "Select to meas with Memosens pH sensors"
#define LBL_SENSORTYPE_19_VAL_18                     "Pfaudler"
#define HLP_SENSORTYPE_19_VAL_18                     "Select to meas with Pfaudler sensors"
#define LBL_SENSORTYPE_19_VAL_13                     "ISM"
#define HLP_SENSORTYPE_19_VAL_13                     "Select to meas with ISM pH sensors"
/*
//----------------------------------------------------------------------------
// Variable MEAS_MODE: Select the display unit.|de|Anzeigeeinheit auswhlen
//----------------------------------------------------------------------------
*/
#define LBL_MEAS_MODE_19                             "Meas Mode|de|Messmodus"
#define HLP_MEAS_MODE_19                             "Select the display unit.|de|Anzeigeeinheit auswhlen"
#define LBL_MEAS_MODE_19_VAL_0                       "pH"
#define HLP_MEAS_MODE_19_VAL_0                       "Sets pH as main display unit."
#define LBL_MEAS_MODE_19_VAL_1                       "mV"
#define HLP_MEAS_MODE_19_VAL_1                       "Sets mV as main display unit."
#define LBL_MEAS_MODE_19_VAL_2                       "ORP"
#define HLP_MEAS_MODE_19_VAL_2                       "Sets ORP as main display unit."
/*
//----------------------------------------------------------------------------
// Variable RTD_TYPE: Select the temperature sensor|de|Auswahl des Temperatursensors
//----------------------------------------------------------------------------
*/
#define LBL_RTD_TYPE_19                              "RTD Type|de|Temperaturfhlertyp"
#define HLP_RTD_TYPE_19                              "Select the temperature sensor|de|Auswahl des Temperatursensors"
#define LBL_RTD_TYPE_19_VAL_0                        "100 PT"
#define HLP_RTD_TYPE_19_VAL_0                        "Select to meas with 100PT"
#define LBL_RTD_TYPE_19_VAL_1                        "1000 PT"
#define HLP_RTD_TYPE_19_VAL_1                        "Select to meas with 1000PT"
#define LBL_RTD_TYPE_19_VAL_5                        "30 NTC"
#define HLP_RTD_TYPE_19_VAL_5                        "Select to meas with 30 NTC"
#define LBL_RTD_TYPE_19_VAL_2                        "8,55 NTC"
#define HLP_RTD_TYPE_19_VAL_2                        "Select to meas with 8,55 NTC"
#define LBL_RTD_TYPE_19_VAL_8                        "BALCO"
#define HLP_RTD_TYPE_19_VAL_8                        "Select to meas with BALCO"
/*
//----------------------------------------------------------------------------
// Variable TEMP_UNIT: Select the shown temperature unit for the display|de|Temperatureinheit
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_UNIT_19                             "Temperature Unit|de|Temperatureinheit"
#define HLP_TEMP_UNIT_19                             "Select the shown temperature unit for the display|de|Temperatureinheit"
#define LBL_TEMP_UNIT_19_VAL_39                      "C"
#define HLP_TEMP_UNIT_19_VAL_39                      "Temperature unit is C"
#define LBL_TEMP_UNIT_19_VAL_40                      "F"
#define HLP_TEMP_UNIT_19_VAL_40                      "Temperature unit is F"
/*
//----------------------------------------------------------------------------
// Variable TEMP_MEAS: Select which temperature is used for calculation while normal measurement|de|Verwendete Temperatur whrend der Messung
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_MEAS_19                             "Temperature Meas|de|Messtemperatur"
#define HLP_TEMP_MEAS_19                             "Select which temperature is used for calculation while normal measurement|de|Verwendete Temperatur whrend der Messung"
#define LBL_TEMP_MEAS_19_VAL_0                       "Auto"
#define HLP_TEMP_MEAS_19_VAL_0                       "Use the temperature from the device"
#define LBL_TEMP_MEAS_19_VAL_1                       "Man"
#define HLP_TEMP_MEAS_19_VAL_1                       "Use manual temperature"
#define LBL_TEMP_MEAS_19_VAL_2                       "Bus"
#define HLP_TEMP_MEAS_19_VAL_2                       "Use the temperature from fieldbus"
/*
//----------------------------------------------------------------------------
// Variable TEMP_MEAS_MAN: Enter the temperature value if TEMP_MEAS is selected MAN|de|Manueller Wert
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_MEAS_MAN_19                         "Temperature Meas Manual Value|de|Manuelle Messtemperatur"
#define HLP_TEMP_MEAS_MAN_19                         "Enter the temperature value if TEMP_MEAS is selected MAN|de|Manueller Wert"
/*
//----------------------------------------------------------------------------
// Variable TEMP_CAL: Select which temperature is used for calibration|de|Verwendete Temperatur whrend der Kalibrierung
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_CAL_19                              "Temperature Calibration|de|Kalibriertemperatur"
#define HLP_TEMP_CAL_19                              "Select which temperature is used for calibration|de|Verwendete Temperatur whrend der Kalibrierung"
#define LBL_TEMP_CAL_19_VAL_0                        "Auto"
#define HLP_TEMP_CAL_19_VAL_0                        "Use the temperature from the device"
#define LBL_TEMP_CAL_19_VAL_1                        "Man"
#define HLP_TEMP_CAL_19_VAL_1                        "Use manual temperature"
#define LBL_TEMP_CAL_19_VAL_2                        "Bus"
#define HLP_TEMP_CAL_19_VAL_2                        "Use the temperature from fieldbus"
/*
//----------------------------------------------------------------------------
// Variable TEMP_CAL_MAN: Enter the temperature value if TEMP_CAL is selected MAN|de|Manueller Wert
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_CAL_MAN_19                          "Temperature Cal Manual Value|de|Manuelle Kalibriertemperatur"
#define HLP_TEMP_CAL_MAN_19                          "Enter the temperature value if TEMP_CAL is selected MAN|de|Manueller Wert"
/*
//----------------------------------------------------------------------------
// Variable NOM_ZERO: Enter the nominal zero point for Pfaudler sensors|de|Nur bei Pfaudler Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_NOM_ZERO_19                              "Nominal Zero|de|Nomineller Nullpunkt"
#define HLP_NOM_ZERO_19                              "Enter the nominal zero point for Pfaudler sensors|de|Nur bei Pfaudler Sensoren"
/*
//----------------------------------------------------------------------------
// Variable NOM_SLOPE: Enter the nominal slope point for Pfaudler sensors|de|Nur bei Pfaudler Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_NOM_SLOPE_19                             "Nominal Slope|de|Nominelle Steilheit"
#define HLP_NOM_SLOPE_19                             "Enter the nominal slope point for Pfaudler sensors|de|Nur bei Pfaudler Sensoren"
/*
//----------------------------------------------------------------------------
// Variable PH_ISO: Enter the pH Iso for Pfaudler sensors|de|Nur bei Pfaudler Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_PH_ISO_19                                "pH Iso|de|pH Iso"
#define HLP_PH_ISO_19                                "Enter the pH Iso for Pfaudler sensors|de|Nur bei Pfaudler Sensoren"
/*
//----------------------------------------------------------------------------
// Variable CALMODE: Select the calibration mode.|de|Kalibriermodus
//----------------------------------------------------------------------------
*/
#define LBL_CALMODE_19                               "Calibration Mode|de|Kalibriermodus"
#define HLP_CALMODE_19                               "Select the calibration mode.|de|Kalibriermodus"
#define LBL_CALMODE_19_VAL_0                         "Auto"
#define HLP_CALMODE_19_VAL_0                         "Select if you want to use the Calimatic for calibration."
#define LBL_CALMODE_19_VAL_1                         "Man"
#define HLP_CALMODE_19_VAL_1                         "Select if you want to make a manual calibration"
#define LBL_CALMODE_19_VAL_2                         "Dat"
#define HLP_CALMODE_19_VAL_2                         "Select if you want to enter the calibration data directly."
/*
//----------------------------------------------------------------------------
// Variable BUFFER_SET: select the buffer set used if CALMODE is AUTO |de|Puffersatz bei automatischer Kalibrierung(Calimatic)
//----------------------------------------------------------------------------
*/
#define LBL_BUFFER_SET_19                            "Buffer Set|de|Puffersatz"
#define HLP_BUFFER_SET_19                            "select the buffer set used if CALMODE is AUTO |de|Puffersatz bei automatischer Kalibrierung(Calimatic)"
#define LBL_BUFFER_SET_19_VAL_0                      " -00- Knick"
#define HLP_BUFFER_SET_19_VAL_0                      "2.00, 4.01, 7.00, 9.21"
#define LBL_BUFFER_SET_19_VAL_1                      " -01- Mettler-Toledo"
#define HLP_BUFFER_SET_19_VAL_1                      "2.00, 4.01, 7.00, 9.21"
#define LBL_BUFFER_SET_19_VAL_2                      " -02- Knick CaliMat"
#define HLP_BUFFER_SET_19_VAL_2                      "2.00, 4.00, 7.00, 9.00, 12.00"
#define LBL_BUFFER_SET_19_VAL_3                      " -03- Ciba (94)"
#define HLP_BUFFER_SET_19_VAL_3                      "2.06, 4.00, 7.00, 10.00"
#define LBL_BUFFER_SET_19_VAL_4                      " -04- NIST Technisch"
#define HLP_BUFFER_SET_19_VAL_4                      "1.68, 4.00, 7.00, 10.01, 12.46"
#define LBL_BUFFER_SET_19_VAL_5                      " -05- NIST Standard"
#define HLP_BUFFER_SET_19_VAL_5                      "1.679,4.006,  6.865,  9.18, (12.454)"
#define LBL_BUFFER_SET_19_VAL_6                      " -06- Hach"
#define HLP_BUFFER_SET_19_VAL_6                      "4.01, 7.00, 10.01"
#define LBL_BUFFER_SET_19_VAL_7                      " -07- WTW techn. Puffer"
#define HLP_BUFFER_SET_19_VAL_7                      "2.00, 4.01, 7.00, 10.00"
#define LBL_BUFFER_SET_19_VAL_8                      " -08- Hamilton"
#define HLP_BUFFER_SET_19_VAL_8                      "2.00, 4.01, 7.00, 10.01, 12.00"
#define LBL_BUFFER_SET_19_VAL_9                      " -09- Reagecon"
#define HLP_BUFFER_SET_19_VAL_9                      "2.00, 4.00, 7.00, 9.00, 12.00"
#define LBL_BUFFER_SET_19_VAL_10                     " -10- DIN 19267"
#define HLP_BUFFER_SET_19_VAL_10                     "1.09, 4.65, 6.79, 9.23, 12.75"
#define LBL_BUFFER_SET_19_VAL_11                     "-U1- User Buffer|de|-U1- Anwender-Puffer"
#define HLP_BUFFER_SET_19_VAL_11                     "Select if you want to use your own buffer set."
/*
//----------------------------------------------------------------------------
// Variable CAL_TIMER: Calibration timer is used to remind you for a calibration. Not for ISM sensors.|de|Kalibrierzyklus einstellen
//----------------------------------------------------------------------------
*/
#define LBL_CAL_TIMER_19                             "Calibration Timer|de|Kalibriertimer"
#define HLP_CAL_TIMER_19                             "Calibration timer is used to remind you for a calibration. Not for ISM sensors.|de|Kalibrierzyklus einstellen"
#define LBL_CAL_TIMER_19_VAL_0                       "Off|de|Aus"
#define HLP_CAL_TIMER_19_VAL_0                       "Select to disable calibration timer"
#define LBL_CAL_TIMER_19_VAL_1                       "Fix"
#define HLP_CAL_TIMER_19_VAL_1                       "Select if you want to use the calibration timer with a value set manually"
#define LBL_CAL_TIMER_19_VAL_2                       "Adaptive"
#define HLP_CAL_TIMER_19_VAL_2                       "Select if you want to use the adaptive calibration timer"
/*
//----------------------------------------------------------------------------
// Variable CAL_CYCLE: Enter a value if CAL_TIMER is set to Fix.|de|Wert des Kalriberirtimers
//----------------------------------------------------------------------------
*/
#define LBL_CAL_CYCLE_19                             "Calibration Cycle|de|Kalibrierzyklen"
#define HLP_CAL_CYCLE_19                             "Enter a value if CAL_TIMER is set to Fix.|de|Wert des Kalriberirtimers"
/*
//----------------------------------------------------------------------------
// Variable ACT: Only for ISM sensors.|de|Nur bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_ACT_19                                   "ACT|de|ACT"
#define HLP_ACT_19                                   "Only for ISM sensors.|de|Nur bei ISM Sensoren."
#define LBL_ACT_19_VAL_0                             "Off|de|Aus"
#define HLP_ACT_19_VAL_0                             "Select to switch off."
#define LBL_ACT_19_VAL_1                             "Auto"
#define HLP_ACT_19_VAL_1                             "Select to use automatic"
#define LBL_ACT_19_VAL_2                             "Man"
#define HLP_ACT_19_VAL_2                             "Select to use manual"
/*
//----------------------------------------------------------------------------
// Variable ACT_CYCLE: Enter a value if ACT is set to MAN.|de|Nur bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_ACT_CYCLE_19                             "ACT Cycle|de|ACT Zyklen"
#define HLP_ACT_CYCLE_19                             "Enter a value if ACT is set to MAN.|de|Nur bei ISM Sensoren."
/*
//----------------------------------------------------------------------------
// Variable TTM: Enable Time To Maintenacne. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_TTM_19                                   "TTM|de|TTM"
#define HLP_TTM_19                                   "Enable Time To Maintenacne. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren."
#define LBL_TTM_19_VAL_0                             "Off|de|Aus"
#define HLP_TTM_19_VAL_0                             "Select to switch off."
#define LBL_TTM_19_VAL_1                             "Auto"
#define HLP_TTM_19_VAL_1                             "Select to use automatic"
#define LBL_TTM_19_VAL_2                             "Man"
#define HLP_TTM_19_VAL_2                             "Select to use manual"
/*
//----------------------------------------------------------------------------
// Variable TTM_CYCLE: Enter value for reminding maintenance. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_TTM_CYCLE_19                             "TTM Cycle|de|TTM Zyklen"
#define HLP_TTM_CYCLE_19                             "Enter value for reminding maintenance. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren."
/*
//----------------------------------------------------------------------------
// Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_CIP_COUNT_19                             "CIP Count|de|CIP Zhler"
#define HLP_CIP_COUNT_19                             "To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_CIP_COUNT_19_VAL_0                       "Off|de|Aus"
#define HLP_CIP_COUNT_19_VAL_0                       "Selecto to switch off"
#define LBL_CIP_COUNT_19_VAL_1                       "On|de|An"
#define HLP_CIP_COUNT_19_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable CIP_CYCLES: Enter value if CIP_COUNT is enabled.|de|CIP Zyklen einstellen.
//----------------------------------------------------------------------------
*/
#define LBL_CIP_CYCLES_19                            "CIP Cycles|de|CIP Zyklen"
#define HLP_CIP_CYCLES_19                            "Enter value if CIP_COUNT is enabled.|de|CIP Zyklen einstellen."
/*
//----------------------------------------------------------------------------
// Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_SIP_COUNT_19                             "SIP Count|de|SIP Zhler"
#define HLP_SIP_COUNT_19                             "To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_SIP_COUNT_19_VAL_0                       "Off|de|Aus"
#define HLP_SIP_COUNT_19_VAL_0                       "Selecto to switch off"
#define LBL_SIP_COUNT_19_VAL_1                       "On|de|An"
#define HLP_SIP_COUNT_19_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable SIP_CYCLES: Enter value if SIP_COUNT is enabled.|de|SIP Zyklen einstellen.
//----------------------------------------------------------------------------
*/
#define LBL_SIP_CYCLES_19                            "SIP Cycles Warning|de|SIP Zyklen (Warngrenze)"
#define HLP_SIP_CYCLES_19                            "Enter value if SIP_COUNT is enabled.|de|SIP Zyklen einstellen."
/*
//----------------------------------------------------------------------------
// Variable AUTOCLAVE: To enable autoclave count alarm for Memosens and ISM sensors|de|Autoklavierzhler Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_AUTOCLAVE_19                             "Autoclave|de|Autoklavierzhler"
#define HLP_AUTOCLAVE_19                             "To enable autoclave count alarm for Memosens and ISM sensors|de|Autoklavierzhler Alarm for Memosens and ISM Sensoren"
#define LBL_AUTOCLAVE_19_VAL_0                       "Off|de|Aus"
#define HLP_AUTOCLAVE_19_VAL_0                       "Selecto to switch off"
#define LBL_AUTOCLAVE_19_VAL_1                       "On|de|An"
#define HLP_AUTOCLAVE_19_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable AC_CYCLES: Enter value if AUTOCLAVE is enabled.|de|Autoklavierzyklen einstellen.
//----------------------------------------------------------------------------
*/
#define LBL_AC_CYCLES_19                             "AC Cycles|de|Autoklavierzyklen"
#define HLP_AC_CYCLES_19                             "Enter value if AUTOCLAVE is enabled.|de|Autoklavierzyklen einstellen."
/*
//----------------------------------------------------------------------------
// Variable TC_SELECT: Select if temperature compensation is needed|de|Temperaturkompensation einstellen
//----------------------------------------------------------------------------
*/
#define LBL_TC_SELECT_19                             "Tc Select|de|Temperaturkompensation"
#define HLP_TC_SELECT_19                             "Select if temperature compensation is needed|de|Temperaturkompensation einstellen"
#define LBL_TC_SELECT_19_VAL_0                       "Off|de|Aus"
#define HLP_TC_SELECT_19_VAL_0                       "Select temperature compensation"
#define LBL_TC_SELECT_19_VAL_1                       "linear|de|Linear"
#define HLP_TC_SELECT_19_VAL_1                       "Select temperature compensation"
#define LBL_TC_SELECT_19_VAL_8                       "Pure Water|de|Reinwasser"
#define HLP_TC_SELECT_19_VAL_8                       "Select temperature compensation"
#define LBL_TC_SELECT_19_VAL_7                       "User Table|de|Anwendertabelle"
#define HLP_TC_SELECT_19_VAL_7                       "Select temperature compensation"
/*
//----------------------------------------------------------------------------
// Variable TC_LIQUID: Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_TC_LIQUID_19                             "Tc Liquid|de|Lin. Temperaturkompensation"
#define HLP_TC_LIQUID_19                             "Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable CONDUCTIVITY: Conductivity parameters
//----------------------------------------------------------------------------
*/
#define LBL_CONDUCTIVITY_20                          "Conductivity"
#define HLP_CONDUCTIVITY_20                          "Conductivity parameters"
/*
//----------------------------------------------------------------------------
// Variable SENSORTYPE: Select the sensor type for conductivity.|de|Whlen Sie den Sensortyp fr Leitfhigkeit
//----------------------------------------------------------------------------
*/
#define LBL_SENSORTYPE_20                            "Sensortype|de|Sensortyp"
#define HLP_SENSORTYPE_20                            "Select the sensor type for conductivity.|de|Whlen Sie den Sensortyp fr Leitfhigkeit"
#define LBL_SENSORTYPE_20_VAL_11                     "2-Electrode"
#define HLP_SENSORTYPE_20_VAL_11                     "For analog 2 electode sensors"
#define LBL_SENSORTYPE_20_VAL_12                     "4-Electrode"
#define HLP_SENSORTYPE_20_VAL_12                     "For analog 4 electode sensors"
#define LBL_SENSORTYPE_20_VAL_14                     "Memosens"
#define HLP_SENSORTYPE_20_VAL_14                     "Select if you want to use Memosens."
/*
//----------------------------------------------------------------------------
// Variable MEAS_MODE: Select the display unit.|de|Anzeigeeinheit auswhlen
//----------------------------------------------------------------------------
*/
#define LBL_MEAS_MODE_20                             "Meas Mode|de|Messmodus"
#define HLP_MEAS_MODE_20                             "Select the display unit.|de|Anzeigeeinheit auswhlen"
#define LBL_MEAS_MODE_20_VAL_0                       "Cond"
#define HLP_MEAS_MODE_20_VAL_0                       "Meas Conductivity"
#define LBL_MEAS_MODE_20_VAL_1                       "Conc %"
#define HLP_MEAS_MODE_20_VAL_1                       "Meas Concentration"
#define LBL_MEAS_MODE_20_VAL_2                       "SAL /oo"
#define HLP_MEAS_MODE_20_VAL_2                       "Meas Salinity"
#define LBL_MEAS_MODE_20_VAL_3                       "USP S/c"
#define HLP_MEAS_MODE_20_VAL_3                       "Use USP function"
#define LBL_MEAS_MODE_20_VAL_4                       "Tds"
#define HLP_MEAS_MODE_20_VAL_4                       "Meas TDS"
/*
//----------------------------------------------------------------------------
// Variable DISPLAY_UNIT: Select Displayformat on transmitter|de|Auswahl Anzeigeformat
//----------------------------------------------------------------------------
*/
#define LBL_DISPLAY_UNIT_20                          "Display Unit|de|Anzeigeeinheit"
#define HLP_DISPLAY_UNIT_20                          "Select Displayformat on transmitter|de|Auswahl Anzeigeformat"
#define LBL_DISPLAY_UNIT_20_VAL_25                   "o.ooo S/cm"
#define HLP_DISPLAY_UNIT_20_VAL_25                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_24                   "oo.oo S/cm"
#define HLP_DISPLAY_UNIT_20_VAL_24                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_23                   "ooo.o S/cm"
#define HLP_DISPLAY_UNIT_20_VAL_23                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_22                   "oooo S/cm"
#define HLP_DISPLAY_UNIT_20_VAL_22                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_21                   "o.ooo mS/cm"
#define HLP_DISPLAY_UNIT_20_VAL_21                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_20                   "oo.oo mS/cm"
#define HLP_DISPLAY_UNIT_20_VAL_20                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_19                   "ooo.o mS/cm"
#define HLP_DISPLAY_UNIT_20_VAL_19                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_17                   "o.ooo S/m"
#define HLP_DISPLAY_UNIT_20_VAL_17                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_16                   "oo.oo S/m"
#define HLP_DISPLAY_UNIT_20_VAL_16                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_20_VAL_55                   "oo.oo MOhm"
#define HLP_DISPLAY_UNIT_20_VAL_55                   "Select Displayformat on transmitter"
/*
//----------------------------------------------------------------------------
// Variable SOLUTION: Select solution of concentration|de|Auswahl der Konzentrationslsung
//----------------------------------------------------------------------------
*/
#define LBL_SOLUTION_20                              "Solution|de|Lsung (Konz.)"
#define HLP_SOLUTION_20                              "Select solution of concentration|de|Auswahl der Konzentrationslsung"
#define LBL_SOLUTION_20_VAL_0                        "-01- (NaCl)"
#define HLP_SOLUTION_20_VAL_0                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_1                        "-02- (HCl)"
#define HLP_SOLUTION_20_VAL_1                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_2                        "-03- (NaOH)"
#define HLP_SOLUTION_20_VAL_2                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_3                        "-04- (H2SO4)"
#define HLP_SOLUTION_20_VAL_3                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_4                        "-05- (HNO3)"
#define HLP_SOLUTION_20_VAL_4                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_5                        "-06- (H2SO4)"
#define HLP_SOLUTION_20_VAL_5                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_6                        "-07- (HCl)"
#define HLP_SOLUTION_20_VAL_6                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_7                        "-08- (HNO3)"
#define HLP_SOLUTION_20_VAL_7                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_8                        "-09- (H2SO4)"
#define HLP_SOLUTION_20_VAL_8                        "Select solution of concentration"
#define LBL_SOLUTION_20_VAL_9                        "-10- (NaOH)"
#define HLP_SOLUTION_20_VAL_9                        "Select solution of concentration"
/*
//----------------------------------------------------------------------------
// Variable RTD_TYPE: Select the temperature sensor|de|Auswahl des Temperatursensors
//----------------------------------------------------------------------------
*/
#define LBL_RTD_TYPE_20                              "RTD Type|de|RTD Typ"
#define HLP_RTD_TYPE_20                              "Select the temperature sensor|de|Auswahl des Temperatursensors"
#define LBL_RTD_TYPE_20_VAL_0                        "100 PT"
#define HLP_RTD_TYPE_20_VAL_0                        "Select temperature probe"
#define LBL_RTD_TYPE_20_VAL_1                        "1000 PT"
#define HLP_RTD_TYPE_20_VAL_1                        "Select temperature probe"
#define LBL_RTD_TYPE_20_VAL_7                        "100 Ni"
#define HLP_RTD_TYPE_20_VAL_7                        "Select temperature probe"
#define LBL_RTD_TYPE_20_VAL_2                        "8.55 NTC"
#define HLP_RTD_TYPE_20_VAL_2                        "Select temperature probe"
#define LBL_RTD_TYPE_20_VAL_5                        "30 NTC"
#define HLP_RTD_TYPE_20_VAL_5                        "Select temperature probe"
/*
//----------------------------------------------------------------------------
// Variable TEMP_UNIT: Select the shown temperature unit for the display|de|Temperatureinheit
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_UNIT_20                             "Temperature Unit|de|Temperatureinheit"
#define HLP_TEMP_UNIT_20                             "Select the shown temperature unit for the display|de|Temperatureinheit"
#define LBL_TEMP_UNIT_20_VAL_39                      "C"
#define HLP_TEMP_UNIT_20_VAL_39                      "Temperature unit is C"
#define LBL_TEMP_UNIT_20_VAL_40                      "F"
#define HLP_TEMP_UNIT_20_VAL_40                      "Temperature unit is F"
/*
//----------------------------------------------------------------------------
// Variable TEMPERATURE: Select which temperature is used for calculation while normal measurement|de|Verwendete Temperatur whrend der Messung
//----------------------------------------------------------------------------
*/
#define LBL_TEMPERATURE_20                           "Temperature Meas|de|Messtemperatur"
#define HLP_TEMPERATURE_20                           "Select which temperature is used for calculation while normal measurement|de|Verwendete Temperatur whrend der Messung"
#define LBL_TEMPERATURE_20_VAL_0                     "Auto"
#define HLP_TEMPERATURE_20_VAL_0                     "Use the temperature from the device"
#define LBL_TEMPERATURE_20_VAL_1                     "Man"
#define HLP_TEMPERATURE_20_VAL_1                     "Use manual temperature"
#define LBL_TEMPERATURE_20_VAL_2                     "Bus"
#define HLP_TEMPERATURE_20_VAL_2                     "Use the temperature from fieldbus"
/*
//----------------------------------------------------------------------------
// Variable TEMPERATURE_MAN: Enter the temperature value if TEMP_MEAS is selected MAN|de|Manueller Wert
//----------------------------------------------------------------------------
*/
#define LBL_TEMPERATURE_MAN_20                       "Temperature Meas Manual Value|de|Manuelle Messtemperatur"
#define HLP_TEMPERATURE_MAN_20                       "Enter the temperature value if TEMP_MEAS is selected MAN|de|Manueller Wert"
/*
//----------------------------------------------------------------------------
// Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_CIP_COUNT_20                             "CIP Count|de|CIP Zhler"
#define HLP_CIP_COUNT_20                             "To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_CIP_COUNT_20_VAL_0                       "Off|de|Aus"
#define HLP_CIP_COUNT_20_VAL_0                       "Selecto to switch off"
#define LBL_CIP_COUNT_20_VAL_1                       "On|de|An"
#define HLP_CIP_COUNT_20_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_SIP_COUNT_20                             "SIP Count|de|SIP Zhler"
#define HLP_SIP_COUNT_20                             "To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_SIP_COUNT_20_VAL_0                       "Off|de|Aus"
#define HLP_SIP_COUNT_20_VAL_0                       "Selecto to switch off"
#define LBL_SIP_COUNT_20_VAL_1                       "On|de|An"
#define HLP_SIP_COUNT_20_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable TC_SELECT: Select if temperature compensation is needed|de|Temperaturkompensation einstellen
//----------------------------------------------------------------------------
*/
#define LBL_TC_SELECT_20                             "Tc Select|de|Temperaturkompensation"
#define HLP_TC_SELECT_20                             "Select if temperature compensation is needed|de|Temperaturkompensation einstellen"
#define LBL_TC_SELECT_20_VAL_0                       "Off|de|Aus"
#define HLP_TC_SELECT_20_VAL_0                       "Select temperature compensation"
#define LBL_TC_SELECT_20_VAL_1                       "Lin"
#define HLP_TC_SELECT_20_VAL_1                       "Select temperature compensation"
#define LBL_TC_SELECT_20_VAL_2                       "NLF"
#define HLP_TC_SELECT_20_VAL_2                       "Select temperature compensation"
#define LBL_TC_SELECT_20_VAL_3                       "NACL"
#define HLP_TC_SELECT_20_VAL_3                       "Select temperature compensation"
#define LBL_TC_SELECT_20_VAL_4                       "HCL"
#define HLP_TC_SELECT_20_VAL_4                       "Select temperature compensation"
#define LBL_TC_SELECT_20_VAL_5                       "NH3"
#define HLP_TC_SELECT_20_VAL_5                       "Select temperature compensation"
#define LBL_TC_SELECT_20_VAL_6                       "NAOH"
#define HLP_TC_SELECT_20_VAL_6                       "Select temperature compensation"
/*
//----------------------------------------------------------------------------
// Variable TC_LIQUID: Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_TC_LIQUID_20                             "Tc Liquid|de|Lin. Temperaturkompensation"
#define HLP_TC_LIQUID_20                             "Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable REF_TEMP: Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_REF_TEMP_20                              "Reference Temperature|de|Referenztemperatur"
#define HLP_REF_TEMP_20                              "Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable TDS_FACTOR: Enter TDS Factor if MEAS MODE is set to TDS|de|TDS Faktor beim Messmodus TDS
//----------------------------------------------------------------------------
*/
#define LBL_TDS_FACTOR_20                            "TDS Factor|de|TDS Faktor"
#define HLP_TDS_FACTOR_20                            "Enter TDS Factor if MEAS MODE is set to TDS|de|TDS Faktor beim Messmodus TDS"
/*
//----------------------------------------------------------------------------
// Variable USP_FACTOR: Enter USP Factor if MEAS MODE is set to USP|de|USP Faktor beim Messmodus USP
//----------------------------------------------------------------------------
*/
#define LBL_USP_FACTOR_20                            "USP Factor|de|USP Faktor"
#define HLP_USP_FACTOR_20                            "Enter USP Factor if MEAS MODE is set to USP|de|USP Faktor beim Messmodus USP"
/*
//----------------------------------------------------------------------------
// Variable TC: Torodial conductivity parameters
//----------------------------------------------------------------------------
*/
#define LBL_TC_21                                    "Toroidal Conductivity"
#define HLP_TC_21                                    "Torodial conductivity parameters"
/*
//----------------------------------------------------------------------------
// Variable SENSORTYPE: Select the sensor type for conductivity.|de|Whlen Sie den Sensortyp fr Leitfhigkeit
//----------------------------------------------------------------------------
*/
#define LBL_SENSORTYPE_21                            "Sensortype|de|Sensortyp"
#define HLP_SENSORTYPE_21                            "Select the sensor type for conductivity.|de|Whlen Sie den Sensortyp fr Leitfhigkeit"
#define LBL_SENSORTYPE_21_VAL_0                      "SE 655"
#define HLP_SENSORTYPE_21_VAL_0                      "Select sensor"
#define LBL_SENSORTYPE_21_VAL_1                      "SE 656"
#define HLP_SENSORTYPE_21_VAL_1                      "Select sensor"
#define LBL_SENSORTYPE_21_VAL_2                      "SE 660"
#define HLP_SENSORTYPE_21_VAL_2                      "Select sensor"
#define LBL_SENSORTYPE_21_VAL_3                      "SE 670"
#define HLP_SENSORTYPE_21_VAL_3                      "Select sensor"
#define LBL_SENSORTYPE_21_VAL_4                      "SE 680"
#define HLP_SENSORTYPE_21_VAL_4                      "Select sensor"
#define LBL_SENSORTYPE_21_VAL_14                     "Memosens"
#define HLP_SENSORTYPE_21_VAL_14                     "Select Sensor"
#define LBL_SENSORTYPE_21_VAL_17                     "SE 681"
#define HLP_SENSORTYPE_21_VAL_17                     "Select sensor"
#define LBL_SENSORTYPE_21_VAL_5                      "Other"
#define HLP_SENSORTYPE_21_VAL_5                      "Select sensor"
/*
//----------------------------------------------------------------------------
// Variable MEAS_MODE: Select the display unit.|de|Anzeigeeinheit auswhlen
//----------------------------------------------------------------------------
*/
#define LBL_MEAS_MODE_21                             "Meas Mode|de|Messmodus"
#define HLP_MEAS_MODE_21                             "Select the display unit.|de|Anzeigeeinheit auswhlen"
#define LBL_MEAS_MODE_21_VAL_0                       "Cond"
#define HLP_MEAS_MODE_21_VAL_0                       "Meas Conductivity"
#define LBL_MEAS_MODE_21_VAL_1                       "Conc %"
#define HLP_MEAS_MODE_21_VAL_1                       "Meas Concentration"
#define LBL_MEAS_MODE_21_VAL_2                       "SAL /oo"
#define HLP_MEAS_MODE_21_VAL_2                       "Meas Salinity"
#define LBL_MEAS_MODE_21_VAL_4                       "Tds"
#define HLP_MEAS_MODE_21_VAL_4                       "Meas TDS"
/*
//----------------------------------------------------------------------------
// Variable DISPLAY_UNIT: Select Displayformat on transmitter|de|Auswahl Anzeigeformat
//----------------------------------------------------------------------------
*/
#define LBL_DISPLAY_UNIT_21                          "Display Unit|de|Anzeigeeinheit"
#define HLP_DISPLAY_UNIT_21                          "Select Displayformat on transmitter|de|Auswahl Anzeigeformat"
#define LBL_DISPLAY_UNIT_21_VAL_21                   "o.ooo mS/cm"
#define HLP_DISPLAY_UNIT_21_VAL_21                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_21_VAL_20                   "oo.oo mS/cm"
#define HLP_DISPLAY_UNIT_21_VAL_20                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_21_VAL_19                   "ooo.o mS/cm"
#define HLP_DISPLAY_UNIT_21_VAL_19                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_21_VAL_18                   "oooo mS/cm"
#define HLP_DISPLAY_UNIT_21_VAL_18                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_21_VAL_17                   "o.ooo S/m"
#define HLP_DISPLAY_UNIT_21_VAL_17                   "Select Displayformat on transmitter"
#define LBL_DISPLAY_UNIT_21_VAL_16                   "oo.oo S/m"
#define HLP_DISPLAY_UNIT_21_VAL_16                   "Select Displayformat on transmitter"
/*
//----------------------------------------------------------------------------
// Variable SOLUTION: Select solution of concentration|de|Auswahl der Konzentrationslsung
//----------------------------------------------------------------------------
*/
#define LBL_SOLUTION_21                              "Solution|de|Lsung (Konz.)"
#define HLP_SOLUTION_21                              "Select solution of concentration|de|Auswahl der Konzentrationslsung"
#define LBL_SOLUTION_21_VAL_0                        "-01- (NaCl)"
#define HLP_SOLUTION_21_VAL_0                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_1                        "-02- (HCl)"
#define HLP_SOLUTION_21_VAL_1                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_2                        "-03- (NaOH)"
#define HLP_SOLUTION_21_VAL_2                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_3                        "-04- (H2SO4)"
#define HLP_SOLUTION_21_VAL_3                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_4                        "-05- (HNO3)"
#define HLP_SOLUTION_21_VAL_4                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_5                        "-06- (H2SO4)"
#define HLP_SOLUTION_21_VAL_5                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_6                        "-07- (HCl)"
#define HLP_SOLUTION_21_VAL_6                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_7                        "-08- (HNO3)"
#define HLP_SOLUTION_21_VAL_7                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_8                        "-09- (H2SO4)"
#define HLP_SOLUTION_21_VAL_8                        "Select solution of concentration"
#define LBL_SOLUTION_21_VAL_9                        "-10- (NaOH)"
#define HLP_SOLUTION_21_VAL_9                        "Select solution of concentration"
/*
//----------------------------------------------------------------------------
// Variable RTD_TYPE: Select the temperature sensor|de|Auswahl des Temperatursensors
//----------------------------------------------------------------------------
*/
#define LBL_RTD_TYPE_21                              "RTD Type|de|RTD Typ"
#define HLP_RTD_TYPE_21                              "Select the temperature sensor|de|Auswahl des Temperatursensors"
#define LBL_RTD_TYPE_21_VAL_0                        "100PT"
#define HLP_RTD_TYPE_21_VAL_0                        "Select temperature probe"
#define LBL_RTD_TYPE_21_VAL_1                        "1000PT"
#define HLP_RTD_TYPE_21_VAL_1                        "Select temperature probe"
#define LBL_RTD_TYPE_21_VAL_5                        "30 NTC"
#define HLP_RTD_TYPE_21_VAL_5                        "Select temperature probe"
/*
//----------------------------------------------------------------------------
// Variable TEMP_UNIT: Select the shown temperature unit for the display|de|Temperatureinheit
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_UNIT_21                             "Temperature Unit|de|Temperatureinheit"
#define HLP_TEMP_UNIT_21                             "Select the shown temperature unit for the display|de|Temperatureinheit"
#define LBL_TEMP_UNIT_21_VAL_39                      "C"
#define HLP_TEMP_UNIT_21_VAL_39                      "Temperature unit is C"
#define LBL_TEMP_UNIT_21_VAL_40                      "F"
#define HLP_TEMP_UNIT_21_VAL_40                      "Temperature unit is F"
/*
//----------------------------------------------------------------------------
// Variable TEMPERATURE: Select which temperature is used for calculation while normal measurement|de|Verwendete Temperatur whrend der Messung
//----------------------------------------------------------------------------
*/
#define LBL_TEMPERATURE_21                           "Temperature Meas|de|Messtemperatur"
#define HLP_TEMPERATURE_21                           "Select which temperature is used for calculation while normal measurement|de|Verwendete Temperatur whrend der Messung"
#define LBL_TEMPERATURE_21_VAL_0                     "Auto"
#define HLP_TEMPERATURE_21_VAL_0                     "Use the temperature from the device"
#define LBL_TEMPERATURE_21_VAL_1                     "Man"
#define HLP_TEMPERATURE_21_VAL_1                     "Use manual temperature"
#define LBL_TEMPERATURE_21_VAL_2                     "Bus"
#define HLP_TEMPERATURE_21_VAL_2                     "Use the temperature from fieldbus"
/*
//----------------------------------------------------------------------------
// Variable TEMPERATURE_MAN: Enter the temperature value if TEMP_MEAS is selected MAN|de|Manueller Wert
//----------------------------------------------------------------------------
*/
#define LBL_TEMPERATURE_MAN_21                       "Temperature Meas Manual Value|de|Manuelle Messtemperatur"
#define HLP_TEMPERATURE_MAN_21                       "Enter the temperature value if TEMP_MEAS is selected MAN|de|Manueller Wert"
/*
//----------------------------------------------------------------------------
// Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_CIP_COUNT_21                             "CIP Count|de|CIP Zhler"
#define HLP_CIP_COUNT_21                             "To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_CIP_COUNT_21_VAL_0                       "Off|de|Aus"
#define HLP_CIP_COUNT_21_VAL_0                       "Selecto to switch off"
#define LBL_CIP_COUNT_21_VAL_1                       "On|de|An"
#define HLP_CIP_COUNT_21_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_SIP_COUNT_21                             "SIP Count|de|SIP Zhler"
#define HLP_SIP_COUNT_21                             "To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_SIP_COUNT_21_VAL_0                       "Off|de|Aus"
#define HLP_SIP_COUNT_21_VAL_0                       "Selecto to switch off"
#define LBL_SIP_COUNT_21_VAL_1                       "On|de|An"
#define HLP_SIP_COUNT_21_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable TC_SELECT: Select if temperature compensation is needed|de|Temperaturkompensation einstellen
//----------------------------------------------------------------------------
*/
#define LBL_TC_SELECT_21                             "Tc Select|de|Temperaturkompensation"
#define HLP_TC_SELECT_21                             "Select if temperature compensation is needed|de|Temperaturkompensation einstellen"
#define LBL_TC_SELECT_21_VAL_0                       "Off|de|Aus"
#define HLP_TC_SELECT_21_VAL_0                       "Select temperature compensation"
#define LBL_TC_SELECT_21_VAL_1                       "Lin"
#define HLP_TC_SELECT_21_VAL_1                       "Select temperature compensation"
#define LBL_TC_SELECT_21_VAL_2                       "NLF"
#define HLP_TC_SELECT_21_VAL_2                       "Select temperature compensation"
#define LBL_TC_SELECT_21_VAL_3                       "NACL"
#define HLP_TC_SELECT_21_VAL_3                       "Select temperature compensation"
#define LBL_TC_SELECT_21_VAL_4                       "HCL"
#define HLP_TC_SELECT_21_VAL_4                       "Select temperature compensation"
#define LBL_TC_SELECT_21_VAL_5                       "NH3"
#define HLP_TC_SELECT_21_VAL_5                       "Select temperature compensation"
#define LBL_TC_SELECT_21_VAL_6                       "NAOH"
#define HLP_TC_SELECT_21_VAL_6                       "Select temperature compensation"
/*
//----------------------------------------------------------------------------
// Variable TC_LIQUID: Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_TC_LIQUID_21                             "Tc Liquid|de|Lin. Temperaturkompensation"
#define HLP_TC_LIQUID_21                             "Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable REF_TEMP: Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_REF_TEMP_21                              "Reference Temperature|de|Referenztemperatur"
#define HLP_REF_TEMP_21                              "Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable TDS_FACTOR: Enter TDS Factor if MEAS MODE is set to TDS|de|TDS Faktor beim Messmodus TDS
//----------------------------------------------------------------------------
*/
#define LBL_TDS_FACTOR_21                            "TDS Factor|de|TDS Faktor"
#define HLP_TDS_FACTOR_21                            "Enter TDS Factor if MEAS MODE is set to TDS|de|TDS Faktor beim Messmodus TDS"
/*
//----------------------------------------------------------------------------
// Variable DISOLVED_OXYGEN: dissolved oxygen parameters
//----------------------------------------------------------------------------
*/
#define LBL_DISOLVED_OXYGEN_22                       "Disolved Oxygen"
#define HLP_DISOLVED_OXYGEN_22                       "dissolved oxygen parameters"
/*
//----------------------------------------------------------------------------
// Variable SENSORTYPE: Select the sensor type for DO.|de|Whlen Sie den Sensortyp fr Sauerstoff
//----------------------------------------------------------------------------
*/
#define LBL_SENSORTYPE_22                            "Sensortype|de|Sensortyp"
#define HLP_SENSORTYPE_22                            "Select the sensor type for DO.|de|Whlen Sie den Sensortyp fr Sauerstoff"
#define LBL_SENSORTYPE_22_VAL_8                      "Standard"
#define HLP_SENSORTYPE_22_VAL_8                      "Select sensor for DO"
#define LBL_SENSORTYPE_22_VAL_9                      "Traces"
#define HLP_SENSORTYPE_22_VAL_9                      "Select sensor for DO"
#define LBL_SENSORTYPE_22_VAL_10                     "Subtraces"
#define HLP_SENSORTYPE_22_VAL_10                     "Select sensor for DO"
#define LBL_SENSORTYPE_22_VAL_14                     "Memosens"
#define HLP_SENSORTYPE_22_VAL_14                     "Select sensor for DO"
#define LBL_SENSORTYPE_22_VAL_13                     "ISM"
#define HLP_SENSORTYPE_22_VAL_13                     "Select sensor for DO"
#define LBL_SENSORTYPE_22_VAL_16                     "SE740 LDO"
#define HLP_SENSORTYPE_22_VAL_16                     "Select sensor for SE740 LDO"
/*
//----------------------------------------------------------------------------
// Variable MEAS_MODE: Select the display unit.|de|Anzeigeeinheit auswhlen
//----------------------------------------------------------------------------
*/
#define LBL_MEAS_MODE_22                             "Meas Mode|de|Messmodus"
#define HLP_MEAS_MODE_22                             "Select the display unit.|de|Anzeigeeinheit auswhlen"
#define LBL_MEAS_MODE_22_VAL_12                      "dO  %"
#define HLP_MEAS_MODE_22_VAL_12                      "Select meas mode"
#define LBL_MEAS_MODE_22_VAL_2                       "dO  mg/l"
#define HLP_MEAS_MODE_22_VAL_2                       "Select meas mode"
#define LBL_MEAS_MODE_22_VAL_5                       "dO  ppm"
#define HLP_MEAS_MODE_22_VAL_5                       "Select meas mode"
#define LBL_MEAS_MODE_22_VAL_8                       "Gas %"
#define HLP_MEAS_MODE_22_VAL_8                       "Select meas mode"
/*
//----------------------------------------------------------------------------
// Variable U_POL_MEAS: Polarisation voltage while measurement.|de|Polarisationsspannung beim Messen
//----------------------------------------------------------------------------
*/
#define LBL_U_POL_MEAS_22                            "Polarization Voltage Meas|de|Polarisationsspannung Messen"
#define HLP_U_POL_MEAS_22                            "Polarisation voltage while measurement.|de|Polarisationsspannung beim Messen"
/*
//----------------------------------------------------------------------------
// Variable U_POL_CAL: Polarisation voltage while calibration.|de|Polarisationsspannung bei der Kalibrierung
//----------------------------------------------------------------------------
*/
#define LBL_U_POL_CAL_22                             "Polarization Voltage Cal|de|Polarisationsspannung Kalibrierung"
#define HLP_U_POL_CAL_22                             "Polarisation voltage while calibration.|de|Polarisationsspannung bei der Kalibrierung"
/*
//----------------------------------------------------------------------------
// Variable MEMBRAN_COMP: Membrane compensation|de|Membrankompensation
//----------------------------------------------------------------------------
*/
#define LBL_MEMBRAN_COMP_22                          "Membran Compensation|de|Membrankompensation"
#define HLP_MEMBRAN_COMP_22                          "Membrane compensation|de|Membrankompensation"
/*
//----------------------------------------------------------------------------
// Variable RTD_TYPE: Select the temperature sensor|de|Auswahl des Temperatursensors
//----------------------------------------------------------------------------
*/
#define LBL_RTD_TYPE_22                              "RTD Type|de|RTD Typ"
#define HLP_RTD_TYPE_22                              "Select the temperature sensor|de|Auswahl des Temperatursensors"
#define LBL_RTD_TYPE_22_VAL_4                        "22 NTC"
#define HLP_RTD_TYPE_22_VAL_4                        "Only for analog sensors."
#define LBL_RTD_TYPE_22_VAL_5                        "30 NTC"
#define HLP_RTD_TYPE_22_VAL_5                        "Only for analog sensors."
/*
//----------------------------------------------------------------------------
// Variable TEMP_UNIT: Select the shown temperature unit for the display|de|Temperatureinheit
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_UNIT_22                             "Temperature Unit|de|Temperatureinheit"
#define HLP_TEMP_UNIT_22                             "Select the shown temperature unit for the display|de|Temperatureinheit"
#define LBL_TEMP_UNIT_22_VAL_39                      "C"
#define HLP_TEMP_UNIT_22_VAL_39                      "Temperature unit is C"
#define LBL_TEMP_UNIT_22_VAL_40                      "F"
#define HLP_TEMP_UNIT_22_VAL_40                      "Temperature unit is F"
/*
//----------------------------------------------------------------------------
// Variable CALMODE: Select the calibration mode.|de|Kalibriermodus
//----------------------------------------------------------------------------
*/
#define LBL_CALMODE_22                               "Calibration Mode|de|Kalibriermodus"
#define HLP_CALMODE_22                               "Select the calibration mode.|de|Kalibriermodus"
#define LBL_CALMODE_22_VAL_5                         "Cal air"
#define HLP_CALMODE_22_VAL_5                         "Select if you calibratie in air"
#define LBL_CALMODE_22_VAL_4                         "Cal water"
#define HLP_CALMODE_22_VAL_4                         "Select if you calibrate in water"
/*
//----------------------------------------------------------------------------
// Variable CAL_TIMER: Calibration timer is used to remind you for a calibration. Not for ISM sensors.|de|Kalibrierzyklus einstellen
//----------------------------------------------------------------------------
*/
#define LBL_CAL_TIMER_22                             "Calibration Timer|de|Kalibriertimer"
#define HLP_CAL_TIMER_22                             "Calibration timer is used to remind you for a calibration. Not for ISM sensors.|de|Kalibrierzyklus einstellen"
#define LBL_CAL_TIMER_22_VAL_0                       "Off|de|Aus"
#define HLP_CAL_TIMER_22_VAL_0                       "Selecto to switch off"
#define LBL_CAL_TIMER_22_VAL_1                       "On|de|An"
#define HLP_CAL_TIMER_22_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable CAL_CYCLE: Enter a value if CAL_TIMER is set to On.|de|Wert des Kalriberirtimers
//----------------------------------------------------------------------------
*/
#define LBL_CAL_CYCLE_22                             "Calibration Cycle|de|Kalibrierzyklen"
#define HLP_CAL_CYCLE_22                             "Enter a value if CAL_TIMER is set to On.|de|Wert des Kalriberirtimers"
/*
//----------------------------------------------------------------------------
// Variable ACT: Only for ISM sensors.|de|Nur bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_ACT_22                                   "ACT|de|ACT"
#define HLP_ACT_22                                   "Only for ISM sensors.|de|Nur bei ISM Sensoren."
#define LBL_ACT_22_VAL_0                             "Off|de|Aus"
#define HLP_ACT_22_VAL_0                             "Select to switch off."
#define LBL_ACT_22_VAL_1                             "Auto"
#define HLP_ACT_22_VAL_1                             "Select to use automatic"
#define LBL_ACT_22_VAL_2                             "Man"
#define HLP_ACT_22_VAL_2                             "Select to use manual"
/*
//----------------------------------------------------------------------------
// Variable ACT_CYCLE: Enter a value if ACT is set to MAN.|de|Nur bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_ACT_CYCLE_22                             "ACT Cycle|de|ACT Zyklen"
#define HLP_ACT_CYCLE_22                             "Enter a value if ACT is set to MAN.|de|Nur bei ISM Sensoren."
/*
//----------------------------------------------------------------------------
// Variable TTM: Enable Time To Maintenacne. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_TTM_22                                   "TTM|de|TTM"
#define HLP_TTM_22                                   "Enable Time To Maintenacne. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren."
#define LBL_TTM_22_VAL_0                             "Off|de|Aus"
#define HLP_TTM_22_VAL_0                             "Select to switch off."
#define LBL_TTM_22_VAL_1                             "Auto"
#define HLP_TTM_22_VAL_1                             "Select to use automatic"
#define LBL_TTM_22_VAL_2                             "Man"
#define HLP_TTM_22_VAL_2                             "Select to use manual"
/*
//----------------------------------------------------------------------------
// Variable TTM_CYCLE: Enter value for reminding maintenance. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_TTM_CYCLE_22                             "TTM Cycle|de|TTM Zyklen"
#define HLP_TTM_CYCLE_22                             "Enter value for reminding maintenance. ISM sensors only.|de|Adaptiver Wartungstimer.NUr bei ISM Sensoren."
/*
//----------------------------------------------------------------------------
// Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_CIP_COUNT_22                             "CIP Count|de|CIP Zhler"
#define HLP_CIP_COUNT_22                             "To enable CIP Count alarm for Memosens and ISM sensors|de|CIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_CIP_COUNT_22_VAL_0                       "Off|de|Aus"
#define HLP_CIP_COUNT_22_VAL_0                       "Selecto to switch off"
#define LBL_CIP_COUNT_22_VAL_1                       "On|de|An"
#define HLP_CIP_COUNT_22_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable CIP_CYCLES: Enter value if CIP_COUNT is enabled.|de|CIP Zyklen einstellen.
//----------------------------------------------------------------------------
*/
#define LBL_CIP_CYCLES_22                            "CIP Cycles|de|CIP Zyklen"
#define HLP_CIP_CYCLES_22                            "Enter value if CIP_COUNT is enabled.|de|CIP Zyklen einstellen."
/*
//----------------------------------------------------------------------------
// Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_SIP_COUNT_22                             "SIP Count|de|SIP Zhler"
#define HLP_SIP_COUNT_22                             "To enable SIP Count alarm for Memosens and ISM sensors|de|SIP Count Alarm for Memosens and ISM Sensoren"
#define LBL_SIP_COUNT_22_VAL_0                       "Off|de|Aus"
#define HLP_SIP_COUNT_22_VAL_0                       "Selecto to switch off"
#define LBL_SIP_COUNT_22_VAL_1                       "On|de|An"
#define HLP_SIP_COUNT_22_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable SIP_CYCLES: Enter value if SIP_COUNT is enabled.|de|SIP Zyklen einstellen.
//----------------------------------------------------------------------------
*/
#define LBL_SIP_CYCLES_22                            "SIP Cycles|de|SIP Zyklen"
#define HLP_SIP_CYCLES_22                            "Enter value if SIP_COUNT is enabled.|de|SIP Zyklen einstellen."
/*
//----------------------------------------------------------------------------
// Variable AUTOCLAVE: To enable autoclave count alarm for Memosens and ISM sensors|de|Autoklavierzhler Alarm for Memosens and ISM Sensoren
//----------------------------------------------------------------------------
*/
#define LBL_AUTOCLAVE_22                             "Autoclave|de|Autoklavierzhler"
#define HLP_AUTOCLAVE_22                             "To enable autoclave count alarm for Memosens and ISM sensors|de|Autoklavierzhler Alarm for Memosens and ISM Sensoren"
#define LBL_AUTOCLAVE_22_VAL_0                       "Off|de|Aus"
#define HLP_AUTOCLAVE_22_VAL_0                       "Selecto to switch off"
#define LBL_AUTOCLAVE_22_VAL_1                       "On|de|An"
#define HLP_AUTOCLAVE_22_VAL_1                       "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable AC_CYCLES: Enter value if AUTOCLAVE is enabled.|de|Autoklavierzyklen einstellen.
//----------------------------------------------------------------------------
*/
#define LBL_AC_CYCLES_22                             "AC Cycles|de|Autoklavierzyklen"
#define HLP_AC_CYCLES_22                             "Enter value if AUTOCLAVE is enabled.|de|Autoklavierzyklen einstellen."
/*
//----------------------------------------------------------------------------
// Variable SALINITY: Enter salinity value.|de|Salinittswert
//----------------------------------------------------------------------------
*/
#define LBL_SALINITY_22                              "Salinity|de|Salinitt"
#define HLP_SALINITY_22                              "Enter salinity value.|de|Salinittswert"
/*
//----------------------------------------------------------------------------
// Variable PRESSURE_UNIT: Select the unit of pressure.|de|Einheit des Druckes
//----------------------------------------------------------------------------
*/
#define LBL_PRESSURE_UNIT_22                         "Pressure Unit|de|Druckeinheit"
#define HLP_PRESSURE_UNIT_22                         "Select the unit of pressure.|de|Einheit des Druckes"
#define LBL_PRESSURE_UNIT_22_VAL_58                  "bar"
#define HLP_PRESSURE_UNIT_22_VAL_58                  "Select pressure unit"
#define LBL_PRESSURE_UNIT_22_VAL_61                  "kPa"
#define HLP_PRESSURE_UNIT_22_VAL_61                  "Select pressure unit"
#define LBL_PRESSURE_UNIT_22_VAL_63                  "psi"
#define HLP_PRESSURE_UNIT_22_VAL_63                  "Select pressure unit"
/*
//----------------------------------------------------------------------------
// Variable PRESSURE: Select pressure by manual input or analog output (BUS)|de|Manuelle Druckkompensation oder ber den Feldbus (AO-Block)
//----------------------------------------------------------------------------
*/
#define LBL_PRESSURE_22                              "Pressure|de|Druck"
#define HLP_PRESSURE_22                              "Select pressure by manual input or analog output (BUS)|de|Manuelle Druckkompensation oder ber den Feldbus (AO-Block)"
#define LBL_PRESSURE_22_VAL_1                        "Man"
#define HLP_PRESSURE_22_VAL_1                        "Selects manual pressure."
#define LBL_PRESSURE_22_VAL_2                        "Bus (Analog Output)"
#define HLP_PRESSURE_22_VAL_2                        "Selects pressure value via bus (Analog Output)"
/*
//----------------------------------------------------------------------------
// Variable PRESSURE_MAN: Enter pressure in unit of PRESSURE_UNIT|de|Manueller Druck in entsprechender Einheit
//----------------------------------------------------------------------------
*/
#define LBL_PRESSURE_MAN_22                          "Pressure Manual Value|de|Manueller Druck"
#define HLP_PRESSURE_MAN_22                          "Enter pressure in unit of PRESSURE_UNIT|de|Manueller Druck in entsprechender Einheit"
/*
//----------------------------------------------------------------------------
// Variable CC: CC parameters
//----------------------------------------------------------------------------
*/
#define LBL_CC_23                                    "Cc"
#define HLP_CC_23                                    "Leitfhigkeit-Leitfhigkeit parameters"
/*
//----------------------------------------------------------------------------
// Variable TC_SELECT_A: Select if temperature compensation is needed|de|Temperaturkompensation einstellen
//----------------------------------------------------------------------------
*/
#define LBL_TC_SELECT_A_23                           "Tc Select A|de|Tc Select A"
#define HLP_TC_SELECT_A_23                           "Select if temperature compensation is needed|de|Temperaturkompensation einstellen"
#define LBL_TC_SELECT_A_23_VAL_0                     "Off|de|Aus"
#define HLP_TC_SELECT_A_23_VAL_0                     "Select temperature compensation"
#define LBL_TC_SELECT_A_23_VAL_1                     "Lin"
#define HLP_TC_SELECT_A_23_VAL_1                     "Select temperature compensation"
#define LBL_TC_SELECT_A_23_VAL_2                     "NLF"
#define HLP_TC_SELECT_A_23_VAL_2                     "Select temperature compensation"
#define LBL_TC_SELECT_A_23_VAL_3                     "NACL"
#define HLP_TC_SELECT_A_23_VAL_3                     "Select temperature compensation"
#define LBL_TC_SELECT_A_23_VAL_4                     "HCL"
#define HLP_TC_SELECT_A_23_VAL_4                     "Select temperature compensation"
#define LBL_TC_SELECT_A_23_VAL_5                     "NH3"
#define HLP_TC_SELECT_A_23_VAL_5                     "Select temperature compensation"
#define LBL_TC_SELECT_A_23_VAL_6                     "NAOH"
#define HLP_TC_SELECT_A_23_VAL_6                     "Select temperature compensation"
/*
//----------------------------------------------------------------------------
// Variable TC_LIQUID_A: Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_TC_LIQUID_A_23                           "Tc Liquid A|de|Tc Liquid A"
#define HLP_TC_LIQUID_A_23                           "Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable REF_TEMP_A: Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_REF_TEMP_A_23                            "Reference Temperature A|de|Referenztemperatur A"
#define HLP_REF_TEMP_A_23                            "Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable TC_SELECT_B: Select if temperature compensation is needed|de|Temperaturkompensation einstellen
//----------------------------------------------------------------------------
*/
#define LBL_TC_SELECT_B_23                           "Tc Select B|de|Tc Select B"
#define HLP_TC_SELECT_B_23                           "Select if temperature compensation is needed|de|Temperaturkompensation einstellen"
#define LBL_TC_SELECT_B_23_VAL_0                     "Off|de|Aus"
#define HLP_TC_SELECT_B_23_VAL_0                     "Select temperature compensation"
#define LBL_TC_SELECT_B_23_VAL_1                     "Lin"
#define HLP_TC_SELECT_B_23_VAL_1                     "Select temperature compensation"
#define LBL_TC_SELECT_B_23_VAL_2                     "NLF"
#define HLP_TC_SELECT_B_23_VAL_2                     "Select temperature compensation"
#define LBL_TC_SELECT_B_23_VAL_3                     "NACL"
#define HLP_TC_SELECT_B_23_VAL_3                     "Select temperature compensation"
#define LBL_TC_SELECT_B_23_VAL_4                     "HCL"
#define HLP_TC_SELECT_B_23_VAL_4                     "Select temperature compensation"
#define LBL_TC_SELECT_B_23_VAL_5                     "NH3"
#define HLP_TC_SELECT_B_23_VAL_5                     "Select temperature compensation"
#define LBL_TC_SELECT_B_23_VAL_6                     "NAOH"
#define HLP_TC_SELECT_B_23_VAL_6                     "Select temperature compensation"
/*
//----------------------------------------------------------------------------
// Variable TC_LIQUID_B: Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_TC_LIQUID_B_23                           "Tc Liquid B|de|Tc Liquid B"
#define HLP_TC_LIQUID_B_23                           "Enter value if temperature compensation is set to LIN|de|Wert fr die lineare Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable REF_TEMP_B: Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation.
//----------------------------------------------------------------------------
*/
#define LBL_REF_TEMP_B_23                            "Reference Temperature B|de|Referenztemperatur B"
#define HLP_REF_TEMP_B_23                            "Enter reference temperature value if temperature compensation is set to LIN|de|Referenztemperatur bei linearer Temperaturkompensation."
/*
//----------------------------------------------------------------------------
// Variable MEAS_RANGE: Select the meas range for conductivity.|de|Messbereich fr Leitfhigkeit
//----------------------------------------------------------------------------
*/
#define LBL_MEAS_RANGE_23                            "Meas Range|de|Messbereich"
#define HLP_MEAS_RANGE_23                            "Select the meas range for conductivity.|de|Messbereich fr Leitfhigkeit"
#define LBL_MEAS_RANGE_23_VAL_25                     "o.ooo S/c"
#define HLP_MEAS_RANGE_23_VAL_25                     "Select meas range"
#define LBL_MEAS_RANGE_23_VAL_24                     "oo.oo S/c"
#define HLP_MEAS_RANGE_23_VAL_24                     "Select meas range"
#define LBL_MEAS_RANGE_23_VAL_23                     "ooo.o S/c"
#define HLP_MEAS_RANGE_23_VAL_23                     "Select meas range"
#define LBL_MEAS_RANGE_23_VAL_22                     "oooo S/c"
#define HLP_MEAS_RANGE_23_VAL_22                     "Select meas range"
#define LBL_MEAS_RANGE_23_VAL_55                     "oo.oo MOhm"
#define HLP_MEAS_RANGE_23_VAL_55                     "Select meas range"
/*
//----------------------------------------------------------------------------
// Variable TEMP_UNIT: Select the shown temperature unit for the display|de|Temperatureinheit
//----------------------------------------------------------------------------
*/
#define LBL_TEMP_UNIT_23                             "Temperature Unit|de|Temperatureinheit"
#define HLP_TEMP_UNIT_23                             "Select the shown temperature unit for the display|de|Temperatureinheit"
#define LBL_TEMP_UNIT_23_VAL_39                      "C"
#define HLP_TEMP_UNIT_23_VAL_39                      "Temperature unit is C"
#define LBL_TEMP_UNIT_23_VAL_40                      "F"
#define HLP_TEMP_UNIT_23_VAL_40                      "Temperature unit is F"
/*
//----------------------------------------------------------------------------
// Variable CALCULATION: Enable or disable calculation.|de|Verrechnung ein oder ausschalten
//----------------------------------------------------------------------------
*/
#define LBL_CALCULATION_23                           "Calculation|de|Verrechnung"
#define HLP_CALCULATION_23                           "Enable or disable calculation.|de|Verrechnung ein oder ausschalten"
#define LBL_CALCULATION_23_VAL_0                     "Off|de|Aus"
#define HLP_CALCULATION_23_VAL_0                     "Selecto to switch off"
#define LBL_CALCULATION_23_VAL_1                     "On|de|An"
#define HLP_CALCULATION_23_VAL_1                     "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable CALCULATION_TYPE: Select calculation type|de|Verrechnungstyp
//----------------------------------------------------------------------------
*/
#define LBL_CALCULATION_TYPE_23                      "Calculation Type|de|Verrechnungstyp"
#define HLP_CALCULATION_TYPE_23                      "Select calculation type|de|Verrechnungstyp"
#define LBL_CALCULATION_TYPE_23_VAL_0                "-C1-  Difference"
#define HLP_CALCULATION_TYPE_23_VAL_0                "Select calculation type"
#define LBL_CALCULATION_TYPE_23_VAL_1                "-C2-  Ratio"
#define HLP_CALCULATION_TYPE_23_VAL_1                "Select calculation type"
#define LBL_CALCULATION_TYPE_23_VAL_2                "-C3-  Passage"
#define HLP_CALCULATION_TYPE_23_VAL_2                "Select calculation type"
#define LBL_CALCULATION_TYPE_23_VAL_3                "-C4-  Rejection"
#define HLP_CALCULATION_TYPE_23_VAL_3                "Select calculation type"
#define LBL_CALCULATION_TYPE_23_VAL_4                "-C5-  Deviation"
#define HLP_CALCULATION_TYPE_23_VAL_4                "Select calculation type"
#define LBL_CALCULATION_TYPE_23_VAL_5                "-C6-  pH-VGB"
#define HLP_CALCULATION_TYPE_23_VAL_5                "Select calculation type"
#define LBL_CALCULATION_TYPE_23_VAL_6                "-C7- pH-variabel"
#define HLP_CALCULATION_TYPE_23_VAL_6                "Select calculation type"
#define LBL_CALCULATION_TYPE_23_VAL_7                "-C8- User spec."
#define HLP_CALCULATION_TYPE_23_VAL_7                "Select calculation type"
/*
//----------------------------------------------------------------------------
// Variable FACTOR_1: Enter 1st factor if CALCULATION_TYPE is set to -C7-|de|1. Faktor bei Verrechnungstyp -C7-
//----------------------------------------------------------------------------
*/
#define LBL_FACTOR_1_23                              "Factor 1|de|Faktor 1"
#define HLP_FACTOR_1_23                              "Enter 1st factor if CALCULATION_TYPE is set to -C7-|de|1. Faktor bei Verrechnungstyp -C7-"
/*
//----------------------------------------------------------------------------
// Variable FACTOR_2: Enter 2nd factor if CALCULATION_TYPE is set to -C7-|de|2. Faktor bei Verrechnungstyp -C7-
//----------------------------------------------------------------------------
*/
#define LBL_FACTOR_2_23                              "Factor 2|de|Faktor 2"
#define HLP_FACTOR_2_23                              "Enter 2nd factor if CALCULATION_TYPE is set to -C7-|de|2. Faktor bei Verrechnungstyp -C7-"
/*
//----------------------------------------------------------------------------
// Variable PARAMETER_W: Enter 1st parameter if CALCULATION_TYPE is set to -C8-|de|1. Faktor bei Verrechnungstyp -C8-
//----------------------------------------------------------------------------
*/
#define LBL_PARAMETER_W_23                           "Parameter W [e-3]|de|Parameter W [e-3]"
#define HLP_PARAMETER_W_23                           "Enter 1st parameter if CALCULATION_TYPE is set to -C8-|de|1. Faktor bei Verrechnungstyp -C8-"
/*
//----------------------------------------------------------------------------
// Variable PARAMETER_A: Enter 2nd parameter if CALCULATION_TYPE is set to -C8-|de|2. Faktor bei Verrechnungstyp -C8-
//----------------------------------------------------------------------------
*/
#define LBL_PARAMETER_A_23                           "Parameter A [e-3]|de|Parameter A [e-3]"
#define HLP_PARAMETER_A_23                           "Enter 2nd parameter if CALCULATION_TYPE is set to -C8-|de|2. Faktor bei Verrechnungstyp -C8-"
/*
//----------------------------------------------------------------------------
// Variable PARAMETER_B: Enter 3rd parameter if CALCULATION_TYPE is set to -C8-|de|3. Faktor bei Verrechnungstyp -C8-
//----------------------------------------------------------------------------
*/
#define LBL_PARAMETER_B_23                           "Parameter B [e-4]|de|Parameter B [e-4]"
#define HLP_PARAMETER_B_23                           "Enter 3rd parameter if CALCULATION_TYPE is set to -C8-|de|3. Faktor bei Verrechnungstyp -C8-"
/*
//----------------------------------------------------------------------------
// Variable FLOW_ADJUST: Enter Flow adjustment in impulses/litre|de|Impulse pro Liter
//----------------------------------------------------------------------------
*/
#define LBL_FLOW_ADJUST_24                           "Flow Adjust|de|Durchflussmessung"
#define HLP_FLOW_ADJUST_24                           "Enter Flow adjustment in impulses/litre|de|Impulse pro Liter"
/*
//----------------------------------------------------------------------------
// Variable ALARM_DELAY: Enter alarm delay in seconds|de|Alarmverzgerung in Sekunden
//----------------------------------------------------------------------------
*/
#define LBL_ALARM_DELAY_25                           "Alarm Delay|de|Alarmverzgerung"
#define HLP_ALARM_DELAY_25                           "Enter alarm delay in seconds|de|Alarmverzgerung in Sekunden"
/*
//----------------------------------------------------------------------------
// Variable SENSOCHECK: Sensocheck appraises the sensor.|de|Sensocheck bewertet den Zustand des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_SENSOCHECK_26                            "Sensocheck|de|Sensocheck"
#define HLP_SENSOCHECK_26                            "Sensocheck appraises the sensor.|de|Sensocheck bewertet den Zustand des Sensors"
#define LBL_SENSOCHECK_26_VAL_0                      "Off|de|Aus"
#define HLP_SENSOCHECK_26_VAL_0                      "Selecto to switch off"
#define LBL_SENSOCHECK_26_VAL_1                      "On|de|An"
#define HLP_SENSOCHECK_26_VAL_1                      "Selecto to switch on"
/*
//----------------------------------------------------------------------------
// Variable CLOCK: Clock parameters
//----------------------------------------------------------------------------
*/
#define LBL_CLOCK_27                                 "Clock"
#define HLP_CLOCK_27                                 "Clock parameters"
/*
//----------------------------------------------------------------------------
// Variable FORMAT: Format|de|Uhrzeitformat
//----------------------------------------------------------------------------
*/
#define LBL_FORMAT_27                                "Format|de|Uhrzeitformat"
#define HLP_FORMAT_27                                "Format|de|Uhrzeitformat"
#define LBL_FORMAT_27_VAL_0                          "24h"
#define HLP_FORMAT_27_VAL_0                          "Select clock format"
#define LBL_FORMAT_27_VAL_1                          "12h"
#define HLP_FORMAT_27_VAL_1                          "Select clock format"
/*
//----------------------------------------------------------------------------
// Variable MINUTE: Minute|de|Minute
//----------------------------------------------------------------------------
*/
#define LBL_MINUTE_27                                "Minute|de|Minute"
#define HLP_MINUTE_27                                "Minute|de|Minute"
/*
//----------------------------------------------------------------------------
// Variable HOUR: Hour|de|Stunde
//----------------------------------------------------------------------------
*/
#define LBL_HOUR_27                                  "Hour|de|Stunde"
#define HLP_HOUR_27                                  "Hour|de|Stunde"
/*
//----------------------------------------------------------------------------
// Variable AMPM: am or pm|de|AM oder PM
//----------------------------------------------------------------------------
*/
#define LBL_AMPM_27                                  "am or pm|de|AM oder PM"
#define HLP_AMPM_27                                  "am or pm|de|AM oder PM"
#define LBL_AMPM_27_VAL_0                            "am"
#define HLP_AMPM_27_VAL_0                            "am"
#define LBL_AMPM_27_VAL_1                            "pm"
#define HLP_AMPM_27_VAL_1                            "pm"
/*
//----------------------------------------------------------------------------
// Variable DAY: Day|de|Tag
//----------------------------------------------------------------------------
*/
#define LBL_DAY_27                                   "Day|de|Tag"
#define HLP_DAY_27                                   "Day|de|Tag"
/*
//----------------------------------------------------------------------------
// Variable MONTH: Month|de|Monat
//----------------------------------------------------------------------------
*/
#define LBL_MONTH_27                                 "Month|de|Monat"
#define HLP_MONTH_27                                 "Month|de|Monat"
/*
//----------------------------------------------------------------------------
// Variable YEAR: Year|de|Jahr
//----------------------------------------------------------------------------
*/
#define LBL_YEAR_27                                  "Year|de|Jahr"
#define HLP_YEAR_27                                  "Year|de|Jahr"
/*
//----------------------------------------------------------------------------
// Variable PH_TC_LIQUID_TABLE: Table if TC_SELECT is set to user tab.Value from 0C to 100C in 5degree steps.
//----------------------------------------------------------------------------
*/
#define LBL_PH_TC_LIQUID_TABLE_28                    "pH Tc Liquid Table"
#define HLP_PH_TC_LIQUID_TABLE_28                    "Table if TC_SELECT is set to user tab.Value from 0C to 100C in 5degree steps."
/*
//----------------------------------------------------------------------------
// Variable DEGREE_0: Enter value for 0C|de|Wert fr 0C 
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_0_28                              "0 C (32 F)"
#define HLP_DEGREE_0_28                              "Enter value for 0C|de|Wert fr 0C "
/*
//----------------------------------------------------------------------------
// Variable DEGREE_5: Enter value for 5C|de|Wert fr 5C 
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_5_28                              "5 C (41 F)"
#define HLP_DEGREE_5_28                              "Enter value for 5C|de|Wert fr 5C "
/*
//----------------------------------------------------------------------------
// Variable DEGREE_10: Enter value for 10C|de|Wert fr 10C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_10_28                             "10 C (50 F)"
#define HLP_DEGREE_10_28                             "Enter value for 10C|de|Wert fr 10C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_15: Enter value for 15C|de|Wert fr 15C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_15_28                             "15 C (59 F)"
#define HLP_DEGREE_15_28                             "Enter value for 15C|de|Wert fr 15C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_20: Enter value for 20C|de|Wert fr 20C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_20_28                             "20 C (68 F)"
#define HLP_DEGREE_20_28                             "Enter value for 20C|de|Wert fr 20C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_25: Enter value for 25C|de|Wert fr 25C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_25_28                             "25 C (77 F)"
#define HLP_DEGREE_25_28                             "Enter value for 25C|de|Wert fr 25C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_30: Enter value for 30C|de|Wert fr 30C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_30_28                             "30 C (86 F)"
#define HLP_DEGREE_30_28                             "Enter value for 30C|de|Wert fr 30C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_35: Enter value for 35C|de|Wert fr 35C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_35_28                             "35 C (95 F)"
#define HLP_DEGREE_35_28                             "Enter value for 35C|de|Wert fr 35C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_40: Enter value for 40C|de|Wert fr 40C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_40_28                             "40 C (104 F)"
#define HLP_DEGREE_40_28                             "Enter value for 40C|de|Wert fr 40C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_45: Enter value for 45C|de|Wert fr 45C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_45_28                             "45 C (113 F)"
#define HLP_DEGREE_45_28                             "Enter value for 45C|de|Wert fr 45C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_50: Enter value for 50C|de|Wert fr 50C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_50_28                             "50 C (122 F)"
#define HLP_DEGREE_50_28                             "Enter value for 50C|de|Wert fr 50C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_55: Enter value for 55C|de|Wert fr 55C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_55_28                             "55 C (131 F)"
#define HLP_DEGREE_55_28                             "Enter value for 55C|de|Wert fr 55C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_60: Enter value for 60C|de|Wert fr 60C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_60_28                             "60 C (140 F)"
#define HLP_DEGREE_60_28                             "Enter value for 60C|de|Wert fr 60C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_65: Enter value for 65C|de|Wert fr 65C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_65_28                             "65 C (149 F)"
#define HLP_DEGREE_65_28                             "Enter value for 65C|de|Wert fr 65C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_70: Enter value for 70C|de|Wert fr 70C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_70_28                             "70 C (158 F)"
#define HLP_DEGREE_70_28                             "Enter value for 70C|de|Wert fr 70C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_75: Enter value for 75C|de|Wert fr 75C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_75_28                             "75 C (167 F)"
#define HLP_DEGREE_75_28                             "Enter value for 75C|de|Wert fr 75C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_80: Enter value for 80C|de|Wert fr 80C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_80_28                             "80 C (176 F)"
#define HLP_DEGREE_80_28                             "Enter value for 80C|de|Wert fr 80C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_85: Enter value for 85C|de|Wert fr 85C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_85_28                             "85 C (185 F)"
#define HLP_DEGREE_85_28                             "Enter value for 85C|de|Wert fr 85C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_90: Enter value for 90C|de|Wert fr 90C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_90_28                             "90 C (194 F)"
#define HLP_DEGREE_90_28                             "Enter value for 90C|de|Wert fr 90C"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_95: Enter value for 95C|de|Wert fr 95C
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_95_28                             "95 C (203 F)"
#define HLP_DEGREE_95_28                             "Enter value for 95C|de|Wert fr 95C"
/*
//----------------------------------------------------------------------------
// Variable PH_USER_BUFFER_1: Table if BUFFER is set to User buffer. 1st buffer
//----------------------------------------------------------------------------
*/
#define LBL_PH_USER_BUFFER_1_29                      "pH User Buffer 1"
#define HLP_PH_USER_BUFFER_1_29                      "Table if BUFFER is set to User buffer. 1st buffer"
/*
//----------------------------------------------------------------------------
// Variable NOMINAL: Enter nominal value at 25C for 1st user buffer pH|de|Nominellen Wert fr 25C fr 1. pH-Pffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_NOMINAL_29                               "Nominal Value|de|Nomineller Wert"
#define HLP_NOMINAL_29                               "Enter nominal value at 25C for 1st user buffer pH|de|Nominellen Wert fr 25C fr 1. pH-Pffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_0: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_0_29                              "0 C (32 F)"
#define HLP_DEGREE_0_29                              "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_5: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_5_29                              "5 C (41 F)"
#define HLP_DEGREE_5_29                              "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_10: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_10_29                             "10 C (50 F)"
#define HLP_DEGREE_10_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_15: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_15_29                             "15 C (59 F)"
#define HLP_DEGREE_15_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_20: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_20_29                             "20 C (68 F)"
#define HLP_DEGREE_20_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_25: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_25_29                             "25 C (77 F)"
#define HLP_DEGREE_25_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_30: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_30_29                             "30 C (86 F)"
#define HLP_DEGREE_30_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_35: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_35_29                             "35 C (95 F)"
#define HLP_DEGREE_35_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_40: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_40_29                             "40 C (104 F)"
#define HLP_DEGREE_40_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_45: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_45_29                             "45 C (113 F)"
#define HLP_DEGREE_45_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_50: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_50_29                             "50 C (122 F)"
#define HLP_DEGREE_50_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_55: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_55_29                             "55 C (131 F)"
#define HLP_DEGREE_55_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_60: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_60_29                             "60 C (140 F)"
#define HLP_DEGREE_60_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_65: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_65_29                             "65 C (149 F)"
#define HLP_DEGREE_65_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_70: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_70_29                             "70 C (158 F)"
#define HLP_DEGREE_70_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_75: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_75_29                             "75 C (167 F)"
#define HLP_DEGREE_75_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_80: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_80_29                             "80 C (176 F)"
#define HLP_DEGREE_80_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_85: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_85_29                             "85 C (185 F)"
#define HLP_DEGREE_85_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_90: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_90_29                             "90 C (194 F)"
#define HLP_DEGREE_90_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_95: Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_95_29                             "95 C (203 F)"
#define HLP_DEGREE_95_29                             "Enter value for 1st user buffer pH|de|Wert fr 1. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable PH_USER_BUFFER_2: Table if BUFFER is set to User buffer. 2nd buffer
//----------------------------------------------------------------------------
*/
#define LBL_PH_USER_BUFFER_2_30                      "pH User Buffer 2"
#define HLP_PH_USER_BUFFER_2_30                      "Table if BUFFER is set to User buffer. 2nd buffer"
/*
//----------------------------------------------------------------------------
// Variable NOMINAL: Enter nominal value at 25C for 2nd user buffer pH|de|Nominellen Wert fr 25C fr 2. pH-Pffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_NOMINAL_30                               "Nominal Value|de|Nomineller Wert"
#define HLP_NOMINAL_30                               "Enter nominal value at 25C for 2nd user buffer pH|de|Nominellen Wert fr 25C fr 2. pH-Pffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_0: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_0_30                              "0 C (32 F)"
#define HLP_DEGREE_0_30                              "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_5: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_5_30                              "5 C (41 F)"
#define HLP_DEGREE_5_30                              "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_10: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_10_30                             "10 C (50 F)"
#define HLP_DEGREE_10_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_15: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_15_30                             "15 C (59 F)"
#define HLP_DEGREE_15_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_20: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_20_30                             "20 C (68 F)"
#define HLP_DEGREE_20_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_25: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_25_30                             "25 C (77 F)"
#define HLP_DEGREE_25_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_30: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_30_30                             "30 C (86 F)"
#define HLP_DEGREE_30_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_35: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_35_30                             "35 C (95 F)"
#define HLP_DEGREE_35_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_40: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_40_30                             "40 C (104 F)"
#define HLP_DEGREE_40_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_45: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_45_30                             "45 C (113 F)"
#define HLP_DEGREE_45_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_50: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_50_30                             "50 C (122 F)"
#define HLP_DEGREE_50_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_55: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_55_30                             "55 C (131 F)"
#define HLP_DEGREE_55_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_60: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_60_30                             "60 C (140 F)"
#define HLP_DEGREE_60_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_65: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_65_30                             "65 C (149 F)"
#define HLP_DEGREE_65_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_70: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_70_30                             "70 C (158 F)"
#define HLP_DEGREE_70_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_75: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_75_30                             "75 C (167 F)"
#define HLP_DEGREE_75_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_80: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_80_30                             "80 C (176 F)"
#define HLP_DEGREE_80_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_85: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_85_30                             "85 C (185 F)"
#define HLP_DEGREE_85_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_90: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_90_30                             "90 C (194 F)"
#define HLP_DEGREE_90_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable DEGREE_95: Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben
//----------------------------------------------------------------------------
*/
#define LBL_DEGREE_95_30                             "95 C (203 F)"
#define HLP_DEGREE_95_30                             "Enter value for 2nd user buffer pH|de|Wert fr 2. Anwender-Puffer eingeben"
/*
//----------------------------------------------------------------------------
// Variable CAL_SAMPLE_PRD: Starts product calibration step 1. Is automatically reset to NOP|de|Startet edn 1. Schritt der Produktkalibrierung. Automatisch auf NOP.
//----------------------------------------------------------------------------
*/
#define LBL_CAL_SAMPLE_PRD_31                        "Sample Product|de|Probe ziehen"
#define HLP_CAL_SAMPLE_PRD_31                        "Starts product calibration step 1. Is automatically reset to NOP|de|Startet edn 1. Schritt der Produktkalibrierung. Automatisch auf NOP."
#define LBL_CAL_SAMPLE_PRD_31_VAL_0                  "No operation"
#define HLP_CAL_SAMPLE_PRD_31_VAL_0                  "No operation"
#define LBL_CAL_SAMPLE_PRD_31_VAL_1                  "Sample"
#define HLP_CAL_SAMPLE_PRD_31_VAL_1                  "Starts product calibration step 1. Is automatically reset to NOP"
/*
//----------------------------------------------------------------------------
// Variable CAL_SAMPLE_PRD_STORED_VAL: Shows the stored value of product calibration step 1|de|Zeigt den gespeicherten Wert aus dem 1. Schritt an.
//----------------------------------------------------------------------------
*/
#define LBL_CAL_SAMPLE_PRD_STORED_VAL_32             "Sample value|de|Probenwert"
#define HLP_CAL_SAMPLE_PRD_STORED_VAL_32             "Shows the stored value of product calibration step 1|de|Zeigt den gespeicherten Wert aus dem 1. Schritt an."
/*
//----------------------------------------------------------------------------
// Variable CAL_PRODUCT: Sets the value for the 2nd part of product calibration|de|Eingabe des Referenzwertes.
//----------------------------------------------------------------------------
*/
#define LBL_CAL_PRODUCT_33                           "Lab value|de|Laborwert"
#define HLP_CAL_PRODUCT_33                           "Sets the value for the 2nd part of product calibration|de|Eingabe des Referenzwertes."
/*
//----------------------------------------------------------------------------
// Variable CAL_PRD_STEP: Show the step of calibration state machine|de|Zeigt den Zustand der Produktkalibrierung
//----------------------------------------------------------------------------
*/
#define LBL_CAL_PRD_STEP_34                          "Calibration Product Step|de|Kalibrierschritt"
#define HLP_CAL_PRD_STEP_34                          "Show the step of calibration state machine|de|Zeigt den Zustand der Produktkalibrierung"
/*
//----------------------------------------------------------------------------
// Variable CAL_RESULT: Result of last calibration|de|Ergebnis der letzten Kalibrierung.
//----------------------------------------------------------------------------
*/
#define LBL_CAL_RESULT_35                            "Calibration Result|de|Kalibrierergebnis"
#define HLP_CAL_RESULT_35                            "Result of last calibration|de|Ergebnis der letzten Kalibrierung."
#define LBL_CAL_RESULT_35_VAL_0                      "Good|de|Gut"
#define HLP_CAL_RESULT_35_VAL_0                      "Last calibration successful|de|Die letzte Kalibrierung war erfolgreich."
#define LBL_CAL_RESULT_35_VAL_1                      "Bad|de|Schlecht"
#define HLP_CAL_RESULT_35_VAL_1                      "Error in calibration or break|de|Die letzte Kalibrierung war nicht erfolgreich."
/*
//----------------------------------------------------------------------------
// Variable LOGBOOK_ENTRY: Set the group index of logbook which should be read.|de|Indexgruppe des Logbuchs.
//----------------------------------------------------------------------------
*/
#define LBL_LOGBOOK_ENTRY_36                         "Logbook Entry|de|Logbucheintrag"
#define HLP_LOGBOOK_ENTRY_36                         "Set the group index of logbook which should be read.|de|Indexgruppe des Logbuchs."
/*
//----------------------------------------------------------------------------
// Variable LOGBOOK_BINARY_DATA: Raw Data
//----------------------------------------------------------------------------
*/
#define LBL_LOGBOOK_BINARY_DATA_37                   "Logbook Binary Data"
#define HLP_LOGBOOK_BINARY_DATA_37                   "Raw Data"
/*
//----------------------------------------------------------------------------
// Variable LOGBOOK_ERASE: Erases the logbook.|de|Lscht das Logbuch.
//----------------------------------------------------------------------------
*/
#define LBL_LOGBOOK_ERASE_38                         "Logbook Erase|de|Logbuch lschen"
#define HLP_LOGBOOK_ERASE_38                         "Erases the logbook.|de|Lscht das Logbuch."
#define LBL_LOGBOOK_ERASE_38_VAL_0                   "No operation"
#define HLP_LOGBOOK_ERASE_38_VAL_0                   "No operation"
#define LBL_LOGBOOK_ERASE_38_VAL_1                   "Erase"
#define HLP_LOGBOOK_ERASE_38_VAL_1                   "Erases the logbook."
/*
//----------------------------------------------------------------------------
// Variable SENSOR: Sensor data
//----------------------------------------------------------------------------
*/
#define LBL_SENSOR_39                                "Sensor"
#define HLP_SENSOR_39                                "Sensor data|de|Sensordaten"
/*
//----------------------------------------------------------------------------
// Variable SNS_STATUS: Shows the Status|de|Statusanzeige des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_SNS_STATUS_39                            "Status|de|Status"
#define HLP_SNS_STATUS_39                            "Shows the Status|de|Statusanzeige des Sensors"
/*
//----------------------------------------------------------------------------
// Variable RUNTIME: Runtime of digital Sensor|de|Laufzeit bei digitalen Sensoren.
//----------------------------------------------------------------------------
*/
#define LBL_RUNTIME_39                               "Operation time|de|Betriebszeit"
#define HLP_RUNTIME_39                               "Operation time of digital Sensor|de|Betriebszeit bei digitalen Sensoren."
/*
//----------------------------------------------------------------------------
// Variable SIP_CYCLES: SIP cycles|de|SIP Zyklen
//----------------------------------------------------------------------------
*/
#define LBL_SIP_CYCLES_39                            "SIP Cycles|de|SIP Zyklen"
#define HLP_SIP_CYCLES_39                            "SIP cycles|de|SIP Zyklen"
/*
//----------------------------------------------------------------------------
// Variable CIP_CYCLES: CIP cycles|de|CIP Zyklen
//----------------------------------------------------------------------------
*/
#define LBL_CIP_CYCLES_39                            "CIP Cycles|de|CIP Zyklen"
#define HLP_CIP_CYCLES_39                            "CIP cycles|de|CIP Zyklen"
/*
//----------------------------------------------------------------------------
// Variable TTM: Time to maintanance|de|Zeit bis zur nchsten Wartung.
//----------------------------------------------------------------------------
*/
#define LBL_TTM_39                                   "TTM|de|TTM"
#define HLP_TTM_39                                   "Time to maintanance|de|Zeit bis zur nchsten Wartung."
/*
//----------------------------------------------------------------------------
// Variable DLI: DLI with ISM Sensor (digital lifetime indicator) Lifetime for Memosens|de|Lifetime
//----------------------------------------------------------------------------
*/
#define LBL_DLI_39                                   "Lifetime|de|Restlaufzeit"
#define HLP_DLI_39                                   "DLI with ISM Sensor (digital lifetime indicator) Lifetime for Memosens|de|voraussichtliche Restlaufzeit"
/*
//----------------------------------------------------------------------------
// Variable ACT: ACT|de|ACT
//----------------------------------------------------------------------------
*/
#define LBL_ACT_39                                   "ACT|de|ACT"
#define HLP_ACT_39                                   "ACT|de|ACT"
/*
//----------------------------------------------------------------------------
// Variable AUTOCLAVE: Autoclave|de|Autoklavierzhler
//----------------------------------------------------------------------------
*/
#define LBL_AUTOCLAVE_39                             "Autoclave|de|Autoklavierzhler"
#define HLP_AUTOCLAVE_39                             "Autoclave|de|Autoklavierzhler"
/*
//----------------------------------------------------------------------------
// Variable WEAR: Sensor wear for Memosens pH or DO sensors|de|Sensorverschlei bei Memosens pH oder Sauerstoffsensoren
//----------------------------------------------------------------------------
*/
#define LBL_WEAR_39                                  "Wear|de|Verschlei"
#define HLP_WEAR_39                                  "Sensor wear for Memosens pH or DO sensors|de|Sensorverschlei bei Memosens pH oder Sauerstoffsensoren"
/*
//----------------------------------------------------------------------------
// Variable SMILEY: Shows the Sensoface Status|de|Sensoface Status
//----------------------------------------------------------------------------
*/
#define LBL_SMILEY_39                                "Sensoface|de|Sensoface"
#define HLP_SMILEY_39                                "Shows the Sensoface Status|de|Sensoface Status"
/*
//----------------------------------------------------------------------------
// Variable CALTIMER: Time until next calibration|de|Zeit bis zur nchsten Kalibrierung
//----------------------------------------------------------------------------
*/
#define LBL_CALTIMER_39                              "Calibration Timer|de|Kalibriertimer"
#define HLP_CALTIMER_39                              "Time until next calibration|de|Zeit bis zur nchsten Kalibrierung"
/*
//----------------------------------------------------------------------------
// Variable SENSOR_REQUEST_BIN: Request data of sensor information.
//----------------------------------------------------------------------------
*/
#define LBL_SENSOR_REQUEST_BIN_40                    "Sensor Request Binary"
#define HLP_SENSOR_REQUEST_BIN_40                    "Request data of sensor information."
/*
//----------------------------------------------------------------------------
// Variable SENSOR_RESPONSE_BIN: Response data of sensor information.
//----------------------------------------------------------------------------
*/
#define LBL_SENSOR_RESPONSE_BIN_41                   "Sensor Response Binary"
#define HLP_SENSOR_RESPONSE_BIN_41                   "Response data of sensor information."
/*
//----------------------------------------------------------------------------
// Variable PH_CAL_SLOPE: pH-Slope with read/write access|de|pH-Steilheit
//----------------------------------------------------------------------------
*/
#define LBL_PH_CAL_SLOPE_42                          "Slope|de|Steilheit"
#define HLP_PH_CAL_SLOPE_42                          "pH-Slope with read/write access|de|pH-Steilheit"
/*
//----------------------------------------------------------------------------
// Variable PH_CAL_ZERO: pH-Zero with read/write access|de|pH-Nullpunkt
//----------------------------------------------------------------------------
*/
#define LBL_PH_CAL_ZERO_43                           "Zero|de|Nullpunkt"
#define HLP_PH_CAL_ZERO_43                           "pH-Zero with read/write access|de|pH-Nullpunkt"
/*
//----------------------------------------------------------------------------
// Variable PH_CAL_OFFSET_ISFET: Isfet-Offset with read/write access (ISM only)|de|Isfett Offset
//----------------------------------------------------------------------------
*/
#define LBL_PH_CAL_OFFSET_ISFET_44                   "Isfet Offset|de|Isfet Offset"
#define HLP_PH_CAL_OFFSET_ISFET_44                   "Isfet-Offset with read/write access (ISM only)|de|Isfett Offset"
/*
//----------------------------------------------------------------------------
// Variable PH_CALZERO_ORP: ORP-Zero with read/write access (ORP only)|de|ORP-Nullpunkt
//----------------------------------------------------------------------------
*/
#define LBL_PH_CALZERO_ORP_45                        "ORP Zero|de|ORP Nullpunkt"
#define HLP_PH_CALZERO_ORP_45                        "ORP-Zero with read/write access (ORP only)|de|ORP-Nullpunkt"
/*
//----------------------------------------------------------------------------
// Variable DO_CAL_SLOPE: DO-Slope with read/write access|de|Sauerstoff-Steilheit
//----------------------------------------------------------------------------
*/
#define LBL_DO_CAL_SLOPE_46                          "Slope|de|Steilheit"
#define HLP_DO_CAL_SLOPE_46                          "DO-Slope with read/write access|de|Sauerstoff-Steilheit"
/*
//----------------------------------------------------------------------------
// Variable DO_CAL_ZERO: DO-Zero with read/write access|de|Sauerstoff-Nullpunkt
//----------------------------------------------------------------------------
*/
#define LBL_DO_CAL_ZERO_47                           "Zero|de|Nullpunkt"
#define HLP_DO_CAL_ZERO_47                           "DO-Zero with read/write access|de|Sauerstoff-Nullpunkt"
/*
//----------------------------------------------------------------------------
// Variable DO_CAL_RH: relative humidity while calibration [%]|de|Relative Feuchte bei der Kalibrierung [%]
//----------------------------------------------------------------------------
*/
#define LBL_DO_CAL_RH_48                             "rH|de|rH"
#define HLP_DO_CAL_RH_48                             "relative humidity while calibration [%]|de|Relative Feuchte bei der Kalibrierung [%]"
/*
//----------------------------------------------------------------------------
// Variable COND_CELLCONST: Enter the cellfactor of your sensor|de|Zellfaktor des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_COND_CELLCONST_49                        "Cellconstant|de|Zellkonstante"
#define HLP_COND_CELLCONST_49                        "Enter the cellfactor of your sensor|de|Zellfaktor des Sensors"
/*
//----------------------------------------------------------------------------
// Variable TC_CELLFACTOR: Enter the cellfactor of your sensor|de|Zellfaktor des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_TC_CELLFACTOR_50                         "Cellfactor|de|Zellfaktor"
#define HLP_TC_CELLFACTOR_50                         "Enter the cellfactor of your sensor|de|Zellfaktor des Sensors"
/*
//----------------------------------------------------------------------------
// Variable TC_INSTALL: Install factor|de|Einbaufaktor des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_TC_INSTALL_51                            "Install|de|Einbaufaktor"
#define HLP_TC_INSTALL_51                            "Install factor|de|Einbaufaktor des Sensors"
/*
//----------------------------------------------------------------------------
// Variable TC_ZERO: Enter the zero of your sensor|de|Nullpunkt des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_TC_ZERO_52                               "Zero|de|Nullpunkt"
#define HLP_TC_ZERO_52                               "Enter the zero of your sensor|de|Nullpunkt des Sensors"
/*
//----------------------------------------------------------------------------
// Variable TC_TRANS_RATIO: Enter the trans ration of your sensor|de|bertragungsfaktor des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_TC_TRANS_RATIO_53                        "Trans Ratio|de|bertragungsfaktor"
#define HLP_TC_TRANS_RATIO_53                        "Enter the trans ration of your sensor|de|bertragungsfaktor des Sensors"
/*
//----------------------------------------------------------------------------
// Variable CC_CELLFACTOR_A: Enter the cellfactor of sensor A (CC only)|de|Zellfaktor A des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_CC_CELLFACTOR_A_54                       "Cellfactor A|de|Zellfaktor A"
#define HLP_CC_CELLFACTOR_A_54                       "Enter the cellfactor of sensor A (CC only)|de|Zellfaktor A des Sensors"
/*
//----------------------------------------------------------------------------
// Variable CC_CELLFACTOR_B: Enter the cellfactor of sensor B (CC only)|de|Zellfaktor B des Sensors
//----------------------------------------------------------------------------
*/
#define LBL_CC_CELLFACTOR_B_55                       "Cellfactor B|de|Zellfaktor B"
#define HLP_CC_CELLFACTOR_B_55                       "Enter the cellfactor of sensor B (CC only)|de|Zellfaktor B des Sensors"
/*
//----------------------------------------------------------------------------
// Variable CAL_TIMESTAMP: Time of last calibration|de|Zeit der letzten Kalibrierung
//----------------------------------------------------------------------------
*/
#define LBL_CAL_TIMESTAMP_56                         "Calibration Time|de|Kalibrierzeitpunkt"
#define HLP_CAL_TIMESTAMP_56                         "Time of last calibration|de|Zeit der letzten Kalibrierung"
/*
//----------------------------------------------------------------------------
// Variable HOLD: Select status behaviour while calibration, configuration and service(life value or last usable value)|de|Whlt das Messwert Statusverhalten bei Kalibrierung, Konfigurierung, Service. (Life Wert oder letzer brauchbarer Wert)
//----------------------------------------------------------------------------
*/
#define LBL_HOLD_57                                  "Hold|de|Status Hold"
#define HLP_HOLD_57                                  "Select status behaviour while calibration, configuration and service(life value or last usable value)|de|Whlt das Messwert Statusverhalten bei Kalibrierung, Konfigurierung, Service. (Life Wert oder letzer brauchbarer Wert)"
#define LBL_HOLD_57_VAL_0                            "Off|de|Aus"
#define HLP_HOLD_57_VAL_0                            "Value and status are continued"
#define LBL_HOLD_57_VAL_1                            "Last Usable Value|de|Letzter brauchbarer Wert"
#define HLP_HOLD_57_VAL_1                            "Last Usable value is transmitted while calibration."
/*
//----------------------------------------------------------------------------
// Variable VERSION: Version
//----------------------------------------------------------------------------
*/
#define LBL_VERSION_58                               "Version"
#define HLP_VERSION_58                               "Version"
/*
//----------------------------------------------------------------------------
// Variable SERIAL_NO_BASE: Device Serial No|de|Seriennummer Gert
//----------------------------------------------------------------------------
*/
#define LBL_SERIAL_NO_BASE_58                        "Device Serial No|de|Seriennummer Gert"
#define HLP_SERIAL_NO_BASE_58                        "Device Serial No|de|Seriennummer Gert"
/*
//----------------------------------------------------------------------------
// Variable SW_VER_BASE: Device Software Version|de|Softwareversion Gert
//----------------------------------------------------------------------------
*/
#define LBL_SW_VER_BASE_58                           "Device Software Version|de|Softwareversion Gert"
#define HLP_SW_VER_BASE_58                           "Device Software Version|de|Softwareversion Gert"
/*
//----------------------------------------------------------------------------
// Variable HW_VER_BASE: Device Hardware Version|de|Hardwareversion Gert
//----------------------------------------------------------------------------
*/
#define LBL_HW_VER_BASE_58                           "Device Hardware Version|de|Hardwareversion Gert"
#define HLP_HW_VER_BASE_58                           "Device Hardware Version|de|Hardwareversion Gert"
/*
//----------------------------------------------------------------------------
// Variable SERIAL_NO_MEAS: Meas Module/sensor Serial No.|de|Seriennummer Messmodul/Sensor
//----------------------------------------------------------------------------
*/
#define LBL_SERIAL_NO_MEAS_58                        "Serial No.|de|Seriennummer"
#define HLP_SERIAL_NO_MEAS_58                        "Serial No.|de|Seriennummer"
/*
//----------------------------------------------------------------------------
// Variable SW_VER_MEAS: Meas Module/sensor Software Version|de|Softwareversion Messmodul/Sensor
//----------------------------------------------------------------------------
*/
#define LBL_SW_VER_MEAS_58                           "Software version|de|Softwareversion"
#define HLP_SW_VER_MEAS_58                           "Meas Module/sensor Software Version|de|Softwareversion Messmodul/Sensor"
/*
//----------------------------------------------------------------------------
// Variable HW_VER_MEAS: Meas Module/sensor Hardware Version|de|Hardwareversion Messmodul/Sensor
//----------------------------------------------------------------------------
*/
#define LBL_HW_VER_MEAS_58                           "Hardware version|de|Hardwareversion"
#define HLP_HW_VER_MEAS_58                           "Meas Module/sensor Hardware Version|de|Hardwareversion Messmodul/Sensor"
/*
//----------------------------------------------------------------------------
// Variable PV_PH: pH Value
//----------------------------------------------------------------------------
*/
#define LBL_PV_PH_59                                 "Value pH [pH]|de|pH Wert"
#define HLP_PV_PH_59                                 "pH Value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: pH Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_59                                 "Value pH [pH]|de|pH Wert"
#define HLP_VALUE_59                                 "pH Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_59                                "Status|de|Status"
#define HLP_STATUS_59                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_MV: mV Value
//----------------------------------------------------------------------------
*/
#define LBL_PV_MV_60                                 "Value mV [mV]|de|mV-Wert"
#define HLP_PV_MV_60                                 "mV Value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: mV Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_60                                 "Value mV [mV]|de|mV-Wert"
#define HLP_VALUE_60                                 "mV Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_60                                "Status|de|Status"
#define HLP_STATUS_60                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_ORP: ORP Value
//----------------------------------------------------------------------------
*/
#define LBL_PV_ORP_61                                "Value ORP [mV]|de|  mV-Wert            "
#define HLP_PV_ORP_61                                "ORP Value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: ORP Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_61                                 "Value ORP [mV]|de|  mV-Wert            "
#define HLP_VALUE_61                                 "ORP Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_61                                "Status|de|Status"
#define HLP_STATUS_61                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_GLASS_IMPEDANCE: Glass Impedance Value
//----------------------------------------------------------------------------
*/
#define LBL_PV_GLASS_IMPEDANCE_62                    "Value Glass Impedance [MOhm]|de|Glasimpedanz[MOhm]"
#define HLP_PV_GLASS_IMPEDANCE_62                    "Glass Impedance Value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Glass Impedance Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_62                                 "Value Glass Impedance [MOhm]|de|Glasimpedanz[MOhm]"
#define HLP_VALUE_62                                 "Glass Impedance Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_62                                "Status|de|Status"
#define HLP_STATUS_62                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_REFERENCE_IMPEDANCE: Reference Impedance Value
//----------------------------------------------------------------------------
*/
#define LBL_PV_REFERENCE_IMPEDANCE_63                "Value Reference Impedance [kOhm]|de|Bezugsimpedanz[kOhm]"
#define HLP_PV_REFERENCE_IMPEDANCE_63                "Reference Impedance Value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Reference Impedance Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_63                                 "Value Reference Impedance [kOhm]|de|Bezugsimpedanz[kOhm]"
#define HLP_VALUE_63                                 "Reference Impedance Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_63                                "Status|de|Status"
#define HLP_STATUS_63                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_TEMPERATURE: Temperature
//----------------------------------------------------------------------------
*/
#define LBL_PV_TEMPERATURE_64                        "Value Temperature|de|Temperatur"
#define HLP_PV_TEMPERATURE_64                        "Temperature"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Temperature
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_64                                 "Value Temperature|de|Temperatur"
#define HLP_VALUE_64                                 "Temperature"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_64                                "Status|de|Status"
#define HLP_STATUS_64                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_TEMPERATURE_UNIT: Select the unit of Temperature
//----------------------------------------------------------------------------
*/
#define LBL_PV_TEMPERATURE_UNIT_65                   "Temperature Unit|de|Temperatureinheit "
#define HLP_PV_TEMPERATURE_UNIT_65                   "Select the unit of Temperature"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1001          "C"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1001          "Unit of temperature"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1002          "F"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1002          "Unit of temperature"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1059          "h"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1059          "Hour"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1133          "kPa"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1133          "Pressure"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1137          "bar"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1137          "Pressure"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1138          "mbar"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1138          "Pressure"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1141          "psi"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1141          "Pressure"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1209          "A"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1209          "Current"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1213          "nA"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1213          "Current"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1243          "mV"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1243          "Voltage"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1281          "Ohm"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1281          "Resistance"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1299          "S/m"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1299          "Conductivity"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1302          "mS/cm"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1302          "Conductivity"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1342          "%"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1342          "Percent"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1353          "l/h"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1353          "Flow"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1422          "pH"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1422          "pH"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1423          "ppm"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1423          "ppm"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1523          "g/kg"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1523          "Salinity"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1524          "1/cm"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1524          "Cellconstant"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1552          "S/cm"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1552          "Conductivity"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1553          "mS/m"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1553          "Conductivity"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1555          "Mohm*cm"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1555          "Specific Resistance"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1558          "mg/l"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1558          "Oxygen in liquid/ TDS"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1559          "g/l"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1559          "Oxygen in liquid/ TDS"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_1562          "Vol%"
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_1562          "Oxygen in gases"
#define LBL_PV_TEMPERATURE_UNIT_65_VAL_0             " "
#define HLP_PV_TEMPERATURE_UNIT_65_VAL_0             "No unit"
/*
//----------------------------------------------------------------------------
// Variable PV_CAL_TIMER: Calibration timer is used to remind you for a calibration. Not for ISM sensors.
//----------------------------------------------------------------------------
*/
#define LBL_PV_CAL_TIMER_66                          "Value Calibration Timer [h]|de|Kalibriertimer [h]"
#define HLP_PV_CAL_TIMER_66                          "Calibration timer is used to remind you for a calibration. Not for ISM sensors."
/*
//----------------------------------------------------------------------------
// Variable VALUE: Calibration timer is used to remind you for a calibration. Not for ISM sensors.
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_66                                 "Value Calibration Timer [h]|de|Kalibriertimer [h]"
#define HLP_VALUE_66                                 "Calibration timer is used to remind you for a calibration. Not for ISM sensors."
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_66                                "Status|de|Status"
#define HLP_STATUS_66                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_SLOPE: Slope
//----------------------------------------------------------------------------
*/
#define LBL_PV_SLOPE_67                              "Value Slope|de|Steilheit"
#define HLP_PV_SLOPE_67                              "Slope"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Slope
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_67                                 "Value Slope|de|Steilheit"
#define HLP_VALUE_67                                 "Slope"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_67                                "Status|de|Status"
#define HLP_STATUS_67                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_SLOPE_UNIT: Select the slope unit
//----------------------------------------------------------------------------
*/
#define LBL_PV_SLOPE_UNIT_68                         "Slope Unit|de|Einheit Steilheit"
#define HLP_PV_SLOPE_UNIT_68                         "Select the slope unit"
#define LBL_PV_SLOPE_UNIT_68_VAL_1001                "C"
#define HLP_PV_SLOPE_UNIT_68_VAL_1001                "Unit of temperature"
#define LBL_PV_SLOPE_UNIT_68_VAL_1002                "F"
#define HLP_PV_SLOPE_UNIT_68_VAL_1002                "Unit of temperature"
#define LBL_PV_SLOPE_UNIT_68_VAL_1059                "h"
#define HLP_PV_SLOPE_UNIT_68_VAL_1059                "Hour"
#define LBL_PV_SLOPE_UNIT_68_VAL_1133                "kPa"
#define HLP_PV_SLOPE_UNIT_68_VAL_1133                "Pressure"
#define LBL_PV_SLOPE_UNIT_68_VAL_1137                "bar"
#define HLP_PV_SLOPE_UNIT_68_VAL_1137                "Pressure"
#define LBL_PV_SLOPE_UNIT_68_VAL_1138                "mbar"
#define HLP_PV_SLOPE_UNIT_68_VAL_1138                "Pressure"
#define LBL_PV_SLOPE_UNIT_68_VAL_1141                "psi"
#define HLP_PV_SLOPE_UNIT_68_VAL_1141                "Pressure"
#define LBL_PV_SLOPE_UNIT_68_VAL_1209                "A"
#define HLP_PV_SLOPE_UNIT_68_VAL_1209                "Current"
#define LBL_PV_SLOPE_UNIT_68_VAL_1213                "nA"
#define HLP_PV_SLOPE_UNIT_68_VAL_1213                "Current"
#define LBL_PV_SLOPE_UNIT_68_VAL_1243                "mV"
#define HLP_PV_SLOPE_UNIT_68_VAL_1243                "Voltage"
#define LBL_PV_SLOPE_UNIT_68_VAL_1281                "Ohm"
#define HLP_PV_SLOPE_UNIT_68_VAL_1281                "Resistance"
#define LBL_PV_SLOPE_UNIT_68_VAL_1299                "S/m"
#define HLP_PV_SLOPE_UNIT_68_VAL_1299                "Conductivity"
#define LBL_PV_SLOPE_UNIT_68_VAL_1302                "mS/cm"
#define HLP_PV_SLOPE_UNIT_68_VAL_1302                "Conductivity"
#define LBL_PV_SLOPE_UNIT_68_VAL_1342                "%"
#define HLP_PV_SLOPE_UNIT_68_VAL_1342                "Percent"
#define LBL_PV_SLOPE_UNIT_68_VAL_1353                "l/h"
#define HLP_PV_SLOPE_UNIT_68_VAL_1353                "Flow"
#define LBL_PV_SLOPE_UNIT_68_VAL_1422                "pH"
#define HLP_PV_SLOPE_UNIT_68_VAL_1422                "pH"
#define LBL_PV_SLOPE_UNIT_68_VAL_1423                "ppm"
#define HLP_PV_SLOPE_UNIT_68_VAL_1423                "ppm"
#define LBL_PV_SLOPE_UNIT_68_VAL_1523                "g/kg"
#define HLP_PV_SLOPE_UNIT_68_VAL_1523                "Salinity"
#define LBL_PV_SLOPE_UNIT_68_VAL_1524                "1/cm"
#define HLP_PV_SLOPE_UNIT_68_VAL_1524                "Cellconstant"
#define LBL_PV_SLOPE_UNIT_68_VAL_1552                "S/cm"
#define HLP_PV_SLOPE_UNIT_68_VAL_1552                "Conductivity"
#define LBL_PV_SLOPE_UNIT_68_VAL_1553                "mS/m"
#define HLP_PV_SLOPE_UNIT_68_VAL_1553                "Conductivity"
#define LBL_PV_SLOPE_UNIT_68_VAL_1555                "Mohm*cm"
#define HLP_PV_SLOPE_UNIT_68_VAL_1555                "Specific Resistance"
#define LBL_PV_SLOPE_UNIT_68_VAL_1558                "mg/l"
#define HLP_PV_SLOPE_UNIT_68_VAL_1558                "Oxygen in liquid/ TDS"
#define LBL_PV_SLOPE_UNIT_68_VAL_1559                "g/l"
#define HLP_PV_SLOPE_UNIT_68_VAL_1559                "Oxygen in liquid/ TDS"
#define LBL_PV_SLOPE_UNIT_68_VAL_1562                "Vol%"
#define HLP_PV_SLOPE_UNIT_68_VAL_1562                "Oxygen in gases"
#define LBL_PV_SLOPE_UNIT_68_VAL_0                   " "
#define HLP_PV_SLOPE_UNIT_68_VAL_0                   "No unit"
/*
//----------------------------------------------------------------------------
// Variable PV_ZERO: Zero
//----------------------------------------------------------------------------
*/
#define LBL_PV_ZERO_69                               "Value Zero|de|Nullpunkt"
#define HLP_PV_ZERO_69                               "Zero"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Zero
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_69                                 "Value Zero|de|Nullpunkt"
#define HLP_VALUE_69                                 "Zero"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_69                                "Status|de|Status"
#define HLP_STATUS_69                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_WEAR: Sensor wear for Memosens pH or DO sensors
//----------------------------------------------------------------------------
*/
#define LBL_PV_WEAR_70                               "Value Wear [%]|de|Verschleiss"
#define HLP_PV_WEAR_70                               "Sensor wear for Memosens pH or DO sensors"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Sensor wear for Memosens pH or DO sensors
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_70                                 "Value Wear [%]|de|Verschleiss"
#define HLP_VALUE_70                                 "Sensor wear for Memosens pH or DO sensors"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_70                                "Status|de|Status"
#define HLP_STATUS_70                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_FLOW: Flow-value
//----------------------------------------------------------------------------
*/
#define LBL_PV_FLOW_71                               "Value Flow [l/h]|de|Durchfluss"
#define HLP_PV_FLOW_71                               "Flow-value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Flow-value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_71                                 "Value Flow [l/h]|de|Durchfluss"
#define HLP_VALUE_71                                 "Flow-value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_71                                "Status|de|Status"
#define HLP_STATUS_71                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_DO_SATURATION_AIR: Saturation Air
//----------------------------------------------------------------------------
*/
#define LBL_PV_DO_SATURATION_AIR_72                  "Value DO Saturation Air [%]|de|Sttigung Air [%]"
#define HLP_PV_DO_SATURATION_AIR_72                  "Saturation Air"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Saturation Air
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_72                                 "Value DO Saturation Air [%]|de|Sttigung Air [%]"
#define HLP_VALUE_72                                 "Saturation Air"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_72                                "Status|de|Status"
#define HLP_STATUS_72                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_DO_CONCENTRATION: DO Concentration
//----------------------------------------------------------------------------
*/
#define LBL_PV_DO_CONCENTRATION_73                   "Value DO Concentration |de|Sauerstoffkonzentration"
#define HLP_PV_DO_CONCENTRATION_73                   "DO Concentration"
/*
//----------------------------------------------------------------------------
// Variable VALUE: DO Concentration
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_73                                 "Value DO Concentration|de|Sauerstoffkonzentration"
#define HLP_VALUE_73                                 "DO Concentration"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_73                                "Status|de|Status"
#define HLP_STATUS_73                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_DO_CONCENTRATION_UNIT: Select the unit for do concentration
//----------------------------------------------------------------------------
*/
#define LBL_PV_DO_CONCENTRATION_UNIT_74              "DO Concentration Unit|de|Einheit Sauerstoffkonzentration"
#define HLP_PV_DO_CONCENTRATION_UNIT_74              "Select the unit for do concentration"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1001     "C"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1001     "Unit of temperature"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1002     "F"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1002     "Unit of temperature"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1059     "h"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1059     "Hour"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1133     "kPa"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1133     "Pressure"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1137     "bar"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1137     "Pressure"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1138     "mbar"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1138     "Pressure"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1141     "psi"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1141     "Pressure"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1209     "A"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1209     "Current"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1213     "nA"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1213     "Current"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1243     "mV"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1243     "Voltage"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1281     "Ohm"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1281     "Resistance"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1299     "S/m"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1299     "Conductivity"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1302     "mS/cm"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1302     "Conductivity"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1342     "%"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1342     "Percent"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1353     "l/h"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1353     "Flow"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1422     "pH"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1422     "pH"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1423     "ppm"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1423     "ppm"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1523     "g/kg"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1523     "Salinity"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1524     "1/cm"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1524     "Cellconstant"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1552     "S/cm"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1552     "Conductivity"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1553     "mS/m"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1553     "Conductivity"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1555     "Mohm*cm"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1555     "Specific Resistance"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1558     "mg/l"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1558     "Oxygen in liquid/ TDS"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1559     "g/l"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1559     "Oxygen in liquid/ TDS"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1562     "Vol%"
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1562     "Oxygen in gases"
#define LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_0        " "
#define HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_0        "No unit"
/*
//----------------------------------------------------------------------------
// Variable PV_GAS_V_CONCENTRATION: Volume concentration in gas
//----------------------------------------------------------------------------
*/
#define LBL_PV_GAS_V_CONCENTRATION_75                "Volume Conc [Vol %]|de|Volumenkonzentration [Vol %]"
#define HLP_PV_GAS_V_CONCENTRATION_75                "Volume concentration in gas"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Volume concentration in gas
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_75                                 "Volume Conc [Vol %]|de|Volumenkonzentration [Vol %]"
#define HLP_VALUE_75                                 "Volume concentration in gas"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_75                                "Status|de|Status"
#define HLP_STATUS_75                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_PART_PRESSURE: Partial Pressure
//----------------------------------------------------------------------------
*/
#define LBL_PV_PART_PRESSURE_76                      "Value Partial Pressure [mbar]|de|Partialdruck [mbar]"
#define HLP_PV_PART_PRESSURE_76                      "Partial Pressure"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Partial Pressure
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_76                                 "Value Partial Pressure [mbar]|de|Partialdruck [mbar]"
#define HLP_VALUE_76                                 "Partial Pressure"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_76                                "Status|de|Status"
#define HLP_STATUS_76                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_CONDUCTIVITY: Conductivity
//----------------------------------------------------------------------------
*/
#define LBL_PV_CONDUCTIVITY_77                       "Value Conductivity|de|Leitfhigkeit"
#define HLP_PV_CONDUCTIVITY_77                       "Conductivity"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Conductivity
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_77                                 "Value Conductivity|de|Leitfhigkeit"
#define HLP_VALUE_77                                 "Conductivity"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_77                                "Status|de|Status"
#define HLP_STATUS_77                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_CONDUCTIVITY_UNIT: Select the unit of conductivity
//----------------------------------------------------------------------------
*/
#define LBL_PV_CONDUCTIVITY_UNIT_78                  "Conductivity Unit|de|Einheit Leitfhigkeit"
#define HLP_PV_CONDUCTIVITY_UNIT_78                  "Select the unit of conductivity"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1001         "C"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1001         "Unit of temperature"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1002         "F"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1002         "Unit of temperature"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1059         "h"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1059         "Hour"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1133         "kPa"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1133         "Pressure"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1137         "bar"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1137         "Pressure"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1138         "mbar"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1138         "Pressure"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1141         "psi"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1141         "Pressure"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1209         "A"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1209         "Current"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1213         "nA"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1213         "Current"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1243         "mV"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1243         "Voltage"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1281         "Ohm"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1281         "Resistance"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1299         "S/m"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1299         "Conductivity"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1302         "mS/cm"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1302         "Conductivity"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1342         "%"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1342         "Percent"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1353         "l/h"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1353         "Flow"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1422         "pH"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1422         "pH"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1423         "ppm"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1423         "ppm"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1523         "g/kg"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1523         "Salinity"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1524         "1/cm"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1524         "Cellconstant"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1552         "S/cm"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1552         "Conductivity"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1553         "mS/m"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1553         "Conductivity"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1555         "Mohm*cm"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1555         "Specific Resistance"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1558         "mg/l"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1558         "Oxygen in liquid/ TDS"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1559         "g/l"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1559         "Oxygen in liquid/ TDS"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1562         "Vol%"
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1562         "Oxygen in gases"
#define LBL_PV_CONDUCTIVITY_UNIT_78_VAL_0            " "
#define HLP_PV_CONDUCTIVITY_UNIT_78_VAL_0            "No unit"
/*
//----------------------------------------------------------------------------
// Variable PV_SPECIFIC_RESISTANCE: Specific Resistance
//----------------------------------------------------------------------------
*/
#define LBL_PV_SPECIFIC_RESISTANCE_79                "Specific Resi. [MOhm*cm]|de|spez. Widerstand [MOhm*cm]"
#define HLP_PV_SPECIFIC_RESISTANCE_79                "Specific Resistance"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Specific Resistance
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_79                                 "Specific Resi. [MOhm*cm]|de|spez. Widerstand [MOhm*cm]"
#define HLP_VALUE_79                                 "Specific Resistance"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_79                                "Status|de|Status"
#define HLP_STATUS_79                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_CONCENTRATION: Concentration
//----------------------------------------------------------------------------
*/
#define LBL_PV_CONCENTRATION_80                      "Value Concentration [%]|de|Konzentration [%]"
#define HLP_PV_CONCENTRATION_80                      "Concentration"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Concentration
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_80                                 "Value Concentration [%]|de|Konzentration [%]"
#define HLP_VALUE_80                                 "Concentration"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_80                                "Status|de|Status"
#define HLP_STATUS_80                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_CONDUCTANCE: Conductance
//----------------------------------------------------------------------------
*/
#define LBL_PV_CONDUCTANCE_81                        "Value Conductance|de|Leitfhigkeit"
#define HLP_PV_CONDUCTANCE_81                        "Conductance"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Conductance
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_81                                 "Value Conductance|de|Leitfhigkeit"
#define HLP_VALUE_81                                 "Conductance"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_81                                "Status|de|Status"
#define HLP_STATUS_81                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_SALINITY: Salinity
//----------------------------------------------------------------------------
*/
#define LBL_PV_SALINITY_82                           "Value Salinity [g/kg]|de|Salinitt [g/kg]"
#define HLP_PV_SALINITY_82                           "Salinity"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Salinity
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_82                                 "Value Salinity [g/kg]|de|Salinitt [g/kg]"
#define HLP_VALUE_82                                 "Salinity"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_82                                "Status|de|Status"
#define HLP_STATUS_82                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_TDS: TDS
//----------------------------------------------------------------------------
*/
#define LBL_PV_TDS_83                                "Value Tds [mg/l]|de|TDS-Wert"
#define HLP_PV_TDS_83                                "TDS"
/*
//----------------------------------------------------------------------------
// Variable VALUE: TDS
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_83                                 "Value Tds [mg/l]|de|TDS-Wert"
#define HLP_VALUE_83                                 "TDS"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_83                                "Status|de|Status"
#define HLP_STATUS_83                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_CONDUCTIVITY_2: CC: Conductivity 2nd value
//----------------------------------------------------------------------------
*/
#define LBL_PV_CONDUCTIVITY_2_84                     "Value Conductivity 2 [S/cm]|de|Leitfhigkeit 2"
#define HLP_PV_CONDUCTIVITY_2_84                     "CC: Conductivity 2nd value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: CC: Conductivity 2nd value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_84                                 "Value Conductivity 2[S/cm]|de|Leitfhigkeit 2"
#define HLP_VALUE_84                                 "CC: Conductivity 2nd value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_84                                "Status|de|Status"
#define HLP_STATUS_84                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_CALCULATION: CC: calculated value related to CC_Calculation type
//----------------------------------------------------------------------------
*/
#define LBL_PV_CALCULATION_85                        "Value Calculation|de|Verrechnung"
#define HLP_PV_CALCULATION_85                        "CC: calculated value related to CC_Calculation type"
/*
//----------------------------------------------------------------------------
// Variable VALUE: CC: calculated value related to CC_Calculation type
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_85                                 "Value Calculation|de|Verrechnung"
#define HLP_VALUE_85                                 "CC: calculated value related to CC_Calculation type"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_85                                "Status|de|Status"
#define HLP_STATUS_85                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_CELL: Cellfactor
//----------------------------------------------------------------------------
*/
#define LBL_PV_CELL_86                               "Value Cell [1/cm]|de|Zellfaktor [1/cm]"
#define HLP_PV_CELL_86                               "Cellfactor"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Cellfactor
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_86                                 "Value Cell [1/cm]|de|Zellfaktor [1/cm]"
#define HLP_VALUE_86                                 "Cellfactor"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_86                                "Status"
#define HLP_STATUS_86                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_TEMPERATURE_2: CC: Temperature 2nd value
//----------------------------------------------------------------------------
*/
#define LBL_PV_TEMPERATURE_2_87                      "Value Temperature 2|de|Temperatur 2"
#define HLP_PV_TEMPERATURE_2_87                      "CC: Temperature 2nd value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: CC: Temperature 2nd value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_87                                 "Value Temperature 2|de|Temperatur 2"
#define HLP_VALUE_87                                 "CC: Temperature 2nd value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_87                                "Status"
#define HLP_STATUS_87                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PV_TEMPERATURE_2_UNIT: CC: Select the unit of Temperature
//----------------------------------------------------------------------------
*/
#define LBL_PV_TEMPERATURE_2_UNIT_88                 "Temperature 2 Unit|de|Temperatur Einheit"
#define HLP_PV_TEMPERATURE_2_UNIT_88                 "CC: Select the unit of Temperature"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1001        "C"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1001        "Unit of temperature"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1002        "F"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1002        "Unit of temperature"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1059        "h"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1059        "Hour"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1133        "kPa"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1133        "Pressure"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1137        "bar"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1137        "Pressure"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1138        "mbar"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1138        "Pressure"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1141        "psi"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1141        "Pressure"
//#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1209        "A"
//#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1209        "Current"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1213        "nA"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1213        "Current"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1243        "mV"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1243        "Voltage"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1281        "Ohm"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1281        "Resistance"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1290        "uS"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1290        "uS"
//#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1299        "S/m"
//#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1299        "Conductivity"
//#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1302        "mS/cm"
//#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1302        "Conductivity"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1342        "%"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1342        "Percent"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1353        "l/h"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1353        "Flow"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1422        "pH"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1422        "pH"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1423        "ppm"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1423        "ppm"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1523        "g/kg"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1523        "Salinity"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1524        "1/cm"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1524        "Cellconstant"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1552        "S/cm"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1552        "Conductivity"
//#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1553        "mS/m"
//#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1553        "Conductivity"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1555        "Mohm*cm"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1555        "Specific Resistance"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1558        "mg/l"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1558        "Oxygen in liquid/ TDS"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1559        "g/l"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1559        "Oxygen in liquid/ TDS"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1562        "Vol%"
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1562        "Oxygen in gases"
#define LBL_PV_TEMPERATURE_2_UNIT_88_VAL_0           " "
#define HLP_PV_TEMPERATURE_2_UNIT_88_VAL_0           "No unit"
/*
//----------------------------------------------------------------------------
// Variable CAL_PRD_STORED_VAL_UNIT: Unit of value while Product Calibration.
//----------------------------------------------------------------------------
*/
#define LBL_CAL_PRD_STORED_VAL_UNIT_89               "Unit|de|Einheit"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89               "Unit of value while Product Calibration."
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1001      "C"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1001      "Unit of temperature"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1002      "F"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1002      "Unit of temperature"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1059      "h"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1059      "Hour"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1133      "kPa"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1133      "Pressure"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1137      "bar"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1137      "Pressure"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1138      "mbar"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1138      "Pressure"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1141      "psi"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1141      "Pressure"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1209      "A"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1209      "Current"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1213      "nA"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1213      "Current"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1243      "mV"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1243      "Voltage"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1281      "Ohm"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1281      "Resistance"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1299      "S/m"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1299      "Conductivity"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1302      "mS/cm"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1302      "Conductivity"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1342      "%"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1342      "Percent"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1353      "l/h"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1353      "Flow"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1422      "pH"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1422      "pH"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1423      "ppm"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1423      "ppm"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1523      "g/kg"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1523      "Salinity"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1524      "1/cm"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1524      "Cellconstant"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1552      "S/cm"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1552      "Conductivity"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1553      "mS/m"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1553      "Conductivity"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1555      "Mohm*cm"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1555      "Specific Resistance"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1558      "mg/l"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1558      "Oxygen in liquid/ TDS"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1559      "g/l"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1559      "Oxygen in liquid/ TDS"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1562      "Vol%"
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1562      "Oxygen in gases"
#define LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_0         " "
#define HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_0         "No unit"
/*
//----------------------------------------------------------------------------
// Variable FINAL_VALUE_TEMPERATURE: Analog Output
//----------------------------------------------------------------------------
*/
#define LBL_FINAL_VALUE_TEMPERATURE_90               "AO Final Value Temperature"
#define HLP_FINAL_VALUE_TEMPERATURE_90               "Analog Output"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_90                                 "AO Final Value Temperature   "
#define HLP_VALUE_90                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_90                                "Status"
#define HLP_STATUS_90                                "Status"
/*
//----------------------------------------------------------------------------
// Variable FINAL_VALUE_TEMPERATURE_FEEDBACK: AO Feedback Value (not used)
//----------------------------------------------------------------------------
*/
#define LBL_FINAL_VALUE_TEMPERATURE_FEEDBACK_91      "AO Feedback Value (not used)"
#define HLP_FINAL_VALUE_TEMPERATURE_FEEDBACK_91      "AO Feedback Value (not used)"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_91                                 "AO Final Value Temperature   "
#define HLP_VALUE_91                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_91                                "Status"
#define HLP_STATUS_91                                "Status"
/*
//----------------------------------------------------------------------------
// Variable FINAL_VALUE_PRESSURE: Analog Output
//----------------------------------------------------------------------------
*/
#define LBL_FINAL_VALUE_PRESSURE_92                  "AO Final Value Pressure"
#define HLP_FINAL_VALUE_PRESSURE_92                  "Analog Output"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_92                                 "AO Final Value Pressure"
#define HLP_VALUE_92                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_92                                "Status"
#define HLP_STATUS_92                                "Status"
/*
//----------------------------------------------------------------------------
// Variable FINAL_VALUE_PRESSURE_FEEDBACK: AO Feedback Value (not used)
//----------------------------------------------------------------------------
*/
#define LBL_FINAL_VALUE_PRESSURE_FEEDBACK_93         "AO Feedback Value (not used)"
#define HLP_FINAL_VALUE_PRESSURE_FEEDBACK_93         "AO Feedback Value (not used)"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_93                                 "Value"
#define HLP_VALUE_93                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_93                                "Status"
#define HLP_STATUS_93                                "Status"
/*
//----------------------------------------------------------------------------
// Variable FINAL_VALUE_D_RELAY_1: DO Final Value 1
//----------------------------------------------------------------------------
*/
#define LBL_FINAL_VALUE_D_RELAY_1_94                 "DO Final Value 1"
#define HLP_FINAL_VALUE_D_RELAY_1_94                 "DO Final Value 1"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_94                                 "Value"
#define HLP_VALUE_94                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_94                                "Status"
#define HLP_STATUS_94                                "Status"
/*
//----------------------------------------------------------------------------
// Variable FINAL_VALUE_D_RELAY_2: DO Final Value 2
//----------------------------------------------------------------------------
*/
#define LBL_FINAL_VALUE_D_RELAY_2_95                 "DO Final Value 2"
#define HLP_FINAL_VALUE_D_RELAY_2_95                 "DO Final Value 2"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_95                                 "Value"
#define HLP_VALUE_95                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_95                                "Status"
#define HLP_STATUS_95                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PRIMARY_VALUE_D_USP: DI Value USP
//----------------------------------------------------------------------------
*/
#define LBL_PRIMARY_VALUE_D_USP_96                   "DI Value USP"
#define HLP_PRIMARY_VALUE_D_USP_96                   "DI Value USP"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_96                                 "Value"
#define HLP_VALUE_96                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_96                                "Status"
#define HLP_STATUS_96                                "Status"
/*
//----------------------------------------------------------------------------
// Variable PRIMARY_VALUE: Primary Value
//----------------------------------------------------------------------------
*/
#define LBL_PRIMARY_VALUE_97                         "Primary Value"
#define HLP_PRIMARY_VALUE_97                         "Primary Value"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Value
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_97                                 "Value"
#define HLP_VALUE_97                                 "Value"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Status
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_97                                "Status"
#define HLP_STATUS_97                                "Status"
/*
//----------------------------------------------------------------------------
// Variable CURRENT_ERROR: Current error of the device|de|Aktueller Fehler des Gertes
//----------------------------------------------------------------------------
*/
#define LBL_CURRENT_ERROR_98                         "Current Error|de|Aktueller Fehler"
#define HLP_CURRENT_ERROR_98                         "Current error of the device|de|Aktueller Fehler des Gertes"
#define LBL_CURRENT_ERROR_98_VAL_0                   "NO FAILURE"
#define HLP_CURRENT_ERROR_98_VAL_0                   "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_102                 "FAILURE BUFFERSET -U1- OR UPOL"
#define HLP_CURRENT_ERROR_98_VAL_102                 "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_103                 "INVALID PARAMETER MEMBR. COMP"
#define HLP_CURRENT_ERROR_98_VAL_103                 "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_59                  "INVALID CALCULATION"
#define HLP_CURRENT_ERROR_98_VAL_59                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_45                  "SENSOCHECK"
#define HLP_CURRENT_ERROR_98_VAL_45                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_41                  "RANGE CONDUCTIVITY B"
#define HLP_CURRENT_ERROR_98_VAL_41                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_43                  "TEMPERATURE RANGE"
#define HLP_CURRENT_ERROR_98_VAL_43                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_40                  "CONDUCTANCE TOO HIGH"
#define HLP_CURRENT_ERROR_98_VAL_40                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_13                  "TEMPERATURE RANGE"
#define HLP_CURRENT_ERROR_98_VAL_13                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_16                  "SENSOCHECK REF-EL"
#define HLP_CURRENT_ERROR_98_VAL_16                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_10                  "ORP OR CONDUCTANCE RANGE"
#define HLP_CURRENT_ERROR_98_VAL_10                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_11                  "PRIMARY VALUE RANGE"
#define HLP_CURRENT_ERROR_98_VAL_11                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_12                  "SECONDARY VALUE RANGE"
#define HLP_CURRENT_ERROR_98_VAL_12                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_15                  "SENSOCHECK"
#define HLP_CURRENT_ERROR_98_VAL_15                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_5                   "CAL DATA"
#define HLP_CURRENT_ERROR_98_VAL_5                   "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_4                   "SENSOR FAILURE"
#define HLP_CURRENT_ERROR_98_VAL_4                   "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_3                   "CANCELED SENSOR"
#define HLP_CURRENT_ERROR_98_VAL_3                   "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_2                   "WRONG SENSOR"
#define HLP_CURRENT_ERROR_98_VAL_2                   "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_1                   "NO SENSOR"
#define HLP_CURRENT_ERROR_98_VAL_1                   "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_96                  "WRONG MODULE"
#define HLP_CURRENT_ERROR_98_VAL_96                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_97                  "NO MODULE INSTALLED"
#define HLP_CURRENT_ERROR_98_VAL_97                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_94                  "FB BLOCK ALARM"
#define HLP_CURRENT_ERROR_98_VAL_94                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_95                  "SYSTEM ERROR"
#define HLP_CURRENT_ERROR_98_VAL_95                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_98                  "CONFIGURATION ERROR"
#define HLP_CURRENT_ERROR_98_VAL_98                  "Active Error"
#define LBL_CURRENT_ERROR_98_VAL_99                  "DEVICE FAILURE"
#define HLP_CURRENT_ERROR_98_VAL_99                  "Active Error"
/*
//----------------------------------------------------------------------------
// Variable PV_SPECIFIC_RESISTANCE_2: CC: Specific Resistance 2
//----------------------------------------------------------------------------
*/
#define LBL_PV_SPECIFIC_RESISTANCE_2_99              "Specific Resi. 2[MOhm*cm]|de|spez. Widerstand 2[MOhm*cm]"
#define HLP_PV_SPECIFIC_RESISTANCE_2_99              "CC: Specific Resistance 2"
/*
//----------------------------------------------------------------------------
// Variable STATUS: Specific Resistance
//----------------------------------------------------------------------------
*/
#define LBL_STATUS_99                                "Status"
#define HLP_STATUS_99                                "Specific Resistance"
/*
//----------------------------------------------------------------------------
// Variable VALUE: Status
//----------------------------------------------------------------------------
*/
#define LBL_VALUE_99                                 "Specific Resi. 2[MOhm*cm]|de|spez. Widerstand 2[MOhm*cm]"
#define HLP_VALUE_99                                 "Status"
/*
//----------------------------------------------------------------------------
// Variable SENSOR_FIX: Sensor data|de|Sensordaten
//----------------------------------------------------------------------------
*/
#define LBL_SENSOR_FIX_100                           "Sensor Fix data|de|Feste Sensordaten"
#define HLP_SENSOR_FIX_100                           "Sensor data|de|Sensordaten"
/*
//----------------------------------------------------------------------------
// Variable SERIAL_NO: Serial number of digital sensor|de|Seriennummer des digitalen Sensors
//----------------------------------------------------------------------------
*/
#define LBL_SERIAL_NO_100                            "Sensor Serial No.|de|Sensor Seriennummer"
#define HLP_SERIAL_NO_100                            "Serial number of digital sensor|de|Seriennummer des digitalen Sensors"
/*
//----------------------------------------------------------------------------
// Variable ORDER_NO: Order number of digital sensor|de|Bestellnummer des digitalen Sensors
//----------------------------------------------------------------------------
*/
#define LBL_ORDER_NO_100                             "Sensor Order No.|de|Sensor Bestellnummer"
#define HLP_ORDER_NO_100                             "Order number of digital sensor|de|Bestellnummer des digitalen Sensors"
/*
//----------------------------------------------------------------------------
// Variable TAG: TAG of digital Sensor|de|Sensor TAG des digitalen Sensors
//----------------------------------------------------------------------------
*/
#define LBL_TAG_100                                  "Tag|de|Sensor TAG"
#define HLP_TAG_100                                  "TAG of digital Sensor|de|Sensor TAG des digitalen Sensors"
/*
//----------------------------------------------------------------------------
// Variable MANU: Manufacturer of digital sensor|de|Hersteller des digitalen Sensors
//----------------------------------------------------------------------------
*/
#define LBL_MANU_100                                 "Manufacturer|de|Hersteller"
#define HLP_MANU_100                                 "Manufacturer of digital sensor|de|Hersteller des digitalen Sensors"
/*
//----------------------------------------------------------------------------
// Variable INIT_OPERATION: Time of initial operation|de|Erstinbetriebnahme des digitalen Sensors
//----------------------------------------------------------------------------
*/
#define LBL_INIT_OPERATION_100                       "Initial Operation|de|Erstinbetriebnahme"
#define HLP_INIT_OPERATION_100                       "Time of initial operation|de|Erstinbetriebnahme des digitalen Sensors"

