/* ----------------------------------------------------------------------

 FILE_NAME          ai3.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
  ###   #####  #### 
 #   #    #        #
 #   #    #     ### 
 #####    #        #
 #   #  #####  #### 
 ------------------------------------------------------
 */

IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC3_AI, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{

    EVERYTHING;

    REDEFINITIONS
    {
        REDEFINE VARIABLE func3_AI_OUT_SCALE_Upper_Value
        {
            LABEL [PI_OUT_SCALE_Upper_Value_label];
            HELP [PI_OUT_SCALE_Upper_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 100;
            }
        }

        REDEFINE VARIABLE func3_AI_OUT_SCALE_Lower_Value
        {
            LABEL [PI_OUT_SCALE_Lower_Value_label];
            HELP [PI_OUT_SCALE_Lower_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
            }
        }

        REDEFINE VARIABLE func3_AI_OUT_SCALE_Decimal_Point
        {
            LABEL [PI_OUT_SCALE_Decimal_Point_label];
            HELP [PI_OUT_SCALE_Decimal_Point_help];
            CLASS CONTAINED & SERVICE;
            TYPE INTEGER (1)
            {
                DEFAULT_VALUE 0;
                MIN_VALUE 0;
                MAX_VALUE 7;
            }
        }

        REDEFINE VARIABLE func3_AI_OUT_Value
        {
            LABEL [PI_OUT_Value_label];
            HELP [PI_OUT_Value_help];
            CLASS OUTPUT & DYNAMIC;
            HANDLING IF (func3_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE FLOAT { DISPLAY_FORMAT DEF_DISPLAY_FORMAT(func3_AI_OUT_SCALE_Decimal_Point) }
        }
        
        REDEFINE VARIABLE func3_AI_OUT_SCALE_Units_Index
        {
            LABEL [PI_PRIMARY_VALUE_UNIT_label];
            HELP [PI_PRIMARY_VALUE_UNIT_help];
            CLASS CONTAINED & SERVICE;
            TYPE ENUMERATED(2)
            {
                DEFAULT_VALUE 1342;
                AI_UNIT_LIST
            }
        }

        REDEFINE VARIABLE func3_AI_CHANNEL
        {
            LABEL "AI3 " + [PI_CHANNEL_label];
            HELP [PI_CHANNEL_help];
            CLASS CONTAINED;            
            TYPE ENUMERATED (2)
            {
                SELECT ( meas_type )
                {
                    CASE MEAS_TYPE_PH: AI_CHANNEL_LIST_PH
                    CASE MEAS_TYPE_COND: AI_CHANNEL_LIST_COND
                    CASE MEAS_TYPE_CONDI: AI_CHANNEL_LIST_CONDI
                    CASE MEAS_TYPE_CC: AI_CHANNEL_LIST_CC
                    CASE MEAS_TYPE_OXY: AI_CHANNEL_LIST_OXY
                    //DEFAULT: AI_CHANNEL_LIST
                }
            }
            HANDLING READ & WRITE;
            POST_EDIT_ACTIONS {method_func3_set_default_unit}
        }    
    }
}

ARRAY OF VARIABLE refarray_func3_AI_CHANNEL
{
    LABEL "";    
    ELEMENTS
    {
        0, func3_AI_CHANNEL;
        1, func3_AI_CHANNEL;
        2, func3_AI_CHANNEL;
        3, func3_AI_CHANNEL;
        4, func3_AI_CHANNEL;
    }
}

/*
 ####################################
 Configuration vom AI
 ####################################
 */
MENU output_ai3_window
{
    LABEL [LABEL_AI3];
    STYLE WINDOW;
    ITEMS
    {
        meas_type(HIDDEN),
        conf_out_ai3_ident,
        conf_out_ai3_process,
        conf_out_ai3_alarm,
        conf_out_ai3_fail,
        conf_out_ai3_batch
    }
    POST_READ_ACTIONS { method_refresh_ai_channels }
}

MENU out_ai3_value
{
    LABEL [PI_display_measure];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_OUT_SCALE_Units_Index (HIDDEN),
        refarray_func3_AI_CHANNEL[meas_type] (READ_ONLY),
        ROWBREAK,
        func3_AI_OUT_Value (READ_ONLY),
        ROWBREAK,
        func3_AI_OUT_Status_Condensed (READ_ONLY)
    }
}

/* TAG... */
MENU conf_out_ai3_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func3_AI_TAG_DESC,
        func3_AI_STRATEGY,
        func3_AI_ST_REV
    }
}

/* OUT,CHANNEL... */
MENU conf_out_ai3_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        refarray_func3_AI_CHANNEL[meas_type],
        func3_AI_PV_FTIME,
        func3_AI_PV_SCALE_Lower_Value,
        func3_AI_PV_SCALE_Upper_Value,
        func3_AI_OUT_SCALE_Lower_Value,
        func3_AI_OUT_SCALE_Upper_Value,
        //    func3_AI_OUT_SCALE_Units_Index(READ_ONLY),
        func3_AI_OUT_SCALE_Decimal_Point
    }
}

/* Alarm, limits... */
MENU conf_out_ai3_alarm
{
    LABEL TXT_FB_ALARM;
    STYLE GROUP;
    ITEMS
    {
        func3_AI_HI_HI_LIM,
        func3_AI_HI_LIM,
        func3_AI_LO_LIM,
        func3_AI_LO_LO_LIM,
        func3_AI_ALARM_HYS
    }
}

/* fail safe... */
MENU conf_out_ai3_fail
{
    LABEL TXT_FB_FAIL;
    STYLE GROUP;
    ITEMS
    {
        func3_AI_FSAFE_TYPE,
        func3_AI_FSAFE_VALUE
    }
}

/* Batch.. */
MENU conf_out_ai3_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func3_AI_BATCH_Batch_ID,
        func3_AI_BATCH_Rup,
        func3_AI_BATCH_Operation,
        func3_AI_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_ai3_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func3_AI_TARGET_MODE,
        func3_AI_MODE_BLK_Actual,
        func3_AI_SIMULATE_Enabled,
        func3_AI_SIMULATE_Value,
        func3_AI_SIMULATE_Status_Condensed
    }
}

MENU out_ai3_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_MODE_BLK_Actual,
        ROWBREAK ,
        func3_AI_SIMULATE_Enabled (READ_ONLY)
    }
}

MENU simulation_window_ai3
{
    LABEL [LABEL_AI3];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
        func3_AI_OUT_SCALE_Units_Index (HIDDEN),

        func3_AI_CHANNEL (READ_ONLY),
        simulation_wnd_ai3_input,
        simulation_wnd_ai3_output
    }
}
MENU simulation_wnd_ai3_input
{
    LABEL TXT_AI_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func3_AI_SIMULATE_Enabled,
        func3_AI_SIMULATE_Value,
        func3_AI_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_ai3_output
{
    LABEL TXT_AI_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func3_AI_TARGET_MODE,
        func3_AI_MODE_BLK_Actual,
        func3_AI_OUT_Value,
        func3_AI_OUT_Status_Condensed
    }
}
/*
 ####################################
 Diagnose vom AI
 ####################################
 */
MENU output_ai3_diag_window
{
    LABEL "Output AI3";
    STYLE WINDOW;
    ITEMS
    {
        diag_out_ai3_alarm
    }
}

/* Alarms... */
MENU diag_out_ai3_alarm
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        func3_AI_ALARM_SUM_Current,
        func3_AI_ALARM_SUM_Unacknowledged,
        func3_AI_ALARM_SUM_Unreported,
        func3_AI_ALARM_SUM_Disabled,
        func3_AI_HI_HI_ALM_Unacknowledged,
        func3_AI_HI_HI_ALM_Alarm_State,
        //func3_AI_HI_HI_ALM_Time_Stamp,
        func3_AI_HI_HI_ALM_Subcode,
        func3_AI_HI_HI_ALM_Value,
        /* -------------------------- */
        func3_AI_HI_ALM_Unacknowledged,
        func3_AI_HI_ALM_Alarm_State,
        // func3_AI_HI_ALM_Time_Stamp,
        func3_AI_HI_ALM_Subcode,
        func3_AI_HI_ALM_Value,
        /* -------------------------- */
        func3_AI_LO_ALM_Unacknowledged,
        func3_AI_LO_ALM_Alarm_State,
        // func3_AI_LO_ALM_Time_Stamp,
        func3_AI_LO_ALM_Subcode,
        func3_AI_LO_ALM_Value,
        /* -------------------------- */
        func3_AI_LO_LO_ALM_Unacknowledged,
        func3_AI_LO_LO_ALM_Alarm_State,
        // func3_AI_LO_LO_ALM_Time_Stamp,
        func3_AI_LO_LO_ALM_Subcode,
        func3_AI_LO_LO_ALM_Value
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

SOURCE ai3_value_source
{
    LABEL [LABEL_AI3];
    Y_AXIS func3_AI_Display_BarVal_out_axis_mandatory_B;
    MEMBERS
    {
        PRIM_VAL, func3_AI_OUT_Value;
    }
}

CHART ai3_value_chart
{
    LABEL "AI3 Value";
    TYPE HORIZONTAL_BAR;    //GAUGE;
    MEMBERS {CHART1, ai3_value_source;}
}

/* Messwerte */
MENU display_out_func3_AI
{
    LABEL [LABEL_AI3];
    ITEMS 
    {
        meas_type (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
        
        out_ai3_value,
        ROWBREAK,
        out_ai3_simu,
        ROWBREAK,
        out_ai3_alarms
    }
}
MENU func3_AI_ovw
{
    LABEL [LABEL_AI3];
    STYLE GROUP;
    ITEMS 
    {
        meas_type (HIDDEN),        
        func3_AI_OUT_SCALE_Units_Index (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
                
        func3_AI_CHANNEL (READ_ONLY),
        func3_AI_OUT_Value,        
        func3_AI_OUT_Status_Condensed
    }
}

/* Alarme */

MENU out_ai3_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_ALARM_SUM_Current
    }
}

MENU overview_ai3_alarms
{
    LABEL [LABEL_AI3];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_ALARM_SUM_Current
        /*
        ,
        COLUMNBREAK,
        func3_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func3_AI_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func3_AI_ALARM_SUM_Disabled        
        */
    }
}

//MENU OnlineWindow_S_alarm_func3_AI
MENU Win_alarm_func3_AI
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        alarm_sum_func3_AI,
        alarm_hi_hi_alm_func3_AI,
        alarm_hi_alm_func3_AI,
        alarm_lo_alm_func3_AI,
        alarm_lo_lo_alm_func3_AI
    }
}

MENU alarm_sum_func3_AI
{
    LABEL [PI_ALARM_SUM_label];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_ALARM_SUM_Current,
        func3_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func3_AI_ALARM_SUM_Unreported,
        func3_AI_ALARM_SUM_Disabled
    }
}

MENU alarm_hi_hi_alm_func3_AI
{
    LABEL [PI_HI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_HI_HI_ALM_Unacknowledged,
        func3_AI_HI_HI_ALM_Alarm_State,
        //func3_AI_HI_HI_ALM_Time_Stamp,
        func3_AI_HI_HI_ALM_Subcode,
        func3_AI_HI_HI_LIM (READ_ONLY),
        func3_AI_HI_HI_ALM_Value
    }
}

MENU alarm_hi_alm_func3_AI
{
    LABEL [PI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_HI_ALM_Unacknowledged,
        func3_AI_HI_ALM_Alarm_State,
        //func3_AI_HI_ALM_Time_Stamp,
        func3_AI_HI_ALM_Subcode,
        func3_AI_HI_LIM (READ_ONLY),
        func3_AI_HI_ALM_Value
    }
}

MENU alarm_lo_alm_func3_AI
{
    LABEL [PI_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_LO_ALM_Unacknowledged,
        func3_AI_LO_ALM_Alarm_State,
        //func3_AI_LO_ALM_Time_Stamp,
        func3_AI_LO_ALM_Subcode,
        func3_AI_LO_LIM (READ_ONLY),
        func3_AI_LO_ALM_Value
    }
}

MENU alarm_lo_lo_alm_func3_AI
{
    LABEL [PI_LO_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func3_AI_LO_LO_ALM_Unacknowledged,
        func3_AI_LO_LO_ALM_Alarm_State,
        //func3_AI_LO_LO_ALM_Time_Stamp,
        func3_AI_LO_LO_ALM_Subcode,
        func3_AI_LO_LO_LIM (READ_ONLY),
        func3_AI_LO_LO_ALM_Value
    }
}

METHOD method_func3_set_default_unit
{
    LABEL "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    DEFINITION {func3_AI_OUT_SCALE_Units_Index = method_set_default_unit(func3_AI_CHANNEL);}
}

UNIT func3_AI_OUT_SCALE_unit_x
{
    func3_AI_OUT_SCALE_Units_Index:            
    func3_AI_SIMULATE_Value
}
