/*
Filename:           61CD01.ddl
Function:           Device Description for .......
Device:             Stratos Multi
Device Revision:    1
DD Revision:        1
Last edit:          stz
Manufacturer:       KNICK GmbH & Co.,
                                Beuckestr.22,
                                D-14163 Berlin
                                Tel: +49 (0) 30-80191-0,
                                Fax: +49 (0) 30-80191-200
                                Internet: http://www.knick.de
                                email: knick@knick.de
Copyright:          (C) Knick GmbH & Co., 2019 All Rights Reserved.
*/

// Zusatz fr das EDD Studio
#define EDD_STUDIO              0

// Darf bei der Registrierung nicht im Code sein, wird aber fr PDM gebraucht!
#ifndef _STRATOS_MULTI
  #define _STRATOS_MULTI        0x61CD
#endif

MANUFACTURER KNICK, DEVICE_TYPE _STRATOS_MULTI, DEVICE_REVISION 2, DD_REVISION 1


/*
---------------------------------------------------------------
Note:
max. string length for label or text is 18 character for HC375
max. string for BIT_ENUMERATED is 16 character for HC375

use Tabsize 2
for HC375 delete #define AMS

---------------------------------------------------------------

*/
// #define AMS  // define for AMS

/*-------------------Select one system  ----------------*/
//#define _SDC625_    // disable for 375
// this line is for the tokenizer


/* old version is macros.ddl */
#include "macros.h"
#include "methods.h"

//#include "src/unused.h"

/* Include Enum declaration */
#include "src/STRATOS_MULTI.h"
#include "src/STRATOS_MULTI_ENUM.h"
#include "src/STRATOS_MULTI_DEFAULTS.h"
#include "src/STRATOS_MULTI_TEXT.h"
//#include "src/STRATOS_MULTI_MARCO.h"

#include "src/STRATOS_MULTI_MENU.dd"
#include "src/STRATOS_MULTI_DEVVAR.dd"
#include "src/STRATOS_MULTI_COMMON.dd"
#include "src/STRATOS_MULTI_METHOD.dd"
#include "src/STRATOS_MULTI_IMAGES.dd"


/*------------------------------------------------------------------------------------*/

/* Import standard tables, or special PDM version */
// Fr die Gerteregistrierung darf keine Prprozessoranweisung um ein IMPORT herumgelegt werden.
IMPORT STANDARD _TABLES, DEVICE_REVISION 20, DD_REVISION 4
{
    //HART_DEVICE_TABLES;
    EVERYTHING;
    
    REDEFINITIONS
    {
        /* redefine for every device */
        
        /* The entire variable must be redefined since Device Type is defined as a two-byte */
        /* Enumerated and the Tokenizer will not allow the type to be redefined from size 2 to 1. */
        VARIABLE device_type
        {
            REDEFINE TYPE        ENUMERATED (2)
            {
                { 0x61CD, STR_DEVICE_TYPE_STRATOS }
            }
        }
        
        /* The entire variable must be redefined since Manufacturer ID is defined as a two-byte */
        /* Enumerated and the Tokenizer will not allow the type to be redefined from size 2 to 1. */
        VARIABLE manufacturer_id
        {
            REDEFINE TYPE        ENUMERATED (2)
            {
                { 0x0061, [Knick] }
            }
        }

        /* The entire variable must be redefined since Private Label is defined as a two-byte */
        /* Enumerated and the Tokenizer will not allow the type to be redefined from size 2 to 1. */
         VARIABLE private_label_distributor
        {
            REDEFINE TYPE        ENUMERATED (2)
            {
                { 0x0061, [Knick] }
            }
        }
            
        VARIABLE device_status
        {
            TYPE BIT_ENUMERATED
            {
                REDEFINE { 0x04, STR_PV_ANALOG_CHANNEL_SAT,      AO1 (AUTO & BAD) }
                REDEFINE { 0x08, STR_PV_ANALOG_CHANNEL_FIXED,    AO1 (MANUAL & GOOD) }
            }
            /* Eigentlich sollte die Methode noch aufgerufen werden, das ist aber fr die Registrierung
             * nicht erlaubt. Fr Variablen sieht die FCG keine REFRESHs vor, PDM hingegen kann diese
             * auswerten und ist an dieser Stelle toleranter. Wir mssen also darauf verzichten, die 
             * Methode sogte bei statisch geffnetem Fenster, dass im Hintergrund CMD_48 ausgefhrt wird. */
            /* Method_RefreshDeviceSpecificStatus */
        }

        VARIABLE extended_fld_device_status
        {
            TYPE BIT_ENUMERATED
            {
                ADD { 0x08, STR_FAILURE,                        MORE }
                ADD { 0x10, STR_OUT_OF_SPEC,                    MORE }
                ADD { 0x20, STR_FUNCTION_CHECK,                 MORE }
            }
        }

        VARIABLE standardized_status_0
        {
             TYPE BIT_ENUMERATED 
             {
                ADD { 0x80, STR_DEVICE_LOCKED, SOFTWARE }
             }
        }
    }// REDEFINITIONS
}//IMPORT STANDARD _TABLES



/* importing standard universal commands, or special PDM version */
// Fr die Gerteregistrierung darf keine Prprozessoranweisung um ein IMPORT herumgelegt werden.
IMPORT STANDARD _UNIVERSAL, DEVICE_REVISION 7, DD_REVISION 2
{
    EVERYTHING;

    REDEFINITIONS
    {
        VARIABLE response_preambles
        {	
            REDEFINE HANDLING READ & WRITE;
        }

        /* Verbesserung der Label, die std. Labels sehen oft nicht wirklich schn aus
         * Ein Redefine der LABEL aus dem Standard ist nicht fr die Registrierung zulssig
         * Auer fr den hestellerspezifischen Bereich des CMD_48 
         * VARIABLE config_change_counter              { REDEFINE LABEL STR_CONFIGURATION_CHANGED_COUNTER; } 
         */

        // Redefine Additional Status
        VARIABLE device_specific_status_0
        {
            REDEFINE LABEL      STR_ERROR_GENERAL;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_009_FIRMWARE,                         MISC },
                { 0x02, STR_ERROR_202_SYSTEM_FAILURE,                   MISC },
                { 0x04, STR_ERROR_000_INTERNAL,                         MISC },
                { 0x08, STR_ERROR_210_SELFTEST,                         MISC },
                { 0x10, STR_ERROR_230_FACTORY_DEFAULT,                  MISC },
                { 0x20, STR_ERROR_200_CONFIGURATION_DATA_LOSS,          MISC },
                { 0x40, STR_ERROR_203_INCONSISTENT_CONFIGURATION,       MISC },
                { 0x80, STR_ERROR_212_CLOCK,                            MISC }
            }
        }
        VARIABLE device_specific_status_1
        {
            REDEFINE LABEL      STR_ERROR_LOCKBOOK;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_190_RECORDER_FULL,                    MISC },
                { 0x02, STR_ERROR_215_STORAGE_FULL,                     MISC },
                { 0x04, STR_ERROR_211_STORAGE,                          MISC },
                { 0x08, STR_ERROR_216_AUDIT_TRAIL_STORAGE,              MISC },
                { 0x10, STR_ERROR_226_ENERGY,                           MISC }
            }
        }
        VARIABLE device_specific_status_2
        {
            REDEFINE LABEL      STR_ERROR_CURRENT_LOOP;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_074_LOOP_1_PARAMETER,                 MISC },
                { 0x02, STR_ERROR_079_LOOP_2_PARAMETER,                 MISC },
                { 0x04, STR_ERROR_084_LOOP_3_PARAMETER,                 MISC },
                { 0x08, STR_ERROR_089_LOOP_4_PARAMETER,                 MISC },
                { 0x10, STR_ERROR_070_LOOP_1_SPAN,                      MISC },
                { 0x20, STR_ERROR_075_LOOP_2_SPAN,                      MISC },
                { 0x40, STR_ERROR_080_LOOP_3_SPAN,                      MISC },
                { 0x80, STR_ERROR_085_LOOP_4_SPAN,                      MISC }
            }
        }

        // VARIABLE device_specific_status_3 (Reserved)

        VARIABLE device_specific_status_4
        {
            REDEFINE LABEL      STR_ERROR_SENSOR_1_AND_2;
            REDEFINE CLASS      DEVICE & DIAGNOSTIC & DYNAMIC;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_029_CH1_NO_SENSOR,                    MISC },
                { 0x02, STR_ERROR_030_CH1_WRONG_SENSOR,                 MISC },
                { 0x04, STR_ERROR_036_CH1_INVALID_SENSOR,               MISC },
                { 0x08, STR_ERROR_121_CH1_ERROR_SENSOR,                 MISC },
                { 0x10, STR_ERROR_050_CH1_MANUEL_RANGE,                 MISC },

                { 0x20, STR_ERROR_029_CH2_NO_SENSOR,                    MISC },
                { 0x40, STR_ERROR_030_CH2_WRONG_SENSOR,                 MISC },
                { 0x80, STR_ERROR_036_CH2_INVALID_SENSOR,               MISC }
            }
        }
        VARIABLE device_specific_status_5
        {
            REDEFINE LABEL      STR_ERROR_SENSOR_2_AND_3;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_121_CH2_ERROR_SENSOR,                 MISC },
                { 0x02, STR_ERROR_050_CH2_MANUEL_RANGE,                 MISC },

                { 0x04, STR_ERROR_029_CH3_NO_SENSOR,                    MISC },
                { 0x08, STR_ERROR_030_CH3_WRONG_SENSOR,                 MISC },
                { 0x10, STR_ERROR_036_CH3_INVALID_SENSOR,               MISC },
                { 0x20, STR_ERROR_121_CH3_ERROR_SENSOR,                 MISC },
                { 0x40, STR_ERROR_050_CH3_MANUEL_RANGE,                 MISC }
            }
        }

        VARIABLE device_specific_status_14
        {
            REDEFINE LABEL      STR_ERROR_CHANNEL_MESSAGES;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_008_CH1_ADJUSTMENT_DATA,              MISC },
                { 0x02, STR_ERROR_240_CH1_CALIBRATION_MODE,             MISC },
                { 0x04, STR_ERROR_122_CH1_CALIBRATION_DATA,             MISC },
                { 0x08, STR_ERROR_123_CH1_JUSTAGE_REQUIRED,             MISC },
                { 0x10, STR_ERROR_124_CH1_SENSOR_DATE,                  MISC },
                { 0x20, STR_ERROR_110_CH1_CIP_LIMIT,                    MISC },
                { 0x40, STR_ERROR_111_CH1_SIP_LIMIT,                    MISC },
                { 0x80, STR_ERROR_112_CH1_AUTOCLAVE_LIMIT,              MISC }
            }
        }
        
        VARIABLE device_specific_status_15
        {
            REDEFINE LABEL      STR_ERROR_SENSOR_SPECIFIC_MESSAGES;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                /* pH */
                { 0x01, STR_ERROR_073_CH1_TTM,                          MISC },
                { 0x02, STR_ERROR_090_CH1_BUFFER_DISTANCE,              MISC },
                /* Oxy */
                { 0x08, STR_ERROR_080_CH1_RANGE_SENSOR_CURRENT,         MISC },
                { 0x10, STR_ERROR_081_CH1_O2_MEASURING,                 MISC },
                /* Cond|Condi */
                { 0x20, STR_ERROR_045_CH1_RANGE_CONDUCTANCE,            MISC }
            }
        }
        
        VARIABLE device_specific_status_16
        {
            REDEFINE LABEL      STR_ERROR_CHANNEL_MESSAGES;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_008_CH2_ADJUSTMENT_DATA,              MISC },
                { 0x02, STR_ERROR_240_CH2_CALIBRATION_MODE,             MISC },
                { 0x04, STR_ERROR_122_CH2_CALIBRATION_DATA,             MISC },
                { 0x08, STR_ERROR_123_CH2_JUSTAGE_REQUIRED,             MISC },
                { 0x10, STR_ERROR_124_CH2_SENSOR_DATE,                  MISC },
                { 0x20, STR_ERROR_110_CH2_CIP_LIMIT,                    MISC },
                { 0x40, STR_ERROR_111_CH2_SIP_LIMIT,                    MISC },
                { 0x80, STR_ERROR_112_CH2_AUTOCLAVE_LIMIT,              MISC }
            }
        }

        VARIABLE device_specific_status_17
        {
            REDEFINE LABEL      STR_ERROR_SENSOR_SPECIFIC_MESSAGES;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                /* pH */
                { 0x01, STR_ERROR_073_CH2_TTM,                          MISC },
                { 0x02, STR_ERROR_090_CH2_BUFFER_DISTANCE,              MISC },
                /* Oxy */
                { 0x08, STR_ERROR_080_CH2_RANGE_SENSOR_CURRENT,         MISC },
                { 0x10, STR_ERROR_081_CH2_O2_MEASURING,                 MISC },
                /* Cond|Condi */
                { 0x20, STR_ERROR_045_CH2_RANGE_CONDUCTANCE,            MISC }
            }
        }
        
        VARIABLE device_specific_status_18
        {
            REDEFINE LABEL      STR_ERROR_CHANNEL_MESSAGES;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                { 0x01, STR_ERROR_008_CH3_ADJUSTMENT_DATA,              MISC },
                { 0x02, STR_ERROR_240_CH3_CALIBRATION_MODE,             MISC },
                { 0x04, STR_ERROR_122_CH3_CALIBRATION_DATA,             MISC },
                { 0x08, STR_ERROR_123_CH3_JUSTAGE_REQUIRED,             MISC },
                { 0x10, STR_ERROR_124_CH3_SENSOR_DATE,                  MISC },
                { 0x20, STR_ERROR_110_CH3_CIP_LIMIT,                    MISC },
                { 0x40, STR_ERROR_111_CH3_SIP_LIMIT,                    MISC },
                { 0x80, STR_ERROR_112_CH3_AUTOCLAVE_LIMIT,              MISC }
            }
        }
        
        VARIABLE device_specific_status_19
        {
            REDEFINE LABEL      STR_ERROR_SENSOR_SPECIFIC_MESSAGES;
            REDEFINE TYPE       BIT_ENUMERATED
            {
                /* pH */
                { 0x01, STR_ERROR_073_CH3_TTM,                          MISC },
                { 0x02, STR_ERROR_090_CH3_BUFFER_DISTANCE,              MISC },
                /* Oxy */
                { 0x08, STR_ERROR_080_CH3_RANGE_SENSOR_CURRENT,         MISC },
                { 0x10, STR_ERROR_081_CH3_O2_MEASURING,                 MISC },
                /* Cond|Condi */
                { 0x20, STR_ERROR_045_CH3_RANGE_CONDUCTANCE,            MISC }
            }
        }
    }  /* end of REDEFINITIONS */
} // IMPORT STANDARD _UNIVERSAL
/* END importing standard universal commands */


/*------------------------------------------------------------------------------------*/
/* Import standard common practice commands, or special PDM version */
IMPORT STANDARD _COMMON_PRACTICE, DEVICE_REVISION 9, DD_REVISION 2
{
#if 0
    EVERYTHING;
#else
    // Zu importierende Variablen
    VARIABLE primary_variable_code;				                                    // Variable aus dem Std. importieren
    VARIABLE secondary_variable_code;			                                    // Variable aus dem Std. importieren
    VARIABLE tertiary_variable_code;			                                    // Variable aus dem Std. importieren
    VARIABLE quaternary_variable_code;		                                        // Variable aus dem Std. importieren
    VARIABLE device_variable_code;                                                  // Variable aus dem Std. importieren
    VARIABLE analog_channel_number_code;							                // Variable aus dem Std. importieren -> for Command 60

    // Zu importierende Commands
    COMMAND read_device_variables;                                                  // Command 33
    COMMAND write_pv_damping_value;                                                 // Command 34
    COMMAND write_pv_range_values;                                                  // Command 35
    COMMAND set_pv_upper_range_value;                                               // Command 36
    COMMAND set_pv_lower_range_value;                                               // Command 37
    // COMMAND enter_exit_fixed_pv_current_mode;                                    // Command 40
    // COMMAND perform_self_test;                                                   // Command 41
    // COMMAND perform_device_reset                                                 // Command 42
    // COMMAND set_pv_zero;                                                         // Command 43
    // COMMAND write_pv_units;                                                      // Command 44
    // COMMAND trim_pv_current_dac_zero;                                            // Command 45
    // COMMAND trim_pv_current_dac_gain;                                            // Command 46
    // COMMAND write_pv_transfer_function;                                          // Command 47
    // COMMAND write_pv_sensor_serial_number;                                       // Command 49
    COMMAND read_device_variable_assignments;                                       // Command 50
    COMMAND write_device_variable_assignments;                                      // Command 51
    // COMMAND set_device_variable_zero;                                            // Command 52
    // COMMAND write_device_variable_units;                                         // Command 53
    COMMAND read_device_variable_information;                                       // Command 54
    // COMMAND write_device_variable_damping_value;                                 // Command 55
    // COMMAND write_device_variable_sensor_serial_number;                          // Command 56
    COMMAND write_number_of_response_preambles;                                     // Command 59
    // COMMAND read_analog_output_and_percent_of_range;                             // Command 60 --> Darf fr die Registrierung nur damm implementiert werden, wenn SV den Strom von I2 abbildet
    // COMMAND read_dynamic_variables_and_pv_analog_output;                         // Command 61
    // COMMAND read_analog_channels;                                                // Command 62
    // COMMAND read_analog_channel_information;                                     // Command 63 --> Darf fr die Registrierung nur damm implementiert werden, wenn SV den Strom von I2 abbildet
    // COMMAND write_analog_channel_additional_damping_value;                       // Command 64
    // COMMAND write_analog_channel_range_values;                                   // Command 65
    // COMMAND enter_exit_fixed_analog_channel_mode;                                // Command 66
    // COMMAND trim_analog_channel_zero;                                            // Command 67
    // COMMAND trim_analog_channel_gain;                                            // Command 68
    // COMMAND write_analog_channel_transfer_function;                              // Command 69
    // COMMAND read_analog_channel_endpoint_values;                                 // Command 70
    COMMAND lock_device;                                                            // Command 71
    COMMAND squawk;                                                                 // Command 72
    COMMAND findDevice;                                                             // Command 73
    // COMMAND read_io_system_capabilities;                                         // Command 74
    COMMAND read_lock_device_state;                                                 // Command 76
    COMMAND write_device_variable;                                                  // Command 79
    // COMMAND read_device_variable_trim_point;                                     // Command 80
    // COMMAND read_device_variable_trim_guidelines;                                // Command 81
    // COMMAND write_device_variable_trim_point;                                    // Command 82
    // COMMAND reset_device_variable_trim;                                          // Command 83
    // COMMAND set_real_time_clock;                                                 // Command 89
    // COMMAND read_real_time_clock;                                                // Command 90
    // COMMAND read_device_communication_statistics;                                // Command 95
    // COMMAND read_country_code;                                                   // Command 512
    // COMMAND write_country_code;                                                  // Command 513
    // ...

    METHOD lock_unlock_device;
#endif

    REDEFINITIONS 
    {
		VARIABLE primary_variable_code
        {
            REDEFINE CLASS          HART & DYNAMIC;
            REDEFINE TYPE           INDEX deviceVariablesForPv;
            DELETE   POST_EDIT_ACTIONS;

// Das EDD-Studio strzt ab, wenn das Attribut DEFAULT_VALUE im Redefine genutzt wird
#if (EDD_STUDIO != 1)
            REDEFINE DEFAULT_VALUE   0;
#endif
        }
		VARIABLE secondary_variable_code
        {
            REDEFINE CLASS          HART & DYNAMIC;
            DELETE   POST_EDIT_ACTIONS;

// Das EDD-Studio strzt ab, wenn das Attribut DEFAULT_VALUE im Redefine genutzt wird
#if (EDD_STUDIO != 1)
            REDEFINE DEFAULT_VALUE   1;
#endif
        }

		VARIABLE tertiary_variable_code
        {
            REDEFINE CLASS          HART & DYNAMIC;
            DELETE   POST_EDIT_ACTIONS;

// Das EDD-Studio strzt ab, wenn das Attribut DEFAULT_VALUE im Redefine genutzt wird
#if (EDD_STUDIO != 1)
            REDEFINE DEFAULT_VALUE   2;
#endif
        }

        VARIABLE quaternary_variable_code
        {
            REDEFINE CLASS          HART & DYNAMIC;
            DELETE   POST_EDIT_ACTIONS;

// Das EDD-Studio strzt ab, wenn das Attribut DEFAULT_VALUE im Redefine genutzt wird
#if (EDD_STUDIO != 1)
            REDEFINE DEFAULT_VALUE   3;
#endif
        }
    } // end of REDEFINITIONS

} //IMPORT STANDARD _COMMON_PRACTICE



/*------------------------------------------------------------------------------------*/
/* Import standard common practice commands, or special PDM version */
IMPORT STANDARD _PV, DEVICE_REVISION 1, DD_REVISION 1
{
    EVERYTHING;

    REDEFINITIONS
    {
        COLLECTION OF COLLECTION primary_variable
        {
            MEMBERS
            {
                REDEFINE DEVICE_VARIABLE,   deviceVariables[primary_variable_code];
            }
        }
        COLLECTION OF COLLECTION secondary_variable
        {
            MEMBERS
            {
                REDEFINE DEVICE_VARIABLE,   deviceVariables[secondary_variable_code];
            }
        }
        COLLECTION OF COLLECTION tertiary_variable
        {
            MEMBERS
            {
                REDEFINE DEVICE_VARIABLE,   deviceVariables[tertiary_variable_code];
            }
        }
        COLLECTION OF COLLECTION quaternary_variable
        {
            MEMBERS
            {
                REDEFINE DEVICE_VARIABLE,   deviceVariables[quaternary_variable_code];
            }
        }
        /*
         * Most devices use the same data item for range units (command 15) and the sensor units.
         * When this is true the following should be added. If tyour device uses a different variable
         * for range units you should reference it here.
         */

        COLLECTION OF VARIABLE scaling
        {
            MEMBERS
            {
                ADD RANGE_UNITS, deviceVariables[primary_variable_code].DIGITAL_UNITS, [range_units], [range_units_help];
            }
        }

        REDEFINE UNIT scaling_units_relation
        {
            deviceVariables[primary_variable_code].DIGITAL_UNITS: upperRange_value, lowerRange_value
        }
    }
}

/*--------------------------------------------------------------------------------------*/
/*
 * Used by the HART Communicator for two things
 *
 * The first is a write order list. If there are 4 variables
 * in the queue to be written and sensor_units was the third
 * item placed in the queue it will be the first variable
 * written when the send key is press because it is the first variable
 * in this list. If the variables in the queue are not in this list
 * they will be taken in the order of their ID's.
 *
 * Second this is the list of variables that the user will be
 * allowed to view and modify under the offline configure.
 * Any variable not in this list will not appear to the user
 * in offline configure.
 */
/* Variablen die durch offline Konfigurierung im Ger?t ge?ndert werden k?nnen */
/* Reihenfolge wie in menu_rev_config und menu_device_info */

/* End */

