/*
Filename:            STRATOS_MULTI_DEVVAR.dd
Function:            Device Description for .......
Device:              Stratos Multi
Device Revision:     1
DD Revision:         1
Last edit:           stz
Manufacturer:        KNICK GmbH & Co.,
                                 Beuckestr.22,
                                 D-14163 Berlin
                                 Tel: +49 (0) 30-80191-0,
                                 Fax: +49 (0) 30-80191-200
                                 Internet: http://www.knick.de
                                 email: knick@knick.de
Copyright:           (C) Knick GmbH & Co., 2019 All Rights Reserved.
*/


#define DEFALUT_TV_CLASSIFICATION            CLASSIFICATION_TEMP       // Class-Temperature
#define DEFALUT_QV_CLASSIFICATION            CLASSIFICATION_TEMP       // Class-Temperature


// Defaultwerte fr Upper Sensor Limit - DD Offline
#define DEFAULT_USL_TEMPERATURE              200.0    // C
#define DEFAULT_USL_PH                       99.99    // pH
#define DEFAULT_USL_ORP                      2000.0   // mV
#define DEFAULT_USL_MV                       600.0    // mV
#define DEFAULT_USL_RH                       42.1     // rH
#define DEFAULT_USL_GLS                      0.0      // Ohm
#define DEFAULT_USL_BZG                      0.0      // Ohm
#define DEFAULT_USL_CAL_PH_NPKT              0.0      // pH
#define DEFAULT_USL_CAL_PH_STEIL             0.0      // mV/pH
#define DEFAULT_USL_CAL_PH_APKT              0.0      // mV
#define DEFAULT_USL_CAL_ORP_OFFSET           0.0      // mV
#define DEFAULT_USL_SAT                      0.0      // 
#define DEFAULT_USL_SO2                      0.0      // 
#define DEFAULT_USL_MGL                      0.0      // 
#define DEFAULT_USL_VOL                      0.0      // 
#define DEFAULT_USL_CUR                      0.0      // 
#define DEFAULT_USL_PP                       0.0      // 
#define DEFAULT_USL_ITK                      0.0      // 
#define DEFAULT_USL_ILC                      0.0      // 
#define DEFAULT_USL_PL                       0.0      // 
#define DEFAULT_USL_SYS_PL                   0.0      // 
#define DEFAULT_USL_IMP                      0.0      // 
#define DEFAULT_USL_I_IN                     0.0      // 
#define DEFAULT_USL_LDO_I_IN                 0.0      //
#define DEFAULT_USL_CAL_OXY_NPKT             0.0      //
#define DEFAULT_USL_CAL_OXY_STEIL            0.0      //
#define DEFAULT_USL_CAL_OXY_STERN            0.0      //
#define DEFAULT_USL_CAL_OXY_PWINKEL          0.0      //
#define DEFAULT_USL_LF                       0.0      // 
#define DEFAULT_USL_SAL                      0.0      // 
#define DEFAULT_USL_KZ                       0.0      // 
#define DEFAULT_USL_RHO                      0.0      // 
#define DEFAULT_USL_USP                      0.0      // 
#define DEFAULT_USL_TDS                      0.0      // 
#define DEFAULT_USL_LW                       0.0      // 
#define DEFAULT_USL_WID                      0.0      // 
#define DEFAULT_USL_CAL_CC_ZELL              0.0      // 
#define DEFAULT_USL_CAL_CC_NPKT              0.0      //
#define DEFAULT_USL_SENSO_FACE               0.0      // 
#define DEFAULT_USL_CAL_TIMER                0.0      // 
#define DEFAULT_USL_RESTSTANDZEIT            0.0      // 
#define DEFAULT_USL_VERSCHLEISS              0.0      // 
#define DEFAULT_USL_BETRIEBSZEIT             0.0      // 
#define DEFAULT_USL_SIP_COUNT                0.0      //  
#define DEFAULT_USL_CIP_COUNT                0.0      // 
#define DEFAULT_USL_AUTO_KLAVIER_COUNT       0.0      // 
#define DEFAULT_USL_DLI                      0.0      // 
#define DEFAULT_USL_ACT                      0.0      // 
#define DEFAULT_USL_TTM                      0.0      // 
#define DEFAULT_USL_TEMPERATURE_DIF          0.0      // 
#define DEFAULT_USL_PH_DIF                   0.0      // 
#define DEFAULT_USL_MV_DIF                   0.0      // 
#define DEFAULT_USL_ORP_DIF                  0.0      // 
#define DEFAULT_USL_SAT_DIF                  0.0      // 
#define DEFAULT_USL_SO2_DIF                  0.0      // 
#define DEFAULT_USL_MGL_DIF                  0.0      // 
#define DEFAULT_USL_VOL_DIF                  0.0      // 
#define DEFAULT_USL_LF_DIF                   0.0      // 
#define DEFAULT_USL_RHO_DIF                  0.0      // 
#define DEFAULT_USL_RATIO                    0.0      // 
#define DEFAULT_USL_PASSAGE                  0.0      // 
#define DEFAULT_USL_REJECTION                0.0      // 
#define DEFAULT_USL_DEVIATION                0.0      // 
#define DEFAULT_USL_PPM                      0.0      // 
#define DEFAULT_USL_UMOLL                    0.0      // 
#define DEFAULT_USL_CC_PH                    0.0      // 
#define DEFAULT_USL_ELF                      0.0      // 
#define DEFAULT_USL_RCAP                     0.0      // 
#define DEFAULT_USL_RTIME                    0.0      //
#define DEFAULT_USL_FLOW                     0.0      //
#define DEFAULT_USL_RM_I_IN                  0.0      //



// Defaultwerte fr Lower Sensor Limit - DD Offline
#define DEFAULT_LSL_TEMPERATURE              -20.0    // C
#define DEFAULT_LSL_PH                       -99.0    // pH
#define DEFAULT_LSL_ORP                      -2000.0  // mV
#define DEFAULT_LSL_MV                       -600.0   // mV
#define DEFAULT_LSL_RH                       0.0      // rH
#define DEFAULT_LSL_GLS                      0.0      // Ohm
#define DEFAULT_LSL_BZG                      0.0      // Ohm
#define DEFAULT_LSL_CAL_PH_NPKT              0.0      // pH
#define DEFAULT_LSL_CAL_PH_STEIL             0.0      // mV/pH
#define DEFAULT_LSL_CAL_PH_APKT              0.0      // mV
#define DEFAULT_LSL_CAL_ORP_OFFSET           0.0      // mV
#define DEFAULT_LSL_SAT                      0.0      // 
#define DEFAULT_LSL_SO2                      0.0      // 
#define DEFAULT_LSL_MGL                      0.0      // 
#define DEFAULT_LSL_VOL                      0.0      // 
#define DEFAULT_LSL_CUR                      0.0      // 
#define DEFAULT_LSL_PP                       0.0      // 
#define DEFAULT_LSL_ITK                      0.0      // 
#define DEFAULT_LSL_ILC                      0.0      // 
#define DEFAULT_LSL_PL                       0.0      // 
#define DEFAULT_LSL_SYS_PL                   0.0      // 
#define DEFAULT_LSL_IMP                      0.0      // 
#define DEFAULT_LSL_I_IN                     0.0      // 
#define DEFAULT_LSL_LDO_I_IN                 0.0      //
#define DEFAULT_LSL_CAL_OXY_NPKT             0.0      //
#define DEFAULT_LSL_CAL_OXY_STEIL            0.0      //
#define DEFAULT_LSL_CAL_OXY_STERN            0.0      //
#define DEFAULT_LSL_CAL_OXY_PWINKEL          0.0      //
#define DEFAULT_LSL_LF                       0.0      // 
#define DEFAULT_LSL_SAL                      0.0      // 
#define DEFAULT_LSL_KZ                       0.0      // 
#define DEFAULT_LSL_RHO                      0.0      // 
#define DEFAULT_LSL_USP                      0.0      // 
#define DEFAULT_LSL_TDS                      0.0      // 
#define DEFAULT_LSL_LW                       0.0      // 
#define DEFAULT_LSL_WID                      0.0      // 
#define DEFAULT_LSL_CAL_CC_ZELL              0.0      // 
#define DEFAULT_LSL_CAL_CC_NPKT              0.0      //
#define DEFAULT_LSL_SENSO_FACE               0.0      // 
#define DEFAULT_LSL_CAL_TIMER                0.0      // 
#define DEFAULT_LSL_RESTSTANDZEIT            0.0      // 
#define DEFAULT_LSL_VERSCHLEISS              0.0      // 
#define DEFAULT_LSL_BETRIEBSZEIT             0.0      // 
#define DEFAULT_LSL_SIP_COUNT                0.0      // 
#define DEFAULT_LSL_CIP_COUNT                0.0      // 
#define DEFAULT_LSL_AUTO_KLAVIER_COUNT       0.0      // 
#define DEFAULT_LSL_DLI                      0.0      // 
#define DEFAULT_LSL_ACT                      0.0      // 
#define DEFAULT_LSL_TTM                      0.0      // 
#define DEFAULT_LSL_TEMPERATURE_DIF          0.0      // 
#define DEFAULT_LSL_PH_DIF                   0.0      // 
#define DEFAULT_LSL_MV_DIF                   0.0      // 
#define DEFAULT_LSL_ORP_DIF                  0.0      // 
#define DEFAULT_LSL_SAT_DIF                  0.0      // 
#define DEFAULT_LSL_SO2_DIF                  0.0      // 
#define DEFAULT_LSL_MGL_DIF                  0.0      // 
#define DEFAULT_LSL_VOL_DIF                  0.0      // 
#define DEFAULT_LSL_LF_DIF                   0.0      // 
#define DEFAULT_LSL_RHO_DIF                  0.0      // 
#define DEFAULT_LSL_RATIO                    0.0      // 
#define DEFAULT_LSL_PASSAGE                  0.0      // 
#define DEFAULT_LSL_REJECTION                0.0      // 
#define DEFAULT_LSL_DEVIATION                0.0      // 
#define DEFAULT_LSL_PPM                      0.0      // 
#define DEFAULT_LSL_UMOLL                    0.0      // 
#define DEFAULT_LSL_CC_PH                    0.0      //
#define DEFAULT_LSL_ELF                      0.0      // 
#define DEFAULT_LSL_RCAP                     0.0      // 
#define DEFAULT_LSL_RTIME                    0.0      //
#define DEFAULT_LSL_FLOW                     0.0      //
#define DEFAULT_LSL_RM_I_IN                  0.0      //


//#############################################################################
//###                          Einheiten Definitionen                       ###
//#############################################################################
// HART_SPEC 183, Rev 24.0, Kap. 5.2
// Temperaturen
#define HART_UNIT_DEG_C                                     32    // Degrees Celsius
#define HART_UNIT_DEF_F                                     33    // Degrees Fahrenheit
#define HART_UNIT_DEG_R                                     34    // Degrees Rankine
#define HART_UNIT_KELVIN                                    35    // Kelvin

// Drcke
#define HART_UNIT_MMHG                                      5     // millimeters of mercury at 0 C
#define HART_UNIT_PSI                                       6     // pounds per square inch
#define HART_UNIT_BAR                                       7     // bars
#define HART_UNIT_MBAR                                      8     // millibars
#define HART_UNIT_G_PER_CM2                                 9     // grams per square centimeter
#define HART_UNIT_KG_PER_CM2                                10    // kilograms per square centimeter
#define HART_UNIT_PA                                        11    // pascals
#define HART_UNIT_KPA                                       12    // KiloPascals

// Elektrisch
#define HART_UNIT_MV                                        36    // millivolts
#define HART_UNIT_V                                         58    // volts
#define HART_UNIT_MA                                        39    // milliamperes
#define HART_UNIT_OHM                                       37    // ohms
#define HART_UNIT_U_SIEM                                    56    // micro siemens
#define HART_UNIT_M_SIEM_PER_CM                             66    // milli siemens per centimeter
#define HART_UNIT_U_SIEM_PER_CM                             67    // micro siemens per centimeter
#define HART_UNIT_KOHM                                      163   // kiloohms

// Lngen
#define HART_UNIT_FT                                        44    // feet
#define HART_UNIT_M                                         45    // meter
#define HART_UNIT_IN                                        47    // inches
#define HART_UNIT_CM                                        48    // centimeter
#define HART_UNIT_MM                                        49    // millimeter

// Zeit
#define HART_UNIT_MIN                                       50    // minutes
#define HART_UNIT_S                                         51    // secounds
#define HART_UNIT_H                                         52    // hours
#define HART_UNIT_D                                         53    // days

// Masse
#define HART_UNIT_G                                         60    // gramms
#define HART_UNIT_KG                                        61    // kilogramms
#define HART_UNIT_T                                         62    // metric tons
#define HART_UNIT_LB                                        63    // pounds
#define HART_UNIT_TON                                       64    // short tons
#define HART_UNIT_TON_UK                                    65    // long tons
#define HART_UNIT_OZ                                        125   // ounce

// Volumen
#define HART_UNIT_GAL                                       40    // gallons 3,785412 * 10-3 m
#define HART_UNIT_L                                         41    // l
#define HART_UNIT_GAL_UK                                    42    // gallons 4,546092 * 10-3 m
#define HART_UNIT_M3                                        43    // m
#define HART_UNIT_ft3                                       112   // cubic feet

// Sonsiges
#define HART_UNIT_HERTZ                                     38    // hertz
#define HART_UNIT_PERCENT                                   57    // percent
#define HART_UNIT_PH                                        59    // potential of Hydrogen (acidity or alkalinity)
#define HART_UNIT_N                                         68    // Newton
#define HART_UNIT_KG_PER_L                                  96    // kilograms per liter
#define HART_UNIT_KW                                        127   // kilowatt
#define HART_UNIT_L_PER_H                                   138   // l/h
#define HART_UNIT_PPM                                       139   // parts per million
#define HART_UNIT_DEGREE                                    143   // 
#define HART_UNIT_UG_PER_L                                  146   // microgramms per liter
#define HART_UNIT_GEW_PERCENT_SOLIDS                        105   // gewicht percent - Feststoffe 
#define HART_UNIT_VOL_PERCENT_SOLIDS                        106   // volume percent - Feststoffe
#define HART_UNIT_VOL_PERCENT                               149   // volume/volume  [percent]
#define HART_UNIT_ML_PER_L                                  154   // milliliters per liter
#define HART_UNIT_UL_PER_L                                  155   // microliters per liter
#define HART_UNIT_PPB                                       169   // parts per billion



// Ab Code 170-219 fngt der Mulit-Definition Bereich an, welcher durch die Varaiablen-Klasse definiert wird
// Wenn wir diesen nutzen sind wir nicht mehr kompatibel mit HART_REV_5 Anlagen !!!
// Diese Festlegung wird erst ab der Protokollversion REVISION 6 untersttzt.
#define HART_UNITS_MULTI_DEFINES_START                      170   // Ab hier beginnen die Multi-defines
#define HART_UNITS_MULTI_DEFINES_END                        219   // Ab hier enden die Multi-defines

#define HART_UNITS_MULTI_USED_170                           170
#define HART_UNITS_MULTI_USED_171                           171
#define HART_UNITS_MULTI_USED_172                           172
#define HART_UNITS_MULTI_USED_173                           173
#define HART_UNITS_MULTI_USED_174                           174

#define HART_UNIT_EXT_HPA                                   174   // hectopascal

#define HART_UNIT_EXT_UM                                    170   // micrometer
#define HART_UNIT_EXT_UIN                                   171   // microinches
#define HART_UNIT_EXT_NM                                    172   // nanometer

#define HART_UNIT_EXT_MS                                    170   // milliseconds
#define HART_UNIT_EXT_US                                    171   // microseconds
#define HART_UNIT_EXT_NS                                    172   // nanoseconds

#define HART_UNIT_EXT_NA                                    170   // nanoamperes
#define HART_UNIT_EXT_UA                                    171   // microamperes
#define HART_UNIT_EXT_A                                     172   // amperes
#define HART_UNIT_EXT_MOHM                                  170   // mega ohm
#define HART_UNIT_EXT_OHM_X_CM                              171   // Ohm cm, kOhm cm, MOhm cm are volumetric
#define HART_UNIT_EXT_KOHM_X_CM                             172   // resistance. They are resistivity units that
#define HART_UNIT_EXT_MOHM_X_CM                             173   // cannot be directly converted to resistance.
#define HART_UNIT_EXT_MILLI_OHM                             174   // milli ohms

#define HART_UNIT_EXT_MG_PER_L                              170   // milligramm per liter

// Reserved - Sollten wenn mglich nicht benutzt werden
// HART_UNIT_NOT_USED --> Mss vorsichtig mit umgegangen werden,
// diese Einheit wird nur dann genutzt wenn es eine entsprechende
// Device Variable nicht gibt. Sie ist keine Einheit fr einheitenlose
// Messgren (Eigentlich zur Signalisierung):
// Keine Messgre: Float --> NaN + Unit --> HART_UNIT_NOT_USED + Class --> HART_CLASS_NOT_CLASSIFIED
#define HART_UNIT_NOT_USED                                  250   // Not Used
#define HART_UNIT_NONE                                      251   // None
#define HART_UNIT_UNKNOWN                                   252   // Unkown
#define HART_UNIT_SPECIAL                                   253   // Special

// Hersteller-spezifischer Bereich
#define HART_UNIT_KNICK_1_PPT_NANU                          240   // LIB_UNIT_PPT_NANU
#define HART_UNIT_KNICK_2_UMOL_PER_L                        241   // LIB_UNIT_UMOL_L
#define HART_UNIT_KNICK_3_RH                                242   // LIB_UNIT_RH
#define HART_UNIT_KNICK_4_MV_PER_PH                         243   // LIB_UNIT_MV_PH
#define HART_UNIT_KNICK_5_G_PER_KG                          244   // LIB_UNIT_G_KG
#define HART_UNIT_KNICK_6_ONE_PER_CM                        245   // LIB_UNIT_1_CM
#define HART_UNIT_KNICK_7                                   246   // To be used
#define HART_UNIT_KNICK_8                                   247   // To be used 
#define HART_UNIT_KNICK_9                                   248   // To be used
#define HART_UNIT_KNICK_10                                  249   // To be used

// Default Einheiten
#define DEFAULT_UNIT_TEMPERATURE                            HART_UNIT_DEG_C                  // C
#define DEFAULT_UNIT_PH                                     HART_UNIT_PH                     // pH
#define DEFAULT_UNIT_ORP                                    HART_UNIT_MV                     // mV
#define DEFAULT_UNIT_MV                                     HART_UNIT_MV                     // mV
#define DEFAULT_UNIT_RH                                     HART_UNIT_KNICK_3_RH             // 
#define DEFAULT_UNIT_GLS                                    HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_BZG                                    HART_UNIT_NONE                   //
#define DEFAULT_UNIT_CAL_PH_NPKT                            HART_UNIT_PH                     // pH
#define DEFAULT_UNIT_CAL_PH_STEIL                           HART_UNIT_KNICK_4_MV_PER_PH      // mV/pH
#define DEFAULT_UNIT_CAL_PH_APKT                            HART_UNIT_MV                     // mV
#define DEFAULT_UNIT_CAL_ORP_OFFSET                         HART_UNIT_MV                     // mV
#define DEFAULT_UNIT_SAT                                    HART_UNIT_PERCENT                // %
#define DEFAULT_UNIT_SO2                                    HART_UNIT_PERCENT                // %
#define DEFAULT_UNIT_MGL                                    HART_UNIT_EXT_MG_PER_L           // Ext - mgl
#define DEFAULT_UNIT_VOL                                    HART_UNIT_VOL_PERCENT            // 
#define DEFAULT_UNIT_CUR                                    HART_UNIT_MA                     // mA
#define DEFAULT_UNIT_PP                                     HART_UNIT_MBAR                   // mbar
#define DEFAULT_UNIT_ITK                                    HART_UNIT_MA                     // 
#define DEFAULT_UNIT_ILC                                    HART_UNIT_MA                     // 
#define DEFAULT_UNIT_SYS_PL                                 HART_UNIT_MBAR                   // mbar
#define DEFAULT_UNIT_IMP                                    HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_I_IN                                   HART_UNIT_MA                     // mA
#define DEFAULT_UNIT_LDO_I_IN                               HART_UNIT_MA                     // mA 
#define DEFAULT_UNIT_CAL_OXY_NPKT                           HART_UNIT_EXT_NA                 // nA 
#define DEFAULT_UNIT_CAL_OXY_STEIL                          HART_UNIT_EXT_NA                 // nA 
#define DEFAULT_UNIT_CAL_OXY_STERN                          HART_UNIT_NONE                   // None 
#define DEFAULT_UNIT_CAL_OXY_PWINKEL                        HART_UNIT_DEGREE                 //  
#define DEFAULT_UNIT_LF                                     HART_UNIT_U_SIEM_PER_CM          // 
#define DEFAULT_UNIT_SAL                                    HART_UNIT_KNICK_5_G_PER_KG       // 
#define DEFAULT_UNIT_KZ                                     HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_RHO                                    HART_UNIT_EXT_MOHM_X_CM          // 
#define DEFAULT_UNIT_USP                                    HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_TDS                                    HART_UNIT_EXT_MG_PER_L           // 
#define DEFAULT_UNIT_LW                                     HART_UNIT_U_SIEM                 // 
#define DEFAULT_UNIT_WID                                    HART_UNIT_OHM                    // Ohm
#define DEFAULT_UNIT_CAL_CC_ZELL                            HART_UNIT_KNICK_6_ONE_PER_CM     // 1/sec
#define DEFAULT_UNIT_CAL_CC_NPKT                            HART_UNIT_U_SIEM                 // S
#define DEFAULT_UNIT_SENSO_FACE                             HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_CAL_TIMER                              HART_UNIT_H                      // 
#define DEFAULT_UNIT_RESTSTANDZEIT                          HART_UNIT_H                      // 
#define DEFAULT_UNIT_VERSCHLEISS                            HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_BETRIEBSZEIT                           HART_UNIT_H                      // 
#define DEFAULT_UNIT_SIP_COUNT                              HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_CIP_COUNT                              HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_AUTO_KLAVIER_COUNT                     HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_DLI                                    HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_ACT                                    HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_TTM                                    HART_UNIT_H                      //
#define DEFAULT_UNIT_TEMPERATURE_DIF                        HART_UNIT_DEG_C                  // C
#define DEFAULT_UNIT_PH_DIF                                 HART_UNIT_PH                     // pH
#define DEFAULT_UNIT_MV_DIF                                 HART_UNIT_MV                     // mV
#define DEFAULT_UNIT_ORP_DIF                                HART_UNIT_MV                     // mV
#define DEFAULT_UNIT_SAT_DIF                                HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_SO2_DIF                                HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_MGL_DIF                                HART_UNIT_EXT_MG_PER_L           // 
#define DEFAULT_UNIT_VOL_DIF                                HART_UNIT_VOL_PERCENT            // 
#define DEFAULT_UNIT_LF_DIF                                 HART_UNIT_U_SIEM_PER_CM          // 
#define DEFAULT_UNIT_RHO_DIF                                HART_UNIT_EXT_MOHM_X_CM          // 
#define DEFAULT_UNIT_RATIO                                  HART_UNIT_NONE                   // 
#define DEFAULT_UNIT_PASSAGE                                HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_REJECTION                              HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_DEVIATION                              HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_PPM                                    HART_UNIT_PPM                    // 
#define DEFAULT_UNIT_UMOLL                                  HART_UNIT_KNICK_2_UMOL_PER_L     //
#define DEFAULT_UNIT_CC_PH                                  HART_UNIT_PH                     // pH
#define DEFAULT_UNIT_ELF                                    HART_UNIT_U_SIEM_PER_CM          // 
#define DEFAULT_UNIT_RCAP                                   HART_UNIT_PERCENT                // 
#define DEFAULT_UNIT_RTIME                                  HART_UNIT_H                      //
#define DEFAULT_UNIT_FLOW                                   HART_UNIT_L_PER_H                //
#define DEFAULT_UNIT_RM_I_IN                                HART_UNIT_MA                     // mA


//#############################################################################
//###           Definition Classification von Device Variablen              ###
//#############################################################################
#define HART_CLASS_NOT_CLASSIFIED                           0
#define HART_CLASS_TEMPERATURE                              64
#define HART_CLASS_PRESSURE                                 65
#define HART_CLASS_VOLUMETRIC_FLOW                          66
#define HART_CLASS_VELOCITY                                 67
#define HART_CLASS_VOLUME                                   68
#define HART_CLASS_LENGTH                                   69
#define HART_CLASS_TIME                                     70
#define HART_CLASS_MASS                                     71
#define HART_CLASS_MASS_FLOW                                72
#define HART_CLASS_MASS_PER_VOLUME                          73
#define HART_CLASS_VISCOSITY                                74
#define HART_CLASS_ANGULAR_VELOCITY                         75
#define HART_CLASS_AREA                                     76
#define HART_CLASS_ENERGY                                   77
#define HART_CLASS_FORCE                                    78
#define HART_CLASS_POWER                                    79
#define HART_CLASS_FREQUENCY                                80
#define HART_CLASS_ANALYTICAL                               81
#define HART_CLASS_CAPACITANCE                              82
#define HART_CLASS_ELECTRONIC_POTENTIAL                     83
#define HART_CLASS_CURRENT                                  84
#define HART_CLASS_RESISTANCE                               85
#define HART_CLASS_ANGLE                                    86
#define HART_CLASS_CONDUCTANCE                              87
#define HART_CLASS_VOLUME_PER_VOLUME                        88
#define HART_CLASS_VOLUME_PER_MASS                          89
#define HART_CLASS_CONCENTRATION                            90
#define HART_CLASS_ACCELERATION                             96
#define HART_CLASS_TURBIDITY                                97
#define HART_CLASS_TEMPERATURE_DIFFERENCE                   98
#define HART_CLASS_THERMAL_EXPANSION                        107
#define HART_CLASS_VOLUMETRIC_ENERGY_DENSITY                108
#define HART_CLASS_MASS_ENERGY_DENSITY                      109
#define HART_CLASS_TORQUE                                   110
#define HART_CLASS_MISCELLANEOUS                            111

// Class-Declaration
#define CLASSIFICATION_TEMPERATURE           HART_CLASS_TEMPERATURE
#define CLASSIFICATION_PH                    HART_CLASS_ANALYTICAL
#define CLASSIFICATION_ORP                   HART_CLASS_ELECTRONIC_POTENTIAL
#define CLASSIFICATION_MV                    HART_CLASS_ELECTRONIC_POTENTIAL
#define CLASSIFICATION_RH                    HART_CLASS_ANALYTICAL
#define CLASSIFICATION_GLS                   HART_CLASS_RESISTANCE
#define CLASSIFICATION_BZG                   HART_CLASS_RESISTANCE
#define CLASSIFICATION_CAL_PH_NPKT           HART_CLASS_ANALYTICAL
#define CLASSIFICATION_CAL_PH_STEIL          HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_CAL_PH_APKT           HART_CLASS_ELECTRONIC_POTENTIAL
#define CLASSIFICATION_CAL_ORP_OFFSET        HART_CLASS_ELECTRONIC_POTENTIAL
#define CLASSIFICATION_SAT                   HART_CLASS_ANALYTICAL
#define CLASSIFICATION_SO2                   HART_CLASS_ANALYTICAL
#define CLASSIFICATION_MGL                   HART_CLASS_CONCENTRATION
#define CLASSIFICATION_VOL                   HART_CLASS_CONCENTRATION
#define CLASSIFICATION_CUR                   HART_CLASS_CURRENT
#define CLASSIFICATION_PP                    HART_CLASS_PRESSURE
#define CLASSIFICATION_ITK                   HART_CLASS_CURRENT
#define CLASSIFICATION_SYS_PL                HART_CLASS_PRESSURE
#define CLASSIFICATION_IMP                   HART_CLASS_RESISTANCE
#define CLASSIFICATION_I_IN                  HART_CLASS_CURRENT
#define CLASSIFICATION_LDO_I_IN              HART_CLASS_CURRENT
#define CLASSIFICATION_CAL_OXY_NPKT          HART_CLASS_CURRENT
#define CLASSIFICATION_CAL_OXY_STEIL         HART_CLASS_CURRENT
#define CLASSIFICATION_CAL_OXY_STERN         HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_CAL_OXY_PWINKEL       HART_CLASS_ANGLE
#define CLASSIFICATION_LF                    HART_CLASS_CONDUCTANCE
#define CLASSIFICATION_SAL                   HART_CLASS_CONCENTRATION
#define CLASSIFICATION_KZ                    HART_CLASS_CONCENTRATION
#define CLASSIFICATION_RHO                   HART_CLASS_RESISTANCE
#define CLASSIFICATION_USP                   HART_CLASS_CONDUCTANCE
#define CLASSIFICATION_TDS                   HART_CLASS_MASS_PER_VOLUME
#define CLASSIFICATION_LW                    HART_CLASS_CONDUCTANCE
#define CLASSIFICATION_WID                   HART_CLASS_RESISTANCE
#define CLASSIFICATION_CAL_CC_ZELL           HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_CAL_CC_NPKT           HART_CLASS_CONDUCTANCE
#define CLASSIFICATION_SENSO_FACE            HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_CAL_TIMER             HART_CLASS_TIME
#define CLASSIFICATION_RESTSTANDZEIT         HART_CLASS_TIME
#define CLASSIFICATION_VERSCHLEISS           HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_BETRIEBSZEIT          HART_CLASS_TIME
#define CLASSIFICATION_SIP_COUNT             HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_CIP_COUNT             HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_AUTO_KLAVIER_COUNT    HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_DLI                   HART_CLASS_MISCELLANEOUS
#define CLASSIFICATION_ACT                   HART_CLASS_MISCELLANEOUS
#define CLASSIFICATION_TTM                   HART_CLASS_TIME
#define CLASSIFICATION_TEMPERATURE_DIF       HART_CLASS_TEMPERATURE
#define CLASSIFICATION_PH_DIF                HART_CLASS_ANALYTICAL
#define CLASSIFICATION_MV_DIF                HART_CLASS_ELECTRONIC_POTENTIAL
#define CLASSIFICATION_ORP_DIF               HART_CLASS_ELECTRONIC_POTENTIAL
#define CLASSIFICATION_SAT_DIF               HART_CLASS_ANALYTICAL
#define CLASSIFICATION_SO2_DIF               HART_CLASS_ANALYTICAL
#define CLASSIFICATION_MGL_DIF               HART_CLASS_CONCENTRATION
#define CLASSIFICATION_VOL_DIF               HART_CLASS_CONCENTRATION
#define CLASSIFICATION_LF_DIF                HART_CLASS_CONDUCTANCE
#define CLASSIFICATION_RHO_DIF               HART_CLASS_RESISTANCE
#define CLASSIFICATION_RATIO                 HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_PASSAGE               HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_REJECTION             HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_DEVIATION             HART_CLASS_NOT_CLASSIFIED
#define CLASSIFICATION_PPM                   HART_CLASS_CONCENTRATION
#define CLASSIFICATION_UMOLL                 HART_CLASS_CONCENTRATION
#define CLASSIFICATION_CC_PH                 HART_CLASS_ANALYTICAL
#define CLASSIFICATION_ELF                   HART_CLASS_CONDUCTANCE
#define CLASSIFICATION_RCAP                  HART_CLASS_MISCELLANEOUS
#define CLASSIFICATION_RTIME                 HART_CLASS_TIME
#define CLASSIFICATION_FLOW                  HART_CLASS_VOLUMETRIC_FLOW
#define CLASSIFICATION_RM_I_IN               HART_CLASS_CURRENT

// Deivce Family
#define DEVICE_FAMILY_NOT_USED               250

