
//-------------------------------------------------------------------------------------------------
// Structure of this file:
//-------------------------------------------------------------------------------------------------
//    Macros
//		Configuration
//    Up-/Download List
//		BLOCK
//    VARIABLE (Standard Parameter)
//    VARIABLE (TB ANALYSER Parameter)
//    UNIT
//    COMMAND (Standard Parameter)
//    COMMAND (DO Parameter)
//		METHOD
//		MENU (Output)
//    MENU (Diagnosis)
//    MENU (Parameter Table)

//-------------------------------------------------------------------------------------------------
//    Macros
//-------------------------------------------------------------------------------------------------

#define DEF_DISPLAY_FORMAT_TRANS4(value)						\
        IF( (value > 999999999) || (value < -999999999) )	\
        {																	\
            SELECT(TRANS4_DECIMAL_POINT_REFERENCE)				\
            {																\
                CASE 0:		".1g";									\
                CASE 1:		".2g";									\
                CASE 2:		".3g";									\
                CASE 3:		".4g";									\
                CASE 4:		".5g";									\
                CASE 5:		".6g";									\
                CASE 6:		".7g";									\
                CASE 7:		".8g";									\
                DEFAULT:	  "8.4g"; 									\
            }																\
        }																	\
        ELSE																\
        {																	\
            SELECT(TRANS4_DECIMAL_POINT_REFERENCE)				\
            {																\
                CASE 0:		".0f";									\
                CASE 1:		".1f";									\
                CASE 2:		".2f";									\
                CASE 3:		".3f";									\
                CASE 4:		".4f";									\
                CASE 5:		".5f";									\
                CASE 6:		".6f";									\
                CASE 7:		".7f";									\
                DEFAULT:	  "7.4f";									\
            }																\
        }

//-------------------------------------------------------------------------------------------------
//    Configuration
//-------------------------------------------------------------------------------------------------

#ifndef TRANS4_TITLE
    #define TRANS4_TITLE [trans4_analysis]
#endif

#ifndef TRANS4_BLOCKNUMBER
    #define TRANS4_BLOCKNUMBER			1
#endif


//-------------------------------------------------------------------------------------------------
//    Up-/Download List
//-------------------------------------------------------------------------------------------------

#define TRANS4_LOAD_TO_DEVICE										\
                trans4_tag_desc,									\
                trans4_analysis_component_name,						\
                trans4_analysis_unit,								\
                trans4_analysis_lower_range_value_1,				\
                trans4_analysis_upper_range_value_1


#define TRANS4_LOAD_TO_PC											\
                TRANS4_LOAD_TO_DEVICE								\
                trans4_st_rev,										\
                trans4_meas_info_module_adr,						\
                trans4_meas_info_ofs_module_tab						\
                trans4_analysis_sensor_id_name,						\
                trans4_analysis_sensor_id_ser_num


//-------------------------------------------------------------------------------------------------
//		BLOCK
//-------------------------------------------------------------------------------------------------

BLOCK trans4_analysis_block
{
    TYPE		TRANSDUCER;
    NUMBER	TRANS4_BLOCKNUMBER;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- TB 00 : BLOCK_OBJECT ------------------------------------------------------------------------

trans4_blk_reserve					LIKE VARIABLE	phys_blk_reserve
{
}


trans4_blk_object						LIKE VARIABLE	phys_blk_object
{
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    3;
        {	3,	[blk_block_object_TRANSDUCER]		}
    }
}


trans4_blk_parent_class				LIKE VARIABLE	phys_blk_parent_class
{
    REDEFINE HELP		[trans_blk_parent_class_help];
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    7;
        {	7,	[trans_blk_parent_class_ANALYSIS]	}
    }
}


trans4_blk_class						LIKE VARIABLE	phys_blk_class
{
    REDEFINE HELP		[trans_blk_class_help];
    REDEFINE TYPE		ENUMERATED(1)
    {
        DEFAULT_VALUE    1;
        {	1,	[standard]	}
    }
}


trans4_blk_dd_reference				LIKE VARIABLE	phys_blk_dd_reference
{
}


trans4_blk_dd_rev						LIKE VARIABLE	phys_blk_dd_rev
{
}


trans4_blk_profile					LIKE VARIABLE	phys_blk_profile
{
}


trans4_blk_profile_rev				LIKE VARIABLE	phys_blk_profile_rev
{
}


trans4_blk_execution_time			LIKE VARIABLE	phys_blk_execution_time
{
}


trans4_blk_num_parameters			LIKE VARIABLE	phys_blk_num_parameters
{
}


trans4_blk_index_view_1				LIKE VARIABLE	phys_blk_index_view_1
{
}


trans4_blk_num_view_lists			LIKE VARIABLE	phys_blk_num_view_lists
{
}


//--- TB 01 : ST_REV ------------------------------------------------------------------------------

trans4_st_rev							LIKE VARIABLE	phys_st_rev
{
}


//--- TB 02 : TAG_DESC ----------------------------------------------------------------------------

trans4_tag_desc						LIKE VARIABLE	phys_tag_desc
{
}


//--- TB 03 : STRATEGY ----------------------------------------------------------------------------

trans4_strategy						LIKE VARIABLE	phys_strategy
{
}


//--- TB 04 : ALERT_KEY ---------------------------------------------------------------------------

trans4_alert_key						LIKE VARIABLE	phys_alert_key
{
}


//--- TB 05 : TARGET_MODE -------------------------------------------------------------------------

trans4_target_mode					LIKE VARIABLE	phys_target_mode
{
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	BLOCK_MODE_AUTO,					[mode_AUTO]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,		[mode_OUT_OF_SERVICE]	}
    }
}


//--- TB 06 : MODE_BLK ----------------------------------------------------------------------------

trans4_actual_mode							LIKE VARIABLE	phys_actual_mode
{
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {	BLOCK_MODE_AUTO,					[mode_AUTO]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,		[mode_OUT_OF_SERVICE]	}
    }
}


trans4_permitted_mode						LIKE VARIABLE	phys_permitted_mode
{
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    0x88;
        {	BLOCK_MODE_AUTO,					[mode_AUTO]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,		[mode_OUT_OF_SERVICE]	}
    }
}


trans4_normal_mode							LIKE VARIABLE	phys_normal_mode
{
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE    BLOCK_MODE_AUTO;
        {	BLOCK_MODE_AUTO,					[mode_AUTO]					}
    }
}


//--- TB 07 : ALARM_SUM ---------------------------------------------------------------------------

trans4_current_state_alarm_sum			LIKE VARIABLE	func1_AI_current_state_alarm_sum
{
}


trans4_unacknowledged_state_alarm_sum	LIKE VARIABLE	func1_AI_unacknowledged_state_alarm_sum
{
}


trans4_unreported_state_alarm_sum		LIKE VARIABLE	func1_AI_unreported_state_alarm_sum
{
}


trans4_disabled_state_alarm_sum			LIKE VARIABLE	func1_AI_disabled_state_alarm_sum
{
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (TB ANALYSER Parameter)
//-------------------------------------------------------------------------------------------------

//--- TB AN 08 : COMPONENT_NAME -------------------------------------------------------------------

VARIABLE trans4_analysis_component_name
{
    LABEL		[trans_analysis_component_name];
    HELP		[trans_analysis_component_name_help];
    CLASS		CONTAINED;
    TYPE		ASCII (32)
    {
        DEFAULT_VALUE "";
    }
    HANDLING	READ & WRITE;
}


//--- TB AN 09 : PV -------------------------------------------------------------------------------

VARIABLE trans4_primary_value
{
    LABEL		[trans_value];
    HELP		[trans_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_TRANS4(trans4_primary_value);
    }
    HANDLING	READ;
}


VARIABLE trans4_primary_value_status_quality
{
    LABEL		[status_quality];
    HELP		[value_status_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING	READ;
}


trans4_primary_value_status_limit			LIKE VARIABLE	trans4_primary_value_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}


VARIABLE trans4_primary_value_time_instant
{
    LABEL		[trans_analysis_primary_value_time_instant];
    HELP		[trans_analysis_primary_value_time_instant_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ASCII(7);
    HANDLING	READ;
}


//--- TB AN 10 : PV_UNIT --------------------------------------------------------------------------

VARIABLE trans4_analysis_unit
{
    LABEL		[trans_analysis_unit];
    HELP		[trans_analysis_unit_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (2)
    {

#ifdef TRANS4_DEVICE_SPECIFIC_UNIT_LIST
    TRANS4_DEVICE_SPECIFIC_UNIT_LIST
#else
        UNIT_LIST_ANALYSIS_UNIT
#endif
    }
//	HANDLING	READ & WRITE;
    HANDLING	READ;
}


//--- TB AN 11 : PV_UNIT_TEXT ---------------------------------------------------------------------

VARIABLE trans4_analysis_unit_text
{
    LABEL		[trans_analysis_unit_text];
    HELP		[trans_analysis_unit_text_help];
    CLASS		CONTAINED;
    TYPE		ASCII (8)
    {
        DEFAULT_VALUE "";
    }
    HANDLING	READ & WRITE;
}


//--- TB AN 12 : ACTIVE_RANGE ---------------------------------------------------------------------

VARIABLE trans4_analysis_active_range
{
    LABEL		[trans_analysis_active_range];
    HELP		[trans_analysis_active_range_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE 1;
        { 1,	"1",	"1" }
    }
    HANDLING	READ & WRITE;
}


//--- TB AN 13 : AUTORANGE_ON ---------------------------------------------------------------------

VARIABLE trans4_analysis_autorange_on
{
    LABEL		[trans_analysis_autorange_on];
    HELP		[trans_analysis_autorange_on_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE 0;
        {	0,	[off]	},
        {	1,	[on]	}
    }
    HANDLING	READ & WRITE;
}


//--- TB AN 14 : SAMPLING_RATE --------------------------------------------------------------------

VARIABLE trans4_analysis_sampling_rate
{
    LABEL		[trans_analysis_sampling_rate];
    HELP		[trans_analysis_sampling_rate_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER(4)
    {
        DEFAULT_VALUE 1000 ;
#ifdef  TRANS4_ANALYSIS_SAMPLING_RATE_MIN_VALUE
        MIN_VALUE TRANS4_ANALYSIS_SAMPLING_RATE_MIN_VALUE ;
#endif
#ifdef  TRANS4_ANALYSIS_SAMPLING_RATE_MAX_VALUE
        MAX_VALUE TRANS4_ANALYSIS_SAMPLING_RATE_MAX_VALUE ;
#endif
    }
    HANDLING	READ & WRITE;
    CONSTANT_UNIT "ms" ;
}


//--- TB AN 25 : NUMBER_OF_RANGES -----------------------------------------------------------------

VARIABLE trans4_analysis_number_of_ranges
{
    LABEL		[trans_number_of_ranges];
    HELP		[trans_number_of_ranges_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE	1;
    }
    HANDLING	READ;
}


//--- TB AN 26 : RANGE_1 --------------------------------------------------------------------------

VARIABLE trans4_analysis_lower_range_value_1
{
    LABEL		[trans_lower_range_value];
    HELP		[trans_lower_range_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_trans4_analysis_lower_range_value_1;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_TRANS4(trans4_analysis_lower_range_value_1);
    }
    HANDLING	READ;
}


VARIABLE trans4_analysis_upper_range_value_1
{
    LABEL		[trans_upper_range_value];
    HELP		[trans_upper_range_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_trans4_analysis_upper_range_value_1;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_TRANS4(trans4_analysis_upper_range_value_1);
    }
    HANDLING	READ;
}


//--- TB AN 27 : MEAS_INFO ---- (Man spec) --------------------------------------------------------

VARIABLE trans4_meas_info_module_adr
{
    LABEL		[trans_meas_info_module_adr];
    HELP		[trans_meas_info_module_adr_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        CONFIGURATION_BASED_MODULE_LIST			/* muss bleiben */
    }
    HANDLING	READ;
}


VARIABLE trans4_meas_info_ofs_module_tab
{
    LABEL		[trans_meas_info_ofs_module_tab];
    HELP		[trans_meas_info_ofs_module_tab_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        CONFIGURATION_BASED_PROCESS_VALUE_LIST	/* muss bleiben */
    }
    HANDLING	READ;
}


VARIABLE trans4_analysis_meas_info
{
    LABEL		"MEAS_INFO";
    CLASS		CONTAINED;
    TYPE		ASCII (7)
    {
        DEFAULT_VALUE "";
    }
    HANDLING	READ;
}


//--- TB AN 28 : SENSOR_ID ---- (Man spec) --------------------------------------------------------

VARIABLE trans4_analysis_sensor_id_name
{
   LABEL         [sensor_id_name];
   HELP          [sensor_id_name];
   CLASS         CONTAINED & DYNAMIC;
   TYPE          ASCII(10);
   HANDLING      READ;
}


VARIABLE trans4_analysis_sensor_id_ser_num
{
   LABEL         [sensor_id_ser_num];
   HELP          [sensor_id_ser_num];
   CLASS         CONTAINED & DYNAMIC;
   TYPE          ASCII(10);
   HANDLING      READ;
}


//-------------------------------------------------------------------------------------------------
//    UNIT
//-------------------------------------------------------------------------------------------------

UNIT trans4_unit_relation
{
    trans4_analysis_unit:
    trans4_analysis_upper_range_value_1,
    trans4_analysis_lower_range_value_1,
    trans4_primary_value
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- TB 00 : BLOCK_OBJECT ------------------------------------------------------------------------

COMMAND read_trans4_blk
{
    BLOCK trans4_analysis_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_blk_reserve,
            trans4_blk_object,
            trans4_blk_parent_class,
            trans4_blk_class,
            trans4_blk_dd_reference,
            trans4_blk_dd_rev,
            trans4_blk_profile,
            trans4_blk_profile_rev,
            trans4_blk_execution_time,
            trans4_blk_num_parameters,
            trans4_blk_index_view_1,
            trans4_blk_num_view_lists
        }
    }
}


//--- TB 01 : ST_REV ------------------------------------------------------------------------------

COMMAND read_trans4_st_rev
{
    BLOCK trans4_analysis_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_st_rev
        }
    }
}


//--- TB 02 : TAG_DESC ----------------------------------------------------------------------------

COMMAND read_trans4_tag_desc
{
    BLOCK trans4_analysis_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_tag_desc
        }
    }
}


COMMAND write_trans4_tag_desc
{
    BLOCK trans4_analysis_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_tag_desc
        }
        REPLY
        {
        }
    }
}


//--- TB 03 : STRATEGY ----------------------------------------------------------------------------

COMMAND read_trans4_strategy
{
    BLOCK trans4_analysis_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_strategy
        }
    }
}


COMMAND write_trans4_strategy
{
    BLOCK trans4_analysis_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_strategy
        }
        REPLY
        {
        }
    }
}


//--- TB 04 : ALERT_KEY ---------------------------------------------------------------------------

COMMAND read_trans4_alert_key
{
    BLOCK trans4_analysis_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_alert_key
        }
    }
}


COMMAND write_trans4_alert_key
{
    BLOCK trans4_analysis_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_alert_key
        }
        REPLY
        {
        }
    }
}


//--- TB 05 : TARGET_MODE -------------------------------------------------------------------------

COMMAND read_trans4_target_mode
{
    BLOCK trans4_analysis_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_target_mode
        }
    }
}


COMMAND write_trans4_target_mode
{
    BLOCK trans4_analysis_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_target_mode
        }
        REPLY
        {
        }
    }
}


//--- TB 06 : MODE_BLK ----------------------------------------------------------------------------

COMMAND read_trans4_mode
{
    BLOCK trans4_analysis_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             trans4_actual_mode,
             trans4_permitted_mode,
             trans4_normal_mode
        }
    }
}


//--- TB 07 : ALARM_SUM ---------------------------------------------------------------------------

COMMAND read_trans4_alarm
{
    BLOCK trans4_analysis_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_current_state_alarm_sum,
            trans4_unacknowledged_state_alarm_sum,
            trans4_unreported_state_alarm_sum,
            trans4_disabled_state_alarm_sum
        }
    }
}


//--- TB AN 08 : COMPONENT_NAME -------------------------------------------------------------------

COMMAND read_trans4_analysis_component_name
{
    BLOCK trans4_analysis_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_component_name
        }
    }
}


COMMAND write_trans4_analysis_component_name
{
    BLOCK trans4_analysis_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_analysis_component_name
        }
        REPLY
        {
        }
    }
}


//--- TB AN 09 : PV -------------------------------------------------------------------------------

COMMAND read_trans4_primary_value
{
    BLOCK trans4_analysis_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_primary_value,
            trans4_primary_value_status_quality	<0xFC>,
            trans4_primary_value_status_limit	<0x03>,
            trans4_primary_value_time_instant
        }
    }
}


//--- TB AN 10 : PV_UNIT --------------------------------------------------------------------------

COMMAND read_trans4_analysis_unit
{
    BLOCK trans4_analysis_block;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_unit
        }
    }
}


COMMAND write_trans4_analysis_unit
{
    BLOCK trans4_analysis_block;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_analysis_unit
        }
        REPLY
        {
        }
    }
}


//--- TB AN 11 : PV_UNIT_TEXT ---------------------------------------------------------------------

COMMAND read_trans4_analysis_unit_text
{
    BLOCK trans4_analysis_block;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_unit_text
        }
    }
}


COMMAND write_trans4_analysis_unit_text
{
    BLOCK trans4_analysis_block;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_analysis_unit_text
        }
        REPLY
        {
        }
    }
}


//--- TB AN 12 : ACTIVE_RANGE ---------------------------------------------------------------------

COMMAND read_trans4_analysis_active_range
{
    BLOCK trans4_analysis_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_active_range
        }
    }
}


COMMAND write_trans4_analysis_active_range
{
    BLOCK trans4_analysis_block;
    INDEX 12;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_analysis_active_range
        }
        REPLY
        {
        }
    }
}


//--- TB AN 13 : AUTORANGE_ON ---------------------------------------------------------------------

COMMAND read_trans4_analysis_autorange_on
{
    BLOCK trans4_analysis_block;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_autorange_on
        }
    }
}


COMMAND write_trans4_analysis_autorange_on
{
    BLOCK trans4_analysis_block;
    INDEX 13;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_analysis_autorange_on
        }
        REPLY
        {
        }
    }
}


//--- TB AN 14 : SAMPLING_RATE --------------------------------------------------------------------

COMMAND read_trans4_analysis_sampling_rate
{
    BLOCK trans4_analysis_block;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_sampling_rate
        }
    }
}


COMMAND write_trans4_analysis_sampling_rate
{
    BLOCK trans4_analysis_block;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_analysis_sampling_rate
        }
        REPLY
        {
        }
    }
}


//--- TB AN 25 : NUMBER_OF_RANGES -----------------------------------------------------------------

COMMAND read_trans4_analysis_number_of_ranges
{
    BLOCK trans4_analysis_block;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_number_of_ranges
        }
    }
}


//--- TB AN 26 : RANGE_1 --------------------------------------------------------------------------

COMMAND read_trans4_analysis_range_1
{
    BLOCK trans4_analysis_block;
    INDEX 26;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_lower_range_value_1,
            trans4_analysis_upper_range_value_1
        }
    }
}


COMMAND write_trans4_analysis_range_1
{
    BLOCK trans4_analysis_block;
    INDEX 26;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            trans4_analysis_lower_range_value_1,
            trans4_analysis_upper_range_value_1
        }
        REPLY
        {
        }
    }
}


//--- TB AN 27 : MEAS_INFO ---- (Man spec) --------------------------------------------------------

COMMAND read_trans4_analysis_meas_info
{
    BLOCK trans4_analysis_block;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_meas_info_module_adr				<0xF0>,
            trans4_meas_info_ofs_module_tab			<0x0F>,
            trans4_analysis_meas_info
        }
    }
}


//--- TB AN 28 : SENSOR_ID ---- (Man spec) --------------------------------------------------------

COMMAND read_trans4_analysis_sensor_id
{
    BLOCK trans4_analysis_block;
    INDEX 28;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            trans4_analysis_sensor_id_name,
            trans4_analysis_sensor_id_ser_num
        }
    }
}



//-------------------------------------------------------------------------------------------------
//		METHOD
//-------------------------------------------------------------------------------------------------



//-------------------------------------------------------------------------------------------------
//    MENU (Output)
//-------------------------------------------------------------------------------------------------

MENU Page_display_trans4_measure
{
    LABEL		TRANS4_TITLE;
    ITEMS
    {
        trans4_tag_desc						(READ_ONLY),
        trans4_analysis_component_name	(READ_ONLY),
        Group_display_trans4_primary
    }
}

CHART HoriBarChart_trans4_pv
{
    LABEL [func_out_value];
    TYPE HORIZONTAL_BAR;
    WIDTH MEDIUM;
    HEIGHT MEDIUM;
    CYCLE_TIME 3000;
    MEMBERS
    {
        SOURCE1, Value_trans4_pv;
    }
}
SOURCE Value_trans4_pv
{
    LABEL [func_out_value];
    Y_AXIS Axis_trans4_pv;
    MEMBERS
    {
        MONITOR1, trans4_primary_value;
    }
}
AXIS Axis_trans4_pv
{
    LABEL [trans_value];
    MIN_VALUE trans4_analysis_lower_range_value_1;
    MAX_VALUE trans4_analysis_upper_range_value_1;
}

MENU Group_display_trans4_primary
{
    LABEL		[trans_value];
    ITEMS
    {
        // trans4_primary_value,
        // SEPARATOR,
        // trans4_primary_value_time_instant,
        HoriBarChart_trans4_pv,
        trans4_primary_value_status_quality,
        trans4_primary_value_status_limit
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Diagnosis)
//-------------------------------------------------------------------------------------------------

MENU Page_diagnosis_trans4
{
    LABEL		TRANS4_TITLE;
    ITEMS
    {
        trans4_blk_object,
        trans4_blk_parent_class,
        trans4_blk_class,
        trans4_blk_dd_reference,
        trans4_blk_dd_rev,
        trans4_blk_profile,
        trans4_blk_profile_rev,
        trans4_st_rev,
        trans4_actual_mode
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Parameter Table)
//-------------------------------------------------------------------------------------------------

MENU Tab_s_trans4_Input
{
    LABEL		"Input" "|de|Eingang";
    ITEMS
    {
        trans4_st_rev,
        trans4_analysis_component_name,
        trans4_analysis_unit,
        trans4_analysis_lower_range_value_1,
        trans4_analysis_upper_range_value_1
    }
}


MENU Tab_m_trans4_Input
{
    LABEL		"Input" "|de|Eingang";
    ITEMS
    {
        trans4_st_rev,
        trans4_analysis_component_name	(READ_ONLY),
        trans4_analysis_unit,
        trans4_analysis_lower_range_value_1,
        trans4_analysis_upper_range_value_1
    }
}


MENU Tab_s_trans4_protos_ai_configuration
{
    LABEL		DEVICE_NAME_SHORT+" AI "+TRANS4_NUMBER+" Configuration" "|de| Konfiguration";
    ITEMS
    {
        trans4_meas_info_module_adr,
        trans4_meas_info_ofs_module_tab,
        trans4_analysis_sensor_id_name,
        trans4_analysis_sensor_id_ser_num,
    }
}


// MENU Tab_s_input_trans4_measrange_1
// {
// 	LABEL		[menu_input_measrange];
// 	ITEMS
// 	{
// 		trans4_analysis_lower_range_value_1,
// 		trans4_analysis_upper_range_value_1
// 	}
// }


// trans4_blk_reserve
// trans4_blk_object
// trans4_blk_parent_class
// trans4_blk_class
// trans4_blk_dd_reference
// trans4_blk_dd_rev
// trans4_blk_profile
// trans4_blk_profile_rev
// trans4_blk_execution_time
// trans4_blk_num_parameters
// trans4_blk_index_view_1
// trans4_blk_num_view_lists
// trans4_st_rev
// trans4_tag_desc
// trans4_strategy
// trans4_alert_key
// trans4_target_mode
// trans4_actual_mode
// trans4_permitted_mode
// trans4_current_state_alarm_sum
// trans4_unacknowledged_state_alarm_sum
// trans4_unreported_state_alarm_sum
// trans4_disabled_state_alarm_sum
// trans4_analysis_component_name
// trans4_primary_value
// trans4_primary_value_status_quality
// trans4_primary_value_status_limit
// trans4_primary_value_time_instant
// trans4_analysis_unit
// trans4_analysis_unit_text
// trans4_analysis_active_range
// trans4_analysis_autorange_on
// trans4_analysis_sampling_rate
// trans4_analysis_number_of_ranges
// trans4_analysis_lower_range_value_1
// trans4_analysis_upper_range_value_1

//--- TB 00 : BLOCK_OBJECT ------------------------------------------------------------------------
//--- TB 01 : ST_REV ------------------------------------------------------------------------------
//--- TB 02 : TAG_DESC ----------------------------------------------------------------------------
//--- TB 03 : STRATEGY ----------------------------------------------------------------------------
//--- TB 04 : ALERT_KEY ---------------------------------------------------------------------------
//--- TB 05 : TARGET_MODE -------------------------------------------------------------------------
//--- TB 06 : MODE_BLK ----------------------------------------------------------------------------
//--- TB 07 : ALARM_SUM ---------------------------------------------------------------------------
//--- TB AN 08 : COMPONENT_NAME -------------------------------------------------------------------
//--- TB AN 09 : PV -------------------------------------------------------------------------------
//--- TB AN 10 : PV_UNIT --------------------------------------------------------------------------
//--- TB AN 11 : PV_UNIT_TEXT ---------------------------------------------------------------------
//--- TB AN 12 : ACTIVE_RANGE ---------------------------------------------------------------------
//--- TB AN 13 : AUTORANGE_ON ---------------------------------------------------------------------
//--- TB AN 14 : SAMPLING_RATE --------------------------------------------------------------------
//--- TB AN 25 : NUMBER_OF_RANGES -----------------------------------------------------------------
//--- TB AN 26 : RANGE_1 --------------------------------------------------------------------------
