/* ----------------------------------------------------------------------

 FILE_NAME          config.ddl



 FUNCTIONAL_MODULE_DESCRIPTION

 Menstruktur und Konfiguration
 - Es werden fr alle Messtypen eigene Seiten erstellt (pH, Oxy...)
 - Die einzelnen Parameter werden nur bestimmten Bedingungen angezeigt. z.B. Manuelle Temperatur nur, wenn Temperatur auf MAN steht
 - Die Struktur sieht wie folgt aus:
 Device Configure/ Setup   - Identification
 - Configuration - Standard
 - pH
 - Cond
 - TCond
 - DO
 - CC
 - Calibration
 Diagnostics
 - Sensor (siehe sensor.ddl)
 - Logbook (Siehe Logbook.ddl)

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */
#include "ident.ddl"


/*
 Menuedefinition - Root-Men
 */
MENU device_root_menu_setup
{
    LABEL TXT_SETUP;
    STYLE MENU;
    ITEMS
    {
        std_configuration_clock,
        param_window,
        device_root_menu_functionblocks,
		config_diag_window
    }
}

MENU device_root_menu_lock
{
    LABEL TXT_DEVICE_LOCK;
    STYLE WINDOW;
    ITEMS
    {
        phys_DEVICE_LOCK
    }
}

MENU device_root_menu_config
{
    LABEL TXT_PROCESSINPUT;
    STYLE MENU;
    ITEMS
    {
        param_window
    }
}

MENU device_root_menu_diag
{
    LABEL TXT_SETUP_DEVICE;
    STYLE MENU;
    ITEMS
    {
        config_diag_window /* Features, DiagEvent... */
    }
}

MENU device_root_menu_functionblocks
{
    LABEL TXT_IO;   
	STYLE WINDOW; 	
    ITEMS
    {
        output_fb_overview,
		func_output_ai,
		func_output_di,
		func_output_ao	
#ifdef STRATOS_DP
        ,func_output_do
#endif
    }
}
MENU func_output_ai
{
    LABEL [label_process_values] + " (AI1-8)";
    ITEMS
    {
        output_ai1_window,
        output_ai2_window,
        output_ai3_window,
        output_ai4_window,
        output_ai5_window,
        output_ai6_window,
        output_ai7_window,
        output_ai8_window
    }
}
MENU func_output_ao
{
    LABEL [label_compensation] + " (AO1)";
    ITEMS
    {
        output_ao1_window
    }
}
MENU func_output_do
{
    LABEL [label_control] + " (DO1-2)";
    ITEMS
    {
        output_do1_window,
        output_do2_window
    }
}
MENU func_output_di
{
    LABEL [label_digital] + " (DI1)";
    ITEMS
    {
        output_di1_window
    }
}
MENU output_fb_overview
{
    LABEL TXT_OVERVIEW;    
    ITEMS
    {
        output_fb_overview_PB,
        output_fb_overview_AI,
        output_fb_overview_AO,
        output_fb_overview_DI
#ifdef STRATOS_DP
        ,output_fb_overview_DO
#endif
    }
    //POST_READ_ACTIONS { method_refresh_ai_chanels(99) }
}
MENU output_fb_overview_PB
{
    LABEL "Physical Block";
    STYLE GROUP;
    ITEMS
    {
        //phys_TAG_DESC,
        //COLUMNBREAK,
        phys_COND_STATUS_DIAG,
        ROWBREAK,
        phys_TARGET_MODE
    }
}
MENU output_fb_overview_AI
{
    LABEL [label_ai];
    STYLE GROUP;
    ITEMS
    {
        meas_type (HIDDEN),
        //"Funktionsblock 1: AI",
        //ROWBREAK,
        //func1_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func1_AI_CHANNEL[meas_type] (READ_ONLY),

        //"Funktionsblock 2: AI",
        //ROWBREAK,
        //func2_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func2_AI_CHANNEL[meas_type](READ_ONLY),
        //ROWBREAK,
        //func2_AI_OUT_SCALE_Units_Index,

        //"Funktionsblock 3: AI",
        //ROWBREAK,
        //func3_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func3_AI_CHANNEL[meas_type](READ_ONLY),
        //ROWBREAK,
        //func3_AI_OUT_SCALE_Units_Index,

        //"Funktionsblock 4: AI"(READ_ONLY),
        //ROWBREAK,
        //func4_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func4_AI_CHANNEL[meas_type](READ_ONLY),
        //ROWBREAK,
        //func4_AI_OUT_SCALE_Units_Index,

        //"Funktionsblock 5: AI",
        //ROWBREAK,
        //func5_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func5_AI_CHANNEL[meas_type](READ_ONLY),
        //ROWBREAK,
        //func5_AI_OUT_SCALE_Units_Index,

        //"Funktionsblock 6: AI",
        //ROWBREAK,
        //func6_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func6_AI_CHANNEL[meas_type](READ_ONLY),
        //ROWBREAK,
        //func6_AI_OUT_SCALE_Units_Index,

        //"Funktionsblock 7: AI",
        //ROWBREAK,
        //func7_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func7_AI_CHANNEL[meas_type](READ_ONLY),
        //ROWBREAK,
        //func7_AI_OUT_SCALE_Units_Index,

        //"Funktionsblock 8: AI",
        //ROWBREAK,
        //func8_AI_TAG_DESC,
        //COLUMNBREAK,
        refarray_func8_AI_CHANNEL[meas_type](READ_ONLY)
        //ROWBREAK,
        //func8_AI_OUT_SCALE_Units_Index,
    }
}

MENU output_fb_overview_AO
{
    LABEL [label_ao];
    STYLE GROUP;
    ITEMS
    {
        //func1_AO_TAG_DESC,
        //COLUMNBREAK,
        func1_AO_OUT_CHANNEL(READ_ONLY)
        //ROWBREAK,
        //func1_AO_PV_SCALE_Units_Index,
    }
}
MENU output_fb_overview_DI
{
    LABEL [label_di];
    STYLE GROUP;
    ITEMS
    {
        //func1_DI_TAG_DESC,
        //COLUMNBREAK,
        func1_DI_CHANNEL(READ_ONLY)
        //ROWBREAK,
        //func1_DI_INVERT(READ_ONLY)
    }
}
MENU output_fb_overview_DO
{
    LABEL [label_do];
    STYLE GROUP;
    ITEMS
    {
        ROWBREAK,ROWBREAK,

        //func1_DO_TAG_DESC,
        //COLUMNBREAK,
        func1_DO_IN_CHANNEL (READ_ONLY),
        //ROWBREAK,
        //func1_DO_INVERT(READ_ONLY),

        ROWBREAK,
        //func2_DO_TAG_DESC,
        //COLUMNBREAK,
        func2_DO_IN_CHANNEL(READ_ONLY)
        //ROWBREAK,
        //func2_DO_INVERT(READ_ONLY)
    }
}

METHOD method_refresh_ai_chanels(unsigned int channel) 
{    
	LABEL    "";
    CLASS OUTPUT;
    DEFINITION
    {
        ReadCommand(tb1_meas_type_read);

        ReadCommand(func1_AI_CHANNEL_read);
        ReadCommand(func2_AI_CHANNEL_read);
        ReadCommand(func3_AI_CHANNEL_read);
        ReadCommand(func4_AI_CHANNEL_read);
        ReadCommand(func5_AI_CHANNEL_read);
        ReadCommand(func6_AI_CHANNEL_read);
        ReadCommand(func7_AI_CHANNEL_read);
        ReadCommand(func8_AI_CHANNEL_read);

        ReadCommand(func1_AI_OUT_SCALE_read);
        ReadCommand(func2_AI_OUT_SCALE_read);
        ReadCommand(func3_AI_OUT_SCALE_read);
        ReadCommand(func4_AI_OUT_SCALE_read);
        ReadCommand(func5_AI_OUT_SCALE_read);
        ReadCommand(func6_AI_OUT_SCALE_read);
        ReadCommand(func7_AI_OUT_SCALE_read);
        ReadCommand(func8_AI_OUT_SCALE_read);
    }
}

/*
 ------------------------------------------------------
 ####   ###   #   #  #####  #####   ####
 #      #   #  ##  #  #        #    #
 #      #   #  # # #  ###      #    # ###
 #      #   #  #  ##  #        #    #   #
 ####   ###   #   #  #      #####   ####
 ------------------------------------------------------
 */
MENU param_window
{
    LABEL TXT_PROCESSINPUT;  
	STYLE WINDOW;	
    ITEMS
    {
        meas_type_wizard, 

        other_configuration_page
    }
}

MENU meas_type_wizard
{
    LABEL TXT_CONF_SEL_MEASTYPE;
    STYLE PAGE;
    ITEMS
    {
        //meas_type (HIDDEN),
				
        param_method,		

        ph_configuration_page,		
        cond_configuration_page,
        condi_configuration_page,
        oxy_configuration_page,
        cc_configuration_page
    }
	PRE_READ_ACTIONS {method_refresh_meas_type}
}

METHOD param_method
{
    LABEL TXT_CONF_MEASTYPE;
    ACCESS OFFLINE;
    CLASS INPUT;
    DEFINITION
    {
        long lSelect, lStep;

        lStep = 1;

        // eventually backup old values, if you want to reset changes
        // before start read values from device, as method acts offline

        method_refresh_ai_chanels(99);

        do
        {
            switch (lStep) {

                // Step 1: prompt for meas type selection
                case 1:
                MenuDisplay(menu_dialog_param_window_step_1, wizard_start_step_buttons, lSelect);

                switch (lSelect) {

                    case 0 :       // Cancel
                    method_quick_start_abort();
                    break;
                    case 1 :// Next
                    lStep = 2;
                    break;
                }
                break;

                // Step 2: prompt for arrangement of channels
                case 2:

                MenuDisplay(menu_dialog_param_window_step_2, wizard_last_step_buttons, lSelect);
                switch (lSelect) {

                    case 0 :       // Cancel
                    method_quick_start_abort();
                    break;
                    case 1 :// Back
                    lStep = 1;
                    break;
                    case 2 :// Next
                    lStep = 10;
                    break;
                }
                break;
               
                default:
                process_abort();
                break;
            }
        }
        while (lStep < 10);

        // apply to device
        if (lStep == 10) {

            save_values();

            WriteCommand(tb1_meas_type_write);

            WriteCommand(func1_AI_CHANNEL_write);
            WriteCommand(func2_AI_CHANNEL_write);
            WriteCommand(func3_AI_CHANNEL_write);
            WriteCommand(func4_AI_CHANNEL_write);
            WriteCommand(func5_AI_CHANNEL_write);
            WriteCommand(func6_AI_CHANNEL_write);
            WriteCommand(func7_AI_CHANNEL_write);
            WriteCommand(func8_AI_CHANNEL_write);
        }
        ReadCommand(tb1_meas_type_read);
    }
}
METHOD method_set_default_unit(unsigned int _meas_type) {
    LABEL
    "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    TYPE
    unsigned int;
    DEFINITION
    {
        switch (_meas_type) {

            case 0x015a :
                if (meas_type == MEAS_TYPE_PH)
                    return 1422; // pH
                if (meas_type == MEAS_TYPE_COND)
                    return 1552; // Conductivity
                if (meas_type == MEAS_TYPE_CONDI)
                    return 1552; // Conductivity
                if (meas_type == MEAS_TYPE_CC)
                    return 1552; // Conductivity
                if (meas_type == MEAS_TYPE_OXY)
                    return 1342; // Saturation
                break;

            case 0x0139 :
                return 1001;
                break; // Temperature
            case 0x0135 :
                return 1243;
                break; // pH-Voltage
            case 0x0136 :
                return 1243;
                break; // ORP-Voltage
            case 0x0137 :
                return 1281;
                break; // Glas-Impedance
            case 0x0138 :
                return 1281;
                break; //
            case 0x013f :
                return 1342;
                break; // Wear
            case 0x013b :
                return 1059;
                break; // Calibration timer
            case 0x0140 :
                return 1353;
                break; // Flow
            case 0x013c :
                if (meas_type == MEAS_TYPE_OXY)
                    return 1213;
                else
                    return 1342;
                break; // Slope
            case 0x013e :
                if (meas_type == MEAS_TYPE_PH)
                    return 1243;
                if (meas_type == MEAS_TYPE_COND)
                    return 1552;
                if (meas_type == MEAS_TYPE_CONDI)
                    return 1552;
                if (meas_type == MEAS_TYPE_CC)
                    return 1552;
                if (meas_type == MEAS_TYPE_OXY)
                    return 1213;
                break;

            case 0x0149 :
                return 1342;
                break; // Concentration
            case 0x014b :
                return 1523;
                break; // Salinity
            case 0x014c :
                return 1558;
                break; // TDS
            case 0x0148 :
                return 1555;
                break; // Specific Resistance
            case 0x014f :
                return 1524;
                break; // Cell constant

            case 0x0142 :
                return 1558;
                break; // O2-Concentration
            case 0x0144 :
                return 1562;
                break; // Volume concentration
            case 0x0145 :
                return 1138;
                break; // Partial pressure
        }
        return 0;
    }
}

METHOD method_set_default_channels
{
    LABEL "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    DEFINITION
    {
        //PUT_MESSAGE("meas type: " + meas_type);

        switch (meas_type) {

            case MEAS_TYPE_PH:
				
            refarray_func1_AI_CHANNEL[meas_type] = 0x015a; // pH
            refarray_func2_AI_CHANNEL[meas_type] = 0x0139;// Temperature
            refarray_func3_AI_CHANNEL[meas_type] = 0x0135;// pH-Voltage
            refarray_func4_AI_CHANNEL[meas_type] = 0x0136;// ORP-Voltage
            refarray_func5_AI_CHANNEL[meas_type] = 0x0137;// Glas-Impedance
            refarray_func6_AI_CHANNEL[meas_type] = 0x013f;// Wear
            refarray_func7_AI_CHANNEL[meas_type] = 0x013b;// Calibration timer
            refarray_func8_AI_CHANNEL[meas_type] = 0x0140;// Flow
            break;

            case MEAS_TYPE_COND:

            refarray_func1_AI_CHANNEL[meas_type] = 0x015a;// Conductivity
            refarray_func2_AI_CHANNEL[meas_type] = 0x0139;// Temperature
            refarray_func3_AI_CHANNEL[meas_type] = 0x0149;// Concentration
            refarray_func4_AI_CHANNEL[meas_type] = 0x014b;// Salinity
            refarray_func5_AI_CHANNEL[meas_type] = 0x014c;// TDS
            refarray_func6_AI_CHANNEL[meas_type] = 0x0148;// Specific Resistance
            refarray_func7_AI_CHANNEL[meas_type] = 0x014f;// Cell constant
            refarray_func8_AI_CHANNEL[meas_type] = 0x0140;// FLow
            break;

            case MEAS_TYPE_CONDI:
            refarray_func1_AI_CHANNEL[meas_type] = 0x015a;// Conductivity
            refarray_func2_AI_CHANNEL[meas_type] = 0x0139;// Temperature
            refarray_func3_AI_CHANNEL[meas_type] = 0x0149;// Concentration
            refarray_func4_AI_CHANNEL[meas_type] = 0x014b;// Salinity
            refarray_func5_AI_CHANNEL[meas_type] = 0x014c;// TDS
            refarray_func6_AI_CHANNEL[meas_type] = 0x0148;// Specific Resistance
            refarray_func7_AI_CHANNEL[meas_type] = 0x014f;// Cell constant
            refarray_func8_AI_CHANNEL[meas_type] = 0x0140;// FLow
            break;

            case MEAS_TYPE_CC:
            refarray_func1_AI_CHANNEL[meas_type] = 0x0146;// Conductivity A
            refarray_func2_AI_CHANNEL[meas_type] = 0x0139;// Temperature A
            refarray_func3_AI_CHANNEL[meas_type] = 0x014d;// Conductivity B
            refarray_func4_AI_CHANNEL[meas_type] = 0x0150;// Temperature B
            refarray_func5_AI_CHANNEL[meas_type] = 0x014e;// Verrechnung
            refarray_func6_AI_CHANNEL[meas_type] = 0x014f;// Cell constant A
            refarray_func7_AI_CHANNEL[meas_type] = 0x013e;// Cell constant B
            refarray_func8_AI_CHANNEL[meas_type] = 0x0140;// Flow
            break;

            case MEAS_TYPE_OXY:
            refarray_func1_AI_CHANNEL[meas_type] = 0x015a;// Saturation
            refarray_func2_AI_CHANNEL[meas_type] = 0x0139;// Temperature
            refarray_func3_AI_CHANNEL[meas_type] = 0x0142;// O2-Concentration
            refarray_func4_AI_CHANNEL[meas_type] = 0x0144;// Volume concentration
            refarray_func5_AI_CHANNEL[meas_type] = 0x0145;// Partial pressure
            refarray_func6_AI_CHANNEL[meas_type] = 0x013f;// Wear
            refarray_func7_AI_CHANNEL[meas_type] = 0x013b;// Calibration timer
            refarray_func8_AI_CHANNEL[meas_type] = 0x0140;// Flow
            break;

        }
		
		if (meas_type != MEAS_TYPE_OXY) { 
			
			func1_AO_OUT_CHANNEL = 0x0153; // Temperatur
			WriteCommand(func1_AO_OUT_CHANNEL_write);
		}
		
        method_func1_set_default_unit();
        method_func2_set_default_unit();
        method_func3_set_default_unit();
        method_func4_set_default_unit();
        method_func5_set_default_unit();
        method_func6_set_default_unit();
        method_func7_set_default_unit();
        method_func8_set_default_unit();
    }
}

METHOD encode_CHANNEL(unsigned int code) {
    LABEL
    "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    TYPE
    unsigned int;
    DEFINITION
    {

        if (code == 1)
            return 1;

        return code + meas_type * 4096;
    }
}

METHOD decode_CHANNEL(unsigned int code) {
    LABEL
    "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    TYPE
    unsigned int;
    DEFINITION
    {
        return code - meas_type * 4096;
    }
}

MENU menu_dialog_param_window_step_1
{
    LABEL TXT_CONF_MEASTYPE;
    STYLE DIALOG;
    ACCESS OFFLINE;
    ITEMS {std_configuration_meas_type}
}

MENU menu_dialog_param_window_step_2
{
    LABEL TXT_CONF_MEASTYPE;
    STYLE DIALOG;
    ACCESS OFFLINE;
    ITEMS {std_configuration_chanel_selection}
}

METHOD method_quick_start_abort
{
    LABEL [cancel];
    DEFINITION
    {
        // restore of backuped values first
        process_abort();
    }
}

MENU other_configuration_page
{
    LABEL TXT_OTHER;
    STYLE PAGE;
    ITEMS
    { std_configuration_alarm }
}

MENU std_configuration_alarm
{
    LABEL TXT_CONF_ALARM;
    STYLE GROUP;
    ITEMS
    {
        sensocheck,
        flow_adjust,
        alarm_delay,
        hold
    }
}

MENU std_configuration_meas_type
{
    LABEL TXT_CONF_MEASTYPE;
    STYLE GROUP;
    ITEMS
    {
        meas_type
    }
}

MENU std_configuration_chanel_selection
{
    LABEL [label_assign];
    STYLE GROUP;
    ITEMS
    {
        refarray_func1_AI_CHANNEL[meas_type],
        refarray_func2_AI_CHANNEL[meas_type],
        refarray_func3_AI_CHANNEL[meas_type],
        refarray_func4_AI_CHANNEL[meas_type],
        refarray_func5_AI_CHANNEL[meas_type],
        refarray_func6_AI_CHANNEL[meas_type],
        refarray_func7_AI_CHANNEL[meas_type],
        refarray_func8_AI_CHANNEL[meas_type]
    }
}

MENU std_configuration_clock
{
    LABEL TXT_CONF_CLOCK;   
	STYLE WINDOW;
    ITEMS
    {
        format_27,
        ampm_27,
        minute_27,
        hour_27,
        day_27,
        month_27,
        year_27
    }
}

/* -----------------------------------------------------------------
 ####   #   #
 #   #  #   #
 ####   #####
 #      #   #
 #      #   #

 Seite "pH"

 Sensorp
 Sensortype        Measmode

 Temperature
 Type              Unit
 Temp-meas         Man
 Temp-cal          Man

 Pfaudler
 Nom-Zero          Nom-Slope
 Ph_iso

 Calibration
 Calmode           Bufferset
 Caltimer          Cal-Cycle

 Maintenance
 ACT               ACT-Cycle
 TTM               TTM-CYCLE
 CIP               CIP-CYCLE
 SIP               SIP-CYCLE
 AUTOCLAVE         AC-CYCLES
 */
MENU ph_configuration_page
{
    LABEL "pH";
    STYLE GROUP;
    ITEMS
    {		
        ph_gr_sensor,
        ph_gr_display,
        ph_gr_Temp,
        ph_gr_pfaudler,
        ph_gr_calibration,
        ph_gr_maintenance
    }
    VALIDITY IF (meas_type == MEAS_TYPE_PH) { TRUE; } ELSE { FALSE; }
}

METHOD method_ph_buffer() 
{    
	LABEL    [buffer_button];
    CLASS OUTPUT;
    DEFINITION
    {
		long lSelect;
		
		lSelect=1;
		do
        {
            switch (lSelect) {

                case 0: 
					method_quick_start_abort();
                    break;
				case 1: 
					MenuDisplay(ph_gr_user_buffer_ovw, wizard_SAVE_CLOSE, lSelect);	
					if (lSelect == 1) {
						//save_values();
						WriteCommand(tb1_ph_user_buffer_1_write);
						WriteCommand(tb1_ph_user_buffer_2_write);					
						ReadCommand(tb1_current_error_read);	
					}
					break;
			}
		}		
		while (1);			
	}
	VALIDITY IF (buffer_set_19 == 11) {TRUE;} ELSE {FALSE;}/* Wenn Buffersatz auf Userbuffer steht */
}

/*
 Sensorp
 Sensortype        Measmode
 */
MENU ph_gr_sensor
{
    LABEL TXT_CONF_PH_SENSOR;
    STYLE GROUP;
    ITEMS
    {
        sensortype_19
    }
}

MENU ph_gr_display
{
    LABEL TXT_DISPLAY;
    STYLE GROUP;
    ITEMS
    {
        meas_mode_19,
        temp_unit_19
    }
}

MENU ph_gr_Temp
{
    LABEL TXT_CONF_TEMPERATUR;
    STYLE GROUP;
    ITEMS
    {
        rtd_type_19,
        temp_meas_19,
        temp_meas_man_19,
        temp_cal_19,
        temp_cal_man_19,
        tc_select_19,
        tc_liquid_19,
		method_ph_liquid
    }
}
METHOD method_ph_liquid() 
{    
	LABEL    [liquid_button];
    CLASS OUTPUT;
    DEFINITION
    {
		long lSelect;
		
		lSelect=1;
		do
        {
            switch (lSelect) {

                case 0: 
					method_quick_start_abort();
                    break;
				case 1: 
					MenuDisplay(ph_gr_liquid_ovw, wizard_SAVE_CLOSE, lSelect);	
					if (lSelect == 1) {
						//save_values();			
						WriteCommand(tb1_ph_tc_liquid_table_write);
					}
					break;
			}
		}		
		while (1);
	}
    VALIDITY IF (tc_select_19 == 7) {TRUE;} ELSE {FALSE;} /* Wenn TC-Select auf User-Tab steht */	
}

MENU ph_gr_pfaudler
{
    LABEL "Pfaudler";
    STYLE GROUP;
    ITEMS
    {
        nom_zero_19,
        nom_slope_19,
        ph_iso_19
    }
    VALIDITY IF (sensortype_19 == 18) { TRUE; } ELSE { FALSE; }
}

/*
 Calibration
 Calmode           Bufferset
 Caltimer          Cal-Cycle
 */
MENU ph_gr_calibration
{
    LABEL TXT_CONF_CALIBRATION;
    STYLE GROUP;
    ITEMS
    {
        calmode_19,
        cal_timer_19,
        cal_cycle_19,
        buffer_set_19,
		method_ph_buffer
    }
}
/*
 Maintenance
 ACT               ACT-Cycle
 TTM               TTM-CYCLE
 CIP               CIP-CYCLE
 SIP               SIP-CYCLE
 AUTOCLAVE         AC-CYCLES
 */
MENU ph_gr_maintenance
{
    LABEL TXT_CONF_MAINT;
    STYLE GROUP;
    ITEMS
    {
        act_19,
        act_cycle_19,
        ttm_19,
        ttm_cycle_19,
        cip_count_19,
        cip_cycles_19,
        sip_count_19,
        sip_cycles_19,
        autoclave_19,
        ac_cycles_19
    }
}
MENU ph_gr_user_buffer_ovw
{
    LABEL [buffer_title];
    STYLE DIALOG;
    ITEMS
    {
		/*
		current_error (HIDDEN),
		//buffer_instructions,
		IF (current_error == 102) {
						
			buffer_error,
		}*/
		//[buffer_instructions], COLUMNBREAK, [buffer_instructions_ff],
		ROWBREAK,
		ph_gr_user_buffer_1, COLUMNBREAK, ph_gr_user_buffer_2
	}
	VALIDITY IF (buffer_set_19 == 11) {TRUE;} ELSE {FALSE;}/* Wenn Buffersatz auf Userbuffer steht */
}

MENU buffer_error
{
    LABEL "Fehler";
    STYLE GROUP;
    ITEMS
    {
		///img_error,
		" ",
		ROWBREAK,
		[buffer_error], COLUMNBREAK, " ",
		ROWBREAK,
		" "
	}
}
/*
MENU buffer_instructions
{
    LABEL "Hinweise";
    STYLE GROUP;
    ITEMS
    {		
		" ",
		ROWBREAK,
		[buffer_instructions_ff], COLUMNBREAK, " ",
		ROWBREAK,
		" "
	}
}*/

MENU ph_gr_user_buffer_1
{
    LABEL [buffer_1_title];
    STYLE GROUP;
    ITEMS
    {
        nominal_29,        
        degree_0_29,
        degree_5_29,
        degree_10_29,
        degree_15_29,
        degree_20_29,
        degree_25_29,
        degree_30_29,
        degree_35_29,
        degree_40_29,
        degree_45_29,
        degree_50_29,
        degree_55_29,
        degree_60_29,
        degree_65_29,
        degree_70_29,
        degree_75_29,
        degree_80_29,
        degree_85_29,
        degree_90_29,
        degree_95_29
    }
}

MENU ph_gr_user_buffer_2
{
    LABEL [buffer_2_title];
    STYLE GROUP;
    ITEMS
    {
        nominal_30,        
        degree_0_30,
        degree_5_30,
        degree_10_30,
        degree_15_30,
        degree_20_30,
        degree_25_30,
        degree_30_30,
        degree_35_30,
        degree_40_30,
        degree_45_30,
        degree_50_30,
        degree_55_30,
        degree_60_30,
        degree_65_30,
        degree_70_30,
        degree_75_30,
        degree_80_30,
        degree_85_30,
        degree_90_30,
        degree_95_30
    }
}

MENU ph_gr_liquid_ovw
{
    LABEL [liquid_title];
    STYLE DIALOG;
    ITEMS
    {
		ph_gr_liquid_table			
	}
}

MENU ph_gr_liquid_table
{
    LABEL [liquid_title];
    STYLE GROUP;
    ITEMS
    {
        degree_0_28,
        degree_5_28,
        degree_10_28,
        degree_15_28,
        degree_20_28,
        degree_25_28,
        degree_30_28,
        degree_35_28,
        degree_40_28,
        degree_45_28,
        degree_50_28,
        degree_55_28,
        degree_60_28,
        degree_65_28,
        degree_70_28,
        degree_75_28,
        degree_80_28,
        degree_85_28,
        degree_90_28,
        degree_95_28
    }
}

/*
 //------------------------------
 //   ###    ###   #   #  ####
 //  #   #  #   #  ##  #  #   #
 //  #      #   #  # # #  #   #
 //  #   #  #   #  #  ##  #   #
 //   ###    ###   #   #  ####
 //------------------------------
 */
/*
 Conductivity

 Sensor
 Sensortype      Meas_mode
 Displayunit    Soultion

 Temperature
 RTD-type        Temp_unit
 Temperature     Temp man

 Maintenance
 CIP_Count
 SPI_Count

 Temperaturecompensation
 TC Select
 TC Liquid       Ref Temp
 */
MENU cond_configuration_page
{
    LABEL TXT_CONDUCTIVITY;
    STYLE GROUP;
    ITEMS
    {
        cond_configuration_sensor,
        cond_configuration_display,
        cond_configuration_temperature,
        cond_configuration_maintenance,
        cond_configuration_tc
    }
    VALIDITY IF (meas_type == MEAS_TYPE_COND) { TRUE; } ELSE { FALSE; }
}

/*
 Sensor
 Sensortype      Meas_mode
 Displayunit    Soultion
 */
MENU cond_configuration_sensor
{
    LABEL [sensor];
    STYLE GROUP;
    ITEMS
    {
        sensortype_20,
        cond_cellconst,
        solution_20,
        tds_factor_20,
        usp_factor_20
    }
}

/*
 Display
 Sensortype      Meas_mode
 Displayunit    Soultion
 */
MENU cond_configuration_display
{
    LABEL TXT_DISPLAY;
    STYLE GROUP;
    ITEMS
    {
        meas_mode_20,
        display_unit_20,
        temp_unit_20
    }
}

/*
 Temperature
 RTD-type        Temp_unit
 Temperature     Temp man
 */
MENU cond_configuration_temperature
{
    LABEL TXT_CONF_TEMPERATUR;
    STYLE GROUP;
    ITEMS
    {
        rtd_type_20,
        temperature_20,
        temperature_man_20
    }
}

/*
 Maintenance
 CIP_Count
 SPI_Count
 */
MENU cond_configuration_maintenance
{
    LABEL TXT_CONF_MAINT;
    STYLE GROUP;
    ITEMS
    {
        cip_count_20,
        sip_count_20
    }
}

/*
 Temperaturecompensation
 TC Select
 TC Liquid       Ref Temp
 */
MENU cond_configuration_tc
{
    LABEL TXT_CONF_TEMPERATUR_COMP;
    STYLE GROUP;
    ITEMS
    {
        tc_select_20,
        tc_liquid_20,
        ref_temp_20
    }
}
/*
 //-------------------------------------
 //   ###    ###   #   #  ####   #####
 //  #   #  #   #  ##  #  #   #    #
 //  #      #   #  # # #  #   #    #
 //  #   #  #   #  #  ##  #   #    #
 //   ###    ###   #   #  ####   #####
 //-------------------------------------
 */
/*
 Torodial Conductivity

 Sensor
 Sensortype      Meas_mode
 Displayunit    Soultion

 Temperature
 RTD-type        Temp_unit
 Temperature     Temp man

 Maintenance
 CIP_Count
 SPI_Count

 Temperaturecompensation
 TC Select
 TC Liquid       Ref Temp
 */
MENU condi_configuration_page
{
    LABEL TXT_TCONDUCTIVITY;
    STYLE GROUP;
    ITEMS
    {
        condi_configuration_sensor,
        condi_configuration_sensor_other,
        condi_configuration_display,
        condi_configuration_temperature,
        condi_configuration_maintenance,
        condi_configuration_tc
    }
    VALIDITY IF (meas_type == MEAS_TYPE_CONDI) { TRUE; } ELSE { FALSE; }
}

/*
 Sensor
 Sensortype      Meas_mode
 Displayunit    Soultion
 */
MENU condi_configuration_sensor
{
    LABEL [sensor];
    STYLE GROUP;
    ITEMS
    {
        sensortype_21,
        solution_21,
        tds_factor_21
    }
    VALIDITY IF (sensortype_21 != 5) { TRUE; } ELSE { FALSE; }/* Parameter nur gltig, wenn Wenn der Sensortyp Other ist */
}

/*
 Display
 Sensortype      Meas_mode
 Displayunit    Soultion
 */
MENU condi_configuration_display
{
    LABEL TXT_DISPLAY;
    STYLE GROUP;
    ITEMS
    {
        meas_mode_21,
        display_unit_21,
        temp_unit_21

    }
}
/*
 Sensor
 Sensortype      Meas_mode, other mit Cellfactor + transratio
 Displayunit    Soultion
 */
MENU condi_configuration_sensor_other
{
    LABEL [sensor];
    STYLE GROUP;
    ITEMS
    {
        sensortype_21,
        solution_21,
        tds_factor_21,
        tc_cellfactor,
        tc_trans_ratio
    }
    VALIDITY IF (sensortype_21 == 5) { TRUE; } ELSE { FALSE; }/* Parameter nur gltig, wenn Wenn der Sensortyp Other ist */    
}

/*
 Temperature
 RTD-type        Temp_unit
 Temperature     Temp man
 */
MENU condi_configuration_temperature
{
    LABEL TXT_CONF_TEMPERATUR;
    STYLE GROUP;
    ITEMS
    {
        rtd_type_21,       
        temperature_21,
        temperature_man_21
    }
}

/*
 Maintenance
 CIP_Count
 SPI_Count
 */
MENU condi_configuration_maintenance
{
    LABEL TXT_CONF_MAINT;
    STYLE GROUP;
    ITEMS
    {
        cip_count_21,
        sip_count_21
    }
}

/*
 Temperaturecompensation
 TC Select
 TC Liquid       Ref Temp
 */
MENU condi_configuration_tc
{
    LABEL TXT_CONF_TEMPERATUR_COMP;
    STYLE GROUP;
    ITEMS
    {
        tc_select_21,
        tc_liquid_21,
        ref_temp_21
    }
}
/*
 //----------------------
 //   ###   #   #  #   #
 //  #   #   # #    # #
 //  #   #    #      #
 //  #   #   # #     #
 //   ###   #   #    #
 //----------------------
 */
/*
 Dissolved Oxygen

 Sensor
 Sensortype      Meas_mode
 u-Pol-meas      U-Pol-cal
 membran_comp
 SALINITY
 PRESSURE_UNIT
 PRESSURE        PRESSURE_MAN


 Temperature
 RTD-type        Temp_unit

 Calibration
 Calmode
 Caltimer        Cal-Cycle

 Maintenance
 ACT             ACT_CYCLE
 TTM             TTM_CYCLE
 CIP_COUNT       CIP_CYCLES
 SIP_COUNT       SIP_CYCLES
 AUTOCLAVE       AC_CYCLES
 */
MENU oxy_configuration_page
{
    LABEL TXT_DOXY;
    STYLE GROUP;
    ITEMS
    {
        oxy_configuration_sensor,
        oxy_configuration_display,
        oxy_configuration_temperature,
        oxy_configuration_calibration,
        oxy_configuration_maintenance
    }
    VALIDITY IF (meas_type == MEAS_TYPE_OXY) { TRUE; } ELSE { FALSE; }
}

/*
 Sensor
 Sensortype      Meas_mode
 Displayunit    Soultion
 */
MENU oxy_configuration_sensor
{
    LABEL [sensor];
    STYLE GROUP;
    ITEMS
    {
        sensortype_22,
        u_pol_meas_22,
        u_pol_cal_22,
        membran_comp_22,
        salinity_22,
        pressure_unit_22,
        pressure_22,
        pressure_man_22
    }
}

/*
 Display
 Sensortype      Meas_mode
 Displayunit    Soultion
 */
MENU oxy_configuration_display
{
    LABEL TXT_DISPLAY;
    STYLE GROUP;
    ITEMS
    {
        meas_mode_22,
        temp_unit_22
    }
}

/*
 Temperature
 RTD-type        Temp_unit
 Temperature     Temp man
 */
MENU oxy_configuration_temperature
{
    LABEL TXT_CONF_TEMPERATUR;
    STYLE GROUP;
    ITEMS
    {
        rtd_type_22
    }
}

/*
 Calibration
 Calmode
 Caltimer        Cal-Cycle
 */
MENU oxy_configuration_calibration
{
    LABEL TXT_CONF_CALIBRATION;
    STYLE GROUP;
    ITEMS
    {
        calmode_22,
        cal_timer_22,
        cal_cycle_22
    }
}

/*
 Maintenance
 ACT             ACT_CYCLE
 TTM             TTM_CYCLE
 CIP_COUNT       CIP_CYCLES
 SIP_COUNT       SIP_CYCLES
 AUTOCLAVE       AC_CYCLES
 */
MENU oxy_configuration_maintenance
{
    LABEL TXT_CONF_MAINT;
    STYLE GROUP;
    ITEMS
    {
        act_22,
        act_cycle_22,
        ttm_22,
        ttm_cycle_22,
        cip_count_22,
        cip_cycles_22,
        sip_count_22,
        sip_cycles_22,
        autoclave_22,
        ac_cycles_22
    }
}
/*
 //-------------------------------------
 //   ###    ###
 //  #   #  #   #
 //  #      #
 //  #   #  #   #
 //   ###    ###
 //-------------------------------------
 */

/*
 CC

 Temperaturecompensation A   Temperaturecompensation B
 TC Select                   TC Select
 TC Liquid                   TC Liquid
 Ref Temp                    Ref Temp

 Display
 Meas_mode                   Temp_unit

 Calculation
 CALCULATION                 CALCULATION_TYPE
 FACTOR_1                    FACTOR_2
 PARAMETER_W
 PARAMETER_A                 PARAMETER_B


 */
MENU cc_configuration_page
{
    LABEL LBL_MEAS_TYPE_18_VAL_3;
    STYLE GROUP;
    ITEMS
    {
        cc_configuration_snsA,
        cc_configuration_snsB,
        cc_configuration_display,
        cc_configuration_calculation
    }
    VALIDITY IF (meas_type == MEAS_TYPE_CC) { TRUE; } ELSE { FALSE; }
}

/*
 Sensor A
 TC Select
 TC Liquid
 Ref Temp
 */
MENU cc_configuration_snsA
{
    LABEL "Sensor A";
    STYLE GROUP;
    ITEMS
    {
        cc_cellfactor_a,
        tc_select_a_23,
        tc_liquid_a_23,
        ref_temp_a_23
    }
}

/*
 Sensor B
 TC Select
 TC Liquid
 Ref Temp
 */
MENU cc_configuration_snsB
{
    LABEL "Sensor B";
    STYLE GROUP;
    ITEMS
    {
        cc_cellfactor_b,
        tc_select_b_23,
        tc_liquid_b_23,
        ref_temp_b_23
    }
}

/*
 Display
 Meas_mode                   Temp_unit
 */
MENU cc_configuration_display
{
    LABEL TXT_DISPLAY;
    STYLE GROUP;
    ITEMS
    {
        meas_range_23,        
        temp_unit_23
    }
}

/*
 Calculation
 CALCULATION                 CALCULATION_TYPE
 FACTOR_1                    FACTOR_2
 PARAMETER_W
 PARAMETER_A                 PARAMETER_B
 */
MENU cc_configuration_calculation
{
    LABEL TXT_CALCULATION;
    STYLE GROUP;
    ITEMS
    {
        calculation_23,
        calculation_type_23,
        factor_1_23,
        factor_2_23,
        parameter_w_23,
        parameter_a_23,
        parameter_b_23
    }
}

/*
 ------------------------------------------------------
 ####   #####   ###    ####
 #   #    #    #   #  #
 #   #    #    #####  # ###
 #   #    #    #   #  #   #
 ####   #####  #   #   ####
 ------------------------------------------------------
 */
MENU config_diag_window
{
    LABEL TXT_DIAG_MAPPING;    
	STYLE WINDOW;
    ITEMS
    {
        phys_DIAG_EVENT_SWITCH_Status_Link_1,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_2,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_3,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_4,ROWBREAK,
        /*phys_DIAG_EVENT_SWITCH_Status_Link_5,
         phys_DIAG_EVENT_SWITCH_Status_Link_6,
         phys_DIAG_EVENT_SWITCH_Status_Link_7,*/
        phys_DIAG_EVENT_SWITCH_Status_Link_8,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_9,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_10,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_11,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_12,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_13,ROWBREAK,
        /*phys_DIAG_EVENT_SWITCH_Status_Link_14,
         phys_DIAG_EVENT_SWITCH_Status_Link_15,*/
        phys_DIAG_EVENT_SWITCH_Status_Link_16,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_17,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_18,ROWBREAK,
        /*phys_DIAG_EVENT_SWITCH_Status_Link_19,*/
        phys_DIAG_EVENT_SWITCH_Status_Link_20,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_21,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_22,ROWBREAK,
        /*phys_DIAG_EVENT_SWITCH_Status_Link_23,*/
        phys_DIAG_EVENT_SWITCH_Status_Link_24,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_25,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_26,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_27,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_28,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_29,ROWBREAK,
        phys_DIAG_EVENT_SWITCH_Status_Link_30
        /*phys_DIAG_EVENT_SWITCH_page
         config_diag_event_page*/
    }
}

/* Diag_Event_Switch */
MENU config_diag_event_page
{
    LABEL "Diagnostic Events";
    ITEMS
    {
        phys_DIAG_EVENT_SWITCH_page
    }
}

// Reset, lock...-Device
MENU other_window
{
    LABEL TXT_OTHER;
    STYLE WINDOW;
    ITEMS
    {
        phys_FACTORY_RESET,
        phys_WRITE_LOCKING,
        phys_LOCAL_OP_ENA
    }
}

MENU device_root_menu_reset
{
    LABEL TXT_RESET;
    STYLE WINDOW;
    ITEMS
    {
        phys_DIAGNOSIS,
        method_reset_factory, /* Device Reset */
        method_reset_warm,
        method_reset_pbadr
    }
}
/*-------------------------------------------------------------------
 Auslieferungszustand
 -------------------------------------------------------------------*/
METHOD method_reset_factory
{
    LABEL TXT_RESET_FACTORY;
    CLASS OUTPUT;
    DEFINITION
    {
        if ( 0 == ACKNOWLEDGE(TXT_RESET_FACTORY_QUEST)) {		
			/* Auslieferungszustand */
			assign_int( phys_FACTORY_RESET, 1 );
			WriteCommand(phys_FACTORY_RESET_write);
		}
    }
}

/*-------------------------------------------------------------------
 Warmstart
 -------------------------------------------------------------------*/
METHOD method_reset_warm
{
    LABEL TXT_RESET_WARM;
    CLASS OUTPUT;
    DEFINITION
    {		
        if ( 0 == ACKNOWLEDGE(TXT_RESET_WARM_QUEST)) {
			/* Warmstart */
			assign_int( phys_FACTORY_RESET, 2506 );
			WriteCommand(phys_FACTORY_RESET_write);
		}
    }
}

/*-------------------------------------------------------------------
 Profibusadresse rcksetzen
 -------------------------------------------------------------------*/
METHOD method_reset_pbadr
{
    LABEL TXT_RESET_PBADR;
    CLASS OUTPUT;
    DEFINITION
    {
        if ( 0 == ACKNOWLEDGE(TXT_RESET_PBADR_QUEST)) {
			
			/* Warmstart */
			assign_int( phys_FACTORY_RESET, 2712 );
			WriteCommand(phys_FACTORY_RESET_write);
		}
    }
}
