/* ----------------------------------------------------------------------

 FILE_NAME          ai5.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
 ###   #####   ###
 #   #    #    #  #
 #   #    #       #
 #####    #       #
 #   #  #####     #
 ------------------------------------------------------
 */

IMPORT "PI/0000_4005_0302_0001_ai5.ddl"
{

    EVERYTHING;

    REDEFINITIONS
    {

		REDEFINE VARIABLE func5_AI_OUT_Value
		{
			LABEL [PI_OUT_Value_label];
			HELP [PI_OUT_Value_help];
			CLASS OUTPUT & DYNAMIC;
			HANDLING IF (func5_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
			TYPE FLOAT { DISPLAY_FORMAT DEF_DISPLAY_FORMAT(func5_AI_OUT_SCALE_Decimal_Point); }
		}
		
        REDEFINE VARIABLE func5_AI_OUT_SCALE_Units_Index
        {
            LABEL [PI_PRIMARY_VALUE_UNIT_label];
            HELP [PI_PRIMARY_VALUE_UNIT_help];
            CLASS CONTAINED & SERVICE;
            TYPE ENUMERATED(2)
            {
                DEFAULT_VALUE 1342;
                AI_UNIT_LIST
            }
        }

        REDEFINE VARIABLE func5_AI_CHANNEL
        {
            LABEL "AI5 " + [PI_CHANNEL_label];
            HELP [PI_CHANNEL_help];
            CLASS CONTAINED;			
            TYPE ENUMERATED (2)
            {
                SELECT ( meas_type )
                {
                    CASE MEAS_TYPE_PH: AI_CHANNEL_LIST_PH
                    CASE MEAS_TYPE_COND: AI_CHANNEL_LIST_COND
                    CASE MEAS_TYPE_CONDI: AI_CHANNEL_LIST_CONDI
                    CASE MEAS_TYPE_CC: AI_CHANNEL_LIST_CC
                    CASE MEAS_TYPE_OXY: AI_CHANNEL_LIST_OXY
                    //DEFAULT: AI_CHANNEL_LIST
                }
            }
            HANDLING READ & WRITE;
            POST_EDIT_ACTIONS {method_func5_set_default_unit}
        }
		
	}
	
}

ARRAY OF VARIABLE refarray_func5_AI_CHANNEL
{
    LABEL "";	
    ELEMENTS
    {
        0, func5_AI_CHANNEL;
        1, func5_AI_CHANNEL;
        2, func5_AI_CHANNEL;
        3, func5_AI_CHANNEL;
        4, func5_AI_CHANNEL;
    }
}

/*
 ####################################
 Configuration vom AI
 ####################################
 */
MENU output_ai5_window
{
    LABEL [LABEL_AI5];
    STYLE WINDOW;
    ITEMS
    {
        meas_type(HIDDEN),
        conf_out_ai5_ident,
        conf_out_ai5_process,
        conf_out_ai5_alarm,
        conf_out_ai5_fail,
        conf_out_ai5_batch
    }
    POST_READ_ACTIONS {method_refresh_ai_chanels(1)}
}

MENU out_ai5_value
{
    LABEL [PI_display_measure];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_OUT_SCALE_Units_Index (HIDDEN),
        refarray_func5_AI_CHANNEL[meas_type] (READ_ONLY),
        ROWBREAK,
        func5_AI_OUT_Value (READ_ONLY),
        ROWBREAK,
        func5_AI_OUT_Status_Condensed (READ_ONLY)
    }
}

/* TAG... */
MENU conf_out_ai5_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func5_AI_TAG_DESC,
        func5_AI_STRATEGY,
        func5_AI_ST_REV
    }
}

/* OUT,CHANNEL... */
MENU conf_out_ai5_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        refarray_func5_AI_CHANNEL[meas_type],
        func5_AI_PV_FTIME,
        func5_AI_PV_SCALE_Lower_Value,
        func5_AI_PV_SCALE_Upper_Value,
        func5_AI_OUT_SCALE_Lower_Value,
        func5_AI_OUT_SCALE_Upper_Value,
		//    func5_AI_OUT_SCALE_Units_Index(READ_ONLY),
        func5_AI_OUT_SCALE_Decimal_Point
    }
}

/* Alarm, limits... */
MENU conf_out_ai5_alarm
{
    LABEL TXT_FB_ALARM;
    STYLE GROUP;
    ITEMS
    {
        func5_AI_HI_HI_LIM,
        func5_AI_HI_LIM,
        func5_AI_LO_LIM,
        func5_AI_LO_LO_LIM,
        func5_AI_ALARM_HYS
    }
}

/* fail safe... */
MENU conf_out_ai5_fail
{
    LABEL TXT_FB_FAIL;
    STYLE GROUP;
    ITEMS
    {
        func5_AI_FSAFE_TYPE,
        func5_AI_FSAFE_VALUE
    }
}

/* Batch.. */
MENU conf_out_ai5_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func5_AI_BATCH_Batch_ID,
        func5_AI_BATCH_Rup,
        func5_AI_BATCH_Operation,
        func5_AI_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_ai5_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func5_AI_TARGET_MODE,
        func5_AI_MODE_BLK_Actual,
        func5_AI_SIMULATE_Enabled,
        func5_AI_SIMULATE_Value,
        func5_AI_SIMULATE_Status_Condensed
    }
}

MENU out_ai5_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_MODE_BLK_Actual,
        ROWBREAK ,
        func5_AI_SIMULATE_Enabled (READ_ONLY)
    }
}

MENU simulation_window_ai5
{
    LABEL [LABEL_AI5];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
		func5_AI_OUT_SCALE_Units_Index (HIDDEN),

		func5_AI_CHANNEL (READ_ONLY),
        simulation_wnd_ai5_input,
        simulation_wnd_ai5_output
    }
}
MENU simulation_wnd_ai5_input
{
    LABEL TXT_AI_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func5_AI_SIMULATE_Enabled,
        func5_AI_SIMULATE_Value,
        func5_AI_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_ai5_output
{
    LABEL TXT_AI_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func5_AI_TARGET_MODE,
        func5_AI_MODE_BLK_Actual,
        func5_AI_OUT_Value,
        func5_AI_OUT_Status_Condensed
    }
}
/*
 ####################################
 Diagnose vom AI
 ####################################
 */
MENU output_ai5_diag_window
{
    LABEL "Output AI5";
    STYLE WINDOW;
    ITEMS
    {
        diag_out_ai5_alarm
    }
}

/* Alarms... */
MENU diag_out_ai5_alarm
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        func5_AI_ALARM_SUM_Current,
        func5_AI_ALARM_SUM_Unacknowledged,
        func5_AI_ALARM_SUM_Unreported,
        func5_AI_ALARM_SUM_Disabled,
        func5_AI_HI_HI_ALM_Unacknowledged,
        func5_AI_HI_HI_ALM_Alarm_State,
        //func5_AI_HI_HI_ALM_Time_Stamp,
        func5_AI_HI_HI_ALM_Subcode,
        func5_AI_HI_HI_ALM_Value,
        /* -------------------------- */
        func5_AI_HI_ALM_Unacknowledged,
        func5_AI_HI_ALM_Alarm_State,
        // func5_AI_HI_ALM_Time_Stamp,
        func5_AI_HI_ALM_Subcode,
        func5_AI_HI_ALM_Value,
        /* -------------------------- */
        func5_AI_LO_ALM_Unacknowledged,
        func5_AI_LO_ALM_Alarm_State,
        // func5_AI_LO_ALM_Time_Stamp,
        func5_AI_LO_ALM_Subcode,
        func5_AI_LO_ALM_Value,
        /* -------------------------- */
        func5_AI_LO_LO_ALM_Unacknowledged,
        func5_AI_LO_LO_ALM_Alarm_State,
        // func5_AI_LO_LO_ALM_Time_Stamp,
        func5_AI_LO_LO_ALM_Subcode,
        func5_AI_LO_LO_ALM_Value
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

SOURCE ai5_value_source
{
	LABEL [LABEL_AI5];
    Y_AXIS func5_AI_Display_BarVal_out_axis_mandatory_B;
    MEMBERS
    {
        PRIM_VAL, func5_AI_OUT_Value;
    }
}

CHART ai5_value_chart
{
    LABEL "AI5 Value";
    TYPE HORIZONTAL_BAR;    //GAUGE;
    MEMBERS {CHART1, ai5_value_source;}
}

/* Messwerte */
MENU display_out_func5_AI
{
    LABEL [LABEL_AI5];
    ITEMS 
	{
		meas_type (HIDDEN),
		phys_FEATURE_Enabled (HIDDEN),
		
        out_ai5_value,
        ROWBREAK,
        out_ai5_simu,
        ROWBREAK,
        out_ai5_alarms
    }
    //POST_READ_ACTIONS{ method_refresh_ai_chanels(1) }
}
MENU func5_AI_ovw
{
    LABEL [LABEL_AI5];
	STYLE GROUP;
    ITEMS 
	{
		meas_type (HIDDEN),		
        func5_AI_OUT_SCALE_Units_Index (HIDDEN),
		phys_FEATURE_Enabled (HIDDEN),
				
		func5_AI_CHANNEL (READ_ONLY),
		func5_AI_OUT_Value,        
        func5_AI_OUT_Status_Condensed
    }
}

/* Alarme */

MENU out_ai5_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_ALARM_SUM_Current
    }
}

MENU overview_ai5_alarms
{
    LABEL [LABEL_AI5];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_ALARM_SUM_Current
		/*
		,
        COLUMNBREAK,
		func5_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func5_AI_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func5_AI_ALARM_SUM_Disabled		
		*/
    }
}

//MENU OnlineWindow_S_alarm_func5_AI
MENU Win_alarm_func5_AI
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        alarm_sum_func5_AI,
        alarm_hi_hi_alm_func5_AI,
        alarm_hi_alm_func5_AI,
        alarm_lo_alm_func5_AI,
        alarm_lo_lo_alm_func5_AI
    }
}

MENU alarm_sum_func5_AI
{
    LABEL [PI_ALARM_SUM_label];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_ALARM_SUM_Current,
        func5_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func5_AI_ALARM_SUM_Unreported,
        func5_AI_ALARM_SUM_Disabled
    }
}

MENU alarm_hi_hi_alm_func5_AI
{
    LABEL [PI_HI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_HI_HI_ALM_Unacknowledged,
        func5_AI_HI_HI_ALM_Alarm_State,
        //func5_AI_HI_HI_ALM_Time_Stamp,
        func5_AI_HI_HI_ALM_Subcode,
        func5_AI_HI_HI_LIM (READ_ONLY),
        func5_AI_HI_HI_ALM_Value
    }
}

MENU alarm_hi_alm_func5_AI
{
    LABEL [PI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_HI_ALM_Unacknowledged,
        func5_AI_HI_ALM_Alarm_State,
        //func5_AI_HI_ALM_Time_Stamp,
        func5_AI_HI_ALM_Subcode,
        func5_AI_HI_LIM (READ_ONLY),
        func5_AI_HI_ALM_Value
    }
}

MENU alarm_lo_alm_func5_AI
{
    LABEL [PI_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_LO_ALM_Unacknowledged,
        func5_AI_LO_ALM_Alarm_State,
        //func5_AI_LO_ALM_Time_Stamp,
        func5_AI_LO_ALM_Subcode,
        func5_AI_LO_LIM (READ_ONLY),
        func5_AI_LO_ALM_Value
    }
}

MENU alarm_lo_lo_alm_func5_AI
{
    LABEL [PI_LO_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func5_AI_LO_LO_ALM_Unacknowledged,
        func5_AI_LO_LO_ALM_Alarm_State,
        //func5_AI_LO_LO_ALM_Time_Stamp,
        func5_AI_LO_LO_ALM_Subcode,
        func5_AI_LO_LO_LIM (READ_ONLY),
        func5_AI_LO_LO_ALM_Value
    }
}

METHOD method_func5_set_default_unit
{
    LABEL "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    DEFINITION {func5_AI_OUT_SCALE_Units_Index = method_set_default_unit(func5_AI_CHANNEL);}
}

UNIT func5_AI_OUT_SCALE_unit_x
{
	func5_AI_OUT_SCALE_Units_Index:			
	func5_AI_SIMULATE_Value
}
