/* ----------------------------------------------------------------------

 FILE_NAME          cal.ddl



 FUNCTIONAL_MODULE_DESCRIPTION

 Kalibrierung
 - es wird nur eine Produktkalibrierung untersttzt
 - Es wird auf eine aufwendige Methode verzichtet, in der auf eine Benutzereingabe gewartet wird, da
 solange die Ausfhrung anderer Methoden blockiert wre.
 - Daher gibt es nur eine Methode , die den Prozesswert speichert und
 eine, die den Laborwert ins Gertschreibt und die Cal-Daten anzeigt

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */
#define CAL_RESULT_GOOD         0x0000
#define CAL_RESULT_BAD          0x0001

/*
 ------------------------------------------------------
  ####   ###   #
 #      #   #  #
 #      #   #  #
 #      #####  #
  ####  #   #  #####
 ------------------------------------------------------
 */
local_cal_prd_step LIKE VARIABLE cal_prd_step
{
    REDEFINE CLASS LOCAL;
    REDEFINE INITIAL_VALUE 0;
}

local_cal_sample_prd_stored_val LIKE VARIABLE cal_sample_prd_stored_val
{
    REDEFINE CLASS OUTPUT & LOCAL;
    REDEFINE VALIDITY IF ( cal_prd_step == 0 ) { TRUE; } ELSE { FALSE; }
}

VARIABLE cal_initialized
{
    LABEL "";
    CLASS LOCAL;
    TYPE UNSIGNED_INTEGER(1);
    INITIAL_VALUE 0;
}

IMAGE img_hook
{
    PATH "Hook.png";
}

IMAGE img_no_sensor
{
    PATH "NoSensor.png";
}

/* -----------------------------------------------------------------
  #### #####  ###  #   # ####   ###  ####  ####
 #       #   #   # ##  # #   # #   # #   # #   #
  ###    #   ##### # # # #   # ##### ####  #   #
     #   #   #   # #  ## #   # #   # #   # #   #
 ####    #   #   # #   # ####  #   # #   # ####

 Seite "Standard"

 meastype

 Clock
 mode          ampm

 */

MENU std_cal_page
{
    LABEL [str_Product_Calibration];
    STYLE WINDOW;
    ITEMS
    {
        sns_status_39 (HIDDEN),
        current_error (HIDDEN),
        meas_type (HIDDEN),    
        meas_mode_19 (HIDDEN),
        cal_prd_step (HIDDEN),
        local_cal_prd_step (HIDDEN),
        IF ( ( current_error >= 1 ) && 
             ( current_error <= 3 ) ) {
            std_cal_page_no_sensor
        }
        ELSE {       
            IF (meas_type == MEAS_TYPE_CC ||    // not supported for double-COND
                meas_mode_19 == 2) {            // not supported for ORP
                std_cal_not_supported
            }
            ELSE {
                IF ( cal_initialized == 1 )
                {
                    std_cal_page_step1    
                    IF ( ( cal_prd_step == 1 ) || ( local_cal_prd_step >= 1 ) ) 
                    {
                        std_cal_page_step2
                    }
                    IF ( local_cal_prd_step == 2 ) 
                    {
                        std_cal_page_result       
                    }
                }
            }
        }
    }
    INIT_ACTIONS { method_prd_cal_getState }
}

MENU std_cal_page_no_sensor
{
    LABEL [str_Cal_Info_No_Sensor];
    STYLE GROUP;
    ITEMS
    {        
        sns_status_39 (HIDDEN),    
        img_no_sensor
    }        
}

MENU std_cal_not_supported
{
    LABEL [str_Cal_Info_Not_Supported];
    STYLE GROUP;
    ITEMS
    {
        sns_status_39 (HIDDEN)
    }
}

UNIT rel_cal_prd_stored_val_unit
{
    cal_prd_stored_val_unit:

    cal_sample_prd_stored_val,
    local_cal_sample_prd_stored_val,
    cal_product
}

MENU std_cal_page_step1
{
    LABEL [str_Cal_Step1];
    STYLE GROUP;
    ITEMS
    {        
        [str_Cal_Info_Step1]
                
        IF ( local_cal_prd_step == 0 )
        {
            method_prd_cal_sample()
        }
        ELSE 
        {
            cal_sample_prd_stored_val, 
            local_cal_sample_prd_stored_val, 
            img_hook
        }
    }
}

MENU std_cal_page_step2
{
    LABEL [str_Cal_Step2];
    STYLE GROUP;
    ITEMS
    {
        cal_prd_stored_val_unit (HIDDEN),
        
        ROWBREAK,
        [str_Cal_Info_Step2]
        
        IF ( cal_prd_step == 1 ) 
        { 
            cal_product,
            method_apply_cal_value() 
        } 
        ELSE 
        { 
            cal_product (READ_ONLY),
            img_hook
        }
    }
}

MENU std_cal_page_result
{
    LABEL [str_Cal_StepResult];
    STYLE GROUP;
    ITEMS
    {
        sensocheck (HIDDEN),
        // Achtung: In der RRTE werden die Zeilen zwischen <<<START>>> und <<<ENDE>>> nicht korrekt angezeigt
        // Warum ? -> keine Ahnung, isso
        // <<<START>>>
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_PH )
        {
            img_smiley_hq,img_smiley_mq,img_smiley_lq,
            cal_result,
            cal_timestamp (READ_ONLY),
            ph_cal_zero (READ_ONLY),
            ph_cal_slope (READ_ONLY)
        }
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_ISFET )
        {
            img_smiley_hq,img_smiley_mq,img_smiley_lq,
            cal_result,
            cal_timestamp (READ_ONLY),
            ph_cal_offset_isfet (READ_ONLY),
            ph_cal_slope (READ_ONLY)
        }
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_ORP )
        {
            img_smiley_hq,img_smiley_mq,img_smiley_lq,
            cal_result,
            cal_timestamp (READ_ONLY),
            ph_calzero_orp (READ_ONLY)
        }
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_COND )
        {
            cal_result,
            cond_cellconst (READ_ONLY)
        }
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_CONDI )
        {
            cal_result,
            cal_timestamp (READ_ONLY),
            tc_cellfactor (READ_ONLY),
            tc_install (READ_ONLY),
            tc_zero (READ_ONLY),
            tc_trans_ratio (READ_ONLY)
        }
        IF ( ( sns_status_39 & SENSOR_MASK ) == SENSOR_DO )
        {
            cal_result,
            cal_timestamp (READ_ONLY),
            do_cal_zero (READ_ONLY),
            do_cal_slope (READ_ONLY)
        }
        // <<<ENDE>>> 
        
        method_prd_cal_finish()
    }
    INIT_ACTIONS { method_read_smiley_state }
}

/*-------------------------------------------------------------------*/
/*  Methode zum Speichern des Prozesswertes und anzeigen des Wertes  */
/*-------------------------------------------------------------------*/
METHOD method_prd_cal_sample
{
    LABEL TXT_CAL_SAMPLE;
    CLASS OUTPUT;
    DEFINITION
    {
        /* Zuerst senden wir das Commando "Sample Value", also eine 1 an das Gert */
        assign_int(cal_sample_prd, 1);
        WriteCommand(tb1_cal_sample_prd_write);

        /* Dann holen wir den gespeicherten Wert und die Einheit aus dem Gert */
        ReadCommand(tb1_cal_sample_prd_stored_val_read);
        assign_float(local_cal_sample_prd_stored_val, cal_sample_prd_stored_val);
        ReadCommand(tb1_cal_prd_stored_val_unit_read);
        
        /* Zustand der Produktkalibrierung aus dem Gert lesen */
        ReadCommand(tb1_cal_prd_step_read);

        assign_int(local_cal_prd_step, 1);
    }
}

/*-------------------------------------------------------------------*/
/*  Methode zur bernahme des Laborwerts  */
/*-------------------------------------------------------------------*/
METHOD method_apply_cal_value
{
    LABEL TXT_CAL_APPLY;
    CLASS OUTPUT;
    DEFINITION
    {
        WriteCommand(tb1_cal_product_write);
        ReadCommand(tb1_cal_prd_step_read);
        assign_int(local_cal_prd_step, 2);
    }
    VALIDITY IF (cal_prd_step == 1) { TRUE; } ELSE { FALSE; }
}

/*-------------------------------------------------------------------*/
/*  Methode zum Beenden der Produktkalibrierung  */
/*-------------------------------------------------------------------*/
METHOD method_prd_cal_finish
{
    LABEL [str_Finished];
    CLASS OUTPUT;
    DEFINITION
    {
        assign_int(local_cal_prd_step, 0);
    }
}
/*-------------------------------------------------------------------*/
/*  Methode zum Auslesen des Status der Cal-State-Machine  */
/*-------------------------------------------------------------------*/
METHOD method_prd_cal_getState
{
    LABEL "";
    CLASS OUTPUT;
    DEFINITION
    {
        ReadCommand(tb1_cal_prd_step_read);
        assign_int(local_cal_prd_step, cal_prd_step);
        assign_int(cal_initialized, 1);
    }
}
/*-------------------------------------------------------------------*/
/*  Methode wenn Produktkal-Probenwert geschrieben wurde  */
/*-------------------------------------------------------------------*/
METHOD method_prd_cal_state_valueWrite
{
    LABEL "";
    CLASS OUTPUT;
    DEFINITION
    {
        ReadCommand(tb1_cal_product_read);
        ReadCommand(tb1_cal_prd_step_read);
    }
}
