/* ----------------------------------------------------------------------

 FILE_NAME          ai2.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
  ###   #####  #### 
 #   #    #        #
 #   #    #     ### 
 #####    #    #    
 #   #  #####  #####
 ------------------------------------------------------
 */

IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC2_AI, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{
    EVERYTHING;

    REDEFINITIONS
    {
        REDEFINE VARIABLE func2_AI_OUT_SCALE_Upper_Value
        {
            LABEL [PI_OUT_SCALE_Upper_Value_label];
            HELP [PI_OUT_SCALE_Upper_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 100;
            }
        }

        REDEFINE VARIABLE func2_AI_OUT_SCALE_Lower_Value
        {
            LABEL [PI_OUT_SCALE_Lower_Value_label];
            HELP [PI_OUT_SCALE_Lower_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
            }
        }

        REDEFINE VARIABLE func2_AI_OUT_SCALE_Decimal_Point
        {
            LABEL [PI_OUT_SCALE_Decimal_Point_label];
            HELP [PI_OUT_SCALE_Decimal_Point_help];
            CLASS CONTAINED & SERVICE;
            TYPE INTEGER (1)
            {
                DEFAULT_VALUE 0;
                MIN_VALUE 0;
                MAX_VALUE 7;
            }
        }

        REDEFINE VARIABLE func2_AI_OUT_Value
        {
            LABEL [PI_OUT_Value_label];
            HELP [PI_OUT_Value_help];
            CLASS OUTPUT & DYNAMIC;
            HANDLING IF (func2_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE FLOAT { DISPLAY_FORMAT DEF_DISPLAY_FORMAT(func2_AI_OUT_SCALE_Decimal_Point) }
        }
        
        REDEFINE VARIABLE func2_AI_OUT_SCALE_Units_Index
        {
            LABEL [PI_PRIMARY_VALUE_UNIT_label];
            HELP [PI_PRIMARY_VALUE_UNIT_help];
            CLASS CONTAINED & SERVICE;
            TYPE ENUMERATED(2)
            {
                DEFAULT_VALUE 1342;
                AI_UNIT_LIST
            }
        }

        REDEFINE VARIABLE func2_AI_CHANNEL
        {
            LABEL "AI2 " + [PI_CHANNEL_label];
            HELP [PI_CHANNEL_help];
            CLASS CONTAINED;            
            TYPE ENUMERATED (2)
            {
                SELECT ( meas_type )
                {
                    CASE MEAS_TYPE_PH: AI_CHANNEL_LIST_PH
                    CASE MEAS_TYPE_COND: AI_CHANNEL_LIST_COND
                    CASE MEAS_TYPE_CONDI: AI_CHANNEL_LIST_CONDI
                    CASE MEAS_TYPE_CC: AI_CHANNEL_LIST_CC
                    CASE MEAS_TYPE_OXY: AI_CHANNEL_LIST_OXY
                    //DEFAULT: AI_CHANNEL_LIST
                }
            }
            HANDLING READ & WRITE;
            POST_EDIT_ACTIONS {method_func2_set_default_unit}
        }
    }
}

ARRAY OF VARIABLE refarray_func2_AI_CHANNEL
{
    LABEL "";    
    ELEMENTS
    {
        0, func2_AI_CHANNEL;
        1, func2_AI_CHANNEL;
        2, func2_AI_CHANNEL;
        3, func2_AI_CHANNEL;
        4, func2_AI_CHANNEL;
    }
}

/*
 ####################################
 Configuration vom AI
 ####################################
 */
MENU output_ai2_window
{
    LABEL [LABEL_AI2];
    STYLE WINDOW;
    ITEMS
    {
        meas_type(HIDDEN),
        conf_out_ai2_ident,
        conf_out_ai2_process,
        conf_out_ai2_alarm,
        conf_out_ai2_fail,
        conf_out_ai2_batch
    }
    POST_READ_ACTIONS { method_refresh_ai_channels }
}

MENU out_ai2_value
{
    LABEL [PI_display_measure];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_OUT_SCALE_Units_Index (HIDDEN),
        refarray_func2_AI_CHANNEL[meas_type] (READ_ONLY),
        ROWBREAK,
        func2_AI_OUT_Value (READ_ONLY),
        ROWBREAK,
        func2_AI_OUT_Status_Condensed (READ_ONLY)
    }
}

/* TAG... */
MENU conf_out_ai2_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func2_AI_TAG_DESC,
        func2_AI_STRATEGY,
        func2_AI_ST_REV
    }
}

/* OUT,CHANNEL... */
MENU conf_out_ai2_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        refarray_func2_AI_CHANNEL[meas_type],
        func2_AI_PV_FTIME,
        func2_AI_PV_SCALE_Lower_Value,
        func2_AI_PV_SCALE_Upper_Value,
        func2_AI_OUT_SCALE_Lower_Value,
        func2_AI_OUT_SCALE_Upper_Value,
        //    func2_AI_OUT_SCALE_Units_Index(READ_ONLY),
        func2_AI_OUT_SCALE_Decimal_Point
    }
}

/* Alarm, limits... */
MENU conf_out_ai2_alarm
{
    LABEL TXT_FB_ALARM;
    STYLE GROUP;
    ITEMS
    {
        func2_AI_HI_HI_LIM,
        func2_AI_HI_LIM,
        func2_AI_LO_LIM,
        func2_AI_LO_LO_LIM,
        func2_AI_ALARM_HYS
    }
}

/* fail safe... */
MENU conf_out_ai2_fail
{
    LABEL TXT_FB_FAIL;
    STYLE GROUP;
    ITEMS
    {
        func2_AI_FSAFE_TYPE,
        func2_AI_FSAFE_VALUE
    }
}

/* Batch.. */
MENU conf_out_ai2_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func2_AI_BATCH_Batch_ID,
        func2_AI_BATCH_Rup,
        func2_AI_BATCH_Operation,
        func2_AI_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_ai2_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func2_AI_TARGET_MODE,
        func2_AI_MODE_BLK_Actual,
        func2_AI_SIMULATE_Enabled,
        func2_AI_SIMULATE_Value,
        func2_AI_SIMULATE_Status_Condensed
    }
}

MENU out_ai2_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_MODE_BLK_Actual,
        ROWBREAK ,
        func2_AI_SIMULATE_Enabled (READ_ONLY)
    }
}

MENU simulation_window_ai2
{
    LABEL [LABEL_AI2];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
        func2_AI_OUT_SCALE_Units_Index (HIDDEN),

        func2_AI_CHANNEL (READ_ONLY),
        simulation_wnd_ai2_input,
        simulation_wnd_ai2_output
    }
}
MENU simulation_wnd_ai2_input
{
    LABEL TXT_AI_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func2_AI_SIMULATE_Enabled,
        func2_AI_SIMULATE_Value,
        func2_AI_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_ai2_output
{
    LABEL TXT_AI_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func2_AI_TARGET_MODE,
        func2_AI_MODE_BLK_Actual,
        func2_AI_OUT_Value,
        func2_AI_OUT_Status_Condensed
    }
}
/*
 ####################################
 Diagnose vom AI
 ####################################
 */
MENU output_ai2_diag_window
{
    LABEL "Output AI2";
    STYLE WINDOW;
    ITEMS
    {
        diag_out_ai2_alarm
    }
}

/* Alarms... */
MENU diag_out_ai2_alarm
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        func2_AI_ALARM_SUM_Current,
        func2_AI_ALARM_SUM_Unacknowledged,
        func2_AI_ALARM_SUM_Unreported,
        func2_AI_ALARM_SUM_Disabled,
        func2_AI_HI_HI_ALM_Unacknowledged,
        func2_AI_HI_HI_ALM_Alarm_State,
        //func2_AI_HI_HI_ALM_Time_Stamp,
        func2_AI_HI_HI_ALM_Subcode,
        func2_AI_HI_HI_ALM_Value,
        /* -------------------------- */
        func2_AI_HI_ALM_Unacknowledged,
        func2_AI_HI_ALM_Alarm_State,
        // func2_AI_HI_ALM_Time_Stamp,
        func2_AI_HI_ALM_Subcode,
        func2_AI_HI_ALM_Value,
        /* -------------------------- */
        func2_AI_LO_ALM_Unacknowledged,
        func2_AI_LO_ALM_Alarm_State,
        // func2_AI_LO_ALM_Time_Stamp,
        func2_AI_LO_ALM_Subcode,
        func2_AI_LO_ALM_Value,
        /* -------------------------- */
        func2_AI_LO_LO_ALM_Unacknowledged,
        func2_AI_LO_LO_ALM_Alarm_State,
        // func2_AI_LO_LO_ALM_Time_Stamp,
        func2_AI_LO_LO_ALM_Subcode,
        func2_AI_LO_LO_ALM_Value
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

SOURCE ai2_value_source
{
    LABEL [LABEL_AI2];
    Y_AXIS func2_AI_Display_BarVal_out_axis_mandatory_B;
    MEMBERS
    {
        PRIM_VAL, func2_AI_OUT_Value;
    }
}

CHART ai2_value_chart
{
    LABEL "AI2 Value";
    TYPE HORIZONTAL_BAR;    //GAUGE;
    MEMBERS {CHART1, ai2_value_source;}
}

/* Messwerte */
MENU display_out_func2_AI
{
    LABEL [LABEL_AI2];
    ITEMS 
    {
        meas_type (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
        
        out_ai2_value,
        ROWBREAK,
        out_ai2_simu,
        ROWBREAK,
        out_ai2_alarms
    }
}
MENU func2_AI_ovw
{
    LABEL [LABEL_AI2];
    STYLE GROUP;
    ITEMS 
    {
        meas_type (HIDDEN),        
        func2_AI_OUT_SCALE_Units_Index (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
                
        func2_AI_CHANNEL (READ_ONLY),
        func2_AI_OUT_Value,        
        func2_AI_OUT_Status_Condensed
    }
}

/* Alarme */

MENU out_ai2_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_ALARM_SUM_Current
    }
}

MENU overview_ai2_alarms
{
    LABEL [LABEL_AI2];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_ALARM_SUM_Current
        /*
        ,
        COLUMNBREAK,
        func2_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func2_AI_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func2_AI_ALARM_SUM_Disabled        
        */
    }
}

//MENU OnlineWindow_S_alarm_func2_AI
MENU Win_alarm_func2_AI
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        alarm_sum_func2_AI,
        alarm_hi_hi_alm_func2_AI,
        alarm_hi_alm_func2_AI,
        alarm_lo_alm_func2_AI,
        alarm_lo_lo_alm_func2_AI
    }
}

MENU alarm_sum_func2_AI
{
    LABEL [PI_ALARM_SUM_label];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_ALARM_SUM_Current,
        func2_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func2_AI_ALARM_SUM_Unreported,
        func2_AI_ALARM_SUM_Disabled
    }
}

MENU alarm_hi_hi_alm_func2_AI
{
    LABEL [PI_HI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_HI_HI_ALM_Unacknowledged,
        func2_AI_HI_HI_ALM_Alarm_State,
        //func2_AI_HI_HI_ALM_Time_Stamp,
        func2_AI_HI_HI_ALM_Subcode,
        func2_AI_HI_HI_LIM (READ_ONLY),
        func2_AI_HI_HI_ALM_Value
    }
}

MENU alarm_hi_alm_func2_AI
{
    LABEL [PI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_HI_ALM_Unacknowledged,
        func2_AI_HI_ALM_Alarm_State,
        //func2_AI_HI_ALM_Time_Stamp,
        func2_AI_HI_ALM_Subcode,
        func2_AI_HI_LIM (READ_ONLY),
        func2_AI_HI_ALM_Value
    }
}

MENU alarm_lo_alm_func2_AI
{
    LABEL [PI_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_LO_ALM_Unacknowledged,
        func2_AI_LO_ALM_Alarm_State,
        //func2_AI_LO_ALM_Time_Stamp,
        func2_AI_LO_ALM_Subcode,
        func2_AI_LO_LIM (READ_ONLY),
        func2_AI_LO_ALM_Value
    }
}

MENU alarm_lo_lo_alm_func2_AI
{
    LABEL [PI_LO_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func2_AI_LO_LO_ALM_Unacknowledged,
        func2_AI_LO_LO_ALM_Alarm_State,
        //func2_AI_LO_LO_ALM_Time_Stamp,
        func2_AI_LO_LO_ALM_Subcode,
        func2_AI_LO_LO_LIM (READ_ONLY),
        func2_AI_LO_LO_ALM_Value
    }
}

METHOD method_func2_set_default_unit
{
    LABEL "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    DEFINITION {func2_AI_OUT_SCALE_Units_Index = method_set_default_unit(func2_AI_CHANNEL);}
}

UNIT func2_AI_OUT_SCALE_unit_x
{
    func2_AI_OUT_SCALE_Units_Index:            
    func2_AI_SIMULATE_Value
}
