
//-------------------------------------------------------------------------------------------------
// Structure of this file:
//-------------------------------------------------------------------------------------------------
//    Macros
//		Configuration
//    Up-/Download List
//		BLOCK
//    VARIABLE (Standard Parameter)
//    VARIABLE (AO Parameter)
//    COMMAND (Standard Parameter)
//    COMMAND (AO Parameter)
//    UNIT
//		COLLECTION
//		MENU
//    MENU (Alarm)
//    MENU (Diagnosis)
//    MENU (Simulation)
//    MENU (Parameter Table)

//-------------------------------------------------------------------------------------------------
//    Macros
//-------------------------------------------------------------------------------------------------

#ifndef FLOAT_MIN
    #define	FLOAT_MIN	-3.4E+38
    #define	FLOAT_MAX	 3.4E+38
#endif


#define DEF_DISPLAY_FORMAT_FUNC1_AO_SCALE(value, point)			\
        IF( (value > 999999999) || (value < -999999999) )			\
        {																			\
            SELECT(point)														\
            {																		\
                CASE 0:		".1g";											\
                CASE 1:		".2g";											\
                CASE 2:		".3g";											\
                CASE 3:		".4g";											\
                CASE 4:		".5g";											\
                CASE 5:		".6g";											\
                CASE 6:		".7g";											\
                CASE 7:		".8g";											\
                DEFAULT:	  "8.4g"; 											\
            }																		\
        }																			\
        ELSE																		\
        {																			\
            SELECT(point)														\
            {																		\
                CASE 0:		".0f";											\
                CASE 1:		".1f";											\
                CASE 2:		".2f";											\
                CASE 3:		".3f";											\
                CASE 4:		".4f";											\
                CASE 5:		".5f";											\
                CASE 6:		".6f";											\
                CASE 7:		".7f";											\
                DEFAULT:	  "7.4f";											\
            }																		\
        }


//-------------------------------------------------------------------------------------------------
//    Configuration
//-------------------------------------------------------------------------------------------------

#ifndef FUNC1_AO_TITLE
    #define FUNC1_AO_TITLE [func1_AO]
#endif


#ifndef DEFAULT_VALUE_func1_AO_upper_range_value
    #define DEFAULT_VALUE_func1_AO_upper_range_value	100.0
#endif


#ifndef DEFAULT_VALUE_func1_AO_lower_range_value
    #define DEFAULT_VALUE_func1_AO_lower_range_value	0.0
#endif


#ifndef DEFAULT_VALUE_func1_AO_unit
    #define DEFAULT_VALUE_func1_AO_unit						1243	// mV
#endif


#ifndef DEFAULT_VALUE_func1_AO_decimal_point
    #define DEFAULT_VALUE_func1_AO_decimal_point			0
#endif



//-------------------------------------------------------------------------------------------------
//    Up-/Download List
//-------------------------------------------------------------------------------------------------

#define FUNC1_AO_LOAD_TO_DEVICE										\
                func1_AO_tag_desc,	  								\
                func1_AO_batch_id,									\
                func1_AO_batch_unit,								\
                func1_AO_batch_operation,							\
                func1_AO_batch_phase,								\
                func1_AO_pv_upper_range_value,						\
                func1_AO_pv_lower_range_value,						\
                func1_AO_pv_unit,									\
                func1_AO_pv_decimal_point,							\
                func1_AO_fsafe_time,								\
                func1_AO_fsafe_type,								\
                func1_AO_fsafe_value,							 	\
                func1_AO_out_upper_range_value,						\
                func1_AO_out_lower_range_value,						\
                func1_AO_out_unit,									\
                func1_AO_out_decimal_point

#define FUNC1_AO_LOAD_TO_PC											\
                FUNC1_AO_LOAD_TO_DEVICE								\
                func1_AO_st_rev


//-------------------------------------------------------------------------------------------------
//    BLOCK
//-------------------------------------------------------------------------------------------------

BLOCK func1_AO_block
{
    TYPE		FUNCTION;
    NUMBER	FUNC1_AO_BLOCKNUMBER;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- AO 00 : BLOCK_OBJECT ------------------------------------------------------------------------

func1_AO_blk_reserve  				LIKE VARIABLE	phys_blk_reserve
{
}


func1_AO_blk_object	  				LIKE VARIABLE	phys_blk_object
{
    REDEFINE	TYPE	ENUMERATED(1)
    {
        DEFAULT_VALUE    2;
        {	2,	[blk_block_object_FUNCTION]	}
    }
}


func1_AO_blk_parent_class	  		LIKE VARIABLE	phys_blk_parent_class
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {	2,	[func_blk_parent_class_OUTPUT]	}
    }
}


func1_AO_blk_class	  				LIKE VARIABLE	phys_blk_class
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE    1;
        {	1,	[func_blk_class_AO]		}
    }
}


func1_AO_blk_dd_reference	  		LIKE VARIABLE	phys_blk_dd_reference
{
}


func1_AO_blk_dd_rev			  		LIKE VARIABLE	phys_blk_dd_rev
{
}


func1_AO_blk_profile  				LIKE VARIABLE	phys_blk_profile
{
}


func1_AO_blk_profile_rev	  		LIKE VARIABLE	phys_blk_profile_rev
{
}


func1_AO_blk_execution_time	  	LIKE VARIABLE	phys_blk_execution_time
{
}


func1_AO_blk_num_parameters	  	LIKE VARIABLE	phys_blk_num_parameters
{
}


func1_AO_blk_index_view	  			LIKE VARIABLE	phys_blk_index_view_1
{
}


func1_AO_blk_num_view_lists	  	LIKE VARIABLE	phys_blk_num_view_lists
{
}


//--- AO 01 : ST_REV ------------------------------------------------------------------------------

func1_AO_st_rev		  				LIKE VARIABLE	phys_st_rev
{
}


//--- AO 02 : TAG_DESC ----------------------------------------------------------------------------

func1_AO_tag_desc	  					LIKE VARIABLE	phys_tag_desc
{
}


//--- AO 03 : STRATEGY ----------------------------------------------------------------------------

func1_AO_strategy	  					LIKE VARIABLE	phys_strategy
{
}


//--- AO 04 : ALERT_KEY ---------------------------------------------------------------------------

func1_AO_alert_key	  				LIKE VARIABLE	phys_alert_key
{
}


//--- AO 05 : TARGET_MODE -------------------------------------------------------------------------

func1_AO_target_mode  				LIKE VARIABLE	phys_target_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
//		{	BLOCK_MODE_RCAS,				[mode_RCAS]					},
        {	BLOCK_MODE_AUTO,				[mode_AUTO]					},
        {	BLOCK_MODE_MAN,				[mode_MAN]					},
//		{	BLOCK_MODE_LO,					[mode_LO]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,	[mode_OUT_OF_SERVICE]	}
    }
}


//--- AO 06 : MODE_BLK ----------------------------------------------------------------------------

func1_AO_actual_mode  				LIKE VARIABLE	phys_actual_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
//		{	BLOCK_MODE_RCAS,				[mode_RCAS]					},
        {	BLOCK_MODE_AUTO,				[mode_AUTO]					},
        {	BLOCK_MODE_MAN,				[mode_MAN]					},
//		{	BLOCK_MODE_LO,					[mode_LO]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,	[mode_OUT_OF_SERVICE]	}
    }
    REDEFINE POST_READ_ACTIONS
    {
        method_func1_AO_set_global_simulation
    }
}


func1_AO_permitted_mode  			LIKE VARIABLE	phys_permitted_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	(BLOCK_MODE_AUTO | BLOCK_MODE_MAN | BLOCK_MODE_OUT_OF_SERVICE);	// 0xA8
//		{	BLOCK_MODE_RCAS,				[mode_RCAS]					},
        {	BLOCK_MODE_AUTO,				[mode_AUTO]					},
        {	BLOCK_MODE_MAN,				[mode_MAN]					},
//		{	BLOCK_MODE_LO,					[mode_LO]					},
        {	BLOCK_MODE_OUT_OF_SERVICE,	[mode_OUT_OF_SERVICE]	}
    }
}


func1_AO_normal_mode  				LIKE VARIABLE	phys_normal_mode
{
    REDEFINE TYPE	ENUMERATED (1)
    {
        DEFAULT_VALUE	BLOCK_MODE_AUTO;
        {	BLOCK_MODE_AUTO,			 	[mode_AUTO]					}
    }
}


//--- AO 07 : ALARM_SUM ---------------------------------------------------------------------------

func1_AO_current_state_alarm_sum  				LIKE VARIABLE	phys_current_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


func1_AO_unacknowledged_state_alarm_sum		LIKE VARIABLE	phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


func1_AO_unreported_state_alarm_sum  			LIKE VARIABLE	phys_unreported_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


func1_AO_disabled_state_alarm_sum  				LIKE VARIABLE	phys_disabled_state_alarm_sum
{
    REDEFINE TYPE		BIT_ENUMERATED (2)
    {
        {	0x0000,	[limit_state_NO_ALARM]	},
        {	0x0200,	[limit_state_HI_HI]		},
        {	0x0400,	[limit_state_HI]			},
        {	0x0800,	[limit_state_LO_LO]		},
        {	0x1000,	[limit_state_LO]			}
//		{	0x8000,	[limit_state_ST_REV]		}
    }
//	REDEFINE STYLE "MULTILINE 12 5" ;
    REDEFINE STYLE "MULTILINE 12 4" ;
}


//--- AO 08 : BATCH -------------------------------------------------------------------------------

VARIABLE func1_AO_batch_id
{
    LABEL		[func_batch_id];
    HELP		[func_batch_id_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_batch_unit
{
    LABEL		[func_batch_unit];
    HELP		[func_batch_unit_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_batch_operation
{
    LABEL		[func_batch_operation];
    HELP		[func_batch_operation_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_batch_phase
{
    LABEL		[func_batch_phase];
    HELP		[func_batch_phase_help];
    CLASS		CONTAINED;
    TYPE		UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE	0;
    }
    HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    VARIABLE (AO Parameter)
//-------------------------------------------------------------------------------------------------

//--- AO 09 : SP ----------------------------------------------------------------------------------

VARIABLE func1_AO_sp_value
{
    LABEL		[func_ao_setpoint_value];
    HELP		[func_ao_setpoint_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
    }
    HANDLING	READ & WRITE;
}

VARIABLE func1_AO_sp_status_quality
{
    LABEL		[status_quality];
    HELP		[func_ao_setpoint_status_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        STATUS_QUALITY_CODES
    }
    HANDLING	READ & WRITE;
    POST_EDIT_ACTIONS
    {
        method_set_status_limit
    }
}


func1_AO_sp_status_limit					LIKE VARIABLE	func1_AO_sp_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        STATUS_INPUT_LIMIT(func1_AO_sp_status_quality)
    }
}


//--- AO 11 : PV_SCALE ----------------------------------------------------------------------------

VARIABLE func1_AO_pv_upper_range_value
{
    LABEL		[func_pv_scale_upper_value];
    HELP		[func_pv_scale_upper_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func1_AO_upper_range_value;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC1_AO_SCALE(func1_AO_pv_upper_range_value, func1_AO_pv_unit)
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_pv_lower_range_value
{
    LABEL		[func_pv_scale_lower_value];
    HELP		[func_pv_scale_lower_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE DEFAULT_VALUE_func1_AO_lower_range_value;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC1_AO_SCALE(func1_AO_pv_lower_range_value, func1_AO_pv_unit)
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_pv_unit
{
    LABEL		[func_pv_scale_unit];
    HELP		[func_pv_scale_unit_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (2)
    {
        DEFAULT_VALUE DEFAULT_VALUE_func1_AO_unit;
        FUNC1_AO_UNIT_LIST
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_pv_decimal_point
{
    LABEL		[decimal_point];
    HELP		[decimal_point_help];
    CLASS		CONTAINED;
    TYPE		INTEGER (1)
    {
        DEFAULT_VALUE	DEFAULT_VALUE_func1_AO_decimal_point;
        {	0,   "0"		},
        {	1,   "1"		},
        {	2,   "2"		},
        {	3,   "3"		}
    }
    HANDLING	READ & WRITE;
}


//--- AO 12 : READBACK ----------------------------------------------------------------------------

VARIABLE func1_AO_readback_value
{
    LABEL		[func_ao_readback_value];
    HELP		[func_ao_readback_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
    }
    HANDLING	READ;
}


func1_AO_readback_status_quality  		LIKE VARIABLE	func1_AO_out_status_quality
{
    REDEFINE HANDLING READ;
}


func1_AO_readback_status_limit  			LIKE VARIABLE	func1_AO_readback_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}


//--- AO 21 : IN_CHANNEL --------------------------------------------------------------------------

VARIABLE func1_AO_in_channel
{
    LABEL		[func_channel];
    HELP		[func_channel_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (2)
    {
        DEFAULT_VALUE			0x0000;
        { 0x0000,	"not used"	}
    }
    HANDLING	READ & WRITE;
}


//--- AO 22 : OUT_CHANNEL -------------------------------------------------------------------------

func1_AO_out_channel							LIKE VARIABLE	func1_AO_in_channel
{
//	REDEFINE TYPE		UNSIGNED_INTEGER (2)
//	{
//		DEFAULT_VALUE	0x0139;
//	}
}

//--- AO 23 : FSAFE_TIME --------------------------------------------------------------------------

VARIABLE func1_AO_fsafe_time
{
    LABEL		[func_ao_fsafe_time];
    HELP		[func_ao_fsafe_time_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
        MIN_VALUE		0.0;
        MAX_VALUE		6000.0;
    }
    CONSTANT_UNIT	[sec];
    HANDLING	READ & WRITE;
}


//--- AO 24 : FSAFE_TYPE --------------------------------------------------------------------------

VARIABLE func1_AO_fsafe_type
{
    LABEL		[func_ao_fsafe_type];
    HELP		[func_ao_fsafe_type_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[func_ao_fsafe_type_FAIL_SAFE_VALUE]			},
        {	1,	[func_ao_fsafe_type_STORING_LAST_SETPOINT]	},
//		{	2,	[func_ao_fsafe_type_FAIL_SAFE_POSITION]		}
        {   2,  "The value is passed without change""|de|Schlechten Wert ohne nderung weitergeben" }
    }
    HANDLING	READ & WRITE;
}


//--- AO 25 : FSAFE_VALUE -------------------------------------------------------------------------

VARIABLE func1_AO_fsafe_value
{
    LABEL		[func_ao_fsafe_value];
    HELP		[func_ao_fsafe_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
    }
    HANDLING	READ & WRITE;
   VALIDITY	IF (func1_AO_fsafe_type == 0)
                {
                    TRUE;
                }
                ELSE
                {
                    FALSE;
                }
}


//--- AO 31 : POS_D -------------------------------------------------------------------------------

VARIABLE func1_AO_pos_d_value
{
    LABEL		[func_ao_position_discrete_value];
    HELP		[func_ao_position_discrete_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		UNSIGNED_INTEGER (1)
    {
        DEFAULT_VALUE 0;
    }
    HANDLING	READ;
}

VARIABLE func1_AO_pos_d_status_quality
{
    LABEL		[status_quality];
    HELP		[func_ao_position_discrete_status_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING	READ;
}

func1_AO_pos_d_status_limit		LIKE VARIABLE	func1_AO_pos_d_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

#define CB_FAIL_SAFE			0x00010000		/* Bit  0 */
#define CB_REQ_LOC_OP		0x00020000		/* Bit  1 */
#define CB_LOCAL_OP			0x00040000		/* Bit  2 */
#define CB_OVERRIDE			0x00080000		/* Bit  3 */
#define CB_DISC_DIR			0x00100000		/* Bit  4 */
#define CB_TORQUE_D_OP		0x00200000		/* Bit  5 */
#define CB_TORQUE_D_CL		0x00400000		/* Bit  6 */
#define CB_TRAV_TIME			0x00800000		/* Bit  7 */
#define CB_ACT_OPEN			0x00000100		/* Bit  8 */
#define CB_ACT_CLOSE			0x00000200		/* Bit  9 */
#define CB_UPDATE_EVT		0x00000400		/* Bit 10 */
#define CB_SIMULATE			0x00000800		/* Bit 11 */
#define CB_DISTURBANCE		0x00001000		/* Bit 12 */
#define CB_CONTR_ERR			0x00002000		/* Bit 13 */
#define CB_CONTR_INACT		0x00004000		/* Bit 14 */
#define CB_SELFTEST			0x00008000		/* Bit 15 */
#define CB_TOT_VALVE_TRAV	0x00000001		/* Bit 16 */


//--- AO 33 : CHECK_BACK --------------------------------------------------------------------------

VARIABLE func1_AO_check_back
{
    LABEL		[func_check_back];
    HELP		[func_check_back_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		BIT_ENUMERATED (3)
    {
        {	0,							[dia_OK],				[dia_OK_help]					},
        {	CB_FAIL_SAFE,			[cb_FAIL_SAFE],		[cb_FAIL_SAFE_help]			},
        {	CB_REQ_LOC_OP,			[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]			},
        {	CB_LOCAL_OP,			[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
        {	CB_OVERRIDE,			[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
        {	CB_DISC_DIR,			[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
        {	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
        {	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
        {	CB_TRAV_TIME,			[cb_TRAV_TIME],		[cb_TRAV_TIME_help]			},
        {	CB_ACT_OPEN,			[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
        {	CB_ACT_CLOSE,			[cb_ACT_CLOSE],		[cb_ACT_CLOSE_help]			},
        {	CB_UPDATE_EVT,			[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]			},
        {	CB_SIMULATE,			[cb_SIMULATE],			[cb_SIMULATE_help]			},
        {	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
        {	CB_CONTR_ERR,			[cb_CONTR_ERR],		[cb_CONTR_ERR_help]			},
        {	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
        {	CB_SELFTEST,			[cb_SELFTEST],			[cb_SELFTEST_help]			},
        {	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
    }
    HANDLING	READ;
}


//--- AO 34 : CHECK_BACK_MASK ---------------------------------------------------------------------

VARIABLE func1_AO_check_back_mask
{
    LABEL		[func_check_back_mask];
    HELP		[func_check_back_mask_help];
    CLASS		CONTAINED;
    TYPE		BIT_ENUMERATED (3)
    {
        {	CB_FAIL_SAFE,			[cb_FAIL_SAFE],		[cb_FAIL_SAFE_help]			},
        {	CB_REQ_LOC_OP,			[cb_REQ_LOC_OP],		[cb_REQ_LOC_OP_help]			},
        {	CB_LOCAL_OP,			[cb_LOCAL_OP],			[cb_LOCAL_OP_help]			},
        {	CB_OVERRIDE,			[cb_OVERRIDE],			[cb_OVERRIDE_help]			},
        {	CB_DISC_DIR,			[cb_DISC_DIR],			[cb_DISC_DIR_help]			},
        {	CB_TORQUE_D_OP,		[cb_TORQUE_D_OP],		[cb_TORQUE_D_OP_help]		},
        {	CB_TORQUE_D_CL,		[cb_TORQUE_D_CL],		[cb_TORQUE_D_CL_help]		},
        {	CB_TRAV_TIME,			[cb_TRAV_TIME],		[cb_TRAV_TIME_help]			},
        {	CB_ACT_OPEN,			[cb_ACT_OPEN],			[cb_ACT_OPEN_help]			},
        {	CB_ACT_CLOSE,			[cb_ACT_CLOSE],		[cb_ACT_CLOSE_help]			},
        {	CB_UPDATE_EVT,			[cb_UPDATE_EVT],		[cb_UPDATE_EVT_help]			},
        {	CB_SIMULATE,			[cb_SIMULATE],			[cb_SIMULATE_help]			},
        {	CB_DISTURBANCE,		[cb_DISTURBANCE],		[cb_DISTURBANCE_help]		},
        {	CB_CONTR_ERR,			[cb_CONTR_ERR],		[cb_CONTR_ERR_help]			},
        {	CB_CONTR_INACT,		[cb_CONTR_INACT],		[cb_CONTR_INACT_help]		},
        {	CB_SELFTEST,			[cb_SELFTEST],			[cb_SELFTEST_help]			},
        {	CB_TOT_VALVE_TRAV,	[cb_TOT_VALVE_TRAV],	[cb_TOT_VALVE_TRAV_help]	}
    }
    HANDLING	READ;
}

//--- AO 35 : SIMULATE ----------------------------------------------------------------------------

VARIABLE func1_AO_simulate_value
{
    LABEL		[func_simulate_value];
    HELP		[func_ao_simulate_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_simulate_status_quality
{
    LABEL		[status_quality];
    HELP		[func_simulate_status_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x20;
        STATUS_INPUT_NO_RCAS
    }
    HANDLING	READ & WRITE;
    POST_EDIT_ACTIONS
    {
        method_set_status_limit
    }
}


func1_AO_simulate_status_limit				LIKE VARIABLE	func1_AO_simulate_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0x00;
        STATUS_INPUT_LIMIT(func1_AO_simulate_status_quality)
    }
}


VARIABLE func1_AO_simulation_enabled
{
    LABEL		[func_simulation_enabled];
    HELP		[func_simulation_enabled_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[disabled]		},
        {	1,	[enabled]		}
    }
    HANDLING READ & WRITE;
    POST_READ_ACTIONS
    {
        method_func1_AO_set_global_simulation
    }
}


//--- AO 36 : INCREASE_CLOSE --------------------------------------------------------------------

VARIABLE func1_AO_increase_close
{
    LABEL		[func_ao_increase_close];
    HELP		[func_ao_increase_close_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        {	0,	[func_ao_increase_close_RISING]		},
        {	1,	[func_ao_increase_close_FALLING]		}
    }
    HANDLING	READ & WRITE;
}


//--- AO 37 : OUT -------------------------------------------------------------------------------

VARIABLE func1_AO_out_value
{
    LABEL		[func_out_value];
    HELP		[func_ao_out_value_help];
    CLASS		CONTAINED & DYNAMIC;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	0.0;
    }
    HANDLING
        IF (func1_AO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


func1_AO_out_status_quality	  			LIKE VARIABLE	func1_AO_sp_status_quality
{
    REDEFINE TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        FUNC_AO_OUT_STATUS_QUALITY_CODES
    }
    REDEFINE HANDLING
        IF (func1_AO_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}


func1_AO_out_status_limit  				LIKE VARIABLE	func1_AO_out_status_quality
{
    REDEFINE LABEL		[status_limit];
    REDEFINE TYPE		ENUMERATED (1)
    {
        IF (func1_AO_target_mode == BLOCK_MODE_MAN)
        {
            STATUS_INPUT_LIMIT(func1_AO_out_status_quality)
        }
        ELSE
        {
            STATUS_OUTPUT_LIMIT
        }
    }
}


//--- AO 38 : OUT_SCALE -------------------------------------------------------------------------

VARIABLE func1_AO_out_upper_range_value
{
    LABEL		[func_out_scale_upper_value];
    HELP		[func_out_scale_upper_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	DEFAULT_VALUE_func1_AO_upper_range_value;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC1_AO_SCALE(func1_AO_out_upper_range_value, func1_AO_out_unit)
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_out_lower_range_value
{
    LABEL		[func_out_scale_lower_value];
    HELP		[func_out_scale_lower_value_help];
    CLASS		CONTAINED;
    TYPE		FLOAT
    {
        DEFAULT_VALUE	DEFAULT_VALUE_func1_AO_lower_range_value;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT_FUNC1_AO_SCALE(func1_AO_out_lower_range_value, func1_AO_out_unit)
    }
    HANDLING	READ & WRITE;
}


VARIABLE func1_AO_out_unit
{
    LABEL		[func_out_scale_unit];
    HELP		[func_out_scale_unit_help];
    CLASS		CONTAINED;
    TYPE		ENUMERATED (2)
    {
        DEFAULT_VALUE DEFAULT_VALUE_func1_AO_unit;
        FUNC1_AO_UNIT_LIST
    }
    HANDLING	READ & WRITE;
}


func1_AO_out_decimal_point						LIKE VARIABLE	func1_AO_pv_decimal_point
{
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (Standard Parameter)
//-------------------------------------------------------------------------------------------------

//--- AO 00 : BLOCK_OBJECT ------------------------------------------------------------------------

COMMAND read_func1_AO_blk
{
    BLOCK func1_AO_block;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_blk_reserve,
            func1_AO_blk_object,
            func1_AO_blk_parent_class,
            func1_AO_blk_class,
            func1_AO_blk_dd_reference,
            func1_AO_blk_dd_rev,
            func1_AO_blk_profile,
            func1_AO_blk_profile_rev,
            func1_AO_blk_execution_time,
            func1_AO_blk_num_parameters,
            func1_AO_blk_index_view,
            func1_AO_blk_num_view_lists
        }
    }
}


//--- AO 01 : ST_REV ------------------------------------------------------------------------------

COMMAND read_func1_AO_st_rev
{
    BLOCK func1_AO_block;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_st_rev
        }
    }
}


//--- AO 02 : TAG_DESC ----------------------------------------------------------------------------

COMMAND read_func1_AO_tag_desc
{
    BLOCK func1_AO_block;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_tag_desc
        }
    }
}


COMMAND write_func1_AO_tag_desc
{
    BLOCK func1_AO_block;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_tag_desc
        }
        REPLY
        {
        }
    }
}


//--- AO 03 : STRATEGY ----------------------------------------------------------------------------

COMMAND read_func1_AO_strategy
{
    BLOCK func1_AO_block;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_strategy
        }
    }
}


COMMAND write_func1_AO_strategy
{
    BLOCK func1_AO_block;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_strategy
        }
        REPLY
        {
        }
    }
}


//--- AO 04 : ALERT_KEY ---------------------------------------------------------------------------

COMMAND read_func1_AO_alert_key
{
    BLOCK func1_AO_block;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_alert_key
        }
    }
}


COMMAND write_func1_AO_alert_key
{
    BLOCK func1_AO_block;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_alert_key
        }
        REPLY
        {
        }
    }
}


//--- AO 05 : TARGET_MODE -------------------------------------------------------------------------

COMMAND read_func1_AO_target_mode
{
    BLOCK func1_AO_block;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_target_mode
        }
    }
}


COMMAND write_func1_AO_target_mode
{
    BLOCK func1_AO_block;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_target_mode
        }
        REPLY
        {
        }
    }
}


//--- AO 06 : MODE_BLK ----------------------------------------------------------------------------

COMMAND read_func1_AO_mode
{
    BLOCK func1_AO_block;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
             func1_AO_actual_mode,
             func1_AO_permitted_mode,
             func1_AO_normal_mode
        }
    }
}


//--- AO 07 : ALARM_SUM ---------------------------------------------------------------------------

COMMAND read_func1_AO_alarm
{
    BLOCK func1_AO_block;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_current_state_alarm_sum,
            func1_AO_unacknowledged_state_alarm_sum,
            func1_AO_unreported_state_alarm_sum,
            func1_AO_disabled_state_alarm_sum
        }
    }
}


//--- AO 08 : BATCH -------------------------------------------------------------------------------

COMMAND read_func1_AO_batch_information
{
    BLOCK func1_AO_block;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_batch_id,
            func1_AO_batch_unit,
            func1_AO_batch_operation,
            func1_AO_batch_phase
        }
    }
}


COMMAND write_func1_AO_batch_information
{
    BLOCK func1_AO_block;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_batch_id,
            func1_AO_batch_unit,
            func1_AO_batch_operation,
            func1_AO_batch_phase
        }
        REPLY
        {
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (AO Parameter)
//-------------------------------------------------------------------------------------------------

//--- AO 09 : SP ----------------------------------------------------------------------------------

COMMAND read_func1_AO_sp
{
    BLOCK func1_AO_block;
    INDEX 9;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_sp_value,
            func1_AO_sp_status_quality		<0xFC>,
            func1_AO_sp_status_limit		<0x03>
        }
    }
}


COMMAND write_func1_AO_sp
{
    BLOCK func1_AO_block;
    INDEX 9;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_sp_value,
            func1_AO_sp_status_quality		<0xFC>,
            func1_AO_sp_status_limit		<0x03>
        }
        REPLY
        {
        }
    }
}


//--- AO 12 : READBACK ----------------------------------------------------------------------------

COMMAND read_func1_AO_pv
{
    BLOCK func1_AO_block;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_pv_upper_range_value,
            func1_AO_pv_lower_range_value,
            func1_AO_pv_unit,
            func1_AO_pv_decimal_point
        }
    }
}

COMMAND write_func1_AO_pv
{
    BLOCK func1_AO_block;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_pv_upper_range_value,
            func1_AO_pv_lower_range_value,
            func1_AO_pv_unit,
            func1_AO_pv_decimal_point
        }
        REPLY
        {
        }
    }
}


//--- AO 12 : READBACK ----------------------------------------------------------------------------

COMMAND read_func1_AO_readback
{
    BLOCK func1_AO_block;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_readback_value,
            func1_AO_readback_status_quality		<0xFC>,
            func1_AO_readback_status_limit		<0x03>
        }
    }
}


//--- AO 21 : IN_CHANNEL --------------------------------------------------------------------------

COMMAND read_func1_AO_in_channel
{
    BLOCK func1_AO_block;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_in_channel
        }
    }
}


COMMAND write_func1_AO_in_channel
{
    BLOCK func1_AO_block;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_in_channel
        }
        REPLY
        {
        }
    }
}


//--- AO 22 : OUT_CHANNEL -------------------------------------------------------------------------

COMMAND read_func1_AO_out_channel
{
    BLOCK func1_AO_block;
    INDEX 22;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_out_channel
        }
    }
}


COMMAND write_func1_AO_out_channel
{
    BLOCK func1_AO_block;
    INDEX 22;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_out_channel
        }
        REPLY
        {
        }
    }
}


//--- AO 23 : FSAFE_TIME --------------------------------------------------------------------------

COMMAND read_func1_AO_fsafe_time
{
    BLOCK func1_AO_block;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_fsafe_time
        }
    }
}


COMMAND write_func1_AO_fsafe_time
{
    BLOCK func1_AO_block;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_fsafe_time
        }
        REPLY
        {
        }
    }
}


//--- AO 24 : FSAFE_TYPE --------------------------------------------------------------------------

COMMAND read_func1_AO_fsafe_type
{
    BLOCK func1_AO_block;
    INDEX 24;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_fsafe_type
        }
    }
}


COMMAND write_func1_AO_fsafe_type
{
    BLOCK func1_AO_block;
    INDEX 24;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_fsafe_type
        }
        REPLY
        {
        }
    }
}


//--- AO 25 : FSAFE_VALUE -------------------------------------------------------------------------

COMMAND read_func1_AO_fsafe_value
{
    BLOCK func1_AO_block;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_fsafe_value
        }
    }
}


COMMAND write_func1_AO_fsafe_value
{
    BLOCK func1_AO_block;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_fsafe_value
        }
        REPLY
        {
        }
    }
}


//--- AO 31 : POS_D -------------------------------------------------------------------------------

COMMAND read_func1_AO_pos_d
{
    BLOCK func1_AO_block;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_pos_d_value,
            func1_AO_pos_d_status_quality	<0xFC>,
            func1_AO_pos_d_status_limit	<0x03>
        }
    }
}


//--- AO 33 : CHECK_BACK --------------------------------------------------------------------------

COMMAND read_func1_AO_check_back
{
    BLOCK func1_AO_block;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_check_back
        }
    }
}


//--- AO 34 : CHECK_BACK_MASK ---------------------------------------------------------------------

COMMAND read_func1_AO_check_back_mask
{
    BLOCK func1_AO_block;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_check_back_mask
        }
    }
}

//--- AO 35 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func1_AO_simulate
{
    BLOCK func1_AO_block;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_simulate_status_quality		<0xFC>,
            func1_AO_simulate_status_limit		<0x03>,
            func1_AO_simulate_value,
            func1_AO_simulation_enabled
        }
    }
}


COMMAND write_func1_AO_simulate
{
    BLOCK func1_AO_block;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_simulate_status_quality		<0xFC>,
            func1_AO_simulate_status_limit		<0x03>,
            func1_AO_simulate_value,
            func1_AO_simulation_enabled
        }
        REPLY
        {
        }
    }
}

//--- AO 36 : INCREASE_CLOSE ----------------------------------------------------------------------

COMMAND read_func1_AO_increase_close
{
    BLOCK func1_AO_block;
    INDEX 36;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_increase_close
        }
    }
}

COMMAND write_func1_AO_increase_close
{
    BLOCK func1_AO_block;
    INDEX 36;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_increase_close
        }
        REPLY
        {
        }
    }
}

//--- AO 37 : OUT ---------------------------------------------------------------------------------

COMMAND read_func1_AO_out
{
    BLOCK func1_AO_block;
    INDEX 37;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_out_value,
            func1_AO_out_status_quality	<0xFC>,
            func1_AO_out_status_limit		<0x03>

        }
    }
}

COMMAND write_func1_AO_out
{
    BLOCK func1_AO_block;
    INDEX 37;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_out_value,
            func1_AO_out_status_quality	<0xFC>,
            func1_AO_out_status_limit		<0x03>
        }
        REPLY
        {
        }
    }
}

//--- AO 38 : OUT_SCALE ---------------------------------------------------------------------------

COMMAND read_func1_AO_out_scale
{
    BLOCK func1_AO_block;
    INDEX 38;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AO_out_upper_range_value,
            func1_AO_out_lower_range_value,
            func1_AO_out_unit,
            func1_AO_out_decimal_point
        }
    }
}

COMMAND write_func1_AO_out_scale
{
    BLOCK func1_AO_block;
    INDEX 38;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AO_out_upper_range_value,
            func1_AO_out_lower_range_value,
            func1_AO_out_unit,
            func1_AO_out_decimal_point
        }
        REPLY
        {
        }
    }
}




//-------------------------------------------------------------------------------------------------
//    UNIT
//-------------------------------------------------------------------------------------------------

UNIT AO_PV_SCALE_UNIT
{
    func1_AO_pv_unit:

    func1_AO_pv_upper_range_value,
    func1_AO_pv_lower_range_value,
    func1_AO_readback_value,
    func1_AO_sp_value,
    func1_AO_fsafe_value,
    func1_AO_simulate_value
}

UNIT AO_OUT_SCALE_UNIT
{
    func1_AO_out_unit:

    func1_AO_out_value,
    func1_AO_out_upper_range_value,
    func1_AO_out_lower_range_value
}


//-------------------------------------------------------------------------------------------------
//    METHOD
//-------------------------------------------------------------------------------------------------

METHOD method_set_status_limit
{
    LABEL "";
    CLASS         INPUT;
    DEFINITION
    {
        int quality;
        int block_mode;             /* !!! temp.: bis Methoden mit
Aufrufparametern funktionieren !!! */

        quality = ivar_value(func1_AO_sp_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func1_AO_sp_status_limit, 0);

/*fbi        quality = ivar_value(func1_rcas_in_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func1_rcas_in_status_limit, 0); */
        quality = ivar_value(func1_AO_simulate_status_quality);
        if ((quality == 0x20) || (quality == 0x30))
            iassign(func1_AO_simulate_status_limit, 0);

        block_mode      = ivar_value(func1_AO_target_mode);
        quality         = ivar_value(func1_AO_out_status_quality);
        if ((block_mode == BLOCK_MODE_MAN) && ((quality == 0x20) || (quality == 0x30)))
            iassign(func1_AO_out_status_limit, 0);
    }
}



METHOD method_func1_AO_set_global_simulation
{
    LABEL "";
    CLASS		DYNAMIC;
    DEFINITION
    {
        int  simu_ena, man_ena;

        simu_ena	= ivar_value( func1_AO_simulation_enabled );
        man_ena	= ivar_value( func1_AO_actual_mode 			);

        if ( (simu_ena == 1) || (man_ena == 0x10) )
        {
            lokal_global_simulation |= FUNC1_AO_GLOBAL_SIMULATION_MASK;
        }
        else
        {
            lokal_global_simulation &= ~FUNC1_AO_GLOBAL_SIMULATION_MASK;
        }
    }
}


//-------------------------------------------------------------------------------------------------
//    COLLECTION
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

MENU Page_display_func1_AO
{
    LABEL		FUNC1_AO_TITLE;
    ITEMS
    {
#ifdef FUNCX_AO_TAG_IN_PAGE_DISPLAY
        func1_AO_tag_desc							(READ_ONLY),
#endif
        Group_display_out_func1_AO_out,
        Group_display_out_func1_AO_readback,
        Group_display_func1_AO_simulation
    }
}


MENU Group_display_out_func1_AO_out
{
    LABEL		[menu_OnlineWindow_func_AO_display_out_d];
    ITEMS
    {
        func1_AO_out_value						(READ_ONLY),
        SEPARATOR,
        func1_AO_out_status_quality			(READ_ONLY),
        func1_AO_out_status_limit				(READ_ONLY),
    }
}


MENU Group_display_out_func1_AO_readback
{
    LABEL		[menu_OnlineWindow_func_AO_display_readback_d];
    ITEMS
    {
        func1_AO_readback_value					(READ_ONLY),
        SEPARATOR,
        func1_AO_readback_status_quality 	(READ_ONLY),
        func1_AO_readback_status_limit 		(READ_ONLY)
    }
}


MENU Group_display_func1_AO_simulation
{
    LABEL		[menu_OnlineWindow_func_display_simulation];
    ITEMS
    {
        func1_AO_simulation_enabled 		(READ_ONLY),
        SEPARATOR,
        func1_AO_actual_mode 				(READ_ONLY)
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Alarm)
//-------------------------------------------------------------------------------------------------

MENU OnlineWindow_S_alarm_func1_AO
{
    LABEL		FUNC1_AO_TITLE;
    ITEMS
    {
        Page_alarm_sum_func1_AO,
    }
}


MENU OnlineWindow_M_alarm_func1_AO
{
    LABEL		FUNC1_AO_TITLE;
    ITEMS
    {
        Page_alarm_sum_func1_AO,
    }
}


MENU Page_alarm_sum_func1_AO
{
    LABEL		[menu_dialog_alarm_sum];
    ITEMS
    {
        func1_AO_current_state_alarm_sum,
        func1_AO_unacknowledged_state_alarm_sum,
        SEPARATOR,
        func1_AO_unreported_state_alarm_sum,
        func1_AO_disabled_state_alarm_sum
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Diagnosis)
//-------------------------------------------------------------------------------------------------

MENU Page_diagnosis_func1_AO
{
    LABEL		FUNC1_AO_TITLE+THEME_AO;
    ITEMS
    {
        func1_AO_blk_object,
        func1_AO_blk_parent_class,
        func1_AO_blk_class,
        func1_AO_blk_dd_reference,
        func1_AO_blk_dd_rev,
        func1_AO_blk_profile,
        func1_AO_blk_profile_rev,
        func1_AO_st_rev,
        func1_AO_actual_mode
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU OnlineDialog_simulation_func1_AO
{
    LABEL		FUNC1_AO_TITLE;
    ITEMS
    {
        Page_simulation_output_func1_AO,
        Page_simulation_input_func1_AO
    }
}


MENU Page_simulation_input_func1_AO
{
    LABEL		[menu_dialog_AO_simulation_input];
    ITEMS
    {
        func1_AO_simulation_enabled,
        Group_simulate_input_func1_AO,
        method_set
    }
}


MENU Group_simulate_input_func1_AO
{
    LABEL		[func_simulate_value];
    ITEMS
    {
        func1_AO_simulate_value,
        SEPARATOR,
        func1_AO_simulate_status_quality,
        func1_AO_simulate_status_limit
    }
}


MENU Page_simulation_output_func1_AO
{
    LABEL		[menu_dialog_AO_simulation_output];
    ITEMS
    {
        func1_AO_target_mode,
        func1_AO_actual_mode,
        Group_simulate_output_func1_AO,
        method_set
    }
}


MENU Group_simulate_output_func1_AO
{
    LABEL		[func_out_value];
    ITEMS
    {
        func1_AO_out_value,
        SEPARATOR,
        func1_AO_out_status_quality,
        func1_AO_out_status_limit
    }
}


//-------------------------------------------------------------------------------------------------
//    MENU (Parameter table)
//-------------------------------------------------------------------------------------------------

MENU Tab_s_func1_AO
{
    LABEL		FUNC1_AO_TITLE;
    ITEMS
    {
        func1_AO_st_rev,
        func1_AO_tag_desc,
        Tab_s_func1_AO_batch,
        Tab_s_func1_AO_input_pv,
        Tab_s_func1_AO_input_out,
        Tab_s_func1_AO_fsafe
    }
}


MENU Tab_m_func1_AO
{
    LABEL		FUNC1_AO_TITLE;
    ITEMS
    {
        func1_AO_st_rev,
        func1_AO_tag_desc 			(READ_ONLY),
        Tab_s_func1_AO_batch,
        Tab_m_func1_AO_fsafe
    }
}


MENU Tab_s_func1_AO_batch
{
    LABEL		[menu_ident_batch_info];
    ITEMS
    {
            func1_AO_batch_id,
            func1_AO_batch_unit,
            func1_AO_batch_operation,
            func1_AO_batch_phase
    }
}


MENU Tab_s_func1_AO_input_pv
{
    LABEL		[menu_input_input];
    ITEMS
    {
        func1_AO_pv_lower_range_value,
        func1_AO_pv_upper_range_value,
        func1_AO_pv_unit,
        func1_AO_pv_decimal_point,
    }
}


MENU Tab_s_func1_AO_input_out
{
    LABEL		[menu_input_workrange];
    ITEMS
    {
        func1_AO_out_lower_range_value,
        func1_AO_out_upper_range_value,
        func1_AO_out_unit,
        func1_AO_out_decimal_point,
    }
}


MENU Tab_s_func1_AO_fsafe
{
    LABEL [menu_fail_safe] ;
    ITEMS
    {
        func1_AO_fsafe_time,
        func1_AO_fsafe_type,
        func1_AO_fsafe_value
    }
}


MENU Tab_m_func1_AO_fsafe
{
    LABEL [menu_fail_safe] ;
    ITEMS
    {
        func1_AO_fsafe_time			(READ_ONLY),
        func1_AO_fsafe_type			(READ_ONLY),
        func1_AO_fsafe_value			(READ_ONLY)
    }
}

