//-------------------------------------------------------------------------------------------------
//    Alle DIs					                          	 
//-------------------------------------------------------------------------------------------------

// TAG ins Online Window Function Block Ausgnge
#define FUNCX_DI_TAG_IN_PAGE_DISPLAY

#define THEME_DI	" (Status)""|de| (Status)"

//-------------------------------------------------------------------------------------------------
//
//  ####   ###          ##
//  #   #   #          # #
//  #   #   #         #  #
//  #   #   #            #
//  #   #   #            #   
//  #   #   #            #   
//  ####   ###         ####
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDI1_300.ddl" 
//-------------------------------------------------------------------------------------------------

#define FUNC1_DI_TITLE	"Unical"								// (re!)
#define FUNC1_DI_BLOCKNUMBER	7
#define FUNC1_DI_GLOBAL_SIMULATION_MASK	0x00000040

#include "KNPASTDI1_300.ddl"

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

#define HANDLING_FUNC1_DI_BLK_MODE_MAN						\
		IF (func1_DI_target_mode == BLOCK_MODE_MAN)		\
		{																\
			READ & WRITE;											\
		}																\
		ELSE															\
		{																\
			READ;														\
		}


func1_DI_out_value_unical_state				LIKE VARIABLE func3_DO_readback_d_value_unical_state
{
	REDEFINE HANDLING	HANDLING_FUNC1_DI_BLK_MODE_MAN
}


func1_DI_out_value_unical_service_switch	LIKE VARIABLE func3_DO_readback_d_value_unical_service_switch
{
	REDEFINE HANDLING	HANDLING_FUNC1_DI_BLK_MODE_MAN
}


func1_DI_out_value_unical_alarm				LIKE VARIABLE func3_DO_readback_d_value_unical_alarm
{
	REDEFINE HANDLING	HANDLING_FUNC1_DI_BLK_MODE_MAN
}


func1_DI_out_value_unical_prg					LIKE VARIABLE func3_DO_readback_d_value_unical_prg
{
	REDEFINE HANDLING	HANDLING_FUNC1_DI_BLK_MODE_MAN
}


//--- DI 21 : FSAFE_VAL_D -------------------------------------------------------------------------

VARIABLE func1_DI_fsafe_value
{
   LABEL		[func_ai_fsafe_value] ;
   HELP		[func_ai_fsafe_value_help];
   CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    0x01;
		{	0x01,	"MEASURE" "|de|MESSEN"	},
		{	0x02,	"SERVICE" "|de|SERVICE"	}
	}
   HANDLING	READ & WRITE;
   VALIDITY	IF (func1_DI_fsafe_type == FUNC_AI_FAIL_SAFE_VALUE)
   			{
					TRUE;
				}
				ELSE
				{
					FALSE;
				}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

func1_DI_simulate_value_unical_state				LIKE VARIABLE func3_DO_simulate_value_unical_state
{
}


func1_DI_simulate_value_unical_service_switch	LIKE VARIABLE func3_DO_simulate_value_unical_service_switch
{
}


func1_DI_simulate_value_unical_alarm				LIKE VARIABLE func3_DO_simulate_value_unical_alarm
{
}


func1_DI_simulate_value_unical_prg					LIKE VARIABLE func3_DO_simulate_value_unical_prg
{
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DI Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func1_DI_out 
{
	BLOCK func1_DI_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_DI_out_value_unical_prg					<0xE0>, 			
			func1_DI_out_value_unical_alarm				<0x08>,
			func1_DI_out_value_unical_service_switch	<0x04>,
			func1_DI_out_value_unical_state				<0x03>, 			// LSB gesetzt -> nchstes Byte
			func1_DI_out_status_quality					<0xFC>,
			func1_DI_out_status_limit						<0x03>
		}
	}
}


COMMAND write_func1_DI_out 
{
	BLOCK func1_DI_block;
	INDEX 10;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_DI_out_value_unical_prg					<0xE0>, 
			func1_DI_out_value_unical_alarm				<0x08>,
			func1_DI_out_value_unical_service_switch	<0x04>,
			func1_DI_out_value_unical_state				<0x03>, 	 		// LSB gesetzt -> nchstes Byte
			func1_DI_out_status_quality					<0xFC>,
			func1_DI_out_status_limit						<0x03>
		}
		REPLY
		{
		}
	}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func1_DI_simulate 
{
	BLOCK func1_DI_block;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func1_DI_simulate_status_quality						<0xFC>,
			func1_DI_simulate_status_limit						<0x03>,	// LSB gesetzt -> nchstes Byte
			func1_DI_simulate_value_unical_prg					<0xE0>,
			func1_DI_simulate_value_unical_alarm				<0x08>,
			func1_DI_simulate_value_unical_service_switch	<0x04>,
			func1_DI_simulate_value_unical_state				<0x03>,	// LSB gesetzt -> nchstes Byte
			func1_DI_simulation_enabled
		}
	}
}


COMMAND write_func1_DI_simulate 
{
	BLOCK func1_DI_block;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func1_DI_simulate_status_quality						<0xFC>,
			func1_DI_simulate_status_limit						<0x03>,	// LSB gesetzt -> nchstes Byte
			func1_DI_simulate_value_unical_prg					<0xE0>,
			func1_DI_simulate_value_unical_alarm				<0x08>,
			func1_DI_simulate_value_unical_service_switch	<0x04>,
			func1_DI_simulate_value_unical_state				<0x03>,	// LSB gesetzt -> nchstes Byte
			func1_DI_simulation_enabled
		}
		REPLY
		{
		}
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU 
//-------------------------------------------------------------------------------------------------

MENU Page_display_func1_DI
{
	LABEL		FUNC1_DI_TITLE;
	ITEMS
	{
#ifdef FUNCX_DI_TAG_IN_PAGE_DISPLAY
		func1_DI_tag_desc									(READ_ONLY),
#endif
		func1_DI_out_value_unical_state				(READ_ONLY), 
		func1_DI_out_value_unical_alarm				(READ_ONLY),
		func1_DI_out_value_unical_service_switch	(READ_ONLY),
		func1_DI_out_value_unical_prg					(READ_ONLY), 
		Group_display_func1_DI_out,
		Group_display_func1_DI_in,
		Group_display_func1_DI_simulation
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func1_DI
{
	LABEL		[func_simulate_value];
	ITEMS
	{
		func1_DI_simulate_value_unical_state,
		func1_DI_simulate_value_unical_alarm,
		func1_DI_simulate_value_unical_service_switch,
		func1_DI_simulate_value_unical_prg,
		SEPARATOR,
		func1_DI_simulate_status_quality,
		func1_DI_simulate_status_limit
	}
}


MENU Group_simulate_output_func1_DI
{
	LABEL		[func_out_value];
	ITEMS
	{
		func1_DI_out_value_unical_state, 
		func1_DI_out_value_unical_alarm,
		func1_DI_out_value_unical_service_switch,
		func1_DI_out_value_unical_prg,
		SEPARATOR,
		func1_DI_out_status_quality,
		func1_DI_out_status_limit
	}
}


//-------------------------------------------------------------------------------------------------
//
//  ####   ###        ###
//  #   #   #        #   #
//  #   #   #            #
//  #   #   #           #
//  #   #   #          #   
//  #   #   #         #   
//  ####   ###       #####
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDI2_300.ddl" 
//-------------------------------------------------------------------------------------------------

#define FUNC2_DI_TITLE	"Contacts / Cal / Lock""|de|Kontakte / Cal / Freigabe"
#define FUNC2_DI_BLOCKNUMBER	8
#define FUNC2_DI_GLOBAL_SIMULATION_MASK	0x00000080

#include "KNPASTDI2_300.ddl"

//-------------------------------------------------------------------------------------------------
//    VARIABLE (DI Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

VARIABLE func2_DI_out_value_contacts
{
	LABEL		"Contact Status""|de|Aktive Kontakte";
//	HELP		[];
	CLASS		OUTPUT & DYNAMIC;
	STYLE 	"MULTILINE 12 4";
	TYPE		BIT_ENUMERATED (1)
	{
		DEFAULT_VALUE    0x00;
		{	0x00,	" "	},
		{	0x01,	"K4"	},
		{	0x02,	"K3"	},
		{	0x04,	"K2"	},
		{	0x08,	"K1"	}
	}
	HANDLING
		IF (func2_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}


VARIABLE func2_DI_out_value_cal_finished
{
	LABEL		"Calibration Finished""|de|Kalibrierung beendet";
	CLASS		OUTPUT & DYNAMIC;
//	HELP		[];
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    0x00;
		{	0x00,	"None" "|de|Keine"	},
		{	0x01,	"Channel 1" "|de|Kanal 1"	},
		{	0x02,	"Channel 2" "|de|Kanal 2"	}
	}
   HANDLING
		IF (func2_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}


func2_DI_out_value_lock_state	LIKE VARIABLE func4_DO_readback_d_value_lock_state
{
	REDEFINE HANDLING
		IF (func2_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}

//--- DI 21 : FSAFE_VAL_D -------------------------------------------------------------------------

VARIABLE func2_DI_fsafe_value
{
   LABEL		[func_ai_fsafe_value] ;
   HELP		[func_ai_fsafe_value_help];
   CLASS		CONTAINED;
	TYPE		INTEGER (1)
	{
		DEFAULT_VALUE    0x00;
		{	0x00,	"K1 - K4 passive"	"|de|K1 ... K4 passiv"	},
		{	0x0F,	"K1 - K4 active"	"|de|K1 ... K4 aktiv"	}
	}
   HANDLING	READ & WRITE;
   VALIDITY	IF (func2_DI_fsafe_type == FUNC_AI_FAIL_SAFE_VALUE)
   			{
					TRUE;
				}
				ELSE
				{
					FALSE;
				}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

func2_DI_simulate_value_contacts			LIKE VARIABLE func2_DI_out_value_contacts
{
	REDEFINE HELP		[func_ai_simulate_value_help];
	REDEFINE CLASS		CONTAINED & SERVICE;
	REDEFINE HANDLING	READ & WRITE;
}


func2_DI_simulate_value_cal_finished	LIKE VARIABLE func2_DI_out_value_cal_finished
{
	REDEFINE HELP		[func_ai_simulate_value_help];
	REDEFINE CLASS		CONTAINED & SERVICE;
	REDEFINE HANDLING	READ & WRITE;
}


func2_DI_simulate_value_lock_state		LIKE VARIABLE func2_DI_out_value_lock_state
{
	REDEFINE HELP		[func_ai_simulate_value_help];
	REDEFINE CLASS		CONTAINED & SERVICE;
	REDEFINE HANDLING	READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DI Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func2_DI_out 
{
	BLOCK func2_DI_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DI_out_value_lock_state		<0xC0>,
			func2_DI_out_value_cal_finished	<0x30>,
			func2_DI_out_value_contacts 		<0x0F>, 			// LSB gesetzt -> nchstes Byte
			func2_DI_out_status_quality		<0xFC>,
			func2_DI_out_status_limit			<0x03>,
		}
	}
}


COMMAND write_func2_DI_out 
{
	BLOCK func2_DI_block;
	INDEX 10;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func2_DI_out_value_lock_state		<0xC0>,
			func2_DI_out_value_cal_finished	<0x30>,
			func2_DI_out_value_contacts 		<0x0F>, 			// LSB gesetzt -> nchstes Byte
			func2_DI_out_status_quality		<0xFC>,
			func2_DI_out_status_limit			<0x03>,
		}
		REPLY
		{
		}
	}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func2_DI_simulate 
{
	BLOCK func2_DI_block;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func2_DI_simulate_status_quality			<0xFC>,
			func2_DI_simulate_status_limit			<0x03>,	// LSB gesetzt -> nchstes Byte
			func2_DI_simulate_value_lock_state		<0xC0>,
			func2_DI_simulate_value_cal_finished	<0x30>,
			func2_DI_simulate_value_contacts 		<0x0F>, 	// LSB gesetzt -> nchstes Byte
			func2_DI_simulation_enabled
		}
	}
}


COMMAND write_func2_DI_simulate 
{
	BLOCK func2_DI_block;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func2_DI_simulate_status_quality			<0xFC>,
			func2_DI_simulate_status_limit			<0x03>,	// LSB gesetzt -> nchstes Byte
			func2_DI_simulate_value_lock_state		<0xC0>,
			func2_DI_simulate_value_cal_finished	<0x30>,
			func2_DI_simulate_value_contacts 		<0x0F>, 	// LSB gesetzt -> nchstes Byte
			func2_DI_simulation_enabled
		}
		REPLY
		{
		}
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU 
//-------------------------------------------------------------------------------------------------

MENU Page_display_func2_DI
{
	LABEL		FUNC2_DI_TITLE;
	ITEMS
	{
#ifdef FUNCX_DI_TAG_IN_PAGE_DISPLAY
		func2_DI_tag_desc						(READ_ONLY),
#endif
		func2_DI_out_value_contacts 		(READ_ONLY),
		func2_DI_out_value_cal_finished	(READ_ONLY),
		func2_DI_out_value_lock_state		(READ_ONLY),
		Group_display_func2_DI_out,
		Group_display_func2_DI_in,
		Group_display_func2_DI_simulation
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func2_DI
{
	LABEL		[func_simulate_value];
	ITEMS
	{
		func2_DI_simulate_value_contacts,
		func2_DI_simulate_value_cal_finished,
		func2_DI_simulate_value_lock_state,
		SEPARATOR,
		func2_DI_simulate_status_quality,
		func2_DI_simulate_status_limit
	}
}


MENU Group_simulate_output_func2_DI
{
	LABEL		[func_out_value];
	ITEMS
	{
		func2_DI_out_value_contacts,
		func2_DI_out_value_cal_finished,
		func2_DI_out_value_lock_state,
		SEPARATOR,
		func2_DI_out_status_quality,
		func2_DI_out_status_limit
	}
}


//-------------------------------------------------------------------------------------------------
//	 
//  ####   ###       ###
//  #   #   #       #   #
//  #   #   #           #
//  #   #   #         ##
//  #   #   #           #  
//  #   #   #       #   #  
//  ####   ###       ###
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDI3_300.ddl" 
//-------------------------------------------------------------------------------------------------

#define FUNC3_DI_TITLE	"Unical Messages|de|Unical Meldungen"			// (re!)
#define FUNC3_DI_BLOCKNUMBER	12
#define FUNC3_DI_GLOBAL_SIMULATION_MASK	0x00000800

#include "KNPASTDI3_300.ddl"

//--- DI 10 : OUT_D -------------------------------------------------------------------------------
VARIABLE func3_DI_out_value
{
	LABEL		"Active Messages""|de|Aktive Meldungen";
//	HELP		[];
	CLASS		OUTPUT & DYNAMIC;
	STYLE 	"MULTILINE 12 8";
	TYPE		BIT_ENUMERATED (1)
	{
		DEFAULT_VALUE    0x00;
		{	0x00,	"None"												"|de|Keine"											},
		{	0x01,	"Probe maintenance request"					"|de|Wartungsbedarf Sonde"						},
		{	0x02,	"Media adapter maintenance request"			"|de|Wartungsbedarf Medienadapter"			},
		{	0x04,	"Unical basic device maintenance request"	"|de|Wartungsbedarf Unical Grundgert"		},		// (re!)
		{	0x08,	"Medium maintenance request"					"|de|Wartungsbedarf Medium"					},
		{	0x10,	"Probe failure"									"|de|Ausfall Sonde"								},
		{	0x20,	"Media adapter failure"							"|de|Ausfall Medienadapter"					},
		{	0x40,	"Unical basic device failure"					"|de|Ausfall Unical Grundgert"				},		// (re!)
		{	0x80,	"Calibration / Communication error"			"|de|Kalibrier- / Kommunikationsfehler"	}
	}
	HANDLING
		IF (func3_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}


//--- DI 21 : FSAFE_VAL_D -------------------------------------------------------------------------

VARIABLE func3_DI_fsafe_value
{
   LABEL		[func_ai_fsafe_value] ;
   HELP		[func_ai_fsafe_value_help];
   CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    0x00;
		{	0x00,	"No message active"								"|de|Keine Meldung aktiv"						},
		{	0xFF,	"All messages active"							"|de|Alle Meldungen aktiv"						},
		{	0x01,	"Probe maintenance request"					"|de|Wartungsbedarf Sonde"						},
		{	0x02,	"Media adapter maintenance request"			"|de|Wartungsbedarf Medienadapter"			},
		{	0x04,	"Unical basic device maintenance request"	"|de|Wartungsbedarf Unical Grundgert"		},		// (re!)
		{	0x08,	"Medium maintenance request"					"|de|Wartungsbedarf Medium"					},
		{	0x10,	"Probe failure"									"|de|Ausfall Sonde"								},
		{	0x20,	"Media adapter failure"							"|de|Ausfall Medienadapter"					},
		{	0x40,	"Unical basic device failure"					"|de|Ausfall Unical Grundgert"				},		// (re!)
		{	0x80,	"Calibration / Communication error"			"|de|Kalibrier- / Kommunikationsfehler"	}
	}
   HANDLING	READ & WRITE;
   VALIDITY	IF (func3_DI_fsafe_type == FUNC_AI_FAIL_SAFE_VALUE)
   			{
					TRUE;
				}
				ELSE
				{
					FALSE;
				}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

func3_DI_simulate_value		LIKE VARIABLE func3_DI_out_value
{
	REDEFINE CLASS			CONTAINED & SERVICE;
	REDEFINE HANDLING		READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DI Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func3_DI_out 
{
	BLOCK func3_DI_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_out_value, 			
			func3_DI_out_status_quality		<0xFC>,
			func3_DI_out_status_limit			<0x03>
		}
	}
}


COMMAND write_func3_DI_out 
{
	BLOCK func3_DI_block;
	INDEX 10;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_out_value, 			
			func3_DI_out_status_quality		<0xFC>,
			func3_DI_out_status_limit			<0x03>
		}
		REPLY
		{
		}
	}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func3_DI_simulate 
{
	BLOCK func3_DI_block;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func3_DI_simulate_status_quality			<0xFC>,
			func3_DI_simulate_status_limit			<0x03>,	// LSB gesetzt -> nchstes Byte
			func3_DI_simulate_value, 			
			func3_DI_simulation_enabled
		}
	}
}


COMMAND write_func3_DI_simulate 
{
	BLOCK func3_DI_block;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func3_DI_simulate_status_quality			<0xFC>,
			func3_DI_simulate_status_limit			<0x03>,	// LSB gesetzt -> nchstes Byte
			func3_DI_simulate_value, 			
			func3_DI_simulation_enabled
		}
		REPLY
		{
		}
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU 
//-------------------------------------------------------------------------------------------------

MENU Page_display_func3_DI
{
	LABEL		FUNC3_DI_TITLE;
	ITEMS
	{
#ifdef FUNCX_DI_TAG_IN_PAGE_DISPLAY
		func3_DI_tag_desc						(READ_ONLY),
#endif
		func3_DI_out_value					(READ_ONLY), 
		Group_display_func3_DI_out,
		Group_display_func3_DI_in,
		Group_display_func3_DI_simulation
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func3_DI
{
	LABEL		[func_simulate_value];
	ITEMS
	{
		func3_DI_simulate_value,
		SEPARATOR,
		func3_DI_simulate_status_quality,
		func3_DI_simulate_status_limit
	}
}


MENU Group_simulate_output_func3_DI
{
	LABEL		[func_out_value];
	ITEMS
	{
		func3_DI_out_value, 
		SEPARATOR,
		func3_DI_out_status_quality,
		func3_DI_out_status_limit
	}
}


//-------------------------------------------------------------------------------------------------
//
//  ####   ###          #
//  #   #   #          #
//  #   #   #         #
//  #   #   #        #  #
//  #   #   #       ######  
//  #   #   #           #  
//  ####   ###          #
//
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//   Konfiguration fr "KNPASTDI4_300.ddl" 
//-------------------------------------------------------------------------------------------------

#define FUNC4_DI_TITLE	"Unical Step"								// (re!)
#define FUNC4_DI_BLOCKNUMBER	13
#define FUNC4_DI_GLOBAL_SIMULATION_MASK	0x00001000

#include "KNPASTDI4_300.ddl"

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

VARIABLE func4_DI_out_value_unical_step_mode
{
	LABEL		"Single step mode|de|Einzelschrittbetrieb";
//	HELP		[];
	CLASS		OUTPUT & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    0x00;
		{	0x00,	"Off|de|Aus"	},
		{	0x01,	"On|de|Ein"		}
	}
	HANDLING
		IF (func4_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}


VARIABLE func4_DI_out_value_unical_step
{
	LABEL		"Actual step|de|Aktueller Schritt";
	CLASS		OUTPUT & DYNAMIC;
//	HELP		[];
	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE    0x00;
	}
	HANDLING
		IF (func4_DI_target_mode == BLOCK_MODE_MAN)
		{
			READ & WRITE;
		}
		ELSE
		{
			READ;
		}
}


//--- DI 21 : FSAFE_VAL_D -------------------------------------------------------------------------

VARIABLE func4_DI_fsafe_value
{
   LABEL		[func_ai_fsafe_value] ;
   HELP		[func_ai_fsafe_value_help];
   CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    0x01;
		{	0x00,	"Single step mode off" 				"|de|Kein Einzelschrittbetrieb"	},
		{	0x01,	"Single step mode on / step 0"	"|de|Einzelschrittbetrieb / Schritt 0"	}
	}
   HANDLING	READ & WRITE;
   VALIDITY	IF (func4_DI_fsafe_type == FUNC_AI_FAIL_SAFE_VALUE)
   			{
					TRUE;
				}
				ELSE
				{
					FALSE;
				}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

func4_DI_simulate_value_unical_step_mode		LIKE VARIABLE func4_DI_out_value_unical_step_mode
{
	REDEFINE CLASS			CONTAINED & SERVICE;
	REDEFINE HANDLING		READ & WRITE;
}


func4_DI_simulate_value_unical_step				LIKE VARIABLE func4_DI_out_value_unical_step
{
	REDEFINE CLASS			CONTAINED & SERVICE;
	REDEFINE HANDLING		READ & WRITE;
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (DI Parameter)
//-------------------------------------------------------------------------------------------------

//--- DI 10 : OUT_D -------------------------------------------------------------------------------

COMMAND read_func4_DI_out 
{
	BLOCK func4_DI_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func4_DI_out_value_unical_step		<0x3E>, 			
			func4_DI_out_value_unical_step_mode	<0x01>, 			// LSB gesetzt -> nchstes Byte
			func4_DI_out_status_quality			<0xFC>,
			func4_DI_out_status_limit				<0x03>
		}
	}
}


COMMAND write_func4_DI_out 
{
	BLOCK func4_DI_block;
	INDEX 10;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func4_DI_out_value_unical_step		<0x3E>, 			
			func4_DI_out_value_unical_step_mode	<0x01>, 			// LSB gesetzt -> nchstes Byte
			func4_DI_out_status_quality			<0xFC>,
			func4_DI_out_status_limit				<0x03>
		}
		REPLY
		{
		}
	}
}


//--- DI 24 : SIMULATE ----------------------------------------------------------------------------

COMMAND read_func4_DI_simulate 
{
	BLOCK func4_DI_block;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			func4_DI_simulate_status_quality				<0xFC>,
			func4_DI_simulate_status_limit				<0x03>,	// LSB gesetzt -> nchstes Byte
			func4_DI_simulate_value_unical_step			<0x3E>,
			func4_DI_simulate_value_unical_step_mode	<0x01>,	// LSB gesetzt -> nchstes Byte
			func4_DI_simulation_enabled
		}
	}
}


COMMAND write_func4_DI_simulate 
{
	BLOCK func4_DI_block;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			func4_DI_simulate_status_quality				<0xFC>,
			func4_DI_simulate_status_limit				<0x03>,	// LSB gesetzt -> nchstes Byte
			func4_DI_simulate_value_unical_step			<0x3E>,
			func4_DI_simulate_value_unical_step_mode	<0x01>,	// LSB gesetzt -> nchstes Byte
			func4_DI_simulation_enabled
		}
		REPLY
		{
		}
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU 
//-------------------------------------------------------------------------------------------------

MENU Page_display_func4_DI
{
	LABEL		FUNC4_DI_TITLE;
	ITEMS
	{
#ifdef FUNCX_DI_TAG_IN_PAGE_DISPLAY
		func4_DI_tag_desc							(READ_ONLY),
#endif
		func4_DI_out_value_unical_step_mode	(READ_ONLY), 
		func4_DI_out_value_unical_step		(READ_ONLY), 
		Group_display_func4_DI_out,
		Group_display_func4_DI_in,
		Group_display_func4_DI_simulation
	}
}


//-------------------------------------------------------------------------------------------------
//    MENU (Simulation)
//-------------------------------------------------------------------------------------------------

MENU Group_simulate_input_func4_DI
{
	LABEL		[func_simulate_value];
	ITEMS
	{
		func4_DI_simulate_value_unical_step_mode,
		func4_DI_simulate_value_unical_step,
		SEPARATOR,
		func4_DI_simulate_status_quality,
		func4_DI_simulate_status_limit
	}
}


MENU Group_simulate_output_func4_DI
{
	LABEL		[func_out_value];
	ITEMS
	{
		func4_DI_out_value_unical_step_mode, 
		func4_DI_out_value_unical_step,
		SEPARATOR,
		func4_DI_out_status_quality,
		func4_DI_out_status_limit
	}
}


