/* ----------------------------------------------------------------------

 FILE_NAME          do2.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke (nur fr A451 DP )- Relaissteuerung

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
 ####    ###   ###
 #   #  #   # #  #
 #   #  #   #    #
 #   #  #   #    #
 ####    ###     #
 ------------------------------------------------------
 */
/*
 ####################################
 Configuration vom DO
 ####################################
 */
MENU output_do2_window
{
    LABEL [LABEL_DO2];
    STYLE WINDOW;
    ITEMS
    {
        conf_out_do2_ident,
        conf_out_do2_process,
        conf_out_do2_alarm,
        conf_out_do2_batch
    }
}

/* TAG... */
MENU conf_out_do2_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func2_DO_TAG_DESC,
        func2_DO_STRATEGY,
        func2_DO_ALERT_KEY
    }
}

/* OUT,CHANNEL... */
MENU conf_out_do2_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        func2_DO_IN_CHANNEL,
        func2_DO_INVERT
        //func2_DO_CHECK_BACK_MASK
    }
}

/* Alarm, limits... */
MENU conf_out_do2_alarm
{
    LABEL TXT_FB_ALARM;
    STYLE GROUP;
    ITEMS
    {
        func2_DO_FSAFE_TYPE,
        func2_DO_FSAFE_VAL_D,
        func2_DO_FSAFE_TIME
    }
}

/* Batch.. */
MENU conf_out_do2_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func2_DO_BATCH_Batch_ID,
        func2_DO_BATCH_Rup,
        func2_DO_BATCH_Operation,
        func2_DO_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_do2_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func2_DO_TARGET_MODE,
        func2_DO_MODE_BLK_Actual,
        func2_DO_MODE_BLK_Permitted,
        func2_DO_SIMULATE_Enabled,
        func2_DO_SIMULATE_Value,
        func2_DO_SIMULATE_Status_Condensed
    }
}

/*
 ####################################
 Diagnose vom DO
 ####################################
 */
MENU output_do2_diag_window
{
    LABEL [LABEL_DO2];
    STYLE WINDOW;
    ITEMS
    {
        diag_out_do2_alarm
    }
}

/* Alarms... */
MENU diag_out_do2_alarm
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func2_DO_ALARM_SUM_Current,
        func2_DO_ALARM_SUM_Unacknowledged,
        func2_DO_ALARM_SUM_Unreported,
        func2_DO_ALARM_SUM_Disabled
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

/* Messwerte */
MENU display_out_func2_DO
{
    LABEL [LABEL_DO2];
    ITEMS 
	{
		meas_type (HIDDEN),
		phys_FEATURE_Enabled (HIDDEN),
		
        out_do2_value,		
		out_do2_simu,        
        out_do2_alarms
        
        //func2_DO_CHECK_BACK,
        /*,
         conf_out_do2_simu*/
    }
}
MENU func2_DO_ovw
{
    LABEL [LABEL_DO2];
	STYLE GROUP;
    ITEMS 
	{
		meas_type (HIDDEN),		
		phys_FEATURE_Enabled (HIDDEN),
        		
		func2_DO_OUT_D_Value,
        ROWBREAK,
        func2_DO_OUT_D_Status_Condensed
    }
}
MENU out_do2_value
{
    LABEL [PI_OUT_Value_label];
    STYLE GROUP;
    ITEMS
    {
		func2_DO_IN_CHANNEL (READ_ONLY),
		
		//func2_DO_SP_D_Value (READ_ONLY),
        //func2_DO_SP_D_Status_Condensed (READ_ONLY),
        func2_DO_OUT_D_Value (READ_ONLY),
        func2_DO_OUT_D_Status_Condensed (READ_ONLY),
	}
}

MENU out_do2_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func2_DO_MODE_BLK_Actual,         
        func2_DO_SIMULATE_Enabled (READ_ONLY)
    }
}

MENU out_do2_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func2_DO_ALARM_SUM_Current
    }
}


MENU alarm_sum_func2_DO
{
    LABEL [menu_dialog_alarm_sum];
    ITEMS
    {
        func2_DO_ALARM_SUM_Current,
        func2_DO_ALARM_SUM_Unacknowledged,
        func2_DO_ALARM_SUM_Unreported,
        func2_DO_ALARM_SUM_Disabled
    }
}

MENU overview_do2_alarms
{
    LABEL [LABEL_DO2];
    STYLE GROUP;
    ITEMS
    {
        func2_DO_ALARM_SUM_Current
		/*,
        COLUMNBREAK,
        func2_DO_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func2_DO_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func2_DO_ALARM_SUM_Disabled
		*/
    }
}

MENU simulation_window_do2
{
    LABEL [LABEL_DO2];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
		
		func2_DO_IN_CHANNEL (READ_ONLY),		
        simulation_wnd_do2_output,
        simulation_wnd_do2_input
    }
}


MENU simulation_wnd_do2_input
{
    LABEL TXT_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func2_DO_SIMULATE_Enabled,
        func2_DO_SIMULATE_Value,
        func2_DO_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_do2_output
{
    LABEL TXT_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func2_DO_TARGET_MODE,
        func2_DO_MODE_BLK_Actual,
        func2_DO_OUT_D_Value,
        func2_DO_OUT_D_Status_Condensed
    }
}
