/* ----------------------------------------------------------------------

 FILE_NAME          do1.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke (nur fr A451 DP )- Relaissteuerung

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
 ####    ###   ###
 #   #  #   # #  #
 #   #  #   #    #
 #   #  #   #    #
 ####    ###     #
 ------------------------------------------------------
 */
/*
 ####################################
 Configuration vom DO
 ####################################
 */
MENU output_do1_window
{
    LABEL [LABEL_DO1];
    STYLE WINDOW;
    ITEMS
    {
        conf_out_do1_ident,
        conf_out_do1_process,
        conf_out_do1_alarm,
        conf_out_do1_batch
    }
}

/* TAG... */
MENU conf_out_do1_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func1_DO_TAG_DESC,
        func1_DO_STRATEGY,
        func1_DO_ALERT_KEY
    }
}

/* OUT,CHANNEL... */
MENU conf_out_do1_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        func1_DO_IN_CHANNEL,
        func1_DO_INVERT
        //func1_DO_CHECK_BACK_MASK
    }
}

/* Alarm, limits... */
MENU conf_out_do1_alarm
{
    LABEL TXT_FB_ALARM;
    STYLE GROUP;
    ITEMS
    {
        func1_DO_FSAFE_TYPE,
        func1_DO_FSAFE_VAL_D,
        func1_DO_FSAFE_TIME
    }
}

/* Batch.. */
MENU conf_out_do1_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func1_DO_BATCH_Batch_ID,
        func1_DO_BATCH_Rup,
        func1_DO_BATCH_Operation,
        func1_DO_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_do1_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func1_DO_TARGET_MODE,
        func1_DO_MODE_BLK_Actual,
        func1_DO_MODE_BLK_Permitted,
        func1_DO_SIMULATE_Enabled,
        func1_DO_SIMULATE_Value,
        func1_DO_SIMULATE_Status_Condensed
    }
}

/*
 ####################################
 Diagnose vom DO
 ####################################
 */
MENU output_do1_diag_window
{
    LABEL [LABEL_DO1];
    STYLE WINDOW;
    ITEMS
    {
        diag_out_do1_alarm
    }
}

/* Alarms... */
MENU diag_out_do1_alarm
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func1_DO_ALARM_SUM_Current,
        func1_DO_ALARM_SUM_Unacknowledged,
        func1_DO_ALARM_SUM_Unreported,
        func1_DO_ALARM_SUM_Disabled
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

/* Messwerte */
MENU display_out_func1_DO
{
    LABEL [LABEL_DO1];
    ITEMS 
	{
		meas_type (HIDDEN),
		phys_FEATURE_Enabled (HIDDEN),
		
        out_do1_value,		
		out_do1_simu,        
        out_do1_alarms
        
        //func1_DO_CHECK_BACK,
        /*,
         conf_out_do1_simu*/
    }
}
MENU func1_DO_ovw
{
    LABEL [LABEL_DO1];
	STYLE GROUP;
    ITEMS 
	{
		meas_type (HIDDEN),		
		phys_FEATURE_Enabled (HIDDEN),
        		
		func1_DO_OUT_D_Value,
        ROWBREAK,
        func1_DO_OUT_D_Status_Condensed
    }
}
MENU out_do1_value
{
    LABEL [PI_OUT_Value_label];
    STYLE GROUP;
    ITEMS
    {
		func1_DO_IN_CHANNEL (READ_ONLY),
		
		//func1_DO_SP_D_Value (READ_ONLY),
        //func1_DO_SP_D_Status_Condensed (READ_ONLY),
        func1_DO_OUT_D_Value (READ_ONLY),
        func1_DO_OUT_D_Status_Condensed (READ_ONLY),
	}
}

MENU out_do1_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func1_DO_MODE_BLK_Actual,         
        func1_DO_SIMULATE_Enabled (READ_ONLY)
    }
}

MENU out_do1_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func1_DO_ALARM_SUM_Current
    }
}


MENU alarm_sum_func1_DO
{
    LABEL [menu_dialog_alarm_sum];
    ITEMS
    {
        func1_DO_ALARM_SUM_Current,
        func1_DO_ALARM_SUM_Unacknowledged,
        func1_DO_ALARM_SUM_Unreported,
        func1_DO_ALARM_SUM_Disabled
    }
}

MENU overview_do1_alarms
{
    LABEL [LABEL_DO1];
    STYLE GROUP;
    ITEMS
    {
        func1_DO_ALARM_SUM_Current
		/*,
        COLUMNBREAK,
        func1_DO_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func1_DO_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func1_DO_ALARM_SUM_Disabled
		*/
    }
}

MENU simulation_window_do1
{
    LABEL [LABEL_DO1];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
		
		func1_DO_IN_CHANNEL (READ_ONLY),		
        simulation_wnd_do1_output,
        simulation_wnd_do1_input
    }
}


MENU simulation_wnd_do1_input
{
    LABEL TXT_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_DO_SIMULATE_Enabled,
        func1_DO_SIMULATE_Value,
        func1_DO_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_do1_output
{
    LABEL TXT_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_DO_TARGET_MODE,
        func1_DO_MODE_BLK_Actual,
        func1_DO_OUT_D_Value,
        func1_DO_OUT_D_Status_Condensed
    }
}
