/* ----------------------------------------------------------------------

 FILE_NAME          rb_diag.ddl



 FUNCTIONAL_MODULE_DESCRIPTION

 Zeigt die Diag-Infos des Resourceblocks

 ----------------------------
 Prozessvariablen Transducerblock
 process_variables_root_menu_MN_TOP
 ----------------------------

 Transducerblock

 Abhngig vom Device-Type

 pH
 -------------
 pH
 mV
 Temperature   Temp unit

 Cond
 --------
 Conductivity
 Temperature Temperature unit

 CondI
 --------
 Conductivity
 Temperature Temperature unit

 Oxy
 --------
 Saturation
 Concentration
 Temperature Temperature unit

 CC
 ------------
 Conductivity 1
 Temperature 1    Temperature Temperature unit
 Conductivity 2
 Temperature 2    Temperature Temperature unit

 Calculation

 Other
 ---------
 Flow
 value_ao
 value_di
 value_do

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 Menuedefinition - Diagnostics Root-Men
 */
/*MENU process_variables_root_menu_MN_TOP
 {
 LABEL   "|en|Process Variables";
 STYLE WINDOW;
 ITEMS
 {
 TB_Process_Var_Page_ph,
 TB_Process_Var_Page_orp,
 TB_Process_Var_Page_cond,
 TB_Process_Var_Page_oxy,
 TB_Process_Var_Page_cc,
 TB_Process_Var_Page_Other
 }
 }*/

/*
 ------------------------------------------------------
 ####   ####            ####  #####   ###    ####
 #   #  #   #           #   #   #    #   #  #
 ####   ####    ####    #   #   #    #   #  # ###
 #   #  #   #           #   #   #    #####  #   #
 #   #  ####            ####  #####  #   #   ####
 ------------------------------------------------------
 */

/*
 pH
 ---------
 pH
 mV
 Temperature   Temp Unit
 */
MENU TB_Process_Var_Page_ph
{
    LABEL "Process Variables pH";
    STYLE PAGE;
    ITEMS
    {
        pv_ph.VALUE,
        pv_ph.STATUS,
        pv_mv.VALUE,
        pv_mv.STATUS,
        pv_temperature.VALUE,
        pv_temperature_unit,
        pv_temperature.STATUS
    }
    VALIDITY IF (meas_type == MEAS_TYPE_PH) { TRUE; } ELSE { FALSE; }
}

/*
 cond
 ---------
 Conductivity
 Temperature Temperature unit

 */
MENU TB_Process_Var_Page_cond
{
    LABEL "Process Variables Conductivity";
    STYLE PAGE;
    ITEMS
    {
        pv_conductivity.VALUE,
        pv_temperature.VALUE,
        pv_temperature_unit
    }
    VALIDITY IF (meas_type == MEAS_TYPE_COND || meas_type == MEAS_TYPE_CONDI) { TRUE; } ELSE { FALSE; }
}

/*
 Oxy
 ---------
 Saturation
 Concentration
 Temperature   Temp unit
 */
MENU TB_Process_Var_Page_oxy
{
    LABEL "Process Variables Oxygen";
    STYLE PAGE;
    ITEMS
    {
        pv_do_saturation_air.VALUE,
        pv_do_concentration.VALUE,
        pv_temperature.VALUE,
        pv_temperature_unit
    }
    VALIDITY IF (meas_type == MEAS_TYPE_OXY) { TRUE; } ELSE { FALSE; }
}

/*
 CC
 ---------
 Conductivity 1
 Temperature 1    Temperature Temperature unit
 Conductivity 2
 Temperature 2    Temperature Temperature unit

 Calculation
 */
MENU TB_Process_Var_Page_cc
{
    LABEL "Process Variables CC";
    STYLE PAGE;
    ITEMS
    {
        pv_conductivity.VALUE,
        pv_temperature.VALUE,
        pv_temperature_unit,
        pv_conductivity_2.VALUE,
        pv_temperature_2.VALUE,
        pv_temperature_unit,
        pv_calculation.VALUE
    }
    VALIDITY IF (meas_type == MEAS_TYPE_CC) { TRUE; } ELSE { FALSE; }
}

/*
 Other
 ---------
 Flow
 value_ao
 value_di
 value_do
 */
MENU TB_Process_Var_Page_Other
{
    LABEL TXT_OTHER;
    STYLE PAGE;
    ITEMS
    {
        pv_flow.VALUE
        /*  value_ao,
         value_di,
         value_do    */
    }
}
