/*
 //----------------------------------------------------------------------------
 // Generierung der DD-Variablen
 // Erzeuger:        msh
 // Datum:           2013-11-11_13:16:28
 //----------------------------------------------------------------------------
 */
/*
 //----------------------------------------------------------------------------
 // Variable MEAS_TYPE: !!! Important !!! Select the Meas Type according to your sensor
 //----------------------------------------------------------------------------
 */
#include "pa_import_0302.h"
#include "pa_macros_0302.h"

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

VARIABLE meas_type
{
    LABEL LBL_MEAS_TYPE_18;
    HELP HLP_MEAS_TYPE_18;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_MEAS_TYPE_18_VAL_0, HLP_MEAS_TYPE_18_VAL_0},
        {   1, LBL_MEAS_TYPE_18_VAL_1, HLP_MEAS_TYPE_18_VAL_1},
        {   2, LBL_MEAS_TYPE_18_VAL_2, HLP_MEAS_TYPE_18_VAL_2},
        {   3, LBL_MEAS_TYPE_18_VAL_3, HLP_MEAS_TYPE_18_VAL_3},
        {   4, LBL_MEAS_TYPE_18_VAL_4, HLP_MEAS_TYPE_18_VAL_4}
    }
    HANDLING READ & WRITE;
    POST_EDIT_ACTIONS {method_set_default_channels}
}

METHOD method_empty
{
    LABEL "";
    CLASS INPUT;
    ACCESS ONLINE;
    DEFINITION {}
}

METHOD method_refresh_meas_type
{
    LABEL "";
    CLASS INPUT;
    ACCESS ONLINE;
    DEFINITION {
        ReadCommand(tb1_meas_type_read);
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable SENSORTYPE: Select the sensor type for pH.
 //----------------------------------------------------------------------------
 */
VARIABLE sensortype_19
{
    LABEL LBL_SENSORTYPE_19;
    HELP HLP_SENSORTYPE_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   6, LBL_SENSORTYPE_19_VAL_6, HLP_SENSORTYPE_19_VAL_6},
        {   7, LBL_SENSORTYPE_19_VAL_7, HLP_SENSORTYPE_19_VAL_7},
        {   13, LBL_SENSORTYPE_19_VAL_13, HLP_SENSORTYPE_19_VAL_13},
        {   14, LBL_SENSORTYPE_19_VAL_14, HLP_SENSORTYPE_19_VAL_14},
        {   18, LBL_SENSORTYPE_19_VAL_18, HLP_SENSORTYPE_19_VAL_18}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable MEAS_MODE: Select the display unit.
 //----------------------------------------------------------------------------
 */
VARIABLE meas_mode_19
{
    LABEL LBL_MEAS_MODE_19;
    HELP HLP_MEAS_MODE_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_MEAS_MODE_19_VAL_0, HLP_MEAS_MODE_19_VAL_0},
        {   1, LBL_MEAS_MODE_19_VAL_1, HLP_MEAS_MODE_19_VAL_1},
        {   2, LBL_MEAS_MODE_19_VAL_2, HLP_MEAS_MODE_19_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable RTD_TYPE: Select the temperature sensor
 //----------------------------------------------------------------------------
 */
VARIABLE rtd_type_19
{
    LABEL LBL_RTD_TYPE_19;
    HELP HLP_RTD_TYPE_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_RTD_TYPE_19_VAL_0, HLP_RTD_TYPE_19_VAL_0},
        {   1, LBL_RTD_TYPE_19_VAL_1, HLP_RTD_TYPE_19_VAL_1},
        {   5, LBL_RTD_TYPE_19_VAL_5, HLP_RTD_TYPE_19_VAL_5},
        {   2, LBL_RTD_TYPE_19_VAL_2, HLP_RTD_TYPE_19_VAL_2},
        {   8, LBL_RTD_TYPE_19_VAL_8, HLP_RTD_TYPE_19_VAL_8}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_UNIT: Select the shown temperature unit for the display
 //----------------------------------------------------------------------------
 */
VARIABLE temp_unit_19
{
    LABEL LBL_TEMP_UNIT_19;
    HELP HLP_TEMP_UNIT_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   39, LBL_TEMP_UNIT_19_VAL_39, HLP_TEMP_UNIT_19_VAL_39},
        {   40, LBL_TEMP_UNIT_19_VAL_40, HLP_TEMP_UNIT_19_VAL_40}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_MEAS: Select which temperature is used for calculation while normal measurement
 //----------------------------------------------------------------------------
 */
VARIABLE temp_meas_19
{
    LABEL LBL_TEMP_MEAS_19;
    HELP HLP_TEMP_MEAS_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TEMP_MEAS_19_VAL_0, HLP_TEMP_MEAS_19_VAL_0},
        {   1, LBL_TEMP_MEAS_19_VAL_1, HLP_TEMP_MEAS_19_VAL_1},
        {   2, LBL_TEMP_MEAS_19_VAL_2, HLP_TEMP_MEAS_19_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_MEAS_MAN: Enter the temperature value if TEMP_MEAS is selected MAN
 //----------------------------------------------------------------------------
 */
VARIABLE temp_meas_man_19
{
    LABEL LBL_TEMP_MEAS_MAN_19;
    HELP HLP_TEMP_MEAS_MAN_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT IF( temp_unit_19 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_CAL: Select which temperature is used for calculation
 //----------------------------------------------------------------------------
 */
VARIABLE temp_cal_19
{
    LABEL LBL_TEMP_CAL_19;
    HELP HLP_TEMP_CAL_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TEMP_CAL_19_VAL_0, HLP_TEMP_CAL_19_VAL_0},
        {   1, LBL_TEMP_CAL_19_VAL_1, HLP_TEMP_CAL_19_VAL_1},
        {   2, LBL_TEMP_CAL_19_VAL_2, HLP_TEMP_CAL_19_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_CAL_MAN: Enter the temperature value if TEMP_CAL is selected MAN
 //----------------------------------------------------------------------------
 */
VARIABLE temp_cal_man_19
{
    LABEL LBL_TEMP_CAL_MAN_19;
    HELP HLP_TEMP_CAL_MAN_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    IF( temp_unit_19 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable NOM_ZERO: Enter the nominal zero point for Pfaudler sensors
 //----------------------------------------------------------------------------
 */
VARIABLE nom_zero_19
{
    LABEL LBL_NOM_ZERO_19;
    HELP HLP_NOM_ZERO_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.3f";
        EDIT_FORMAT "4.3f";
        MIN_VALUE 0.0;
        MAX_VALUE 16.0;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "pH";
}

/*
 //----------------------------------------------------------------------------
 // Variable NOM_SLOPE: Enter the nominal slope point for Pfaudler sensors
 //----------------------------------------------------------------------------
 */
VARIABLE nom_slope_19
{
    LABEL LBL_NOM_SLOPE_19;
    HELP HLP_NOM_SLOPE_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
        MIN_VALUE 30.0;
        MAX_VALUE 60.0;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "mV";
}

/*
 //----------------------------------------------------------------------------
 // Variable PH_ISO: Enter the pH Iso for Pfaudler sensors
 //----------------------------------------------------------------------------
 */
VARIABLE ph_iso_19
{
    LABEL LBL_PH_ISO_19;
    HELP HLP_PH_ISO_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.3f";
        EDIT_FORMAT "4.3f";
        MIN_VALUE 0;
        MAX_VALUE 14.0;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "pH";
}

/*
 //----------------------------------------------------------------------------
 // Variable CALMODE: Select the calibration mode.
 //----------------------------------------------------------------------------
 */
VARIABLE calmode_19
{
    LABEL LBL_CALMODE_19;
    HELP HLP_CALMODE_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CALMODE_19_VAL_0, HLP_CALMODE_19_VAL_0},
        {   1, LBL_CALMODE_19_VAL_1, HLP_CALMODE_19_VAL_1},
        {   2, LBL_CALMODE_19_VAL_2, HLP_CALMODE_19_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable BUFFER_SET: select the buffer set used if CALMODE is AUTO
 //----------------------------------------------------------------------------
 */
VARIABLE buffer_set_19
{
    LABEL LBL_BUFFER_SET_19;
    HELP HLP_BUFFER_SET_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   1, LBL_BUFFER_SET_19_VAL_1, HLP_BUFFER_SET_19_VAL_1},
        {   2, LBL_BUFFER_SET_19_VAL_2, HLP_BUFFER_SET_19_VAL_2},
        {   3, LBL_BUFFER_SET_19_VAL_3, HLP_BUFFER_SET_19_VAL_3},
        {   4, LBL_BUFFER_SET_19_VAL_4, HLP_BUFFER_SET_19_VAL_4},
        {   5, LBL_BUFFER_SET_19_VAL_5, HLP_BUFFER_SET_19_VAL_5},
        {   6, LBL_BUFFER_SET_19_VAL_6, HLP_BUFFER_SET_19_VAL_6},
        {   7, LBL_BUFFER_SET_19_VAL_7, HLP_BUFFER_SET_19_VAL_7},
        {   8, LBL_BUFFER_SET_19_VAL_8, HLP_BUFFER_SET_19_VAL_8},
        {   9, LBL_BUFFER_SET_19_VAL_9, HLP_BUFFER_SET_19_VAL_9},
        {   10, LBL_BUFFER_SET_19_VAL_10, HLP_BUFFER_SET_19_VAL_10},
        {   11, LBL_BUFFER_SET_19_VAL_11, HLP_BUFFER_SET_19_VAL_11}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_TIMER: Calibration timer is used to remind you for a calibration. Not for ISM sensors.
 //----------------------------------------------------------------------------
 */
VARIABLE cal_timer_19
{
    LABEL LBL_CAL_TIMER_19;
    HELP HLP_CAL_TIMER_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CAL_TIMER_19_VAL_0, HLP_CAL_TIMER_19_VAL_0},
        {   1, LBL_CAL_TIMER_19_VAL_1, HLP_CAL_TIMER_19_VAL_1},
        {   2, LBL_CAL_TIMER_19_VAL_2, HLP_CAL_TIMER_19_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_CYCLE: Enter a value if CAL_TIMER is set to Fix.
 //----------------------------------------------------------------------------
 */
VARIABLE cal_cycle_19
{
    LABEL LBL_CAL_CYCLE_19;
    HELP HLP_CAL_CYCLE_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "h";
}

/*
 //----------------------------------------------------------------------------
 // Variable ACT: Only for ISM sensors.
 //----------------------------------------------------------------------------
 */
VARIABLE act_19
{
    LABEL LBL_ACT_19;
    HELP HLP_ACT_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_ACT_19_VAL_0, HLP_ACT_19_VAL_0},
        {   1, LBL_ACT_19_VAL_1, HLP_ACT_19_VAL_1},
        {   2, LBL_ACT_19_VAL_2, HLP_ACT_19_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable ACT_CYCLE: Enter a value if ACT is set to MAN.
 //----------------------------------------------------------------------------
 */
VARIABLE act_cycle_19
{
    LABEL LBL_ACT_CYCLE_19;
    HELP HLP_ACT_CYCLE_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "day(s)";
}

/*
 //----------------------------------------------------------------------------
 // Variable TTM: Enable Time To Maintenacne. ISM sensors only.
 //----------------------------------------------------------------------------
 */
VARIABLE ttm_19
{
    LABEL LBL_TTM_19;
    HELP HLP_TTM_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TTM_19_VAL_0, HLP_TTM_19_VAL_0},
        {   1, LBL_TTM_19_VAL_1, HLP_TTM_19_VAL_1},
        {   2, LBL_TTM_19_VAL_2, HLP_TTM_19_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TTM_CYCLE: Enter value for reminding maintenance. ISM sensors only.
 //----------------------------------------------------------------------------
 */
VARIABLE ttm_cycle_19
{
    LABEL LBL_TTM_CYCLE_19;
    HELP HLP_TTM_CYCLE_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
        MIN_VALUE 0;
        MAX_VALUE 2000;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "day(s)";
}

/*
 //----------------------------------------------------------------------------
 // Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE cip_count_19
{
    LABEL LBL_CIP_COUNT_19;
    HELP HLP_CIP_COUNT_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CIP_COUNT_19_VAL_0, HLP_CIP_COUNT_19_VAL_0},
        {   1, LBL_CIP_COUNT_19_VAL_1, HLP_CIP_COUNT_19_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CIP_CYCLES: Enter value if CIP_COUNT is enabled.
 //----------------------------------------------------------------------------
 */
VARIABLE cip_cycles_19
{
    LABEL LBL_CIP_CYCLES_19;
    HELP HLP_CIP_CYCLES_19;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE sip_count_19
{
    LABEL LBL_SIP_COUNT_19;
    HELP HLP_SIP_COUNT_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_SIP_COUNT_19_VAL_0, HLP_SIP_COUNT_19_VAL_0},
        {   1, LBL_SIP_COUNT_19_VAL_1, HLP_SIP_COUNT_19_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SIP_CYCLES: Enter value if SIP_COUNT is enabled.
 //----------------------------------------------------------------------------
 */
VARIABLE sip_cycles_19
{
    LABEL LBL_SIP_CYCLES_19;
    HELP HLP_SIP_CYCLES_19;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable AUTOCLAVE: To enable autoclave count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE autoclave_19
{
    LABEL LBL_AUTOCLAVE_19;
    HELP HLP_AUTOCLAVE_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_AUTOCLAVE_19_VAL_0, HLP_AUTOCLAVE_19_VAL_0},
        {   1, LBL_AUTOCLAVE_19_VAL_1, HLP_AUTOCLAVE_19_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable AC_CYCLES: Enter value if AUTOCLAVE is enabled.
 //----------------------------------------------------------------------------
 */
VARIABLE ac_cycles_19
{
    LABEL LBL_AC_CYCLES_19;
    HELP HLP_AC_CYCLES_19;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_SELECT: Select if temperature compensation is needed
 //----------------------------------------------------------------------------
 */
VARIABLE tc_select_19
{
    LABEL LBL_TC_SELECT_19;
    HELP HLP_TC_SELECT_19;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TC_SELECT_19_VAL_0, HLP_TC_SELECT_19_VAL_0},
        {   1, LBL_TC_SELECT_19_VAL_1, HLP_TC_SELECT_19_VAL_1},
        {   8, LBL_TC_SELECT_19_VAL_8, HLP_TC_SELECT_19_VAL_8},
        {   7, LBL_TC_SELECT_19_VAL_7, HLP_TC_SELECT_19_VAL_7}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_LIQUID: Enter value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE tc_liquid_19
{
    LABEL LBL_TC_LIQUID_19;
    HELP HLP_TC_LIQUID_19;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
        MIN_VALUE -19.99;
        MAX_VALUE 19.99;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%/K";
    VISIBILITY IF ( tc_select_19 == 1)
    {
        TRUE;
    }
    ELSE
    {
        FALSE;
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable SENSORTYPE: Select the sensor type for conductivity.
 //----------------------------------------------------------------------------
 */
VARIABLE sensortype_20
{
    LABEL LBL_SENSORTYPE_20;
    HELP HLP_SENSORTYPE_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   11, LBL_SENSORTYPE_20_VAL_11, HLP_SENSORTYPE_20_VAL_11},
        {   12, LBL_SENSORTYPE_20_VAL_12, HLP_SENSORTYPE_20_VAL_12},
        {   14, LBL_SENSORTYPE_20_VAL_14, HLP_SENSORTYPE_20_VAL_14}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable MEAS_MODE: Select the meas mode for conductivity.
 //----------------------------------------------------------------------------
 */
VARIABLE meas_mode_20
{
    LABEL LBL_MEAS_MODE_20;
    HELP HLP_MEAS_MODE_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_MEAS_MODE_20_VAL_0, HLP_MEAS_MODE_20_VAL_0},
        {   1, LBL_MEAS_MODE_20_VAL_1, HLP_MEAS_MODE_20_VAL_1},
        {   2, LBL_MEAS_MODE_20_VAL_2, HLP_MEAS_MODE_20_VAL_2},
        {   3, LBL_MEAS_MODE_20_VAL_3, HLP_MEAS_MODE_20_VAL_3},
        {   4, LBL_MEAS_MODE_20_VAL_4, HLP_MEAS_MODE_20_VAL_4}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DISPLAY_UNIT: Select Displayformat on transmitter
 //----------------------------------------------------------------------------
 */
VARIABLE display_unit_20
{
    LABEL LBL_DISPLAY_UNIT_20;
    HELP HLP_DISPLAY_UNIT_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   25, LBL_DISPLAY_UNIT_20_VAL_25, HLP_DISPLAY_UNIT_20_VAL_25},
        {   24, LBL_DISPLAY_UNIT_20_VAL_24, HLP_DISPLAY_UNIT_20_VAL_24},
        {   23, LBL_DISPLAY_UNIT_20_VAL_23, HLP_DISPLAY_UNIT_20_VAL_23},
        {   22, LBL_DISPLAY_UNIT_20_VAL_22, HLP_DISPLAY_UNIT_20_VAL_22},
        {   21, LBL_DISPLAY_UNIT_20_VAL_21, HLP_DISPLAY_UNIT_20_VAL_21},
        {   20, LBL_DISPLAY_UNIT_20_VAL_20, HLP_DISPLAY_UNIT_20_VAL_20},
        {   19, LBL_DISPLAY_UNIT_20_VAL_19, HLP_DISPLAY_UNIT_20_VAL_19},
        {   17, LBL_DISPLAY_UNIT_20_VAL_17, HLP_DISPLAY_UNIT_20_VAL_17},
        {   16, LBL_DISPLAY_UNIT_20_VAL_16, HLP_DISPLAY_UNIT_20_VAL_16},
        {   55, LBL_DISPLAY_UNIT_20_VAL_55, HLP_DISPLAY_UNIT_20_VAL_55}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SOLUTION: Select solution of concentration
 //----------------------------------------------------------------------------
 */
VARIABLE solution_20
{
    LABEL LBL_SOLUTION_20;
    HELP HLP_SOLUTION_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_SOLUTION_20_VAL_0, HLP_SOLUTION_20_VAL_0},
        {   1, LBL_SOLUTION_20_VAL_1, HLP_SOLUTION_20_VAL_1},
        {   2, LBL_SOLUTION_20_VAL_2, HLP_SOLUTION_20_VAL_2},
        {   3, LBL_SOLUTION_20_VAL_3, HLP_SOLUTION_20_VAL_3},
        {   4, LBL_SOLUTION_20_VAL_4, HLP_SOLUTION_20_VAL_4},
        {   5, LBL_SOLUTION_20_VAL_5, HLP_SOLUTION_20_VAL_5},
        {   6, LBL_SOLUTION_20_VAL_6, HLP_SOLUTION_20_VAL_6},
        {   7, LBL_SOLUTION_20_VAL_7, HLP_SOLUTION_20_VAL_7},
        {   8, LBL_SOLUTION_20_VAL_8, HLP_SOLUTION_20_VAL_8},
        {   9, LBL_SOLUTION_20_VAL_9, HLP_SOLUTION_20_VAL_9}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable RTD_TYPE: Select the temperature sensor
 //----------------------------------------------------------------------------
 */
VARIABLE rtd_type_20
{
    LABEL LBL_RTD_TYPE_20;
    HELP HLP_RTD_TYPE_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_RTD_TYPE_20_VAL_0, HLP_RTD_TYPE_20_VAL_0},
        {   1, LBL_RTD_TYPE_20_VAL_1, HLP_RTD_TYPE_20_VAL_1},
        {   7, LBL_RTD_TYPE_20_VAL_7, HLP_RTD_TYPE_20_VAL_7},
        {   2, LBL_RTD_TYPE_20_VAL_2, HLP_RTD_TYPE_20_VAL_2},
        {   5, LBL_RTD_TYPE_20_VAL_5, HLP_RTD_TYPE_20_VAL_5}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_UNIT: Select the shown temperature unit for the display
 //----------------------------------------------------------------------------
 */
VARIABLE temp_unit_20
{
    LABEL LBL_TEMP_UNIT_20;
    HELP HLP_TEMP_UNIT_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   39, LBL_TEMP_UNIT_20_VAL_39, HLP_TEMP_UNIT_20_VAL_39},
        {   40, LBL_TEMP_UNIT_20_VAL_40, HLP_TEMP_UNIT_20_VAL_40}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMPERATURE: Select which temperature is used for calculation while normal measurement
 //----------------------------------------------------------------------------
 */
VARIABLE temperature_20
{
    LABEL LBL_TEMPERATURE_20;
    HELP HLP_TEMPERATURE_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TEMPERATURE_20_VAL_0, HLP_TEMPERATURE_20_VAL_0},
        {   1, LBL_TEMPERATURE_20_VAL_1, HLP_TEMPERATURE_20_VAL_1},
        {   2, LBL_TEMPERATURE_20_VAL_2, HLP_TEMPERATURE_20_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMPERATURE_MAN: Enter the temperature value if TEMP_MEAS is selected MAN
 //----------------------------------------------------------------------------
 */
VARIABLE temperature_man_20
{
    LABEL LBL_TEMPERATURE_MAN_20;
    HELP HLP_TEMPERATURE_MAN_20;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    IF( temp_unit_20 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE cip_count_20
{
    LABEL LBL_CIP_COUNT_20;
    HELP HLP_CIP_COUNT_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CIP_COUNT_20_VAL_0, HLP_CIP_COUNT_20_VAL_0},
        {   1, LBL_CIP_COUNT_20_VAL_1, HLP_CIP_COUNT_20_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE sip_count_20
{
    LABEL LBL_SIP_COUNT_20;
    HELP HLP_SIP_COUNT_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_SIP_COUNT_20_VAL_0, HLP_SIP_COUNT_20_VAL_0},
        {   1, LBL_SIP_COUNT_20_VAL_1, HLP_SIP_COUNT_20_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_SELECT: Select if temperature compensation is needed
 //----------------------------------------------------------------------------
 */
VARIABLE tc_select_20
{
    LABEL LBL_TC_SELECT_20;
    HELP HLP_TC_SELECT_20;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TC_SELECT_20_VAL_0, HLP_TC_SELECT_20_VAL_0},
        {   1, LBL_TC_SELECT_20_VAL_1, HLP_TC_SELECT_20_VAL_1},
        {   2, LBL_TC_SELECT_20_VAL_2, HLP_TC_SELECT_20_VAL_2},
        {   3, LBL_TC_SELECT_20_VAL_3, HLP_TC_SELECT_20_VAL_3},
        {   4, LBL_TC_SELECT_20_VAL_4, HLP_TC_SELECT_20_VAL_4},
        {   5, LBL_TC_SELECT_20_VAL_5, HLP_TC_SELECT_20_VAL_5},
        {   6, LBL_TC_SELECT_20_VAL_6, HLP_TC_SELECT_20_VAL_6}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_LIQUID: Enter value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE tc_liquid_20
{
    LABEL LBL_TC_LIQUID_20;
    HELP HLP_TC_LIQUID_20;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
        MIN_VALUE 0.00;
        MAX_VALUE 19.99;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%/K";
}

/*
 //----------------------------------------------------------------------------
 // Variable REF_TEMP: Enter reference temperature value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE ref_temp_20
{
    LABEL LBL_REF_TEMP_20;
    HELP HLP_REF_TEMP_20;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    IF( temp_unit_20 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable TDS_FACTOR: Enter TDS Factor if MEAS MODE is set to TDS
 //----------------------------------------------------------------------------
 */
VARIABLE tds_factor_20
{
    LABEL LBL_TDS_FACTOR_20;
    HELP HLP_TDS_FACTOR_20;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
        MIN_VALUE 0;
        MAX_VALUE 1;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable USP_FACTOR: Enter USP Factor if MEAS MODE is set to USP
 //----------------------------------------------------------------------------
 */
VARIABLE usp_factor_20
{
    LABEL LBL_USP_FACTOR_20;
    HELP HLP_USP_FACTOR_20;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.1f";
        EDIT_FORMAT "5.1f";
        MIN_VALUE 10.0;
        MAX_VALUE 100.0;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SENSORTYPE: Select the sensor type for toroidal conductivity.
 //----------------------------------------------------------------------------
 */
VARIABLE sensortype_21
{
    LABEL LBL_SENSORTYPE_21;
    HELP HLP_SENSORTYPE_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   14, LBL_SENSORTYPE_21_VAL_14, HLP_SENSORTYPE_21_VAL_14},
        {   0, LBL_SENSORTYPE_21_VAL_0, HLP_SENSORTYPE_21_VAL_0},
        {   1, LBL_SENSORTYPE_21_VAL_1, HLP_SENSORTYPE_21_VAL_1},
        {   2, LBL_SENSORTYPE_21_VAL_2, HLP_SENSORTYPE_21_VAL_2},
        {   3, LBL_SENSORTYPE_21_VAL_3, HLP_SENSORTYPE_21_VAL_3},
        {   4, LBL_SENSORTYPE_21_VAL_4, HLP_SENSORTYPE_21_VAL_4},
        {   5, LBL_SENSORTYPE_21_VAL_5, HLP_SENSORTYPE_21_VAL_5}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable MEAS_MODE: Select the meas mode for toroidal conductivity.
 //----------------------------------------------------------------------------
 */
VARIABLE meas_mode_21
{
    LABEL LBL_MEAS_MODE_21;
    HELP HLP_MEAS_MODE_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_MEAS_MODE_21_VAL_0, HLP_MEAS_MODE_21_VAL_0},
        {   1, LBL_MEAS_MODE_21_VAL_1, HLP_MEAS_MODE_21_VAL_1},
        {   2, LBL_MEAS_MODE_21_VAL_2, HLP_MEAS_MODE_21_VAL_2},
        {   4, LBL_MEAS_MODE_21_VAL_4, HLP_MEAS_MODE_21_VAL_4}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DISPLAY_UNIT: Select Displayformat on transmitter
 //----------------------------------------------------------------------------
 */
VARIABLE display_unit_21
{
    LABEL LBL_DISPLAY_UNIT_21;
    HELP HLP_DISPLAY_UNIT_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   21, LBL_DISPLAY_UNIT_21_VAL_21, HLP_DISPLAY_UNIT_21_VAL_21},
        {   20, LBL_DISPLAY_UNIT_21_VAL_20, HLP_DISPLAY_UNIT_21_VAL_20},
        {   19, LBL_DISPLAY_UNIT_21_VAL_19, HLP_DISPLAY_UNIT_21_VAL_19},
        {   18, LBL_DISPLAY_UNIT_21_VAL_18, HLP_DISPLAY_UNIT_21_VAL_18},
        {   17, LBL_DISPLAY_UNIT_21_VAL_17, HLP_DISPLAY_UNIT_21_VAL_17},
        {   16, LBL_DISPLAY_UNIT_21_VAL_16, HLP_DISPLAY_UNIT_21_VAL_16}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SOLUTION: Select solution of concentration
 //----------------------------------------------------------------------------
 */
VARIABLE solution_21
{
    LABEL LBL_SOLUTION_21;
    HELP HLP_SOLUTION_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_SOLUTION_21_VAL_0, HLP_SOLUTION_21_VAL_0},
        {   1, LBL_SOLUTION_21_VAL_1, HLP_SOLUTION_21_VAL_1},
        {   2, LBL_SOLUTION_21_VAL_2, HLP_SOLUTION_21_VAL_2},
        {   3, LBL_SOLUTION_21_VAL_3, HLP_SOLUTION_21_VAL_3},
        {   4, LBL_SOLUTION_21_VAL_4, HLP_SOLUTION_21_VAL_4},
        {   5, LBL_SOLUTION_21_VAL_5, HLP_SOLUTION_21_VAL_5},
        {   6, LBL_SOLUTION_21_VAL_6, HLP_SOLUTION_21_VAL_6},
        {   7, LBL_SOLUTION_21_VAL_7, HLP_SOLUTION_21_VAL_7},
        {   8, LBL_SOLUTION_21_VAL_8, HLP_SOLUTION_21_VAL_8},
        {   9, LBL_SOLUTION_21_VAL_9, HLP_SOLUTION_21_VAL_9}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable RTD_TYPE: Select the temperature sensor
 //----------------------------------------------------------------------------
 */
VARIABLE rtd_type_21
{
    LABEL LBL_RTD_TYPE_21;
    HELP HLP_RTD_TYPE_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_RTD_TYPE_21_VAL_0, HLP_RTD_TYPE_21_VAL_0},
        {   1, LBL_RTD_TYPE_21_VAL_1, HLP_RTD_TYPE_21_VAL_1},
        {   5, LBL_RTD_TYPE_21_VAL_5, HLP_RTD_TYPE_21_VAL_5}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_UNIT: Select the shown temperature unit for the display
 //----------------------------------------------------------------------------
 */
VARIABLE temp_unit_21
{
    LABEL LBL_TEMP_UNIT_21;
    HELP HLP_TEMP_UNIT_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   39, LBL_TEMP_UNIT_21_VAL_39, HLP_TEMP_UNIT_21_VAL_39},
        {   40, LBL_TEMP_UNIT_21_VAL_40, HLP_TEMP_UNIT_21_VAL_40}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMPERATURE: Select which temperature is used for calculation while normal measurement
 //----------------------------------------------------------------------------
 */
VARIABLE temperature_21
{
    LABEL LBL_TEMPERATURE_21;
    HELP HLP_TEMPERATURE_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TEMPERATURE_21_VAL_0, HLP_TEMPERATURE_21_VAL_0},
        {   1, LBL_TEMPERATURE_21_VAL_1, HLP_TEMPERATURE_21_VAL_1},
        {   2, LBL_TEMPERATURE_21_VAL_2, HLP_TEMPERATURE_21_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMPERATURE_MAN: Enter the temperature value if TEMP_MEAS is selected MAN
 //----------------------------------------------------------------------------
 */
VARIABLE temperature_man_21
{
    LABEL LBL_TEMPERATURE_MAN_21;
    HELP HLP_TEMPERATURE_MAN_21;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    IF ( temp_unit_21 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE cip_count_21
{
    LABEL LBL_CIP_COUNT_21;
    HELP HLP_CIP_COUNT_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CIP_COUNT_21_VAL_0, HLP_CIP_COUNT_21_VAL_0},
        {   1, LBL_CIP_COUNT_21_VAL_1, HLP_CIP_COUNT_21_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE sip_count_21
{
    LABEL LBL_SIP_COUNT_21;
    HELP HLP_SIP_COUNT_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_SIP_COUNT_21_VAL_0, HLP_SIP_COUNT_21_VAL_0},
        {   1, LBL_SIP_COUNT_21_VAL_1, HLP_SIP_COUNT_21_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_SELECT: Select if temperature compensation is needed
 //----------------------------------------------------------------------------
 */
VARIABLE tc_select_21
{
    LABEL LBL_TC_SELECT_21;
    HELP HLP_TC_SELECT_21;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TC_SELECT_21_VAL_0, HLP_TC_SELECT_21_VAL_0},
        {   1, LBL_TC_SELECT_21_VAL_1, HLP_TC_SELECT_21_VAL_1},
        {   2, LBL_TC_SELECT_21_VAL_2, HLP_TC_SELECT_21_VAL_2},
        {   3, LBL_TC_SELECT_21_VAL_3, HLP_TC_SELECT_21_VAL_3},
        {   4, LBL_TC_SELECT_21_VAL_4, HLP_TC_SELECT_21_VAL_4},
        {   5, LBL_TC_SELECT_21_VAL_5, HLP_TC_SELECT_21_VAL_5},
        {   6, LBL_TC_SELECT_21_VAL_6, HLP_TC_SELECT_21_VAL_6}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_LIQUID: Enter value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE tc_liquid_21
{
    LABEL LBL_TC_LIQUID_21;
    HELP HLP_TC_LIQUID_21;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
        MIN_VALUE 0.00;
        MAX_VALUE 19.99;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%/K";
}

/*
 //----------------------------------------------------------------------------
 // Variable REF_TEMP: Enter reference temperature value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE ref_temp_21
{
    LABEL LBL_REF_TEMP_21;
    HELP HLP_REF_TEMP_21;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    IF( temp_unit_21 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable TDS_FACTOR: Enter TDS Factor if MEAS MODE is set to TDS
 //----------------------------------------------------------------------------
 */
VARIABLE tds_factor_21
{
    LABEL LBL_TDS_FACTOR_21;
    HELP HLP_TDS_FACTOR_21;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
        MIN_VALUE 0;
        MAX_VALUE 1;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SENSORTYPE: Select the sensor type for DO
 //----------------------------------------------------------------------------
 */
VARIABLE sensortype_22
{
    LABEL LBL_SENSORTYPE_22;
    HELP HLP_SENSORTYPE_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   8, LBL_SENSORTYPE_22_VAL_8, HLP_SENSORTYPE_22_VAL_8},
        {   9, LBL_SENSORTYPE_22_VAL_9, HLP_SENSORTYPE_22_VAL_9},
        {   10, LBL_SENSORTYPE_22_VAL_10, HLP_SENSORTYPE_22_VAL_10},
        {   14, LBL_SENSORTYPE_22_VAL_14, HLP_SENSORTYPE_22_VAL_14},
        {   13, LBL_SENSORTYPE_22_VAL_13, HLP_SENSORTYPE_22_VAL_13}
#ifdef STRATOS_DP
        ,{   16, LBL_SENSORTYPE_22_VAL_16, HLP_SENSORTYPE_22_VAL_16},
#endif

    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable MEAS_MODE: Select the meas mode for DO.
 //----------------------------------------------------------------------------
 */
VARIABLE meas_mode_22
{
    LABEL LBL_MEAS_MODE_22;
    HELP HLP_MEAS_MODE_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   12, LBL_MEAS_MODE_22_VAL_12, HLP_MEAS_MODE_22_VAL_12},
        {   2, LBL_MEAS_MODE_22_VAL_2, HLP_MEAS_MODE_22_VAL_2},
        {   5, LBL_MEAS_MODE_22_VAL_5, HLP_MEAS_MODE_22_VAL_5},
        {   8, LBL_MEAS_MODE_22_VAL_8, HLP_MEAS_MODE_22_VAL_8}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable U_POL_MEAS: Polarisation voltage while measurement.
 //----------------------------------------------------------------------------
 */
VARIABLE u_pol_meas_22
{
    LABEL LBL_U_POL_MEAS_22;
    HELP HLP_U_POL_MEAS_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "mV";
}

/*
 //----------------------------------------------------------------------------
 // Variable U_POL_CAL: Polarisation voltage while calibration.
 //----------------------------------------------------------------------------
 */
VARIABLE u_pol_cal_22
{
    LABEL LBL_U_POL_CAL_22;
    HELP HLP_U_POL_CAL_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "mV";
}

/*
 //----------------------------------------------------------------------------
 // Variable MEMBRAN_COMP: Membrane compensation
 //----------------------------------------------------------------------------
 */
VARIABLE membran_comp_22
{
    LABEL LBL_MEMBRAN_COMP_22;
    HELP HLP_MEMBRAN_COMP_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable RTD_TYPE: Select the temperature sensor
 //----------------------------------------------------------------------------
 */
VARIABLE rtd_type_22
{
    LABEL LBL_RTD_TYPE_22;
    HELP HLP_RTD_TYPE_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   4, LBL_RTD_TYPE_22_VAL_4, HLP_RTD_TYPE_22_VAL_4},
        {   5, LBL_RTD_TYPE_22_VAL_5, HLP_RTD_TYPE_22_VAL_5}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_UNIT: Select the shown temperature unit for the display
 //----------------------------------------------------------------------------
 */
VARIABLE temp_unit_22
{
    LABEL LBL_TEMP_UNIT_22;
    HELP HLP_TEMP_UNIT_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   39, LBL_TEMP_UNIT_22_VAL_39, HLP_TEMP_UNIT_22_VAL_39},
        {   40, LBL_TEMP_UNIT_22_VAL_40, HLP_TEMP_UNIT_22_VAL_40}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CALMODE: Select the calibration mode.
 //----------------------------------------------------------------------------
 */
VARIABLE calmode_22
{
    LABEL LBL_CALMODE_22;
    HELP HLP_CALMODE_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   5, LBL_CALMODE_22_VAL_5, HLP_CALMODE_22_VAL_5},
        {   4, LBL_CALMODE_22_VAL_4, HLP_CALMODE_22_VAL_4}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_TIMER: Calibration timer is used to remind you for a calibration. Not for ISM sensors.
 //----------------------------------------------------------------------------
 */
VARIABLE cal_timer_22
{
    LABEL LBL_CAL_TIMER_22;
    HELP HLP_CAL_TIMER_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CAL_TIMER_22_VAL_0, HLP_CAL_TIMER_22_VAL_0},
        {   1, LBL_CAL_TIMER_22_VAL_1, HLP_CAL_TIMER_22_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_CYCLE: Enter a value if CAL_TIMER is set to On.
 //----------------------------------------------------------------------------
 */
VARIABLE cal_cycle_22
{
    LABEL LBL_CAL_CYCLE_22;
    HELP HLP_CAL_CYCLE_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "day(s)";
}

/*
 //----------------------------------------------------------------------------
 // Variable ACT: Only for ISM sensors.
 //----------------------------------------------------------------------------
 */
VARIABLE act_22
{
    LABEL LBL_ACT_22;
    HELP HLP_ACT_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_ACT_22_VAL_0, HLP_ACT_22_VAL_0},
        {   1, LBL_ACT_22_VAL_1, HLP_ACT_22_VAL_1},
        {   2, LBL_ACT_22_VAL_2, HLP_ACT_22_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable ACT_CYCLE: Enter a value if ACT is set to MAN.
 //----------------------------------------------------------------------------
 */
VARIABLE act_cycle_22
{
    LABEL LBL_ACT_CYCLE_22;
    HELP HLP_ACT_CYCLE_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "day(s)";
}

/*
 //----------------------------------------------------------------------------
 // Variable TTM: Enable Time To Maintenacne. ISM sensors only.
 //----------------------------------------------------------------------------
 */
VARIABLE ttm_22
{
    LABEL LBL_TTM_22;
    HELP HLP_TTM_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TTM_22_VAL_0, HLP_TTM_22_VAL_0},
        {   1, LBL_TTM_22_VAL_1, HLP_TTM_22_VAL_1},
        {   2, LBL_TTM_22_VAL_2, HLP_TTM_22_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TTM_CYCLE: Enter value for reminding maintenance. ISM sensors only.
 //----------------------------------------------------------------------------
 */
VARIABLE ttm_cycle_22
{
    LABEL LBL_TTM_CYCLE_22;
    HELP HLP_TTM_CYCLE_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
        MIN_VALUE 0;
        MAX_VALUE 2000;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "day(s)";
}

/*
 //----------------------------------------------------------------------------
 // Variable CIP_COUNT: To enable CIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE cip_count_22
{
    LABEL LBL_CIP_COUNT_22;
    HELP HLP_CIP_COUNT_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CIP_COUNT_22_VAL_0, HLP_CIP_COUNT_22_VAL_0},
        {   1, LBL_CIP_COUNT_22_VAL_1, HLP_CIP_COUNT_22_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CIP_CYCLES: Enter value if CIP_COUNT is enabled.
 //----------------------------------------------------------------------------
 */
VARIABLE cip_cycles_22
{
    LABEL LBL_CIP_CYCLES_22;
    HELP HLP_CIP_CYCLES_22;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SIP_COUNT: To enable SIP Count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE sip_count_22
{
    LABEL LBL_SIP_COUNT_22;
    HELP HLP_SIP_COUNT_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_SIP_COUNT_22_VAL_0, HLP_SIP_COUNT_22_VAL_0},
        {   1, LBL_SIP_COUNT_22_VAL_1, HLP_SIP_COUNT_22_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SIP_CYCLES: Enter value if SIP_COUNT is enabled.
 //----------------------------------------------------------------------------
 */
VARIABLE sip_cycles_22
{
    LABEL LBL_SIP_CYCLES_22;
    HELP HLP_SIP_CYCLES_22;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable AUTOCLAVE: To enable autoclave count alarm for Memosens and ISM sensors
 //----------------------------------------------------------------------------
 */
VARIABLE autoclave_22
{
    LABEL LBL_AUTOCLAVE_22;
    HELP HLP_AUTOCLAVE_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_AUTOCLAVE_22_VAL_0, HLP_AUTOCLAVE_22_VAL_0},
        {   1, LBL_AUTOCLAVE_22_VAL_1, HLP_AUTOCLAVE_22_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable AC_CYCLES: Enter value if AUTOCLAVE is enabled.
 //----------------------------------------------------------------------------
 */
VARIABLE ac_cycles_22
{
    LABEL LBL_AC_CYCLES_22;
    HELP HLP_AC_CYCLES_22;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        MIN_VALUE 0;
        MAX_VALUE 9999;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SALINITY: Enter salinity value.
 //----------------------------------------------------------------------------
 */
VARIABLE salinity_22
{
    LABEL LBL_SALINITY_22;
    HELP HLP_SALINITY_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
        MIN_VALUE 0;
        MAX_VALUE 45.0;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "ppt";
}

/*
 //----------------------------------------------------------------------------
 // Variable PRESSURE_UNIT: Select the unit of pressure.
 //----------------------------------------------------------------------------
 */
VARIABLE pressure_unit_22
{
    LABEL LBL_PRESSURE_UNIT_22;
    HELP HLP_PRESSURE_UNIT_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   58, LBL_PRESSURE_UNIT_22_VAL_58, HLP_PRESSURE_UNIT_22_VAL_58},
        {   61, LBL_PRESSURE_UNIT_22_VAL_61, HLP_PRESSURE_UNIT_22_VAL_61},
        {   63, LBL_PRESSURE_UNIT_22_VAL_63, HLP_PRESSURE_UNIT_22_VAL_63}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable PRESSURE: Select pressure by manual input or analog output (BUS)
 //----------------------------------------------------------------------------
 */
VARIABLE pressure_22
{
    LABEL LBL_PRESSURE_22;
    HELP HLP_PRESSURE_22;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   1, LBL_PRESSURE_22_VAL_1, HLP_PRESSURE_22_VAL_1},
        {   2, LBL_PRESSURE_22_VAL_2, HLP_PRESSURE_22_VAL_2}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable PRESSURE_MAN: Enter pressure in unit of PRESSURE_UNIT
 //----------------------------------------------------------------------------
 */
VARIABLE pressure_man_22
{
    LABEL LBL_PRESSURE_MAN_22;
    HELP HLP_PRESSURE_MAN_22;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "7.3f";
        EDIT_FORMAT "7.3f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    SELECT ( pressure_unit_22 ) {
        CASE 58: "bar";
        CASE 61: "kPa";
        CASE 63: "psi";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_SELECT_A: Select if temperature compensation is needed
 //----------------------------------------------------------------------------
 */
VARIABLE tc_select_a_23
{
    LABEL LBL_TC_SELECT_A_23;
    HELP HLP_TC_SELECT_A_23;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TC_SELECT_A_23_VAL_0, HLP_TC_SELECT_A_23_VAL_0},
        {   1, LBL_TC_SELECT_A_23_VAL_1, HLP_TC_SELECT_A_23_VAL_1},
        {   2, LBL_TC_SELECT_A_23_VAL_2, HLP_TC_SELECT_A_23_VAL_2},
        {   3, LBL_TC_SELECT_A_23_VAL_3, HLP_TC_SELECT_A_23_VAL_3},
        {   4, LBL_TC_SELECT_A_23_VAL_4, HLP_TC_SELECT_A_23_VAL_4},
        {   5, LBL_TC_SELECT_A_23_VAL_5, HLP_TC_SELECT_A_23_VAL_5},
        {   6, LBL_TC_SELECT_A_23_VAL_6, HLP_TC_SELECT_A_23_VAL_6}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_LIQUID_A: Enter value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE tc_liquid_a_23
{
    LABEL LBL_TC_LIQUID_A_23;
    HELP HLP_TC_LIQUID_A_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
        MIN_VALUE 0.00;
        MAX_VALUE 19.99;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%/K";
}

/*
 //----------------------------------------------------------------------------
 // Variable REF_TEMP_A: Enter reference temperature value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE ref_temp_a_23
{
    LABEL LBL_REF_TEMP_A_23;
    HELP HLP_REF_TEMP_A_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    IF( temp_unit_23 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_SELECT_B: Select if temperature compensation is needed
 //----------------------------------------------------------------------------
 */
VARIABLE tc_select_b_23
{
    LABEL LBL_TC_SELECT_B_23;
    HELP HLP_TC_SELECT_B_23;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_TC_SELECT_B_23_VAL_0, HLP_TC_SELECT_B_23_VAL_0},
        {   1, LBL_TC_SELECT_B_23_VAL_1, HLP_TC_SELECT_B_23_VAL_1},
        {   2, LBL_TC_SELECT_B_23_VAL_2, HLP_TC_SELECT_B_23_VAL_2},
        {   3, LBL_TC_SELECT_B_23_VAL_3, HLP_TC_SELECT_B_23_VAL_3},
        {   4, LBL_TC_SELECT_B_23_VAL_4, HLP_TC_SELECT_B_23_VAL_4},
        {   5, LBL_TC_SELECT_B_23_VAL_5, HLP_TC_SELECT_B_23_VAL_5},
        {   6, LBL_TC_SELECT_B_23_VAL_6, HLP_TC_SELECT_B_23_VAL_6}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_LIQUID_B: Enter value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE tc_liquid_b_23
{
    LABEL LBL_TC_LIQUID_B_23;
    HELP HLP_TC_LIQUID_B_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
        MIN_VALUE 0.00;
        MAX_VALUE 19.99;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%/K";
}

/*
 //----------------------------------------------------------------------------
 // Variable REF_TEMP_B: Enter reference temperature value if temperature compensation is set to LIN
 //----------------------------------------------------------------------------
 */
VARIABLE ref_temp_b_23
{
    LABEL LBL_REF_TEMP_B_23;
    HELP HLP_REF_TEMP_B_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT
    IF( temp_unit_23 == 40 )
    {
        "F";
    }
    ELSE
    {
        "C";
    }
}

/*
 //----------------------------------------------------------------------------
 // Variable MEAS_RANGE: Select the meas range for conductivity.
 //----------------------------------------------------------------------------
 */
VARIABLE meas_range_23
{
    LABEL LBL_MEAS_RANGE_23;
    HELP HLP_MEAS_RANGE_23;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   25, LBL_MEAS_RANGE_23_VAL_25, HLP_MEAS_RANGE_23_VAL_25},
        {   24, LBL_MEAS_RANGE_23_VAL_24, HLP_MEAS_RANGE_23_VAL_24},
        {   23, LBL_MEAS_RANGE_23_VAL_23, HLP_MEAS_RANGE_23_VAL_23},
        {   22, LBL_MEAS_RANGE_23_VAL_22, HLP_MEAS_RANGE_23_VAL_22},
        {   55, LBL_MEAS_RANGE_23_VAL_55, HLP_MEAS_RANGE_23_VAL_55}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TEMP_UNIT: Select the shown temperature unit for the display
 //----------------------------------------------------------------------------
 */
VARIABLE temp_unit_23
{
    LABEL LBL_TEMP_UNIT_23;
    HELP HLP_TEMP_UNIT_23;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   39, LBL_TEMP_UNIT_23_VAL_39, HLP_TEMP_UNIT_23_VAL_39},
        {   40, LBL_TEMP_UNIT_23_VAL_40, HLP_TEMP_UNIT_23_VAL_40}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CALCULATION: Enable or disable calculation.
 //----------------------------------------------------------------------------
 */
VARIABLE calculation_23
{
    LABEL LBL_CALCULATION_23;
    HELP HLP_CALCULATION_23;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CALCULATION_23_VAL_0, HLP_CALCULATION_23_VAL_0},
        {   1, LBL_CALCULATION_23_VAL_1, HLP_CALCULATION_23_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CALCULATION_TYPE: Select calculation type
 //----------------------------------------------------------------------------
 */
VARIABLE calculation_type_23
{
    LABEL LBL_CALCULATION_TYPE_23;
    HELP HLP_CALCULATION_TYPE_23;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CALCULATION_TYPE_23_VAL_0, HLP_CALCULATION_TYPE_23_VAL_0},
        {   1, LBL_CALCULATION_TYPE_23_VAL_1, HLP_CALCULATION_TYPE_23_VAL_1},
        {   2, LBL_CALCULATION_TYPE_23_VAL_2, HLP_CALCULATION_TYPE_23_VAL_2},
        {   3, LBL_CALCULATION_TYPE_23_VAL_3, HLP_CALCULATION_TYPE_23_VAL_3},
        {   4, LBL_CALCULATION_TYPE_23_VAL_4, HLP_CALCULATION_TYPE_23_VAL_4},
        {   5, LBL_CALCULATION_TYPE_23_VAL_5, HLP_CALCULATION_TYPE_23_VAL_5},
        {   6, LBL_CALCULATION_TYPE_23_VAL_6, HLP_CALCULATION_TYPE_23_VAL_6},
        {   7, LBL_CALCULATION_TYPE_23_VAL_7, HLP_CALCULATION_TYPE_23_VAL_7}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable FACTOR_1: Enter 1st factor if CALCULATION_TYPE is set to -C7-
 //----------------------------------------------------------------------------
 */
VARIABLE factor_1_23
{
    LABEL LBL_FACTOR_1_23;
    HELP HLP_FACTOR_1_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
        MIN_VALUE 1.00;
        MAX_VALUE 10.00;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable FACTOR_2: Enter 2nd factor if CALCULATION_TYPE is set to -C7-
 //----------------------------------------------------------------------------
 */
VARIABLE factor_2_23
{
    LABEL LBL_FACTOR_2_23;
    HELP HLP_FACTOR_2_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "3.0f";
        EDIT_FORMAT "3.0f";
        MIN_VALUE 100;
        MAX_VALUE 500;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable PARAMETER_W: Enter 1st parameter if CALCULATION_TYPE is set to -C8-
 //----------------------------------------------------------------------------
 */
VARIABLE parameter_w_23
{
    LABEL LBL_PARAMETER_W_23;
    HELP HLP_PARAMETER_W_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable PARAMETER_A: Enter 2nd parameter if CALCULATION_TYPE is set to -C8-
 //----------------------------------------------------------------------------
 */
VARIABLE parameter_a_23
{
    LABEL LBL_PARAMETER_A_23;
    HELP HLP_PARAMETER_A_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.1f";
        EDIT_FORMAT "5.1f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable PARAMETER_B: Enter 3rd parameter if CALCULATION_TYPE is set to -C8-
 //----------------------------------------------------------------------------
 */
VARIABLE parameter_b_23
{
    LABEL LBL_PARAMETER_B_23;
    HELP HLP_PARAMETER_B_23;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.1f";
        EDIT_FORMAT "5.1f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable FLOW_ADJUST: Enter Flow adjustment in impulses/litre
 //----------------------------------------------------------------------------
 */
VARIABLE flow_adjust
{
    LABEL LBL_FLOW_ADJUST_24;
    HELP HLP_FLOW_ADJUST_24;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.0f";
        EDIT_FORMAT "5.0f";
        MIN_VALUE 0;
        MAX_VALUE 20000.0;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "Impulse/l"; // rth: noch lokalisieren
}

/*
 //----------------------------------------------------------------------------
 // Variable ALARM_DELAY: Enter alarm delay in seconds
 //----------------------------------------------------------------------------
 */
VARIABLE alarm_delay
{
    LABEL LBL_ALARM_DELAY_25;
    HELP HLP_ALARM_DELAY_25;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
        MIN_VALUE 0.0;
        MAX_VALUE 600.0;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "s";
}

/*
 //----------------------------------------------------------------------------
 // Variable SENSOCHECK: Sensocheck appraises the sensor.
 //----------------------------------------------------------------------------
 */
VARIABLE sensocheck
{
    LABEL LBL_SENSOCHECK_26;
    HELP HLP_SENSOCHECK_26;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_SENSOCHECK_26_VAL_0, HLP_SENSOCHECK_26_VAL_0},
        {   1, LBL_SENSOCHECK_26_VAL_1, HLP_SENSOCHECK_26_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable FORMAT: Select clock format
 //----------------------------------------------------------------------------
 */
VARIABLE format_27
{
    LABEL LBL_FORMAT_27;
    HELP HLP_FORMAT_27;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_FORMAT_27_VAL_0, HLP_FORMAT_27_VAL_0},
        {   1, LBL_FORMAT_27_VAL_1, HLP_FORMAT_27_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable MINUTE: Enter minute
 //----------------------------------------------------------------------------
 */
VARIABLE minute_27
{
    LABEL LBL_MINUTE_27;
    HELP HLP_MINUTE_27;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1)
    {
        MIN_VALUE 0;
        MAX_VALUE 59;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable HOUR: Enter hour
 //----------------------------------------------------------------------------
 */
VARIABLE hour_27
{
    LABEL LBL_HOUR_27;
    HELP HLP_HOUR_27;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1)
    {
        MIN_VALUE 0;
        MAX_VALUE 24;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable AMPM: Enter if am or pm
 //----------------------------------------------------------------------------
 */
VARIABLE ampm_27
{
    LABEL LBL_AMPM_27;
    HELP HLP_AMPM_27;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_AMPM_27_VAL_0, HLP_AMPM_27_VAL_0},
        {   1, LBL_AMPM_27_VAL_1, HLP_AMPM_27_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DAY: Enter day
 //----------------------------------------------------------------------------
 */
VARIABLE day_27
{
    LABEL LBL_DAY_27;
    HELP HLP_DAY_27;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1)
    {
        MIN_VALUE 1;
        MAX_VALUE 31;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable MONTH: Enter month
 //----------------------------------------------------------------------------
 */
VARIABLE month_27
{
    LABEL LBL_MONTH_27;
    HELP HLP_MONTH_27;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1)
    {
        MIN_VALUE 1;
        MAX_VALUE 12;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable YEAR: Enter year
 //----------------------------------------------------------------------------
 */
VARIABLE year_27
{
    LABEL LBL_YEAR_27;
    HELP HLP_YEAR_27;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(2)
    {
        MIN_VALUE 2000;
        MAX_VALUE 2099;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_0: Enter value for 0C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_0_28
{
    LABEL LBL_DEGREE_0_28;
    HELP HLP_DEGREE_0_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_5: Enter value for 5C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_5_28
{
    LABEL LBL_DEGREE_5_28;
    HELP HLP_DEGREE_5_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_10: Enter value for 10C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_10_28
{
    LABEL LBL_DEGREE_10_28;
    HELP HLP_DEGREE_10_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_15: Enter value for 15C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_15_28
{
    LABEL LBL_DEGREE_15_28;
    HELP HLP_DEGREE_15_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_20: Enter value for 20C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_20_28
{
    LABEL LBL_DEGREE_20_28;
    HELP HLP_DEGREE_20_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_25: Enter value for 25C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_25_28
{
    LABEL LBL_DEGREE_25_28;
    HELP HLP_DEGREE_25_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_30: Enter value for 30C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_30_28
{
    LABEL LBL_DEGREE_30_28;
    HELP HLP_DEGREE_30_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_35: Enter value for 35C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_35_28
{
    LABEL LBL_DEGREE_35_28;
    HELP HLP_DEGREE_35_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_40: Enter value for 40C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_40_28
{
    LABEL LBL_DEGREE_40_28;
    HELP HLP_DEGREE_40_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_45: Enter value for 45C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_45_28
{
    LABEL LBL_DEGREE_45_28;
    HELP HLP_DEGREE_45_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_50: Enter value for 50C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_50_28
{
    LABEL LBL_DEGREE_50_28;
    HELP HLP_DEGREE_50_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_55: Enter value for 55C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_55_28
{
    LABEL LBL_DEGREE_55_28;
    HELP HLP_DEGREE_55_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_60: Enter value for 60C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_60_28
{
    LABEL LBL_DEGREE_60_28;
    HELP HLP_DEGREE_60_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_65: Enter value for 65C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_65_28
{
    LABEL LBL_DEGREE_65_28;
    HELP HLP_DEGREE_65_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_70: Enter value for 70C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_70_28
{
    LABEL LBL_DEGREE_70_28;
    HELP HLP_DEGREE_70_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_75: Enter value for 75C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_75_28
{
    LABEL LBL_DEGREE_75_28;
    HELP HLP_DEGREE_75_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_80: Enter value for 80C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_80_28
{
    LABEL LBL_DEGREE_80_28;
    HELP HLP_DEGREE_80_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_85: Enter value for 85C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_85_28
{
    LABEL LBL_DEGREE_85_28;
    HELP HLP_DEGREE_85_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_90: Enter value for 90C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_90_28
{
    LABEL LBL_DEGREE_90_28;
    HELP HLP_DEGREE_90_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_95: Enter value for 95C
 //----------------------------------------------------------------------------
 */
VARIABLE degree_95_28
{
    LABEL LBL_DEGREE_95_28;
    HELP HLP_DEGREE_95_28;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.2f";
        EDIT_FORMAT "5.2f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable NOMINAL: Enter nominal value at 25C for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE nominal_29
{
    LABEL LBL_NOMINAL_29;
    HELP HLP_NOMINAL_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_0: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_0_29
{
    LABEL LBL_DEGREE_0_29;
    HELP HLP_DEGREE_0_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_5: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_5_29
{
    LABEL LBL_DEGREE_5_29;
    HELP HLP_DEGREE_5_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_10: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_10_29
{
    LABEL LBL_DEGREE_10_29;
    HELP HLP_DEGREE_10_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_15: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_15_29
{
    LABEL LBL_DEGREE_15_29;
    HELP HLP_DEGREE_15_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_20: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_20_29
{
    LABEL LBL_DEGREE_20_29;
    HELP HLP_DEGREE_20_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_25: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_25_29
{
    LABEL LBL_DEGREE_25_29;
    HELP HLP_DEGREE_25_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_30: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_30_29
{
    LABEL LBL_DEGREE_30_29;
    HELP HLP_DEGREE_30_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_35: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_35_29
{
    LABEL LBL_DEGREE_35_29;
    HELP HLP_DEGREE_35_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_40: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_40_29
{
    LABEL LBL_DEGREE_40_29;
    HELP HLP_DEGREE_40_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_45: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_45_29
{
    LABEL LBL_DEGREE_45_29;
    HELP HLP_DEGREE_45_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_50: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_50_29
{
    LABEL LBL_DEGREE_50_29;
    HELP HLP_DEGREE_50_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_55: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_55_29
{
    LABEL LBL_DEGREE_55_29;
    HELP HLP_DEGREE_55_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_60: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_60_29
{
    LABEL LBL_DEGREE_60_29;
    HELP HLP_DEGREE_60_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_65: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_65_29
{
    LABEL LBL_DEGREE_65_29;
    HELP HLP_DEGREE_65_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_70: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_70_29
{
    LABEL LBL_DEGREE_70_29;
    HELP HLP_DEGREE_70_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_75: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_75_29
{
    LABEL LBL_DEGREE_75_29;
    HELP HLP_DEGREE_75_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_80: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_80_29
{
    LABEL LBL_DEGREE_80_29;
    HELP HLP_DEGREE_80_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_85: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_85_29
{
    LABEL LBL_DEGREE_85_29;
    HELP HLP_DEGREE_85_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_90: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_90_29
{
    LABEL LBL_DEGREE_90_29;
    HELP HLP_DEGREE_90_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_95: Enter value for 1st user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_95_29
{
    LABEL LBL_DEGREE_95_29;
    HELP HLP_DEGREE_95_29;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable NOMINAL: Enter nominal value at 25C for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE nominal_30
{
    LABEL LBL_NOMINAL_30;
    HELP HLP_NOMINAL_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_0: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_0_30
{
    LABEL LBL_DEGREE_0_30;
    HELP HLP_DEGREE_0_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_5: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_5_30
{
    LABEL LBL_DEGREE_5_30;
    HELP HLP_DEGREE_5_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_10: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_10_30
{
    LABEL LBL_DEGREE_10_30;
    HELP HLP_DEGREE_10_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_15: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_15_30
{
    LABEL LBL_DEGREE_15_30;
    HELP HLP_DEGREE_15_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_20: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_20_30
{
    LABEL LBL_DEGREE_20_30;
    HELP HLP_DEGREE_20_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_25: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_25_30
{
    LABEL LBL_DEGREE_25_30;
    HELP HLP_DEGREE_25_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_30: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_30_30
{
    LABEL LBL_DEGREE_30_30;
    HELP HLP_DEGREE_30_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_35: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_35_30
{
    LABEL LBL_DEGREE_35_30;
    HELP HLP_DEGREE_35_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_40: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_40_30
{
    LABEL LBL_DEGREE_40_30;
    HELP HLP_DEGREE_40_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_45: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_45_30
{
    LABEL LBL_DEGREE_45_30;
    HELP HLP_DEGREE_45_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_50: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_50_30
{
    LABEL LBL_DEGREE_50_30;
    HELP HLP_DEGREE_50_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_55: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_55_30
{
    LABEL LBL_DEGREE_55_30;
    HELP HLP_DEGREE_55_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_60: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_60_30
{
    LABEL LBL_DEGREE_60_30;
    HELP HLP_DEGREE_60_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_65: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_65_30
{
    LABEL LBL_DEGREE_65_30;
    HELP HLP_DEGREE_65_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_70: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_70_30
{
    LABEL LBL_DEGREE_70_30;
    HELP HLP_DEGREE_70_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_75: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_75_30
{
    LABEL LBL_DEGREE_75_30;
    HELP HLP_DEGREE_75_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_80: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_80_30
{
    LABEL LBL_DEGREE_80_30;
    HELP HLP_DEGREE_80_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_85: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_85_30
{
    LABEL LBL_DEGREE_85_30;
    HELP HLP_DEGREE_85_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_90: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_90_30
{
    LABEL LBL_DEGREE_90_30;
    HELP HLP_DEGREE_90_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable DEGREE_95: Enter value for 2nd user buffer pH
 //----------------------------------------------------------------------------
 */
VARIABLE degree_95_30
{
    LABEL LBL_DEGREE_95_30;
    HELP HLP_DEGREE_95_30;
    CLASS CONTAINED;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_SAMPLE_PRD: Starts product calibration step 1. Is automatically reset to NOP
 //----------------------------------------------------------------------------
 */
VARIABLE cal_sample_prd
{
    LABEL LBL_CAL_SAMPLE_PRD_31;
    HELP HLP_CAL_SAMPLE_PRD_31;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CAL_SAMPLE_PRD_31_VAL_0, HLP_CAL_SAMPLE_PRD_31_VAL_0},
        {   1, LBL_CAL_SAMPLE_PRD_31_VAL_1, HLP_CAL_SAMPLE_PRD_31_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_SAMPLE_PRD_STORED_VAL: Shows the stored value of product calibration step 1
 //----------------------------------------------------------------------------
 */
VARIABLE cal_sample_prd_stored_val
{
    LABEL LBL_CAL_SAMPLE_PRD_STORED_VAL_32;
    HELP HLP_CAL_SAMPLE_PRD_STORED_VAL_32;
    CLASS OUTPUT & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
    }
    HANDLING READ;
    VALIDITY IF (cal_prd_step == 1) { TRUE; } ELSE { FALSE; }
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_PRODUCT: Sets the value for the 2nd part of product calibration
 //----------------------------------------------------------------------------
 */
VARIABLE cal_product
{
    LABEL LBL_CAL_PRODUCT_33;
    HELP HLP_CAL_PRODUCT_33;
    CLASS OUTPUT & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "6.3f";
        EDIT_FORMAT "6.3f";
    }
    HANDLING READ & WRITE;    
    POST_WRITE_ACTIONS {method_prd_cal_state_valueWrite}
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_PRD_STEP: Show the step of calibration state machine
 //----------------------------------------------------------------------------
 */
VARIABLE cal_prd_step
{
    LABEL LBL_CAL_PRD_STEP_34;
    HELP HLP_CAL_PRD_STEP_34;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    DEFAULT_VALUE 2;
    INITIAL_VALUE 2;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_RESULT: Result of last calibration
 //----------------------------------------------------------------------------
 */
VARIABLE cal_result
{
    LABEL LBL_CAL_RESULT_35;
    HELP HLP_CAL_RESULT_35;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CAL_RESULT_35_VAL_0, HLP_CAL_RESULT_35_VAL_0},
        {   1, LBL_CAL_RESULT_35_VAL_1, HLP_CAL_RESULT_35_VAL_1}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable LOGBOOK_ENTRY: Set the group index of logbook which should be read.
 //----------------------------------------------------------------------------
 */
VARIABLE logbook_entry
{
    LABEL LBL_LOGBOOK_ENTRY_36;
    HELP HLP_LOGBOOK_ENTRY_36;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ & WRITE;
}
/*
 //----------------------------------------------------------------------------
 // Variable LOGBOOK_BINARY_DATA: Raw Data
 //----------------------------------------------------------------------------
 */
/*VARIABLE logbook_binary_data
 {
 LABEL          LBL_LOGBOOK_BINARY_DATA_37;
 HELP           HLP_LOGBOOK_BINARY_DATA_37;
 CLASS          CONTAINED;
 TYPE           OCTET(92);
 HANDLING       READ;
 }*/
/* !!!! manuelle Anpassung, nicht berschreiben !!!!*/
VARIABLE logbook_binary_dataType
{
    LABEL LBL_LOGBOOK_BINARY_DATA_37;
    HELP HLP_LOGBOOK_BINARY_DATA_37;
    CLASS LOCAL;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ & WRITE;
}

ARRAY logbook_binary_data
{
    LABEL LBL_LOGBOOK_BINARY_DATA_37;
    HELP HLP_LOGBOOK_BINARY_DATA_37;
    NUMBER_OF_ELEMENTS 78;
    TYPE logbook_binary_dataType;
}

/*
 //----------------------------------------------------------------------------
 // Variable LOGBOOK_ERASE: Erases the logbook.
 //----------------------------------------------------------------------------
 */
VARIABLE logbook_erase
{
    LABEL LBL_LOGBOOK_ERASE_38;
    HELP HLP_LOGBOOK_ERASE_38;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_LOGBOOK_ERASE_38_VAL_0, HLP_LOGBOOK_ERASE_38_VAL_0},
        {   1, LBL_LOGBOOK_ERASE_38_VAL_1, HLP_LOGBOOK_ERASE_38_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SNS_STATUS: Shows the Status
 //----------------------------------------------------------------------------
 */
VARIABLE sns_status_39
{
    LABEL LBL_SNS_STATUS_39;
    HELP HLP_SNS_STATUS_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE UNSIGNED_INTEGER(2);
    HANDLING READ;
}
/*
 //----------------------------------------------------------------------------
 // Variable RUNTIME: Runtime of digital Sensor
 //----------------------------------------------------------------------------
 */
VARIABLE runtime_39
{
    LABEL LBL_RUNTIME_39;
    HELP HLP_RUNTIME_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ;
    CONSTANT_UNIT "h";
}

/*
 //----------------------------------------------------------------------------
 // Variable SIP_CYCLES: SIP cycles
 //----------------------------------------------------------------------------
 */
VARIABLE sip_cycles_39
{
    LABEL LBL_SIP_CYCLES_39;
    HELP HLP_SIP_CYCLES_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE UNSIGNED_INTEGER(2);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable CIP_CYCLES: CIP cycles
 //----------------------------------------------------------------------------
 */
VARIABLE cip_cycles_39
{
    LABEL LBL_CIP_CYCLES_39;
    HELP HLP_CIP_CYCLES_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE UNSIGNED_INTEGER(2);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable TTM: Time to maintanance
 //----------------------------------------------------------------------------
 */
VARIABLE ttm_39
{
    LABEL LBL_TTM_39;
    HELP HLP_TTM_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable DLI: DLI with ISM Sensor (digital lifetime indicator) Lifetime for Memosens
 //----------------------------------------------------------------------------
 */
VARIABLE dli_39
{
    LABEL LBL_DLI_39;
    HELP HLP_DLI_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable ACT: ACT
 //----------------------------------------------------------------------------
 */
VARIABLE act_39
{
    LABEL LBL_ACT_39;
    HELP HLP_ACT_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable AUTOCLAVE: Autoclave
 //----------------------------------------------------------------------------
 */
VARIABLE autoclave_39
{
    LABEL LBL_AUTOCLAVE_39;
    HELP HLP_AUTOCLAVE_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable WEAR: Sensor wear for Memosens pH or DO sensors
 //----------------------------------------------------------------------------
 */
VARIABLE wear_39
{
    LABEL LBL_WEAR_39;
    HELP HLP_WEAR_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.1f";
        EDIT_FORMAT "5.1f";
    }
    CONSTANT_UNIT "%";
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable SMILEY: Shows the Smiley Status
 //----------------------------------------------------------------------------
 */
VARIABLE smiley_39
{
    LABEL LBL_SMILEY_39;
    HELP HLP_SMILEY_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE UNSIGNED_INTEGER(2);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable CALTIMER: Time until next calibration
 //----------------------------------------------------------------------------
 */
VARIABLE caltimer_39
{
    LABEL LBL_CALTIMER_39;
    HELP HLP_CALTIMER_39;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.1f";
        EDIT_FORMAT "5.1f";
    }
    CONSTANT_UNIT  "h";
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable SENSOR_REQUEST_BIN: Request data of sensor information.
 //----------------------------------------------------------------------------
 */
VARIABLE sensor_request_bin
{
    LABEL LBL_SENSOR_REQUEST_BIN_40;
    HELP HLP_SENSOR_REQUEST_BIN_40;
    CLASS CONTAINED;
    TYPE OCTET(20);
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SENSOR_RESPONSE_BIN: Response data of sensor information.
 //----------------------------------------------------------------------------
 */
VARIABLE sensor_response_bin
{
    LABEL LBL_SENSOR_RESPONSE_BIN_41;
    HELP HLP_SENSOR_RESPONSE_BIN_41;
    CLASS CONTAINED;
    TYPE OCTET(32);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable PH_CAL_SLOPE: pH-Slope with read/write access
 //----------------------------------------------------------------------------
 */
VARIABLE ph_cal_slope
{
    LABEL LBL_PH_CAL_SLOPE_42;
    HELP HLP_PH_CAL_SLOPE_42;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.1f";
        EDIT_FORMAT "5.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "%";
}

/*
 //----------------------------------------------------------------------------
 // Variable PH_CAL_ZERO: pH-Zero with read/write access
 //----------------------------------------------------------------------------
 */
VARIABLE ph_cal_zero
{
    LABEL LBL_PH_CAL_ZERO_43;
    HELP HLP_PH_CAL_ZERO_43;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "mV";
}

/*
 //----------------------------------------------------------------------------
 // Variable PH_CAL_OFFSET_ISFET: Isfet-Offset with read/write access (ISM only)
 //----------------------------------------------------------------------------
 */
VARIABLE ph_cal_offset_isfet
{
    LABEL LBL_PH_CAL_OFFSET_ISFET_44;
    HELP HLP_PH_CAL_OFFSET_ISFET_44;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.1f";
        EDIT_FORMAT "4.1f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "mV";
}

/*
 //----------------------------------------------------------------------------
 // Variable PH_CALZERO_ORP: ORP-Zero with read/write access (ORP only)
 //----------------------------------------------------------------------------
 */
VARIABLE ph_calzero_orp
{
    LABEL LBL_PH_CALZERO_ORP_45;
    HELP HLP_PH_CALZERO_ORP_45;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "mV";
}

/*
 //----------------------------------------------------------------------------
 // Variable DO_CAL_SLOPE: DO-Slope with read/write access
 //----------------------------------------------------------------------------
 */
VARIABLE do_cal_slope
{
    LABEL LBL_DO_CAL_SLOPE_46;
    HELP HLP_DO_CAL_SLOPE_46;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.1f";
        EDIT_FORMAT "5.1f";
    }
    HANDLING READ & WRITE;
#ifndef STRATOS_DP
    CONSTANT_UNIT "nA";
#endif
}

/*
 //----------------------------------------------------------------------------
 // Variable DO_CAL_ZERO: DO-Zero with read/write access
 //----------------------------------------------------------------------------
 */
VARIABLE do_cal_zero
{
    LABEL LBL_DO_CAL_ZERO_47;
    HELP HLP_DO_CAL_ZERO_47;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.2f";
        EDIT_FORMAT "4.2f";
    }
    HANDLING READ & WRITE;
#ifndef STRATOS_DP
    CONSTANT_UNIT "nA";
#endif
}

/*
 //----------------------------------------------------------------------------
 // Variable DO_CAL_RH: relative humidity while calibration [%]
 //----------------------------------------------------------------------------
 */
VARIABLE do_cal_rh
{
    LABEL LBL_DO_CAL_RH_48;
    HELP HLP_DO_CAL_RH_48;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable COND_CELLCONST: Enter the cellfactor of your sensor
 //----------------------------------------------------------------------------
 */
VARIABLE cond_cellconst
{
    LABEL LBL_COND_CELLCONST_49;
    HELP HLP_COND_CELLCONST_49;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "7.4f";
        EDIT_FORMAT "7.4f";
        MIN_VALUE 0.0050;
        MAX_VALUE 19.9999;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "1/cm";
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_CELLFACTOR: Enter the cellfactor of your sensor
 //----------------------------------------------------------------------------
 */
VARIABLE tc_cellfactor
{
    LABEL LBL_TC_CELLFACTOR_50;
    HELP HLP_TC_CELLFACTOR_50;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "6.3f";
        EDIT_FORMAT "6.3f";
        MIN_VALUE 0.100;
        MAX_VALUE 19.999;
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "1/cm";
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_INSTALL: Install factor
 //----------------------------------------------------------------------------
 */
VARIABLE tc_install
{
    LABEL LBL_TC_INSTALL_51;
    HELP HLP_TC_INSTALL_51;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "5.3f";
        EDIT_FORMAT "5.3f";
        MIN_VALUE 0.100;
        MAX_VALUE 5.000;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_ZERO: Enter the zero of your sensor
 //----------------------------------------------------------------------------
 */
VARIABLE tc_zero
{
    LABEL LBL_TC_ZERO_52;
    HELP HLP_TC_ZERO_52;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "4.0f";
        EDIT_FORMAT "4.0f";
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable TC_TRANS_RATIO: Enter the trans ration of your sensor
 //----------------------------------------------------------------------------
 */
VARIABLE tc_trans_ratio
{
    LABEL LBL_TC_TRANS_RATIO_53;
    HELP HLP_TC_TRANS_RATIO_53;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "6.2f";
        EDIT_FORMAT "6.2f";
        MIN_VALUE 1.00;
        MAX_VALUE 199.99;
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable CC_CELLFACTOR_A: Enter the cellfactor of sensor A (CC only)
 //----------------------------------------------------------------------------
 */
VARIABLE cc_cellfactor_a
{
    LABEL LBL_CC_CELLFACTOR_A_54;
    HELP HLP_CC_CELLFACTOR_A_54;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "7.4f";
        EDIT_FORMAT "7.4f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "1/cm";
}

/*
 //----------------------------------------------------------------------------
 // Variable CC_CELLFACTOR_B: Enter the cellfactor of sensor B (CC only)
 //----------------------------------------------------------------------------
 */
VARIABLE cc_cellfactor_b
{
    LABEL LBL_CC_CELLFACTOR_B_55;
    HELP HLP_CC_CELLFACTOR_B_55;
    CLASS CONTAINED & DYNAMIC;
    TYPE FLOAT
    {
        DISPLAY_FORMAT "7.4f";
        EDIT_FORMAT "7.4f";
    }
    HANDLING READ & WRITE;
    CONSTANT_UNIT "1/cm";
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_TIMESTAMP: Time of last calibration
 //----------------------------------------------------------------------------
 */
VARIABLE cal_timestamp
{
    LABEL LBL_CAL_TIMESTAMP_56;
    HELP HLP_CAL_TIMESTAMP_56;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(19);
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable HOLD: Select status behaviour while calibration, configuration and service
 //----------------------------------------------------------------------------
 */
VARIABLE hold
{
    LABEL LBL_HOLD_57;
    HELP HLP_HOLD_57;
    CLASS CONTAINED;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_HOLD_57_VAL_0, HLP_HOLD_57_VAL_0},
        {   1, LBL_HOLD_57_VAL_1, HLP_HOLD_57_VAL_1}
    }
    HANDLING READ & WRITE;
}

/*
 //----------------------------------------------------------------------------
 // Variable SERIAL_NO_BASE: Serial number of device
 //----------------------------------------------------------------------------
 */
VARIABLE serial_no_base_58
{
    LABEL LBL_SERIAL_NO_BASE_58;
    HELP HLP_SERIAL_NO_BASE_58;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(4);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable SW_VER_BASE: Software version of device
 //----------------------------------------------------------------------------
 */
VARIABLE sw_ver_base_58
{
    LABEL LBL_SW_VER_BASE_58;
    HELP HLP_SW_VER_BASE_58;
    CLASS CONTAINED;
    TYPE OCTET(8);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable HW_VER_BASE: Software version of device
 //----------------------------------------------------------------------------
 */
VARIABLE hw_ver_base_58
{
    LABEL LBL_HW_VER_BASE_58;
    HELP HLP_HW_VER_BASE_58;
    CLASS CONTAINED;
    TYPE OCTET(2);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable SERIAL_NO_MEAS: Serial number of digital sensor
 //----------------------------------------------------------------------------
 */
VARIABLE serial_no_meas_58
{
    LABEL LBL_SERIAL_NO_MEAS_58;
    HELP HLP_SERIAL_NO_MEAS_58;
    CLASS CONTAINED  & DYNAMIC;
    TYPE ASCII(16);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable SW_VER_MEAS: Software Version of digital sensor
 //----------------------------------------------------------------------------
 */
VARIABLE sw_ver_meas_58
{
    LABEL LBL_SW_VER_MEAS_58;
    HELP HLP_SW_VER_MEAS_58;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(8);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable HW_VER_MEAS: Hardware Version of digital sensor
 //----------------------------------------------------------------------------
 */
VARIABLE hw_ver_meas_58
{
    LABEL LBL_HW_VER_MEAS_58;
    HELP HLP_HW_VER_MEAS_58;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(2);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: pH Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_59
{
    LABEL LBL_VALUE_59;
    HELP HLP_VALUE_59;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_59
{
    LABEL LBL_STATUS_59;
    HELP HLP_STATUS_59;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: mV Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_60
{
    LABEL LBL_VALUE_60;
    HELP HLP_VALUE_60;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_60
{
    LABEL LBL_STATUS_60;
    HELP HLP_STATUS_60;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: ORP Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_61
{
    LABEL LBL_VALUE_61;
    HELP HLP_VALUE_61;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_61
{
    LABEL LBL_STATUS_61;
    HELP HLP_STATUS_61;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Glass Impedance Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_62
{
    LABEL LBL_VALUE_62;
    HELP HLP_VALUE_62;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_62
{
    LABEL LBL_STATUS_62;
    HELP HLP_STATUS_62;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Reference Impedance Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_63
{
    LABEL LBL_VALUE_63;
    HELP HLP_VALUE_63;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_63
{
    LABEL LBL_STATUS_63;
    HELP HLP_STATUS_63;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Temperature
 //----------------------------------------------------------------------------
 */
VARIABLE value_64
{
    LABEL LBL_VALUE_64;
    HELP HLP_VALUE_64;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_64
{
    LABEL LBL_STATUS_64;
    HELP HLP_STATUS_64;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable PV_TEMPERATURE_UNIT: Select the unit of Temperature
 //----------------------------------------------------------------------------
 */
VARIABLE pv_temperature_unit
{
    LABEL LBL_PV_TEMPERATURE_UNIT_65;
    HELP HLP_PV_TEMPERATURE_UNIT_65;
    CLASS CONTAINED;
    TYPE ENUMERATED(2)
    {
        {   1001,LBL_PV_TEMPERATURE_UNIT_65_VAL_1001,HLP_PV_TEMPERATURE_UNIT_65_VAL_1001},
        {   1002,LBL_PV_TEMPERATURE_UNIT_65_VAL_1002,HLP_PV_TEMPERATURE_UNIT_65_VAL_1002},
        {   1059,LBL_PV_TEMPERATURE_UNIT_65_VAL_1059,HLP_PV_TEMPERATURE_UNIT_65_VAL_1059},
        {   1133,LBL_PV_TEMPERATURE_UNIT_65_VAL_1133,HLP_PV_TEMPERATURE_UNIT_65_VAL_1133},
        {   1137,LBL_PV_TEMPERATURE_UNIT_65_VAL_1137,HLP_PV_TEMPERATURE_UNIT_65_VAL_1137},
        {   1138,LBL_PV_TEMPERATURE_UNIT_65_VAL_1138,HLP_PV_TEMPERATURE_UNIT_65_VAL_1138},
        {   1141,LBL_PV_TEMPERATURE_UNIT_65_VAL_1141,HLP_PV_TEMPERATURE_UNIT_65_VAL_1141},
        {   1213,LBL_PV_TEMPERATURE_UNIT_65_VAL_1213,HLP_PV_TEMPERATURE_UNIT_65_VAL_1213},
        {   1243,LBL_PV_TEMPERATURE_UNIT_65_VAL_1243,HLP_PV_TEMPERATURE_UNIT_65_VAL_1243},
        {   1281,LBL_PV_TEMPERATURE_UNIT_65_VAL_1281,HLP_PV_TEMPERATURE_UNIT_65_VAL_1281},
        {   1342,LBL_PV_TEMPERATURE_UNIT_65_VAL_1342,HLP_PV_TEMPERATURE_UNIT_65_VAL_1342},
        {   1353,LBL_PV_TEMPERATURE_UNIT_65_VAL_1353,HLP_PV_TEMPERATURE_UNIT_65_VAL_1353},
        {   1422,LBL_PV_TEMPERATURE_UNIT_65_VAL_1422,HLP_PV_TEMPERATURE_UNIT_65_VAL_1422},
        {   1423,LBL_PV_TEMPERATURE_UNIT_65_VAL_1423,HLP_PV_TEMPERATURE_UNIT_65_VAL_1423},
        {   1523,LBL_PV_TEMPERATURE_UNIT_65_VAL_1523,HLP_PV_TEMPERATURE_UNIT_65_VAL_1523},
        {   1524,LBL_PV_TEMPERATURE_UNIT_65_VAL_1524,HLP_PV_TEMPERATURE_UNIT_65_VAL_1524},
        {   1552,LBL_PV_TEMPERATURE_UNIT_65_VAL_1552,HLP_PV_TEMPERATURE_UNIT_65_VAL_1552},
        {   1555,LBL_PV_TEMPERATURE_UNIT_65_VAL_1555,HLP_PV_TEMPERATURE_UNIT_65_VAL_1555},
        {   1558,LBL_PV_TEMPERATURE_UNIT_65_VAL_1558,HLP_PV_TEMPERATURE_UNIT_65_VAL_1558},
        {   1559,LBL_PV_TEMPERATURE_UNIT_65_VAL_1559,HLP_PV_TEMPERATURE_UNIT_65_VAL_1559},
        {   1562,LBL_PV_TEMPERATURE_UNIT_65_VAL_1562,HLP_PV_TEMPERATURE_UNIT_65_VAL_1562},
        {   0,LBL_PV_TEMPERATURE_UNIT_65_VAL_0,HLP_PV_TEMPERATURE_UNIT_65_VAL_0}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Calibration timer is used to remind you for a calibration. Not for ISM sensors.
 //----------------------------------------------------------------------------
 */
VARIABLE value_66
{
    LABEL LBL_VALUE_66;
    HELP HLP_VALUE_66;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_66
{
    LABEL LBL_STATUS_66;
    HELP HLP_STATUS_66;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Slope
 //----------------------------------------------------------------------------
 */
VARIABLE value_67
{
    LABEL LBL_VALUE_67;
    HELP HLP_VALUE_67;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_67
{
    LABEL LBL_STATUS_67;
    HELP HLP_STATUS_67;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable PV_SLOPE_UNIT: Select the slope unit
 //----------------------------------------------------------------------------
 */
VARIABLE pv_slope_unit
{
    LABEL LBL_PV_SLOPE_UNIT_68;
    HELP HLP_PV_SLOPE_UNIT_68;
    CLASS CONTAINED;
    TYPE ENUMERATED(2)
    {
        {   1001, LBL_PV_SLOPE_UNIT_68_VAL_1001, HLP_PV_SLOPE_UNIT_68_VAL_1001},
        {   1002, LBL_PV_SLOPE_UNIT_68_VAL_1002, HLP_PV_SLOPE_UNIT_68_VAL_1002},
        {   1059, LBL_PV_SLOPE_UNIT_68_VAL_1059, HLP_PV_SLOPE_UNIT_68_VAL_1059},
        {   1133, LBL_PV_SLOPE_UNIT_68_VAL_1133, HLP_PV_SLOPE_UNIT_68_VAL_1133},
        {   1137, LBL_PV_SLOPE_UNIT_68_VAL_1137, HLP_PV_SLOPE_UNIT_68_VAL_1137},
        {   1138, LBL_PV_SLOPE_UNIT_68_VAL_1138, HLP_PV_SLOPE_UNIT_68_VAL_1138},
        {   1141, LBL_PV_SLOPE_UNIT_68_VAL_1141, HLP_PV_SLOPE_UNIT_68_VAL_1141},
        {   1209, LBL_PV_SLOPE_UNIT_68_VAL_1209, HLP_PV_SLOPE_UNIT_68_VAL_1209},
        {   1213, LBL_PV_SLOPE_UNIT_68_VAL_1213, HLP_PV_SLOPE_UNIT_68_VAL_1213},
        {   1243, LBL_PV_SLOPE_UNIT_68_VAL_1243, HLP_PV_SLOPE_UNIT_68_VAL_1243},
        {   1281, LBL_PV_SLOPE_UNIT_68_VAL_1281, HLP_PV_SLOPE_UNIT_68_VAL_1281},
        {   1299, LBL_PV_SLOPE_UNIT_68_VAL_1299, HLP_PV_SLOPE_UNIT_68_VAL_1299},
        {   1302, LBL_PV_SLOPE_UNIT_68_VAL_1302, HLP_PV_SLOPE_UNIT_68_VAL_1302},
        {   1342, LBL_PV_SLOPE_UNIT_68_VAL_1342, HLP_PV_SLOPE_UNIT_68_VAL_1342},
        {   1353, LBL_PV_SLOPE_UNIT_68_VAL_1353, HLP_PV_SLOPE_UNIT_68_VAL_1353},
        {   1422, LBL_PV_SLOPE_UNIT_68_VAL_1422, HLP_PV_SLOPE_UNIT_68_VAL_1422},
        {   1423, LBL_PV_SLOPE_UNIT_68_VAL_1423, HLP_PV_SLOPE_UNIT_68_VAL_1423},
        {   1523, LBL_PV_SLOPE_UNIT_68_VAL_1523, HLP_PV_SLOPE_UNIT_68_VAL_1523},
        {   1524, LBL_PV_SLOPE_UNIT_68_VAL_1524, HLP_PV_SLOPE_UNIT_68_VAL_1524},
        {   1552, LBL_PV_SLOPE_UNIT_68_VAL_1552, HLP_PV_SLOPE_UNIT_68_VAL_1552},
        {   1553, LBL_PV_SLOPE_UNIT_68_VAL_1553, HLP_PV_SLOPE_UNIT_68_VAL_1553},
        {   1555, LBL_PV_SLOPE_UNIT_68_VAL_1555, HLP_PV_SLOPE_UNIT_68_VAL_1555},
        {   1558, LBL_PV_SLOPE_UNIT_68_VAL_1558, HLP_PV_SLOPE_UNIT_68_VAL_1558},
        {   1559, LBL_PV_SLOPE_UNIT_68_VAL_1559, HLP_PV_SLOPE_UNIT_68_VAL_1559},
        {   1562, LBL_PV_SLOPE_UNIT_68_VAL_1562, HLP_PV_SLOPE_UNIT_68_VAL_1562},
        {   0, LBL_PV_SLOPE_UNIT_68_VAL_0, HLP_PV_SLOPE_UNIT_68_VAL_0}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Zero
 //----------------------------------------------------------------------------
 */
VARIABLE value_69
{
    LABEL LBL_VALUE_69;
    HELP HLP_VALUE_69;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_69
{
    LABEL LBL_STATUS_69;
    HELP HLP_STATUS_69;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Sensor wear for Memosens pH or DO sensors
 //----------------------------------------------------------------------------
 */
VARIABLE value_70
{
    LABEL LBL_VALUE_70;
    HELP HLP_VALUE_70;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_70
{
    LABEL LBL_STATUS_70;
    HELP HLP_STATUS_70;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Flow-value
 //----------------------------------------------------------------------------
 */
VARIABLE value_71
{
    LABEL LBL_VALUE_71;
    HELP HLP_VALUE_71;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_71
{
    LABEL LBL_STATUS_71;
    HELP HLP_STATUS_71;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Saturation Air
 //----------------------------------------------------------------------------
 */
VARIABLE value_72
{
    LABEL LBL_VALUE_72;
    HELP HLP_VALUE_72;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_72
{
    LABEL LBL_STATUS_72;
    HELP HLP_STATUS_72;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: DO Concentration
 //----------------------------------------------------------------------------
 */
VARIABLE value_73
{
    LABEL LBL_VALUE_73;
    HELP HLP_VALUE_73;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_73
{
    LABEL LBL_STATUS_73;
    HELP HLP_STATUS_73;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable PV_DO_CONCENTRATION_UNIT: Select the unit for do concentration
 //----------------------------------------------------------------------------
 */
VARIABLE pv_do_concentration_unit
{
    LABEL LBL_PV_DO_CONCENTRATION_UNIT_74;
    HELP HLP_PV_DO_CONCENTRATION_UNIT_74;
    CLASS CONTAINED;
    TYPE ENUMERATED(2)
    {
        {   1001,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1001,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1001},
        {   1002,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1002,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1002},
        {   1059,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1059,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1059},
        {   1133,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1133,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1133},
        {   1137,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1137,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1137},
        {   1138,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1138,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1138},
        {   1141,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1141,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1141},
        {   1209,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1209,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1209},
        {   1213,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1213,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1213},
        {   1243,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1243,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1243},
        {   1281,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1281,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1281},
        {   1299,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1299,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1299},
        {   1302,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1302,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1302},
        {   1342,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1342,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1342},
        {   1353,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1353,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1353},
        {   1422,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1422,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1422},
        {   1423,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1423,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1423},
        {   1523,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1523,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1523},
        {   1524,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1524,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1524},
        {   1552,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1552,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1552},
        {   1553,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1553,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1553},
        {   1555,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1555,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1555},
        {   1558,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1558,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1558},
        {   1559,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1559,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1559},
        {   1562,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_1562,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_1562},
        {   0,LBL_PV_DO_CONCENTRATION_UNIT_74_VAL_0,HLP_PV_DO_CONCENTRATION_UNIT_74_VAL_0}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Volume concentration in gas
 //----------------------------------------------------------------------------
 */
VARIABLE value_75
{
    LABEL LBL_VALUE_75;
    HELP HLP_VALUE_75;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_75
{
    LABEL LBL_STATUS_75;
    HELP HLP_STATUS_75;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Partial Pressure
 //----------------------------------------------------------------------------
 */
VARIABLE value_76
{
    LABEL LBL_VALUE_76;
    HELP HLP_VALUE_76;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_76
{
    LABEL LBL_STATUS_76;
    HELP HLP_STATUS_76;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Conductivity
 //----------------------------------------------------------------------------
 */
VARIABLE value_77
{
    LABEL LBL_VALUE_77;
    HELP HLP_VALUE_77;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_77
{
    LABEL LBL_STATUS_77;
    HELP HLP_STATUS_77;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable PV_CONDUCTIVITY_UNIT: Select the unit of conductivity
 //----------------------------------------------------------------------------
 */
VARIABLE pv_conductivity_unit
{
    LABEL LBL_PV_CONDUCTIVITY_UNIT_78;
    HELP HLP_PV_CONDUCTIVITY_UNIT_78;
    CLASS CONTAINED;
    TYPE ENUMERATED(2)
    {
        {   1001,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1001,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1001},
        {   1002,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1002,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1002},
        {   1059,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1059,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1059},
        {   1133,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1133,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1133},
        {   1137,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1137,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1137},
        {   1138,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1138,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1138},
        {   1141,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1141,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1141},
        {   1209,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1209,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1209},
        {   1213,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1213,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1213},
        {   1243,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1243,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1243},
        {   1281,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1281,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1281},
        {   1299,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1299,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1299},
        {   1302,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1302,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1302},
        {   1342,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1342,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1342},
        {   1353,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1353,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1353},
        {   1422,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1422,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1422},
        {   1423,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1423,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1423},
        {   1523,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1523,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1523},
        {   1524,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1524,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1524},
        {   1552,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1552,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1552},
        {   1553,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1553,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1553},
        {   1555,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1555,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1555},
        {   1558,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1558,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1558},
        {   1559,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1559,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1559},
        {   1562,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_1562,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_1562},
        {   0,LBL_PV_CONDUCTIVITY_UNIT_78_VAL_0,HLP_PV_CONDUCTIVITY_UNIT_78_VAL_0}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Specific Resistance
 //----------------------------------------------------------------------------
 */
VARIABLE value_79
{
    LABEL LBL_VALUE_79;
    HELP HLP_VALUE_79;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_79
{
    LABEL LBL_STATUS_79;
    HELP HLP_STATUS_79;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Concentration
 //----------------------------------------------------------------------------
 */
VARIABLE value_80
{
    LABEL LBL_VALUE_80;
    HELP HLP_VALUE_80;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_80
{
    LABEL LBL_STATUS_80;
    HELP HLP_STATUS_80;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Conductance
 //----------------------------------------------------------------------------
 */
VARIABLE value_81
{
    LABEL LBL_VALUE_81;
    HELP HLP_VALUE_81;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_81
{
    LABEL LBL_STATUS_81;
    HELP HLP_STATUS_81;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Salinity
 //----------------------------------------------------------------------------
 */
VARIABLE value_82
{
    LABEL LBL_VALUE_82;
    HELP HLP_VALUE_82;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_82
{
    LABEL LBL_STATUS_82;
    HELP HLP_STATUS_82;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: TDS
 //----------------------------------------------------------------------------
 */
VARIABLE value_83
{
    LABEL LBL_VALUE_83;
    HELP HLP_VALUE_83;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_83
{
    LABEL LBL_STATUS_83;
    HELP HLP_STATUS_83;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: CC: Conductivity 2nd value
 //----------------------------------------------------------------------------
 */
VARIABLE value_84
{
    LABEL LBL_VALUE_84;
    HELP HLP_VALUE_84;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_84
{
    LABEL LBL_STATUS_84;
    HELP HLP_STATUS_84;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: CC: calculated value related to CC_Calculation type
 //----------------------------------------------------------------------------
 */
VARIABLE value_85
{
    LABEL LBL_VALUE_85;
    HELP HLP_VALUE_85;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_85
{
    LABEL LBL_STATUS_85;
    HELP HLP_STATUS_85;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Cellfactor
 //----------------------------------------------------------------------------
 */
VARIABLE value_86
{
    LABEL LBL_VALUE_86;
    HELP HLP_VALUE_86;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_86
{
    LABEL LBL_STATUS_86;
    HELP HLP_STATUS_86;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: CC: Temperature 2nd value
 //----------------------------------------------------------------------------
 */
VARIABLE value_87
{
    LABEL LBL_VALUE_87;
    HELP HLP_VALUE_87;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_87
{
    LABEL LBL_STATUS_87;
    HELP HLP_STATUS_87;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable PV_TEMPERATURE_2_UNIT: CC: Select the unit of Temperature
 //----------------------------------------------------------------------------
 */
VARIABLE pv_temperature_2_unit
{
    LABEL LBL_PV_TEMPERATURE_2_UNIT_88;
    HELP HLP_PV_TEMPERATURE_2_UNIT_88;
    CLASS CONTAINED;
    TYPE ENUMERATED(2)
    {
        {   1001,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1001,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1001},
        {   1002,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1002,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1002},
        {   1059,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1059,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1059},
        {   1133,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1133,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1133},
        {   1137,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1137,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1137},
        {   1138,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1138,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1138},
        {   1141,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1141,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1141},
        {   1213,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1213,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1213},
        {   1243,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1243,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1243},
        {   1281,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1281,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1281},
        {   1342,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1342,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1342},
        {   1353,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1353,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1353},
        {   1422,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1422,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1422},
        {   1423,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1423,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1423},
        {   1523,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1523,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1523},
        {   1524,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1524,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1524},
        {   1552,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1552,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1552},
        {   1555,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1555,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1555},
        {   1558,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1558,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1558},
        {   1559,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1559,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1559},
        {   1562,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_1562,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_1562},
        {   0,LBL_PV_TEMPERATURE_2_UNIT_88_VAL_0,HLP_PV_TEMPERATURE_2_UNIT_88_VAL_0}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable CAL_PRD_STORED_VAL_UNIT: Unit of value while Product Calibration.
 //----------------------------------------------------------------------------
 */
VARIABLE cal_prd_stored_val_unit
{
    LABEL LBL_CAL_PRD_STORED_VAL_UNIT_89;
    HELP HLP_CAL_PRD_STORED_VAL_UNIT_89;
    CLASS CONTAINED;
    TYPE ENUMERATED(2)
    {
        {   1001,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1001,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1001},
        {   1002,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1002,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1002},
        {   1059,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1059,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1059},
        {   1133,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1133,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1133},
        {   1137,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1137,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1137},
        {   1138,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1138,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1138},
        {   1141,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1141,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1141},
        {   1209,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1209,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1209},
        {   1213,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1213,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1213},
        {   1243,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1243,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1243},
        {   1281,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1281,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1281},
        {   1299,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1299,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1299},
        {   1302,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1302,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1302},
        {   1342,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1342,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1342},
        {   1353,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1353,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1353},
        {   1422,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1422,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1422},
        {   1423,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1423,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1423},
        {   1523,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1523,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1523},
        {   1524,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1524,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1524},
        {   1552,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1552,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1552},
        {   1553,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1553,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1553},
        {   1555,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1555,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1555},
        {   1558,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1558,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1558},
        {   1559,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1559,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1559},
        {   1562,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_1562,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_1562},
        {   0,LBL_CAL_PRD_STORED_VAL_UNIT_89_VAL_0,HLP_CAL_PRD_STORED_VAL_UNIT_89_VAL_0}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_90
{
    LABEL LBL_VALUE_90;
    HELP HLP_VALUE_90;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_90
{
    LABEL LBL_STATUS_90;
    HELP HLP_STATUS_90;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_91
{
    LABEL LBL_VALUE_91;
    HELP HLP_VALUE_91;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_91
{
    LABEL LBL_STATUS_91;
    HELP HLP_STATUS_91;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_92
{
    LABEL LBL_VALUE_92;
    HELP HLP_VALUE_92;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_92
{
    LABEL LBL_STATUS_92;
    HELP HLP_STATUS_92;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_93
{
    LABEL LBL_VALUE_93;
    HELP HLP_VALUE_93;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_93
{
    LABEL LBL_STATUS_93;
    HELP HLP_STATUS_93;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_94
{
    LABEL LBL_VALUE_94;
    HELP HLP_VALUE_94;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_94
{
    LABEL LBL_STATUS_94;
    HELP HLP_STATUS_94;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_95
{
    LABEL LBL_VALUE_95;
    HELP HLP_VALUE_95;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_95
{
    LABEL LBL_STATUS_95;
    HELP HLP_STATUS_95;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_96
{
    LABEL LBL_VALUE_96;
    HELP HLP_VALUE_96;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_96
{
    LABEL LBL_STATUS_96;
    HELP HLP_STATUS_96;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Value
 //----------------------------------------------------------------------------
 */
VARIABLE value_97
{
    LABEL LBL_VALUE_97;
    HELP HLP_VALUE_97;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Status
 //----------------------------------------------------------------------------
 */
VARIABLE status_97
{
    LABEL LBL_STATUS_97;
    HELP HLP_STATUS_97;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable CURRENT_ERROR: Current error of the device
 //----------------------------------------------------------------------------
 */
VARIABLE current_error
{
    LABEL LBL_CURRENT_ERROR_98;
    HELP HLP_CURRENT_ERROR_98;
    CLASS CONTAINED & DYNAMIC;
    TYPE ENUMERATED(1)
    {
        {   0, LBL_CURRENT_ERROR_98_VAL_0, HLP_CURRENT_ERROR_98_VAL_0},
        {   102, LBL_CURRENT_ERROR_98_VAL_102, HLP_CURRENT_ERROR_98_VAL_102},
        {   103, LBL_CURRENT_ERROR_98_VAL_103, HLP_CURRENT_ERROR_98_VAL_103},
        {   59, LBL_CURRENT_ERROR_98_VAL_59, HLP_CURRENT_ERROR_98_VAL_59},
        {   45, LBL_CURRENT_ERROR_98_VAL_45, HLP_CURRENT_ERROR_98_VAL_45},
        {   41, LBL_CURRENT_ERROR_98_VAL_41, HLP_CURRENT_ERROR_98_VAL_41},
        {   43, LBL_CURRENT_ERROR_98_VAL_43, HLP_CURRENT_ERROR_98_VAL_43},
        {   40, LBL_CURRENT_ERROR_98_VAL_40, HLP_CURRENT_ERROR_98_VAL_40},
        {   13, LBL_CURRENT_ERROR_98_VAL_13, HLP_CURRENT_ERROR_98_VAL_13},
        {   16, LBL_CURRENT_ERROR_98_VAL_16, HLP_CURRENT_ERROR_98_VAL_16},
        {   10, LBL_CURRENT_ERROR_98_VAL_10, HLP_CURRENT_ERROR_98_VAL_10},
        {   11, LBL_CURRENT_ERROR_98_VAL_11, HLP_CURRENT_ERROR_98_VAL_11},
        {   12, LBL_CURRENT_ERROR_98_VAL_12, HLP_CURRENT_ERROR_98_VAL_12},
        {   15, LBL_CURRENT_ERROR_98_VAL_15, HLP_CURRENT_ERROR_98_VAL_15},
        {   5, LBL_CURRENT_ERROR_98_VAL_5, HLP_CURRENT_ERROR_98_VAL_5},
        {   4, LBL_CURRENT_ERROR_98_VAL_4, HLP_CURRENT_ERROR_98_VAL_4},
        {   3, LBL_CURRENT_ERROR_98_VAL_3, HLP_CURRENT_ERROR_98_VAL_3},
        {   2, LBL_CURRENT_ERROR_98_VAL_2, HLP_CURRENT_ERROR_98_VAL_2},
        {   1, LBL_CURRENT_ERROR_98_VAL_1, HLP_CURRENT_ERROR_98_VAL_1},
        {   96, LBL_CURRENT_ERROR_98_VAL_96, HLP_CURRENT_ERROR_98_VAL_96},
        {   97, LBL_CURRENT_ERROR_98_VAL_97, HLP_CURRENT_ERROR_98_VAL_97},
        {   94, LBL_CURRENT_ERROR_98_VAL_94, HLP_CURRENT_ERROR_98_VAL_94},
        {   95, LBL_CURRENT_ERROR_98_VAL_95, HLP_CURRENT_ERROR_98_VAL_95},
        {   98, LBL_CURRENT_ERROR_98_VAL_98, HLP_CURRENT_ERROR_98_VAL_98},
        {   99, LBL_CURRENT_ERROR_98_VAL_99, HLP_CURRENT_ERROR_98_VAL_99}
    }
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable STATUS: Specific Resistance
 //----------------------------------------------------------------------------
 */
VARIABLE status_99
{
    LABEL LBL_STATUS_99;
    HELP HLP_STATUS_99;
    CLASS CONTAINED;
    TYPE UNSIGNED_INTEGER(1);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable VALUE: Status
 //----------------------------------------------------------------------------
 */
VARIABLE value_99
{
    LABEL LBL_VALUE_99;
    HELP HLP_VALUE_99;
    CLASS CONTAINED;
    TYPE FLOAT;
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable SERIAL_NO: Serial number of digital sensor
 //----------------------------------------------------------------------------
 */
VARIABLE serial_no_100
{
    LABEL LBL_SERIAL_NO_100;
    HELP HLP_SERIAL_NO_100;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(16);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable ORDER_NO: Order number of digital sensor
 //----------------------------------------------------------------------------
 */
VARIABLE order_no_100
{
    LABEL LBL_ORDER_NO_100;
    HELP HLP_ORDER_NO_100;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(18);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable TAG: TAG of digital Sensor
 //----------------------------------------------------------------------------
 */
VARIABLE tag_100
{
    LABEL LBL_TAG_100;
    HELP HLP_TAG_100;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(32);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable MANU: Manufacturer of digital sensor
 //----------------------------------------------------------------------------
 */
VARIABLE manu_100
{
    LABEL LBL_MANU_100;
    HELP HLP_MANU_100;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(16);
    HANDLING READ;
}

/*
 //----------------------------------------------------------------------------
 // Variable INIT_OPERATION: Time of initial operation
 //----------------------------------------------------------------------------
 */
VARIABLE init_operation_100
{
    LABEL LBL_INIT_OPERATION_100;
    HELP HLP_INIT_OPERATION_100;
    CLASS CONTAINED & DYNAMIC;
    TYPE ASCII(19);
    HANDLING READ;
}

#ifdef USE_RECORDS
/*
 //----------------------------------------------------------------------------
 // Record pH: PH-parameters
 //----------------------------------------------------------------------------
 */
RECORD ph
{
    LABEL LBL_PH_19;
    HELP HLP_PH_19;
    MEMBERS
    {
        SENSORTYPE, sensortype_19;
        MEAS_MODE, meas_mode_19;
        RTD_TYPE, rtd_type_19;
        TEMP_UNIT, temp_unit_19;
        TEMP_MEAS, temp_meas_19;
        TEMP_MEAS_MAN, temp_meas_man_19;
        TEMP_CAL, temp_cal_19;
        TEMP_CAL_MAN, temp_cal_man_19;
        NOM_ZERO, nom_zero_19;
        NOM_SLOPE, nom_slope_19;
        PH_ISO, ph_iso_19;
        CALMODE, calmode_19;
        BUFFER_SET, buffer_set_19;
        CAL_TIMER, cal_timer_19;
        CAL_CYCLE, cal_cycle_19;
        ACT, act_19;
        ACT_CYCLE, act_cycle_19;
        TTM, ttm_19;
        TTM_CYCLE, ttm_cycle_19;
        CIP_COUNT, cip_count_19;
        CIP_CYCLES, cip_cycles_19;
        SIP_COUNT, sip_count_19;
        SIP_CYCLES, sip_cycles_19;
        AUTOCLAVE, autoclave_19;
        AC_CYCLES, ac_cycles_19;
        TC_SELECT, tc_select_19;
        TC_LIQUID, tc_liquid_19;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record CONDUCTIVITY: Conductivity parameters
 //----------------------------------------------------------------------------
 */
RECORD conductivity
{
    LABEL LBL_CONDUCTIVITY_20;
    HELP HLP_CONDUCTIVITY_20;
    MEMBERS
    {
        SENSORTYPE, sensortype_20;
        MEAS_MODE, meas_mode_20;
        DISPLAY_UNIT, display_unit_20;
        SOLUTION, solution_20;
        RTD_TYPE, rtd_type_20;
        TEMP_UNIT, temp_unit_20;
        TEMPERATURE, temperature_20;
        TEMPERATURE_MAN, temperature_man_20;
        CIP_COUNT, cip_count_20;
        SIP_COUNT, sip_count_20;
        TC_SELECT, tc_select_20;
        TC_LIQUID, tc_liquid_20;
        REF_TEMP, ref_temp_20;
        TDS_FACTOR, tds_factor_20;
        USP_FACTOR, usp_factor_20;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record TC: Torodial conductivity parameters
 //----------------------------------------------------------------------------
 */
RECORD tc
{
    LABEL LBL_TC_21;
    HELP HLP_TC_21;
    MEMBERS
    {
        SENSORTYPE, sensortype_21;
        MEAS_MODE, meas_mode_21;
        DISPLAY_UNIT, display_unit_21;
        SOLUTION, solution_21;
        RTD_TYPE, rtd_type_21;
        TEMP_UNIT, temp_unit_21;
        TEMPERATURE, temperature_21;
        TEMPERATURE_MAN, temperature_man_21;
        CIP_COUNT, cip_count_21;
        SIP_COUNT, sip_count_21;
        TC_SELECT, tc_select_21;
        TC_LIQUID, tc_liquid_21;
        REF_TEMP, ref_temp_21;
        TDS_FACTOR, tds_factor_21;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record DISOLVED_OXYGEN: dissolved oxygen parameters
 //----------------------------------------------------------------------------
 */
RECORD disolved_oxygen
{
    LABEL LBL_DISOLVED_OXYGEN_22;
    HELP HLP_DISOLVED_OXYGEN_22;
    MEMBERS
    {
        SENSORTYPE, sensortype_22;
        MEAS_MODE, meas_mode_22;
        U_POL_MEAS, u_pol_meas_22;
        U_POL_CAL, u_pol_cal_22;
        MEMBRAN_COMP, membran_comp_22;
        RTD_TYPE, rtd_type_22;
        TEMP_UNIT, temp_unit_22;
        CALMODE, calmode_22;
        CAL_TIMER, cal_timer_22;
        CAL_CYCLE, cal_cycle_22;
        ACT, act_22;
        ACT_CYCLE, act_cycle_22;
        TTM, ttm_22;
        TTM_CYCLE, ttm_cycle_22;
        CIP_COUNT, cip_count_22;
        CIP_CYCLES, cip_cycles_22;
        SIP_COUNT, sip_count_22;
        SIP_CYCLES, sip_cycles_22;
        AUTOCLAVE, autoclave_22;
        AC_CYCLES, ac_cycles_22;
        SALINITY, salinity_22;
        PRESSURE_UNIT, pressure_unit_22;
        PRESSURE, pressure_22;
        PRESSURE_MAN, pressure_man_22;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record CC: CC parameters
 //----------------------------------------------------------------------------
 */
RECORD cc
{
    LABEL LBL_CC_23;
    HELP HLP_CC_23;
    MEMBERS
    {
        TC_SELECT_A, tc_select_a_23;
        TC_LIQUID_A, tc_liquid_a_23;
        REF_TEMP_A, ref_temp_a_23;
        TC_SELECT_B, tc_select_b_23;
        TC_LIQUID_B, tc_liquid_b_23;
        REF_TEMP_B, ref_temp_b_23;
        MEAS_RANGE, meas_range_23;
        TEMP_UNIT, temp_unit_23;
        CALCULATION, calculation_23;
        CALCULATION_TYPE, calculation_type_23;
        FACTOR_1, factor_1_23;
        FACTOR_2, factor_2_23;
        PARAMETER_W, parameter_w_23;
        PARAMETER_A, parameter_a_23;
        PARAMETER_B, parameter_b_23;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record CLOCK: Clock parameters
 //----------------------------------------------------------------------------
 */
RECORD clock
{
    LABEL LBL_CLOCK_27;
    HELP HLP_CLOCK_27;
    MEMBERS
    {
        FORMAT, format_27;
        MINUTE, minute_27;
        HOUR, hour_27;
        AMPM, ampm_27;
        DAY, day_27;
        MONTH, month_27;
        YEAR, year_27;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PH_TC_LIQUID_TABLE: Table if TC_SELECT is set to user tab.Value from 0C to 100C in 5degree steps.
 //----------------------------------------------------------------------------
 */
RECORD ph_tc_liquid_table
{
    LABEL LBL_PH_TC_LIQUID_TABLE_28;
    HELP HLP_PH_TC_LIQUID_TABLE_28;
    MEMBERS
    {
        DEGREE_0, degree_0_28;
        DEGREE_5, degree_5_28;
        DEGREE_10, degree_10_28;
        DEGREE_15, degree_15_28;
        DEGREE_20, degree_20_28;
        DEGREE_25, degree_25_28;
        DEGREE_30, degree_30_28;
        DEGREE_35, degree_35_28;
        DEGREE_40, degree_40_28;
        DEGREE_45, degree_45_28;
        DEGREE_50, degree_50_28;
        DEGREE_55, degree_55_28;
        DEGREE_60, degree_60_28;
        DEGREE_65, degree_65_28;
        DEGREE_70, degree_70_28;
        DEGREE_75, degree_75_28;
        DEGREE_80, degree_80_28;
        DEGREE_85, degree_85_28;
        DEGREE_90, degree_90_28;
        DEGREE_95, degree_95_28;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PH_USER_BUFFER_1: Table if BUFFER is set to User buffer. 1st buffer
 //----------------------------------------------------------------------------
 */
RECORD ph_user_buffer_1
{
    LABEL LBL_PH_USER_BUFFER_1_29;
    HELP HLP_PH_USER_BUFFER_1_29;
    MEMBERS
    {
        NOMINAL, nominal_29;
        DEGREE_0, degree_0_29;
        DEGREE_5, degree_5_29;
        DEGREE_10, degree_10_29;
        DEGREE_15, degree_15_29;
        DEGREE_20, degree_20_29;
        DEGREE_25, degree_25_29;
        DEGREE_30, degree_30_29;
        DEGREE_35, degree_35_29;
        DEGREE_40, degree_40_29;
        DEGREE_45, degree_45_29;
        DEGREE_50, degree_50_29;
        DEGREE_55, degree_55_29;
        DEGREE_60, degree_60_29;
        DEGREE_65, degree_65_29;
        DEGREE_70, degree_70_29;
        DEGREE_75, degree_75_29;
        DEGREE_80, degree_80_29;
        DEGREE_85, degree_85_29;
        DEGREE_90, degree_90_29;
        DEGREE_95, degree_95_29;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PH_USER_BUFFER_2: Table if BUFFER is set to User buffer. 2nd buffer
 //----------------------------------------------------------------------------
 */
RECORD ph_user_buffer_2
{
    LABEL LBL_PH_USER_BUFFER_2_30;
    HELP HLP_PH_USER_BUFFER_2_30;
    MEMBERS
    {
        NOMINAL, nominal_30;
        DEGREE_0, degree_0_30;
        DEGREE_5, degree_5_30;
        DEGREE_10, degree_10_30;
        DEGREE_15, degree_15_30;
        DEGREE_20, degree_20_30;
        DEGREE_25, degree_25_30;
        DEGREE_30, degree_30_30;
        DEGREE_35, degree_35_30;
        DEGREE_40, degree_40_30;
        DEGREE_45, degree_45_30;
        DEGREE_50, degree_50_30;
        DEGREE_55, degree_55_30;
        DEGREE_60, degree_60_30;
        DEGREE_65, degree_65_30;
        DEGREE_70, degree_70_30;
        DEGREE_75, degree_75_30;
        DEGREE_80, degree_80_30;
        DEGREE_85, degree_85_30;
        DEGREE_90, degree_90_30;
        DEGREE_95, degree_95_30;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record SENSOR: Sensor data
 //----------------------------------------------------------------------------
 */
RECORD sensor
{
    LABEL LBL_SENSOR_39;
    HELP HLP_SENSOR_39;
    MEMBERS
    {
        SNS_STATUS, sns_status_39;
        RUNTIME, runtime_39;
        SIP_CYCLES, sip_cycles_39;
        CIP_CYCLES, cip_cycles_39;
        TTM, ttm_39;
        DLI, dli_39;
        ACT, act_39;
        AUTOCLAVE, autoclave_39;
        WEAR, wear_39;
        SMILEY, smiley_39;
        CALTIMER, caltimer_39;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record VERSION: Version
 //----------------------------------------------------------------------------
 */
RECORD version
{
    LABEL LBL_VERSION_58;
    HELP HLP_VERSION_58;
    MEMBERS
    {
        SERIAL_NO_BASE, serial_no_base_58;
        SW_VER_BASE, sw_ver_base_58;
        HW_VER_BASE, hw_ver_base_58;
        SERIAL_NO_MEAS, serial_no_meas_58;
        SW_VER_MEAS, sw_ver_meas_58;
        HW_VER_MEAS, hw_ver_meas_58;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_PH: pH Value
 //----------------------------------------------------------------------------
 */
RECORD pv_ph
{
    LABEL LBL_PV_PH_59;
    HELP HLP_PV_PH_59;
    MEMBERS
    {
        VALUE, value_59;
        STATUS, status_59;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_MV: mV Value
 //----------------------------------------------------------------------------
 */
RECORD pv_mv
{
    LABEL LBL_PV_MV_60;
    HELP HLP_PV_MV_60;
    MEMBERS
    {
        VALUE, value_60;
        STATUS, status_60;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_ORP: ORP Value
 //----------------------------------------------------------------------------
 */
RECORD pv_orp
{
    LABEL LBL_PV_ORP_61;
    HELP HLP_PV_ORP_61;
    MEMBERS
    {
        VALUE, value_61;
        STATUS, status_61;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_GLASS_IMPEDANCE: Glass Impedance Value
 //----------------------------------------------------------------------------
 */
RECORD pv_glass_impedance
{
    LABEL LBL_PV_GLASS_IMPEDANCE_62;
    HELP HLP_PV_GLASS_IMPEDANCE_62;
    MEMBERS
    {
        VALUE, value_62;
        STATUS, status_62;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_REFERENCE_IMPEDANCE: Reference Impedance Value
 //----------------------------------------------------------------------------
 */
RECORD pv_reference_impedance
{
    LABEL LBL_PV_REFERENCE_IMPEDANCE_63;
    HELP HLP_PV_REFERENCE_IMPEDANCE_63;
    MEMBERS
    {
        VALUE, value_63;
        STATUS, status_63;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_TEMPERATURE: Temperature
 //----------------------------------------------------------------------------
 */
RECORD pv_temperature
{
    LABEL LBL_PV_TEMPERATURE_64;
    HELP HLP_PV_TEMPERATURE_64;
    MEMBERS
    {
        VALUE, value_64;
        STATUS, status_64;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_CAL_TIMER: Calibration timer is used to remind you for a calibration. Not for ISM sensors.
 //----------------------------------------------------------------------------
 */
RECORD pv_cal_timer
{
    LABEL LBL_PV_CAL_TIMER_66;
    HELP HLP_PV_CAL_TIMER_66;
    MEMBERS
    {
        VALUE, value_66;
        STATUS, status_66;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_SLOPE: Slope
 //----------------------------------------------------------------------------
 */
RECORD pv_slope
{
    LABEL LBL_PV_SLOPE_67;
    HELP HLP_PV_SLOPE_67;
    MEMBERS
    {
        VALUE, value_67;
        STATUS, status_67;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_ZERO: Zero
 //----------------------------------------------------------------------------
 */
RECORD pv_zero
{
    LABEL LBL_PV_ZERO_69;
    HELP HLP_PV_ZERO_69;
    MEMBERS
    {
        VALUE, value_69;
        STATUS, status_69;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_WEAR: Sensor wear for Memosens pH or DO sensors
 //----------------------------------------------------------------------------
 */
RECORD pv_wear
{
    LABEL LBL_PV_WEAR_70;
    HELP HLP_PV_WEAR_70;
    MEMBERS
    {
        VALUE, value_70;
        STATUS, status_70;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_FLOW: Flow-value
 //----------------------------------------------------------------------------
 */
RECORD pv_flow
{
    LABEL LBL_PV_FLOW_71;
    HELP HLP_PV_FLOW_71;
    MEMBERS
    {
        VALUE, value_71;
        STATUS, status_71;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_DO_SATURATION_AIR: Saturation Air
 //----------------------------------------------------------------------------
 */
RECORD pv_do_saturation_air
{
    LABEL LBL_PV_DO_SATURATION_AIR_72;
    HELP HLP_PV_DO_SATURATION_AIR_72;
    MEMBERS
    {
        VALUE, value_72;
        STATUS, status_72;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_DO_CONCENTRATION: DO Concentration
 //----------------------------------------------------------------------------
 */
RECORD pv_do_concentration
{
    LABEL LBL_PV_DO_CONCENTRATION_73;
    HELP HLP_PV_DO_CONCENTRATION_73;
    MEMBERS
    {
        VALUE, value_73;
        STATUS, status_73;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_GAS_V_CONCENTRATION: Volume concentration in gas
 //----------------------------------------------------------------------------
 */
RECORD pv_gas_v_concentration
{
    LABEL LBL_PV_GAS_V_CONCENTRATION_75;
    HELP HLP_PV_GAS_V_CONCENTRATION_75;
    MEMBERS
    {
        VALUE, value_75;
        STATUS, status_75;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_PART_PRESSURE: Partial Pressure
 //----------------------------------------------------------------------------
 */
RECORD pv_part_pressure
{
    LABEL LBL_PV_PART_PRESSURE_76;
    HELP HLP_PV_PART_PRESSURE_76;
    MEMBERS
    {
        VALUE, value_76;
        STATUS, status_76;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_CONDUCTIVITY: Conductivity
 //----------------------------------------------------------------------------
 */
RECORD pv_conductivity
{
    LABEL LBL_PV_CONDUCTIVITY_77;
    HELP HLP_PV_CONDUCTIVITY_77;
    MEMBERS
    {
        VALUE, value_77;
        STATUS, status_77;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_SPECIFIC_RESISTANCE: Specific Resistance
 //----------------------------------------------------------------------------
 */
RECORD pv_specific_resistance
{
    LABEL LBL_PV_SPECIFIC_RESISTANCE_79;
    HELP HLP_PV_SPECIFIC_RESISTANCE_79;
    MEMBERS
    {
        VALUE, value_79;
        STATUS, status_79;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_CONCENTRATION: Concentration
 //----------------------------------------------------------------------------
 */
RECORD pv_concentration
{
    LABEL LBL_PV_CONCENTRATION_80;
    HELP HLP_PV_CONCENTRATION_80;
    MEMBERS
    {
        VALUE, value_80;
        STATUS, status_80;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_CONDUCTANCE: Conductance
 //----------------------------------------------------------------------------
 */
RECORD pv_conductance
{
    LABEL LBL_PV_CONDUCTANCE_81;
    HELP HLP_PV_CONDUCTANCE_81;
    MEMBERS
    {
        VALUE, value_81;
        STATUS, status_81;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_SALINITY: Salinity
 //----------------------------------------------------------------------------
 */
RECORD pv_salinity
{
    LABEL LBL_PV_SALINITY_82;
    HELP HLP_PV_SALINITY_82;
    MEMBERS
    {
        VALUE, value_82;
        STATUS, status_82;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_TDS: TDS
 //----------------------------------------------------------------------------
 */
RECORD pv_tds
{
    LABEL LBL_PV_TDS_83;
    HELP HLP_PV_TDS_83;
    MEMBERS
    {
        VALUE, value_83;
        STATUS, status_83;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_CONDUCTIVITY_2: CC: Conductivity 2nd value
 //----------------------------------------------------------------------------
 */
RECORD pv_conductivity_2
{
    LABEL LBL_PV_CONDUCTIVITY_2_84;
    HELP HLP_PV_CONDUCTIVITY_2_84;
    MEMBERS
    {
        VALUE, value_84;
        STATUS, status_84;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_CALCULATION: CC: calculated value related to CC_Calculation type
 //----------------------------------------------------------------------------
 */
RECORD pv_calculation
{
    LABEL LBL_PV_CALCULATION_85;
    HELP HLP_PV_CALCULATION_85;
    MEMBERS
    {
        VALUE, value_85;
        STATUS, status_85;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_CELL: Cellfactor
 //----------------------------------------------------------------------------
 */
RECORD pv_cell
{
    LABEL LBL_PV_CELL_86;
    HELP HLP_PV_CELL_86;
    MEMBERS
    {
        VALUE, value_86;
        STATUS, status_86;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_TEMPERATURE_2: CC: Temperature 2nd value
 //----------------------------------------------------------------------------
 */
RECORD pv_temperature_2
{
    LABEL LBL_PV_TEMPERATURE_2_87;
    HELP HLP_PV_TEMPERATURE_2_87;
    MEMBERS
    {
        VALUE, value_87;
        STATUS, status_87;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record FINAL_VALUE_TEMPERATURE: Analog Output
 //----------------------------------------------------------------------------
 */
RECORD final_value_temperature
{
    LABEL LBL_FINAL_VALUE_TEMPERATURE_90;
    HELP HLP_FINAL_VALUE_TEMPERATURE_90;
    MEMBERS
    {
        VALUE, value_90;
        STATUS, status_90;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record FINAL_VALUE_TEMPERATURE_FEEDBACK: AO Feedback Value (not used)
 //----------------------------------------------------------------------------
 */
RECORD final_value_temperature_feedback
{
    LABEL LBL_FINAL_VALUE_TEMPERATURE_FEEDBACK_91;
    HELP HLP_FINAL_VALUE_TEMPERATURE_FEEDBACK_91;
    MEMBERS
    {
        VALUE, value_91;
        STATUS, status_91;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record FINAL_VALUE_PRESSURE: Analog Output
 //----------------------------------------------------------------------------
 */
RECORD final_value_pressure
{
    LABEL LBL_FINAL_VALUE_PRESSURE_92;
    HELP HLP_FINAL_VALUE_PRESSURE_92;
    MEMBERS
    {
        VALUE, value_92;
        STATUS, status_92;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record FINAL_VALUE_PRESSURE_FEEDBACK: AO Feedback Value (not used)
 //----------------------------------------------------------------------------
 */
RECORD final_value_pressure_feedback
{
    LABEL LBL_FINAL_VALUE_PRESSURE_FEEDBACK_93;
    HELP HLP_FINAL_VALUE_PRESSURE_FEEDBACK_93;
    MEMBERS
    {
        VALUE, value_93;
        STATUS, status_93;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record FINAL_VALUE_D_RELAY_1: DO Final Value 1
 //----------------------------------------------------------------------------
 */
RECORD final_value_d_relay_1
{
    LABEL LBL_FINAL_VALUE_D_RELAY_1_94;
    HELP HLP_FINAL_VALUE_D_RELAY_1_94;
    MEMBERS
    {
        VALUE, value_94;
        STATUS, status_94;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record FINAL_VALUE_D_RELAY_2: DO Final Value 2
 //----------------------------------------------------------------------------
 */
RECORD final_value_d_relay_2
{
    LABEL LBL_FINAL_VALUE_D_RELAY_2_95;
    HELP HLP_FINAL_VALUE_D_RELAY_2_95;
    MEMBERS
    {
        VALUE, value_95;
        STATUS, status_95;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PRIMARY_VALUE_D_USP: DI Value USP
 //----------------------------------------------------------------------------
 */
RECORD primary_value_d_usp
{
    LABEL LBL_PRIMARY_VALUE_D_USP_96;
    HELP HLP_PRIMARY_VALUE_D_USP_96;
    MEMBERS
    {
        VALUE, value_96;
        STATUS, status_96;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PRIMARY_VALUE: Primary Value
 //----------------------------------------------------------------------------
 */
RECORD primary_value
{
    LABEL LBL_PRIMARY_VALUE_97;
    HELP HLP_PRIMARY_VALUE_97;
    MEMBERS
    {
        VALUE, value_97;
        STATUS, status_97;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record PV_SPECIFIC_RESISTANCE_2: CC: Specific Resistance 2
 //----------------------------------------------------------------------------
 */
RECORD pv_specific_resistance_2
{
    LABEL LBL_PV_SPECIFIC_RESISTANCE_2_99;
    HELP HLP_PV_SPECIFIC_RESISTANCE_2_99;
    MEMBERS
    {
        STATUS, status_99;
        VALUE, value_99;
    }
}

/*
 //----------------------------------------------------------------------------
 // Record SENSOR_FIX: Sensor data
 //----------------------------------------------------------------------------
 */
RECORD sensor_fix
{
    LABEL LBL_SENSOR_FIX_100;
    HELP HLP_SENSOR_FIX_100;
    MEMBERS
    {
        SERIAL_NO, serial_no_100;
        ORDER_NO, order_no_100;
        TAG, tag_100;
        MANU, manu_100;
        INIT_OPERATION, init_operation_100;
    }
}

#endif // USE_RECORDS
/*
 //-------------------------------------------------------------------
 // hier werden alle Commands aufgelistet
 //-------------------------------------------------------------------
 */
COMMAND tb1_meas_type_read
{
    BLOCK tb1_Ana_block;
    INDEX 11;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            meas_type
        }
    }
}

COMMAND tb1_meas_type_write
{
    BLOCK tb1_Ana_block;
    INDEX 11;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            meas_type
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_ph_read
{
    BLOCK tb1_Ana_block;
    INDEX 12;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sensortype_19,
            meas_mode_19,
            rtd_type_19,
            temp_unit_19,
            temp_meas_19,
            temp_meas_man_19,
            temp_cal_19,
            temp_cal_man_19,
            nom_zero_19,
            nom_slope_19,
            ph_iso_19,
            calmode_19,
            buffer_set_19,
            cal_timer_19,
            cal_cycle_19,
            act_19,
            act_cycle_19,
            ttm_19,
            ttm_cycle_19,
            cip_count_19,
            cip_cycles_19,
            sip_count_19,
            sip_cycles_19,
            autoclave_19,
            ac_cycles_19,
            tc_select_19,
            tc_liquid_19
        }
    }
}

COMMAND tb1_ph_write
{
    BLOCK tb1_Ana_block;
    INDEX 12;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            sensortype_19,
            meas_mode_19,
            rtd_type_19,
            temp_unit_19,
            temp_meas_19,
            temp_meas_man_19,
            temp_cal_19,
            temp_cal_man_19,
            nom_zero_19,
            nom_slope_19,
            ph_iso_19,
            calmode_19,
            buffer_set_19,
            cal_timer_19,
            cal_cycle_19,
            act_19,
            act_cycle_19,
            ttm_19,
            ttm_cycle_19,
            cip_count_19,
            cip_cycles_19,
            sip_count_19,
            sip_cycles_19,
            autoclave_19,
            ac_cycles_19,
            tc_select_19,
            tc_liquid_19
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_conductivity_read
{
    BLOCK tb1_Ana_block;
    INDEX 13;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sensortype_20,
            meas_mode_20,
            display_unit_20,
            solution_20,
            rtd_type_20,
            temp_unit_20,
            temperature_20,
            temperature_man_20,
            cip_count_20,
            sip_count_20,
            tc_select_20,
            tc_liquid_20,
            ref_temp_20,
            tds_factor_20,
            usp_factor_20
        }
    }
}

COMMAND tb1_conductivity_write
{
    BLOCK tb1_Ana_block;
    INDEX 13;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            sensortype_20,
            meas_mode_20,
            display_unit_20,
            solution_20,
            rtd_type_20,
            temp_unit_20,
            temperature_20,
            temperature_man_20,
            cip_count_20,
            sip_count_20,
            tc_select_20,
            tc_liquid_20,
            ref_temp_20,
            tds_factor_20,
            usp_factor_20
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_tc_read
{
    BLOCK tb1_Ana_block;
    INDEX 14;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sensortype_21,
            meas_mode_21,
            display_unit_21,
            solution_21,
            rtd_type_21,
            temp_unit_21,
            temperature_21,
            temperature_man_21,
            cip_count_21,
            sip_count_21,
            tc_select_21,
            tc_liquid_21,
            ref_temp_21,
            tds_factor_21
        }
    }
}

COMMAND tb1_tc_write
{
    BLOCK tb1_Ana_block;
    INDEX 14;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            sensortype_21,
            meas_mode_21,
            display_unit_21,
            solution_21,
            rtd_type_21,
            temp_unit_21,
            temperature_21,
            temperature_man_21,
            cip_count_21,
            sip_count_21,
            tc_select_21,
            tc_liquid_21,
            ref_temp_21,
            tds_factor_21
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_disolved_oxygen_read
{
    BLOCK tb1_Ana_block;
    INDEX 15;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sensortype_22,
            meas_mode_22,
            u_pol_meas_22,
            u_pol_cal_22,
            membran_comp_22,
            rtd_type_22,
            temp_unit_22,
            calmode_22,
            cal_timer_22,
            cal_cycle_22,
            act_22,
            act_cycle_22,
            ttm_22,
            ttm_cycle_22,
            cip_count_22,
            cip_cycles_22,
            sip_count_22,
            sip_cycles_22,
            autoclave_22,
            ac_cycles_22,
            salinity_22,
            pressure_unit_22,
            pressure_22,
            pressure_man_22
        }
    }
}

COMMAND tb1_disolved_oxygen_write
{
    BLOCK tb1_Ana_block;
    INDEX 15;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            sensortype_22,
            meas_mode_22,
            u_pol_meas_22,
            u_pol_cal_22,
            membran_comp_22,
            rtd_type_22,
            temp_unit_22,
            calmode_22,
            cal_timer_22,
            cal_cycle_22,
            act_22,
            act_cycle_22,
            ttm_22,
            ttm_cycle_22,
            cip_count_22,
            cip_cycles_22,
            sip_count_22,
            sip_cycles_22,
            autoclave_22,
            ac_cycles_22,
            salinity_22,
            pressure_unit_22,
            pressure_22,
            pressure_man_22
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cc_read
{
    BLOCK tb1_Ana_block;
    INDEX 16;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tc_select_a_23,
            tc_liquid_a_23,
            ref_temp_a_23,
            tc_select_b_23,
            tc_liquid_b_23,
            ref_temp_b_23,
            meas_range_23,
            temp_unit_23,
            calculation_23,
            calculation_type_23,
            factor_1_23,
            factor_2_23,
            parameter_w_23,
            parameter_a_23,
            parameter_b_23
        }
    }
}

COMMAND tb1_cc_write
{
    BLOCK tb1_Ana_block;
    INDEX 16;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            tc_select_a_23,
            tc_liquid_a_23,
            ref_temp_a_23,
            tc_select_b_23,
            tc_liquid_b_23,
            ref_temp_b_23,
            meas_range_23,
            temp_unit_23,
            calculation_23,
            calculation_type_23,
            factor_1_23,
            factor_2_23,
            parameter_w_23,
            parameter_a_23,
            parameter_b_23
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_flow_adjust_read
{
    BLOCK tb1_Ana_block;
    INDEX 17;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            flow_adjust
        }
    }
}

COMMAND tb1_flow_adjust_write
{
    BLOCK tb1_Ana_block;
    INDEX 17;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            flow_adjust
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_alarm_delay_read
{
    BLOCK tb1_Ana_block;
    INDEX 18;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            alarm_delay
        }
    }
}

COMMAND tb1_alarm_delay_write
{
    BLOCK tb1_Ana_block;
    INDEX 18;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            alarm_delay
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_sensocheck_read
{
    BLOCK tb1_Ana_block;
    INDEX 19;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sensocheck
        }
    }
}

COMMAND tb1_sensocheck_write
{
    BLOCK tb1_Ana_block;
    INDEX 19;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            sensocheck
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_clock_read
{
    BLOCK tb1_Ana_block;
    INDEX 20;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            format_27,
            minute_27,
            hour_27,
            ampm_27,
            day_27,
            month_27,
            year_27
        }
    }
}

COMMAND tb1_clock_write
{
    BLOCK tb1_Ana_block;
    INDEX 20;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            format_27,
            minute_27,
            hour_27,
            ampm_27,
            day_27,
            month_27,
            year_27
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_ph_tc_liquid_table_read
{
    BLOCK tb1_Ana_block;
    INDEX 21;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            degree_0_28,
            degree_5_28,
            degree_10_28,
            degree_15_28,
            degree_20_28,
            degree_25_28,
            degree_30_28,
            degree_35_28,
            degree_40_28,
            degree_45_28,
            degree_50_28,
            degree_55_28,
            degree_60_28,
            degree_65_28,
            degree_70_28,
            degree_75_28,
            degree_80_28,
            degree_85_28,
            degree_90_28,
            degree_95_28
        }
    }
}

COMMAND tb1_ph_tc_liquid_table_write
{
    BLOCK tb1_Ana_block;
    INDEX 21;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            degree_0_28,
            degree_5_28,
            degree_10_28,
            degree_15_28,
            degree_20_28,
            degree_25_28,
            degree_30_28,
            degree_35_28,
            degree_40_28,
            degree_45_28,
            degree_50_28,
            degree_55_28,
            degree_60_28,
            degree_65_28,
            degree_70_28,
            degree_75_28,
            degree_80_28,
            degree_85_28,
            degree_90_28,
            degree_95_28
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_ph_user_buffer_1_read
{
    BLOCK tb1_Ana_block;
    INDEX 22;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            nominal_29,
            degree_0_29,
            degree_5_29,
            degree_10_29,
            degree_15_29,
            degree_20_29,
            degree_25_29,
            degree_30_29,
            degree_35_29,
            degree_40_29,
            degree_45_29,
            degree_50_29,
            degree_55_29,
            degree_60_29,
            degree_65_29,
            degree_70_29,
            degree_75_29,
            degree_80_29,
            degree_85_29,
            degree_90_29,
            degree_95_29
        }
    }
}

COMMAND tb1_ph_user_buffer_1_write
{
    BLOCK tb1_Ana_block;
    INDEX 22;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            nominal_29,
            degree_0_29,
            degree_5_29,
            degree_10_29,
            degree_15_29,
            degree_20_29,
            degree_25_29,
            degree_30_29,
            degree_35_29,
            degree_40_29,
            degree_45_29,
            degree_50_29,
            degree_55_29,
            degree_60_29,
            degree_65_29,
            degree_70_29,
            degree_75_29,
            degree_80_29,
            degree_85_29,
            degree_90_29,
            degree_95_29
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_ph_user_buffer_2_read
{
    BLOCK tb1_Ana_block;
    INDEX 23;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            nominal_30,
            degree_0_30,
            degree_5_30,
            degree_10_30,
            degree_15_30,
            degree_20_30,
            degree_25_30,
            degree_30_30,
            degree_35_30,
            degree_40_30,
            degree_45_30,
            degree_50_30,
            degree_55_30,
            degree_60_30,
            degree_65_30,
            degree_70_30,
            degree_75_30,
            degree_80_30,
            degree_85_30,
            degree_90_30,
            degree_95_30
        }
    }
}

COMMAND tb1_ph_user_buffer_2_write
{
    BLOCK tb1_Ana_block;
    INDEX 23;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            nominal_30,
            degree_0_30,
            degree_5_30,
            degree_10_30,
            degree_15_30,
            degree_20_30,
            degree_25_30,
            degree_30_30,
            degree_35_30,
            degree_40_30,
            degree_45_30,
            degree_50_30,
            degree_55_30,
            degree_60_30,
            degree_65_30,
            degree_70_30,
            degree_75_30,
            degree_80_30,
            degree_85_30,
            degree_90_30,
            degree_95_30
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cal_sample_prd_read
{
    BLOCK tb1_Ana_block;
    INDEX 24;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cal_sample_prd
        }
    }
}

COMMAND tb1_cal_sample_prd_write
{
    BLOCK tb1_Ana_block;
    INDEX 24;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            cal_sample_prd
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cal_sample_prd_stored_val_read
{
    BLOCK tb1_Ana_block;
    INDEX 25;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cal_sample_prd_stored_val
        }
    }
}

COMMAND tb1_cal_product_read
{
    BLOCK tb1_Ana_block;
    INDEX 26;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cal_product
        }
    }
}

COMMAND tb1_cal_product_write
{
    BLOCK tb1_Ana_block;
    INDEX 26;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            cal_product
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cal_prd_step_read
{
    BLOCK tb1_Ana_block;
    INDEX 27;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cal_prd_step
        }
    }
}

COMMAND tb1_cal_result_read
{
    BLOCK tb1_Ana_block;
    INDEX 28;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cal_result
        }
    }
}

COMMAND tb1_cal_result_write
{
    BLOCK tb1_Ana_block;
    INDEX 28;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            cal_result
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_logbook_entry_read
{
    BLOCK tb1_Ana_block;
    INDEX 29;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            logbook_entry
        }
    }
}

COMMAND tb1_logbook_entry_write
{
    BLOCK tb1_Ana_block;
    INDEX 29;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            logbook_entry
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_logbook_binary_data_read
{
    BLOCK tb1_Ana_block;
    INDEX 30;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            logbook_binary_data
        }
    }
}

COMMAND tb1_logbook_erase_read
{
    BLOCK tb1_Ana_block;
    INDEX 31;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            logbook_erase
        }
    }
}

COMMAND tb1_logbook_erase_write
{
    BLOCK tb1_Ana_block;
    INDEX 31;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            logbook_erase
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_sensor_read
{
    BLOCK tb1_Ana_block;
    INDEX 32;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sns_status_39,
            runtime_39,
            sip_cycles_39,
            cip_cycles_39,
            ttm_39,
            dli_39,
            act_39,
            autoclave_39,
            wear_39,
            smiley_39,
            caltimer_39
        }
    }
}

COMMAND tb1_sensor_request_bin_read
{
    BLOCK tb1_Ana_block;
    INDEX 33;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sensor_request_bin
        }
    }
}

COMMAND tb1_sensor_request_bin_write
{
    BLOCK tb1_Ana_block;
    INDEX 33;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            sensor_request_bin
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_sensor_response_bin_read
{
    BLOCK tb1_Ana_block;
    INDEX 34;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            sensor_response_bin
        }
    }
}

COMMAND tb1_ph_cal_slope_read
{
    BLOCK tb1_Ana_block;
    INDEX 35;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            ph_cal_slope
        }
    }
}

COMMAND tb1_ph_cal_slope_write
{
    BLOCK tb1_Ana_block;
    INDEX 35;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            ph_cal_slope
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_ph_cal_zero_read
{
    BLOCK tb1_Ana_block;
    INDEX 36;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            ph_cal_zero
        }
    }
}

COMMAND tb1_ph_cal_zero_write
{
    BLOCK tb1_Ana_block;
    INDEX 36;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            ph_cal_zero
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_ph_cal_offset_isfet_read
{
    BLOCK tb1_Ana_block;
    INDEX 37;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            ph_cal_offset_isfet
        }
    }
}

COMMAND tb1_ph_cal_offset_isfet_write
{
    BLOCK tb1_Ana_block;
    INDEX 37;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            ph_cal_offset_isfet
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_ph_calzero_orp_read
{
    BLOCK tb1_Ana_block;
    INDEX 38;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            ph_calzero_orp
        }
    }
}

COMMAND tb1_ph_calzero_orp_write
{
    BLOCK tb1_Ana_block;
    INDEX 38;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            ph_calzero_orp
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_do_cal_slope_read
{
    BLOCK tb1_Ana_block;
    INDEX 39;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            do_cal_slope
        }
    }
}

COMMAND tb1_do_cal_slope_write
{
    BLOCK tb1_Ana_block;
    INDEX 39;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            do_cal_slope
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_do_cal_zero_read
{
    BLOCK tb1_Ana_block;
    INDEX 40;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            do_cal_zero
        }
    }
}

COMMAND tb1_do_cal_zero_write
{
    BLOCK tb1_Ana_block;
    INDEX 40;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            do_cal_zero
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_do_cal_rh_read
{
    BLOCK tb1_Ana_block;
    INDEX 41;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            do_cal_rh
        }
    }
}

COMMAND tb1_do_cal_rh_write
{
    BLOCK tb1_Ana_block;
    INDEX 41;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            do_cal_rh
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cond_cellconst_read
{
    BLOCK tb1_Ana_block;
    INDEX 42;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cond_cellconst
        }
    }
}

COMMAND tb1_cond_cellconst_write
{
    BLOCK tb1_Ana_block;
    INDEX 42;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            cond_cellconst
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_tc_cellfactor_read
{
    BLOCK tb1_Ana_block;
    INDEX 43;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tc_cellfactor
        }
    }
}

COMMAND tb1_tc_cellfactor_write
{
    BLOCK tb1_Ana_block;
    INDEX 43;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            tc_cellfactor
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_tc_install_read
{
    BLOCK tb1_Ana_block;
    INDEX 44;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tc_install
        }
    }
}

COMMAND tb1_tc_install_write
{
    BLOCK tb1_Ana_block;
    INDEX 44;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            tc_install
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_tc_zero_read
{
    BLOCK tb1_Ana_block;
    INDEX 45;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tc_zero
        }
    }
}

COMMAND tb1_tc_zero_write
{
    BLOCK tb1_Ana_block;
    INDEX 45;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            tc_zero
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_tc_trans_ratio_read
{
    BLOCK tb1_Ana_block;
    INDEX 46;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            tc_trans_ratio
        }
    }
}

COMMAND tb1_tc_trans_ratio_write
{
    BLOCK tb1_Ana_block;
    INDEX 46;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            tc_trans_ratio
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cc_cellfactor_a_read
{
    BLOCK tb1_Ana_block;
    INDEX 47;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cc_cellfactor_a
        }
    }
}

COMMAND tb1_cc_cellfactor_a_write
{
    BLOCK tb1_Ana_block;
    INDEX 47;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            cc_cellfactor_a
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cc_cellfactor_b_read
{
    BLOCK tb1_Ana_block;
    INDEX 48;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cc_cellfactor_b
        }
    }
}

COMMAND tb1_cc_cellfactor_b_write
{
    BLOCK tb1_Ana_block;
    INDEX 48;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            cc_cellfactor_b
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_cal_timestamp_read
{
    BLOCK tb1_Ana_block;
    INDEX 49;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cal_timestamp
        }
    }
}

COMMAND tb1_cal_timestamp_write
{
    BLOCK tb1_Ana_block;
    INDEX 49;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            cal_timestamp
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_hold_read
{
    BLOCK tb1_Ana_block;
    INDEX 50;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            hold
        }
    }
}

COMMAND tb1_hold_write
{
    BLOCK tb1_Ana_block;
    INDEX 50;
    OPERATION WRITE;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
            hold
        }
        REPLY
        {
        }
    }
}

COMMAND tb1_version_read
{
    BLOCK tb1_Ana_block;
    INDEX 51;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            serial_no_base_58,
            sw_ver_base_58,
            hw_ver_base_58,
            serial_no_meas_58,
            sw_ver_meas_58,
            hw_ver_meas_58
        }
    }
}

COMMAND tb1_pv_ph_read
{
    BLOCK tb1_Ana_block;
    INDEX 52;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_59,
            status_59
        }
    }
}

COMMAND tb1_pv_mv_read
{
    BLOCK tb1_Ana_block;
    INDEX 53;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_60,
            status_60
        }
    }
}

COMMAND tb1_pv_orp_read
{
    BLOCK tb1_Ana_block;
    INDEX 54;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_61,
            status_61
        }
    }
}

COMMAND tb1_pv_glass_impedance_read
{
    BLOCK tb1_Ana_block;
    INDEX 55;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_62,
            status_62
        }
    }
}

COMMAND tb1_pv_reference_impedance_read
{
    BLOCK tb1_Ana_block;
    INDEX 56;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_63,
            status_63
        }
    }
}

COMMAND tb1_pv_temperature_read
{
    BLOCK tb1_Ana_block;
    INDEX 57;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_64,
            status_64
        }
    }
}

COMMAND tb1_pv_temperature_unit_read
{
    BLOCK tb1_Ana_block;
    INDEX 58;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            pv_temperature_unit
        }
    }
}

COMMAND tb1_pv_cal_timer_read
{
    BLOCK tb1_Ana_block;
    INDEX 59;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_66,
            status_66
        }
    }
}

COMMAND tb1_pv_slope_read
{
    BLOCK tb1_Ana_block;
    INDEX 60;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_67,
            status_67
        }
    }
}

COMMAND tb1_pv_slope_unit_read
{
    BLOCK tb1_Ana_block;
    INDEX 61;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            pv_slope_unit
        }
    }
}

COMMAND tb1_pv_zero_read
{
    BLOCK tb1_Ana_block;
    INDEX 62;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_69,
            status_69
        }
    }
}

COMMAND tb1_pv_wear_read
{
    BLOCK tb1_Ana_block;
    INDEX 63;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_70,
            status_70
        }
    }
}

COMMAND tb1_pv_flow_read
{
    BLOCK tb1_Ana_block;
    INDEX 64;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_71,
            status_71
        }
    }
}

COMMAND tb1_pv_do_saturation_air_read
{
    BLOCK tb1_Ana_block;
    INDEX 65;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_72,
            status_72
        }
    }
}

COMMAND tb1_pv_do_concentration_read
{
    BLOCK tb1_Ana_block;
    INDEX 66;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_73,
            status_73
        }
    }
}

COMMAND tb1_pv_do_concentration_unit_read
{
    BLOCK tb1_Ana_block;
    INDEX 67;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            pv_do_concentration_unit
        }
    }
}

COMMAND tb1_pv_gas_v_concentration_read
{
    BLOCK tb1_Ana_block;
    INDEX 68;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_75,
            status_75
        }
    }
}

COMMAND tb1_pv_part_pressure_read
{
    BLOCK tb1_Ana_block;
    INDEX 69;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_76,
            status_76
        }
    }
}

COMMAND tb1_pv_conductivity_read
{
    BLOCK tb1_Ana_block;
    INDEX 70;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_77,
            status_77
        }
    }
}

COMMAND tb1_pv_conductivity_unit_read
{
    BLOCK tb1_Ana_block;
    INDEX 71;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            pv_conductivity_unit
        }
    }
}

COMMAND tb1_pv_specific_resistance_read
{
    BLOCK tb1_Ana_block;
    INDEX 72;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_79,
            status_79
        }
    }
}

COMMAND tb1_pv_concentration_read
{
    BLOCK tb1_Ana_block;
    INDEX 73;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_80,
            status_80
        }
    }
}

COMMAND tb1_pv_conductance_read
{
    BLOCK tb1_Ana_block;
    INDEX 74;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_81,
            status_81
        }
    }
}

COMMAND tb1_pv_salinity_read
{
    BLOCK tb1_Ana_block;
    INDEX 75;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_82,
            status_82
        }
    }
}

COMMAND tb1_pv_tds_read
{
    BLOCK tb1_Ana_block;
    INDEX 76;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_83,
            status_83
        }
    }
}

COMMAND tb1_pv_conductivity_2_read
{
    BLOCK tb1_Ana_block;
    INDEX 77;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_84,
            status_84
        }
    }
}

COMMAND tb1_pv_calculation_read
{
    BLOCK tb1_Ana_block;
    INDEX 78;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_85,
            status_85
        }
    }
}

COMMAND tb1_pv_cell_read
{
    BLOCK tb1_Ana_block;
    INDEX 79;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_86,
            status_86
        }
    }
}

COMMAND tb1_pv_temperature_2_read
{
    BLOCK tb1_Ana_block;
    INDEX 80;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_87,
            status_87
        }
    }
}

COMMAND tb1_pv_temperature_2_unit_read
{
    BLOCK tb1_Ana_block;
    INDEX 81;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            pv_temperature_2_unit
        }
    }
}

COMMAND tb1_cal_prd_stored_val_unit_read
{
    BLOCK tb1_Ana_block;
    INDEX 82;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            cal_prd_stored_val_unit
        }
    }
}

COMMAND tb1_final_value_temperature_read
{
    BLOCK tb1_Ana_block;
    INDEX 83;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_90,
            status_90
        }
    }
}

COMMAND tb1_final_value_temperature_feedback_read
{
    BLOCK tb1_Ana_block;
    INDEX 84;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_91,
            status_91
        }
    }
}

COMMAND tb1_final_value_pressure_read
{
    BLOCK tb1_Ana_block;
    INDEX 85;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_92,
            status_92
        }
    }
}

COMMAND tb1_final_value_pressure_feedback_read
{
    BLOCK tb1_Ana_block;
    INDEX 86;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_93,
            status_93
        }
    }
}

COMMAND tb1_final_value_d_relay_1_read
{
    BLOCK tb1_Ana_block;
    INDEX 87;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_94,
            status_94
        }
    }
}

COMMAND tb1_final_value_d_relay_2_read
{
    BLOCK tb1_Ana_block;
    INDEX 88;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_95,
            status_95
        }
    }
}

COMMAND tb1_primary_value_d_usp_read
{
    BLOCK tb1_Ana_block;
    INDEX 89;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_96,
            status_96
        }
    }
}

COMMAND tb1_primary_value_read
{
    BLOCK tb1_Ana_block;
    INDEX 90;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            value_97,
            status_97
        }
    }
}

COMMAND tb1_current_error_read
{
    BLOCK tb1_Ana_block;
    INDEX 91;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            current_error
        }
    }
}

COMMAND tb1_pv_specific_resistance_2_read
{
    BLOCK tb1_Ana_block;
    INDEX 92;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            status_99,
            value_99
        }
    }
}

COMMAND tb1_sensor_fix_read
{
    BLOCK tb1_Ana_block;
    INDEX 93;
    OPERATION READ;
    RESPONSE_CODES DPV1_PA_rsp_codes;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            serial_no_100,
            order_no_100,
            tag_100,
            manu_100,
            init_operation_100
        }
    }
}

/*-------------------------------------------------------------------*/
/*  Methode zum auslesen der Features  */
/*-------------------------------------------------------------------*/
METHOD method_get_phys_features
{
    LABEL "";
    CLASS OUTPUT;
    DEFINITION
    {
        ReadCommand(phys_FEATURE_read);
    }
}

/*
 //-------------------------------------------------------------------
 // Ende alle Commands
 //-------------------------------------------------------------------
 */
