/* ----------------------------------------------------------------------

 FILE_NAME          ai1.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
  ###   #####   ###
 #   #    #    #  #
 #   #    #       #
 #####    #       #
 #   #  #####     #
 ------------------------------------------------------
 */

IMPORT MANUFACTURER __STANDARD, DEVICE_TYPE __FUNC1_AI, DEVICE_REVISION 0x0302, DD_REVISION 0x0001
{
    EVERYTHING;

    REDEFINITIONS
    {
        REDEFINE VARIABLE func1_AI_OUT_SCALE_Upper_Value
        {
            LABEL [PI_OUT_SCALE_Upper_Value_label];
            HELP [PI_OUT_SCALE_Upper_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 100;
            }
        }

        REDEFINE VARIABLE func1_AI_OUT_SCALE_Lower_Value
        {
            LABEL [PI_OUT_SCALE_Lower_Value_label];
            HELP [PI_OUT_SCALE_Lower_Value_help];
            CLASS CONTAINED;
            TYPE FLOAT
            {
                DEFAULT_VALUE 0;
            }
        }

        REDEFINE VARIABLE func1_AI_OUT_SCALE_Decimal_Point
        {
            LABEL [PI_OUT_SCALE_Decimal_Point_label];
            HELP [PI_OUT_SCALE_Decimal_Point_help];
            CLASS CONTAINED & SERVICE;
            TYPE INTEGER (1)
            {
                DEFAULT_VALUE 0;
                MIN_VALUE 0;
                MAX_VALUE 7;
            }
        }

        REDEFINE VARIABLE func1_AI_OUT_Value
        {
            LABEL [PI_OUT_Value_label];
            HELP [PI_OUT_Value_help];
            CLASS OUTPUT & DYNAMIC;
            HANDLING IF (func1_AI_MODE_BLK_Actual == 0x10) { READ & WRITE; } ELSE { READ; }
            TYPE FLOAT { DISPLAY_FORMAT DEF_DISPLAY_FORMAT(func1_AI_OUT_SCALE_Decimal_Point) }
        }
        
        REDEFINE VARIABLE func1_AI_OUT_SCALE_Units_Index
        {
            LABEL [PI_PRIMARY_VALUE_UNIT_label];
            HELP [PI_PRIMARY_VALUE_UNIT_help];
            CLASS CONTAINED & SERVICE;
            TYPE ENUMERATED(2)
            {
                DEFAULT_VALUE 1342;
                AI_UNIT_LIST
            }
        }

        REDEFINE VARIABLE func1_AI_CHANNEL
        {
            LABEL "AI1 " + [PI_CHANNEL_label];
            HELP [PI_CHANNEL_help];
            CLASS CONTAINED;            
            TYPE ENUMERATED (2)
            {
                SELECT ( meas_type )
                {
                    CASE MEAS_TYPE_PH: AI_CHANNEL_LIST_PH
                    CASE MEAS_TYPE_COND: AI_CHANNEL_LIST_COND
                    CASE MEAS_TYPE_CONDI: AI_CHANNEL_LIST_CONDI
                    CASE MEAS_TYPE_CC: AI_CHANNEL_LIST_CC
                    CASE MEAS_TYPE_OXY: AI_CHANNEL_LIST_OXY
                    //DEFAULT: AI_CHANNEL_LIST
                }
            }
            HANDLING READ & WRITE;
            POST_EDIT_ACTIONS {method_func1_set_default_unit}
        }
    }
}

ARRAY OF VARIABLE refarray_func1_AI_CHANNEL
{
    LABEL "";    
    ELEMENTS
    {
        0, func1_AI_CHANNEL;
        1, func1_AI_CHANNEL;
        2, func1_AI_CHANNEL;
        3, func1_AI_CHANNEL;
        4, func1_AI_CHANNEL;
    }
}

/*
 ####################################
 Configuration vom AI
 ####################################
 */
MENU output_ai1_window
{
    LABEL [LABEL_AI1];
    STYLE WINDOW;
    ITEMS
    {
        meas_type(HIDDEN),
        conf_out_ai1_ident,
        conf_out_ai1_process,
        conf_out_ai1_alarm,
        conf_out_ai1_fail,
        conf_out_ai1_batch
    }
    POST_READ_ACTIONS { method_refresh_ai_channels }
}

MENU out_ai1_value
{
    LABEL [PI_display_measure];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_OUT_SCALE_Units_Index (HIDDEN),
        refarray_func1_AI_CHANNEL[meas_type] (READ_ONLY),
        ROWBREAK,
        func1_AI_OUT_Value (READ_ONLY),
        ROWBREAK,
        func1_AI_OUT_Status_Condensed (READ_ONLY)
    }
}

/* TAG... */
MENU conf_out_ai1_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func1_AI_TAG_DESC,
        func1_AI_STRATEGY,
        func1_AI_ST_REV
    }
}

/* OUT,CHANNEL... */
MENU conf_out_ai1_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        refarray_func1_AI_CHANNEL[meas_type],
        func1_AI_PV_FTIME,
        func1_AI_PV_SCALE_Lower_Value,
        func1_AI_PV_SCALE_Upper_Value,
        func1_AI_OUT_SCALE_Lower_Value,
        func1_AI_OUT_SCALE_Upper_Value,
        //    func1_AI_OUT_SCALE_Units_Index(READ_ONLY),
        func1_AI_OUT_SCALE_Decimal_Point
    }
}

/* Alarm, limits... */
MENU conf_out_ai1_alarm
{
    LABEL TXT_FB_ALARM;
    STYLE GROUP;
    ITEMS
    {
        func1_AI_HI_HI_LIM,
        func1_AI_HI_LIM,
        func1_AI_LO_LIM,
        func1_AI_LO_LO_LIM,
        func1_AI_ALARM_HYS
    }
}

/* fail safe... */
MENU conf_out_ai1_fail
{
    LABEL TXT_FB_FAIL;
    STYLE GROUP;
    ITEMS
    {
        func1_AI_FSAFE_TYPE,
        func1_AI_FSAFE_VALUE
    }
}

/* Batch.. */
MENU conf_out_ai1_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func1_AI_BATCH_Batch_ID,
        func1_AI_BATCH_Rup,
        func1_AI_BATCH_Operation,
        func1_AI_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_ai1_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func1_AI_TARGET_MODE,
        func1_AI_MODE_BLK_Actual,
        func1_AI_SIMULATE_Enabled,
        func1_AI_SIMULATE_Value,
        func1_AI_SIMULATE_Status_Condensed
    }
}

MENU out_ai1_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_MODE_BLK_Actual,
        ROWBREAK ,
        func1_AI_SIMULATE_Enabled (READ_ONLY)
    }
}

MENU simulation_window_ai1
{
    LABEL [LABEL_AI1];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
        func1_AI_OUT_SCALE_Units_Index (HIDDEN),

        func1_AI_CHANNEL (READ_ONLY),
        simulation_wnd_ai1_input,
        simulation_wnd_ai1_output
    }
}
MENU simulation_wnd_ai1_input
{
    LABEL TXT_AI_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_AI_SIMULATE_Enabled,
        func1_AI_SIMULATE_Value,
        func1_AI_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_ai1_output
{
    LABEL TXT_AI_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_AI_TARGET_MODE,
        func1_AI_MODE_BLK_Actual,
        func1_AI_OUT_Value,
        func1_AI_OUT_Status_Condensed
    }
}
/*
 ####################################
 Diagnose vom AI
 ####################################
 */
MENU output_ai1_diag_window
{
    LABEL "Output AI1";
    STYLE WINDOW;
    ITEMS
    {
        diag_out_ai1_alarm
    }
}

/* Alarms... */
MENU diag_out_ai1_alarm
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        func1_AI_ALARM_SUM_Current,
        func1_AI_ALARM_SUM_Unacknowledged,
        func1_AI_ALARM_SUM_Unreported,
        func1_AI_ALARM_SUM_Disabled,
        func1_AI_HI_HI_ALM_Unacknowledged,
        func1_AI_HI_HI_ALM_Alarm_State,
        //func1_AI_HI_HI_ALM_Time_Stamp,
        func1_AI_HI_HI_ALM_Subcode,
        func1_AI_HI_HI_ALM_Value,
        /* -------------------------- */
        func1_AI_HI_ALM_Unacknowledged,
        func1_AI_HI_ALM_Alarm_State,
        // func1_AI_HI_ALM_Time_Stamp,
        func1_AI_HI_ALM_Subcode,
        func1_AI_HI_ALM_Value,
        /* -------------------------- */
        func1_AI_LO_ALM_Unacknowledged,
        func1_AI_LO_ALM_Alarm_State,
        // func1_AI_LO_ALM_Time_Stamp,
        func1_AI_LO_ALM_Subcode,
        func1_AI_LO_ALM_Value,
        /* -------------------------- */
        func1_AI_LO_LO_ALM_Unacknowledged,
        func1_AI_LO_LO_ALM_Alarm_State,
        // func1_AI_LO_LO_ALM_Time_Stamp,
        func1_AI_LO_LO_ALM_Subcode,
        func1_AI_LO_LO_ALM_Value
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

SOURCE ai1_value_source
{
    LABEL [LABEL_AI1];
    Y_AXIS func1_AI_Display_BarVal_out_axis_mandatory_B;
    MEMBERS
    {
        PRIM_VAL, func1_AI_OUT_Value;
    }
}

CHART ai1_value_chart
{
    LABEL "AI1 Value";
    TYPE HORIZONTAL_BAR;    //GAUGE;
    MEMBERS {CHART1, ai1_value_source;}
}

/* Messwerte */
MENU display_out_func1_AI
{
    LABEL [LABEL_AI1];
    ITEMS 
    {
        meas_type (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
        
        out_ai1_value,
        ROWBREAK,
        out_ai1_simu,
        ROWBREAK,
        out_ai1_alarms
    }
}
MENU func1_AI_ovw
{
    LABEL [LABEL_AI1];
    STYLE GROUP;
    ITEMS 
    {
        meas_type (HIDDEN),        
        func1_AI_OUT_SCALE_Units_Index (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),
                
        func1_AI_CHANNEL (READ_ONLY),
        func1_AI_OUT_Value,        
        func1_AI_OUT_Status_Condensed
    }
}

/* Alarme */

MENU out_ai1_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_ALARM_SUM_Current
    }
}

MENU overview_ai1_alarms
{
    LABEL [LABEL_AI1];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_ALARM_SUM_Current
        /*
        ,
        COLUMNBREAK,
        func1_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func1_AI_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func1_AI_ALARM_SUM_Disabled        
        */
    }
}

//MENU OnlineWindow_S_alarm_func1_AI
MENU Win_alarm_func1_AI
{
    LABEL "Alarms";
    STYLE GROUP;
    ITEMS
    {
        alarm_sum_func1_AI,
        alarm_hi_hi_alm_func1_AI,
        alarm_hi_alm_func1_AI,
        alarm_lo_alm_func1_AI,
        alarm_lo_lo_alm_func1_AI
    }
}

MENU alarm_sum_func1_AI
{
    LABEL [PI_ALARM_SUM_label];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_ALARM_SUM_Current,
        func1_AI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func1_AI_ALARM_SUM_Unreported,
        func1_AI_ALARM_SUM_Disabled
    }
}

MENU alarm_hi_hi_alm_func1_AI
{
    LABEL [PI_HI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_HI_HI_ALM_Unacknowledged,
        func1_AI_HI_HI_ALM_Alarm_State,
        //func1_AI_HI_HI_ALM_Time_Stamp,
        func1_AI_HI_HI_ALM_Subcode,
        func1_AI_HI_HI_LIM (READ_ONLY),
        func1_AI_HI_HI_ALM_Value
    }
}

MENU alarm_hi_alm_func1_AI
{
    LABEL [PI_HI_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_HI_ALM_Unacknowledged,
        func1_AI_HI_ALM_Alarm_State,
        //func1_AI_HI_ALM_Time_Stamp,
        func1_AI_HI_ALM_Subcode,
        func1_AI_HI_LIM (READ_ONLY),
        func1_AI_HI_ALM_Value
    }
}

MENU alarm_lo_alm_func1_AI
{
    LABEL [PI_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_LO_ALM_Unacknowledged,
        func1_AI_LO_ALM_Alarm_State,
        //func1_AI_LO_ALM_Time_Stamp,
        func1_AI_LO_ALM_Subcode,
        func1_AI_LO_LIM (READ_ONLY),
        func1_AI_LO_ALM_Value
    }
}

MENU alarm_lo_lo_alm_func1_AI
{
    LABEL [PI_LO_LO_LIM_label];
    STYLE GROUP;
    ITEMS
    {
        func1_AI_LO_LO_ALM_Unacknowledged,
        func1_AI_LO_LO_ALM_Alarm_State,
        //func1_AI_LO_LO_ALM_Time_Stamp,
        func1_AI_LO_LO_ALM_Subcode,
        func1_AI_LO_LO_LIM (READ_ONLY),
        func1_AI_LO_LO_ALM_Value
    }
}

METHOD method_func1_set_default_unit
{
    LABEL "";
    CLASS OUTPUT;
    ACCESS ONLINE;
    DEFINITION {func1_AI_OUT_SCALE_Units_Index = method_set_default_unit(func1_AI_CHANNEL);}
}

UNIT func1_AI_OUT_SCALE_unit_x
{
    func1_AI_OUT_SCALE_Units_Index:            
    func1_AI_SIMULATE_Value
}
