//-------------------------------------------------------------------------------------------------
// Structure of this file:
//-------------------------------------------------------------------------------------------------
//    Macros
//Configuration
//    Up-/Download List
//BLOCK
//    VARIABLE
//    ARRAY
//    COMMAND
//    UNIT
//COLLECTION
//METHOD
//MENU

//-------------------------------------------------------------------------------------------------
//    Macros
//-------------------------------------------------------------------------------------------------


#define TNR2TXT \
        {  1 ,[TXT_001] }, \
        {102 ,[TXT_102] }, \
        {103 ,[TXT_103] }, \
        {104 ,[TXT_104] }, \
        {105 ,[TXT_105] }, \
        {106 ,[TXT_106] }, \
        {110 ,[TXT_110] }, \
        {111 ,[TXT_111] }, \
        {112 ,[TXT_112] }, \
        {113 ,[TXT_113] }, \
        {114 ,[TXT_114] }, \
        {115 ,[TXT_115] }, \
        {116 ,[TXT_116] }, \
        {117 ,[TXT_117] }, \
        {118 ,[TXT_118] }, \
        {119 ,[TXT_119] }, \
        {120 ,[TXT_120] }, \
        {121 ,[TXT_121] }, \
        {122 ,[TXT_122] }, \
        {123 ,[TXT_123] }, \
        {124 ,[TXT_124] }, \
        {125 ,[TXT_125] }, \
        {126 ,[TXT_117] }, \
        {127 ,[TXT_118] }, \
        {128 ,[TXT_119] }, \
        {129 ,[TXT_120] }, \
        {130 ,[TXT_121] }, \
        {131 ,[TXT_122] }, \
        {132 ,[TXT_123] }, \
        {133 ,[TXT_124] }, \
        {134 ,[TXT_134] }, \
        {135 ,[TXT_117] }, \
        {136 ,[TXT_118] }, \
        {137 ,[TXT_119] }, \
        {138 ,[TXT_120] }, \
        {139 ,[TXT_121] }, \
        {140 ,[TXT_122] }, \
        {141 ,[TXT_123] }, \
        {142 ,[TXT_124] }, \
        {143 ,[TXT_143] }, \
        {144 ,[TXT_144] }, \
        {145 ,[TXT_122] }, \
        {146 ,[TXT_146] }, \
        {147 ,[TXT_147] }, \
        {148 ,[TXT_148] }, \
        {149 ,[TXT_149] }, \
        {150 ,[TXT_150] }, \
        {151 ,[TXT_146] }, \
        {152 ,[TXT_152] }, \
        {153 ,[TXT_153] }, \
        {154 ,[TXT_154] }, \
        {155 ,[TXT_155] }, \
        {156 ,[TXT_156] }, \
        {157 ,[TXT_157] }, \
        {158 ,[TXT_158] }, \
        {170 ,[TXT_114] }, \
        {171 ,[TXT_115] }, \
        {172 ,[TXT_114] }, \
        {173 ,[TXT_115] }, \
        {180 ,[TXT_180] }, \
        {182 ,[TXT_182] }, \
        {183 ,[TXT_182] }, \
        {184 ,[TXT_182] }, \
        {200 ,[TXT_200] }, \
        {201 ,[TXT_103] }, \
        {202 ,[TXT_102] }, \
        {203 ,[TXT_103] }, \
        {204 ,[TXT_104] }, \
        {205 ,[TXT_105] }, \
        {206 ,[TXT_106] }, \
        {207 ,[TXT_207] }, \
        {208 ,[TXT_208] }, \
        {209 ,[TXT_209] }, \
        {210 ,[TXT_110] }, \
        {211 ,[TXT_111] }, \
        {214 ,[TXT_114] }, \
        {215 ,[TXT_115] }, \
        {216 ,[TXT_116] }, \
        {217 ,[TXT_117] }, \
        {218 ,[TXT_118] }, \
        {219 ,[TXT_119] }, \
        {225 ,[TXT_125] }, \
        {226 ,[TXT_117] }, \
        {227 ,[TXT_118] }, \
        {228 ,[TXT_119] }, \
        {234 ,[TXT_134] }, \
        {235 ,[TXT_117] }, \
        {236 ,[TXT_118] }, \
        {237 ,[TXT_119] }, \
        {243 ,[TXT_156] }, \
        {244 ,[TXT_244] }, \
        {245 ,[TXT_122] }, \
        {246 ,[TXT_146] }, \
        {247 ,[TXT_147] }, \
        {248 ,[TXT_157] }, \
        {249 ,[TXT_249] }, \
        {250 ,[TXT_250] }, \
        {251 ,[TXT_146] }, \
        {252 ,[TXT_152] }, \
        {253 ,[TXT_155] }, \
        {254 ,[TXT_254] }, \
        {255 ,[TXT_117] }, \
        {256 ,[TXT_118] }, \
        {257 ,[TXT_119] }, \
        {258 ,[TXT_120] }, \
        {259 ,[TXT_124] }, \
        {260 ,[TXT_260] }, \
        {262 ,[TXT_121] }, \
        {263 ,[TXT_263] }, \
        {270 ,[TXT_114] }, \
        {271 ,[TXT_115] }, \
        {272 ,[TXT_114] }, \
        {273 ,[TXT_115] }, \
        {280 ,[TXT_180] }, \
        {281 ,[TXT_281] }, \
        {282 ,[TXT_182] }, \
        {283 ,[TXT_182] }, \
        {284 ,[TXT_182] }, \
        {300 ,[TXT_300] }, \
        {301 ,[TXT_301] }, \
        {302 ,[TXT_302] }, \
        {306 ,[TXT_306] }, \
        {307 ,[TXT_307] }, \
        {308 ,[TXT_308] }, \
        {309 ,[TXT_309] }, \
        {310 ,[TXT_310] }, \
        {311 ,[TXT_307] }, \
        {312 ,[TXT_308] }, \
        {313 ,[TXT_309] }, \
        {314 ,[TXT_314] }, \
        {315 ,[TXT_307] }, \
        {316 ,[TXT_308] }, \
        {317 ,[TXT_309] }, \
        {319 ,[TXT_319] }, \
        {320 ,[TXT_320] }, \
        {321 ,[TXT_321] }, \
        {322 ,[TXT_322] }, \
        {323 ,[TXT_323] }, \
        {324 ,[TXT_324] }, \
        {325 ,[TXT_325] }, \
        {402 ,[TXT_402] }, \
        {403 ,[TXT_103] }, \
        {404 ,[TXT_104] }, \
        {405 ,[TXT_105] }, \
        {406 ,[TXT_106] }, \
        {410 ,[TXT_410] }, \
        {412 ,[TXT_412] }, \
        {413 ,[TXT_413] }, \
        {415 ,[TXT_415] }, \
        {416 ,[TXT_416] }, \
        {417 ,[TXT_417] }, \
        {418 ,[TXT_118] }, \
        {419 ,[TXT_119] }, \
        {420 ,[TXT_420] }, \
        {421 ,[TXT_421] }, \
        {422 ,[TXT_422] }, \
        {423 ,[TXT_123] }, \
        {424 ,[TXT_259] }, \
        {430 ,[TXT_430] }, \
        {431 ,[TXT_431] }, \
        {432 ,[TXT_432] }, \
        {433 ,[TXT_433] }, \
        {434 ,[TXT_434] }, \
        {435 ,[TXT_435] }, \
        {436 ,[TXT_436] }, \
        {437 ,[TXT_437] }, \
        {444 ,[TXT_444] }, \
        {447 ,[TXT_447] }, \
        {548 ,[TXT_444] }, \
        {549 ,[TXT_549] }, \
        {448 ,[TXT_448] }, \
        {449 ,[TXT_449] }, \
        {450 ,[TXT_450] }, \
        {451 ,[TXT_146] }, \
        {452 ,[TXT_152] }, \
        {453 ,[TXT_153] }, \
        {454 ,[TXT_154] }, \
        {458 ,[TXT_158] }, \
        {480 ,[TXT_180] }, \
        {502 ,[TXT_502] }, \
        {503 ,[TXT_103] }, \
        {504 ,[TXT_104] }, \
        {505 ,[TXT_105] }, \
        {506 ,[TXT_106] }, \
        {510 ,[TXT_410] }, \
        {515 ,[TXT_415] }, \
        {516 ,[TXT_416] }, \
        {517 ,[TXT_417] }, \
        {518 ,[TXT_118] }, \
        {519 ,[TXT_119] }, \
        {530 ,[TXT_430] }, \
        {531 ,[TXT_431] }, \
        {532 ,[TXT_432] }, \
        {533 ,[TXT_433] }, \
        {534 ,[TXT_434] }, \
        {535 ,[TXT_435] }, \
        {536 ,[TXT_436] }, \
        {537 ,[TXT_437] }, \
        {544 ,[TXT_444] }, \
        {547 ,[TXT_447] }, \
        {553 ,[TXT_155] }, \
        {563 ,[TXT_263] }, \
        {580 ,[TXT_180] }, \
        {581 ,[TXT_281] }, \
        {602 ,[TXT_402] }, \
        {603 ,[TXT_103] }, \
        {604 ,[TXT_104] }, \
        {605 ,[TXT_105] }, \
        {606 ,[TXT_106] }, \
        {617 ,[TXT_617] }, \
        {618 ,[TXT_118] }, \
        {619 ,[TXT_119] }, \
        {643 ,[TXT_643] }, \
        {647 ,[TXT_647] }, \
        {653 ,[TXT_153] }, \
        {702 ,[TXT_502] }, \
        {703 ,[TXT_103] }, \
        {704 ,[TXT_104] }, \
        {705 ,[TXT_105] }, \
        {706 ,[TXT_106] }, \
        {717 ,[TXT_617] }, \
        {718 ,[TXT_118] }, \
        {719 ,[TXT_119] }, \
        {743 ,[TXT_643] }, \
        {747 ,[TXT_647] }, \
        {753 ,[TXT_155] }, \
        {802 ,[TXT_402] }, \
        {803 ,[TXT_103] }, \
        {804 ,[TXT_104] }, \
        {805 ,[TXT_105] }, \
        {806 ,[TXT_106] }, \
        {817 ,[TXT_617] }, \
        {818 ,[TXT_118] }, \
        {819 ,[TXT_119] }, \
        {847 ,[TXT_847] }, \
        {853 ,[TXT_153] }, \
        {880 ,[TXT_180] }, \
        {902 ,[TXT_702] }, \
        {903 ,[TXT_103] }, \
        {904 ,[TXT_104] }, \
        {905 ,[TXT_105] }, \
        {906 ,[TXT_106] }, \
        {917 ,[TXT_617] }, \
        {918 ,[TXT_118] }, \
        {919 ,[TXT_119] }, \
        {947 ,[TXT_847] }, \
        {953 ,[TXT_155] }, \
        {980 ,[TXT_180] }, \
        {981 ,[TXT_281] }, \

#define TNR2VAL \
        {102 ,[VAL_102] }, \
        {103 ,[VAL_103] }, \
        {104 ,[VAL_104] }, \
        {105 ,[VAL_105] }, \
        {106 ,[VAL_106] }, \
        {110 ,[VAL_110] }, \
        {111 ,[VAL_111] }, \
        {112 ,[VAL_112] }, \
        {113 ,[VAL_113] }, \
        {114 ,[VAL_114] }, \
        {115 ,[VAL_115] }, \
        {116 ,[VAL_116] }, \
        {117 ,[VAL_117] }, \
        {118 ,[VAL_118] }, \
        {119 ,[VAL_119] }, \
        {120 ,[VAL_120] }, \
        {121 ,[VAL_121] }, \
        {122 ,[VAL_122] }, \
        {123 ,[VAL_123] }, \
        {124 ,[VAL_124] }, \
        {125 ,[VAL_125] }, \
        {126 ,[VAL_117] }, \
        {127 ,[VAL_118] }, \
        {128 ,[VAL_119] }, \
        {129 ,[VAL_120] }, \
        {130 ,[VAL_121] }, \
        {131 ,[VAL_122] }, \
        {132 ,[VAL_123] }, \
        {133 ,[VAL_124] }, \
        {134 ,[VAL_134] }, \
        {135 ,[VAL_117] }, \
        {136 ,[VAL_118] }, \
        {137 ,[VAL_119] }, \
        {138 ,[VAL_120] }, \
        {139 ,[VAL_121] }, \
        {140 ,[VAL_122] }, \
        {141 ,[VAL_123] }, \
        {142 ,[VAL_124] }, \
        {143 ,[VAL_143] }, \
        {144 ,[VAL_144] }, \
        {145 ,[VAL_122] }, \
        {146 ,[VAL_146] }, \
        {147 ,[VAL_147] }, \
        {148 ,[VAL_148] }, \
        {149 ,[VAL_149] }, \
        {150 ,[VAL_150] }, \
        {151 ,[VAL_146] }, \
        {152 ,[VAL_152] }, \
        {153 ,[VAL_153] }, \
        {154 ,[VAL_154] }, \
        {155 ,[VAL_155] }, \
        {156 ,[VAL_156] }, \
        {157 ,[VAL_157] }, \
        {158 ,[VAL_158] }, \
        {170 ,[VAL_114] }, \
        {171 ,[VAL_115] }, \
        {172 ,[VAL_114] }, \
        {173 ,[VAL_115] }, \
        {180 ,[VAL_180] }, \
        {182 ,[VAL_182] }, \
        {183 ,[VAL_182] }, \
        {184 ,[VAL_182] }, \
        {200 ,[VAL_200] }, \
        {201 ,[VAL_103] }, \
        {202 ,[VAL_102] }, \
        {203 ,[VAL_103] }, \
        {204 ,[VAL_104] }, \
        {205 ,[VAL_105] }, \
        {206 ,[VAL_106] }, \
        {207 ,[VAL_207] }, \
        {208 ,[VAL_208] }, \
        {209 ,[VAL_209] }, \
        {210 ,[VAL_110] }, \
        {211 ,[VAL_111] }, \
        {214 ,[VAL_114] }, \
        {215 ,[VAL_115] }, \
        {216 ,[VAL_116] }, \
        {217 ,[VAL_117] }, \
        {218 ,[VAL_118] }, \
        {219 ,[VAL_119] }, \
        {225 ,[VAL_125] }, \
        {226 ,[VAL_117] }, \
        {227 ,[VAL_118] }, \
        {228 ,[VAL_119] }, \
        {234 ,[VAL_134] }, \
        {235 ,[VAL_117] }, \
        {236 ,[VAL_118] }, \
        {237 ,[VAL_119] }, \
        {243 ,[VAL_156] }, \
        {244 ,[VAL_244] }, \
        {245 ,[VAL_122] }, \
        {246 ,[VAL_146] }, \
        {247 ,[VAL_147] }, \
        {248 ,[VAL_157] }, \
        {249 ,[VAL_249] }, \
        {250 ,[VAL_250] }, \
        {251 ,[VAL_146] }, \
        {252 ,[VAL_152] }, \
        {253 ,[VAL_155] }, \
        {254 ,[VAL_254] }, \
        {255 ,[VAL_117] }, \
        {256 ,[VAL_118] }, \
        {257 ,[VAL_119] }, \
        {258 ,[VAL_120] }, \
        {259 ,[VAL_124] }, \
        {260 ,[VAL_260] }, \
        {262 ,[VAL_121] }, \
        {263 ,[VAL_263] }, \
        {270 ,[VAL_114] }, \
        {271 ,[VAL_115] }, \
        {272 ,[VAL_114] }, \
        {273 ,[VAL_115] }, \
        {280 ,[VAL_180] }, \
        {281 ,[VAL_281] }, \
        {282 ,[VAL_182] }, \
        {283 ,[VAL_182] }, \
        {284 ,[VAL_182] }, \
        {300 ,[VAL_300] }, \
        {301 ,[VAL_301] }, \
        {302 ,[VAL_302] }, \
        {306 ,[VAL_306] }, \
        {307 ,[VAL_307] }, \
        {308 ,[VAL_308] }, \
        {309 ,[VAL_309] }, \
        {310 ,[VAL_310] }, \
        {311 ,[VAL_307] }, \
        {312 ,[VAL_308] }, \
        {313 ,[VAL_309] }, \
        {314 ,[VAL_314] }, \
        {315 ,[VAL_307] }, \
        {316 ,[VAL_308] }, \
        {317 ,[VAL_309] }, \
        {319 ,[VAL_319] }, \
        {320 ,[VAL_320] }, \
        {321 ,[VAL_321] }, \
        {322 ,[VAL_322] }, \
        {323 ,[VAL_323] }, \
        {324 ,[VAL_324] }, \
        {325 ,[VAL_325] }, \
        {402 ,[VAL_402] }, \
        {403 ,[VAL_103] }, \
        {404 ,[VAL_104] }, \
        {405 ,[VAL_105] }, \
        {406 ,[VAL_106] }, \
        {410 ,[VAL_410] }, \
        {412 ,[VAL_412] }, \
        {413 ,[VAL_413] }, \
        {415 ,[VAL_415] }, \
        {416 ,[VAL_416] }, \
        {417 ,[VAL_417] }, \
        {418 ,[VAL_118] }, \
        {419 ,[VAL_119] }, \
        {420 ,[VAL_420] }, \
        {421 ,[VAL_421] }, \
        {422 ,[VAL_422] }, \
        {423 ,[VAL_123] }, \
        {424 ,[VAL_259] }, \
        {430 ,[VAL_430] }, \
        {431 ,[VAL_431] }, \
        {432 ,[VAL_432] }, \
        {433 ,[VAL_433] }, \
        {434 ,[VAL_434] }, \
        {435 ,[VAL_435] }, \
        {436 ,[VAL_436] }, \
        {437 ,[VAL_437] }, \
        {444 ,[VAL_444] }, \
        {447 ,[VAL_447] }, \
        {548 ,[VAL_548] }, \
        {549 ,[VAL_549] }, \
        {448 ,[VAL_448] }, \
        {449 ,[VAL_449] }, \
        {450 ,[VAL_450] }, \
        {451 ,[VAL_146] }, \
        {452 ,[VAL_152] }, \
        {453 ,[VAL_153] }, \
        {454 ,[VAL_154] }, \
        {458 ,[VAL_158] }, \
        {480 ,[VAL_180] }, \
        {502 ,[VAL_502] }, \
        {503 ,[VAL_103] }, \
        {504 ,[VAL_104] }, \
        {505 ,[VAL_105] }, \
        {506 ,[VAL_106] }, \
        {510 ,[VAL_410] }, \
        {515 ,[VAL_415] }, \
        {516 ,[VAL_416] }, \
        {517 ,[VAL_417] }, \
        {518 ,[VAL_118] }, \
        {519 ,[VAL_119] }, \
        {530 ,[VAL_430] }, \
        {531 ,[VAL_431] }, \
        {532 ,[VAL_432] }, \
        {533 ,[VAL_433] }, \
        {534 ,[VAL_434] }, \
        {535 ,[VAL_435] }, \
        {536 ,[VAL_436] }, \
        {537 ,[VAL_437] }, \
        {544 ,[VAL_444] }, \
        {547 ,[VAL_447] }, \
        {553 ,[VAL_155] }, \
        {563 ,[VAL_263] }, \
        {580 ,[VAL_180] }, \
        {581 ,[VAL_281] }, \
        {602 ,[VAL_402] }, \
        {603 ,[VAL_103] }, \
        {604 ,[VAL_104] }, \
        {605 ,[VAL_105] }, \
        {606 ,[VAL_106] }, \
        {617 ,[VAL_617] }, \
        {618 ,[VAL_118] }, \
        {619 ,[VAL_119] }, \
        {643 ,[VAL_643] }, \
        {647 ,[VAL_647] }, \
        {653 ,[VAL_153] }, \
        {702 ,[VAL_502] }, \
        {703 ,[VAL_103] }, \
        {704 ,[VAL_104] }, \
        {705 ,[VAL_105] }, \
        {706 ,[VAL_106] }, \
        {717 ,[VAL_617] }, \
        {718 ,[VAL_118] }, \
        {719 ,[VAL_119] }, \
        {743 ,[VAL_643] }, \
        {747 ,[VAL_647] }, \
        {753 ,[VAL_155] }, \
        {802 ,[VAL_402] }, \
        {803 ,[VAL_103] }, \
        {804 ,[VAL_104] }, \
        {805 ,[VAL_105] }, \
        {806 ,[VAL_106] }, \
        {817 ,[VAL_617] }, \
        {818 ,[VAL_118] }, \
        {819 ,[VAL_119] }, \
        {847 ,[VAL_847] }, \
        {853 ,[VAL_153] }, \
        {880 ,[VAL_180] }, \
        {902 ,[VAL_702] }, \
        {903 ,[VAL_103] }, \
        {904 ,[VAL_104] }, \
        {905 ,[VAL_105] }, \
        {906 ,[VAL_106] }, \
        {917 ,[VAL_617] }, \
        {918 ,[VAL_118] }, \
        {919 ,[VAL_119] }, \
        {947 ,[VAL_847] }, \
        {953 ,[VAL_155] }, \
        {980 ,[VAL_180] }, \
        {981 ,[VAL_281] }, \

#define CALMODE2TXT \
        {  1 ,[CALMODE_1] }, \
        {  2 ,[CALMODE_2] }, \
        {  4 ,[CALMODE_4] }, \
        {  8 ,[CALMODE_8] }, \
        { 16 ,[CALMODE_16] }, \
        { 32 ,[CALMODE_32] }, \
        { 64 ,[CALMODE_64] }, \
        {101 ,[CALMODE_1] }, \
        {102 ,[CALMODE_2] }, \
        {104 ,[CALMODE_4] }, \
        {108 ,[CALMODE_108] }, \
        {116 ,[CALMODE_116] }, \
        {201 ,[CALMODE_201] }, \
        {202 ,[CALMODE_202] }, \
        {204 ,[CALMODE_204] }, \
		{206 ,[CALMODE_204] }, \
        {208 ,[CALMODE_208] }, \
        {216 ,[CALMODE_4] }, \
		{232 ,[CALMODE_232] }, \
		{301 ,[CALMODE_301] }, \
		{302 ,[CALMODE_302] }, \
		{304 ,[CALMODE_304] }, \
		{308 ,[CALMODE_308] }, \
		{316 ,[CALMODE_316] }, \
		{401 ,[CALMODE_401] }, \
		{402 ,[CALMODE_402] }, \
		{404 ,[CALMODE_404] }, \
		{408 ,[CALMODE_408] }, \
		{999 ,[CALMODE_unknown] }, \

//-------------------------------------------------------------------------------------------------
//    Configuration
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    BLOCK
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    VARIABLE
//-------------------------------------------------------------------------------------------------

VARIABLE local_calprot_data_item
{
    LABEL "Calprot Array Item";
    CLASS LOCAL;
    TYPE UNSIGNED_INTEGER
    {
        DEFAULT_VALUE 0xFF;
    }
    HANDLING READ;
}


VARIABLE CalProtocol_Attribute
{
  LABEL               "Entry";
  CLASS               LOCAL;
  TYPE                ASCII;
  HANDLING            READ;
}

ARRAY CalProtocol_Attributes
{
  LABEL               "Entry";
  NUMBER_OF_ELEMENTS  30;
  TYPE                CalProtocol_Attribute;
}

VARIABLE CalProtocol_Value
{
  LABEL               "Entry";
  CLASS               LOCAL;
  TYPE                ASCII;
  HANDLING            READ;
}

ARRAY CalProtocol_Values
{
  LABEL               "Entry";
  NUMBER_OF_ELEMENTS  30;
  TYPE                CalProtocol_Attribute;
}


//-------------------------------------------------------------------------------------------------
//    ARRAY
//-------------------------------------------------------------------------------------------------

ARRAY local_calprot_data
{
    LABEL "Cal Protocol Array";
    TYPE local_calprot_data_item;
    NUMBER_OF_ELEMENTS 1024;
}

//-------------------------------------------------------------------------------------------------
//    COMMAND
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    UNIT
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    COLLECTION
//-------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------
//    METHOD
//-------------------------------------------------------------------------------------------------

MENU Page_calprot_not_supported
{
    LABEL [str_wrong_version];
    ITEMS
    { 		
		Group_calprot_not_supported
    }    
}

MENU Group_calprot_not_supported
{
    LABEL [str_wrong_version];
	STYLE GROUP;
    ITEMS
    { 
		
		phys_software_rev,
		[str_calprot_not_supported]
    }    
}


METHOD method_calprot_read_next(int TB_channel) 
{
    LABEL    "";
    CLASS INPUT;
    DEFINITION
    {

        int status;

        status = 0;
		
        switch (TB_channel) {
            case TB_CHANNEL_1 :
                ReadCommand(read_func1_AI_calprot_status);
                status = func1_AI_calprot_status;
                break;

            case TB_CHANNEL_2 :
                ReadCommand(read_func5_AI_calprot_status);
                status = func5_AI_calprot_status;
                break;
        }

        switch (status) // dann ist mindestens ein weiteres Protokoll da
        {
            case 0 :
                //ACKNOWLEDGE("Kein Protokoll vorhanden!");
                break;

            case 1 :
                //method_calprot_read_again(TB_channel);
                //ACKNOWLEDGE("Kein weiteres Protokoll vorhanden!");
                break;

            default:
                switch (TB_channel) {
                    case TB_CHANNEL_1 :
                        func1_AI_calprot_confirm = 1; // Protokoll besttigen, weiterschalten
                        WriteCommand(write_func1_AI_calprot_confirm);
                        break;

                    case TB_CHANNEL_2 :
                        func5_AI_calprot_confirm = 1; // Protokoll besttigen, weiterschalten
                        WriteCommand(write_func5_AI_calprot_confirm);
                        break;
                }

                method_calprot_reader(TB_channel); // Protokoll auslesen
                break;
        }
    }
}

METHOD method_calprot_read_rewind(int TB_channel) {
    LABEL
    "";
    CLASS INPUT;
    DEFINITION
    {

        int status;

        status = 0;

        switch (TB_channel) {
            case TB_CHANNEL_1 :
                ReadCommand(read_func1_AI_calprot_status);
                status = func1_AI_calprot_status;
                break;

            case TB_CHANNEL_2 :
                ReadCommand(read_func5_AI_calprot_status);
                status = func5_AI_calprot_status;
                break;
        }

        if (status > 0) // dann ist mindestens ein Protokoll da
                {
            switch (TB_channel) {
                case TB_CHANNEL_1 :
                    func1_AI_calprot_confirm = 2; // Protokoll 1 zurckspulen
                    WriteCommand(write_func1_AI_calprot_confirm);
                    break;

                case TB_CHANNEL_2 :
                    func5_AI_calprot_confirm = 2; // Protokoll 2 zurckspulen
                    WriteCommand(write_func5_AI_calprot_confirm);
                    break;
            }

            //method_calprot_reader(TB_channel); // Protokoll auslesen
        }
        else // kein Protokoll vorhanden
        {
            //ACKNOWLEDGE("Kein Protokoll vorhanden!");
        }

    }
}

/*
METHOD method_calprot_confirm() 
{
    LABEL    "Confirm";
    CLASS INPUT;
    DEFINITION
    {
		func1_AI_calprot_confirm = 1;
        WriteCommand(write_func1_AI_calprot_confirm);
		ReadCommand(read_func1_AI_calprot_status);
	}
}

METHOD method_calprot_read() 
{
    LABEL    "Read";
    CLASS INPUT;
    DEFINITION
    {
		func1_AI_local_calprot_text = "";
		method_calprot_reader(TB_CHANNEL_1);
	}
}
METHOD method_calprot_status() 
{
    LABEL    "Status";
    CLASS INPUT;
    DEFINITION
    {
		ReadCommand(read_func1_AI_calprot_status);
	}
}
*/

METHOD method_calprot_next(int TB_channel) 
{
    LABEL    "Next";
    CLASS INPUT;
    DEFINITION
    {
		
		switch (TB_channel) {
			case 0 : 
				ReadCommand(read_func1_AI_calprot_status);
				if (func1_AI_calprot_status > 1 ) {
					func1_AI_calprot_confirm = 1;
					WriteCommand(write_func1_AI_calprot_confirm);
				}
				break;
			case 1 : 
				ReadCommand(read_func5_AI_calprot_status);
				if (func5_AI_calprot_status > 1 ) {
					func5_AI_calprot_confirm = 1;
					WriteCommand(write_func5_AI_calprot_confirm);
				}
				break;
		}					
	}
}

METHOD method_calprot_read_all(int TB_channel) 
{
    LABEL  "";
    CLASS INPUT;
    DEFINITION
    {
		int status,i;
		DD_STRING proto_text;
		
		status = 999;        
		proto_text = [TXT_000];

		for (i=0; i<PROTO_GRID_ROWS; i++){
			
			CalProtocol_Attributes[i]= "";
			CalProtocol_Values[i] = "";
		}
				
		// Vorspulen, bis nur noch ein Protokoll im COMPA vorhanden ist,
		// dieses darf nicht weitergespult werden, da es sonst vom COMPA gelscht wird 
		// und dann unwiederbringlich verloren ist.
		while (status > 1) {
		
			switch (TB_channel) {
				case 0 : 
					ReadCommand(read_func1_AI_calprot_status);
					status = func1_AI_calprot_status;
					break;
				case 1 : 
					ReadCommand(read_func5_AI_calprot_status);
					status = func5_AI_calprot_status;
					break;
			}
			method_calprot_next(TB_channel);
		}
		method_calprot_read_rewind(TB_channel);
		
		// wenn nur noch ein Protokoll im COMPA vorhanden, dann auslesen, dekodieren und anzeigen
		if (status == 1) {
			
			proto_text = method_calprot_reader(TB_channel);
		}
					
		switch (TB_channel) {
			case 0 :                
				func1_AI_local_calprot_text = proto_text;
				for (i=0; i<PROTO_GRID_ROWS;i++){
					func1_CalProtocol_Attributes[i] = CalProtocol_Attributes[i];
					func1_CalProtocol_Values[i] = CalProtocol_Values[i];
				}
				break;

			case 1 :
				func5_AI_local_calprot_text = proto_text;
				for (i=0; i<PROTO_GRID_ROWS;i++){
					func5_CalProtocol_Attributes[i] = CalProtocol_Attributes[i];
					func5_CalProtocol_Values[i] = CalProtocol_Values[i];
				}
				break;
		}
	}
}

METHOD method_calprot_reader(int TB_channel) 
{
    LABEL  "";
    CLASS INPUT;
	TYPE DD_STRING;
    DEFINITION
    {
        int i, n, res, z;		
        unsigned char cbuf[PROTO_LENGTH];
				
        res = 0;
        n = 0;

        while ((n < 10) && (res == 0)) {
            
            switch (TB_channel) {
                case 0 :					
					ReadCommand(read_func1_AI_calprot_data);
					for (i = 0; i < PROTO_LENGTH; i++) {
						cbuf[i] = func1_AI_calprot_data[i];
					}
					
                    break;
                case 1 :
					ReadCommand(read_func5_AI_calprot_data);
					for (i = 0; i < PROTO_LENGTH; i++) {
						cbuf[i] = func5_AI_calprot_data[i];
						}
                    
                    break;
            }

			//PUT_MESSAGE(" " + cbuf[0] + " " + n);
            if (cbuf[0] != n) // dann stimmt der Hppchen-Zhler nicht                    
			{
                res = 1; // Fehler!
            }
            else // Hppchen-Zhler stimmt, dann erstmal das Hppchen an das lokale Gesamt-Binr-Protokoll anhngen
            {
                for (i = 0; i < PROTO_LENGTH - 2; i++) {

                    local_calprot_data[i + (n * (PROTO_LENGTH - 2))] = cbuf[i+ 2];
                }

                if (cbuf[1] == 0) { // d.h. 'no more data'
                        
                    if ((n == 0) && (cbuf[2] == 0)) { // dann ist es ein Leer-Protokoll (0x00, 0x00, 0x00)
                            
                        res = 2; // fertig, es war aber ein Leer-Protokoll
                    }
                    else {
						
                        res = 3; // fertig, echtes Protokoll liegt vor
                    }
                }
                else // d.h. weitere Hppchen verfgbar -> res = 0 lassen, weitermachen
                {
                    n = n + 1;
                    switch (TB_channel) {
                        case 0 :
                            func1_AI_calprot_confirm = 3; // Block quittieren -> NEXT_BLOCK
                            WriteCommand(write_func1_AI_calprot_confirm);
                            break;

                        case 1 :
                            func5_AI_calprot_confirm = 3; // Block quittieren -> NEXT_BLOCK
                            WriteCommand(write_func5_AI_calprot_confirm);
                            break;
                    }
                }
            }
        }

        switch (res) {
            case 1 :
                ACKNOWLEDGE("Fehler (1) beim Lesen des Protokolls.");
                break;

            case 2 :
                ACKNOWLEDGE("Fehler (2) beim Lesen des Protokolls."); // COMPA hat nur ein Leer-Protokoll geliefert; darf nicht sein
                break;

            case 3 :				
                return method_calprot_interpreter(); // Lesen ok, nun auswerten
                break;
        }
		return "";
    }
}

#define proto local_calprot_data
METHOD method_calprot_interpreter() 
{
    LABEL  "";
	TYPE DD_STRING;
    CLASS INPUT;
    DEFINITION
    {

        //DD_STRING a, b;
        //unsigned char c;        
        char proto_text[2048];
        char buf[64];
        unsigned int tnr, mode;
        int i, j, m, expo, bcnt, floatVar, dateVar, entryCount;
        unsigned long k, value;
        float fVar;
		
        proto_text = "";        
			
        i = 0;
        entryCount = 0;
		
		
        while ((i < 1024) && (proto[i] != 0)) {

            buf[0] = '0'; /* ASCII-Buffer lschen*/
            bcnt = proto[i];
            tnr = proto[i + 2];
            tnr = tnr << 8;
            tnr = tnr + proto[i + 1];
            floatVar = 0; /* bisher keine Floatumwandlung notwendig*/
            dateVar = 0; /* und keine Datum/Uhrzeit-Umwandlungen*/
            
            //PUT_MESSAGE("Byte-Gre: " + bcnt + "\n"+ "TNR: " + tnr);
             
            switch (bcnt) {
                case 4 :
					
					mode = proto[i + 3];
					// mode kommt aus dem bertragenen Protokoll und gibt an, welcher Kalibriermode gewhlt war
				    // hier wird Messgren-abhngig noch Meldungsbereiche angelegt.
                    
					switch (tnr) {
                        case 104 : /*=== PH ===*/
                        case 204 :
							buf = method_format_string(3, 000 + mode, "", -1);
                            break;
                        case 174 : /*=== CO2 ===*/
                        case 274 :
							buf = method_format_string(3, 100 + mode, "", -1);
                            break;
                        case 404 : /*=== OXY ===*/
                        case 504 :
							buf = method_format_string(3, 200 + mode, "", -1);
                            break;
                        case 604 : /*=== CONDI ===*/
                        case 704 :
							buf = method_format_string(3, 300 + mode, "", -1);						                           
                            break;
                        case 804 : /*=== COND ===*/
                        case 904 :
							buf = method_format_string(3, 400 + mode, "", -1);
                            break;

                        default:
                            if (proto[i + 3]) {
                                buf = BUILD_MESSAGE("|en|Yes|de|Ja");
                            }
                            else {
                                buf = BUILD_MESSAGE("|en|No|de|Nein");
                            }
                            break;
                    }
                    break;
                case 7 :
                    switch (tnr) {
                        case 102 :
                        case 200 :
                        case 202 :
                        case 402 :
                        case 502 :
                        case 602 :
                        case 702 :
                        case 802 :
                        case 902 : //value = proto[i+3] + (proto[i+4]<<8) + (proto[i+5]<<16) + (proto[i+6]<<24);
                            value = proto[i + 6];
                            value <<= 8;
                            value += proto[i + 5];
                            value <<= 8;
                            value += proto[i + 4];
                            value <<= 8;
                            value += proto[i + 3];
                            dateVar = 1; // value muss in Datum/Uhrzeit gewandelt werden
                            break;

                        case 308 :
                        case 312 :
                        case 316 :
                            buf[0] = '0' + (proto[i + 3] >> 4);
                            buf[1] = '0' + (proto[i + 3] & 0x0F);
                            buf[2] = buf[5] = '.';
                            buf[3] = '0' + (proto[i + 4] >> 4);
                            buf[4] = '0' + (proto[i + 4] & 0x0F);
                            buf[6] = '2';
                            buf[7] = '0';
                            buf[8] = '0' + (proto[i + 5] >> 4);
                            buf[9] = '0' + (proto[i + 5] & 0x0F);
                            buf[10] = '\0';
                            break;

                        default:
                            value = proto[i + 6];
                            value <<= 8;
                            value += proto[i + 5];
                            value <<= 8;
                            value += proto[i + 4];
                            value <<= 8;
                            value += proto[i + 3];
                            floatVar = 1; // value muss in float gewandelt werden
                            break;
                    }
                    break;
                default:

                    for (j = 0; j < (bcnt - 3); j++)
                        buf[j] = proto[i + j + 3]; // ASCII
                    buf[bcnt - 3] = '\0';
                    break;
            }

            /*--- Float-Umwandlung ---*/
            if (floatVar) {
                if (value == 0x7FA00000)
                    fVar = 0x7FA00000;
                else {
                    k = value & 0x007FFFFF; // Mantisse auslsen
                    expo = (value & 0x7F800000) >> 23; // Exponent ermitteln
                    if (expo != 0) { // IF( Exponent != 0 )
                        k |= 0x00800000; //   fehlendes Bit eintragen
                        expo -= 127; //   Offset herausnehmen

                        fVar = k; // Mantisse in Float
                        fVar = fVar / 0x00800000; // Auf 1.0 normieren
                        if (expo > 0)
                            for (j = 0; j < expo; j++)
                                fVar = fVar * 2.0; // positiven Exponenten einrechnen
                        else
                            for (j = 0; j < -expo; j++)
                                fVar = fVar / 2.0; // negativen Exponenten einrechnen

                        if (value & 0x80000000)
                            fVar = -fVar; // Vorzeichen umdrehen
                    }
                    else
                        fVar = 0.0;
                }

                //ACKNOWLEDGE("Float: %[f]{f}");
            }

            /*--- Datum-Umwandlung ---*/
            if (dateVar) {
                int tag, monat, jahr, std, min;
                unsigned long sec;

                //ACKNOWLEDGE("Datum: 0x%[8.8x]{value}");
                /*--- Datum aufbereiten ---*/
                tag = monat = 1;
                jahr = 2000;
                while (value >= 0x07861f80) {
                    value -= 0x07861f80; /* Timestamp -= 4 Jahre*/
                    jahr += 4;
                }
                if (value >= 0x01e28500) {
                    value -= 0x01e28500; /* Timestamp -= 1 Schaltjahr*/
                    jahr++;
                    while (value >= 0x01e13380) {
                        value -= 0x01e13380; /* Timestamp -= 1 Jahr*/
                        jahr++;
                    }
                }
                //ACKNOWLEDGE("Jahr: %[d]{jahr}");

                for (monat = 1; monat <= 12; monat++) {
                    switch (monat) {
                        case 2 :
                            sec = (jahr % 4) ? (28 * 86400) : (29 * 86400);
                            break;
                            /*  case 7:Fehler: Der Monat Juli hat 31 und nicht 30 Tage !*/
                        case 4 :
                        case 6 :
                        case 9 :
                        case 11 :
                            sec = 30 * 86400;
                            break;
                        default:
                            sec = 31 * 86400;
                            break;
                    }
                    if (value < sec)
                        break;
                    value -= sec;
                }
                //ACKNOWLEDGE("Monat: %[d]{monat}");

                tag = (value / 86400) + 1;
                value %= 86400;

                buf[0] = '0' + (tag / 10);
                buf[1] = '0' + (tag % 10);
                buf[2] = buf[5] = '.';
                buf[3] = '0' + (monat / 10);
                buf[4] = '0' + (monat % 10);
                buf[6] = '0' + (jahr / 1000);
                buf[7] = '0' + (jahr % 1000) / 100;
                buf[8] = '0' + (jahr % 100) / 10;
                buf[9] = '0' + (jahr % 10);
                buf[10] = '\0';
                //ACKNOWLEDGE("Tag: %[d]{tag}");

                if ((tnr != 308) && (tnr != 312) && (tnr != 316)) {
                    /*--- Uhrzeit aufbereiten ---*/
                    std = value / 3600;
                    value %= 3600;
                    min = value / 60;
                    sec = value % 60;

                    buf[10] = ' ';
                    buf[11] = '0' + (std / 10);
                    buf[12] = '0' + (std % 10);
                    buf[13] = ':';
                    buf[14] = '0' + (min / 10);
                    buf[15] = '0' + (min % 10);
                    buf[16] = '\0';
                }

            }
			
            /*--- Skalierungen und Textausgabe ---*/
            
			switch (tnr) {
                case 110 :
                    fVar = fVar / 1000000.0; /* Ohm -> MOhm */
                    break;
                case 111 :
                    fVar = fVar / 1000.0; /* Ohm -> kOhm */
                    break;
                case 210 :
                    fVar = fVar / 1000000.0; /* Ohm -> MOhm */
                    break;
                case 410 :
                    fVar = fVar / 1000.0; /* Ohm -> kOhm */
                    break;
                case 510 :
                    fVar = fVar / 1000.0; /* Ohm -> kOhm */
            }
			            
			CalProtocol_Attributes[entryCount] = method_format_string(1, tnr, buf, fVar);
			CalProtocol_Values[entryCount] = method_format_string(2, tnr, buf, fVar);

			proto_text += CalProtocol_Attributes[entryCount];
				
			for(m = strlen(CalProtocol_Attributes[entryCount]); m<30; m++)
				proto_text += " ";

			proto_text += CalProtocol_Values[entryCount];
			proto_text += "\n";
			
			entryCount++;
			
			i = i + bcnt;
        }
		
		return proto_text;		
    }
}

VARIABLE f
{
    LABEL "";
    HELP "";
    CLASS LOCAL;
    TYPE FLOAT {}
}
VARIABLE tnr2txtMapping
{
    LABEL "";
    HELP "";
    CLASS LOCAL;
    TYPE ENUMERATED {TNR2TXT}
}
VARIABLE tnr2valMapping
{
    LABEL "";
    HELP "";
    CLASS LOCAL;
    TYPE ENUMERATED {TNR2VAL}
}
VARIABLE calnr2txtMapping
{
    LABEL "";
    HELP "";
    CLASS LOCAL;
    TYPE ENUMERATED {CALMODE2TXT}
}
METHOD method_format_string(unsigned int mappingType, int number, DD_STRING buffer, float fVar) {
    LABEL    "";
    CLASS INPUT;
    TYPE DD_STRING;
    DEFINITION
    {
        DD_STRING s, dct_id, buf;		
		int ret;
        char pz[2];
		char sz[512];

        pz[0] = '%';
        pz[1] = '\0';
		ret = 0;

		f = fVar;
		buf = buffer;
				
		switch(mappingType) {
			
			case 1: 
				ret = get_enum_string(tnr2txtMapping, number, s);
				break;
			case 2:
				ret = get_enum_string(tnr2valMapping, number, s);
				break;
			case 3:
				ret = get_enum_string(calnr2txtMapping, number, s);
				break;
		}
		
		if (s == "{buf}") 
			s = "%[s]{buf}";
						
		if (0 == ret ) {
							
				return /*number + " " + */ BUILD_MESSAGE(s);			
		}
		return "missing: " + number;
    }
}
//-------------------------------------------------------------------------------------------------
//    MENU
//-------------------------------------------------------------------------------------------------

