/* ----------------------------------------------------------------------

 FILE_NAME          di1.inc



 FUNCTIONAL_MODULE_DESCRIPTION

 Konfiguration der Funktionsblcke

 ---------------------------------------------------------------------- */

/*
 ----------------------------------------------------------------------
 Includes
 ----------------------------------------------------------------------
 */

/*
 ----------------------------------------------------------------------
 Defines
 ----------------------------------------------------------------------
 */

/*
 ------------------------------------------------------
 ###   #####   ###
 #   #    #    #  #
 #   #    #       #
 #####    #       #
 #   #  #####     #
 ------------------------------------------------------
 */
/*
 ####################################
 Configuration vom DI
 ####################################
 */
MENU output_di1_window
{
    LABEL [LABEL_DI1];
    ITEMS
    {
        conf_out_di1_ident,
        conf_out_di1_process,
        conf_out_di1_alarm,
        conf_out_di1_batch
    }
}

/* TAG... */
MENU conf_out_di1_ident
{
    LABEL TXT_IDENTIFICATION;
    STYLE GROUP;
    ITEMS
    {
        func1_DI_TAG_DESC,
        func1_DI_STRATEGY,
        func1_DI_ST_REV
    }
}

/* OUT,CHANNEL... */
MENU conf_out_di1_process
{
    LABEL TXT_PROCESS;
    STYLE GROUP;
    ITEMS
    {
        func1_DI_CHANNEL,
        func1_DI_INVERT
    }
}

/* Alarm, limits... */
MENU conf_out_di1_alarm
{
    LABEL TXT_FB_FAIL;
    STYLE GROUP;
    ITEMS
    {
        func1_DI_FSAFE_TYPE,
        func1_DI_FSAFE_VAL_D
    }
}

/* Batch.. */
MENU conf_out_di1_batch
{
    LABEL "Batch";
    STYLE GROUP;
    ITEMS
    {
        func1_DI_BATCH_Batch_ID,
        func1_DI_BATCH_Rup,
        func1_DI_BATCH_Operation,
        func1_DI_BATCH_Phase
    }
}

/* Simulation.. */
MENU conf_out_di1_simu
{
    LABEL "Simulation";
    STYLE GROUP;
    ITEMS
    {
        func1_DI_TARGET_MODE,
        func1_DI_MODE_BLK_Actual,
        func1_DI_SIMULATE_Enabled,
        func1_DI_SIMULATE_Value,
        func1_DI_SIMULATE_Status_Condensed
    }
}

/*
 ####################################
 Diagnose vom DI
 ####################################
 */
MENU output_di1_diag_window
{
    LABEL "Output DI1";
    STYLE WINDOW;
    ITEMS
    {
        diag_out_di1_alarm
    }
}

/* Alarms... */
MENU diag_out_di1_alarm
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func1_DI_ALARM_SUM_Current,
        func1_DI_ALARM_SUM_Unacknowledged,
        func1_DI_ALARM_SUM_Unreported,
        func1_DI_ALARM_SUM_Disabled
    }
}

/*
 ####################################
 Function Block : Online-Windows
 ####################################
 */

/* Messwerte */
MENU display_out_func1_DI
{
    LABEL [LABEL_DI1];
    ITEMS
    {
        meas_type (HIDDEN),
        phys_FEATURE_Enabled (HIDDEN),

        out_di1_value (READ_ONLY),
        ROWBREAK,
        out_di1_simu (READ_ONLY),
        ROWBREAK,
        out_di1_alarms (READ_ONLY)
    }
}
MENU func1_DI_ovw
{
    LABEL [LABEL_DI1];
	STYLE GROUP;
    ITEMS 
	{
		meas_type (HIDDEN),		        
		phys_FEATURE_Enabled (HIDDEN),
		
		func1_DI_OUT_D_Value,
        ROWBREAK,
        func1_DI_OUT_D_Status_Condensed
    }
}
MENU out_di1_value
{
    LABEL [PI_OUT_Value_label];
    STYLE GROUP;
    ITEMS
    {
		func1_DI_CHANNEL (READ_ONLY),
        func1_DI_OUT_D_Value,
        func1_DI_OUT_D_Status_Condensed
    }
}
MENU out_di1_simu
{
    LABEL [simulation];
    STYLE GROUP;
    ITEMS
    {
        func1_DI_MODE_BLK_Actual,
        ROWBREAK ,
        func1_DI_SIMULATE_Enabled (READ_ONLY)
    }
}
MENU out_di1_alarms
{
    LABEL [alarms];
    STYLE GROUP;
    ITEMS
    {
        func1_DI_ALARM_SUM_Current
    }
}

MENU alarm_sum_func1_DI
{
    LABEL [PI_ALARM_SUM_label];
    ITEMS
    {
        func1_DI_ALARM_SUM_Current,
        func1_DI_ALARM_SUM_Unacknowledged,
        func1_DI_ALARM_SUM_Unreported,
        func1_DI_ALARM_SUM_Disabled
    }
}

MENU overview_di1_alarms
{
    LABEL [LABEL_DI1];
    STYLE GROUP;
    ITEMS
    {
        func1_DI_ALARM_SUM_Current
		/*,
        COLUMNBREAK,
        func1_DI_ALARM_SUM_Unacknowledged,
        COLUMNBREAK,
        func1_DI_ALARM_SUM_Unreported,
        COLUMNBREAK,
        func1_DI_ALARM_SUM_Disabled
		*/
    }
}

MENU simulation_window_di1
{
    LABEL [LABEL_DI1];
    STYLE WINDOW;
    ITEMS
    {
        phys_FEATURE_Enabled (HIDDEN),
		
		func1_DI_CHANNEL (READ_ONLY),
        simulation_wnd_di1_input,
        simulation_wnd_di1_output
    }
}


MENU simulation_wnd_di1_input
{
    LABEL TXT_AI_SIM_INPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_DI_SIMULATE_Enabled,
        func1_DI_SIMULATE_Value,
        func1_DI_SIMULATE_Status_Condensed
    }
}

MENU simulation_wnd_di1_output
{
    LABEL TXT_AI_SIM_OUTPUT;
    STYLE GROUP;
    ITEMS
    {
        func1_DI_TARGET_MODE,
        func1_DI_MODE_BLK_Actual,
        func1_DI_OUT_D_Value,
        func1_DI_OUT_D_Status_Condensed
    }
}
