
#define MODULE_LIST									\
    { 0,    "empty""|de|leer"   },                  \
    IF(phys_module_configuration_ex == 0) 		\
    {														\
        { 3,	"PH 3400-031"			},				\
        { 4,	"PHU 3400-110" 		},				\
        { 5,	"COND 3400-041"   	},				\
        { 6,	"CONDI 3400-051"		},				\
        { 7,	"OXY 3400-061"	   	},				\
        { 8,	"OUT 3400-071"	   	},				\
        { 9,	"PID 3400-121"	   	},				\
        { 10,	"OXY 3400-062"	   	},				\
        { 11,	"OXY 3400-063"	   	},				\
        { 12,	"PH 3400-032"	   	},				\
        { 13,	"PH 3400-033"	   	},				\
        { 14,	"COMPA 3400-081" 		},				\
        { 18,	"CO2 3400-130" 		},				\
        { 19,	"PH 3400-035"	 		},				\
        { 20,	"OXY 3400-065" 		},				\
        { 21,	"OXY 3400-066" 		},				\
        { 23,	"COMFF 3400-085" 		},				\
        { 25,	"empty""|de|leer"		},				\
        { 26,	"OXY 3400-067" 		},				\
    { 27,	"MS 3400-160" 	   	},			\
    { 28,	"FIU 3400-140/141"	},			\
    { 30,	"Memosens PH"			},			\
    { 31,	"Memosens OXY"			},			\
    { 32,	"Memosens COND"		},			\
    { 33,	"Memosens CONDI"		},			\
    { 34,	"Memosens ORP"			}			\
    { 40,	"LDO 3400-170"			} 			\
    }														\
    ELSE													\
    {														\
        { 3,	"PH 3400X-031"			},				\
        { 4,	"PHU 3400X-110" 		},				\
        { 5,	"COND 3400X-041"  	},				\
        { 6,	"CONDI 3400X-051"		},				\
        { 7,	"OXY 3400X-061"		},				\
        { 8,	"OUT 3400X-071"		},				\
        { 9,	"PID 3400X-121"		},				\
        { 10,	"OXY 3400X-062"		},				\
        { 11,	"OXY 3400X-063"		},				\
        { 12,	"PH 3400X-032"	   	},				\
        { 13,	"PH 3400X-033"	   	},				\
        { 14,	"COMPA 3400X-081" 	},				\
        { 18,	"CO2 3400X-130" 		},				\
        { 19,	"PH 3400X-035"	 		},				\
        { 20,	"OXY 3400X-065" 		},				\
        { 21,	"OXY 3400X-066" 		},				\
        { 23,	"COMFF 3400X-085"		},				\
        { 25,	"empty""|de|leer"		},				\
        { 26,	"OXY 3400X-067" 		},				\
    { 27,	"MS 3400X-160"	   	},			\
    { 28,	"FIU 3400X-140/141"	},			\
    { 30,	"Memosens PH"			},			\
    { 31,	"Memosens OXY"			},			\
    { 32,	"Memosens COND"		},			\
    { 33,	"Memosens CONDI"		},			\
    { 34,	"Memosens ORP"			} 			\
    { 40,	"LDO 3400-170"			} 			\
    }


#define CONFIGURATION_BASED_MODULE_LIST																											\
        DEFAULT_VALUE    0;																																\
                                { 0, "Off""|de|Aus"												},														\
        IF( (phys_module_configuration_module_at_addr_4 != 0) && (phys_module_configuration_module_at_addr_4 != 14) )		\
        {																																						\
            IF(phys_module_configuration_ex == 0) 																									\
            {																																					\
                SELECT( phys_module_configuration_module_at_addr_4 )																			\
                {																																				\
                    CASE 3  :	{ 4, "PH 3400-031"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 4  :	{ 4, "PHU 3400-110"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 5  :	{ 4, "COND 3400-041"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 6  :	{ 4, "CONDI 3400-051"		+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 7  :	{ 4, "OXY 3400-061"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 10 :	{ 4, "OXY 3400-062"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 11 :	{ 4, "OXY 3400-063"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 12 :	{ 4, "PH 3400-032"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 13 :	{ 4, "PH 3400-033"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 18 :	{ 4, "CO2 3400-130"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 19 :	{ 4, "PH 3400-035"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 20 :	{ 4, "OXY 3400-065"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 21 :	{ 4, "OXY 3400-066"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 23 :	{ 4, "COMFF 3400-085"		+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 26 :	{ 4, "OXY 3400-067"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                CASE 27 :	{ 4, "MS 3400-160"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 28 :	{ 4, "FIU 3400-140/141"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 30 :	{ 4, "Memosens PH"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 31 :	{ 4, "Memosens OXY"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 32 :	{ 4, "Memosens COND"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 33 :	{ 4, "Memosens CONDI"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 34 :	{ 4, "Memosens ORP"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
				CASE 40 :	{ 4, "LDO 3400-170"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                }																																				\
            }																																					\
            ELSE																																				\
            {																																					\
                SELECT( phys_module_configuration_module_at_addr_4 )																			\
                {																																				\
                    CASE 3  :	{ 4, "PH 3400X-031"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 4  :	{ 4, "PHU 3400X-110"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 5  :	{ 4, "COND 3400X-041"		+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 6  :	{ 4, "CONDI 3400X-051"		+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 7  :	{ 4, "OXY 3400X-061"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 10 :	{ 4, "OXY 3400X-062"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 11 :	{ 4, "OXY 3400X-063"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 12 :	{ 4, "PH 3400X-032"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 13 :	{ 4, "PH 3400X-033"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 18 :	{ 4, "CO2 3400X-130"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 19 :	{ 4, "PH 3400X-035"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 20 :	{ 4, "OXY 3400X-065"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 21 :	{ 4, "OXY 3400X-066"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 23 :	{ 4, "COMFF 3400X-085"		+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                    CASE 26 :	{ 4, "OXY 3400X-067"			+ " in Slot 1" "|de| an Steckplatz 1"	},									\
                CASE 27 :	{ 4, "MS 3400X-160"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 28 :	{ 4, "FIU 3400X-140/141"	+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 30 :	{ 4, "Memosens PH"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 31 :	{ 4, "Memosens OXY"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 32 :	{ 4, "Memosens COND"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 33 :	{ 4, "Memosens CONDI"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                CASE 34 :	{ 4, "Memosens ORP"			+ " in Slot 1" "|de| an Steckplatz 1"	},								\
				CASE 40 :	{ 4, "LDO 3400-170"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                }																																				\
            }																																					\
        }																																						\
        IF( (phys_module_configuration_module_at_addr_5 != 0) && (phys_module_configuration_module_at_addr_5 != 14) )		\
        {																																						\
            IF(phys_module_configuration_ex == 0) 																									\
            {																																					\
                SELECT( phys_module_configuration_module_at_addr_5 )																			\
                {																																				\
                    CASE 3  :	{ 5, "PH 3400-031"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 4  :	{ 5, "PHU 3400-110"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 5  :	{ 5, "COND 3400-041"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 6  :	{ 5, "CONDI 3400-051"		+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 7  :	{ 5, "OXY 3400-061"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 10 :	{ 5, "OXY 3400-062"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 11 :	{ 5, "OXY 3400-063"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 12 :	{ 5, "PH 3400-032"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 13 :	{ 5, "PH 3400-033"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 18 :	{ 5, "CO2 3400-130"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 19 :	{ 5, "PH 3400-035"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 20 :	{ 5, "OXY 3400-065"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 21 :	{ 5, "OXY 3400-066"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 23 :	{ 5, "COMFF 3400-085"		+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 26 :	{ 5, "OXY 3400-067"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                CASE 27 :	{ 5, "MS 3400-160"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 28 :	{ 5, "FIU 3400-140/141"		+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 30 :	{ 5, "Memosens PH"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 31 :	{ 5, "Memosens OXY"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 32 :	{ 5, "Memosens COND"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 33 :	{ 5, "Memosens CONDI"		+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 34 :	{ 5, "Memosens ORP"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
				CASE 40 :	{ 4, "LDO 3400-170"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                }																																				\
            }																																					\
            ELSE																																				\
            {																																					\
                SELECT( phys_module_configuration_module_at_addr_5 )																			\
                {																																				\
                    CASE 3  :	{ 5, "PH 3400X-031"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 4  :	{ 5, "PHU 3400X-110"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 5  :	{ 5, "COND 3400X-041"		+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 6  :	{ 5, "CONDI 3400X-051"		+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 7  :	{ 5, "OXY 3400X-061"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 10 :	{ 5, "OXY 3400X-062"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 11 :	{ 5, "OXY 3400X-063"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 12 :	{ 5, "PH 3400X-032"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 13 :	{ 5, "PH 3400X-033"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 18 :	{ 5, "CO2 3400X-130"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 19 :	{ 5, "PH 3400X-035"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 20 :	{ 5, "OXY 3400X-065"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 21 :	{ 5, "OXY 3400X-066"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 23 :	{ 5, "COMFF 3400X-085"		+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                    CASE 26 :	{ 5, "OXY 3400X-067"			+ " in Slot 2" "|de| an Steckplatz 2"	},									\
                CASE 27 :	{ 5, "MS 3400X-160"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 28 :	{ 5, "FIU 3400X-140/141"	+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 30 :	{ 5, "Memosens PH"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 31 :	{ 5, "Memosens OXY"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 32 :	{ 5, "Memosens COND"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 33 :	{ 5, "Memosens CONDI"		+ " in Slot 2" "|de| an Steckplatz 2"	},								\
                CASE 34 :	{ 5, "Memosens ORP"			+ " in Slot 2" "|de| an Steckplatz 2"	},								\
				CASE 40 :	{ 4, "LDO 3400-170"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                }																																				\
            }																																					\
        }																																						\
        IF( (phys_module_configuration_module_at_addr_6 != 0) && (phys_module_configuration_module_at_addr_6 != 14) )		\
        {																																						\
            IF(phys_module_configuration_ex == 0) 																									\
            {																																					\
                SELECT( phys_module_configuration_module_at_addr_6 )																			\
                {																																				\
                    CASE 3  :	{ 6, "PH 3400-031"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 4  :	{ 6, "PHU 3400-110"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 5  :	{ 6, "COND 3400-041"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 6  :	{ 6, "CONDI 3400-051"		+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 7  :	{ 6, "OXY 3400-061"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 10 :	{ 6, "OXY 3400-062"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 11 :	{ 6, "OXY 3400-063"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 12 :	{ 6, "PH 3400-032"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 13 :	{ 6, "PH 3400-033"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 18 :	{ 6, "CO2 3400-130"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 19 :	{ 6, "PH 3400-035"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 20 :	{ 6, "OXY 3400-065"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 21 :	{ 6, "OXY 3400-066"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 23 :	{ 6, "COMFF 3400-085"		+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 26 :	{ 6, "OXY 3400-067"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                CASE 27 :	{ 6, "MS 3400-160"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 28 :	{ 6, "FIU 3400-140/141"		+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 30 :	{ 6, "Memosens PH"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 31 :	{ 6, "Memosens OXY"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 32 :	{ 6, "Memosens COND"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 33 :	{ 6, "Memosens CONDI"		+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 34 :	{ 6, "Memosens ORP"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
				CASE 40 :	{ 4, "LDO 3400-170"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                }																																				\
            }																																					\
            ELSE																																				\
            {																																					\
                SELECT( phys_module_configuration_module_at_addr_6 )																			\
                {																																				\
                    CASE 3  :	{ 6, "PH 3400X-031"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 4  :	{ 6, "PHU 3400X-110"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 5  :	{ 6, "COND 3400X-041"		+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 6  :	{ 6, "CONDI 3400X-051"		+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 7  :	{ 6, "OXY 3400X-061"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 10 :	{ 6, "OXY 3400X-062"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 11 :	{ 6, "OXY 3400X-063"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 12 :	{ 6, "PH 3400X-032"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 13 :	{ 6, "PH 3400X-033"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 18 :	{ 6, "CO2 3400X-130"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 19 :	{ 6, "PH 3400X-035"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 20 :	{ 6, "OXY 3400X-065"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 21 :	{ 6, "OXY 3400X-066"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 23 :	{ 6, "COMFF 3400X-085"		+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                    CASE 26 :	{ 6, "OXY 3400X-067"			+ " in Slot 3" "|de| an Steckplatz 3"	},									\
                CASE 27 :	{ 6, "MS 3400X-160"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 28 :	{ 6, "FIU 3400X-140/141"	+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 30 :	{ 6, "Memosens PH"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 31 :	{ 6, "Memosens OXY"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 32 :	{ 6, "Memosens COND"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 33 :	{ 6, "Memosens CONDI"		+ " in Slot 3" "|de| an Steckplatz 3"	},								\
                CASE 34 :	{ 6, "Memosens ORP"			+ " in Slot 3" "|de| an Steckplatz 3"	},								\
				CASE 40 :	{ 4, "LDO 3400-170"		+ " in Slot 1" "|de| an Steckplatz 1"	},								\
                }																																				\
            }																																					\
        }


#define VAR_LIST_PH												\
    IF( phys_module_configuration_sw_ver < 0x80 )		\
    {																	\
        { 0,	"pH"		"|de|pH"		},							\
        { 1,	"ORP"		"|de|ORP"	},							\
        { 2,	"C"		"|de|C"		},							\
        { 4,	"mV"		"|de|mV"		},							\
        { 5,	"rH"		"|de|rH"		},							\
        { 6,	"MOhm"	"|de|MOhm"	},							\
        { 7,	"kOhm"	"|de|kOhm"	},							\
        { 9,	"F"		"|de|F"		},							\
        { 10,	"Zero"	"|de|Npkt"	},							\
        { 11,	"Slope"	"|de|Sth"	},							\
        { 12,	"pH'"		"|de|pH'"	},							\
        { 13,	"CTime"	"|de|CTime"	},							\
        { 14,	"Wear"	"|de|Verschleiss"	}					\
    }																	\
    ELSE																\
    {																	\
        { 0,	"pH"		"|de|pH"		},							\
        { 1,	"ORP"		"|de|ORP"	},							\
        { 2,	"C"		"|de|C"		},							\
        { 4,	"mV"		"|de|mV"		},							\
        { 5,	"rH"		"|de|rH"		},							\
        { 6,	"MOhm"	"|de|MOhm"	},							\
        { 7,	"kOhm"	"|de|kOhm"	},							\
        { 8,	"F"		"|de|F"		},							\
        { 9,	"Zero"	"|de|Npkt"	},							\
        { 10,	"Slope"	"|de|Sth"	},							\
        { 11,	"pH'"		"|de|pH'"	},							\
        { 12,	"CTime"	"|de|CTime"	},							\
        { 13,	"Wear"	"|de|Verschleiss"	},					\
        { 14,	"LTime"	"|de|LTime / DLI"	},					\
        { 15,	"TTM"		"|de|TTM"	}							\
    }

#define VAR_LIST_COND								\
        { 0,	"S/cm"	"|de|S/cm"	},				\
        { 1,	"%"		"|de|Gew%"	},				\
        { 2,	"C"		"|de|C"		},				\
        { 4,	"g/kg"	"|de|g/kg"	},				\
        { 5,	"Ohm cm"	"|de|Ohm cm"},				\
        { 6,	"F"		"|de|F"		},				\
        { 7,	"Cell"	"|de|Cell"	},				\
        { 8,	"USP"		"|de|USP"	},				\
        { 9,	"Sigma'"	"|de|Sigma'"	}

#define VAR_LIST_CONDI								\
        { 0,	"S/cm"	"|de|S/cm"	},				\
        { 1,	"%"		"|de|Gew%"	},				\
        { 2,	"C"		"|de|C"		},				\
        { 4,	"g/kg"	"|de|g/kg"	},				\
        { 5,	"Ohm cm"	"|de|Ohm cm"},				\
        { 6,	"F"		"|de|F"		},				\
        { 7,	"Zero"	"|de|Npkt"	},				\
        { 8,	"Cell"	"|de|Cell"	},				\
        { 9,	"Sigma'"	"|de|Sigma'"	}

#ifdef DO3_UNICAL
  #define VAR_LIST_OXY						  					\
    IF( phys_module_configuration_sw_ver < 0x70 )		\
    {																	\
        { 0,	"%Air"	"|de|%Air"	},							\
        { 1,	"%O2"		"|de|%O2"	},							\
        { 2,	"C"		"|de|C"		},							\
        { 3,	"mbar"	"|de|mbar"	},							\
        { 4,	"nA"		"|de|nA"		},							\
        { 7,	"mg/l"	"|de|mg/l"	},							\
        { 8,	"ppm"		"|de|ppm"	},							\
        { 9,	"mbar"	"|de|mbar"	},							\
        { 10,	"F"		"|de|F"		},							\
        { 11,	"Vol%"	"|de|Vol%"	},							\
        { 12,	"ppm"		"|de|ppm"	},							\
        { 13,	"Zero"	"|de|Npkt"	},							\
        { 14,	"Slope"	"|de|Sth"	},							\
    }																	\
    ELSE																\
    {																	\
        { 0,	"%Air"	"|de|%Air"	},							\
        { 1,	"%O2"		"|de|%O2"	},							\
        { 2,	"C"		"|de|C"		},							\
        { 3,	"mbar"	"|de|mbar"	},							\
        { 4,	"nA"		"|de|nA"		},							\
        { 5,	"CTime"	"|de|CTime"	},							\
        { 6,	"mmHg"	"|de|mmHg"	},							\
        { 7,	"mg/l"	"|de|mg/l"	},							\
        { 8,	"ppm"		"|de|ppm"	},							\
        { 9,	"mbar"	"|de|mbar"	},							\
        { 10,	"F"		"|de|F"		},							\
        { 11,	"Vol%"	"|de|Vol%"	},							\
        { 12,	"Wear"	"|de|Verschleiss"	},					\
        { 13,	"Zero"	"|de|Npkt"	},							\
        { 14,	"Slope"	"|de|Sth"	},							\
        { 15,	"I-Inp"	"|de|I-Eing" }							\
    }
#else
  #define VAR_LIST_OXY								\
        { 0,	"%Air"	"|de|%Air"	},				\
        { 1,	"%O2"		"|de|%O2"	},				\
        { 2,	"C"		"|de|C"		},				\
        { 3,	"mbar"	"|de|mbar"	},				\
        { 4,	"nA"		"|de|nA"		},				\
        { 5,	"kOhm"	"|de|kOhm"	},				\
        { 7,	"mg/l"	"|de|mg/l"	},				\
        { 8,	"ppm"		"|de|ppm"	},				\
        { 9,	"mbar"	"|de|mbar"	},				\
        { 10,	"F"		"|de|F"		},				\
        { 11,	"Vol%"	"|de|Vol%"	},				\
        { 12,	"ppm"		"|de|ppm"	},				\
        { 13,	"Zero"	"|de|Npkt"	},				\
        { 14,	"Slope"	"|de|Sth"	},				\
        { 15,	"Pol"		"|de|Pol"	}
#endif


#ifdef DO3_UNICAL
#define VAR_LIST_LDO						  					\
    IF( phys_module_configuration_sw_ver < 0x70 )		\
    {																	\
        { 0,	"%Air"	"|de|%Air"	},							\
        { 1,	"%O2"		"|de|%O2"	},							\
        { 2,	"C"		"|de|C"		},							\
        { 3,	"mbar"	"|de|mbar"	},							\
        { 4,	"nA"		"|de|nA"		},							\
        { 7,	"mg/l"	"|de|mg/l"	},							\
        { 8,	"ppm"		"|de|ppm"	},							\
        { 9,	"mbar"	"|de|mbar"	},							\
        { 10,	"F"		"|de|F"		},							\
        { 11,	"Vol%"	"|de|Vol%"	},							\
        { 12,	"ppm"		"|de|ppm"	},							\
        { 13,	"Zero"	"|de|Npkt"	},							\
        { 14,	"Slope"	"|de|Sth"	},							\
    }																	\
    ELSE																\
    {																	\
        { 0,	"%Air"	"|de|%Air"	},							\
        { 1,	"%O2"		"|de|%O2"	},							\
        { 2,	"C"		"|de|C"		},							\
        { 3,	"mbar"	"|de|mbar"	},							\
        { 4,	"nA"		"|de|nA"		},							\
        { 5,	"CTime"	"|de|CTime"	},							\
        { 6,	"mmHg"	"|de|mmHg"	},							\
        { 7,	"mg/l"	"|de|mg/l"	},							\
        { 8,	"ppm"		"|de|ppm"	},							\
        { 9,	"p'"	"|de|p*"	},							\
        { 10,	"F"		"|de|F"		},							\
        { 11,	"Vol%"	"|de|Vol%"	},							\
        { 12,	"Wear"	"|de|Verschleiss"	},					\
        { 13,	"Zero"	"|de|Npkt"	},							\
        { 14,	"Slope"	"|de|Sth"	},							\
        { 15,	"I-Inp"	"|de|I-Eing" }							\
    }
#else
#define VAR_LIST_LDO								            \
        { 0,	"%Air"	"|de|%Air"	},							\
        { 1,	"%O2"		"|de|%O2"	},						\
        { 2,	"C"		"|de|C"		},					\
        { 3,	"mbar"	"|de|mbar"	},							\
        { 4,	"nA"		"|de|nA"		},					\
        { 5,	"CTime"	"|de|CTime"	},							\
        { 6,	"mmHg"	"|de|mmHg"	},							\
        { 7,	"mg/l"	"|de|mg/l"	},							\
        { 8,	"ppm"		"|de|ppm"	},						\
        { 9,	"p'"	"|de|p*"	},							\
        { 10,	"F"		"|de|F"		},				    \
        { 11,	"Vol%"	"|de|Vol%"	},							\
        { 12,	"Wear"	"|de|Verschleiss"	},					\
        { 13,	"Zero"	"|de|Npkt"	},							\
        { 14,	"Slope"	"|de|Sth"	},							\
        { 15,	"mA"		"|de|mA"		},							

#endif

#define VAR_LIST_CO2							  		\
        { 0,	"%"		"|de|%"		},				\
        { 1,	"mg/l"	"|de|mg/l"	},				\
        { 2,	"C"		"|de|C"		},				\
        { 4,	"p'"		"|de|p'"		},				\
        { 5,	"MOhm"	"|de|MOhm"	},				\
        { 6,	"kOhm"	"|de|kOhm"	},				\
        { 7,	"mmHg"	"|de|mmHg"	},				\
        { 8,	"F"		"|de|F"		},				\
        { 9,	"Zero"	"|de|Npkt"	},				\
        { 10,	"Slope"	"|de|Sth"	},				\
        { 11,	"CTime"	"|de|CTime"	},				\
        { 12,	"Wear"	"|de|Verschleiss"	}

#define VAR_LIST_ORP							  		\
        { 0,	"ORP"		"|de|ORP"	},				\
        { 1,	"F"		"|de|F"		},				\
        { 2,	"C"		"|de|C"		},				\
        { 4,	"CTime"	"|de|CTime"	}


#define MEAS_LIST_MODULES			  												\
        CASE 3  :	VAR_LIST_PH					/* 031 - pH			*/			\
        CASE 4  :	VAR_LIST_PH					/* 110 - PHU		*/			\
        CASE 5  :	VAR_LIST_COND				/* 041 - Cond	   */			\
        CASE 6  :	VAR_LIST_CONDI				/* 051 - CondI	   */			\
        CASE 7  :	VAR_LIST_OXY				/* 061 - Oxy	   */			\
        CASE 10 :	VAR_LIST_OXY				/* 062 - Oxy	   */			\
        CASE 11 :	VAR_LIST_OXY				/* 063 - Oxy	   */			\
        CASE 12 :	VAR_LIST_PH					/* 032 - PH/ISFET */			\
        CASE 13 :	VAR_LIST_PH					/* 033 - PH/DS	   */			\
        CASE 14 :									/* 081 - COMPA    */			\
        CASE 18 :	VAR_LIST_CO2				/* 130 - CO2		*/			\
        CASE 19 :	VAR_LIST_PH					/* 035 - PH			*/			\
        CASE 20 :	VAR_LIST_OXY				/* 065 - OXY		*/			\
        CASE 21 :	VAR_LIST_OXY				/* 066 - OXY		*/			\
        CASE 23 :									/* 085 - COMFF    */			\
        CASE 26 :	VAR_LIST_OXY				/* 067 - OXY		*/			\
    CASE 27 :								/* 160 - MS    	*/			\
    CASE 28 :								/* 140/141 - FIU  */			\
    CASE 30 :	VAR_LIST_PH				/* Memosens PH		*/			\
    CASE 31 :	VAR_LIST_OXY			/* Memosens OXY	*/			\
    CASE 32 :	VAR_LIST_COND			/* Memosens COND	*/			\
    CASE 33 :	VAR_LIST_CONDI			/* Memosens CONDI	*/			\
    CASE 34 :	VAR_LIST_ORP			/* Memosens ORP	*/              \
	CASE 40 :	VAR_LIST_LDO			/* 170 - LDO	*/


#define CONFIGURATION_BASED_PROCESS_VALUE_LIST												\
        SELECT( SELECTED_MODULE_ADDR )															\
        {																									\
            CASE 0:  { 0,	"Off""|de|Aus"	}												  		\
            CASE 4: 	SELECT ( phys_module_configuration_module_at_addr_4 )				\
                        {																					\
                            MEAS_LIST_MODULES															\
                        }																					\
            CASE 5: 	SELECT ( phys_module_configuration_module_at_addr_5 )				\
                        {																					\
                            MEAS_LIST_MODULES															\
                        }																					\
            CASE 6: 	SELECT ( phys_module_configuration_module_at_addr_6 )				\
                        {																					\
                            MEAS_LIST_MODULES															\
                        }																					\
        }

//--- neu ---------------------------------------------------------

#define DISPLAY_FORMAT_CALPRD_TRUE_VAL(cal_prd_unit)		\
    SELECT ( cal_prd_unit )											\
    {																		\
        CASE 1422 :	 ".2f";	/* pH		*/							\
        CASE 1552 :	 ".0f";	/* uS/cm */							\
        CASE 1342 :	 ".1f";	/* %		*/							\
    }


#define MODULE_BASED_CALPRD_MODE_LIST(module_id)			\
    IF(   ( module_id ==  7 ) 		/* 061 - Oxy	   */		\
        || ( module_id == 10 ) 		/* 062 - Oxy	   */		\
        || ( module_id == 11 ) 		/* 063 - Oxy	   */		\
        || ( module_id == 20 ) 		/* 065 - OXY		*/		\
        || ( module_id == 21 ) 		/* 066 - OXY		*/		\
        || ( module_id == 26 )  	/* 067 - OXY		*/		\
        || ( module_id == 40 ) )	/* 170 - LDO		*/		\
    {																		\
        { 0, "Saturation|de|Sttigung"				},			\
        { 1, "Concentration|de|Konzentration"  	}			\
    }																		\
    ELSE																	\
    {																		\
        { 0, "Liquid|de|In Flssigkeit"	}						\
    }


#define MODULE_BASED_CALPRD_MODE_VALIDITY(module_id)		\
    IF(   ( module_id ==  7 ) 		/* 061 - Oxy	   */		\
        || ( module_id == 10 ) 		/* 062 - Oxy	   */		\
        || ( module_id == 11 ) 		/* 063 - Oxy	   */		\
        || ( module_id == 20 ) 		/* 065 - OXY		*/		\
        || ( module_id == 21 ) 		/* 066 - OXY		*/		\
        || ( module_id == 26 )  	/* 067 - OXY		*/		\
		|| ( module_id == 40 ) )	/* 170 - LDO		*/		\
    {																		\
        TRUE;																\
    }																		\
    ELSE																	\
    {																		\
        FALSE;															\
    }


METHOD method_get_prdcal_unit( int TB_channel )
{
    LABEL	"Get prdcal unit";
    CLASS	INPUT;
    DEFINITION
    {
        int module_id, calprd_mode, unit;

        switch( TB_channel )
        {
            case TB_CHANNEL_1:	module_id 	= func1_AI_local_module_id;
                                        calprd_mode	= func1_AI_calprd_mode;
                                        break;
            case TB_CHANNEL_2:	module_id	= func5_AI_local_module_id;
                                        calprd_mode	= func5_AI_calprd_mode;
                                        break;
        }

        switch( module_id )
        {
            case 3  :	// 031 - pH
            case 4  :	// 110 - PHU
            case 12 :	// 032 - PH/ISFET
            case 13 :	// 033 - PH/DS
            case 19 : 	// 035 - PH
                             unit = 1422;
                             break;
            case 5  :	// 041 - Cond
            case 6  : 	// 051 - CondI
                             unit = 1552;
                             break;
            case 7  :	// 061 - Oxy
            case 10 :	// 062 - Oxy
            case 11 :	// 063 - Oxy
            case 20 :	// 065 - OXY
            case 21 : 	// 066 - OXY
            case 26 : 	// 066 - OXY
                            if( calprd_mode == 0 )
                                unit = 1342;
                            else
                                unit = 1562;
                            break;

            case 18 : 	// 130 - CO2
                             unit = 1342;
                             break;
            case 14 : 	// 081 - COMPA
            case 23 : 	// 081 - COMFF
                            unit = 1997;
                            break;
			case 40 : 	// 170 - LDO
                unit = 1342;
                break;
        }

        switch( TB_channel )
        {
            case TB_CHANNEL_1:	func1_AI_local_calprd_unit = unit;	break;
            case TB_CHANNEL_2:	func5_AI_local_calprd_unit = unit;	break;
        }
    }
}


METHOD method_get_channel_mapping( int TB_channel )
{
    LABEL	"Get channel mapping";
    CLASS	INPUT;
    DEFINITION
    {
        ReadCommand(read_phys_module_configuration);

        switch( TB_channel )
        {
            case TB_CHANNEL_1:	ReadCommand(read_trans1_analysis_meas_info);
                                        func1_AI_local_module_adr = trans1_meas_info_module_adr;
                                        switch( func1_AI_local_module_adr )
                                        {
                                            case 0: func1_AI_local_module_id = 0;														  break;
                                            case 4: func1_AI_local_module_id = phys_module_configuration_module_at_addr_4;  break;
                                            case 5: func1_AI_local_module_id = phys_module_configuration_module_at_addr_5;  break;
                                            case 6: func1_AI_local_module_id = phys_module_configuration_module_at_addr_6;  break;
                                        }
                                        break;

            case TB_CHANNEL_2:	ReadCommand(read_trans5_analysis_meas_info);
                                        func5_AI_local_module_adr = trans5_meas_info_module_adr;
                                        switch( func5_AI_local_module_adr )
                                        {
                                            case 0: func5_AI_local_module_id = 0;															break;
                                            case 4: func5_AI_local_module_id = phys_module_configuration_module_at_addr_4;	break;
                                            case 5: func5_AI_local_module_id = phys_module_configuration_module_at_addr_5;	break;
                                            case 6: func5_AI_local_module_id = phys_module_configuration_module_at_addr_6;	break;
                                        }
                                        break;
        }
    }
}
