//******************************************************************************
//****	Communication Error Handling  ******************************************
//******************************************************************************

VARIABLE CommError_0000_009F
{
    LABEL		[comm_err_dp_error_reserved];
    HELP		[comm_err_dp_error_reserved_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00A0_00A0
{
    LABEL		[comm_err_dp_read_error];
    HELP		[comm_err_dp_read_error_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00A1_00A1
{
    LABEL		[comm_err_dp_write_error];
    HELP		[comm_err_dp_write_error_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00A2_00A2
{
    LABEL		[comm_err_dp_module_failure];
    HELP		[comm_err_dp_module_failure_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00A3_00A7
{
    LABEL		[comm_err_dp_application_reserved];
    HELP		[comm_err_dp_application_reserved_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00A8_00A8
{
    LABEL		[comm_err_dp_version_conflict];
    HELP		[comm_err_dp_version_conflict_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00A9_00A9
{
    LABEL		[comm_err_dp_feature_not_supported];
    HELP		[comm_err_dp_feature_not_supported_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00AA_00AF
{
    LABEL		[comm_err_dp_application_user_specific];
    HELP		[comm_err_dp_application_user_specific_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B0_00B0
{
    LABEL		[comm_err_dp_invalid_index];
    HELP		[comm_err_dp_invalid_index_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B1_00B1
{
    LABEL		[comm_err_dp_write_length_error];
    HELP		[comm_err_dp_write_length_error_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B2_00B2
{
    LABEL		[comm_err_dp_invalid_slot];
    HELP		[comm_err_dp_invalid_slot_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B3_00B3
{
    LABEL		[comm_err_dp_type_conflict];
    HELP		[comm_err_dp_type_conflict_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B4_00B4
{
    LABEL		[comm_err_dp_invalid_area];
    HELP		[comm_err_dp_invalid_area_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B5_00B5
{
    LABEL		[comm_err_dp_state_conflict];
    HELP		[comm_err_dp_state_conflict_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B6_00B6
{
    LABEL		[comm_err_dp_access_denied];
    HELP		[comm_err_dp_access_denied_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B7_00B7
{
    LABEL		[comm_err_dp_invalid_range];
    HELP		[comm_err_dp_invalid_range_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B8_00B8
{
    LABEL		[comm_err_dp_invalid_parameter];
    HELP		[comm_err_dp_invalid_parameter_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	0;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00B9_00B9
{
    LABEL		[comm_err_dp_invalid_type];
    HELP		[comm_err_dp_invalid_type_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00BA_00BF
{
    LABEL		[comm_err_dp_access_user_specific];
    HELP		[comm_err_dp_access_user_specific_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00C0_00C0
{
    LABEL		[comm_err_dp_read_constrain_conflict];
    HELP		[comm_err_dp_read_constrain_conflict_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00C1_00C1
{
    LABEL		[comm_err_dp_write_constrain_conflict];
    HELP		[comm_err_dp_write_constrain_conflict_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00C2_00C2
{
    LABEL		[comm_err_dp_resource_busy];
    HELP		[comm_err_dp_resource_busy_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00C3_00C3
{
    LABEL		[comm_err_dp_resource_unavailable];
    HELP		[comm_err_dp_resource_unavailable_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00C4_00C7
{
    LABEL		[comm_err_dp_resource_reserved];
    HELP		[comm_err_dp_resource_reserved_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00C8_00CF
{
    LABEL		[comm_err_dp_recource_user_specific];
    HELP		[comm_err_dp_recource_user_specific_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_00D0_00FF
{
    LABEL		[comm_err_dp_user_specific];
    HELP		[comm_err_dp_user_specific_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [ignore]	},
        { 1, [check]	}
    }
}

VARIABLE CommError_ShowIgnoredErrors
{
    LABEL		[comm_show_ignored_errors];
    HELP		[comm_show_ignored_errors_help];
    CLASS		LOCAL;
    TYPE		ENUMERATED (1)
    {
        DEFAULT_VALUE	1;
        { 0, [comm_show_ignored_errors_NOT_SHOW]	},
        { 1, [comm_show_ignored_errors_SHOW]		}
    }
}

VARIABLE CommError_Delay_Read
{
    LABEL		[comm_delay_read];
    HELP		[comm_delay_read_help];
    CLASS		LOCAL;
    TYPE		UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE	0;
    }
    CONSTANT_UNIT	[msec];
}

VARIABLE CommError_Delay_Write
{
    LABEL		[comm_delay_write];
    HELP		[comm_delay_write_help];
    CLASS		LOCAL;
    TYPE		UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE	0;
    }
    CONSTANT_UNIT	[msec];
}


MENU Menu_CommError
{
    LABEL	" ";
    ITEMS
    {
        CommError_0000_009F,			// DP Error Reserved
        CommError_00A0_00A0,			// Application: DP Read Error
        CommError_00A1_00A1,			// Application: DP Write Error
        CommError_00A2_00A2,			// Application: DP Module Failure
        CommError_00A3_00A7,			// Application: DP Application Reserved
        CommError_00A8_00A8,			// Application: DP Version Conflict
        CommError_00A9_00A9,			// Application: DP Feature Not Supported
        CommError_00AA_00AF,			// Application:	DP Application User Specific
        CommError_00B0_00B0,			// Access:	DP Invalid Index
        CommError_00B1_00B1,			// Access:	DP Write Length Erro
        CommError_00B2_00B2,			// Access:	DP Invalid Slot
        CommError_00B3_00B3,			// Access:	DP Type Conflict
        CommError_00B4_00B4,			// Access:	DP Invalid Area
        CommError_00B5_00B5,			// Access:	DP State Conflict
        CommError_00B6_00B6,			// Access:	DP Access Denied
        CommError_00B7_00B7,			// Access:	DP Invalid Range
        CommError_00B8_00B8,			// Access:	DP Invalid Parameter
        CommError_00B9_00B9,			// Access:	DP Invalid Type
        CommError_00BA_00BF,			// Access:	DP Access User Speci
        CommError_00C0_00C0,			// Resource:	DP Read Constrain Conflict
        CommError_00C1_00C1,			// Resource:	DP Write Constrain Conflict
        CommError_00C2_00C2,			// Resource:	DP Resource Busy
        CommError_00C3_00C3,			// Resource:	DP Resource unavailable
        CommError_00C4_00C7,			// Resource:	DP Resource Reserved
        CommError_00C8_00CF,			// Resource:	DP Recource User Specific
        CommError_00D0_00FF			// DP User Specific
    }
}

MENU Menu_CommError_Delay
{
    LABEL	" ";
    ITEMS
    {
        CommError_Delay_Read,
        CommError_Delay_Write
    }
}


MENU OfflineDialog_CommErrorHandling
{
    LABEL 	[menu_dialog_error_handling];
    ITEMS
    {
        Page_CommError_General,
        Page_CommError_Application,
        Page_CommError_Access,
        Page_CommError_Resource,
        Page_CommError_Other
    }
}

MENU Page_CommError_General
{
    LABEL 	[menu_dialog_general];
    ITEMS
    {
        CommError_Delay_Read,
        CommError_Delay_Write,
        CommError_ShowIgnoredErrors,
        CommError_DefaultHandling,
        CommError_CheckAllErrors,
        CommError_IgnoreAllErrors
    }
}

MENU Page_CommError_Application
{
    LABEL 	[menu_dialog_error_handling_application];
    ITEMS
    {
        CommError_00A0_00A0,	// Application: DP Read Error
        CommError_00A1_00A1,	// Application: DP Write Error
        CommError_00A2_00A2,	// Application: DP Module Failure
        CommError_00A3_00A7,	// Application: DP Application Reserved
        CommError_00A8_00A8,	// Application: DP Version Conflict
        CommError_00A9_00A9,	// Application: DP Feature Not Supported
        CommError_00AA_00AF	// Application:	DP Application User Specific
    }
}

MENU Page_CommError_Access
{
    LABEL 	[menu_dialog_error_handling_access];
    ITEMS
    {
        CommError_00B0_00B0,	// Access:	DP Invalid Index
        CommError_00B1_00B1,	// Access:	DP Write Length Error
        CommError_00B2_00B2,	// Access:	DP Invalid Slot
        CommError_00B3_00B3,	// Access:	DP Type Conflict
        CommError_00B4_00B4,	// Access:	DP Invalid Area
        CommError_00B5_00B5,	// Access:	DP State Conflict
        CommError_00B6_00B6,	// Access:	DP Access Denied
        CommError_00B7_00B7,	// Access:	DP Invalid Range
        CommError_00B8_00B8,	// Access:	DP Invalid Parameter
        CommError_00B9_00B9,	// Access:	DP Invalid Type
        CommError_00BA_00BF	// Access:	DP Access User Specific
    }
}

MENU Page_CommError_Resource
{
    LABEL 	[menu_dialog_error_handling_resource];
    ITEMS
    {
        CommError_00C0_00C0,	// Resource:	DP Read Constrain Conflict
        CommError_00C1_00C1,	// Resource:	DP Write Constrain Conflict
        CommError_00C2_00C2,	// Resource:	DP Resource Busy
        CommError_00C3_00C3,	// Resource:	DP Resource unavailable
        CommError_00C4_00C7,	// Resource:	DP Resource Reserved
        CommError_00C8_00CF	// Resource:	DP Recource User Specific
    }
}

MENU Page_CommError_Other
{
    LABEL 	[menu_dialog_error_handling_other];
    ITEMS
    {
        CommError_0000_009F,
        CommError_00D0_00FF
    }
}

METHOD	CommError_IgnoreAllErrors
{
    LABEL 		[comm_ignore_all_errors];
    HELP		[comm_ignore_all_errors_help];
    DEFINITION
    {
        iassign(CommError_0000_009F, 0);	// DP Error Reserved
        iassign(CommError_00A0_00A0, 0);	// Application: DP Read Error
        iassign(CommError_00A1_00A1, 0);	// Application: DP Write Error
        iassign(CommError_00A2_00A2, 0);	// Application: DP Module Failure
        iassign(CommError_00A3_00A7, 0);	// Application: DP Application Reserved
        iassign(CommError_00A8_00A8, 0);	// Application: DP Version Conflict
        iassign(CommError_00A9_00A9, 0);	// Application: DP Feature Not Supported
        iassign(CommError_00AA_00AF, 0);	// Application:	DP Application User Specific
        iassign(CommError_00B0_00B0, 0);	// Access:	DP Invalid Index
        iassign(CommError_00B1_00B1, 0);	// Access:	DP Write Length Error
        iassign(CommError_00B2_00B2, 0);	// Access:	DP Invalid Slot
        iassign(CommError_00B3_00B3, 0);	// Access:	DP Type Conflict
        iassign(CommError_00B4_00B4, 0);	// Access:	DP Invalid Area
        iassign(CommError_00B5_00B5, 0);	// Access:	DP State Conflict
        iassign(CommError_00B6_00B6, 0);	// Access:	DP Access Denied
        iassign(CommError_00B7_00B7, 0);	// Access:	DP Invalid Range
        iassign(CommError_00B8_00B8, 0);	// Access:	DP Invalid Parameter
        iassign(CommError_00B9_00B9, 0);	// Access:	DP Invalid Type
        iassign(CommError_00BA_00BF, 0);	// Access:	DP Access User Specific
        iassign(CommError_00C0_00C0, 0);	// Resource:	DP Read Constrain Conflict
        iassign(CommError_00C1_00C1, 0);	// Resource:	DP Write Constrain Conflict
        iassign(CommError_00C2_00C2, 0);	// Resource:	DP Resource Busy
        iassign(CommError_00C3_00C3, 0);	// Resource:	DP Resource unavailable
        iassign(CommError_00C4_00C7, 0);	// Resource:	DP Resource Reserved
        iassign(CommError_00C8_00CF, 0);	// Resource:	DP Recource User Specific
        iassign(CommError_00D0_00FF, 0);	// DP User Specific
    }
}

METHOD	CommError_CheckAllErrors
{
    LABEL 		[comm_check_all_errors];
    HELP		[comm_check_all_errors_help];
    DEFINITION
    {
        iassign(CommError_0000_009F, 1);	// DP Error Reserved
        iassign(CommError_00A0_00A0, 1);	// Application: DP Read Error
        iassign(CommError_00A1_00A1, 1);	// Application: DP Write Error
        iassign(CommError_00A2_00A2, 1);	// Application: DP Module Failure
        iassign(CommError_00A3_00A7, 1);	// Application: DP Application Reserved
        iassign(CommError_00A8_00A8, 1);	// Application: DP Version Conflict
        iassign(CommError_00A9_00A9, 1);	// Application: DP Feature Not Supported
        iassign(CommError_00AA_00AF, 1);	// Application:	DP Application User Specific
        iassign(CommError_00B0_00B0, 1);	// Access:	DP Invalid Index
        iassign(CommError_00B1_00B1, 1);	// Access:	DP Write Length Error
        iassign(CommError_00B2_00B2, 1);	// Access:	DP Invalid Slot
        iassign(CommError_00B3_00B3, 1);	// Access:	DP Type Conflict
        iassign(CommError_00B4_00B4, 1);	// Access:	DP Invalid Area
        iassign(CommError_00B5_00B5, 1);	// Access:	DP State Conflict
        iassign(CommError_00B6_00B6, 1);	// Access:	DP Access Denied
        iassign(CommError_00B7_00B7, 1);	// Access:	DP Invalid Range
        iassign(CommError_00B8_00B8, 1);	// Access:	DP Invalid Parameter
        iassign(CommError_00B9_00B9, 1);	// Access:	DP Invalid Type
        iassign(CommError_00BA_00BF, 1);	// Access:	DP Access User Specific
        iassign(CommError_00C0_00C0, 1);	// Resource:	DP Read Constrain Conflict
        iassign(CommError_00C1_00C1, 1);	// Resource:	DP Write Constrain Conflict
        iassign(CommError_00C2_00C2, 1);	// Resource:	DP Resource Busy
        iassign(CommError_00C3_00C3, 1);	// Resource:	DP Resource unavailable
        iassign(CommError_00C4_00C7, 1);	// Resource:	DP Resource Reserved
        iassign(CommError_00C8_00CF, 1);	// Resource:	DP Recource User Specific
        iassign(CommError_00D0_00FF, 1);	// DP User Specific								*/
    }
}

METHOD	CommError_DefaultHandling
{
    LABEL 		[comm_default_handling];
    HELP		[comm_default_handling_help];
    DEFINITION
    {
        lassign(CommError_Delay_Read,  0);	// Delay after Read Command
        lassign(CommError_Delay_Write, 0);	// Delay after Write Command
        iassign(CommError_0000_009F, 1);	// DP Error Reserved
        iassign(CommError_00A0_00A0, 1);	// Application: DP Read Error
        iassign(CommError_00A1_00A1, 1);	// Application: DP Write Error
        iassign(CommError_00A2_00A2, 1);	// Application: DP Module Failure
        iassign(CommError_00A3_00A7, 1);	// Application: DP Application Reserved
        iassign(CommError_00A8_00A8, 1);	// Application: DP Version Conflict
        iassign(CommError_00A9_00A9, 1);	// Application: DP Feature Not Supported
        iassign(CommError_00AA_00AF, 1);	// Application:	DP Application User Specific
        iassign(CommError_00B0_00B0, 0);	// Access:	DP Invalid Index
        iassign(CommError_00B1_00B1, 1);	// Access:	DP Write Length Error
        iassign(CommError_00B2_00B2, 0);	// Access:	DP Invalid Slot
        iassign(CommError_00B3_00B3, 1);	// Access:	DP Type Conflict
        iassign(CommError_00B4_00B4, 1);	// Access:	DP Invalid Area
        iassign(CommError_00B5_00B5, 0);	// Access:	DP State Conflict
        iassign(CommError_00B6_00B6, 1);	// Access:	DP Access Denied
        iassign(CommError_00B7_00B7, 1);	// Access:	DP Invalid Range
        iassign(CommError_00B8_00B8, 0);	// Access:	DP Invalid Parameter
        iassign(CommError_00B9_00B9, 1);	// Access:	DP Invalid Type
        iassign(CommError_00BA_00BF, 1);	// Access:	DP Access User Specific
        iassign(CommError_00C0_00C0, 1);	// Resource:	DP Read Constrain Conflict
        iassign(CommError_00C1_00C1, 1);	// Resource:	DP Write Constrain Conflict
        iassign(CommError_00C2_00C2, 1);	// Resource:	DP Resource Busy
        iassign(CommError_00C3_00C3, 1);	// Resource:	DP Resource unavailable
        iassign(CommError_00C4_00C7, 1);	// Resource:	DP Resource Reserved
        iassign(CommError_00C8_00CF, 1);	// Resource:	DP Recource User Specific
        iassign(CommError_00D0_00FF, 1);	// DP User Specific
    }
}

METHOD method_Dummy{
    LABEL "";
    DEFINITION
        {
        }
}
