
/*
 * $Id$
 * 
 * Copyright (C) PI 2007-2012. All rights reserved.
 * 
 * Version: 2.0.5
 * 
 */

#ifndef __DPV1_PA_RSP_CODES_H
#define __DPV1_PA_RSP_CODES_H


/**
 * Response codes from Profibus communication.
 * These are the response codes of possible Error_Code_1 values.
 */
RESPONSE_CODES DPV1_PA_rsp_codes
{
		0xA0,  MISC_ERROR,         [PI_appl_read_error];
		0xA1,  MISC_ERROR,         [PI_appl_write_error];
		0xA2,  MISC_ERROR,         [PI_appl_module_failure];
		0xA9,  MISC_ERROR,         [PI_appl_feature_not_supported];
		0xAF,  MISC_ERROR,         [PI_appl_unspecific_error];
		0xB0,  MISC_ERROR,         [PI_access_invalid_index];
		0xB1,  DATA_ENTRY_ERROR,   [PI_access_write_length_error];
		0xB2,  MISC_ERROR,         [PI_access_invalid_slot];
		0xB3,  DATA_ENTRY_ERROR,   [PI_access_type_conflict];
		0xB4,  MISC_ERROR,         [PI_access_invalid_area];
		0xB5,  MODE_ERROR,         [PI_access_state_conflict];
		0xB6,  MODE_ERROR,         [PI_access_access_denied];
		0xB7,  MISC_ERROR,         [PI_access_invalid_range];
		0xBF,  MISC_ERROR,         [PI_access_unspecific_error];
		0xC2,  MISC_ERROR,         [PI_resource_busy];
		0xC3,  MISC_ERROR,         [PI_resource_unavailable];
		0xCF,  MISC_ERROR,         [PI_resource_unspecific_error];
}



#endif /* __DPV1_PA_RSP_CODES_H */