/*
Filename:           STRATOS_MULTI_ENUM.h
Function:           Device Description for .......
Device:             Stratos Multi
Device Revision:    1
DD Revision:        1
Last edit:          stz
Manufacturer:		KNICK GmbH & Co.,
                                Beuckestr.22,
                                D-14163 Berlin
                                Tel: +49 (0) 30-80191-0,
                                Fax: +49 (0) 30-80191-200
                                Internet: http://www.knick.de
                                email: knick@knick.de
Copyright:			(C) Knick GmbH & Co., 2019 All Rights Reserved.
*/


/*-----------------------------------------------------------*/

#define ENUM_OffOn               \
        {0, str_ENUM_OffOn_0} ,  \
        {1, str_ENUM_OffOn_1}    \



#define DEVICE_UNITS        \
            UNITS_CODE(HART_UNIT_DEG_C), \
            UNITS_CODE(HART_UNIT_DEF_F), \
            UNITS_CODE(34), \
            UNITS_CODE(HART_UNIT_KELVIN), \
            UNITS_CODE(1), \
            UNITS_CODE(2), \
            UNITS_CODE(3), \
            UNITS_CODE(4), \
            UNITS_CODE(5), \
            UNITS_CODE(6), \
            UNITS_CODE(7), \
            UNITS_CODE(8), \
            UNITS_CODE(9), \
            UNITS_CODE(10), \
            UNITS_CODE(11), \
            UNITS_CODE(12), \
            UNITS_CODE(13), \
            UNITS_CODE(14), \
            UNITS_CODE(145), \
            UNITS_CODE(237), \
            UNITS_CODE(238), \
            UNITS_CODE(239), \
            UNITS_CODE(15), \
            UNITS_CODE(16), \
            UNITS_CODE(17), \
            UNITS_CODE(18), \
            UNITS_CODE(19), \
            UNITS_CODE(22), \
            UNITS_CODE(23), \
            UNITS_CODE(24), \
            UNITS_CODE(25), \
            UNITS_CODE(26), \
            UNITS_CODE(27), \
            UNITS_CODE(28), \
            UNITS_CODE(29), \
            UNITS_CODE(30), \
            UNITS_CODE(31), \
            UNITS_CODE(121), \
            UNITS_CODE(122), \
            UNITS_CODE(123), \
            UNITS_CODE(130), \
            UNITS_CODE(131), \
            UNITS_CODE(132), \
            UNITS_CODE(133), \
            UNITS_CODE(134), \
            UNITS_CODE(135), \
            UNITS_CODE(136), \
            UNITS_CODE(137), \
            UNITS_CODE(138), \
            UNITS_CODE(235), \
            UNITS_CODE(20), \
            UNITS_CODE(21), \
            UNITS_CODE(114), \
            UNITS_CODE(115), \
            UNITS_CODE(116), \
            UNITS_CODE(120), \
            UNITS_CODE(40), \
            UNITS_CODE(41), \
            UNITS_CODE(42), \
            UNITS_CODE(43), \
            UNITS_CODE(46), \
            UNITS_CODE(110), \
            UNITS_CODE(111), \
            UNITS_CODE(112), \
            UNITS_CODE(113), \
            UNITS_CODE(124), \
            UNITS_CODE(166), \
            UNITS_CODE(167), \
            UNITS_CODE(168), \
            UNITS_CODE(236), \
            UNITS_CODE(44), \
            UNITS_CODE(45), \
            UNITS_CODE(47), \
            UNITS_CODE(48), \
            UNITS_CODE(49), \
            UNITS_CODE(50), \
            UNITS_CODE(51), \
            UNITS_CODE(52), \
            UNITS_CODE(53), \
            UNITS_CODE(60), \
            UNITS_CODE(61), \
            UNITS_CODE(62), \
            UNITS_CODE(63), \
            UNITS_CODE(64), \
            UNITS_CODE(65), \
            UNITS_CODE(125), \
            UNITS_CODE(70), \
            UNITS_CODE(71), \
            UNITS_CODE(72), \
            UNITS_CODE(73), \
            UNITS_CODE(74), \
            UNITS_CODE(75), \
            UNITS_CODE(76), \
            UNITS_CODE(77), \
            UNITS_CODE(78), \
            UNITS_CODE(79), \
            UNITS_CODE(80), \
            UNITS_CODE(81), \
            UNITS_CODE(82), \
            UNITS_CODE(83), \
            UNITS_CODE(84), \
            UNITS_CODE(85), \
            UNITS_CODE(86), \
            UNITS_CODE(87), \
            UNITS_CODE(88), \
            UNITS_CODE(90), \
            UNITS_CODE(91), \
            UNITS_CODE(92), \
            UNITS_CODE(93), \
            UNITS_CODE(94), \
            UNITS_CODE(95), \
            UNITS_CODE(96), \
            UNITS_CODE(97), \
            UNITS_CODE(98), \
            UNITS_CODE(99), \
            UNITS_CODE(100), \
            UNITS_CODE(102), \
            UNITS_CODE(103), \
            UNITS_CODE(104), \
            UNITS_CODE(146), \
            UNITS_CODE(147), \
            UNITS_CODE(54), \
            UNITS_CODE(55), \
            UNITS_CODE(36), \
            UNITS_CODE(58), \
            UNITS_CODE(39), \
            UNITS_CODE(37), \
            UNITS_CODE(163), \
            UNITS_CODE(69), \
            UNITS_CODE(89), \
            UNITS_CODE(126), \
            UNITS_CODE(128), \
            UNITS_CODE(162), \
            UNITS_CODE(164), \
            UNITS_CODE(165), \
            UNITS_CODE(127), \
            UNITS_CODE(129), \
            UNITS_CODE(140), \
            UNITS_CODE(141), \
            UNITS_CODE(142), \
            UNITS_CODE(117), \
            UNITS_CODE(118), \
            UNITS_CODE(119), \
            UNITS_CODE(38), \
            UNITS_CODE(56), \
            UNITS_CODE(57), \
            UNITS_CODE(59), \
            UNITS_CODE(66), \
            UNITS_CODE(67), \
            UNITS_CODE(68), \
            UNITS_CODE(101), \
            UNITS_CODE(105), \
            UNITS_CODE(106), \
            UNITS_CODE(107), \
            UNITS_CODE(108), \
            UNITS_CODE(109), \
            UNITS_CODE(139), \
            UNITS_CODE(143), \
            UNITS_CODE(144), \
            UNITS_CODE(148), \
            UNITS_CODE(149), \
            UNITS_CODE(150), \
            UNITS_CODE(151), \
            UNITS_CODE(152), \
            UNITS_CODE(153), \
            UNITS_CODE(154), \
            UNITS_CODE(155), \
            UNITS_CODE(160), \
            UNITS_CODE(161), \
            UNITS_CODE(169), \
            UNITS_CODE(250), \
            UNITS_CODE(251), \
            UNITS_CODE(252), \
            UNITS_CODE(253)


#define DEF_ENUM_LIST_UNITS         DEVICE_UNITS

//#####################################################################################
// Hier werden die spezialisierten Einheiten-Listen der jeweiligen Messgren definiert

//##############
// Temperatur
#define DEF_ENUM_LIST_TEMPERATURE_UNITS_INIT                    \
            UNITS_CODE_TEMPERATURE(HART_UNIT_DEG_C),            \
            UNITS_CODE_TEMPERATURE(HART_UNIT_DEF_F),            \
            UNITS_CODE_TEMPERATURE(HART_UNIT_KELVIN)

#define DEF_ENUM_LIST_TEMPERATURE_UNITS                         \
            ADD UNITS_CODE(HART_UNIT_NONE)

//##############
// pH-Sensoren
#define DEF_ENUM_LIST_PH_UNITS                                  \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_ANALYTICAL(HART_UNIT_PH)


#define DEF_ENUM_LIST_ORP_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_EMF(HART_UNIT_MV)                    \
            ADD UNITS_CODE_EMF(HART_UNIT_V)


#define DEF_ENUM_LIST_MV_UNITS                                  \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_EMF(HART_UNIT_MV)                    \
            ADD UNITS_CODE_EMF(HART_UNIT_V)


#define DEF_ENUM_LIST_RH_UNITS                                  \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_ANALYTICAL(HART_UNIT_PH)             \
            ADD { HART_UNIT_KNICK_3_RH, "|en|rH" }


#define DEF_ENUM_LIST_GLS_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_OHM)            \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_KOHM)           \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MOHM)       \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MILLI_OHM)


#define DEF_ENUM_LIST_BZG_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_OHM)            \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_KOHM)           \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MOHM)       \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MILLI_OHM)

#define DEF_ENUM_LIST_CAL_PH_NPKT_UNITS                         \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_ANALYTICAL(HART_UNIT_PH)

#define DEF_ENUM_LIST_CAL_PH_STEIL_UNITS                        \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD { HART_UNIT_KNICK_4_MV_PER_PH, "|en|mV/pH" }

#define DEF_ENUM_LIST_CAL_PH_APKT_UNITS                         \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_EMF(HART_UNIT_MV)

#define DEF_ENUM_LIST_CAL_ORP_OFFSET_UNITS                      \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_EMF(HART_UNIT_MV)



//##############
// Oxy-Sensoren
#define DEF_ENUM_LIST_SAT_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_SO2_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_MGL_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PPM)                       \
            ADD UNITS_CODE_MASS_PER_VOLUME(HART_UNIT_UG_PER_L)  \
            ADD UNITS_CODE_MASS_PER_VOLUME(HART_UNIT_EXT_MG_PER_L)

#define DEF_ENUM_LIST_VOL_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_VOL_PERCENT)               \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_CUR_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_CURRENT(HART_UNIT_MA)                \
            ADD UNITS_CODE_CURRENT(HART_UNIT_EXT_UA)            \
            ADD { HART_UNIT_EXT_NA, "|en|nA" }                  \
            ADD UNITS_CODE_CURRENT(HART_UNIT_EXT_A)
 

#define DEF_ENUM_LIST_PP_UNITS                                  \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_MMHG)             \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_PSI)              \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_BAR)              \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_MBAR)             \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_G_PER_CM2)        \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_KG_PER_CM2)       \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_KPA)              \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_PA)


#define DEF_ENUM_LIST_ITK_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_CURRENT(HART_UNIT_EXT_A)             \
            ADD UNITS_CODE_CURRENT(HART_UNIT_MA)                \
            ADD UNITS_CODE_CURRENT(HART_UNIT_EXT_UA)            \
            ADD { HART_UNIT_EXT_NA, "|en|nA" }


#define DEF_ENUM_LIST_SYS_PL_UNITS                              \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_MMHG)             \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_PSI)              \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_BAR)              \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_MBAR)             \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_G_PER_CM2)        \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_KG_PER_CM2)       \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_KPA)              \
            ADD UNITS_CODE_PRESSURE(HART_UNIT_PA)


#define DEF_ENUM_LIST_IMP_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_KOHM)                      \
            ADD UNITS_CODE(HART_UNIT_OHM)


#define DEF_ENUM_LIST_CAL_OXY_NPKT_UNITS                        \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_CURRENT(HART_UNIT_MA)                \
            ADD UNITS_CODE_CURRENT(HART_UNIT_EXT_UA)            \
            ADD { HART_UNIT_EXT_NA, "|en|nA" }

#define DEF_ENUM_LIST_CAL_OXY_STEIL_UNITS                       \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD { HART_UNIT_EXT_NA, "|en|nA" }                  \
            ADD UNITS_CODE_CURRENT(HART_UNIT_EXT_UA)            \
            ADD UNITS_CODE_CURRENT(HART_UNIT_MA)

#define DEF_ENUM_LIST_CAL_OXY_STERN_UNITS                       \
            ADD UNITS_CODE(HART_UNIT_NONE)

#define DEF_ENUM_LIST_CAL_OXY_PWINKEL_UNITS                     \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_DEGREE)



//##############
// Cond-Sensoren
#define DEF_ENUM_LIST_LF_UNITS                                  \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_U_SIEM)                    \
            ADD UNITS_CODE(HART_UNIT_M_SIEM_PER_CM)             \
            ADD UNITS_CODE(HART_UNIT_U_SIEM_PER_CM)


#define DEF_ENUM_LIST_SAL_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)                   \
            ADD { HART_UNIT_KNICK_5_G_PER_KG, "|en|g/kg" }


#define DEF_ENUM_LIST_KZ_UNITS                                  \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_RHO_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_OHM)            \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_OHM_X_CM)   \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_KOHM_X_CM)  \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MOHM_X_CM)


#define DEF_ENUM_LIST_USP_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_U_SIEM)                    \
            ADD UNITS_CODE(HART_UNIT_U_SIEM_PER_CM)             \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_TDS_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_MASS_PER_VOLUME(HART_UNIT_UG_PER_L)  \
            ADD UNITS_CODE_MASS_PER_VOLUME(HART_UNIT_EXT_MG_PER_L)


#define DEF_ENUM_LIST_LW_UNITS                                  \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_U_SIEM)


#define DEF_ENUM_LIST_WID_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_OHM)            \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_KOHM)           \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MOHM)       \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MILLI_OHM)

#define DEF_ENUM_LIST_CAL_CC_ZELL_UNITS                         \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD { HART_UNIT_KNICK_6_ONE_PER_CM, "|en|1/cm" }

#define DEF_ENUM_LIST_CAL_CC_NPKT_UNITS                         \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_U_SIEM)


//##############
// Diagnostic
#define DEF_ENUM_LIST_SENSO_FACE_UNITS                          \
            ADD UNITS_CODE(HART_UNIT_NONE)


#define DEF_ENUM_LIST_CAL_TIMER_UNITS                           \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_TIME(HART_UNIT_S)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_H)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_D)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_MS)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_US)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_NS)


#define DEF_ENUM_LIST_RESTSTANDZEIT_UNITS                       \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_TIME(HART_UNIT_S)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_H)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_D)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_MS)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_US)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_NS)


#define DEF_ENUM_LIST_VERSCHLEISS_UNITS                         \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_BETRIEBSZEIT_UNITS                        \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_TIME(HART_UNIT_S)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_H)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_D)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_MS)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_US)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_NS)


#define DEF_ENUM_LIST_SIP_COUNT_UNITS                           \
            ADD UNITS_CODE(HART_UNIT_NONE)


#define DEF_ENUM_LIST_CIP_COUNT_UNITS                           \
            ADD UNITS_CODE(HART_UNIT_NONE)


#define DEF_ENUM_LIST_AUTO_KLAVIER_COUNT_UNITS                  \
            ADD UNITS_CODE(HART_UNIT_NONE)


#define DEF_ENUM_LIST_DLI_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_ACT_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_TTM_UNITS                                 \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_TIME(HART_UNIT_S)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_H)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_D)                    \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_MS)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_US)               \
            ADD UNITS_CODE_TIME(HART_UNIT_EXT_NS)


#define DEF_ENUM_LIST_TEMPERATURE_DIF_UNITS                     \
            ADD UNITS_CODE(HART_UNIT_NONE)

#define DEF_ENUM_LIST_PH_DIF_UNITS                              \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_ANALYTICAL(HART_UNIT_PH)

#define DEF_ENUM_LIST_MV_DIF_UNITS                              \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_EMF(HART_UNIT_MV)                    \
            ADD UNITS_CODE_EMF(HART_UNIT_V)

#define DEF_ENUM_LIST_ORP_DIF_UNITS                             \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_EMF(HART_UNIT_MV)                    \
            ADD UNITS_CODE_EMF(HART_UNIT_V)

#define DEF_ENUM_LIST_SAT_DIF_UNITS                             \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)

#define DEF_ENUM_LIST_SO2_DIF_UNITS                             \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PERCENT)

#define DEF_ENUM_LIST_MGL_DIF_UNITS                             \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_PPM)                       \
            ADD UNITS_CODE(HART_UNIT_PERCENT)                   \
            ADD UNITS_CODE_MASS_PER_VOLUME(HART_UNIT_EXT_MG_PER_L)

#define DEF_ENUM_LIST_VOL_DIF_UNITS                             \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_VOL_PERCENT)               \
            ADD UNITS_CODE(HART_UNIT_PERCENT)

#define DEF_ENUM_LIST_LF_DIF_UNITS                              \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE(HART_UNIT_M_SIEM_PER_CM)             \
            ADD UNITS_CODE(HART_UNIT_U_SIEM_PER_CM)

#define DEF_ENUM_LIST_RHO_DIF_UNITS                             \
            ADD UNITS_CODE(HART_UNIT_NONE)                      \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_OHM)            \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_OHM_X_CM)   \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_KOHM_X_CM)  \
            ADD UNITS_CODE_RESISTANCE(HART_UNIT_EXT_MOHM_X_CM)


#define DEF_ENUM_LIST_RATIO_UNITS                               \
            ADD UNITS_CODE(HART_UNIT_NONE)


#define DEF_ENUM_LIST_PASSAGE_UNITS                             \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_REJECTION_UNITS                           \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_DEVIATION_UNITS                           \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_PPM_UNITS                                 \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE(HART_UNIT_PPM)                        \
           ADD UNITS_CODE(HART_UNIT_PERCENT)

#define DEF_ENUM_LIST_UMOLL_UNITS                               \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD { HART_UNIT_KNICK_2_UMOL_PER_L, "|en|mol/l" }   \
           ADD UNITS_CODE(HART_UNIT_PERCENT)

#define DEF_ENUM_LIST_CC_PH_UNITS                               \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE_ANALYTICAL(HART_UNIT_PH)

#define DEF_ENUM_LIST_ELF_UNITS                                 \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE(HART_UNIT_M_SIEM_PER_CM)              \
           ADD UNITS_CODE(HART_UNIT_U_SIEM_PER_CM)


#define DEF_ENUM_LIST_RCAP_UNITS                                \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE(HART_UNIT_PERCENT)


#define DEF_ENUM_LIST_RTIME_UNITS                               \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE_TIME(HART_UNIT_S)                     \
           ADD UNITS_CODE_TIME(HART_UNIT_H)                     \
           ADD UNITS_CODE_TIME(HART_UNIT_D)                     \
           ADD UNITS_CODE_TIME(HART_UNIT_EXT_MS)                \
           ADD UNITS_CODE_TIME(HART_UNIT_EXT_US)                \
           ADD UNITS_CODE_TIME(HART_UNIT_EXT_NS)

#define DEF_ENUM_LIST_FLOW_UNITS                                \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE_VOLUMETRIC_FLOW(HART_UNIT_L_PER_H)



#define DEF_ENUM_LIST_RM_I_IN_UNITS                             \
           ADD UNITS_CODE(HART_UNIT_NONE)                       \
           ADD UNITS_CODE_CURRENT(HART_UNIT_MA)



