// File: SIPASTPB_300.inc
// Copyright (C) Siemens AG (1997 -2003). All Rights Reserved
// Description: Profile 3 - Physical Block
/* $Revision:   1.21  $	*/
/* $Date:   Jan 2 2003 $	*/


// --- Configuration -------------------------------------------

#ifndef DEVICE_TYPE
#define DEVICE_TYPE " "
#endif


#ifndef PHYSICAL_BLOCK_PARENT_CLASS
#define PHYSICAL_BLOCK_PARENT_CLASS		1,	[phys_blk_parent_class_TRANSMITTER]
#endif	


#ifndef DEFAULT_MANUFACTURER_ID
#define DEFAULT_MANUFACTURER_ID	252
#endif


#ifndef DEFAULT_phys_ident_number
#define DEFAULT_phys_ident_number	0
#endif

#ifndef DEFAULT_VALUE_phys_device_certification
#define DEFAULT_VALUE_phys_device_certification "CE,NE21, Exmarking see plate"
#endif

#ifndef DEFAULT_VALUE_phys_device_id
#define DEFAULT_VALUE_phys_device_id "?"
#endif

#ifndef DEFAULT_VALUE_phys_software_rev
#define DEFAULT_VALUE_phys_software_rev	"?"
#endif


#ifndef PHYS_FACTORY_RESET_ADDRESS
#define PHYS_FACTORY_RESET_ADDRESS	2712
#endif

#ifndef PHYS_FACTORY_RESET_CMD
#define PHYS_FACTORY_RESET_CMD	2506
#endif



// --- Windows and dialogs ----------------------------------------------------

MENU Page_diagnosis_phys_block
{
	LABEL		[blk_block_object_PHYSICAL];
	ITEMS
	{
		phys_blk_object,
		phys_blk_parent_class,
		phys_blk_class,
		phys_blk_dd_reference,
		phys_blk_dd_rev,
		phys_blk_profile,
		phys_blk_profile_rev,
		phys_st_rev,
		phys_actual_mode
	}
}



// --- Reset dialogs 

MENU OnlineDialog_reset
{
	LABEL		[master_reset];
	HELP		[master_reset_help];
	ITEMS
	{
		Page_reset
	}
}



MENU Page_reset
{
	LABEL		[master_reset];
	HELP		[master_reset_help];
	ITEMS
	{
		phys_diagnosis,
		SEPARATOR,
		method_phys_factory_reset_params,
		method_phys_factory_reset_warm,
		method_phys_factory_reset_address
#ifdef MANUFACTURER_SPECIFIC_phys_factory_reset
		,method_phys_factory_reset_device_specific
#endif
	}
}



METHOD method_phys_factory_reset_params
{
	LABEL		[factory_reset_PARAMS];
	DEFINITION
	{
		int status;

		ACKNOWLEDGE([factory_reset_PARAMS]);

		phys_factory_reset = 1; //	[factory_reset_PARAMS]	

		status = WriteCommand (write_phys_factory_reset);
	}
}


METHOD method_phys_factory_reset_warm
{
	LABEL		[phys_device_reset_cmd];
	DEFINITION
	{
		int status;
		char sz[512] ;
		int iLen ;

		get_dictionary_string(phys_device_reset_cmd, sz, iLen) ;

#ifdef _V510_
		sz += "\r\n\r\n" ;
		sz += [note_connection_will_be_aborted] ;
#endif

		ACKNOWLEDGE(sz);

		phys_factory_reset = PHYS_FACTORY_RESET_CMD ;

		status = WriteCommand (write_phys_factory_reset);

		if( status == 17456 )
		{
			ACKNOWLEDGE([not_supported]) ;
		}
	}
}


METHOD method_phys_factory_reset_address
{
	LABEL		[factory_reset_ADDRESS];
	DEFINITION
	{
		int status;
		char sz[512] ;
		int iLen ;

		get_dictionary_string(factory_reset_ADDRESS, sz, iLen) ;

#ifdef _V510_
		sz += "\r\n\r\n" ;
		sz += [note_connection_will_be_aborted] ;
#endif

		ACKNOWLEDGE(sz);

		phys_factory_reset = PHYS_FACTORY_RESET_ADDRESS; 

		status = WriteCommand (write_phys_factory_reset);

		if( status == 17456 )
		{
			ACKNOWLEDGE([not_supported]) ;
		}
	}
}


METHOD method_phys_factory_reset_device_specific
{
	LABEL		[device_specific_reset];
	DEFINITION
	{
		int status;
		char sz[512] ;
		int iLen ;

		GET_DEV_VAR_VALUE([reset], phys_factory_reset) ;

		status = WriteCommand (write_phys_factory_reset);

		if( status == 17456 )
		{
			ACKNOWLEDGE([not_supported]) ;
		}
	}
}



// --- Parameter table --------------------------------------------------------

MENU Tab_s_ident
{
	LABEL		[menu_ident];

	ITEMS
	{
		Tab_s_ident_opunit,
		Tab_s_ident_device

#ifdef PHYS_ADDITIONAL_GROUP_SPECIALIST
		,
		PHYS_ADDITIONAL_GROUP_SPECIALIST
#endif
	}
}


MENU Tab_s_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		phys_tag_desc,
		phys_descriptor,	
		phys_message	
	}
}



MENU Tab_m_ident
{
	LABEL		[menu_ident];
	ITEMS
	{
		Tab_m_ident_opunit,
		Tab_m_ident_device
#ifdef PHYS_ADDITIONAL_GROUP_MAINTENANCE
		,
		PHYS_ADDITIONAL_GROUP_MAINTENANCE
#endif
	}
}



MENU Tab_m_ident_opunit
{
	LABEL		[menu_ident_opunit];
	ITEMS
	{
		phys_tag_desc		(READ_ONLY),
		phys_descriptor,	
		phys_message	
	}
}


MENU Tab_s_certificates
{
	LABEL		[menu_certificates];
	ITEMS
	{
		phys_device_certification	(READ_ONLY)
	}
}



// ---- Firmware version ------------------------------------------------------



// --- Physical Block (Profile 3) ---------------------------------------------

#define PHYS_LOAD_TO_PC											\
		phys_st_rev,											\
		phys_tag_desc,											\
		phys_device_man_id,										\
		phys_device_id											\
		phys_device_ser_num,									\
		phys_software_rev,										\
		phys_hardware_rev,										\
		phys_blk_profile_rev,									\
		phys_install_date,										\
		phys_device_certification,								\
		phys_descriptor,										\
		phys_message,											\
		phys_ident_number,										\
		phys_write_locking,										\
		phys_module_configuration_sw_ver,						\
		phys_module_configuration_module_at_addr_4,				\
		phys_module_configuration_module_at_addr_5,				\
		phys_module_configuration_module_at_addr_6,				\
		phys_module_configuration_ex



#define PHYS_LOAD_TO_DEVICE										\
		phys_tag_desc,											\
		phys_install_date,										\
		phys_descriptor,										\
		phys_message,											\
		phys_ident_number,										\
		phys_write_locking



// --- Windows and dialogs ---------------------------------------------------------------

MENU Page_diagnosis_general
{
	LABEL		[menu_dialog_general];
	ITEMS
	{
		phys_tag_desc					(READ_ONLY),
		phys_device_man_id,
		phys_device_id,
		phys_device_ser_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_install_date				(READ_ONLY),

#ifndef NO_phys_write_locking
		phys_write_locking			(READ_ONLY),
#endif

		phys_analysis_device_state	(READ_ONLY)
	}
}



// Physical Block Parameter ---------------------------------------------------



// Parameter:	PHYS_ADDITIONAL_PARAMETER
// Parameter:	PHYS_MULTIVARIABLE_DEVICE
// Parameter:	PHYS_ADDITIONAL_GROUP_SPECIALIST
// Parameter:	PHYS_ADDITIONAL_GROUP_MAINTENANCE
// Parameter:	PHYS_IDENT_SPECIFIC
// Parameter:	MANUFACTURER_SPECIFIC_phys_factory_reset

// To disable optional parameters use the following macros
// NO_phys_hw_write_protection
// NO_phys_local_operation_enable
// NO_phys_diagnosis_extension
// NO_phys_diagnosis_extension_mask

// To disable/enable optional enumeration of phys_ident_number define the following macros
// NO_phys_ident_number_MANUFACURER
// OPT_PHYS_IDENT_NUMBER_MANUFACTURER_2_0
// OPT_PHYS_IDENT_NUMBER_MULTIVARIABLE



// --- Parameter table --------------------------------------------------------

MENU Tab_s_ident_device
{
	LABEL		[menu_ident_device];
	ITEMS
	{
		phys_device_man_id,
		phys_device_id,
		phys_device_ser_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_blk_profile_rev,
		phys_st_rev,
		phys_ident_number,
		phys_install_date
#ifdef PHYS_ADDITIONAL_PARAMETER
		,
		PHYS_ADDITIONAL_PARAMETER
#endif
	}
}


MENU Tab_m_ident_device
{
	LABEL		[menu_ident_device];
	ITEMS
	{
		phys_device_man_id,
		phys_device_id,
		phys_device_ser_num,
		phys_software_rev,
		phys_hardware_rev,
		phys_blk_profile_rev,
		phys_st_rev,
		phys_ident_number	(READ_ONLY),
		phys_install_date	(READ_ONLY)
	}
}


//-------------------------------------------------------------------------------------------------
//    OnlineDialog: Write Locking
//-------------------------------------------------------------------------------------------------

MENU OnlineDialog_write_locking
{
	LABEL		[phys_write_locking];
	HELP		[phys_write_locking_help];
  	ITEMS
  	{
		phys_write_locking,							
		phys_local_operation_enable,							
  	 	method_set
  	}
}


// Parameter ------------------------------------------------------------------

BLOCK physical_block
{
	TYPE	PHYSICAL;
	NUMBER	1;
}

VARIABLE phys_blk_reserve
{
	LABEL		[blk_reserved];
	HELP		[blk_reserved_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}

VARIABLE phys_blk_object
{
	LABEL		[blk_block_object];
	HELP		[blk_block_object_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		{	1,	[blk_block_object_PHYSICAL]	}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_parent_class
{
	LABEL		[blk_parent_class];
	HELP		[phys_blk_parent_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		{ PHYSICAL_BLOCK_PARENT_CLASS }
	}
	HANDLING	READ;
}

VARIABLE phys_blk_class
{
	LABEL		[blk_class];
	HELP		[phys_blk_class_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(1)
	{
		DEFAULT_VALUE	250;
		{	250,	[not_used]		}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_dd_reference
{
	LABEL		[blk_dd_reference];
	HELP		[blk_dd_reference_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (4);
	HANDLING	READ;
}

VARIABLE phys_blk_dd_rev
{
	LABEL		[blk_dd_rev];
	HELP		[blk_dd_rev_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(2);
	HANDLING	READ;
}

VARIABLE phys_blk_profile
{
	LABEL		[blk_profile];
	HELP		[blk_profile_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
#ifdef DEFAULT_VALUE_phys_blk_profile
		DEFAULT_VALUE_phys_blk_profile
#endif
		{ 0x4001,	[blk_profile_PA_COMPACT_A]	},
		{ 0x4002,	[blk_profile_PA_COMPACT_B]	},
		{ 0x4081,	[blk_profile_PA_SIMPLE_A]	},
		{ 0x4082,	[blk_profile_PA_SIMPLE_B]	}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_profile_rev
{
	LABEL		[blk_profile_rev];
	HELP		[blk_profile_rev_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
#ifdef CHECK_PROFILE_REV
		DEFAULT_VALUE	CHECK_PROFILE_REV ;
#else
		DEFAULT_VALUE	0x0300;
#endif
		{	0x025A,	"2.90"	},
		{	0x025B,	"2.91"	},
		{	0x025C,	"2.92"	},
		{	0x025D,	"2.93"	},
		{	0x025E,	"2.94"	},
		{	0x025F,	"2.95"	},
		{	0x0260,	"2.96"	},
		{	0x0261,	"2.97"	},
		{	0x0262,	"2.98"	},
		{	0x0263,	"2.99"	},
		{	0x0300,	"3.0"	}
	}
	HANDLING	READ;
}

VARIABLE phys_blk_execution_time
{
	LABEL		[blk_execution_time];
	HELP		[blk_execution_time_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER(1);
	HANDLING	READ;
}

VARIABLE phys_blk_num_parameters
{
	LABEL		[blk_num_parameters];
	HELP		[blk_num_parameters_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE phys_blk_index_view_1
{
	LABEL		[blk_index_view_1];
	HELP		[blk_index_view_1_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2);
	HANDLING	READ;
}

VARIABLE phys_blk_num_view_lists
{
	LABEL		[blk_num_view_lists];
	HELP		[blk_num_view_lists_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1);
	HANDLING	READ;
}

VARIABLE phys_st_rev
{
	LABEL		[st_rev];
	HELP		[st_rev_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0;
	}
	HANDLING	READ;
}

VARIABLE phys_tag_desc
{
	/* ST_REV */
	LABEL		[tag_desc];		
	HELP		[tag_desc_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32);
	HANDLING	READ & WRITE;
}

VARIABLE phys_strategy
{
	/* ST_REV */
	LABEL		[strategy];		
	HELP		[strategy_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (2)
	{
		DEFAULT_VALUE	0; 
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_alert_key
{
	/* ST_REV */
	LABEL		[alert_key];		
	HELP		[alert_key_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	0; 
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_target_mode
{
	/* ST_REV */
	LABEL		[target_mode];		
	HELP		[target_mode_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_actual_mode
{
	LABEL		[actual_mode];		
	HELP		[actual_mode_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE 0x08 ;
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE phys_permitted_mode
{
	LABEL		[permitted_mode];		
	HELP		[permitted_mode_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}
	}
	HANDLING	READ;
}

VARIABLE phys_normal_mode
{
	LABEL		[normal_mode];		
	HELP		[normal_mode_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	0x08;
		
		{	0x02,	[mode_RCAS]				},
		{	0x08,	[mode_AUTO]				},
		{	0x10,	[mode_MAN]				},
		{	0x20,	[mode_LO]				},
		{	0x80,	[mode_OUT_OF_SERVICE]	}

	}
	HANDLING	READ;
}

VARIABLE phys_current_state_alarm_sum
{
	LABEL		[current_state_alarm_sum];		
	HELP		[current_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_unacknowledged_state_alarm_sum
{
	LABEL		[unacknowledged_state_alarm_sum];		
	HELP		[unacknowledged_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_unreported_state_alarm_sum
{
	LABEL		[unreported_state_alarm_sum];		
	HELP		[unreported_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_disabled_state_alarm_sum
{
	LABEL		[disabled_state_alarm_sum];		
	HELP		[disabled_state_alarm_sum_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE	0x0000; 
		{	0x0000,	[limit_state_NO_ALARM]	},
		{	0x8000,	[limit_state_ST_REV]	}
	}
	HANDLING	READ;
}

VARIABLE phys_software_rev
{
	LABEL		[phys_software_revision];
	HELP		[phys_software_revision_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
		DEFAULT_VALUE	"1";
	}
	HANDLING	READ;
}


VARIABLE phys_software_rev_numeric
{
	LABEL		[phys_software_revision];
	CLASS		LOCAL ;
	TYPE		UNSIGNED_INTEGER(4)
	{
		DEFAULT_VALUE 0 ;
	}
	HANDLING	READ;
}

VARIABLE phys_software_rev_rest
{
	LABEL		[phys_software_revision];
	CLASS		CONTAINED;
	TYPE		ASCII(8) ;
	HANDLING	READ;
}
VARIABLE phys_software_rev_str
{
	LABEL		[phys_software_revision];
	CLASS		CONTAINED;
	TYPE		ASCII(8) ;
	HANDLING	READ;
	POST_READ_ACTIONS {GetNumericSoftwareRevision}
}


COMMAND read_phys_software_rev_numeric
{
	BLOCK physical_block;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_software_rev_rest
            phys_software_rev_str
		}
	}
}

METHOD GetNumericSoftwareRevision
{
    LABEL "GetNumericSoftwareRevision";
	TYPE int;
	CLASS INPUT;
    DEFINITION
    {     
		char cbuf[16];
		unsigned long iSoftwareVersion;
		
        //ReadCommand(read_phys_software_rev_numeric);
		
		cbuf = phys_software_rev_str;
		cbuf[1] = '0';
		cbuf[3] = '0';
				
		
		iSoftwareVersion = atol(cbuf);
		phys_software_rev_numeric = iSoftwareVersion;		

		//PUT_MESSAGE("Version: " + phys_software_rev_str + " " + cbuf + " "+ phys_software_rev_numeric);

return iSoftwareVersion;
    }
}

VARIABLE phys_hardware_rev
{
	LABEL		[phys_hardware_revision];
	HELP		[phys_hardware_revision_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
		DEFAULT_VALUE	"1";
	}
	HANDLING	READ;
}

VARIABLE phys_device_man_id
{
	LABEL		[phys_device_man_id];
	HELP		[phys_device_man_id_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (2)
	{
		DEFAULT_VALUE	DEFAULT_MANUFACTURER_ID;
		PHYS_DEVICE_MAN_ID_LIST
	}
	HANDLING	READ;
}

VARIABLE phys_device_id
{
	LABEL		[phys_device_type];
	HELP		[phys_device_type_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
		DEFAULT_VALUE	DEVICE_TYPE;
	}
	HANDLING	READ;
}

VARIABLE phys_device_ser_num
{
	LABEL		[phys_device_ser_num];
	HELP		[phys_device_ser_num_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16);
	HANDLING	READ;
}

#define DIA_HW_ELECTR			0x01000000		/* 0x00000001 */
#define DIA_HW_MECH				0x02000000		/* 0x00000002 */
#define DIA_TEMP_MOTOR			0x04000000		/* 0x00000004 */
#define DIA_TEMP_ELECTR			0x08000000		/* 0x00000008 */
#define DIA_MEM_CHKSUM			0x10000000		/* 0x00000010 */
#define DIA_MEASUREMENT			0x20000000		/* 0x00000020 */
#define DIA_NOT_INIT				0x40000000		/* 0x00000040 */
#define DIA_INIT_ERR				0x80000000		/* 0x00000080 */
#define DIA_ZERO_ERR				0x00010000		/* 0x00000100 */
#define DIA_SUPPLY				0x00020000		/* 0x00000200 */
#define DIA_CONF_INVAL			0x00040000		/* 0x00000400 */
#define DIA_WARMSTART			0x00080000		/* 0x00000800 */
#define DIA_COLDSTART			0x00100000		/* 0x00001000 */
#define DIA_MAINTENANCE			0x00200000		/* 0x00002000 */
#define DIA_CHARACT				0x00400000		/* 0x00004000 */
#define DIA_IDENT_VIOL			0x00800000		/* 0x00008000 */
#define EXTENSION_AVAILABLE	0x00000080		/* 0x80000000 */

VARIABLE phys_diagnosis
{
	LABEL		[phys_diagnosis];
	HELP		[phys_diagnosis_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		BIT_ENUMERATED (4)
	{
		DEFAULT_VALUE    0x00000000;
		{	0,							[dia_OK],						[dia_OK_help]							},
		{	DIA_HW_ELECTR,			[dia_HW_ELECTR],				[dia_HW_ELECTR_help]					},
//		{	DIA_HW_MECH,			[dia_HW_MECH],					[dia_HW_MECH_help]					},
//		{	DIA_TEMP_MOTOR,		[dia_TEMP_MOTOR],				[dia_TEMP_MOTOR_help]				},
//		{	DIA_TEMP_ELECTR,		[dia_TEMP_ELECTR],			[dia_TEMP_ELECTR_help]				},
		{	DIA_MEM_CHKSUM,		[dia_MEM_CHKSUM],				[dia_MEM_CHKSUM_help]				},
		{	DIA_MEASUREMENT,		[dia_MEASUREMENT],			[dia_MEASUREMENT_help]				},
//		{	DIA_NOT_INIT,			[dia_NOT_INIT],				[dia_NOT_INIT_help]					},
//		{	DIA_INIT_ERR,			[dia_INIT_ERR],				[dia_INIT_ERR_help]					},
//		{	DIA_ZERO_ERR,			[dia_ZERO_ERR],				[dia_ZERO_ERR_help]					},
//		{	DIA_SUPPLY,				[dia_SUPPLY],					[dia_SUPPLY_help]						},
//		{	DIA_CONF_INVAL,		[dia_CONF_INVAL],				[dia_CONF_INVAL_help]				},
		{	DIA_WARMSTART,			[dia_WARMSTART],				[dia_WARMSTART_help]					},
		{	DIA_COLDSTART,			[dia_COLDSTART],				[dia_COLDSTART_help]					},
		{	DIA_MAINTENANCE,		[dia_MAINTENANCE],			[dia_MAINTENANCE_help]				},
//		{	DIA_CHARACT,			[dia_CHARACT],					[dia_CHARACT_help]					},
		{	DIA_IDENT_VIOL,		[dia_IDENT_VIOL],				[dia_IDENT_VIOL_help]				}
//		{	EXTENSION_AVAILABLE,	[dia_EXTENSION_AVAILABLE],	[dia_EXTENSION_AVAILABLE_help]	}
	}
	HANDLING	READ;
#ifdef _V510_
	STYLE "MULTILINE 16 7" ;
#endif
}

VARIABLE phys_diagnosis_mask
{
	LABEL		[phys_diagnosis_mask];
	HELP		[phys_diagnosis_mask_help];
	CLASS		CONTAINED;
	TYPE		BIT_ENUMERATED (4)
	{
#ifdef DEFAULT_VALUE_phys_diagnosis_mask
	DEFAULT_VALUE DEFAULT_VALUE_phys_diagnosis_mask ;
#endif

		{	DIA_HW_ELECTR,		[dia_HW_ELECTR],			[dia_HW_ELECTR_help]			},
		{	DIA_HW_MECH,		[dia_HW_MECH],				[dia_HW_MECH_help]				},
		{	DIA_TEMP_MOTOR,		[dia_TEMP_MOTOR],			[dia_TEMP_MOTOR_help]			},
		{	DIA_TEMP_ELECTR,		[dia_TEMP_ELECTR],			[dia_TEMP_ELECTR_help]			},
		{	DIA_MEM_CHKSUM,		[dia_MEM_CHKSUM],			[dia_MEM_CHKSUM_help]			},
		{	DIA_MEASUREMENT,		[dia_MEASUREMENT],			[dia_MEASUREMENT_help]			},
		{	DIA_NOT_INIT,			[dia_NOT_INIT],				[dia_NOT_INIT_help]				},
		{	DIA_INIT_ERR,			[dia_INIT_ERR],				[dia_INIT_ERR_help]				},
		{	DIA_ZERO_ERR,			[dia_ZERO_ERR],				[dia_ZERO_ERR_help]				},
		{	DIA_SUPPLY,			[dia_SUPPLY],				[dia_SUPPLY_help]				},
		{	DIA_CONF_INVAL,		[dia_CONF_INVAL],			[dia_CONF_INVAL_help]			},
		{	DIA_WARMSTART,		[dia_WARMSTART],			[dia_WARMSTART_help]			},
		{	DIA_COLDSTART,		[dia_COLDSTART],			[dia_COLDSTART_help]			},
		{	DIA_MAINTENANCE,		[dia_MAINTENANCE],			[dia_MAINTENANCE_help]			},
		{	DIA_CHARACT,			[dia_CHARACT],				[dia_CHARACT_help]				},
		{	DIA_IDENT_VIOL,		[dia_IDENT_VIOL],			[dia_IDENT_VIOL_help]			}
		{	EXTENSION_AVAILABLE,	[dia_EXTENSION_AVAILABLE],	[dia_EXTENSION_AVAILABLE_help]	}
	}
	HANDLING	READ;
}

#ifndef NO_phys_diagnosis_extension
VARIABLE phys_diagnosis_extension				/* optional */
{
	LABEL		[phys_diagnosis_extension];
	HELP		[phys_diagnosis_extension_help];
	CLASS		CONTAINED & DYNAMIC ;
	TYPE		ASCII (6);
/*	TYPE		BIT_ENUMERATED (6);	*/
	HANDLING	READ;
}
#endif

#ifndef NO_phys_diagnosis_extension_mask
VARIABLE phys_diagnosis_extension_mask			/* optional */
{
	LABEL		[phys_diagnosis_extension_mask];
	HELP		[phys_diagnosis_extension_mask_help];
	CLASS		CONTAINED;
	TYPE		ASCII (6);
/*	TYPE		BIT_ENUMERATED (6);	*/
	HANDLING	READ;
}
#endif

VARIABLE phys_device_certification				/* optional */
{
	LABEL		[phys_device_certification];
	HELP		[phys_device_certification_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{

		DEFAULT_VALUE	DEFAULT_VALUE_phys_device_certification ;
	}
	HANDLING	READ;
}

#ifndef NO_phys_write_locking
VARIABLE phys_write_locking						/* optional */
{
	LABEL		[phys_write_locking];
	HELP		[phys_write_locking_help];
	CLASS		CONTAINED;
#ifdef MANUFACTURER_SPECIFIC_NUM_phys_write_locking
	TYPE		UNSIGNED_INTEGER(2)
#else
	TYPE		ENUMERATED(2)
#endif
	{
		DEFAULT_VALUE	2457;
		{ 2457,		[off]	},
		{ 0,		[on]	}
#ifdef MANUFACTURER_SPECIFIC_phys_write_locking
	,MANUFACTURER_SPECIFIC_phys_write_locking		
#endif

	}
	HANDLING	READ & WRITE;
}
#endif

VARIABLE phys_factory_reset						/* optional */
{
	/* ST_REV */
	LABEL		[phys_factory_reset];
	HELP		[phys_factory_reset_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED(2)
	{
		DEFAULT_VALUE	0;
		{ 0,		[no_function]			},
		{ 1,		[factory_reset_PARAMS]	},
		{ PHYS_FACTORY_RESET_CMD,			[phys_device_reset_cmd]	},
//		{ PHYS_FACTORY_RESET_ADDRESS,		[factory_reset_ADDRESS]	}
#ifdef MANUFACTURER_SPECIFIC_phys_factory_reset
	,MANUFACTURER_SPECIFIC_phys_factory_reset		
#endif
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_descriptor						/* optional */
{
	LABEL		[phys_descriptor];
	HELP		[phys_descriptor_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
		DEFAULT_VALUE "";
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_message							/* optional */
{
	LABEL		[phys_message];
	HELP		[phys_message_help];
	CLASS		CONTAINED;
	TYPE		ASCII (32)
	{
		DEFAULT_VALUE "";
	}
	HANDLING	READ & WRITE;
}

VARIABLE phys_install_date						/* optional */
{
	LABEL		[phys_install_date];
	HELP		[phys_install_date_help];
	CLASS		CONTAINED;
	TYPE		ASCII (16)
	{
		DEFAULT_VALUE "01.02.2004";
	}
	HANDLING	READ & WRITE;
// mes, 29.10.05 TEST start
	POST_EDIT_ACTIONS
	{
//		method_phys_calprot1_interpreter
		//rth: (mes fragen, die gibt es scheinbar nicht mehr) method_calprot_clear
//		method_phys_calprot2_dauerfeuer
	}
// mes, 29.10.05 TEST end
}


#ifndef NO_phys_local_operation_enable
VARIABLE phys_local_operation_enable
{
	LABEL		[trans_act_local_operation];
	HELP		[trans_act_local_operation_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE	1;
		{	0,	[disabled]	},
		{	1,	[enabled]	}
	}
	HANDLING	READ & WRITE;
}
#endif

VARIABLE phys_ident_number
{
	LABEL		[phys_ident_number];
	HELP		[phys_ident_number_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE DEFAULT_phys_ident_number ;

		{	0,	[phys_ident_number_PROFILE]		}		// (mand)
#ifndef NO_phys_ident_number_MANUFACURER
		,{	1,	[phys_ident_number_MANUFACURER]	}		// (opt)
#endif
#ifdef OPT_PHYS_IDENT_NUMBER_MANUFACTURER_2_0
		,{	2,	[phys_ident_number_MANUFACTURER_2_0]	}	// (opt)
#endif
#ifdef OPT_PHYS_IDENT_NUMBER_MULTIVARIABLE
		,{	3,	[phys_ident_number_MULTIVARIABLE] }		// (opt)
#endif
#ifdef PHYS_IDENT_SPECIFIC
		,PHYS_IDENT_SPECIFIC
#endif


	}
	HANDLING	READ & WRITE;
}


#ifndef NO_phys_hw_write_protection
VARIABLE phys_hw_write_protection
{
	LABEL		[phys_hw_write_protection];
	HELP		[phys_hw_write_protection_help];
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE 0 ;
		{	1,	[on]	},
		{	0,	[off]	}
	}
	HANDLING	READ;
}
#endif


/*---------------------------------------------------------------------*/
/*    Physical Block: Analyser specific parameters                 */
/*---------------------------------------------------------------------*/

VARIABLE phys_analysis_device_configuration 
{
	LABEL		[phys_analysis_device_configuration];
	HELP		[phys_analysis_device_configuration_help];
	CLASS		CONTAINED;
	TYPE		ASCII(32);
	HANDLING	READ;
}


VARIABLE phys_analysis_init_state
{
	LABEL		[phys_analysis_init_state];
	HELP		[phys_analysis_init_state_help];
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE	1;
		{	1,	[status_before_reset] 	},
		{	2,	[status_run] 				},
		{	3,	[status_standby]			},
		{	4,	[status_power_down]		},
		{	5,	[status_maintenance]		}
	}
	HANDLING	READ & WRITE;
}


VARIABLE phys_analysis_device_state
{
	LABEL		[phys_analysis_device_state];
	HELP		[phys_analysis_device_state_help];
	CLASS		CONTAINED & DYNAMIC;
	TYPE		ENUMERATED(1)
	{
		DEFAULT_VALUE	2;
		{	2,	[status_run], 				[phys_analysis_device_state_run_help] 				},
		{	3,	[status_standby], 		[phys_analysis_device_state_standby_help]			},
		{	4,	[status_power_down], 	[phys_analysis_device_state_power_down_help]		},
		{	5,	[status_maintenance], 	[phys_analysis_device_state_maintenance_help]	}
	}

	HANDLING	READ & WRITE;
}


VARIABLE phys_analysis_global_status
{
	LABEL		[phys_analysis_global_status];
	HELP		[phys_analysis_global_status_help];
	CLASS		CONTAINED & DYNAMIC;
	STYLE 	"MULTILINE 12 4";
	TYPE		BIT_ENUMERATED (2)
	{
		DEFAULT_VALUE    0x000F;
		{	0x0000,	[status_OK] 						},
		{	0x8000,	[status_failure]					},
		{	0x4000,	[status_maintenance_request]	},
		{	0x2000,	[status_function_check]			},
		{	0x1000,	[status_limits]					}
	}
	HANDLING  READ;
}


//--- PB 48 : MODULE_CONFIGURATION ----------------------------------------------------------------

VARIABLE phys_module_configuration_sw_ver
{
	LABEL		"SW Version";		
	CLASS		CONTAINED;
	TYPE		UNSIGNED_INTEGER (1)
	{
		DEFAULT_VALUE    0x00;
	}
	HANDLING	READ;
}


VARIABLE phys_module_configuration_module_at_addr_4
{
	LABEL		[phys_module_configuration_module_at_addr_4];		
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    0;
		MODULE_LIST
	}
	HANDLING	READ;
}


phys_module_configuration_module_at_addr_5	LIKE VARIABLE 	phys_module_configuration_module_at_addr_4
{
	REDEFINE LABEL		[phys_module_configuration_module_at_addr_5];		
}


phys_module_configuration_module_at_addr_6	LIKE VARIABLE 	phys_module_configuration_module_at_addr_4
{
	REDEFINE LABEL		[phys_module_configuration_module_at_addr_6];		
}


VARIABLE phys_module_configuration_ex
{
	LABEL		"Ex";		
	CLASS		CONTAINED;
	TYPE		ENUMERATED (1)
	{
		DEFAULT_VALUE    0x00;
		{	0x00,	"Nicht Ex"		},
		{	0x01,	"Ex"				}
	}
	HANDLING	READ;
}


VARIABLE phys_module_configuration_0_to_1
{
	LABEL		"";		
	CLASS		CONTAINED;
	TYPE		ASCII (2);
	HANDLING	READ;
}


VARIABLE phys_module_configuration_3_to_4
{
	LABEL		"";		
	CLASS		CONTAINED;
	TYPE		ASCII (2);
	HANDLING	READ;
}


VARIABLE phys_module_configuration_8_to_9
{
	LABEL		"";		
	CLASS		CONTAINED;
	TYPE		ASCII (2);
	HANDLING	READ;
}


VARIABLE phys_module_configuration_10
{
	LABEL		"";		
	CLASS		CONTAINED;
	TYPE		ASCII (1);
	HANDLING	READ;
}


VARIABLE phys_module_configuration_11_to_15
{
	LABEL		"";		
	CLASS		CONTAINED;
	TYPE		ASCII (5);
	HANDLING	READ;
}

/*---------------------------------------------------------------------*/
/*    Physical Block	Commands		 */
/*---------------------------------------------------------------------*/

COMMAND read_phys_blk
{
	BLOCK physical_block;
	INDEX 0;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_blk_reserve, phys_blk_object, phys_blk_parent_class, phys_blk_class,
			phys_blk_dd_reference, phys_blk_dd_rev, phys_blk_profile, phys_blk_profile_rev,
			phys_blk_execution_time, phys_blk_num_parameters, phys_blk_index_view_1,
			phys_blk_num_view_lists
		}
	}
}

COMMAND read_phys_st_rev
{
	BLOCK physical_block;
	INDEX 1;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_st_rev
		}
	}
}

COMMAND read_phys_tag_desc
{
	BLOCK physical_block;
	INDEX 2;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_tag_desc
		}
	}
}

COMMAND write_phys_tag_desc
{
	BLOCK physical_block;
	INDEX 2;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_tag_desc
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_strategy
{
	BLOCK physical_block;
	INDEX 3;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_strategy
		}
	}
}

COMMAND write_phys_strategy
{
	BLOCK physical_block;
	INDEX 3;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_strategy
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_alert_key
{
	BLOCK physical_block;
	INDEX 4;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_alert_key
		}
	}
}

COMMAND write_phys_alert_key
{
	BLOCK physical_block;
	INDEX 4;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_alert_key
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_target_mode
{
	BLOCK physical_block;
	INDEX 5;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_target_mode
		}
	}
}

COMMAND write_phys_target_mode
{
	BLOCK physical_block;
	INDEX 5;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
		 	phys_target_mode
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_mode
{
	BLOCK physical_block;
	INDEX 6;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			 phys_actual_mode, phys_permitted_mode, phys_normal_mode
		}
	}
}

COMMAND read_phys_alarm
{
	BLOCK physical_block;
	INDEX 7;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_current_state_alarm_sum, phys_unacknowledged_state_alarm_sum,
			phys_unreported_state_alarm_sum, phys_disabled_state_alarm_sum
		}
	}
}

COMMAND read_phys_software_rev
{
	BLOCK physical_block;
	INDEX 8;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_software_rev
		}
	}
}

COMMAND read_phys_hardware_rev
{
	BLOCK physical_block;
	INDEX 9;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_hardware_rev
		}
	}
}

COMMAND read_phys_device_man_id
{
	BLOCK physical_block;
	INDEX 10;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_man_id
		}
	}
}

COMMAND read_phys_device_id
{
	BLOCK physical_block;
	INDEX 11;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_id
		}
	}
}

COMMAND read_phys_device_ser_num
{
	BLOCK physical_block;
	INDEX 12;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_ser_num
		}
	}
}

COMMAND read_phys_diagnosis
{
	BLOCK physical_block;
	INDEX 13;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis
		}
	}
}

#ifndef NO_phys_diagnosis_extension
COMMAND read_phys_diagnosis_extension
{
	BLOCK physical_block;
	INDEX 14;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_extension
		}
	}
}
#endif

COMMAND read_phys_diagnosis_mask
{
	BLOCK physical_block;
	INDEX 15;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_mask
		}
	}
}

#ifndef NO_phys_diagnosis_extension_mask
COMMAND read_phys_diagnosis_extension_mask
{
	BLOCK physical_block;
	INDEX 16;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_diagnosis_extension_mask
		}
	}
}
#endif

COMMAND read_phys_device_certification
{
	BLOCK physical_block;
	INDEX 17;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_device_certification
		}
	}
}


#ifndef NO_phys_write_locking

COMMAND read_phys_write_locking
{
	BLOCK physical_block;
	INDEX 18;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_write_locking
		}
	}
}

COMMAND write_phys_write_locking
{
	BLOCK physical_block;
	INDEX 18;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_write_locking
		}
		REPLY
		{
		}
	}
}
#endif

COMMAND read_phys_factory_reset
{
	BLOCK physical_block;
	INDEX 19;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_factory_reset
		}
	}
}

COMMAND write_phys_factory_reset
{
	BLOCK physical_block;
	INDEX 19;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_factory_reset
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_descriptor
{
	BLOCK physical_block;
	INDEX 20;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_descriptor
		}
	}
}

COMMAND write_phys_descriptor
{
	BLOCK physical_block;
	INDEX 20;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_descriptor
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_message
{
	BLOCK physical_block;
	INDEX 21;
	OPERATION  READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_message
		}
	}
}

COMMAND write_phys_message
{
	BLOCK physical_block;
	INDEX 21;
	OPERATION  WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_message
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_install_date
{
	BLOCK physical_block;
	INDEX 22;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_install_date
		}
	}
}

COMMAND write_phys_install_date
{
	BLOCK physical_block;
	INDEX 22;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_install_date
		}
		REPLY
		{
		}
	}
}

#ifndef NO_phys_local_operation_enable
COMMAND read_phys_local_operation_enable
{
	BLOCK physical_block;
	INDEX 23;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_local_operation_enable
		}
	}
}

COMMAND write_phys_local_operation_enable
{
	BLOCK physical_block;
	INDEX 23;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_local_operation_enable
		}
		REPLY
		{
		}
	}
}
#endif


COMMAND read_phys_ident_number
{
	BLOCK physical_block;
	INDEX 24;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_ident_number
		}
	}
}

COMMAND write_phys_ident_number
{
	BLOCK physical_block;
	INDEX 24;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_ident_number
		}
		REPLY
		{
		}
	}
}




#ifndef NO_phys_hw_write_protection
COMMAND read_phys_hw_write_protection
{
	BLOCK physical_block;
	INDEX 25;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_hw_write_protection
		}
	}
}
#endif


/*---------------------------------------------------------------------*/
/*    Physical Block: specific parameters analyser							   */
/*---------------------------------------------------------------------*/

COMMAND read_phys_analysis_device_configuration
{
	BLOCK physical_block;
	INDEX 36;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_analysis_device_configuration
		}
	}
}

COMMAND read_phys_analysis_init_state
{
	BLOCK physical_block;
	INDEX 37;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_analysis_init_state
		}
	}
}

COMMAND write_phys_analysis_init_state
{
	BLOCK physical_block;
	INDEX 37;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_analysis_init_state
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_analysis_device_state
{
	BLOCK physical_block;
	INDEX 38;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_analysis_device_state
		}
	}
}

COMMAND write_phys_analysis_device_state
{
	BLOCK physical_block;
	INDEX 38;
	OPERATION WRITE;
	TRANSACTION
	{
		REQUEST
		{
			phys_analysis_device_state
		}
		REPLY
		{
		}
	}
}

COMMAND read_phys_analysis_global_status
{
	BLOCK physical_block;
	INDEX 39;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_analysis_global_status
		}
	}
}


//-------------------------------------------------------------------------------------------------
//    COMMAND (PB Parameter)
//-------------------------------------------------------------------------------------------------

//--- PB 48 : MODULE_CONFIGURATION ----------------------------------------------------------------

COMMAND read_phys_module_configuration
{
	BLOCK physical_block;
	INDEX 48;
	OPERATION READ;
	TRANSACTION
	{
		REQUEST
		{
		}
		REPLY
		{
			phys_module_configuration_0_to_1,
			phys_module_configuration_sw_ver,
			phys_module_configuration_3_to_4,
			phys_module_configuration_module_at_addr_4,
			phys_module_configuration_module_at_addr_5,
			phys_module_configuration_module_at_addr_6,
			phys_module_configuration_8_to_9,
			//phys_module_configuration_10			 			<0xFE>,
			phys_module_configuration_ex			 			<0x01>,
			phys_module_configuration_11_to_15
		}
	}
}






